jQuery(document).ready(function ($) {
	if (!('ontouchstart' in window) && (dtLocal.themeSettings.smoothScroll == "on" || dtLocal.themeSettings.smoothScroll == "on_parallax" && $(".stripe-parallax-bg").length > 0)) {
		$("body").css({"scroll-behavior" : "smooth"});
	}

});



/*
Plugin: jQuery Parallax
Version 1.1.3
Author: Ian Lunn
Twitter: @IanLunn
Author URL: http://www.ianlunn.co.uk/
Plugin URL: http://www.ianlunn.co.uk/plugins/jquery-parallax/

Dual licensed under the MIT and GPL licenses:
http://www.opensource.org/licenses/mit-license.php
http://www.gnu.org/licenses/gpl.html
*/

jQuery(document).ready(function ($) {
	var $window = $(window);
	var windowHeight = $window.height();

	$window.resize(function () {
		windowHeight = $window.height();
	});

	$.fn.parallax = function(xpos, speedFactor, outerHeight) {
		var $this = $(this);
		var getHeight;
		var firstTop;
		var paddingTop = 0;
		var fixTimeout;
		
		//get the starting position of each element to have parallax applied to it    
		$this.each(function(){
				firstTop = $this.offset().top;
		});

		if (outerHeight) {
			getHeight = function(jqo) {
				return jqo.outerHeight(true);
			};
		} else {
			getHeight = function(jqo) {
				return jqo.height();
			};
		}
			
		// setup defaults if arguments aren't specified
		if (arguments.length < 1 || xpos === null) xpos = "50%";
		if (arguments.length < 2 || speedFactor === null) speedFactor = 0.1;
		if (arguments.length < 3 || outerHeight === null) outerHeight = true;
		
		// function to be called whenever the window is scrolled or resized
		function update(){
			var pos = $window.scrollTop();        

			$this.each(function(){
				var $element = $(this);
				var top = $element.offset().top;
				var height = getHeight($element);

				// Check if totally above or totally below viewport
				if (top + height < pos || top > pos + windowHeight) {
					return;
				}

				$this.css('backgroundPosition', xpos + " " + Math.round((top - pos) * speedFactor) + "px");
			});
		}   

		$window.bind('scroll', update).resize(function() {
			update();
		}).bind("debouncedresize", function() {
			clearTimeout(fixTimeout);
			fixTimeout = setTimeout(function() {
				update();
			}, 20);
		});
		update();

		setTimeout(function() {
			if (!window.bgGlitchFixed && $.browser.webkit) {
				$window.scrollTop($window.scrollTop() + 1);
				window.bgGlitchFixed = true;
			}
		}, 20);

	};
});



/*!
 * Name    : Just Another Parallax [Jarallax]
 * Version : 1.1.0
 * Author  : _nK http://nkdev.info
 * GitHub  : https://github.com/nk-o/jarallax
 */


/*!
 * Name    : Just Another Parallax [Jarallax]
 * Version : 1.2.0
 * Author  : _nK http://nkdev.info
 * GitHub  : https://github.com/nk-o/jarallax
 */
(function(factory) {
    'use strict';
    if (typeof define === 'function' && define.amd) {
        define(['jquery'], factory);
    } else if (typeof exports !== 'undefined') {
        module.exports = factory(require('jquery'));
    } else {
        factory(jQuery);
    }
}(function($) {
    // Adapted from https://gist.github.com/paulirish/1579671
    if (!Date.now)
        Date.now = function() { return new Date().getTime(); };
    if(!window.requestAnimationFrame)
        (function() {
            'use strict';
            
            var vendors = ['webkit', 'moz'];
            for (var i = 0; i < vendors.length && !window.requestAnimationFrame; ++i) {
                var vp = vendors[i];
                window.requestAnimationFrame = window[vp+'RequestAnimationFrame'];
                window.cancelAnimationFrame = (window[vp+'CancelAnimationFrame']
                                           || window[vp+'CancelRequestAnimationFrame']);
            }
            if (/iP(ad|hone|od).*OS 6/.test(window.navigator.userAgent) // iOS6 is buggy
                || !window.requestAnimationFrame || !window.cancelAnimationFrame) {
                var lastTime = 0;
                window.requestAnimationFrame = function(callback) {
                    var now = Date.now();
                    var nextTime = Math.max(lastTime + 16, now);
                    return setTimeout(function() { callback(lastTime = nextTime); },
                                      nextTime - now);
                };
                window.cancelAnimationFrame = clearTimeout;
            }
        }());

    var supportTransform = (function() {
        var prefixes = 'transform WebkitTransform MozTransform OTransform msTransform'.split(' ');
        var div = document.createElement('div');
        for(var i = 0; i < prefixes.length; i++) {
            if(div && div.style[prefixes[i]] !== undefined) {
                return prefixes[i];
            }
        }
        return false;
    }());

    var support3dtransform = (function() {
        if (!window.getComputedStyle) {
            return false;
        }

        var el = document.createElement('p'), 
            has3d,
            transforms = {
                'webkitTransform':'-webkit-transform',
                'OTransform':'-o-transform',
                'msTransform':'-ms-transform',
                'MozTransform':'-moz-transform',
                'transform':'transform'
            };

        // Add it to the body to get the computed style.
        (document.body || document.documentElement).insertBefore(el, null);

        for (var t in transforms) {
            if (el.style[t] !== undefined) {
                el.style[t] = "translate3d(1px,1px,1px)";
                has3d = window.getComputedStyle(el).getPropertyValue(transforms[t]);
            }
        }

        (document.body || document.documentElement).removeChild(el);

        return (has3d !== undefined && has3d.length > 0 && has3d !== "none");
    }());
    
    var isAndroid = navigator.userAgent.toLowerCase().indexOf('android') > -1;
    var isOperaOld = !!window.opera;

    // list with all jarallax instances
    // need to render all in one scroll/resize event
    var jarallaxList = [];

    // Jarallax instance
    var Jarallax = (function() {
        var instanceID = 0;

        function Jarallax(item, userOptions) {
            var _this = this,
                dataOptions;

            _this.$item      = $(item);

            _this.defaults   = {
                speed             : 0.5,
                imgSrc            : null,
                imgWidth          : null,
                imgHeight         : null,
                enableTransform   : true,
                zIndex            : -100
            };
            dataOptions      = _this.$item.data('jarallax') || {};
            _this.options    = $.extend({}, _this.defaults, dataOptions, userOptions);

            // fix speed option [0.0, 1.0]
            _this.options.speed = Math.min(1, Math.max(-1, parseFloat(_this.options.speed)));

            _this.instanceID = instanceID++;

            _this.image      = {
                src        : _this.options.imgSrc || null,
                $container : null,
                $item      : null,
                width      : _this.options.imgWidth || null,
                height     : _this.options.imgHeight || null,
                // fix for Android devices
                // use <img> instead background image - more smoothly
                useImgTag  : isAndroid || isOperaOld
            }

            if(_this.initImg()) {
                _this.init();

                jarallaxList.push(_this);
            }
        }

        return Jarallax;
    }());

    Jarallax.prototype.initImg = function() {
        var _this = this;

        // get image src
        if(_this.image.src === null) {
            _this.image.src = _this.$item.css('background-image').replace(/^url\(['"]?/g,'').replace(/['"]?\)$/g,'');
        }
        if(!_this.image.src || _this.image.src === 'none') {
            return false;
        }
        return true;
    }

    Jarallax.prototype.init = function() {

        if($(".header-side-line").length > 0 ){
            var sideHW = $(".side-header-v-stroke").width();
        }else if(!$("body").hasClass("sticky-header") && !$("body").hasClass("overlay-navigation") && $(".side-header").length > 0){
            var sideHW = $(".side-header").width();
        }else{
            var sideHW = 0;
        }
        //if($(".move-header-animation").length > 0){
            var $position = "absolute";
        // }else{
        //     var $position = "fixed";
        // }
       
        var _this = this;
        if(_this.$item[0].classList[0] == 'stripe'){
            var stripePadL  = 2000 + sideHW;
        }else{
            var stripePadL  = $(".content").offset().left + 22;
        }

        var pageW = $("#page").width(),
            pageOfL  = stripePadL - $(".content").offset().left - 22,
             containerStylesStripe = {
                position         : 'absolute',
                top              : 0,
                left             : pageOfL,
                // 'marginLeft'     : pageOfL,

                width            : pageW,
                height           : '100%',
                overflow         : 'hidden',
                'pointer-events' : 'none',
                'transition'     : 'transform linear -1ms, -webkit-transform linear -1ms'
            },
            containerStyles = {
                position         : 'absolute',
                top              : 0,
                left             : 0,
                width            : '100%',
                height           : '100%',
                overflow         : 'hidden',
                'pointer-events' : 'none',
                'transition'     : 'transform linear -1ms, -webkit-transform linear -1ms'
            },
            imageStyles = {
                position              : $position,
                left             : 50 + '%',
            };

        // container for parallax image
        _this.image.$container = $('<div>')
            .css(containerStyles)
            .css({
                visibility : 'hidden',
                'z-index'  : _this.options.zIndex
            })
            .attr('id', 'jarallax-container-' + _this.instanceID)
            .prependTo(_this.$item);

        // use img tag
        if(_this.image.useImgTag && supportTransform) {
            _this.image.$item = $('<img>').attr('src', _this.image.src);
            imageStyles = $.extend({
                'max-width' : 'none'
            }, containerStyles, imageStyles)
        }

        // use div with background image
        else {
            _this.image.$item = $('<div>');
            imageStyles = $.extend({
                'background-position' : 'inherit',
                'background-repeat'   : 'inherit',
                'background-image'    : 'url("' + _this.image.src + '")'
            }, containerStyles, imageStyles)
        }

        // parallax image
        _this.image.$item.css(imageStyles)
            .prependTo(_this.image.$container);

        // cover image if width and height is ready
        function initAfterReady() {
            _this.coverImage();
            _this.clipContainer();
            _this.onScroll(true);

            // save default user styles
            _this.$item.data('jarallax-original-styles', _this.$item.attr('style'));

            // timeout to fix IE blinking
            setTimeout(function() {
                // remove default user background
                _this.$item.css({
                    'background-image'      : 'none',
                    'background-attachment' : 'scroll',
                    'background-size'       : 'auto'
                });
            }, 0);
        }

        if(_this.image.width && _this.image.height) {
            // init if width and height already exists
            initAfterReady();
        } else {
            // load image and get width and height
            _this.getImageSize(_this.image.src, function(width, height) {
                _this.image.width  = width;
                _this.image.height = height;
                initAfterReady();
            });
        }
    };

    Jarallax.prototype.destroy = function() {
        var _this = this;

        // remove from instances list
        for(var k = 0, len = jarallaxList.length; k < len; k++) {
            if(jarallaxList[k].instanceID === _this.instanceID) {
                jarallaxList.splice(k, 1);
                break;
            }
        }

        // remove additional styles for clip
        $('head #jarallax-clip-' + _this.instanceID).remove();

        _this.$item.attr('style', _this.$item.data('jarallax-original-styles'));
        _this.$item.removeData('jarallax-original-styles');

        _this.image.$container.remove();

        delete _this.$item[0].jarallax;
    }

    // round to 2 decimals
    Jarallax.prototype.round = function(num) {
        return Math.floor(num * 100) / 100;
    }

    Jarallax.prototype.getImageSize = function(src, callback) {
        if(!src || !callback) {
            return false;
        }

        var tempImg = new Image();
        tempImg.onload = function() {
            callback(tempImg.width, tempImg.height)
        }
        tempImg.src = src;
    }

    // it will remove some image overlapping
    // overlapping occur due to an image position fixed inside absolute possition element (webkit based browsers works without any fix)
    Jarallax.prototype.clipContainer = function() {
        var _this  = this,
            width  = _this.image.$container.outerWidth(true),
            height = _this.image.$container.outerHeight(true);

        var $styles = $('head #jarallax-clip-' + _this.instanceID);
        if(!$styles.length) {
            $('head').append('<style type="text/css" id="jarallax-clip-' + _this.instanceID + '"></style>');
            $styles = $('head #jarallax-clip-' + _this.instanceID);
        }

        var css = [
            '#jarallax-container-' + _this.instanceID + ' {',
            '   clip: rect(0px ' + width + 'px ' + height + 'px 0);',
            '   clip: rect(0px, ' + width + 'px, ' + height + 'px, 0);',
            '}'
        ].join('\n');

        // add clip styles inline (this method need for support IE8 and less browsers)
        if ($styles[0].styleSheet) {
            $styles[0].styleSheet.cssText = css;
        } else {
            $styles.html(css);
        }
    }

    Jarallax.prototype.coverImage = function() {
        var _this = this;

        if(!_this.image.width || !_this.image.height) {
            return;
        }
        if(!$("body").hasClass("transparent")){
            var headerH = $(".masthead:not(.side-header):not(.side-header-v-stroke)").height() + $("#wpadminbar").height();
        }else{
            var headerH = 0 + $("#wpadminbar").height();
        }
        if($(".side-header-v-stroke").length > 0){
            var headerW = $(".side-header-v-stroke").width();
        }else {

            var headerW = 0;
        }
        console.log(headerH + "headerH")

        var contW = _this.image.$container.outerWidth(true),
            contH = _this.image.$container.outerHeight(true),
            wndW  = $(window).outerWidth(true),
            whdH  = $(window).outerHeight(true),
            imgW  = _this.image.width,
            imgH  = _this.image.height,
            resultWidth, resultHeight;
        if(_this.$item[0].classList[0] == 'stripe'){
              var contW = _this.image.$container.outerWidth(true) - 4000
        }

        var css = {
            width  : Math.max(wndW, contW) * 1,
            height : Math.max(whdH, contH) * Math.max(_this.options.speed, 1) /*+ headerH*/
        };
        //  if(_this.image.$item.css("position") == "absolute"){
        // 	 var css = {
	       //      width  : Math.max(wndW, contW) * 1,
	       //      height : Math.max(whdH, contH) * Math.max(_this.options.speed, 1) * 1.5
	       //  };
        // }

        // cover by width
        if(css.width / css.height > imgW / imgH) {
            resultWidth = css.width;
            resultHeight = css.width * imgH / imgW;
        }

        // cover by height
        else {
            resultWidth = css.height * imgW / imgH;
            resultHeight = css.height;
        }
        
        // for img tag
        if(_this.image.useImgTag && supportTransform) {
            css.width = _this.round(resultWidth);
            css.height = _this.round(resultHeight);
            css.marginLeft = _this.round(- (resultWidth - contW) / 2);
            css.marginTop = _this.round(- (resultHeight - contH) / 2);
        }

        // for div with background image
        else {
            css.backgroundSize = _this.round(resultWidth) + 'px ' + _this.round(resultHeight) + 'px';
        }

        // apply to item
        _this.image.$item.css(css);
    };

    Jarallax.prototype.onScroll = function(force) {
        var _this = this;

        if(!_this.image.width || !_this.image.height) {
            return;
        }

        var scrollTop     = $(window).scrollTop(),
            scrollLeft    = $(window).scrollLeft(),
            wndWidth      = $(window).width(),
            wndHeight     = $(window).height(),
            // starting position of each element to have parallax applied to it
            sectionTop    = _this.$item.offset().top,
            sectionLeft    = _this.$item.offset().left,
            sectionHeight = _this.$item.outerHeight(true),
            css           = {
                visibility         : 'visible',
                backgroundPosition : 'inherit'
            };

        // if(_this.image.$item.css("position") == "absolute"){
        //      var sectionTop    = _this.$item.position().top - $(".side-header-h-stroke").height();
        // }

        // Check if totally above or totally below viewport
        var check = force ? false
                          : sectionTop + sectionHeight < scrollTop || sectionTop > scrollTop + wndHeight;
        if (check) {
            return;
        }

        // calculate parallax
        var positionY = - (scrollTop - sectionTop) * _this.options.speed;
        var positionX = - (scrollLeft - sectionLeft) * _this.options.speed;
            positionY = _this.round(positionY);
            positionX = _this.round(positionX);
            console.log(sectionTop + "top offset", _this.options.speed + " speed", _this.image.$item.css("position"))
       

        if(supportTransform && _this.options.enableTransform) {
            css.transform = 'translateY(' + positionY + 'px) translateX(' + positionX + 'px)';
            if(support3dtransform) {
                css.transform = 'translate3d(' + -50 + '%, ' + positionY + 'px, 0)';
            }
        } else {
            css.backgroundPosition = positionX + 'px ' + positionY + 'px';
        }

        _this.image.$item.css(css);
    };

    // init events
    (function() {
        $(window).on('scroll.jarallax', function() {
            window.requestAnimationFrame(function() {
                for(var k = 0, len = jarallaxList.length; k < len; k++) {
                    jarallaxList[k].onScroll();
                }
            });
        });

        var timeout;
        $(window).on('resize.jarallax orientationchange.jarallax load.jarallax', function() {
            clearTimeout(timeout);
            timeout = setTimeout(function() {
                window.requestAnimationFrame(function() {
                    for(var k = 0, len = jarallaxList.length; k < len; k++) {
                        var _this = jarallaxList[k];
                        _this.coverImage();
                        _this.clipContainer();
                        _this.onScroll();
                    }
                });
            }, 100);
        });
    }());

    var oldJarallax = $.fn.jarallax;

    $.fn.jarallax = function() {
        var items = this,
            options = arguments[0],
            args = Array.prototype.slice.call(arguments, 1),
            len = items.length,
            k = 0,
            ret;

        for (k; k < len; k++) {
            if (typeof options === 'object' || typeof options === 'undefined') {
                if(!items[k].jarallax) {
                    items[k].jarallax = new Jarallax(items[k], options);
                }
            }
            else {
                ret = items[k].jarallax ? items[k].jarallax[options].apply(items[k].jarallax, args) : undefined;
            }
            if (typeof ret !== 'undefined') {
                return ret;
            }
        }

        return this;
    };

    // no conflict
    $.fn.jarallax.noConflict = function () {
        $.fn.jarallax = oldJarallax;
        return this;
    };

    // data-jarallax initialization
    $(document).on('ready.data-jarallax', function () {
        $('[data-jarallax]').jarallax();
    });
}));
