/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2018-09-11 05:03:28 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `myevntl_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_cptch_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(100) NOT NULL,
  `package_id` int(11) NOT NULL,
  `number` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8;

CREATE TABLE `myevntl_cptch_packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(100) NOT NULL,
  `folder` char(100) NOT NULL,
  `settings` longtext NOT NULL,
  `user_settings` longtext NOT NULL,
  `add_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

CREATE TABLE `myevntl_cptch_whitelist` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ip` char(31) NOT NULL,
  `ip_from_int` bigint(20) DEFAULT NULL,
  `ip_to_int` bigint(20) DEFAULT NULL,
  `add_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `myevntl_datalist` (
  `url` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `full_content` smallint(6) NOT NULL,
  PRIMARY KEY (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `myevntl_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `myevntl_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=55583 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3264 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=1614 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_redirection_404` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `agent` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referrer` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `url` (`url`(191)),
  KEY `referrer` (`referrer`(191)),
  KEY `ip` (`ip`)
) ENGINE=MyISAM AUTO_INCREMENT=4092 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_redirection_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tracking` int(11) NOT NULL DEFAULT '1',
  `module_id` int(11) unsigned NOT NULL DEFAULT '0',
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `position` int(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `module_id` (`module_id`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_redirection_items` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `regex` int(11) unsigned NOT NULL DEFAULT '0',
  `position` int(11) unsigned NOT NULL DEFAULT '0',
  `last_count` int(10) unsigned NOT NULL DEFAULT '0',
  `last_access` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `group_id` int(11) NOT NULL DEFAULT '0',
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `action_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_code` int(11) unsigned NOT NULL,
  `action_data` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `match_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `status` (`status`),
  KEY `regex` (`regex`),
  KEY `group_idpos` (`group_id`,`position`),
  KEY `group` (`group_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_redirection_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `url` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sent_to` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `agent` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referrer` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `redirection_id` int(11) unsigned DEFAULT NULL,
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `module_id` int(11) unsigned NOT NULL,
  `group_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `created` (`created`),
  KEY `redirection_id` (`redirection_id`),
  KEY `ip` (`ip`),
  KEY `group_id` (`group_id`),
  KEY `module_id` (`module_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `params` longtext NOT NULL,
  `advanced` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=112 DEFAULT CHARSET=latin1;

CREATE TABLE `myevntl_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `myevntl_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `myevntl_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `myevntl_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `myevntl_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `myevntl_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `myevntl_vfb_pro_entries` (
  `entries_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT '1',
  `data` longtext NOT NULL,
  `subject` text,
  `sender_name` varchar(255) DEFAULT NULL,
  `sender_email` varchar(255) DEFAULT NULL,
  `emails_to` text,
  `date_submitted` datetime DEFAULT NULL,
  `ip_address` varchar(25) DEFAULT NULL,
  `notes` text,
  `akismet` text,
  `entry_approved` varchar(20) DEFAULT '1',
  PRIMARY KEY (`entries_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

CREATE TABLE `myevntl_vfb_pro_fields` (
  `field_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `field_key` varchar(255) NOT NULL,
  `field_type` varchar(25) NOT NULL,
  `field_options` text,
  `field_options_other` varchar(255) DEFAULT NULL,
  `field_description` text,
  `field_name` text NOT NULL,
  `field_sequence` bigint(20) DEFAULT '0',
  `field_parent` bigint(20) DEFAULT '0',
  `field_validation` varchar(25) DEFAULT NULL,
  `field_required` varchar(25) DEFAULT NULL,
  `field_size` varchar(25) DEFAULT 'medium',
  `field_css` varchar(255) DEFAULT NULL,
  `field_layout` varchar(255) DEFAULT NULL,
  `field_default` text,
  `field_rule_setting` tinyint(1) DEFAULT NULL,
  `field_rule` longtext,
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM AUTO_INCREMENT=299 DEFAULT CHARSET=utf8;

CREATE TABLE `myevntl_vfb_pro_forms` (
  `form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_key` tinytext NOT NULL,
  `form_title` text NOT NULL,
  `form_email_subject` text,
  `form_email_to` text,
  `form_email_from` varchar(255) DEFAULT NULL,
  `form_email_from_name` varchar(255) DEFAULT NULL,
  `form_email_from_override` varchar(255) DEFAULT NULL,
  `form_email_from_name_override` varchar(255) DEFAULT NULL,
  `form_email_rule_setting` tinyint(1) DEFAULT NULL,
  `form_email_rule` longtext,
  `form_success_type` varchar(25) DEFAULT 'text',
  `form_success_message` text,
  `form_notification_setting` varchar(25) DEFAULT NULL,
  `form_notification_email_name` varchar(255) DEFAULT NULL,
  `form_notification_email_from` varchar(255) DEFAULT NULL,
  `form_notification_email` varchar(25) DEFAULT NULL,
  `form_notification_subject` varchar(255) DEFAULT NULL,
  `form_notification_message` text,
  `form_notification_entry` varchar(25) DEFAULT NULL,
  `form_email_design` text,
  `form_paypal_setting` varchar(25) DEFAULT NULL,
  `form_paypal_email` varchar(255) DEFAULT NULL,
  `form_paypal_currency` varchar(25) DEFAULT 'USD',
  `form_paypal_shipping` varchar(255) DEFAULT NULL,
  `form_paypal_tax` varchar(255) DEFAULT NULL,
  `form_paypal_field_price` text,
  `form_paypal_item_name` varchar(255) DEFAULT NULL,
  `form_label_alignment` varchar(25) DEFAULT NULL,
  `form_verification` tinyint(1) DEFAULT '1',
  `form_entries_allowed` varchar(25) DEFAULT NULL,
  `form_entries_schedule` varchar(100) DEFAULT NULL,
  `form_unique_entry` tinyint(1) DEFAULT '0',
  `form_status` varchar(20) DEFAULT 'publish',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

CREATE TABLE `myevntl_wplc_chat_msgs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_sess_id` int(11) NOT NULL,
  `msgfrom` varchar(150) NOT NULL,
  `msg` longtext NOT NULL,
  `timestamp` datetime NOT NULL,
  `status` int(3) NOT NULL,
  `originates` int(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=215 DEFAULT CHARSET=utf8;

CREATE TABLE `myevntl_wplc_chat_sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `name` varchar(700) NOT NULL,
  `email` varchar(700) NOT NULL,
  `ip` varchar(700) NOT NULL,
  `status` int(11) NOT NULL,
  `session` varchar(100) NOT NULL,
  `url` varchar(700) NOT NULL,
  `last_active_timestamp` datetime NOT NULL,
  `other` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2449 DEFAULT CHARSET=utf8;

CREATE TABLE `myevntl_wplc_offline_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `name` varchar(700) NOT NULL,
  `email` varchar(700) NOT NULL,
  `message` varchar(700) NOT NULL,
  `ip` varchar(700) NOT NULL,
  `user_agent` varchar(700) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: myevntl_cptch_images */
INSERT INTO `myevntl_cptch_images` VALUES("1", "0.png", "1", "0");
INSERT INTO `myevntl_cptch_images` VALUES("2", "1.png", "1", "1");
INSERT INTO `myevntl_cptch_images` VALUES("3", "2.png", "1", "2");
INSERT INTO `myevntl_cptch_images` VALUES("4", "3.png", "1", "3");
INSERT INTO `myevntl_cptch_images` VALUES("5", "4.png", "1", "4");
INSERT INTO `myevntl_cptch_images` VALUES("6", "5.png", "1", "5");
INSERT INTO `myevntl_cptch_images` VALUES("7", "6.png", "1", "6");
INSERT INTO `myevntl_cptch_images` VALUES("8", "7.png", "1", "7");
INSERT INTO `myevntl_cptch_images` VALUES("9", "8.png", "1", "8");
INSERT INTO `myevntl_cptch_images` VALUES("10", "9.png", "1", "9");
INSERT INTO `myevntl_cptch_images` VALUES("11", "0.png", "2", "0");
INSERT INTO `myevntl_cptch_images` VALUES("12", "1.png", "2", "1");
INSERT INTO `myevntl_cptch_images` VALUES("13", "2.png", "2", "2");
INSERT INTO `myevntl_cptch_images` VALUES("14", "3.png", "2", "3");
INSERT INTO `myevntl_cptch_images` VALUES("15", "4.png", "2", "4");
INSERT INTO `myevntl_cptch_images` VALUES("16", "5.png", "2", "5");
INSERT INTO `myevntl_cptch_images` VALUES("17", "6.png", "2", "6");
INSERT INTO `myevntl_cptch_images` VALUES("18", "7.png", "2", "7");
INSERT INTO `myevntl_cptch_images` VALUES("19", "8.png", "2", "8");
INSERT INTO `myevntl_cptch_images` VALUES("20", "9.png", "2", "9");
INSERT INTO `myevntl_cptch_images` VALUES("21", "0.png", "3", "0");
INSERT INTO `myevntl_cptch_images` VALUES("22", "1.png", "3", "1");
INSERT INTO `myevntl_cptch_images` VALUES("23", "2.png", "3", "2");
INSERT INTO `myevntl_cptch_images` VALUES("24", "3.png", "3", "3");
INSERT INTO `myevntl_cptch_images` VALUES("25", "4.png", "3", "4");
INSERT INTO `myevntl_cptch_images` VALUES("26", "5.png", "3", "5");
INSERT INTO `myevntl_cptch_images` VALUES("27", "6.png", "3", "6");
INSERT INTO `myevntl_cptch_images` VALUES("28", "7.png", "3", "7");
INSERT INTO `myevntl_cptch_images` VALUES("29", "8.png", "3", "8");
INSERT INTO `myevntl_cptch_images` VALUES("30", "9.png", "3", "9");
INSERT INTO `myevntl_cptch_images` VALUES("31", "0.png", "4", "0");
INSERT INTO `myevntl_cptch_images` VALUES("32", "1.png", "4", "1");
INSERT INTO `myevntl_cptch_images` VALUES("33", "2.png", "4", "2");
INSERT INTO `myevntl_cptch_images` VALUES("34", "3.png", "4", "3");
INSERT INTO `myevntl_cptch_images` VALUES("35", "4.png", "4", "4");
INSERT INTO `myevntl_cptch_images` VALUES("36", "5.png", "4", "5");
INSERT INTO `myevntl_cptch_images` VALUES("37", "6.png", "4", "6");
INSERT INTO `myevntl_cptch_images` VALUES("38", "7.png", "4", "7");
INSERT INTO `myevntl_cptch_images` VALUES("39", "8.png", "4", "8");
INSERT INTO `myevntl_cptch_images` VALUES("40", "9.png", "4", "9");
INSERT INTO `myevntl_cptch_images` VALUES("41", "1.png", "5", "1");
INSERT INTO `myevntl_cptch_images` VALUES("42", "2.png", "5", "2");
INSERT INTO `myevntl_cptch_images` VALUES("43", "3.png", "5", "3");
INSERT INTO `myevntl_cptch_images` VALUES("44", "4.png", "5", "4");
INSERT INTO `myevntl_cptch_images` VALUES("45", "5.png", "5", "5");
INSERT INTO `myevntl_cptch_images` VALUES("46", "6.png", "5", "6");
INSERT INTO `myevntl_cptch_images` VALUES("47", "7.png", "5", "7");
INSERT INTO `myevntl_cptch_images` VALUES("48", "8.png", "5", "8");
INSERT INTO `myevntl_cptch_images` VALUES("49", "9.png", "5", "9");
INSERT INTO `myevntl_cptch_images` VALUES("50", "1.png", "6", "1");
INSERT INTO `myevntl_cptch_images` VALUES("51", "2.png", "6", "2");
INSERT INTO `myevntl_cptch_images` VALUES("52", "3.png", "6", "3");
INSERT INTO `myevntl_cptch_images` VALUES("53", "4.png", "6", "4");
INSERT INTO `myevntl_cptch_images` VALUES("54", "5.png", "6", "5");
INSERT INTO `myevntl_cptch_images` VALUES("55", "6.png", "6", "6");
INSERT INTO `myevntl_cptch_images` VALUES("56", "7.png", "6", "7");
INSERT INTO `myevntl_cptch_images` VALUES("57", "8.png", "6", "8");
INSERT INTO `myevntl_cptch_images` VALUES("58", "9.png", "6", "9");
INSERT INTO `myevntl_cptch_images` VALUES("59", "1.png", "7", "1");
INSERT INTO `myevntl_cptch_images` VALUES("60", "2.png", "7", "2");
INSERT INTO `myevntl_cptch_images` VALUES("61", "3.png", "7", "3");
INSERT INTO `myevntl_cptch_images` VALUES("62", "4.png", "7", "4");
INSERT INTO `myevntl_cptch_images` VALUES("63", "5.png", "7", "5");
INSERT INTO `myevntl_cptch_images` VALUES("64", "6.png", "7", "6");
INSERT INTO `myevntl_cptch_images` VALUES("65", "7.png", "7", "7");
INSERT INTO `myevntl_cptch_images` VALUES("66", "8.png", "7", "8");
INSERT INTO `myevntl_cptch_images` VALUES("67", "9.png", "7", "9");
INSERT INTO `myevntl_cptch_images` VALUES("68", "1.png", "8", "1");
INSERT INTO `myevntl_cptch_images` VALUES("69", "2.png", "8", "2");
INSERT INTO `myevntl_cptch_images` VALUES("70", "3.png", "8", "3");
INSERT INTO `myevntl_cptch_images` VALUES("71", "4.png", "8", "4");
INSERT INTO `myevntl_cptch_images` VALUES("72", "5.png", "8", "5");
INSERT INTO `myevntl_cptch_images` VALUES("73", "6.png", "8", "6");
INSERT INTO `myevntl_cptch_images` VALUES("74", "7.png", "8", "7");
INSERT INTO `myevntl_cptch_images` VALUES("75", "8.png", "8", "8");
INSERT INTO `myevntl_cptch_images` VALUES("76", "9.png", "8", "9");
INSERT INTO `myevntl_cptch_images` VALUES("77", "1.png", "9", "1");
INSERT INTO `myevntl_cptch_images` VALUES("78", "2.png", "9", "2");
INSERT INTO `myevntl_cptch_images` VALUES("79", "3.png", "9", "3");
INSERT INTO `myevntl_cptch_images` VALUES("80", "4.png", "9", "4");
INSERT INTO `myevntl_cptch_images` VALUES("81", "5.png", "9", "5");
INSERT INTO `myevntl_cptch_images` VALUES("82", "6.png", "9", "6");
INSERT INTO `myevntl_cptch_images` VALUES("83", "7.png", "9", "7");
INSERT INTO `myevntl_cptch_images` VALUES("84", "8.png", "9", "8");
INSERT INTO `myevntl_cptch_images` VALUES("85", "9.png", "9", "9");
INSERT INTO `myevntl_cptch_images` VALUES("86", "1.png", "10", "1");
INSERT INTO `myevntl_cptch_images` VALUES("87", "2.png", "10", "2");
INSERT INTO `myevntl_cptch_images` VALUES("88", "3.png", "10", "3");
INSERT INTO `myevntl_cptch_images` VALUES("89", "4.png", "10", "4");
INSERT INTO `myevntl_cptch_images` VALUES("90", "5.png", "10", "5");
INSERT INTO `myevntl_cptch_images` VALUES("91", "6.png", "10", "6");
INSERT INTO `myevntl_cptch_images` VALUES("92", "7.png", "10", "7");
INSERT INTO `myevntl_cptch_images` VALUES("93", "8.png", "10", "8");
INSERT INTO `myevntl_cptch_images` VALUES("94", "9.png", "10", "9");
INSERT INTO `myevntl_cptch_images` VALUES("95", "1.png", "11", "1");
INSERT INTO `myevntl_cptch_images` VALUES("96", "2.png", "11", "2");
INSERT INTO `myevntl_cptch_images` VALUES("97", "3.png", "11", "3");
INSERT INTO `myevntl_cptch_images` VALUES("98", "4.png", "11", "4");
INSERT INTO `myevntl_cptch_images` VALUES("99", "5.png", "11", "5");
INSERT INTO `myevntl_cptch_images` VALUES("100", "6.png", "11", "6");
INSERT INTO `myevntl_cptch_images` VALUES("101", "7.png", "11", "7");
INSERT INTO `myevntl_cptch_images` VALUES("102", "8.png", "11", "8");
INSERT INTO `myevntl_cptch_images` VALUES("103", "9.png", "11", "9");
INSERT INTO `myevntl_cptch_images` VALUES("104", "1.png", "12", "1");
INSERT INTO `myevntl_cptch_images` VALUES("105", "2.png", "12", "2");
INSERT INTO `myevntl_cptch_images` VALUES("106", "3.png", "12", "3");
INSERT INTO `myevntl_cptch_images` VALUES("107", "4.png", "12", "4");
INSERT INTO `myevntl_cptch_images` VALUES("108", "5.png", "12", "5");
INSERT INTO `myevntl_cptch_images` VALUES("109", "6.png", "12", "6");
INSERT INTO `myevntl_cptch_images` VALUES("110", "7.png", "12", "7");
INSERT INTO `myevntl_cptch_images` VALUES("111", "8.png", "12", "8");
INSERT INTO `myevntl_cptch_images` VALUES("112", "9.png", "12", "9");

/* INSERT TABLE DATA: myevntl_cptch_packages */
INSERT INTO `myevntl_cptch_packages` VALUES("1", "Arabic ( black numbers - transparent background )", "arabic_bt", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("2", "Arabic ( black numbers - white background )", "arabic_bw", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("3", "Arabic ( white numbers - transparent background )", "arabic_wt", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("4", "Arabic ( white numbers - black background )", "arabic_wb", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("5", "Dots ( black dots - transparent background )", "dots_bt", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("6", "Dots ( black dots - white background )", "dots_bw", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("7", "Dots ( white dots - black background )", "dots_wb", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("8", "Dots ( white dots - transparent background )", "dots_wt", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("9", "Roman ( black numbers - transparent background )", "roman_bt", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("10", "Roman ( black numbers - white background )", "roman_bw", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("11", "Roman ( white numbers - black background )", "roman_wb", "", "", "2017-05-09 04:28:30");
INSERT INTO `myevntl_cptch_packages` VALUES("12", "Roman ( white numbers - transparent background )", "roman_wt", "", "", "2017-05-09 04:28:30");

/* INSERT TABLE DATA: myevntl_duplicator_packages */
INSERT INTO `myevntl_duplicator_packages` VALUES("2", "20180911_myeventologyitfctxtravelogue", "fc8aa63f688fe2472998180911050303", "20", "2018-09-11 05:03:28", "My Eventology Admin", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-09-11 05:03:03\";s:7:\"Version\";s:5:\"1.2.6\";s:9:\"VersionWP\";s:5:\"4.7.4\";s:9:\"VersionDB\";s:6:\"5.7.23\";s:10:\"VersionPHP\";s:6:\"5.6.37\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:37:\"20180911_myeventologyitfctxtravelogue\";s:4:\"Hash\";s:32:\"fc8aa63f688fe2472998180911050303\";s:8:\"NameHash\";s:70:\"20180911_myeventologyitfctxtravelogue_fc8aa63f688fe2472998180911050303\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:57:\"/home/travel/public_html/myeventology.ph/wp-snapshots/tmp\";s:8:\"StoreURL\";s:40:\"http://www.myeventology.ph/wp-snapshots/\";s:8:\"ScanFile\";s:80:\"20180911_myeventologyitfctxtravelogue_fc8aa63f688fe2472998180911050303_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:19:\"My Eventology Admin\";s:7:\"Archive\";O:11:\"DUP_Archive\":13:{s:10:\"FilterDirs\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:4:\"File\";s:82:\"20180911_myeventologyitfctxtravelogue_fc8aa63f688fe2472998180911050303_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:40:\"/home/travel/public_html/myeventology.ph\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":6:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-09-11 05:03:03\";s:7:\"Version\";s:5:\"1.2.6\";s:9:\"VersionWP\";s:5:\"4.7.4\";s:9:\"VersionDB\";s:6:\"5.7.23\";s:10:\"VersionPHP\";s:6:\"5.6.37\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20180911_myeventologyitfctxtravelogue\";s:4:\"Hash\";s:32:\"fc8aa63f688fe2472998180911050303\";s:8:\"NameHash\";s:70:\"20180911_myeventologyitfctxtravelogue_fc8aa63f688fe2472998180911050303\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:57:\"/home/travel/public_html/myeventology.ph/wp-snapshots/tmp\";s:8:\"StoreURL\";s:40:\"http://www.myeventology.ph/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":12:{s:4:\"File\";s:84:\"20180911_myeventologyitfctxtravelogue_fc8aa63f688fe2472998180911050303_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSSLAdmin\";i:0;s:12:\"OptsSSLLogin\";i:0;s:11:\"OptsCacheWP\";i:0;s:13:\"OptsCachePath\";i:0;s:10:\"OptsURLNew\";s:0:\"\";s:10:\"\0*\0Package\";r:52;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:83:\"20180911_myeventologyitfctxtravelogue_fc8aa63f688fe2472998180911050303_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}}s:9:\"Installer\";r:74;s:8:\"Database\";r:87;}");

/* INSERT TABLE DATA: myevntl_options */
INSERT INTO `myevntl_options` VALUES("1", "siteurl", "http://www.myeventology.ph", "yes");
INSERT INTO `myevntl_options` VALUES("2", "home", "http://www.myeventology.ph", "yes");
INSERT INTO `myevntl_options` VALUES("3", "blogname", "MyEventology - ITF, CTX, Travelogue", "yes");
INSERT INTO `myevntl_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `myevntl_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `myevntl_options` VALUES("6", "admin_email", "info@cebuwebconcepts.com", "yes");
INSERT INTO `myevntl_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `myevntl_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `myevntl_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `myevntl_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `myevntl_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `myevntl_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `myevntl_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `myevntl_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `myevntl_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `myevntl_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `myevntl_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `myevntl_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `myevntl_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `myevntl_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `myevntl_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `myevntl_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `myevntl_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `myevntl_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `myevntl_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `myevntl_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `myevntl_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `myevntl_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `myevntl_options` VALUES("29", "rewrite_rules", "a:105:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `myevntl_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `myevntl_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `myevntl_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `myevntl_options` VALUES("33", "active_plugins", "a:17:{i:0;s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:19:\"captcha/captcha.php\";i:3;s:59:\"change-default-login-logo-url-and-title/change-logo-url.php\";i:4;s:36:\"contact-form-7/wp-contact-form-7.php\";i:5;s:29:\"dt-the7-core/dt-the7-core.php\";i:6;s:33:\"duplicate-post/duplicate-post.php\";i:7;s:25:\"duplicator/duplicator.php\";i:8;s:59:\"editor-menu-and-widget-access/editor-menu-widget-access.php\";i:9;s:45:\"hide-plugin-updates-notifications/wphdpuw.php\";i:10;s:27:\"js_composer/js_composer.php\";i:11;s:27:\"redirection/redirection.php\";i:12;s:35:\"rename-wp-login/rename-wp-login.php\";i:13;s:23:\"revslider/revslider.php\";i:14;s:44:\"stops-core-theme-and-plugin-updates/main.php\";i:15;s:51:\"visual-form-builder-pro/visual-form-builder-pro.php\";i:16;s:45:\"wp-live-chat-support/wp-live-chat-support.php\";}", "yes");
INSERT INTO `myevntl_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `myevntl_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `myevntl_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `myevntl_options` VALUES("37", "gmt_offset", "8", "yes");
INSERT INTO `myevntl_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `myevntl_options` VALUES("39", "recently_edited", "a:3:{i:0;s:87:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology-child/style.css\";i:1;s:81:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO `myevntl_options` VALUES("40", "template", "myeventology", "yes");
INSERT INTO `myevntl_options` VALUES("41", "stylesheet", "myeventology-child", "yes");
INSERT INTO `myevntl_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `myevntl_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `myevntl_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `myevntl_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `myevntl_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `myevntl_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `myevntl_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `myevntl_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `myevntl_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `myevntl_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `myevntl_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `myevntl_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `myevntl_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `myevntl_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `myevntl_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `myevntl_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `myevntl_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `myevntl_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `myevntl_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `myevntl_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `myevntl_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `myevntl_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `myevntl_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `myevntl_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `myevntl_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `myevntl_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `myevntl_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `myevntl_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `myevntl_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `myevntl_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `myevntl_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `myevntl_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `myevntl_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `myevntl_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `myevntl_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `myevntl_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `myevntl_options` VALUES("78", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("81", "uninstall_plugins", "a:5:{s:25:\"go_pricing/go_pricing.php\";a:2:{i:0;s:12:\"GW_GoPricing\";i:1;s:9:\"uninstall\";}s:45:\"hide-plugin-updates-notifications/wphdpuw.php\";s:15:\"wphpuw_unistall\";s:35:\"rename-wp-login/rename-wp-login.php\";a:2:{i:0;s:15:\"Rename_WP_Login\";i:1;s:9:\"uninstall\";}s:19:\"captcha/captcha.php\";s:20:\"cptch_delete_options\";s:27:\"redirection/redirection.php\";a:2:{i:0;s:17:\"Redirection_Admin\";i:1;s:16:\"plugin_uninstall\";}}", "no");
INSERT INTO `myevntl_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `myevntl_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `myevntl_options` VALUES("84", "page_on_front", "2", "yes");
INSERT INTO `myevntl_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `myevntl_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `myevntl_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `myevntl_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `myevntl_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `myevntl_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `myevntl_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `myevntl_options` VALUES("92", "myevntl_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:83:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:9:\"access_cp\";b:1;s:16:\"vfb_create_forms\";b:1;s:14:\"vfb_edit_forms\";b:1;s:14:\"vfb_copy_forms\";b:1;s:16:\"vfb_delete_forms\";b:1;s:16:\"vfb_import_forms\";b:1;s:16:\"vfb_export_forms\";b:1;s:16:\"vfb_view_entries\";b:1;s:16:\"vfb_edit_entries\";b:1;s:18:\"vfb_delete_entries\";b:1;s:21:\"vfb_edit_email_design\";b:1;s:18:\"vfb_view_analytics\";b:1;s:17:\"vfb_edit_settings\";b:1;s:10:\"copy_posts\";b:1;s:13:\"wplc_ma_agent\";b:1;s:24:\"edit_wplc_quick_response\";b:1;s:30:\"edit_other_wplc_quick_response\";b:1;s:27:\"publish_wplc_quick_response\";b:1;s:24:\"read_wplc_quick_response\";b:1;s:32:\"read_private_wplc_quick_response\";b:1;s:26:\"delete_wplc_quick_response\";b:1;s:14:\"ljmm_view_site\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"vfb_view_entries\";b:1;s:16:\"vfb_edit_entries\";b:1;s:18:\"vfb_delete_entries\";b:1;s:18:\"vfb_view_analytics\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `myevntl_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `myevntl_options` VALUES("94", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("95", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("162", "theme_switched", "", "yes");
INSERT INTO `myevntl_options` VALUES("96", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("97", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("98", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("99", "sidebars_widgets", "a:10:{s:9:\"sidebar_4\";a:1:{i:0;s:10:\"nav_menu-4\";}s:9:\"sidebar_5\";a:1:{i:0;s:10:\"nav_menu-5\";}s:9:\"sidebar_6\";a:1:{i:0;s:10:\"nav_menu-6\";}s:9:\"sidebar_7\";a:1:{i:0;s:10:\"nav_menu-7\";}s:9:\"sidebar_8\";a:1:{i:0;s:10:\"nav_menu-8\";}s:9:\"sidebar_9\";a:1:{i:0;s:10:\"nav_menu-9\";}s:19:\"wp_inactive_widgets\";a:3:{i:0;s:4:\"9022\";i:1;s:4:\"9022\";i:2;s:4:\"9022\";}s:9:\"sidebar_1\";a:1:{i:0;s:25:\"presscore-custom-menu-1-4\";}s:9:\"sidebar_2\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `myevntl_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("103", "widget_nav_menu", "a:7:{i:4;a:1:{s:8:\"nav_menu\";i:5;}i:5;a:1:{s:8:\"nav_menu\";i:6;}i:6;a:1:{s:8:\"nav_menu\";i:7;}i:7;a:1:{s:8:\"nav_menu\";i:8;}i:8;a:1:{s:8:\"nav_menu\";i:9;}i:9;a:1:{s:8:\"nav_menu\";i:10;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("104", "cron", "a:4:{i:1536670828;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1536693573;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1536715220;a:1:{s:22:\"redirection_log_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `myevntl_options` VALUES("105", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1488214955;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:0:{}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `myevntl_options` VALUES("138", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("139", "akismet_strictness", "0", "yes");
INSERT INTO `myevntl_options` VALUES("140", "akismet_show_user_comments_approved", "0", "yes");
INSERT INTO `myevntl_options` VALUES("141", "wordpress_api_key", "e2e8d458a3f9", "yes");
INSERT INTO `myevntl_options` VALUES("160", "current_theme", "MyEventology Child Theme", "yes");
INSERT INTO `myevntl_options` VALUES("161", "theme_mods_myeventology-child", "a:3:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:6:{s:7:\"primary\";i:4;s:10:\"split_left\";i:0;s:11:\"split_right\";i:0;s:6:\"mobile\";i:0;s:3:\"top\";i:0;s:6:\"bottom\";i:0;}}", "yes");
INSERT INTO `myevntl_options` VALUES("55578", "_transient_timeout_plugin_slugs", "1536728237", "no");
INSERT INTO `myevntl_options` VALUES("55579", "_transient_plugin_slugs", "a:20:{i:0;s:19:\"akismet/akismet.php\";i:1;s:19:\"captcha/captcha.php\";i:2;s:59:\"change-default-login-logo-url-and-title/change-logo-url.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:27:\"convertplug/convertplug.php\";i:5;s:33:\"duplicate-post/duplicate-post.php\";i:6;s:25:\"duplicator/duplicator.php\";i:7;s:44:\"stops-core-theme-and-plugin-updates/main.php\";i:8;s:59:\"editor-menu-and-widget-access/editor-menu-widget-access.php\";i:9;s:43:\"lj-maintenance-mode/lj-maintenance-mode.php\";i:10;s:27:\"redirection/redirection.php\";i:11;s:35:\"rename-wp-login/rename-wp-login.php\";i:12;s:23:\"revslider/revslider.php\";i:13;s:29:\"dt-the7-core/dt-the7-core.php\";i:14;s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";i:15;s:51:\"visual-form-builder-pro/visual-form-builder-pro.php\";i:16;s:41:\"wordpress-importer/wordpress-importer.php\";i:17;s:27:\"js_composer/js_composer.php\";i:18;s:45:\"hide-plugin-updates-notifications/wphdpuw.php\";i:19;s:45:\"wp-live-chat-support/wp-live-chat-support.php\";}", "no");
INSERT INTO `myevntl_options` VALUES("39356", "_transient_dt_opts_assets_inc_presets_images", "a:340:{s:55:\"/inc/presets/images/full/skin01r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin01r.gif\";s:60:\"/inc/presets/images/full/skin01r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin01r.gif\";s:59:\"/inc/presets/images/full/skin01r.general-boxed-bg-image.gif\";s:31:\"/inc/presets/images/skin01r.gif\";s:66:\"/inc/presets/images/full/skin01r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin01r.gif\";s:71:\"/inc/presets/images/full/skin01r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin01r.gif\";s:63:\"/inc/presets/images/full/skin01r.header-style-mixed-logo-hd.png\";s:31:\"/inc/presets/images/skin01r.gif\";s:68:\"/inc/presets/images/full/skin01r.header-style-mixed-logo-regular.png\";s:31:\"/inc/presets/images/skin01r.gif\";s:64:\"/inc/presets/images/full/skin01r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin01r.gif\";s:69:\"/inc/presets/images/full/skin01r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin01r.gif\";s:69:\"/inc/presets/images/full/skin01r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin01r.gif\";s:74:\"/inc/presets/images/full/skin01r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin01r.gif\";s:62:\"/inc/presets/images/full/skin01r.stripes-stripe-3-bg-image.gif\";s:31:\"/inc/presets/images/skin01r.gif\";s:55:\"/inc/presets/images/full/skin02r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin02r.gif\";s:60:\"/inc/presets/images/full/skin02r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin02r.gif\";s:59:\"/inc/presets/images/full/skin02r.general-boxed-bg-image.jpg\";s:31:\"/inc/presets/images/skin02r.gif\";s:51:\"/inc/presets/images/full/skin02r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin02r.gif\";s:56:\"/inc/presets/images/full/skin02r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin02r.gif\";s:66:\"/inc/presets/images/full/skin02r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin02r.gif\";s:71:\"/inc/presets/images/full/skin02r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin02r.gif\";s:64:\"/inc/presets/images/full/skin02r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin02r.gif\";s:69:\"/inc/presets/images/full/skin02r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin02r.gif\";s:69:\"/inc/presets/images/full/skin02r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin02r.gif\";s:74:\"/inc/presets/images/full/skin02r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin02r.gif\";s:62:\"/inc/presets/images/full/skin02r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin02r.gif\";s:55:\"/inc/presets/images/full/skin03r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:60:\"/inc/presets/images/full/skin03r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:52:\"/inc/presets/images/full/skin03r.footer-bg-image.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:51:\"/inc/presets/images/full/skin03r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:56:\"/inc/presets/images/full/skin03r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:66:\"/inc/presets/images/full/skin03r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:71:\"/inc/presets/images/full/skin03r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:64:\"/inc/presets/images/full/skin03r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:69:\"/inc/presets/images/full/skin03r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:69:\"/inc/presets/images/full/skin03r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:74:\"/inc/presets/images/full/skin03r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:62:\"/inc/presets/images/full/skin03r.stripes-stripe-1-bg-image.png\";s:31:\"/inc/presets/images/skin03r.gif\";s:62:\"/inc/presets/images/full/skin03r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin03r.gif\";s:55:\"/inc/presets/images/full/skin04r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin04r.gif\";s:60:\"/inc/presets/images/full/skin04r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin04r.gif\";s:51:\"/inc/presets/images/full/skin04r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin04r.gif\";s:56:\"/inc/presets/images/full/skin04r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin04r.gif\";s:66:\"/inc/presets/images/full/skin04r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin04r.gif\";s:71:\"/inc/presets/images/full/skin04r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin04r.gif\";s:64:\"/inc/presets/images/full/skin04r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin04r.gif\";s:69:\"/inc/presets/images/full/skin04r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin04r.gif\";s:69:\"/inc/presets/images/full/skin04r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin04r.gif\";s:74:\"/inc/presets/images/full/skin04r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin04r.gif\";s:62:\"/inc/presets/images/full/skin04r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin04r.gif\";s:55:\"/inc/presets/images/full/skin05r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin05r.gif\";s:60:\"/inc/presets/images/full/skin05r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin05r.gif\";s:52:\"/inc/presets/images/full/skin05r.footer-bg-image.gif\";s:31:\"/inc/presets/images/skin05r.gif\";s:51:\"/inc/presets/images/full/skin05r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin05r.gif\";s:56:\"/inc/presets/images/full/skin05r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin05r.gif\";s:69:\"/inc/presets/images/full/skin05r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin05r.gif\";s:74:\"/inc/presets/images/full/skin05r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin05r.gif\";s:62:\"/inc/presets/images/full/skin05r.stripes-stripe-1-bg-image.gif\";s:31:\"/inc/presets/images/skin05r.gif\";s:62:\"/inc/presets/images/full/skin05r.stripes-stripe-3-bg-image.gif\";s:31:\"/inc/presets/images/skin05r.gif\";s:55:\"/inc/presets/images/full/skin06b.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin06b.gif\";s:60:\"/inc/presets/images/full/skin06b.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin06b.gif\";s:59:\"/inc/presets/images/full/skin06b.general-boxed-bg-image.jpg\";s:31:\"/inc/presets/images/skin06b.gif\";s:51:\"/inc/presets/images/full/skin06b.header-logo-hd.png\";s:31:\"/inc/presets/images/skin06b.gif\";s:56:\"/inc/presets/images/full/skin06b.header-logo-regular.png\";s:31:\"/inc/presets/images/skin06b.gif\";s:66:\"/inc/presets/images/full/skin06b.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin06b.gif\";s:71:\"/inc/presets/images/full/skin06b.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin06b.gif\";s:64:\"/inc/presets/images/full/skin06b.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin06b.gif\";s:69:\"/inc/presets/images/full/skin06b.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin06b.gif\";s:69:\"/inc/presets/images/full/skin06b.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin06b.gif\";s:74:\"/inc/presets/images/full/skin06b.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin06b.gif\";s:62:\"/inc/presets/images/full/skin06b.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin06b.gif\";s:51:\"/inc/presets/images/full/skin06r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin06r.gif\";s:56:\"/inc/presets/images/full/skin06r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin06r.gif\";s:63:\"/inc/presets/images/full/skin06r.header-style-mixed-logo-hd.png\";s:31:\"/inc/presets/images/skin06r.gif\";s:68:\"/inc/presets/images/full/skin06r.header-style-mixed-logo-regular.png\";s:31:\"/inc/presets/images/skin06r.gif\";s:64:\"/inc/presets/images/full/skin06r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin06r.gif\";s:69:\"/inc/presets/images/full/skin06r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin06r.gif\";s:62:\"/inc/presets/images/full/skin06r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin06r.gif\";s:52:\"/inc/presets/images/full/skin07b.footer-bg-image.gif\";s:31:\"/inc/presets/images/skin07b.gif\";s:52:\"/inc/presets/images/full/skin07b.header-bg-image.gif\";s:31:\"/inc/presets/images/skin07b.gif\";s:63:\"/inc/presets/images/full/skin07b.header-style-mixed-logo-hd.png\";s:31:\"/inc/presets/images/skin07b.gif\";s:68:\"/inc/presets/images/full/skin07b.header-style-mixed-logo-regular.png\";s:31:\"/inc/presets/images/skin07b.gif\";s:64:\"/inc/presets/images/full/skin07b.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin07b.gif\";s:69:\"/inc/presets/images/full/skin07b.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin07b.gif\";s:62:\"/inc/presets/images/full/skin07b.stripes-stripe-3-bg-image.gif\";s:31:\"/inc/presets/images/skin07b.gif\";s:55:\"/inc/presets/images/full/skin07c.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin07c.gif\";s:60:\"/inc/presets/images/full/skin07c.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin07c.gif\";s:59:\"/inc/presets/images/full/skin07c.general-boxed-bg-image.gif\";s:31:\"/inc/presets/images/skin07c.gif\";s:51:\"/inc/presets/images/full/skin07c.header-logo-hd.gif\";s:31:\"/inc/presets/images/skin07c.gif\";s:56:\"/inc/presets/images/full/skin07c.header-logo-regular.gif\";s:31:\"/inc/presets/images/skin07c.gif\";s:63:\"/inc/presets/images/full/skin07c.header-style-mixed-logo-hd.gif\";s:31:\"/inc/presets/images/skin07c.gif\";s:68:\"/inc/presets/images/full/skin07c.header-style-mixed-logo-regular.gif\";s:31:\"/inc/presets/images/skin07c.gif\";s:64:\"/inc/presets/images/full/skin07c.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin07c.gif\";s:69:\"/inc/presets/images/full/skin07c.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin07c.gif\";s:62:\"/inc/presets/images/full/skin07c.stripes-stripe-3-bg-image.gif\";s:31:\"/inc/presets/images/skin07c.gif\";s:55:\"/inc/presets/images/full/skin07s.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin07s.gif\";s:60:\"/inc/presets/images/full/skin07s.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin07s.gif\";s:59:\"/inc/presets/images/full/skin07s.general-boxed-bg-image.jpg\";s:31:\"/inc/presets/images/skin07s.gif\";s:51:\"/inc/presets/images/full/skin07s.header-logo-hd.png\";s:31:\"/inc/presets/images/skin07s.gif\";s:56:\"/inc/presets/images/full/skin07s.header-logo-regular.png\";s:31:\"/inc/presets/images/skin07s.gif\";s:66:\"/inc/presets/images/full/skin07s.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin07s.gif\";s:71:\"/inc/presets/images/full/skin07s.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin07s.gif\";s:64:\"/inc/presets/images/full/skin07s.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin07s.gif\";s:69:\"/inc/presets/images/full/skin07s.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin07s.gif\";s:69:\"/inc/presets/images/full/skin07s.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin07s.gif\";s:74:\"/inc/presets/images/full/skin07s.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin07s.gif\";s:62:\"/inc/presets/images/full/skin07s.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin07s.gif\";s:55:\"/inc/presets/images/full/skin09r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin09r.gif\";s:60:\"/inc/presets/images/full/skin09r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin09r.gif\";s:51:\"/inc/presets/images/full/skin09r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin09r.gif\";s:56:\"/inc/presets/images/full/skin09r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin09r.gif\";s:66:\"/inc/presets/images/full/skin09r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin09r.gif\";s:71:\"/inc/presets/images/full/skin09r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin09r.gif\";s:64:\"/inc/presets/images/full/skin09r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin09r.gif\";s:69:\"/inc/presets/images/full/skin09r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin09r.gif\";s:69:\"/inc/presets/images/full/skin09r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin09r.gif\";s:74:\"/inc/presets/images/full/skin09r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin09r.gif\";s:62:\"/inc/presets/images/full/skin09r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin09r.gif\";s:56:\"/inc/presets/images/full/skin10r.bottom-bar-bg-image.gif\";s:31:\"/inc/presets/images/skin10r.gif\";s:55:\"/inc/presets/images/full/skin10r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin10r.gif\";s:60:\"/inc/presets/images/full/skin10r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin10r.gif\";s:52:\"/inc/presets/images/full/skin10r.footer-bg-image.gif\";s:31:\"/inc/presets/images/skin10r.gif\";s:53:\"/inc/presets/images/full/skin10r.general-bg-image.gif\";s:31:\"/inc/presets/images/skin10r.gif\";s:59:\"/inc/presets/images/full/skin10r.general-boxed-bg-image.jpg\";s:31:\"/inc/presets/images/skin10r.gif\";s:52:\"/inc/presets/images/full/skin10r.header-bg-image.gif\";s:31:\"/inc/presets/images/skin10r.gif\";s:51:\"/inc/presets/images/full/skin10r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin10r.gif\";s:56:\"/inc/presets/images/full/skin10r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin10r.gif\";s:64:\"/inc/presets/images/full/skin10r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin10r.gif\";s:69:\"/inc/presets/images/full/skin10r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin10r.gif\";s:53:\"/inc/presets/images/full/skin10r.sidebar-bg-image.gif\";s:31:\"/inc/presets/images/skin10r.gif\";s:62:\"/inc/presets/images/full/skin10r.stripes-stripe-1-bg-image.gif\";s:31:\"/inc/presets/images/skin10r.gif\";s:62:\"/inc/presets/images/full/skin10r.stripes-stripe-2-bg-image.gif\";s:31:\"/inc/presets/images/skin10r.gif\";s:62:\"/inc/presets/images/full/skin10r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin10r.gif\";s:55:\"/inc/presets/images/full/skin11b.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin11b.gif\";s:60:\"/inc/presets/images/full/skin11b.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin11b.gif\";s:59:\"/inc/presets/images/full/skin11b.general-title-bg-image.gif\";s:31:\"/inc/presets/images/skin11b.gif\";s:51:\"/inc/presets/images/full/skin11b.header-logo-hd.png\";s:31:\"/inc/presets/images/skin11b.gif\";s:56:\"/inc/presets/images/full/skin11b.header-logo-regular.png\";s:31:\"/inc/presets/images/skin11b.gif\";s:66:\"/inc/presets/images/full/skin11b.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin11b.gif\";s:71:\"/inc/presets/images/full/skin11b.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin11b.gif\";s:64:\"/inc/presets/images/full/skin11b.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin11b.gif\";s:69:\"/inc/presets/images/full/skin11b.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin11b.gif\";s:69:\"/inc/presets/images/full/skin11b.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin11b.gif\";s:74:\"/inc/presets/images/full/skin11b.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin11b.gif\";s:62:\"/inc/presets/images/full/skin11b.stripes-stripe-3-bg-image.gif\";s:31:\"/inc/presets/images/skin11b.gif\";s:55:\"/inc/presets/images/full/skin11r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:60:\"/inc/presets/images/full/skin11r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:52:\"/inc/presets/images/full/skin11r.footer-bg-image.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:59:\"/inc/presets/images/full/skin11r.general-boxed-bg-image.jpg\";s:31:\"/inc/presets/images/skin11r.gif\";s:52:\"/inc/presets/images/full/skin11r.header-bg-image.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:51:\"/inc/presets/images/full/skin11r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:56:\"/inc/presets/images/full/skin11r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:66:\"/inc/presets/images/full/skin11r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:71:\"/inc/presets/images/full/skin11r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:64:\"/inc/presets/images/full/skin11r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:69:\"/inc/presets/images/full/skin11r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:69:\"/inc/presets/images/full/skin11r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:74:\"/inc/presets/images/full/skin11r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:62:\"/inc/presets/images/full/skin11r.stripes-stripe-2-bg-image.png\";s:31:\"/inc/presets/images/skin11r.gif\";s:62:\"/inc/presets/images/full/skin11r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin11r.gif\";s:55:\"/inc/presets/images/full/skin12r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin12r.gif\";s:60:\"/inc/presets/images/full/skin12r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin12r.gif\";s:51:\"/inc/presets/images/full/skin12r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin12r.gif\";s:56:\"/inc/presets/images/full/skin12r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin12r.gif\";s:66:\"/inc/presets/images/full/skin12r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin12r.gif\";s:71:\"/inc/presets/images/full/skin12r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin12r.gif\";s:64:\"/inc/presets/images/full/skin12r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin12r.gif\";s:69:\"/inc/presets/images/full/skin12r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin12r.gif\";s:69:\"/inc/presets/images/full/skin12r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin12r.gif\";s:74:\"/inc/presets/images/full/skin12r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin12r.gif\";s:62:\"/inc/presets/images/full/skin12r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin12r.gif\";s:52:\"/inc/presets/images/full/skin13r.footer-bg-image.gif\";s:31:\"/inc/presets/images/skin13r.gif\";s:51:\"/inc/presets/images/full/skin13r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin13r.gif\";s:56:\"/inc/presets/images/full/skin13r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin13r.gif\";s:66:\"/inc/presets/images/full/skin13r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin13r.gif\";s:71:\"/inc/presets/images/full/skin13r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin13r.gif\";s:64:\"/inc/presets/images/full/skin13r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin13r.gif\";s:69:\"/inc/presets/images/full/skin13r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin13r.gif\";s:69:\"/inc/presets/images/full/skin13r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin13r.gif\";s:74:\"/inc/presets/images/full/skin13r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin13r.gif\";s:62:\"/inc/presets/images/full/skin13r.stripes-stripe-1-bg-image.gif\";s:31:\"/inc/presets/images/skin13r.gif\";s:59:\"/inc/presets/images/full/skin14r.general-boxed-bg-image.jpg\";s:31:\"/inc/presets/images/skin14r.gif\";s:51:\"/inc/presets/images/full/skin14r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin14r.gif\";s:56:\"/inc/presets/images/full/skin14r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin14r.gif\";s:66:\"/inc/presets/images/full/skin14r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin14r.gif\";s:71:\"/inc/presets/images/full/skin14r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin14r.gif\";s:64:\"/inc/presets/images/full/skin14r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin14r.gif\";s:69:\"/inc/presets/images/full/skin14r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin14r.gif\";s:69:\"/inc/presets/images/full/skin14r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin14r.gif\";s:74:\"/inc/presets/images/full/skin14r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin14r.gif\";s:62:\"/inc/presets/images/full/skin14r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin14r.gif\";s:55:\"/inc/presets/images/full/skin15r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin15r.gif\";s:60:\"/inc/presets/images/full/skin15r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin15r.gif\";s:51:\"/inc/presets/images/full/skin15r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin15r.gif\";s:56:\"/inc/presets/images/full/skin15r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin15r.gif\";s:69:\"/inc/presets/images/full/skin15r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin15r.gif\";s:74:\"/inc/presets/images/full/skin15r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin15r.gif\";s:62:\"/inc/presets/images/full/skin15r.stripes-stripe-3-bg-image.gif\";s:31:\"/inc/presets/images/skin15r.gif\";s:52:\"/inc/presets/images/full/skin16r.footer-bg-image.gif\";s:31:\"/inc/presets/images/skin16r.gif\";s:59:\"/inc/presets/images/full/skin16r.general-boxed-bg-image.jpg\";s:31:\"/inc/presets/images/skin16r.gif\";s:59:\"/inc/presets/images/full/skin16r.general-title-bg-image.gif\";s:31:\"/inc/presets/images/skin16r.gif\";s:52:\"/inc/presets/images/full/skin16r.header-bg-image.gif\";s:31:\"/inc/presets/images/skin16r.gif\";s:51:\"/inc/presets/images/full/skin16r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin16r.gif\";s:56:\"/inc/presets/images/full/skin16r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin16r.gif\";s:64:\"/inc/presets/images/full/skin16r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin16r.gif\";s:69:\"/inc/presets/images/full/skin16r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin16r.gif\";s:62:\"/inc/presets/images/full/skin16r.stripes-stripe-1-bg-image.gif\";s:31:\"/inc/presets/images/skin16r.gif\";s:62:\"/inc/presets/images/full/skin16r.stripes-stripe-2-bg-image.gif\";s:31:\"/inc/presets/images/skin16r.gif\";s:62:\"/inc/presets/images/full/skin16r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin16r.gif\";s:55:\"/inc/presets/images/full/skin18r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin18r.gif\";s:60:\"/inc/presets/images/full/skin18r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin18r.gif\";s:59:\"/inc/presets/images/full/skin18r.general-boxed-bg-image.jpg\";s:31:\"/inc/presets/images/skin18r.gif\";s:51:\"/inc/presets/images/full/skin18r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin18r.gif\";s:56:\"/inc/presets/images/full/skin18r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin18r.gif\";s:66:\"/inc/presets/images/full/skin18r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin18r.gif\";s:71:\"/inc/presets/images/full/skin18r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin18r.gif\";s:64:\"/inc/presets/images/full/skin18r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin18r.gif\";s:69:\"/inc/presets/images/full/skin18r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin18r.gif\";s:69:\"/inc/presets/images/full/skin18r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin18r.gif\";s:74:\"/inc/presets/images/full/skin18r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin18r.gif\";s:62:\"/inc/presets/images/full/skin18r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin18r.gif\";s:59:\"/inc/presets/images/full/skin19b.general-boxed-bg-image.jpg\";s:31:\"/inc/presets/images/skin19b.gif\";s:59:\"/inc/presets/images/full/skin19b.general-title-bg-image.jpg\";s:31:\"/inc/presets/images/skin19b.gif\";s:51:\"/inc/presets/images/full/skin19b.header-logo-hd.png\";s:31:\"/inc/presets/images/skin19b.gif\";s:56:\"/inc/presets/images/full/skin19b.header-logo-regular.png\";s:31:\"/inc/presets/images/skin19b.gif\";s:63:\"/inc/presets/images/full/skin19b.header-style-mixed-logo-hd.png\";s:31:\"/inc/presets/images/skin19b.gif\";s:68:\"/inc/presets/images/full/skin19b.header-style-mixed-logo-regular.png\";s:31:\"/inc/presets/images/skin19b.gif\";s:64:\"/inc/presets/images/full/skin19b.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin19b.gif\";s:69:\"/inc/presets/images/full/skin19b.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin19b.gif\";s:62:\"/inc/presets/images/full/skin19b.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin19b.gif\";s:55:\"/inc/presets/images/full/skin19r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:60:\"/inc/presets/images/full/skin19r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:51:\"/inc/presets/images/full/skin19r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:56:\"/inc/presets/images/full/skin19r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:66:\"/inc/presets/images/full/skin19r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:71:\"/inc/presets/images/full/skin19r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:63:\"/inc/presets/images/full/skin19r.header-style-mixed-logo-hd.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:68:\"/inc/presets/images/full/skin19r.header-style-mixed-logo-regular.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:64:\"/inc/presets/images/full/skin19r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:69:\"/inc/presets/images/full/skin19r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:69:\"/inc/presets/images/full/skin19r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:74:\"/inc/presets/images/full/skin19r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin19r.gif\";s:62:\"/inc/presets/images/full/skin19r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin19r.gif\";s:55:\"/inc/presets/images/full/skin19s.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin19s.gif\";s:60:\"/inc/presets/images/full/skin19s.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin19s.gif\";s:51:\"/inc/presets/images/full/skin19s.header-logo-hd.png\";s:31:\"/inc/presets/images/skin19s.gif\";s:56:\"/inc/presets/images/full/skin19s.header-logo-regular.png\";s:31:\"/inc/presets/images/skin19s.gif\";s:63:\"/inc/presets/images/full/skin19s.header-style-mixed-logo-hd.png\";s:31:\"/inc/presets/images/skin19s.gif\";s:68:\"/inc/presets/images/full/skin19s.header-style-mixed-logo-regular.png\";s:31:\"/inc/presets/images/skin19s.gif\";s:64:\"/inc/presets/images/full/skin19s.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin19s.gif\";s:69:\"/inc/presets/images/full/skin19s.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin19s.gif\";s:62:\"/inc/presets/images/full/skin19s.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin19s.gif\";s:55:\"/inc/presets/images/full/skin20r.bottom-bar-logo-hd.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:60:\"/inc/presets/images/full/skin20r.bottom-bar-logo-regular.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:59:\"/inc/presets/images/full/skin20r.general-boxed-bg-image.jpg\";s:31:\"/inc/presets/images/skin20r.gif\";s:51:\"/inc/presets/images/full/skin20r.header-logo-hd.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:56:\"/inc/presets/images/full/skin20r.header-logo-regular.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:66:\"/inc/presets/images/full/skin20r.header-style-floating-logo-hd.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:71:\"/inc/presets/images/full/skin20r.header-style-floating-logo-regular.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:63:\"/inc/presets/images/full/skin20r.header-style-mixed-logo-hd.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:68:\"/inc/presets/images/full/skin20r.header-style-mixed-logo-regular.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:64:\"/inc/presets/images/full/skin20r.header-style-mobile-logo-hd.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:69:\"/inc/presets/images/full/skin20r.header-style-mobile-logo-regular.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:69:\"/inc/presets/images/full/skin20r.header-style-transparent-logo-hd.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:74:\"/inc/presets/images/full/skin20r.header-style-transparent-logo-regular.png\";s:31:\"/inc/presets/images/skin20r.gif\";s:62:\"/inc/presets/images/full/skin20r.stripes-stripe-3-bg-image.jpg\";s:31:\"/inc/presets/images/skin20r.gif\";s:58:\"/inc/presets/images/full/skin21.general-title-bg-image.gif\";s:30:\"/inc/presets/images/skin21.gif\";s:51:\"/inc/presets/images/full/skin21.header-bg-image.gif\";s:30:\"/inc/presets/images/skin21.gif\";s:50:\"/inc/presets/images/full/skin21.header-logo-hd.png\";s:30:\"/inc/presets/images/skin21.gif\";s:55:\"/inc/presets/images/full/skin21.header-logo-regular.png\";s:30:\"/inc/presets/images/skin21.gif\";s:62:\"/inc/presets/images/full/skin21.header-style-mixed-logo-hd.png\";s:30:\"/inc/presets/images/skin21.gif\";s:67:\"/inc/presets/images/full/skin21.header-style-mixed-logo-regular.png\";s:30:\"/inc/presets/images/skin21.gif\";s:63:\"/inc/presets/images/full/skin21.header-style-mobile-logo-hd.png\";s:30:\"/inc/presets/images/skin21.gif\";s:68:\"/inc/presets/images/full/skin21.header-style-mobile-logo-regular.png\";s:30:\"/inc/presets/images/skin21.gif\";s:61:\"/inc/presets/images/full/skin21.stripes-stripe-3-bg-image.gif\";s:30:\"/inc/presets/images/skin21.gif\";s:54:\"/inc/presets/images/full/skin22.bottom-bar-logo-hd.png\";s:54:\"/inc/presets/images/full/skin22.bottom-bar-logo-hd.png\";s:59:\"/inc/presets/images/full/skin22.bottom-bar-logo-regular.png\";s:59:\"/inc/presets/images/full/skin22.bottom-bar-logo-regular.png\";s:50:\"/inc/presets/images/full/skin22.header-logo-hd.png\";s:50:\"/inc/presets/images/full/skin22.header-logo-hd.png\";s:55:\"/inc/presets/images/full/skin22.header-logo-regular.png\";s:55:\"/inc/presets/images/full/skin22.header-logo-regular.png\";s:65:\"/inc/presets/images/full/skin22.header-style-floating-logo-hd.png\";s:65:\"/inc/presets/images/full/skin22.header-style-floating-logo-hd.png\";s:70:\"/inc/presets/images/full/skin22.header-style-floating-logo-regular.png\";s:70:\"/inc/presets/images/full/skin22.header-style-floating-logo-regular.png\";s:63:\"/inc/presets/images/full/skin22.header-style-mobile-logo-hd.png\";s:63:\"/inc/presets/images/full/skin22.header-style-mobile-logo-hd.png\";s:68:\"/inc/presets/images/full/skin22.header-style-mobile-logo-regular.png\";s:68:\"/inc/presets/images/full/skin22.header-style-mobile-logo-regular.png\";s:68:\"/inc/presets/images/full/skin22.header-style-transparent-logo-hd.png\";s:68:\"/inc/presets/images/full/skin22.header-style-transparent-logo-hd.png\";s:73:\"/inc/presets/images/full/skin22.header-style-transparent-logo-regular.png\";s:73:\"/inc/presets/images/full/skin22.header-style-transparent-logo-regular.png\";s:61:\"/inc/presets/images/full/skin22.stripes-stripe-3-bg-image.jpg\";s:61:\"/inc/presets/images/full/skin22.stripes-stripe-3-bg-image.jpg\";s:56:\"/inc/presets/images/full/wizard01.bottom-bar-logo-hd.png\";s:32:\"/inc/presets/images/wizard01.gif\";s:61:\"/inc/presets/images/full/wizard01.bottom-bar-logo-regular.png\";s:32:\"/inc/presets/images/wizard01.gif\";s:52:\"/inc/presets/images/full/wizard01.header-logo-hd.png\";s:32:\"/inc/presets/images/wizard01.gif\";s:57:\"/inc/presets/images/full/wizard01.header-logo-regular.png\";s:32:\"/inc/presets/images/wizard01.gif\";s:67:\"/inc/presets/images/full/wizard01.header-style-floating-logo-hd.png\";s:32:\"/inc/presets/images/wizard01.gif\";s:72:\"/inc/presets/images/full/wizard01.header-style-floating-logo-regular.png\";s:32:\"/inc/presets/images/wizard01.gif\";s:65:\"/inc/presets/images/full/wizard01.header-style-mobile-logo-hd.png\";s:32:\"/inc/presets/images/wizard01.gif\";s:70:\"/inc/presets/images/full/wizard01.header-style-mobile-logo-regular.png\";s:32:\"/inc/presets/images/wizard01.gif\";s:70:\"/inc/presets/images/full/wizard01.header-style-transparent-logo-hd.png\";s:32:\"/inc/presets/images/wizard01.gif\";s:75:\"/inc/presets/images/full/wizard01.header-style-transparent-logo-regular.png\";s:32:\"/inc/presets/images/wizard01.gif\";s:63:\"/inc/presets/images/full/wizard01.stripes-stripe-3-bg-image.jpg\";s:32:\"/inc/presets/images/wizard01.gif\";s:56:\"/inc/presets/images/full/wizard02.bottom-bar-logo-hd.png\";s:32:\"/inc/presets/images/wizard02.gif\";s:61:\"/inc/presets/images/full/wizard02.bottom-bar-logo-regular.png\";s:32:\"/inc/presets/images/wizard02.gif\";s:52:\"/inc/presets/images/full/wizard02.header-logo-hd.png\";s:32:\"/inc/presets/images/wizard02.gif\";s:57:\"/inc/presets/images/full/wizard02.header-logo-regular.png\";s:32:\"/inc/presets/images/wizard02.gif\";s:67:\"/inc/presets/images/full/wizard02.header-style-floating-logo-hd.png\";s:32:\"/inc/presets/images/wizard02.gif\";s:72:\"/inc/presets/images/full/wizard02.header-style-floating-logo-regular.png\";s:32:\"/inc/presets/images/wizard02.gif\";s:65:\"/inc/presets/images/full/wizard02.header-style-mobile-logo-hd.png\";s:32:\"/inc/presets/images/wizard02.gif\";s:70:\"/inc/presets/images/full/wizard02.header-style-mobile-logo-regular.png\";s:32:\"/inc/presets/images/wizard02.gif\";s:70:\"/inc/presets/images/full/wizard02.header-style-transparent-logo-hd.png\";s:32:\"/inc/presets/images/wizard02.gif\";s:75:\"/inc/presets/images/full/wizard02.header-style-transparent-logo-regular.png\";s:32:\"/inc/presets/images/wizard02.gif\";s:63:\"/inc/presets/images/full/wizard02.stripes-stripe-3-bg-image.jpg\";s:32:\"/inc/presets/images/wizard02.gif\";s:56:\"/inc/presets/images/full/wizard03.bottom-bar-logo-hd.png\";s:32:\"/inc/presets/images/wizard03.gif\";s:61:\"/inc/presets/images/full/wizard03.bottom-bar-logo-regular.png\";s:32:\"/inc/presets/images/wizard03.gif\";s:52:\"/inc/presets/images/full/wizard03.header-logo-hd.png\";s:32:\"/inc/presets/images/wizard03.gif\";s:57:\"/inc/presets/images/full/wizard03.header-logo-regular.png\";s:32:\"/inc/presets/images/wizard03.gif\";s:67:\"/inc/presets/images/full/wizard03.header-style-floating-logo-hd.png\";s:32:\"/inc/presets/images/wizard03.gif\";s:72:\"/inc/presets/images/full/wizard03.header-style-floating-logo-regular.png\";s:32:\"/inc/presets/images/wizard03.gif\";s:65:\"/inc/presets/images/full/wizard03.header-style-mobile-logo-hd.png\";s:32:\"/inc/presets/images/wizard03.gif\";s:70:\"/inc/presets/images/full/wizard03.header-style-mobile-logo-regular.png\";s:32:\"/inc/presets/images/wizard03.gif\";s:70:\"/inc/presets/images/full/wizard03.header-style-transparent-logo-hd.png\";s:32:\"/inc/presets/images/wizard03.gif\";s:75:\"/inc/presets/images/full/wizard03.header-style-transparent-logo-regular.png\";s:32:\"/inc/presets/images/wizard03.gif\";s:56:\"/inc/presets/images/full/wizard04.bottom-bar-logo-hd.png\";s:32:\"/inc/presets/images/wizard04.gif\";s:61:\"/inc/presets/images/full/wizard04.bottom-bar-logo-regular.png\";s:32:\"/inc/presets/images/wizard04.gif\";s:52:\"/inc/presets/images/full/wizard04.header-logo-hd.png\";s:32:\"/inc/presets/images/wizard04.gif\";s:57:\"/inc/presets/images/full/wizard04.header-logo-regular.png\";s:32:\"/inc/presets/images/wizard04.gif\";s:67:\"/inc/presets/images/full/wizard04.header-style-floating-logo-hd.png\";s:32:\"/inc/presets/images/wizard04.gif\";s:72:\"/inc/presets/images/full/wizard04.header-style-floating-logo-regular.png\";s:32:\"/inc/presets/images/wizard04.gif\";s:64:\"/inc/presets/images/full/wizard04.header-style-mixed-logo-hd.png\";s:32:\"/inc/presets/images/wizard04.gif\";s:69:\"/inc/presets/images/full/wizard04.header-style-mixed-logo-regular.png\";s:32:\"/inc/presets/images/wizard04.gif\";s:65:\"/inc/presets/images/full/wizard04.header-style-mobile-logo-hd.png\";s:32:\"/inc/presets/images/wizard04.gif\";s:70:\"/inc/presets/images/full/wizard04.header-style-mobile-logo-regular.png\";s:32:\"/inc/presets/images/wizard04.gif\";s:52:\"/inc/presets/images/full/wizard05.header-logo-hd.png\";s:32:\"/inc/presets/images/wizard05.gif\";s:57:\"/inc/presets/images/full/wizard05.header-logo-regular.png\";s:32:\"/inc/presets/images/wizard05.gif\";s:64:\"/inc/presets/images/full/wizard05.header-style-mixed-logo-hd.png\";s:32:\"/inc/presets/images/wizard05.gif\";s:69:\"/inc/presets/images/full/wizard05.header-style-mixed-logo-regular.png\";s:32:\"/inc/presets/images/wizard05.gif\";s:65:\"/inc/presets/images/full/wizard05.header-style-mobile-logo-hd.png\";s:32:\"/inc/presets/images/wizard05.gif\";s:70:\"/inc/presets/images/full/wizard05.header-style-mobile-logo-regular.png\";s:32:\"/inc/presets/images/wizard05.gif\";s:52:\"/inc/presets/images/full/wizard06.header-logo-hd.png\";s:32:\"/inc/presets/images/wizard06.gif\";s:57:\"/inc/presets/images/full/wizard06.header-logo-regular.png\";s:32:\"/inc/presets/images/wizard06.gif\";s:67:\"/inc/presets/images/full/wizard06.header-style-floating-logo-hd.png\";s:32:\"/inc/presets/images/wizard06.gif\";s:72:\"/inc/presets/images/full/wizard06.header-style-floating-logo-regular.png\";s:32:\"/inc/presets/images/wizard06.gif\";s:64:\"/inc/presets/images/full/wizard06.header-style-mixed-logo-hd.png\";s:32:\"/inc/presets/images/wizard06.gif\";s:69:\"/inc/presets/images/full/wizard06.header-style-mixed-logo-regular.png\";s:32:\"/inc/presets/images/wizard06.gif\";s:65:\"/inc/presets/images/full/wizard06.header-style-mobile-logo-hd.png\";s:32:\"/inc/presets/images/wizard06.gif\";s:70:\"/inc/presets/images/full/wizard06.header-style-mobile-logo-regular.png\";s:32:\"/inc/presets/images/wizard06.gif\";}", "no");
INSERT INTO `myevntl_options` VALUES("39357", "_transient_timeout_dt_opts_assets_images_backgrounds_patterns", "1523416566", "no");
INSERT INTO `myevntl_options` VALUES("39358", "_transient_dt_opts_assets_images_backgrounds_patterns", "a:25:{s:45:\"/images/backgrounds/patterns/full/archers.gif\";s:47:\"/images/backgrounds/patterns/thumbs/archers.jpg\";s:50:\"/images/backgrounds/patterns/full/binding_dark.gif\";s:52:\"/images/backgrounds/patterns/thumbs/binding_dark.jpg\";s:47:\"/images/backgrounds/patterns/full/brickwall.gif\";s:49:\"/images/backgrounds/patterns/thumbs/brickwall.jpg\";s:55:\"/images/backgrounds/patterns/full/congruent_outline.png\";s:57:\"/images/backgrounds/patterns/thumbs/congruent_outline.jpg\";s:56:\"/images/backgrounds/patterns/full/congruent_pentagon.png\";s:58:\"/images/backgrounds/patterns/thumbs/congruent_pentagon.jpg\";s:57:\"/images/backgrounds/patterns/full/crisp_paper_ruffles.jpg\";s:59:\"/images/backgrounds/patterns/thumbs/crisp_paper_ruffles.jpg\";s:53:\"/images/backgrounds/patterns/full/escheresque_ste.png\";s:55:\"/images/backgrounds/patterns/thumbs/escheresque_ste.jpg\";s:50:\"/images/backgrounds/patterns/full/gplaypattern.jpg\";s:52:\"/images/backgrounds/patterns/thumbs/gplaypattern.jpg\";s:49:\"/images/backgrounds/patterns/full/graphy-dark.png\";s:51:\"/images/backgrounds/patterns/thumbs/graphy-dark.jpg\";s:50:\"/images/backgrounds/patterns/full/graphy-light.png\";s:52:\"/images/backgrounds/patterns/thumbs/graphy-light.jpg\";s:47:\"/images/backgrounds/patterns/full/grey_wood.jpg\";s:49:\"/images/backgrounds/patterns/thumbs/grey_wood.jpg\";s:47:\"/images/backgrounds/patterns/full/grid-dark.png\";s:49:\"/images/backgrounds/patterns/thumbs/grid-dark.jpg\";s:48:\"/images/backgrounds/patterns/full/grid-light.png\";s:50:\"/images/backgrounds/patterns/thumbs/grid-light.jpg\";s:51:\"/images/backgrounds/patterns/full/halftone-dark.png\";s:53:\"/images/backgrounds/patterns/thumbs/halftone-dark.jpg\";s:52:\"/images/backgrounds/patterns/full/halftone-light.png\";s:54:\"/images/backgrounds/patterns/thumbs/halftone-light.jpg\";s:44:\"/images/backgrounds/patterns/full/herald.png\";s:46:\"/images/backgrounds/patterns/thumbs/herald.jpg\";s:48:\"/images/backgrounds/patterns/full/linedpaper.jpg\";s:50:\"/images/backgrounds/patterns/thumbs/linedpaper.jpg\";s:56:\"/images/backgrounds/patterns/full/low_contrast_linen.jpg\";s:58:\"/images/backgrounds/patterns/thumbs/low_contrast_linen.jpg\";s:46:\"/images/backgrounds/patterns/full/notebook.gif\";s:48:\"/images/backgrounds/patterns/thumbs/notebook.jpg\";s:42:\"/images/backgrounds/patterns/full/poly.png\";s:44:\"/images/backgrounds/patterns/thumbs/poly.jpg\";s:48:\"/images/backgrounds/patterns/full/retro-dark.png\";s:50:\"/images/backgrounds/patterns/thumbs/retro-dark.jpg\";s:49:\"/images/backgrounds/patterns/full/retro-light.png\";s:51:\"/images/backgrounds/patterns/thumbs/retro-light.jpg\";s:44:\"/images/backgrounds/patterns/full/skulls.gif\";s:46:\"/images/backgrounds/patterns/thumbs/skulls.jpg\";s:46:\"/images/backgrounds/patterns/full/stardust.gif\";s:48:\"/images/backgrounds/patterns/thumbs/stardust.jpg\";s:51:\"/images/backgrounds/patterns/full/subtle_grunge.png\";s:53:\"/images/backgrounds/patterns/thumbs/subtle_grunge.jpg\";}", "no");
INSERT INTO `myevntl_options` VALUES("5166", "wp_less_stylesheet_data_aa33403642dfedc16ff5cf0649f2625f", "a:1:{s:10:\"target_uri\";s:99:\"http://www.myeventology.ph/wp-content/uploads/wp-less/myeventology/css/custom-old-ie-2a6270c530.css\";}", "yes");
INSERT INTO `myevntl_options` VALUES("39364", "_transient_timeout_wp_less_compiled_aa33403642dfedc16ff5cf0649f2625f", "1523413123", "no");
INSERT INTO `myevntl_options` VALUES("39365", "_transient_wp_less_compiled_aa33403642dfedc16ff5cf0649f2625f", "a:4:{s:4:\"root\";s:94:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/custom-old-ie.less\";s:8:\"compiled\";N;s:5:\"files\";a:1:{s:94:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/custom-old-ie.less\";i:1492687608;}s:7:\"updated\";i:1523413093;}", "no");
INSERT INTO `myevntl_options` VALUES("5169", "wp_less_stylesheet_data_0ef4ee98e07f08b9a8045fb952b18f63", "a:1:{s:10:\"target_uri\";s:92:\"http://www.myeventology.ph/wp-content/uploads/wp-less/myeventology/css/custom-2a6270c530.css\";}", "yes");
INSERT INTO `myevntl_options` VALUES("39366", "_transient_timeout_wp_less_compiled_0ef4ee98e07f08b9a8045fb952b18f63", "1523413124", "no");
INSERT INTO `myevntl_options` VALUES("39367", "_transient_wp_less_compiled_0ef4ee98e07f08b9a8045fb952b18f63", "a:4:{s:4:\"root\";s:87:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/custom.less\";s:8:\"compiled\";N;s:5:\"files\";a:47:{s:94:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/custom-old-ie.less\";i:1492687608;s:87:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/custom.less\";i:1492687608;s:103:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/variables.less\";i:1492687608;s:103:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/svg-icons.less\";i:1492687608;s:104:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/typography.less\";i:1492687608;s:100:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header.less\";i:1492687608;s:135:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_horizontal-headers.less\";i:1492687608;s:133:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_vertical-headers.less\";i:1492687608;s:131:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_classic-header.less\";i:1492687608;s:130:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_inline-header.less\";i:1492687608;s:129:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_split-header.less\";i:1492687608;s:130:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_mixed-headers.less\";i:1492687608;s:108:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/top-bar.less\";i:1492687608;s:116:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-elements.less\";i:1492687608;s:109:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav.less\";i:1492687608;s:119:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav/main-menu.less\";i:1492687608;s:131:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav/menu-decoration-style.less\";i:1492687608;s:118:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav/sub-menu.less\";i:1492687608;s:119:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav/mega-menu.less\";i:1492687608;s:121:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav/mobile-menu.less\";i:1492687608;s:116:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/floating-header.less\";i:1492687608;s:108:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/main-slideshow.less\";i:1492687608;s:100:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/titles.less\";i:1492687608;s:101:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/sidebar.less\";i:1492687608;s:101:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/widgets.less\";i:1492687608;s:107:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/post-template.less\";i:1492687608;s:100:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/single.less\";i:1492687608;s:104:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes.less\";i:1492687608;s:112:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/buttons.less\";i:1492687608;s:109:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/tabs.less\";i:1492687608;s:114:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/accordion.less\";i:1492687608;s:126:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/titles-and-separators.less\";i:1492687608;s:114:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/pie-chart.less\";i:1492687608;s:112:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/tooltip.less\";i:1492687608;s:116:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/fancy-media.less\";i:1492687608;s:109:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/list.less\";i:1492687608;s:117:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/social-icons.less\";i:1492687608;s:117:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/progress-bar.less\";i:1492687608;s:115:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/blockquote.less\";i:1492687608;s:123:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/shortcode-scroller.less\";i:1492687608;s:101:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/stripes.less\";i:1492687608;s:111:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/filter-pagination.less\";i:1492687608;s:100:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/footer.less\";i:1492687608;s:97:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/mix.less\";i:1492687608;s:107:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/hover-layouts.less\";i:1492687608;s:101:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/plugins.less\";i:1492687608;s:101:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/presets.less\";i:1492687608;}s:7:\"updated\";i:1523413094;}", "no");
INSERT INTO `myevntl_options` VALUES("5172", "wp_less_stylesheet_data_e78f61cea7e3cbf084e80e0c265c773d", "a:1:{s:10:\"target_uri\";s:91:\"http://www.myeventology.ph/wp-content/uploads/wp-less/myeventology/css/media-2a6270c530.css\";}", "yes");
INSERT INTO `myevntl_options` VALUES("39368", "_transient_timeout_wp_less_compiled_e78f61cea7e3cbf084e80e0c265c773d", "1523413125", "no");
INSERT INTO `myevntl_options` VALUES("39369", "_transient_wp_less_compiled_e78f61cea7e3cbf084e80e0c265c773d", "a:4:{s:4:\"root\";s:86:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/media.less\";s:8:\"compiled\";N;s:5:\"files\";a:48:{s:94:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/custom-old-ie.less\";i:1492687608;s:87:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/custom.less\";i:1492687608;s:103:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/variables.less\";i:1492687608;s:103:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/svg-icons.less\";i:1492687608;s:104:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/typography.less\";i:1492687608;s:100:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header.less\";i:1492687608;s:135:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_horizontal-headers.less\";i:1492687608;s:133:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_vertical-headers.less\";i:1492687608;s:131:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_classic-header.less\";i:1492687608;s:130:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_inline-header.less\";i:1492687608;s:129:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_split-header.less\";i:1492687608;s:130:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-layouts/_mixed-headers.less\";i:1492687608;s:108:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/top-bar.less\";i:1492687608;s:116:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/header-elements.less\";i:1492687608;s:109:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav.less\";i:1492687608;s:119:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav/main-menu.less\";i:1492687608;s:131:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav/menu-decoration-style.less\";i:1492687608;s:118:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav/sub-menu.less\";i:1492687608;s:119:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav/mega-menu.less\";i:1492687608;s:121:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/main-nav/mobile-menu.less\";i:1492687608;s:116:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/header/floating-header.less\";i:1492687608;s:108:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/main-slideshow.less\";i:1492687608;s:100:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/titles.less\";i:1492687608;s:101:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/sidebar.less\";i:1492687608;s:101:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/widgets.less\";i:1492687608;s:107:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/post-template.less\";i:1492687608;s:100:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/single.less\";i:1492687608;s:104:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes.less\";i:1492687608;s:112:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/buttons.less\";i:1492687608;s:109:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/tabs.less\";i:1492687608;s:114:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/accordion.less\";i:1492687608;s:126:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/titles-and-separators.less\";i:1492687608;s:114:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/pie-chart.less\";i:1492687608;s:112:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/tooltip.less\";i:1492687608;s:116:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/fancy-media.less\";i:1492687608;s:109:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/list.less\";i:1492687608;s:117:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/social-icons.less\";i:1492687608;s:117:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/progress-bar.less\";i:1492687608;s:115:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/blockquote.less\";i:1492687608;s:123:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/shortcodes/shortcode-scroller.less\";i:1492687608;s:101:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/stripes.less\";i:1492687608;s:111:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/filter-pagination.less\";i:1492687608;s:100:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/footer.less\";i:1492687608;s:97:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/mix.less\";i:1492687608;s:107:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/hover-layouts.less\";i:1492687608;s:101:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/plugins.less\";i:1492687608;s:101:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/dynamic-less/presets.less\";i:1492687608;s:86:\"/home/travel/public_html/myeventology.ph/wp-content/themes/myeventology/css/media.less\";i:1492687608;}s:7:\"updated\";i:1523413095;}", "no");
INSERT INTO `myevntl_options` VALUES("33952", "_site_transient_timeout_available_translations", "1519795510", "no");
INSERT INTO `myevntl_options` VALUES("33953", "_site_transient_available_translations", "a:108:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-27 04:32:49\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.4/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:49:08\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-22 18:59:07\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-12 20:34:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-09 11:39:31\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.4/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-16 13:06:08\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-04 16:58:43\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-05 09:44:12\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"མུ་མཐུད།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-04 20:20:28\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-12 09:29:39\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 08:46:26\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:49:29\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-05 09:50:06\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-28 14:35:15\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7.4/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-18 13:57:42\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:40:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:39:59\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/4.7.4/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-11 20:10:39\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-28 03:10:25\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:53:43\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:54:30\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:49:34\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-27 00:40:28\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-04 18:08:49\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-10 16:26:52\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:54:37\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:54:37\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-09 09:36:22\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-28 20:09:49\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:41:31\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-23 23:02:31\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:42:28\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 16:37:11\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-12 06:40:28\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-02-02 15:21:03\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:42:25\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:40:32\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-02-03 21:08:25\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-05 12:10:24\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:40:27\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-21 14:17:42\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:31:\"ચાલુ રાખવું\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-29 21:21:10\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-01 10:53:22\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-28 13:34:22\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:39\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-02 14:01:52\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-13 13:55:54\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-08 04:57:54\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-02 05:13:51\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-05 06:17:00\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:39:13\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-07 02:07:59\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-18 05:09:08\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:25\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-30 09:46:13\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-17 20:40:40\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:54:41\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:43:32\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-12 07:29:35\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"Үргэлжлүүлэх\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-24 06:52:11\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-05 09:45:10\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.20\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.20/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:42:31\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:31\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-11 15:57:29\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-15 08:29:44\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-02-16 13:24:21\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.7.4/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:40:57\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-02 13:47:38\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:7:\"Punjabi\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-23 09:31:28\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.20\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.20/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-17 15:02:48\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-15 10:57:32\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-15 14:53:36\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-20 10:13:53\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-10 13:48:29\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-02-08 17:57:45\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-24 08:35:30\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:41:03\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-03 00:34:10\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:48:43\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-30 02:38:08\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-15 09:03:35\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:0:\"\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-05 09:23:39\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-17 03:13:31\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-27 07:08:07\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-13 09:55:38\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-04-10 15:33:37\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.4/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-03-28 12:03:30\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-01-26 15:54:45\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.7.4\";s:7:\"updated\";s:19:\"2017-05-08 04:16:08\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.4/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "no");
INSERT INTO `myevntl_options` VALUES("8172", "WPLANG", "", "yes");
INSERT INTO `myevntl_options` VALUES("257", "bsf_local_transient_bundled", "1536157209", "yes");
INSERT INTO `myevntl_options` VALUES("271", "widget_presscore-portfolio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("272", "widget_presscore-photos", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("273", "widget_presscore-team", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("274", "widget_presscore-testimonials-list", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("275", "widget_presscore-testimonials-slider", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("276", "widget_presscore-logos", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("285", "revslider-valid-notice", "false", "yes");
INSERT INTO `myevntl_options` VALUES("277", "vc_version", "5.0.1", "yes");
INSERT INTO `myevntl_options` VALUES("297", "smile_fonts", "a:1:{s:8:\"Defaults\";a:4:{s:7:\"include\";s:20:\"smile_fonts/Defaults\";s:6:\"folder\";s:20:\"smile_fonts/Defaults\";s:5:\"style\";s:21:\"Defaults/Defaults.css\";s:6:\"config\";s:11:\"charmap.php\";}}", "yes");
INSERT INTO `myevntl_options` VALUES("303", "wp_less_stylesheet_data_a646f63a57e75161af925407b508db8d", "a:1:{s:10:\"target_uri\";s:92:\"http://www.myeventology.ph/wp-content/uploads/wp-less/myeventology/css/custom-caa5ac0913.css\";}", "yes");
INSERT INTO `myevntl_options` VALUES("306", "wp_less_stylesheet_data_166c3d2407c4b6520898a6b58af0ce68", "a:1:{s:10:\"target_uri\";s:91:\"http://www.myeventology.ph/wp-content/uploads/wp-less/myeventology/css/media-caa5ac0913.css\";}", "yes");
INSERT INTO `myevntl_options` VALUES("309", "wp_less_stylesheet_data_e5d304dfae091b2bbb334fbed831ab52", "a:1:{s:10:\"target_uri\";s:103:\"http://www.myeventology.ph/wp-content/uploads/wp-less/myeventology/css/post-type-dynamic-caa5ac0913.css\";}", "yes");
INSERT INTO `myevntl_options` VALUES("3952", "category_children", "a:0:{}", "yes");
INSERT INTO `myevntl_options` VALUES("3953", "dt_portfolio_category_children", "a:0:{}", "yes");
INSERT INTO `myevntl_options` VALUES("3954", "dt_gallery_category_children", "a:0:{}", "yes");
INSERT INTO `myevntl_options` VALUES("3955", "dt_team_category_children", "a:0:{}", "yes");
INSERT INTO `myevntl_options` VALUES("3956", "dt_testimonials_category_children", "a:0:{}", "yes");
INSERT INTO `myevntl_options` VALUES("3957", "dt_benefits_category_children", "a:0:{}", "yes");
INSERT INTO `myevntl_options` VALUES("3958", "dt_logos_category_children", "a:0:{}", "yes");
INSERT INTO `myevntl_options` VALUES("323", "the7_options_saved", "1", "no");
INSERT INTO `myevntl_options` VALUES("1620", "rs_obj_favorites", "a:12:{i:0;s:114:\"http://www.myeventology.ph/wp-content/plugins/revslider/public/assets/assets/svg/action/ic_camera_enhance_24px.svg\";i:1;s:112:\"http://www.myeventology.ph/wp-content/plugins/revslider/public/assets/assets/svg/action/ic_flip_to_back_24px.svg\";i:2;s:111:\"http://www.myeventology.ph/wp-content/plugins/revslider/public/assets/assets/svg/action/ic_flight_land_24px.svg\";i:3;s:16:\"object_dvd_1.png\";i:4;s:17:\"relax_hammock.jpg\";i:5;s:16:\"beach_houses.jpg\";i:6;s:17:\"forest_road_2.jpg\";i:7;s:18:\"object_plant_1.png\";i:8;s:16:\"object_pen_1.png\";i:9;s:13:\"fa-icon-glass\";i:10;s:13:\"fa-icon-music\";i:11;s:14:\"fa-icon-search\";}", "yes");
INSERT INTO `myevntl_options` VALUES("337", "rs_cache_overlay", "5.3.1.5", "yes");
INSERT INTO `myevntl_options` VALUES("268", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("134", "can_compress_scripts", "1", "no");
INSERT INTO `myevntl_options` VALUES("136", "recently_activated", "a:0:{}", "yes");
INSERT INTO `myevntl_options` VALUES("174", "the7_db_version", "4.1.1", "yes");
INSERT INTO `myevntl_options` VALUES("175", "the7_force_regen_css", "", "yes");
INSERT INTO `myevntl_options` VALUES("176", "the7_beautiful_loader_inline_css", "body #load {\n  display: block;\n  height: 100%;\n  overflow: hidden;\n  position: fixed;\n  width: 100%;\n  z-index: 9901;\n  opacity: 1;\n  visibility: visible;\n  -webkit-transition: all .35s ease-out;\n  transition: all .35s ease-out;\n}\nbody #load.loader-removed {\n  opacity: 0;\n  visibility: hidden;\n}\n.load-wrap {\n  width: 100%;\n  height: 100%;\n  background-position: center center;\n  background-repeat: no-repeat;\n  text-align: center;\n}\n.load-wrap > svg {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -ms-transform: translate(-50%,-50%);\n  -webkit-transform: translate(-50%,-50%);\n  transform: translate(-50%,-50%);\n}\n#load {\n  background-color: #ffffff;\n}\n.uil-default rect:not(.bk) {\n  fill: rgba(249,122,122,0.3);\n}\n.uil-ring > path {\n  fill: rgba(249,122,122,0.3);\n}\n.ring-loader .circle {\n  fill: rgba(249,122,122,0.3);\n}\n.ring-loader .moving-circle {\n  fill: #f97a7a;\n}\n.uil-hourglass .glass {\n  stroke: #f97a7a;\n}\n.uil-hourglass .sand {\n  fill: rgba(249,122,122,0.3);\n}\n.spinner-loader .load-wrap {\n  background-image: url(\"data:image/svg+xml,%3Csvg width=\'75px\' height=\'75px\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 100 100\' preserveAspectRatio=\'xMidYMid\' class=\'uil-default\'%3E%3Crect x=\'0\' y=\'0\' width=\'100\' height=\'100\' fill=\'none\' class=\'bk\'%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(0 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(30 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.08333333333333333s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(60 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.16666666666666666s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(90 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.25s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(120 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.3333333333333333s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(150 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.4166666666666667s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(180 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.5s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(210 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.5833333333333334s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(240 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.6666666666666666s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(270 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.75s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(300 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.8333333333333334s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\' transform=\'rotate(330 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.9166666666666666s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3C/svg%3E\");\n}\n.ring-loader .load-wrap {\n  background-image: url(\"data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 32 32\' width=\'72\' height=\'72\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\'%3E   %3Cpath opacity=\'.25\' d=\'M16 0 A16 16 0 0 0 16 32 A16 16 0 0 0 16 0 M16 4 A12 12 0 0 1 16 28 A12 12 0 0 1 16 4\'/%3E   %3Cpath d=\'M16 0 A16 16 0 0 1 32 16 L28 16 A12 12 0 0 0 16 4z\'%3E     %3CanimateTransform attributeName=\'transform\' type=\'rotate\' from=\'0 16 16\' to=\'360 16 16\' dur=\'0.8s\' repeatCount=\'indefinite\' /%3E   %3C/path%3E %3C/svg%3E\");\n}\n.hourglass-loader .load-wrap {\n  background-image: url(\"data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 32 32\' width=\'72\' height=\'72\' fill=\'rgba%28249%2C122%2C122%2C0.3%29\'%3E   %3Cpath transform=\'translate(2)\' d=\'M0 12 V20 H4 V12z\'%3E      %3Canimate attributeName=\'d\' values=\'M0 12 V20 H4 V12z; M0 4 V28 H4 V4z; M0 12 V20 H4 V12z; M0 12 V20 H4 V12z\' dur=\'1.2s\' repeatCount=\'indefinite\' begin=\'0\' keytimes=\'0;.2;.5;1\' keySplines=\'0.2 0.2 0.4 0.8;0.2 0.6 0.4 0.8;0.2 0.8 0.4 0.8\' calcMode=\'spline\'  /%3E   %3C/path%3E   %3Cpath transform=\'translate(8)\' d=\'M0 12 V20 H4 V12z\'%3E     %3Canimate attributeName=\'d\' values=\'M0 12 V20 H4 V12z; M0 4 V28 H4 V4z; M0 12 V20 H4 V12z; M0 12 V20 H4 V12z\' dur=\'1.2s\' repeatCount=\'indefinite\' begin=\'0.2\' keytimes=\'0;.2;.5;1\' keySplines=\'0.2 0.2 0.4 0.8;0.2 0.6 0.4 0.8;0.2 0.8 0.4 0.8\' calcMode=\'spline\'  /%3E   %3C/path%3E   %3Cpath transform=\'translate(14)\' d=\'M0 12 V20 H4 V12z\'%3E     %3Canimate attributeName=\'d\' values=\'M0 12 V20 H4 V12z; M0 4 V28 H4 V4z; M0 12 V20 H4 V12z; M0 12 V20 H4 V12z\' dur=\'1.2s\' repeatCount=\'indefinite\' begin=\'0.4\' keytimes=\'0;.2;.5;1\' keySplines=\'0.2 0.2 0.4 0.8;0.2 0.6 0.4 0.8;0.2 0.8 0.4 0.8\' calcMode=\'spline\' /%3E   %3C/path%3E   %3Cpath transform=\'translate(20)\' d=\'M0 12 V20 H4 V12z\'%3E     %3Canimate attributeName=\'d\' values=\'M0 12 V20 H4 V12z; M0 4 V28 H4 V4z; M0 12 V20 H4 V12z; M0 12 V20 H4 V12z\' dur=\'1.2s\' repeatCount=\'indefinite\' begin=\'0.6\' keytimes=\'0;.2;.5;1\' keySplines=\'0.2 0.2 0.4 0.8;0.2 0.6 0.4 0.8;0.2 0.8 0.4 0.8\' calcMode=\'spline\' /%3E   %3C/path%3E   %3Cpath transform=\'translate(26)\' d=\'M0 12 V20 H4 V12z\'%3E     %3Canimate attributeName=\'d\' values=\'M0 12 V20 H4 V12z; M0 4 V28 H4 V4z; M0 12 V20 H4 V12z; M0 12 V20 H4 V12z\' dur=\'1.2s\' repeatCount=\'indefinite\' begin=\'0.8\' keytimes=\'0;.2;.5;1\' keySplines=\'0.2 0.2 0.4 0.8;0.2 0.6 0.4 0.8;0.2 0.8 0.4 0.8\' calcMode=\'spline\' /%3E   %3C/path%3E %3C/svg%3E\");\n}\n", "yes");
INSERT INTO `myevntl_options` VALUES("177", "the7_style_version", "4.2.2.b1701171530", "yes");
INSERT INTO `myevntl_options` VALUES("165", "widget_presscore-contact-info-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("166", "widget_presscore-custom-menu-1", "a:3:{i:3;a:2:{s:5:\"title\";s:2:\" \";s:4:\"menu\";s:2:\"13\";}i:4;a:2:{s:5:\"title\";s:0:\"\";s:4:\"menu\";s:2:\"11\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("167", "widget_presscore-custom-menu-2", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("168", "widget_presscore-blog-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("169", "widget_presscore-blog-categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("170", "widget_presscore-progress-bars-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("171", "widget_presscore-contact-form-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("172", "widget_presscore-accordion-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("173", "dt_the7pt_installed_once", "yes", "yes");
INSERT INTO `myevntl_options` VALUES("180", "optionsframework", "a:2:{s:2:\"id\";s:22:\"myeventologychildtheme\";s:12:\"knownoptions\";a:1:{i:0;s:22:\"myeventologychildtheme\";}}", "yes");
INSERT INTO `myevntl_options` VALUES("181", "myeventologychildtheme", "a:723:{s:21:\"general-content_width\";s:6:\"1250px\";s:14:\"general-layout\";s:4:\"wide\";s:17:\"general-box_width\";s:6:\"1280px\";s:22:\"general-boxed_bg_color\";s:7:\"#ffffff\";s:22:\"general-boxed_bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:27:\"general-boxed_bg_fullscreen\";b:0;s:22:\"general-boxed_bg_fixed\";b:0;s:16:\"general-bg_color\";s:7:\"#ffffff\";s:18:\"general-bg_opacity\";i:100;s:16:\"general-bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:3:\"top\";}s:21:\"general-bg_fullscreen\";b:0;s:16:\"general-bg_fixed\";b:0;s:30:\"general-content_boxes_bg_color\";s:7:\"#f4f4f4\";s:32:\"general-content_boxes_bg_opacity\";i:100;s:32:\"general-content_boxes_decoration\";s:4:\"none\";s:46:\"general-content_boxes_decoration_outline_color\";s:7:\"#000000\";s:48:\"general-content_boxes_decoration_outline_opacity\";i:0;s:14:\"dividers-color\";s:7:\"#cccccc\";s:16:\"dividers-opacity\";i:50;s:25:\"general-accent_color_mode\";s:5:\"color\";s:23:\"general-accent_bg_color\";s:7:\"#f97a7a\";s:32:\"general-accent_bg_color_gradient\";a:2:{i:0;s:7:\"#0ca2e0\";i:1;s:7:\"#27dde8\";}s:21:\"general-border_radius\";i:0;s:26:\"general-contact_form_style\";s:7:\"minimal\";s:31:\"general-slideshow_bullets_style\";s:6:\"accent\";s:25:\"general-beautiful_loading\";s:8:\"disabled\";s:37:\"general-fullscreen_overlay_color_mode\";s:5:\"color\";s:32:\"general-fullscreen_overlay_color\";s:7:\"#ffffff\";s:35:\"general-fullscreen_overlay_gradient\";a:2:{i:0;s:7:\"#2edded\";i:1;s:7:\"#0084bb\";}s:34:\"general-fullscreen_overlay_opacity\";i:100;s:21:\"general-spinner_color\";s:7:\"#f97a7a\";s:23:\"general-spinner_opacity\";i:30;s:20:\"general-loader_style\";s:14:\"double_circles\";s:21:\"general-custom_loader\";s:0:\"\";s:6:\"preset\";s:7:\"skin11r\";s:13:\"header-layout\";s:6:\"inline\";s:28:\"header-classic-show_elements\";s:1:\"1\";s:26:\"header-classic-icons_style\";s:4:\"bold\";s:23:\"header-classic-elements\";a:4:{s:12:\"top_bar_left\";a:2:{i:0;s:11:\"custom_menu\";i:1;s:4:\"cart\";}s:13:\"top_bar_right\";a:1:{i:0;s:6:\"search\";}s:15:\"near_menu_right\";a:1:{i:0;s:12:\"social_icons\";}s:15:\"near_logo_right\";a:2:{i:0;s:5:\"phone\";i:1;s:5:\"email\";}}s:51:\"header-classic-elements-near_menu_right-padding-top\";i:0;s:53:\"header-classic-elements-near_menu_right-padding-right\";i:0;s:54:\"header-classic-elements-near_menu_right-padding-bottom\";i:0;s:52:\"header-classic-elements-near_menu_right-padding-left\";i:40;s:50:\"header-classic-elements-near_logo_left-padding-top\";i:0;s:52:\"header-classic-elements-near_logo_left-padding-right\";i:0;s:53:\"header-classic-elements-near_logo_left-padding-bottom\";i:0;s:51:\"header-classic-elements-near_logo_left-padding-left\";i:0;s:51:\"header-classic-elements-near_logo_right-padding-top\";i:0;s:53:\"header-classic-elements-near_logo_right-padding-right\";i:0;s:54:\"header-classic-elements-near_logo_right-padding-bottom\";i:0;s:52:\"header-classic-elements-near_logo_right-padding-left\";i:0;s:27:\"header-inline-show_elements\";s:1:\"0\";s:25:\"header-inline-icons_style\";s:4:\"bold\";s:22:\"header-inline-elements\";a:0:{}s:50:\"header-inline-elements-near_menu_right-padding-top\";i:0;s:52:\"header-inline-elements-near_menu_right-padding-right\";i:0;s:53:\"header-inline-elements-near_menu_right-padding-bottom\";i:0;s:51:\"header-inline-elements-near_menu_right-padding-left\";i:0;s:26:\"header-split-show_elements\";s:1:\"1\";s:24:\"header-split-icons_style\";s:4:\"bold\";s:21:\"header-split-elements\";a:2:{s:14:\"near_menu_left\";a:1:{i:0;s:6:\"search\";}s:15:\"near_menu_right\";a:1:{i:0;s:4:\"cart\";}}s:48:\"header-split-elements-near_menu_left-padding-top\";i:0;s:50:\"header-split-elements-near_menu_left-padding-right\";i:20;s:51:\"header-split-elements-near_menu_left-padding-bottom\";i:0;s:49:\"header-split-elements-near_menu_left-padding-left\";i:20;s:49:\"header-split-elements-near_menu_right-padding-top\";i:0;s:51:\"header-split-elements-near_menu_right-padding-right\";i:20;s:52:\"header-split-elements-near_menu_right-padding-bottom\";i:0;s:50:\"header-split-elements-near_menu_right-padding-left\";i:20;s:25:\"header-side-show_elements\";s:1:\"1\";s:23:\"header-side-icons_style\";s:4:\"bold\";s:20:\"header-side-elements\";a:1:{s:10:\"below_menu\";a:3:{i:0;s:12:\"social_icons\";i:1;s:5:\"email\";i:2;s:5:\"skype\";}}s:43:\"header-side-elements-below_menu-padding-top\";i:0;s:45:\"header-side-elements-below_menu-padding-right\";i:35;s:46:\"header-side-elements-below_menu-padding-bottom\";i:0;s:44:\"header-side-elements-below_menu-padding-left\";i:35;s:30:\"header-slide_out-show_elements\";s:1:\"1\";s:28:\"header-slide_out-icons_style\";s:4:\"bold\";s:25:\"header-slide_out-elements\";a:1:{s:13:\"side_top_line\";a:3:{i:0;s:5:\"phone\";i:1;s:5:\"email\";i:2;s:5:\"skype\";}}s:46:\"header-slide_out-elements-top_line-padding-top\";i:0;s:48:\"header-slide_out-elements-top_line-padding-right\";i:40;s:49:\"header-slide_out-elements-top_line-padding-bottom\";i:0;s:47:\"header-slide_out-elements-top_line-padding-left\";i:40;s:48:\"header-slide_out-elements-below_menu-padding-top\";i:0;s:50:\"header-slide_out-elements-below_menu-padding-right\";i:0;s:51:\"header-slide_out-elements-below_menu-padding-bottom\";i:0;s:49:\"header-slide_out-elements-below_menu-padding-left\";i:0;s:28:\"header-overlay-show_elements\";s:1:\"1\";s:26:\"header-overlay-icons_style\";s:4:\"bold\";s:23:\"header-overlay-elements\";a:2:{s:10:\"below_menu\";a:2:{i:0;s:6:\"search\";i:1;s:4:\"cart\";}s:13:\"side_top_line\";a:3:{i:0;s:12:\"social_icons\";i:1;s:9:\"text_area\";i:2;s:5:\"phone\";}}s:44:\"header-overlay-elements-top_line-padding-top\";i:0;s:46:\"header-overlay-elements-top_line-padding-right\";i:40;s:47:\"header-overlay-elements-top_line-padding-bottom\";i:0;s:45:\"header-overlay-elements-top_line-padding-left\";i:40;s:46:\"header-overlay-elements-below_menu-padding-top\";i:0;s:48:\"header-overlay-elements-below_menu-padding-right\";i:0;s:49:\"header-overlay-elements-below_menu-padding-bottom\";i:0;s:47:\"header-overlay-elements-below_menu-padding-left\";i:0;s:28:\"header-classic-logo-position\";s:4:\"left\";s:28:\"header-classic-menu-position\";s:4:\"left\";s:30:\"header-classic-menu-margin-top\";i:0;s:33:\"header-classic-menu-margin-bottom\";i:0;s:21:\"header-classic-height\";i:180;s:27:\"header-classic-is_fullwidth\";s:1:\"0\";s:27:\"header-inline-menu-position\";s:5:\"right\";s:20:\"header-inline-height\";i:100;s:26:\"header-inline-is_fullwidth\";s:1:\"0\";s:26:\"header-split-menu-position\";s:7:\"outside\";s:19:\"header-split-height\";i:100;s:25:\"header-split-is_fullwidth\";s:1:\"0\";s:20:\"header-side-position\";s:5:\"right\";s:17:\"header-side-width\";s:5:\"300px\";s:25:\"header-side-content-width\";s:5:\"300px\";s:28:\"header-side-content-position\";s:6:\"center\";s:31:\"header-side-content-padding-top\";i:50;s:33:\"header-side-content-padding-right\";i:0;s:34:\"header-side-content-padding-bottom\";i:40;s:32:\"header-side-content-padding-left\";i:0;s:25:\"header-side-menu-position\";s:5:\"v_top\";s:25:\"header-side-logo-position\";s:6:\"inside\";s:28:\"header-side-menu-padding-top\";i:50;s:31:\"header-side-menu-padding-bottom\";i:50;s:32:\"header-side-menu-items_alignment\";s:6:\"center\";s:27:\"header-side-menu-items_link\";s:9:\"fullwidth\";s:23:\"header-slide_out-layout\";s:9:\"menu_icon\";s:52:\"header-slide_out-layout-menu_icon-show_floating_logo\";s:1:\"1\";s:39:\"header-slide_out-layout-top_line-height\";i:90;s:45:\"header-slide_out-layout-top_line-is_fullwidth\";s:1:\"1\";s:46:\"header-slide_out-layout-top_line-logo-position\";s:4:\"left\";s:39:\"header-slide_out-layout-side_line-width\";i:60;s:42:\"header-slide_out-layout-side_line-position\";s:5:\"under\";s:25:\"header-slide_out-position\";s:4:\"left\";s:34:\"header-slide_out-overlay-animation\";s:4:\"fade\";s:22:\"header-slide_out-width\";s:5:\"400px\";s:30:\"header-slide_out-content-width\";s:5:\"350px\";s:33:\"header-slide_out-content-position\";s:6:\"center\";s:36:\"header-slide_out-content-padding-top\";i:50;s:38:\"header-slide_out-content-padding-right\";i:0;s:39:\"header-slide_out-content-padding-bottom\";i:50;s:37:\"header-slide_out-content-padding-left\";i:0;s:30:\"header-slide_out-menu-position\";s:5:\"v_top\";s:30:\"header-slide_out-logo-position\";s:12:\"fully_inside\";s:33:\"header-slide_out-menu-padding-top\";i:40;s:36:\"header-slide_out-menu-padding-bottom\";i:40;s:37:\"header-slide_out-menu-items_alignment\";s:6:\"center\";s:32:\"header-slide_out-menu-items_link\";s:9:\"fullwidth\";s:21:\"header-overlay-layout\";s:9:\"menu_icon\";s:50:\"header-overlay-layout-menu_icon-show_floating_logo\";s:1:\"1\";s:37:\"header-overlay-layout-top_line-height\";i:130;s:43:\"header-overlay-layout-top_line-is_fullwidth\";s:1:\"0\";s:44:\"header-overlay-layout-top_line-logo-position\";s:4:\"left\";s:37:\"header-overlay-layout-side_line-width\";i:60;s:28:\"header-overlay-content-width\";s:5:\"300px\";s:31:\"header-overlay-content-position\";s:6:\"center\";s:34:\"header-overlay-content-padding-top\";i:0;s:36:\"header-overlay-content-padding-right\";i:0;s:37:\"header-overlay-content-padding-bottom\";i:0;s:35:\"header-overlay-content-padding-left\";i:0;s:28:\"header-overlay-menu-position\";s:8:\"v_center\";s:28:\"header-overlay-logo-position\";s:12:\"fully_inside\";s:31:\"header-overlay-menu-padding-top\";i:40;s:34:\"header-overlay-menu-padding-bottom\";i:40;s:35:\"header-overlay-menu-items_alignment\";s:6:\"center\";s:30:\"header-overlay-menu-items_link\";s:9:\"fullwidth\";s:19:\"top_bar-font-family\";s:9:\"Open Sans\";s:17:\"top_bar-font-size\";i:13;s:27:\"top_bar-font-is_capitalized\";b:0;s:18:\"top_bar-font-color\";s:7:\"#ffffff\";s:20:\"top_bar-paddings-top\";i:0;s:23:\"top_bar-paddings-bottom\";i:0;s:27:\"top_bar-paddings-horizontal\";i:0;s:16:\"top_bar-bg-style\";s:12:\"content_line\";s:16:\"top_bar-bg-color\";s:7:\"#ffffff\";s:18:\"top_bar-bg-opacity\";i:15;s:16:\"top_bar-bg-image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:15:\"header-bg-color\";s:7:\"#232323\";s:17:\"header-bg-opacity\";i:100;s:15:\"header-bg-image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:23:\"header-bg-is_fullscreen\";b:0;s:18:\"header-bg-is_fixed\";b:0;s:17:\"header-decoration\";s:8:\"disabled\";s:23:\"header-decoration-color\";s:7:\"#dd3333\";s:25:\"header-decoration-opacity\";i:100;s:28:\"header-classic-menu-bg-style\";s:5:\"solid\";s:28:\"header-classic-menu-bg-color\";s:7:\"#000000\";s:30:\"header-classic-menu-bg-opacity\";i:100;s:21:\"header-menu_icon-size\";s:6:\"medium\";s:22:\"header-menu_icon-color\";s:7:\"#000000\";s:25:\"header-menu_icon-bg-color\";s:7:\"#ffffff\";s:27:\"header-menu_icon-bg-opacity\";i:75;s:28:\"header-menu_icon-hover-color\";s:7:\"#000000\";s:31:\"header-menu_icon-hover-bg-color\";s:7:\"#ffffff\";s:33:\"header-menu_icon-hover-bg-opacity\";i:75;s:27:\"header-menu_icon-margin-top\";i:0;s:29:\"header-menu_icon-margin-right\";i:0;s:30:\"header-menu_icon-margin-bottom\";i:0;s:28:\"header-menu_icon-margin-left\";i:0;s:24:\"header-menu_icon-bg-size\";i:54;s:33:\"header-menu_icon-bg-border-radius\";i:0;s:23:\"header-mixed-decoration\";s:6:\"shadow\";s:29:\"header-mixed-decoration-color\";s:7:\"#dd9933\";s:31:\"header-mixed-decoration-opacity\";i:100;s:21:\"header-mixed-bg-color\";s:7:\"#ffffff\";s:23:\"header-mixed-bg-opacity\";i:100;s:39:\"header-slide_out-overlay-bg-color-style\";s:5:\"color\";s:33:\"header-slide_out-overlay-bg-color\";s:7:\"#232323\";s:36:\"header-slide_out-overlay-bg-gradient\";a:2:{i:0;s:7:\"#cdb7e2\";i:1;s:7:\"#821482\";}s:35:\"header-slide_out-overlay-bg-opacity\";i:40;s:29:\"header-slide_out-overlay-blur\";s:1:\"0\";s:33:\"header-slide_out-overlay-x_cursor\";s:1:\"1\";s:39:\"header-slide_out-overlay-x_cursor-color\";s:7:\"#ffffff\";s:41:\"header-slide_out-overlay-x_cursor-opacity\";i:100;s:23:\"header-menu-font-family\";s:10:\"Roboto:700\";s:21:\"header-menu-font-size\";i:16;s:31:\"header-menu-font-is_capitalized\";s:1:\"1\";s:32:\"header-menu-subtitle-font-family\";s:15:\"Arial:400italic\";s:30:\"header-menu-subtitle-font-size\";i:11;s:22:\"header-menu-font-color\";s:7:\"#ffffff\";s:34:\"header-menu-hover-font-color-style\";s:6:\"accent\";s:28:\"header-menu-hover-font-color\";s:7:\"#ffffff\";s:31:\"header-menu-hover-font-gradient\";a:2:{i:0;s:7:\"#8224e3\";i:1;s:7:\"#751257\";}s:40:\"header-menu-active_item-font-color-style\";s:6:\"accent\";s:34:\"header-menu-active_item-font-color\";s:7:\"#ffffff\";s:37:\"header-menu-active_item-font-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:21:\"header-menu-icon-size\";i:14;s:31:\"header-menu-show_next_lvl_icons\";s:1:\"1\";s:28:\"header-menu-item-padding-top\";i:5;s:30:\"header-menu-item-padding-right\";i:10;s:31:\"header-menu-item-padding-bottom\";i:5;s:29:\"header-menu-item-padding-left\";i:10;s:27:\"header-menu-item-margin-top\";i:10;s:29:\"header-menu-item-margin-right\";i:4;s:30:\"header-menu-item-margin-bottom\";i:10;s:28:\"header-menu-item-margin-left\";i:6;s:39:\"header-menu-item-surround_margins-style\";s:8:\"disabled\";s:47:\"header-menu-item-surround_margins-custom-margin\";i:30;s:47:\"header-menu-decoration-other-links-is_justified\";s:1:\"0\";s:25:\"header-menu-show_dividers\";s:1:\"0\";s:33:\"header-menu-dividers-height-style\";s:6:\"custom\";s:27:\"header-menu-dividers-height\";i:28;s:29:\"header-menu-dividers-surround\";s:1:\"0\";s:26:\"header-menu-dividers-color\";s:7:\"#ffffff\";s:28:\"header-menu-dividers-opacity\";i:100;s:28:\"header-menu-decoration-style\";s:4:\"none\";s:42:\"header-menu-decoration-underline-direction\";s:7:\"upwards\";s:44:\"header-menu-decoration-underline-color-style\";s:6:\"accent\";s:38:\"header-menu-decoration-underline-color\";s:7:\"#ffffff\";s:41:\"header-menu-decoration-underline-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:42:\"header-menu-decoration-underline-line_size\";s:1:\"2\";s:40:\"header-menu-decoration-other-hover-style\";s:10:\"background\";s:46:\"header-menu-decoration-other-hover-color-style\";s:5:\"color\";s:40:\"header-menu-decoration-other-hover-color\";s:7:\"#ffffff\";s:43:\"header-menu-decoration-other-hover-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:36:\"header-menu-decoration-other-opacity\";i:0;s:39:\"header-menu-decoration-other-hover-line\";s:1:\"0\";s:51:\"header-menu-decoration-other-hover-line-color-style\";s:8:\"gradient\";s:45:\"header-menu-decoration-other-hover-line-color\";s:7:\"#dd3333\";s:48:\"header-menu-decoration-other-hover-line-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:47:\"header-menu-decoration-other-hover-line-opacity\";i:23;s:41:\"header-menu-decoration-other-active-style\";s:10:\"background\";s:47:\"header-menu-decoration-other-active-color-style\";s:5:\"color\";s:41:\"header-menu-decoration-other-active-color\";s:7:\"#ffffff\";s:44:\"header-menu-decoration-other-active-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:43:\"header-menu-decoration-other-active-opacity\";i:0;s:40:\"header-menu-decoration-other-active-line\";s:1:\"0\";s:52:\"header-menu-decoration-other-active-line-color-style\";s:5:\"color\";s:46:\"header-menu-decoration-other-active-line-color\";s:7:\"#8224e3\";s:49:\"header-menu-decoration-other-active-line-gradient\";a:2:{i:0;s:7:\"#dd3333\";i:1;s:7:\"#81d742\";}s:48:\"header-menu-decoration-other-active-line-opacity\";i:30;s:40:\"header-menu-decoration-other-click_decor\";s:1:\"1\";s:52:\"header-menu-decoration-other-click_decor-color-style\";s:5:\"color\";s:46:\"header-menu-decoration-other-click_decor-color\";s:7:\"#ffffff\";s:49:\"header-menu-decoration-other-click_decor-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:48:\"header-menu-decoration-other-click_decor-opacity\";i:20;s:42:\"header-menu-decoration-other-border-radius\";i:3;s:38:\"header-menu-decoration-other-line_size\";s:1:\"2\";s:31:\"header-menu-submenu-font-family\";s:13:\"Open Sans:600\";s:29:\"header-menu-submenu-font-size\";i:15;s:37:\"header-menu-submenu-font-is_uppercase\";b:0;s:40:\"header-menu-submenu-subtitle-font-family\";s:15:\"Arial:400italic\";s:38:\"header-menu-submenu-subtitle-font-size\";i:10;s:30:\"header-menu-submenu-font-color\";s:7:\"#262b2e\";s:42:\"header-menu-submenu-hover-font-color-style\";s:6:\"accent\";s:36:\"header-menu-submenu-hover-font-color\";s:7:\"#895cb8\";s:39:\"header-menu-submenu-hover-font-gradient\";a:2:{i:0;s:7:\"#81d742\";i:1;s:7:\"#eeee22\";}s:43:\"header-menu-submenu-active-font-color-style\";s:6:\"accent\";s:37:\"header-menu-submenu-active-font-color\";s:7:\"#ffffff\";s:40:\"header-menu-submenu-active-font-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:29:\"header-menu-submenu-icon-size\";i:14;s:39:\"header-menu-submenu-show_next_lvl_icons\";b:0;s:39:\"header-menu-submenu-parent_is_clickable\";s:1:\"1\";s:36:\"header-menu-submenu-item-padding-top\";i:8;s:38:\"header-menu-submenu-item-padding-right\";i:10;s:39:\"header-menu-submenu-item-padding-bottom\";i:8;s:37:\"header-menu-submenu-item-padding-left\";i:10;s:35:\"header-menu-submenu-item-margin-top\";i:0;s:37:\"header-menu-submenu-item-margin-right\";i:0;s:38:\"header-menu-submenu-item-margin-bottom\";i:0;s:36:\"header-menu-submenu-item-margin-left\";i:0;s:28:\"header-menu-submenu-bg-color\";s:7:\"#ffffff\";s:30:\"header-menu-submenu-bg-opacity\";i:100;s:28:\"header-menu-submenu-bg-width\";i:260;s:28:\"header-menu-submenu-bg-hover\";s:10:\"background\";s:33:\"header-side-menu-submenu-position\";s:4:\"down\";s:37:\"header-elements-near_menu-font_family\";s:10:\"Roboto:700\";s:35:\"header-elements-near_menu-font_size\";i:18;s:36:\"header-elements-near_menu-font_color\";s:7:\"#ffffff\";s:37:\"header-elements-near_logo-font_family\";s:13:\"Open Sans:600\";s:35:\"header-elements-near_logo-font_size\";i:14;s:36:\"header-elements-near_logo-font_color\";s:7:\"#393940\";s:30:\"header-elements-search-caption\";s:0:\"\";s:27:\"header-elements-search-icon\";s:1:\"1\";s:34:\"header-elements-search-on-desktops\";s:4:\"show\";s:42:\"header-elements-search-first-header-switch\";s:9:\"near_logo\";s:43:\"header-elements-search-second-header-switch\";s:9:\"near_logo\";s:39:\"header-elements-contact-address-caption\";s:44:\"8500 Beverly Boulevard Los Angeles, CA 90048\";s:36:\"header-elements-contact-address-icon\";s:1:\"1\";s:43:\"header-elements-contact-address-on-desktops\";s:4:\"show\";s:51:\"header-elements-contact-address-first-header-switch\";s:9:\"near_logo\";s:52:\"header-elements-contact-address-second-header-switch\";s:7:\"in_menu\";s:37:\"header-elements-contact-phone-caption\";s:15:\"(6332) 406.6692\";s:34:\"header-elements-contact-phone-icon\";s:1:\"1\";s:41:\"header-elements-contact-phone-on-desktops\";s:4:\"show\";s:49:\"header-elements-contact-phone-first-header-switch\";s:9:\"near_logo\";s:50:\"header-elements-contact-phone-second-header-switch\";s:7:\"in_menu\";s:37:\"header-elements-contact-email-caption\";s:18:\"sales@yoursite.com\";s:34:\"header-elements-contact-email-icon\";s:1:\"1\";s:41:\"header-elements-contact-email-on-desktops\";s:4:\"show\";s:49:\"header-elements-contact-email-first-header-switch\";s:9:\"near_logo\";s:50:\"header-elements-contact-email-second-header-switch\";s:7:\"in_menu\";s:37:\"header-elements-contact-skype-caption\";s:10:\"Your_Skype\";s:34:\"header-elements-contact-skype-icon\";s:1:\"1\";s:41:\"header-elements-contact-skype-on-desktops\";s:4:\"show\";s:49:\"header-elements-contact-skype-first-header-switch\";s:9:\"near_logo\";s:50:\"header-elements-contact-skype-second-header-switch\";s:7:\"in_menu\";s:37:\"header-elements-contact-clock-caption\";s:32:\"Monday – Friday 10 AM – 8 PM\";s:34:\"header-elements-contact-clock-icon\";s:1:\"1\";s:41:\"header-elements-contact-clock-on-desktops\";s:4:\"show\";s:49:\"header-elements-contact-clock-first-header-switch\";s:9:\"near_logo\";s:50:\"header-elements-contact-clock-second-header-switch\";s:7:\"in_menu\";s:29:\"header-elements-login-caption\";s:5:\"Login\";s:30:\"header-elements-logout-caption\";s:6:\"Logout\";s:26:\"header-elements-login-icon\";s:1:\"1\";s:33:\"header-elements-login-on-desktops\";s:4:\"show\";s:41:\"header-elements-login-first-header-switch\";s:9:\"near_logo\";s:42:\"header-elements-login-second-header-switch\";s:7:\"in_menu\";s:25:\"header-elements-login-url\";s:22:\"http://themeforest.net\";s:32:\"header-elements-text-on-desktops\";s:4:\"show\";s:40:\"header-elements-text-first-header-switch\";s:9:\"near_logo\";s:41:\"header-elements-text-second-header-switch\";s:7:\"in_menu\";s:20:\"header-elements-text\";s:35:\"Some call to action text goes here!\";s:34:\"header-elements-text-2-on-desktops\";s:4:\"show\";s:42:\"header-elements-text-2-first-header-switch\";s:9:\"near_logo\";s:43:\"header-elements-text-2-second-header-switch\";s:7:\"in_menu\";s:22:\"header-elements-text-2\";s:35:\"Some call to action text goes here!\";s:34:\"header-elements-text-3-on-desktops\";s:4:\"show\";s:42:\"header-elements-text-3-first-header-switch\";s:9:\"near_logo\";s:43:\"header-elements-text-3-second-header-switch\";s:7:\"in_menu\";s:22:\"header-elements-text-3\";s:35:\"Some call to action text goes here!\";s:32:\"header-elements-menu-on-desktops\";s:4:\"show\";s:40:\"header-elements-menu-first-header-switch\";s:9:\"near_logo\";s:41:\"header-elements-menu-second-header-switch\";s:6:\"hidden\";s:26:\"header-elements-menu-style\";s:8:\"dropdown\";s:37:\"header-elements-soc_icons-on-desktops\";s:4:\"show\";s:45:\"header-elements-soc_icons-first-header-switch\";s:9:\"near_logo\";s:46:\"header-elements-soc_icons-second-header-switch\";s:7:\"in_menu\";s:31:\"header-elements-soc_icons-color\";s:7:\"#a9abac\";s:28:\"header-elements-soc_icons-bg\";s:5:\"color\";s:34:\"header-elements-soc_icons-bg-color\";s:7:\"#ffffff\";s:36:\"header-elements-soc_icons-bg-opacity\";i:100;s:37:\"header-elements-soc_icons-bg-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:37:\"header-elements-soc_icons-hover-color\";s:7:\"#ffffff\";s:34:\"header-elements-soc_icons-hover-bg\";s:6:\"accent\";s:40:\"header-elements-soc_icons-hover-bg-color\";s:7:\"#ffffff\";s:42:\"header-elements-soc_icons-bg-hover-opacity\";i:100;s:43:\"header-elements-soc_icons-hover-bg-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:25:\"header-elements-soc_icons\";a:3:{i:1;a:2:{s:4:\"icon\";s:8:\"facebook\";s:3:\"url\";s:63:\"https://www.facebook.com/people/MyEventology-Co/100009288364941\";}i:2;a:2:{s:4:\"icon\";s:7:\"twitter\";s:3:\"url\";s:1:\"#\";}i:3;a:2:{s:4:\"icon\";s:9:\"instagram\";s:3:\"url\";s:1:\"#\";}}s:31:\"header-show_floating_navigation\";s:1:\"1\";s:32:\"header-floating_navigation-style\";s:5:\"slide\";s:37:\"header-floating_navigation-show_after\";i:140;s:33:\"header-floating_navigation-height\";i:70;s:35:\"header-floating_navigation-bg-color\";s:7:\"#000000\";s:37:\"header-floating_navigation-bg-opacity\";i:90;s:37:\"header-floating_navigation-decoration\";s:8:\"disabled\";s:43:\"header-floating_navigation-decoration-color\";s:7:\"#dd3333\";s:45:\"header-floating_navigation-decoration-opacity\";i:100;s:32:\"header-mobile-first_switch-after\";i:1050;s:33:\"header-mobile-first_switch-layout\";s:10:\"right_left\";s:33:\"header-mobile-first_switch-height\";i:70;s:33:\"header-mobile-second_switch-after\";i:1050;s:34:\"header-mobile-second_switch-layout\";s:11:\"left_center\";s:34:\"header-mobile-second_switch-height\";i:60;s:33:\"header-mobile-floating_navigation\";s:6:\"sticky\";s:30:\"header-mobile-menu-font-family\";s:10:\"Roboto:700\";s:28:\"header-mobile-menu-font-size\";i:16;s:38:\"header-mobile-menu-font-is_capitalized\";s:1:\"1\";s:33:\"header-mobile-submenu-font-family\";s:10:\"Roboto:700\";s:31:\"header-mobile-submenu-font-size\";i:16;s:41:\"header-mobile-submenu-font-is_capitalized\";b:0;s:29:\"header-mobile-menu-font-color\";s:7:\"#232323\";s:41:\"header-mobile-menu-font-hover-color-style\";s:6:\"accent\";s:35:\"header-mobile-menu-font-hover-color\";s:7:\"#3c3e45\";s:38:\"header-mobile-menu-font-hover-gradient\";a:2:{i:0;s:7:\"#b78ce2\";i:1;s:7:\"#1e73be\";}s:27:\"header-mobile-menu-bg-color\";s:7:\"#ffffff\";s:29:\"header-mobile-menu-bg-opacity\";i:100;s:27:\"header-mobile-menu-bg-width\";i:330;s:24:\"header-mobile-menu-align\";s:4:\"left\";s:19:\"header-logo_regular\";a:2:{i:0;s:49:\"/wp-content/uploads/2017/03/MyEventology-logo.png\";i:1;i:1251;}s:14:\"header-logo_hd\";a:2:{i:0;s:49:\"/wp-content/uploads/2017/03/MyEventology-logo.png\";i:1;i:1251;}s:23:\"header-logo-padding-top\";i:0;s:25:\"header-logo-padding-right\";i:10;s:26:\"header-logo-padding-bottom\";i:0;s:24:\"header-logo-padding-left\";i:0;s:37:\"header-style-transparent-logo_regular\";a:2:{i:0;s:49:\"/wp-content/uploads/2017/03/MyEventology-logo.png\";i:1;i:1251;}s:32:\"header-style-transparent-logo_hd\";a:2:{i:0;s:49:\"/wp-content/uploads/2017/03/MyEventology-logo.png\";i:1;i:1251;}s:41:\"header-style-transparent-logo-padding-top\";i:0;s:43:\"header-style-transparent-logo-padding-right\";i:10;s:44:\"header-style-transparent-logo-padding-bottom\";i:0;s:42:\"header-style-transparent-logo-padding-left\";i:0;s:31:\"header-style-mixed-logo_regular\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:26:\"header-style-mixed-logo_hd\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:35:\"header-style-mixed-logo-padding-top\";i:0;s:37:\"header-style-mixed-logo-padding-right\";i:0;s:38:\"header-style-mixed-logo-padding-bottom\";i:0;s:36:\"header-style-mixed-logo-padding-left\";i:0;s:33:\"header-style-floating-choose_logo\";s:6:\"custom\";s:34:\"header-style-floating-logo_regular\";a:2:{i:0;s:56:\"/wp-content/uploads/2017/03/Eventology-logo-sticky-1.png\";i:1;i:1248;}s:29:\"header-style-floating-logo_hd\";a:2:{i:0;s:56:\"/wp-content/uploads/2017/03/Eventology-logo-sticky-1.png\";i:1;i:1248;}s:38:\"header-style-floating-logo-padding-top\";i:0;s:40:\"header-style-floating-logo-padding-right\";i:10;s:41:\"header-style-floating-logo-padding-bottom\";i:0;s:39:\"header-style-floating-logo-padding-left\";i:0;s:31:\"header-mobile-first_switch-logo\";s:7:\"desktop\";s:32:\"header-mobile-second_switch-logo\";s:7:\"desktop\";s:32:\"header-style-mobile-logo_regular\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:27:\"header-style-mobile-logo_hd\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:36:\"header-style-mobile-logo-padding-top\";i:0;s:38:\"header-style-mobile-logo-padding-right\";i:0;s:39:\"header-style-mobile-logo-padding-bottom\";i:0;s:37:\"header-style-mobile-logo-padding-left\";i:0;s:23:\"bottom_bar-logo_regular\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:18:\"bottom_bar-logo_hd\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:27:\"bottom_bar-logo-padding-top\";i:7;s:29:\"bottom_bar-logo-padding-right\";i:20;s:30:\"bottom_bar-logo-padding-bottom\";i:7;s:28:\"bottom_bar-logo-padding-left\";i:0;s:15:\"general-favicon\";s:35:\"/wp-content/uploads/2017/03/fav.png\";s:18:\"general-favicon_hd\";s:35:\"/wp-content/uploads/2017/03/fav.png\";s:32:\"general-handheld_icon-old_iphone\";s:0:\"\";s:30:\"general-handheld_icon-old_ipad\";s:0:\"\";s:35:\"general-handheld_icon-retina_iphone\";s:0:\"\";s:33:\"general-handheld_icon-retina_ipad\";s:0:\"\";s:21:\"bottom_bar-copyrights\";s:45:\"© 2018 MyEventology Co. All rights reserved.\";s:18:\"bottom_bar-credits\";b:0;s:22:\"stripes-stripe_1_color\";s:7:\"#f4f4f4\";s:25:\"stripes-stripe_1_bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:24:\"stripes-stripe_1_outline\";s:4:\"hide\";s:30:\"stripes-stripe_1_outline_color\";s:7:\"#44bb70\";s:32:\"stripes-stripe_1_outline_opacity\";i:100;s:39:\"stripes-stripe_1_content_boxes_bg_color\";s:7:\"#ffffff\";s:41:\"stripes-stripe_1_content_boxes_bg_opacity\";i:100;s:41:\"stripes-stripe_1_content_boxes_decoration\";s:4:\"none\";s:55:\"stripes-stripe_1_content_boxes_decoration_outline_color\";s:7:\"#dd3333\";s:57:\"stripes-stripe_1_content_boxes_decoration_outline_opacity\";i:100;s:30:\"stripes-stripe_1_headers_color\";s:7:\"#232323\";s:27:\"stripes-stripe_1_text_color\";s:7:\"#7f7f7f\";s:22:\"stripes-stripe_2_color\";s:7:\"#f4f4f4\";s:25:\"stripes-stripe_2_bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:24:\"stripes-stripe_2_outline\";s:4:\"hide\";s:30:\"stripes-stripe_2_outline_color\";s:7:\"#ffffff\";s:32:\"stripes-stripe_2_outline_opacity\";i:15;s:39:\"stripes-stripe_2_content_boxes_bg_color\";s:7:\"#ffffff\";s:41:\"stripes-stripe_2_content_boxes_bg_opacity\";i:100;s:41:\"stripes-stripe_2_content_boxes_decoration\";s:4:\"none\";s:55:\"stripes-stripe_2_content_boxes_decoration_outline_color\";s:7:\"#ffffff\";s:57:\"stripes-stripe_2_content_boxes_decoration_outline_opacity\";i:15;s:30:\"stripes-stripe_2_headers_color\";s:7:\"#232323\";s:27:\"stripes-stripe_2_text_color\";s:7:\"#7f7f7f\";s:22:\"stripes-stripe_3_color\";s:7:\"#232323\";s:25:\"stripes-stripe_3_bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:24:\"stripes-stripe_3_outline\";s:4:\"hide\";s:30:\"stripes-stripe_3_outline_color\";s:7:\"#252728\";s:32:\"stripes-stripe_3_outline_opacity\";i:100;s:39:\"stripes-stripe_3_content_boxes_bg_color\";s:7:\"#FFFFFF\";s:41:\"stripes-stripe_3_content_boxes_bg_opacity\";i:10;s:41:\"stripes-stripe_3_content_boxes_decoration\";s:6:\"shadow\";s:55:\"stripes-stripe_3_content_boxes_decoration_outline_color\";s:7:\"#ffffff\";s:57:\"stripes-stripe_3_content_boxes_decoration_outline_opacity\";i:15;s:30:\"stripes-stripe_3_headers_color\";s:7:\"#ffffff\";s:27:\"stripes-stripe_3_text_color\";s:7:\"#ffffff\";s:13:\"sidebar-width\";i:28;s:25:\"sidebar-vertical_distance\";i:50;s:20:\"sidebar-visual_style\";s:13:\"with_dividers\";s:24:\"sidebar-divider-vertical\";s:1:\"0\";s:26:\"sidebar-divider-horizontal\";s:1:\"0\";s:16:\"sidebar-bg_color\";s:7:\"#f4f4f4\";s:18:\"sidebar-bg_opacity\";i:100;s:16:\"sidebar-bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:18:\"sidebar-decoration\";s:4:\"none\";s:32:\"sidebar-decoration_outline_color\";s:7:\"#000000\";s:34:\"sidebar-decoration_outline_opacity\";i:6;s:21:\"sidebar-headers_color\";s:7:\"#232323\";s:26:\"sidebar-primary_text_color\";s:7:\"#7f7f7f\";s:12:\"footer-style\";s:16:\"solid_background\";s:15:\"footer-bg_color\";s:7:\"#232323\";s:17:\"footer-bg_opacity\";i:100;s:17:\"footer-decoration\";s:4:\"none\";s:31:\"footer-decoration_outline_color\";s:7:\"#81d742\";s:33:\"footer-decoration_outline_opacity\";i:96;s:15:\"footer-bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:3:\"top\";}s:21:\"footer-slide-out-mode\";s:1:\"0\";s:20:\"footer-headers_color\";s:7:\"#ffffff\";s:25:\"footer-primary_text_color\";s:7:\"#8e8e8e\";s:18:\"footer-padding-top\";i:0;s:21:\"footer-padding-bottom\";i:10;s:23:\"footer-paddings-columns\";i:25;s:13:\"footer-layout\";s:11:\"1/2+1/4+1/4\";s:21:\"footer-collapse_after\";i:850;s:18:\"bottom_bar-enabled\";s:1:\"1\";s:16:\"bottom_bar-style\";s:18:\"content_width_line\";s:19:\"bottom_bar-bg_color\";s:7:\"#8e8e8e\";s:21:\"bottom_bar-bg_opacity\";i:20;s:19:\"bottom_bar-bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:3:\"top\";}s:16:\"bottom_bar-color\";s:7:\"#8e8e8e\";s:15:\"bottom_bar-text\";s:0:\"\";s:20:\"general-filter_style\";s:7:\"minimal\";s:42:\"general-filter_style-minimal-border_radius\";i:100;s:39:\"general-filter_style-material-line_size\";i:2;s:26:\"general-filter-font-family\";s:13:\"Open Sans:700\";s:24:\"general-filter-font-size\";i:14;s:20:\"general-filter_ucase\";b:0;s:26:\"general-filter-padding-top\";i:6;s:28:\"general-filter-padding-right\";i:15;s:29:\"general-filter-padding-bottom\";i:6;s:27:\"general-filter-padding-left\";i:16;s:25:\"general-filter-margin-top\";i:0;s:27:\"general-filter-margin-right\";i:5;s:28:\"general-filter-margin-bottom\";i:0;s:26:\"general-filter-margin-left\";i:0;s:25:\"general-navigation_margin\";i:40;s:21:\"blog-fancy_date-style\";s:6:\"circle\";s:20:\"post-show_fancy_date\";b:0;s:26:\"post-show_fancy_categories\";b:0;s:19:\"blog-thumbnail_size\";s:6:\"resize\";s:26:\"blog-thumbnail_proportions\";a:2:{s:5:\"width\";i:2;s:6:\"height\";i:1;}s:27:\"general-show_author_in_blog\";s:1:\"1\";s:25:\"general-next_prev_in_blog\";s:1:\"1\";s:32:\"general-show_back_button_in_post\";s:1:\"0\";s:20:\"general-blog_meta_on\";s:1:\"1\";s:22:\"general-blog_meta_date\";s:1:\"1\";s:24:\"general-blog_meta_author\";s:1:\"1\";s:28:\"general-blog_meta_categories\";s:1:\"1\";s:26:\"general-blog_meta_comments\";s:1:\"1\";s:22:\"general-blog_meta_tags\";s:1:\"1\";s:22:\"general-show_rel_posts\";s:1:\"1\";s:28:\"general-rel_posts_head_title\";s:13:\"Related posts\";s:21:\"general-rel_posts_max\";i:6;s:19:\"general-title_align\";s:6:\"center\";s:20:\"general-title_height\";i:280;s:22:\"page_title-padding-top\";i:0;s:25:\"page_title-padding-bottom\";i:40;s:19:\"general-show_titles\";s:1:\"1\";s:18:\"general-title_size\";s:2:\"h1\";s:19:\"general-title_color\";s:7:\"#ffffff\";s:24:\"general-show_breadcrumbs\";s:1:\"1\";s:25:\"general-breadcrumbs_color\";s:7:\"#ffffff\";s:28:\"general-breadcrumbs_bg_color\";s:5:\"white\";s:21:\"general-title_bg_mode\";s:10:\"background\";s:17:\"header-background\";s:11:\"transparent\";s:27:\"header-transparent_bg_color\";s:7:\"#000000\";s:29:\"header-transparent_bg_opacity\";i:0;s:52:\"page_title-background-style-transparent-color_scheme\";s:12:\"from_options\";s:22:\"general-title_bg_color\";s:7:\"#232323\";s:24:\"general-title_bg_opacity\";i:100;s:24:\"general-title_decoration\";s:4:\"none\";s:38:\"general-title_decoration_outline_color\";s:7:\"#1e73be\";s:40:\"general-title_decoration_outline_opacity\";i:0;s:25:\"general-title_bg_gradient\";a:2:{i:0;s:7:\"#4a66d6\";i:1;s:7:\"#12b4ea\";}s:22:\"general-title_bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:27:\"general-title_bg_fullscreen\";s:1:\"1\";s:22:\"general-title_bg_fixed\";b:0;s:25:\"general-title_bg_parallax\";s:0:\"\";s:21:\"content-headers_color\";s:7:\"#232323\";s:26:\"content-primary_text_color\";s:7:\"#7f7f7f\";s:28:\"content-secondary_text_color\";s:7:\"#aaaaaa\";s:17:\"fonts-font_family\";s:9:\"Open Sans\";s:14:\"fonts-big_size\";i:15;s:26:\"fonts-big_size_line_height\";i:28;s:17:\"fonts-normal_size\";i:15;s:29:\"fonts-normal_size_line_height\";i:28;s:16:\"fonts-small_size\";i:13;s:28:\"fonts-small_size_line_height\";i:24;s:20:\"fonts-h1_font_family\";s:10:\"Roboto:700\";s:18:\"fonts-h1_font_size\";i:36;s:20:\"fonts-h1_line_height\";i:46;s:18:\"fonts-h1_uppercase\";b:0;s:20:\"fonts-h2_font_family\";s:10:\"Roboto:700\";s:18:\"fonts-h2_font_size\";i:22;s:20:\"fonts-h2_line_height\";i:32;s:18:\"fonts-h2_uppercase\";b:0;s:20:\"fonts-h3_font_family\";s:10:\"Roboto:700\";s:18:\"fonts-h3_font_size\";i:18;s:20:\"fonts-h3_line_height\";i:28;s:18:\"fonts-h3_uppercase\";b:0;s:20:\"fonts-h4_font_family\";s:10:\"Roboto:700\";s:18:\"fonts-h4_font_size\";i:16;s:20:\"fonts-h4_line_height\";i:26;s:18:\"fonts-h4_uppercase\";b:0;s:20:\"fonts-h5_font_family\";s:10:\"Roboto:700\";s:18:\"fonts-h5_font_size\";i:14;s:20:\"fonts-h5_line_height\";i:24;s:18:\"fonts-h5_uppercase\";b:0;s:20:\"fonts-h6_font_family\";s:10:\"Roboto:700\";s:18:\"fonts-h6_font_size\";i:12;s:20:\"fonts-h6_line_height\";i:22;s:18:\"fonts-h6_uppercase\";b:0;s:13:\"buttons-style\";s:4:\"flat\";s:18:\"buttons-color_mode\";s:6:\"accent\";s:13:\"buttons-color\";s:7:\"#81d742\";s:22:\"buttons-color_gradient\";a:2:{i:0;s:7:\"#13aa4a\";i:1;s:7:\"#84df31\";}s:24:\"buttons-hover_color_mode\";s:5:\"color\";s:19:\"buttons-hover_color\";s:7:\"#cc2443\";s:28:\"buttons-hover_color_gradient\";a:2:{i:0;s:7:\"#1cd9ea\";i:1;s:7:\"#0ca2e0\";}s:23:\"buttons-text_color_mode\";s:5:\"color\";s:18:\"buttons-text_color\";s:7:\"#ffffff\";s:29:\"buttons-text_hover_color_mode\";s:5:\"color\";s:24:\"buttons-text_hover_color\";s:7:\"#ffffff\";s:21:\"buttons-s_font_family\";s:13:\"Open Sans:700\";s:19:\"buttons-s_font_size\";i:12;s:19:\"buttons-s_uppercase\";b:0;s:21:\"buttons-s_line_height\";i:30;s:23:\"buttons-s_border_radius\";i:0;s:21:\"buttons-m_font_family\";s:13:\"Open Sans:700\";s:19:\"buttons-m_font_size\";i:14;s:19:\"buttons-m_uppercase\";b:0;s:21:\"buttons-m_line_height\";i:38;s:23:\"buttons-m_border_radius\";i:0;s:21:\"buttons-l_font_family\";s:9:\"Open Sans\";s:19:\"buttons-l_font_size\";i:16;s:19:\"buttons-l_uppercase\";b:0;s:21:\"buttons-l_line_height\";i:46;s:23:\"buttons-l_border_radius\";i:0;s:17:\"image_hover-style\";s:4:\"none\";s:29:\"image_hover-onclick_animation\";s:1:\"1\";s:24:\"image_hover-default_icon\";s:10:\"big_center\";s:22:\"image_hover-color_mode\";s:5:\"color\";s:17:\"image_hover-color\";s:7:\"#000000\";s:26:\"image_hover-color_gradient\";a:2:{i:0;s:7:\"#2edded\";i:1;s:7:\"#0084bb\";}s:19:\"image_hover-opacity\";i:30;s:31:\"image_hover-project_icons_style\";s:7:\"outline\";s:34:\"image_hover-album_miniatures_style\";s:7:\"style_2\";s:39:\"image_hover-project_rollover_color_mode\";s:6:\"accent\";s:34:\"image_hover-project_rollover_color\";s:7:\"#000000\";s:43:\"image_hover-project_rollover_color_gradient\";a:2:{i:0;s:7:\"#2edded\";i:1;s:7:\"#0084bb\";}s:36:\"image_hover-project_rollover_opacity\";i:90;s:25:\"social_buttons-visibility\";s:7:\"allways\";s:32:\"social_buttons-post-button_title\";s:15:\"Share this post\";s:19:\"social_buttons-post\";a:0:{}s:42:\"social_buttons-portfolio_post-button_title\";s:15:\"Share this post\";s:29:\"social_buttons-portfolio_post\";a:0:{}s:33:\"social_buttons-photo-button_title\";s:16:\"Share this image\";s:20:\"social_buttons-photo\";a:0:{}s:32:\"social_buttons-page-button_title\";s:15:\"Share this page\";s:19:\"social_buttons-page\";a:0:{}s:11:\"widgetareas\";a:2:{i:1;a:2:{s:12:\"sidebar_name\";s:15:\"Default Sidebar\";s:12:\"sidebar_desc\";s:27:\"Sidebar primary widget area\";}i:2;a:2:{s:12:\"sidebar_name\";s:14:\"Default Footer\";s:12:\"sidebar_desc\";s:26:\"Footer primary widget area\";}}s:31:\"general-page_content_top_margin\";i:80;s:34:\"general-page_content_bottom_margin\";i:80;s:18:\"general-responsive\";s:1:\"1\";s:31:\"general-responsiveness-treshold\";i:970;s:29:\"general-side_content_paddings\";i:50;s:31:\"general-switch_content_paddings\";i:768;s:36:\"general-mobile_side_content_paddings\";i:25;s:27:\"general-images_lazy_loading\";s:1:\"1\";s:21:\"general-smooth_scroll\";s:3:\"off\";s:33:\"general-contact_form_send_mail_to\";s:0:\"\";s:34:\"general-hide_plugins_notifications\";s:1:\"1\";s:18:\"general-custom_css\";s:131:\"p {\r\n    margin-bottom: 20px;\r\n}\r\n.top-header .main-nav.level-arrows-on>li.has-children>a .menu-text {\r\n    padding-right: 15px;\r\n}\";s:21:\"general-tracking_code\";s:0:\"\";s:30:\"general-next_prev_in_portfolio\";s:1:\"1\";s:35:\"general-show_back_button_in_project\";s:1:\"0\";s:25:\"general-portfolio_meta_on\";s:1:\"1\";s:27:\"general-portfolio_meta_date\";s:1:\"1\";s:29:\"general-portfolio_meta_author\";s:1:\"1\";s:33:\"general-portfolio_meta_categories\";s:1:\"1\";s:31:\"general-portfolio_meta_comments\";s:1:\"1\";s:25:\"general-show_rel_projects\";s:1:\"0\";s:31:\"general-rel_projects_head_title\";s:16:\"Related projects\";s:26:\"general-rel_projects_title\";s:1:\"1\";s:28:\"general-rel_projects_excerpt\";s:1:\"1\";s:30:\"general-rel_projects_info_date\";s:1:\"1\";s:32:\"general-rel_projects_info_author\";s:1:\"1\";s:34:\"general-rel_projects_info_comments\";s:1:\"1\";s:36:\"general-rel_projects_info_categories\";s:1:\"1\";s:25:\"general-rel_projects_link\";s:1:\"1\";s:25:\"general-rel_projects_zoom\";s:1:\"1\";s:28:\"general-rel_projects_details\";s:1:\"1\";s:24:\"general-rel_projects_max\";i:12;s:37:\"general-rel_projects_fullwidth_height\";i:210;s:42:\"general-rel_projects_fullwidth_width_style\";s:4:\"prop\";s:36:\"general-rel_projects_fullwidth_width\";i:210;s:27:\"general-rel_projects_height\";i:180;s:32:\"general-rel_projects_width_style\";s:4:\"prop\";s:26:\"general-rel_projects_width\";i:180;s:26:\"general-next_prev_in_album\";s:1:\"1\";s:33:\"general-show_back_button_in_album\";s:1:\"1\";s:21:\"general-album_meta_on\";s:1:\"1\";s:23:\"general-album_meta_date\";s:1:\"1\";s:25:\"general-album_meta_author\";b:0;s:29:\"general-album_meta_categories\";s:1:\"1\";s:27:\"general-album_meta_comments\";b:0;s:24:\"modules-portfolio-status\";s:8:\"disabled\";s:27:\"modules-testimonials-status\";s:8:\"disabled\";s:19:\"modules-team-status\";s:8:\"disabled\";s:20:\"modules-logos-status\";s:8:\"disabled\";s:23:\"modules-benefits-status\";s:8:\"disabled\";s:21:\"modules-albums-status\";s:8:\"disabled\";s:24:\"modules-slideshow-status\";s:8:\"disabled\";s:39:\"general-post_back_button_target_page_id\";i:0;s:42:\"general-project_back_button_target_page_id\";i:0;s:40:\"general-album_back_button_target_page_id\";i:0;s:32:\"general-post_type_portfolio_slug\";s:7:\"project\";s:30:\"general-post_type_gallery_slug\";s:10:\"dt_gallery\";s:27:\"general-post_type_team_slug\";s:7:\"dt_team\";}", "yes");
INSERT INTO `myevntl_options` VALUES("238", "the7pt_flush_rewrite_rules", "", "yes");
INSERT INTO `myevntl_options` VALUES("182", "presscore_less_css_is_writable", "1", "yes");
INSERT INTO `myevntl_options` VALUES("183", "wp_less_stylesheet_data_b8b5915270db4c4490cc30d280ecd8f0", "a:1:{s:10:\"target_uri\";s:99:\"http://www.myeventology.ph/wp-content/uploads/wp-less/myeventology/css/custom-old-ie-caa5ac0913.css\";}", "yes");
INSERT INTO `myevntl_options` VALUES("294", "ultimate_updater", "disabled", "yes");
INSERT INTO `myevntl_options` VALUES("295", "ultimate_constants", "a:3:{s:24:\"ULTIMATE_NO_UPDATE_CHECK\";b:1;s:28:\"ULTIMATE_NO_EDIT_PAGE_NOTICE\";b:1;s:30:\"ULTIMATE_NO_PLUGIN_PAGE_NOTICE\";b:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("296", "ultimate_modules", "a:41:{i:0;s:18:\"ultimate_animation\";i:1;s:16:\"ultimate_buttons\";i:2;s:18:\"ultimate_countdown\";i:3;s:17:\"ultimate_flip_box\";i:4;s:20:\"ultimate_google_maps\";i:5;s:22:\"ultimate_google_trends\";i:6;s:17:\"ultimate_headings\";i:7;s:22:\"ultimate_icon_timeline\";i:8;s:17:\"ultimate_info_box\";i:9;s:20:\"ultimate_info_circle\";i:10;s:18:\"ultimate_info_list\";i:11;s:20:\"ultimate_info_tables\";i:12;s:28:\"ultimate_interactive_banners\";i:13;s:29:\"ultimate_interactive_banner_2\";i:14;s:15:\"ultimate_modals\";i:15;s:17:\"ultimate_parallax\";i:16;s:23:\"ultimate_pricing_tables\";i:17;s:15:\"ultimate_spacer\";i:18;s:22:\"ultimate_stats_counter\";i:19;s:20:\"ultimate_swatch_book\";i:20;s:14:\"ultimate_icons\";i:21;s:18:\"ultimate_list_icon\";i:22;s:17:\"ultimate_carousel\";i:23;s:18:\"ultimate_fancytext\";i:24;s:22:\"ultimate_highlight_box\";i:25;s:20:\"ultimate_info_banner\";i:26;s:15:\"ultimate_ihover\";i:27;s:16:\"ultimate_hotspot\";i:28;s:21:\"ultimate_video_banner\";i:29;s:11:\"woocomposer\";i:30;s:20:\"ultimate_dual_button\";i:31;s:13:\"ultimate_link\";i:32;s:19:\"ultimate_fancy_text\";i:33;s:23:\"ultimate_hightlight_box\";i:34;s:20:\"ultimate_content_box\";i:35;s:24:\"ultimate_image_separator\";i:36;s:27:\"ultimate_expandable_section\";i:37;s:12:\"ultimate_tab\";i:38;s:23:\"ultimate_sticky_section\";i:39;s:13:\"ultimate_team\";i:40;s:21:\"ultimate_range_slider\";}", "yes");
INSERT INTO `myevntl_options` VALUES("204", "wpcf7", "a:2:{s:7:\"version\";s:3:\"4.7\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1488213044;s:7:\"version\";s:5:\"4.6.1\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `myevntl_options` VALUES("205", "convert_plug_modules", "a:3:{i:0;s:11:\"Modal_Popup\";i:1;s:8:\"Info_Bar\";i:2;s:14:\"Slide_In_Popup\";}", "yes");
INSERT INTO `myevntl_options` VALUES("206", "cp_image_compatibility_check", "1", "yes");
INSERT INTO `myevntl_options` VALUES("207", "ultimate_google_fonts", "a:818:{i:0;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"ABeeZee\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-09-29\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/abeezee/v9/mE5BOuZKGln_Ex0uYKpIaw.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/abeezee/v9/kpplLynmYgP0YtlJA3atRw.ttf\";}}i:1;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Abel\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-09-29\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/abel/v6/RpUKfqNxoyNe_ka23bzQ2A.ttf\";}}i:2;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Abhaya Libre\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:7:\"sinhala\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-10-06\";s:5:\"files\";O:8:\"stdClass\":5:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/abhayalibre/v1/zTLc5Jxv6yvb1nHyqBasVy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"500\";s:89:\"http://fonts.gstatic.com/s/abhayalibre/v1/wBjdF6T34NCo7wQYXgzrc5MQuUSAwdHsY8ov_6tk1oA.ttf\";s:3:\"600\";s:89:\"http://fonts.gstatic.com/s/abhayalibre/v1/wBjdF6T34NCo7wQYXgzrc2v8CylhIUtwUiYO7Z2wXbE.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/abhayalibre/v1/wBjdF6T34NCo7wQYXgzrc0D2ttfZwueP-QU272T9-k4.ttf\";s:3:\"800\";s:89:\"http://fonts.gstatic.com/s/abhayalibre/v1/wBjdF6T34NCo7wQYXgzrc_qsay_1ZmRGmC8pVRdIfAg.ttf\";}}i:3;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Abril Fatface\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/abrilfatface/v8/X1g_KwGeBV3ajZIXQ9VnDojjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:4;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Aclonica\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/aclonica/v6/M6pHZMPwK3DiBSlo3jwAKQ.ttf\";}}i:5;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Acme\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/acme/v5/-J6XNtAHPZBEbsifCdBt-g.ttf\";}}i:6;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Actor\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/actor/v6/ugMf40CrRK6Jf6Yz_xNSmQ.ttf\";}}i:7;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Adamina\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/adamina/v8/RUQfOodOMiVVYqFZcSlT9w.ttf\";}}i:8;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Advent Pro\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"greek\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"100\";s:87:\"http://fonts.gstatic.com/s/adventpro/v4/87-JOpSUecTG50PBYK4ysi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"200\";s:87:\"http://fonts.gstatic.com/s/adventpro/v4/URTSSjIp0Wr-GrjxFdFWnGeudeTO44zf-ht3k-KNzwg.ttf\";s:3:\"300\";s:87:\"http://fonts.gstatic.com/s/adventpro/v4/sJaBfJYSFgoB80OL1_66m0eOrDcLawS7-ssYqLr2Xp4.ttf\";s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/adventpro/v4/1NxMBeKVcNNH2H46AUR3wfesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"500\";s:87:\"http://fonts.gstatic.com/s/adventpro/v4/7kBth2-rT8tP40RmMMXMLJp-63r6doWhTEbsfBIRJ7A.ttf\";s:3:\"600\";s:87:\"http://fonts.gstatic.com/s/adventpro/v4/3Jo-2maCzv2QLzQBzaKHV_pTEJqju4Hz1txDWij77d4.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/adventpro/v4/M4I6QiICt-ey_wZTpR2gKwJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:9;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Aguafina Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/aguafinascript/v5/65g7cgMtMGnNlNyq_Z6CvMxLhO8OSNnfAp53LK1_iRs.ttf\";}}i:10;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Akronim\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/akronim/v5/qA0L2CSArk3tuOWE1AR1DA.ttf\";}}i:11;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Aladin\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/aladin/v5/PyuJ5cVHkduO0j5fAMKvAA.ttf\";}}i:12;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Aldrich\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/aldrich/v6/kMMW1S56gFx7RP_mW1g-Eg.ttf\";}}i:13;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Alef\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"hebrew\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/alef/v6/ENvZ_P0HBDQxNZYCQO0lUA.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/alef/v6/VDgZJhEwudtOzOFQpZ8MEA.ttf\";}}i:14;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Alegreya\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/alegreya/v7/62J3atXd6bvMU4qO_ca-eA.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/alegreya/v7/cbshnQGxwmlHBjUil7DaIfesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/alegreya/v7/5oZtdI5-wQwgAFrd9erCsaCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/alegreya/v7/IWi8e5bpnqhMRsZKTcTUWgJKKGfqHaYFsRG-T3ceEVo.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/alegreya/v7/oQeMxX-vxGImzDgX6nxA7KCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"900italic\";s:86:\"http://fonts.gstatic.com/s/alegreya/v7/-L71QLH_XqgYWaI1GbOVhp0EAVxt0G0biEntp43Qt6E.ttf\";}}i:15;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Alegreya SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/alegreyasc/v6/3ozeFnTbygMK6PfHh8B-iqCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:88:\"http://fonts.gstatic.com/s/alegreyasc/v6/GOqmv3FLsJ2r6ZALMZVBmkeOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/alegreyasc/v6/M9OIREoxDkvynwTpBAYUq3e1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:88:\"http://fonts.gstatic.com/s/alegreyasc/v6/5PCoU7IUfCicpKBJtBmP6c_zJjSACmk0BRPxQqhnNLU.ttf\";s:3:\"900\";s:88:\"http://fonts.gstatic.com/s/alegreyasc/v6/M9OIREoxDkvynwTpBAYUqyenaqEuufTBk9XMKnKmgDA.ttf\";s:9:\"900italic\";s:88:\"http://fonts.gstatic.com/s/alegreyasc/v6/5PCoU7IUfCicpKBJtBmP6U_yTOUGsoC54csJe1b-IRw.ttf\";}}i:16;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Alegreya Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":14:{s:3:\"100\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/TKyx_-JJ6MdpQruNk-t-PJFGFO4uyVFMfB6LZsii7kI.ttf\";s:9:\"100italic\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/gRkSP2lBpqoMTVxg7DmVn2cDnjsrnI9_xJ-5gnBaHsE.ttf\";s:3:\"300\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/11EDm-lum6tskJMBbdy9acB1LjARzAvdqa1uQC32v70.ttf\";s:9:\"300italic\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/WfiXipsmjqRqsDBQ1bA9CnfqlVoxTUFFx1C8tBqmbcg.ttf\";s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/KYNzioYhDai7mTMnx_gDgn8f0n03UdmQgF_CLvNR2vg.ttf\";s:6:\"italic\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/TKyx_-JJ6MdpQruNk-t-PD4G9C9ttb0Oz5Cvf0qOitE.ttf\";s:3:\"500\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/11EDm-lum6tskJMBbdy9aQqQmZ7VjhwksfpNVG0pqGc.ttf\";s:9:\"500italic\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/WfiXipsmjqRqsDBQ1bA9Cs7DCVO6wo6i5LKIyZDzK40.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/11EDm-lum6tskJMBbdy9aVCbmAUID8LN-q3pJpOk3Ys.ttf\";s:9:\"700italic\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/WfiXipsmjqRqsDBQ1bA9CpF66r9C4AnxxlBlGd7xY4g.ttf\";s:3:\"800\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/11EDm-lum6tskJMBbdy9acxnD5BewVtRRHHljCwR2bM.ttf\";s:9:\"800italic\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/WfiXipsmjqRqsDBQ1bA9CicOAJ_9MkLPbDmrtXDPbIU.ttf\";s:3:\"900\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/11EDm-lum6tskJMBbdy9aW42xlVP-j5dagE7-AU2zwg.ttf\";s:9:\"900italic\";s:90:\"http://fonts.gstatic.com/s/alegreyasans/v3/WfiXipsmjqRqsDBQ1bA9ChRaDUI9aE8-k7PrIG2iiuo.ttf\";}}i:17;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Alegreya Sans SC\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":14:{s:3:\"100\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/trwFkDJLOJf6hqM93944kVnzStfdnFU-MXbO84aBs_M.ttf\";s:9:\"100italic\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/qG3gA9iy5RpXMH4crZboqqakMVR0XlJhO7VdJ8yYvA4.ttf\";s:3:\"300\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/AjAmkoP1y0Vaad0UPPR46-1IqtfxJspFjzJp0SaQRcI.ttf\";s:9:\"300italic\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/0VweK-TO3aQgazdxg8fs0CnTKaH808trtzttbEg4yVA.ttf\";s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/6kgb6ZvOagoVIRZyl8XV-EklWX-XdLVn1WTiuGuvKIU.ttf\";s:6:\"italic\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/trwFkDJLOJf6hqM93944kTfqo69HNOlCNZvbwAmUtiA.ttf\";s:3:\"500\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/AjAmkoP1y0Vaad0UPPR46_hHTluI57wqxl55RvSYo3s.ttf\";s:9:\"500italic\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/0VweK-TO3aQgazdxg8fs0NqVvxKdFVwqwzilqfVd39U.ttf\";s:3:\"700\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/AjAmkoP1y0Vaad0UPPR4600aId5t1FC-xZ8nmpa_XLk.ttf\";s:9:\"700italic\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/0VweK-TO3aQgazdxg8fs0IBYn3VD6xMEnodOh8pnFw4.ttf\";s:3:\"800\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/AjAmkoP1y0Vaad0UPPR46wQgSHD3Lo1Mif2Wkk5swWA.ttf\";s:9:\"800italic\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/0VweK-TO3aQgazdxg8fs0HStmCm6Rs90XeztCALm0H8.ttf\";s:3:\"900\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/AjAmkoP1y0Vaad0UPPR461Rf9EWUSEX_PR1d_gLKfpM.ttf\";s:9:\"900italic\";s:92:\"http://fonts.gstatic.com/s/alegreyasanssc/v3/0VweK-TO3aQgazdxg8fs0IvtwEfTCJoOJugANj-jWDI.ttf\";}}i:18;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Alex Brush\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/alexbrush/v6/ooh3KJFbKJSUoIRWfiu8o_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:19;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Alfa Slab One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/alfaslabone/v6/Qx6FPcitRwTC_k88tLPc-Yjjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:20;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Alice\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-19\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/alice/v8/wZTAfivekBqIg-rk63nFvQ.ttf\";}}i:21;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Alike\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/alike/v8/Ho8YpRKNk_202fwDiGNIyw.ttf\";}}i:22;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Alike Angular\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/alikeangular/v6/OpeCu4xxI3qO1C7CZcJtPT3XH2uEnVI__ynTBvNyki8.ttf\";}}i:23;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Allan\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/allan/v7/T3lemhgZmLQkQI2Qc2bQHA.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/allan/v7/zSxQiwo7wgnr7KkMXhSiag.ttf\";}}i:24;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Allerta\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/allerta/v7/s9FOEuiJFTNbMe06ifzV8g.ttf\";}}i:25;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Allerta Stencil\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/allertastencil/v7/CdSZfRtHbQrBohqmzSdDYFf2eT4jUldwg_9fgfY_tHc.ttf\";}}i:26;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Allura\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/allura/v4/4hcqgZanyuJ2gMYWffIR6A.ttf\";}}i:27;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Almendra\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/almendra/v8/PDpbB-ZF7deXAAEYPkQOeg.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/almendra/v8/CNWLyiDucqVKVgr4EMidi_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/almendra/v8/ZpLdQMj7Q2AFio4nNO6A76CWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/almendra/v8/-tXHKMcnn6FqrhJV3l1e3QJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:28;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Almendra Display\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/almendradisplay/v6/2Zuu97WJ_ez-87yz5Ai8fF6uyC_qD11hrFQ6EGgTJWI.ttf\";}}i:29;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Almendra SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/almendrasc/v6/IuiLd8Fm9I6raSalxMoWeaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:30;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Amarante\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/amarante/v4/2dQHjIBWSpydit5zkJZnOw.ttf\";}}i:31;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Amaranth\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/amaranth/v6/7VcBog22JBHsHXHdnnycTA.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/amaranth/v6/UrJlRY9LcVERJSvggsdBqPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/amaranth/v6/j5OFHqadfxyLnQRxFeox6qCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/amaranth/v6/BHyuYFj9nqLFNvOvGh0xTwJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:32;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Amatic SC\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:6:\"hebrew\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2017-01-20\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/amaticsc/v9/MldbRWLFytvqxU1y81xSVg.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/amaticsc/v9/IDnkRTPGcrSVo50UyYNK7y3USBnSvpkopQaUR-2r7iU.ttf\";}}i:33;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Amatica SC\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:6:\"hebrew\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/amaticasc/v1/f9SWSy9DLsJV2etvm5rwGPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/amaticasc/v1/nFmSxyAMfCP_5xGDJ4j5TgJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:34;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Amethysta\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/amethysta/v4/1jEo9tOFIJDolAUpBnWbnA.ttf\";}}i:35;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Amiko\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"600\";i:2;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/amiko/v1/A7bjc3cOLJtGgpPGnxyHsw.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/amiko/v1/BaZst4RZ4sDyD3mH-BfVaA.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/amiko/v1/6syx43mQ07VvOmpFc0G9Lg.ttf\";}}i:36;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Amiri\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/amiri/v7/ATARrPmSew75SlpOw2YABQ.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/amiri/v7/3t1yTQlLUXBw8htrqlXBrw.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/amiri/v7/WQsR_moz-FNqVwGYgptqiA.ttf\";s:9:\"700italic\";s:83:\"http://fonts.gstatic.com/s/amiri/v7/uF8aNEyD0bxMeTBg9bFDSPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:37;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Amita\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/amita/v1/RhdhGBXSJqkHo6g7miTEcQ.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/amita/v1/cIYA2Lzp7l2pcGsqpUidBg.ttf\";}}i:38;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Anaheim\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/anaheim/v4/t-z8aXHMpgI2gjN_rIflKA.ttf\";}}i:39;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Andada\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/andada/v7/rSFaDqNNQBRw3y19MB5Y4w.ttf\";}}i:40;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Andika\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/andika/v7/oe-ag1G0lcqZ3IXfeEgaGg.ttf\";}}i:41;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Angkor\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/angkor/v8/DLpLgIS-8F10ecwKqCm95Q.ttf\";}}i:42;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:24:\"Annie Use Your Telescope\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:99:\"http://fonts.gstatic.com/s/annieuseyourtelescope/v6/2cuiO5VmaR09C8SLGEQjGqbp7mtG8sPlcZvOaO8HBak.ttf\";}}i:43;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Anonymous Pro\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/anonymouspro/v9/Zhfjj_gat3waL4JSju74E-V_5zh5b-_HiooIRUBwn1A.ttf\";s:6:\"italic\";s:90:\"http://fonts.gstatic.com/s/anonymouspro/v9/q0u6LFHwttnT_69euiDbWKwIsuKDCXG0NQm7BvAgx-c.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/anonymouspro/v9/WDf5lZYgdmmKhO8E1AQud--Cz_5MeePnXDAcLNWyBME.ttf\";s:9:\"700italic\";s:90:\"http://fonts.gstatic.com/s/anonymouspro/v9/_fVr_XGln-cetWSUc-JpfA1LL9bfs7wyIp6F8OC9RxA.ttf\";}}i:44;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Antic\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/antic/v7/hEa8XCNM7tXGzD0Uk0AipA.ttf\";}}i:45;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Antic Didone\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/anticdidone/v4/r3nJcTDuOluOL6LGDV1vRy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:46;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Antic Slab\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/anticslab/v4/PSbJCTKkAS7skPdkd7AKEvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:47;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Anton\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/anton/v8/XIbCenm-W0IRHWYIh7CGUQ.ttf\";}}i:48;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Arapey\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/arapey/v5/dqu823lrSYn8T2gApTdslA.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/arapey/v5/pY-Xi5JNBpaWxy2tZhEm5A.ttf\";}}i:49;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Arbutus\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/arbutus/v5/Go_hurxoUsn5MnqNVQgodQ.ttf\";}}i:50;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Arbutus Slab\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/arbutusslab/v4/6k3Yp6iS9l4jRIpynA8qMy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:51;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Architects Daughter\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:96:\"http://fonts.gstatic.com/s/architectsdaughter/v6/RXTgOOQ9AAtaVOHxx0IUBMCy0EhZjHzu-y0e6uLf4Fg.ttf\";}}i:52;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Archivo Black\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/archivoblack/v4/WoAoVT7K3k7hHfxKbvB6B51XQG8isOYYJhPIYAyrESQ.ttf\";}}i:53;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Archivo Narrow\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/archivonarrow/v5/DsLzC9scoPnrGiwYYMQXppTvAuddT2xDMbdz0mdLyZY.ttf\";s:6:\"italic\";s:91:\"http://fonts.gstatic.com/s/archivonarrow/v5/vqsrtPCpTU3tJlKfuXP5zUpmlyBQEFfdE6dERLXdQGQ.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/archivonarrow/v5/M__Wu4PAmHf4YZvQM8tWsMLtdzs3iyjn_YuT226ZsLU.ttf\";s:9:\"700italic\";s:91:\"http://fonts.gstatic.com/s/archivonarrow/v5/wG6O733y5zHl4EKCOh8rSTg5KB8MNJ4uPAETq9naQO8.ttf\";}}i:54;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Aref Ruqaa\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/arefruqaa/v1/kbqI055uLQz2hkccTTrYPfesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/arefruqaa/v1/RT-Q5DVI9arM6ZKux-UmTAJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:55;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Arima Madurai\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";}s:7:\"subsets\";a:4:{i:0;s:5:\"tamil\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-08-22\";s:5:\"files\";O:8:\"stdClass\":8:{s:3:\"100\";s:90:\"http://fonts.gstatic.com/s/arimamadurai/v2/Q0tjl46beRRcUe3RlWWNrdyXLlNBCUjoM1yKFfVCFUI.ttf\";s:3:\"200\";s:90:\"http://fonts.gstatic.com/s/arimamadurai/v2/EsCGNPwBfkMk17-w_DTJ4rArwWuxcSSKq67BdR6k5Rg.ttf\";s:3:\"300\";s:90:\"http://fonts.gstatic.com/s/arimamadurai/v2/EsCGNPwBfkMk17-w_DTJ4joJ52uD-1fmXmi8u0n_zsc.ttf\";s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/arimamadurai/v2/8fNfThKRw_pr7MwgNdcHiW_MnNA9OgK8I1F23mNWOpE.ttf\";s:3:\"500\";s:90:\"http://fonts.gstatic.com/s/arimamadurai/v2/EsCGNPwBfkMk17-w_DTJ4v_2zpxNHQ3utWt_82o9dAo.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/arimamadurai/v2/EsCGNPwBfkMk17-w_DTJ4qiiXuG_rGcOxkuidirlnJE.ttf\";s:3:\"800\";s:90:\"http://fonts.gstatic.com/s/arimamadurai/v2/EsCGNPwBfkMk17-w_DTJ4khKLu0CevfTHM1eXjGnvQo.ttf\";s:3:\"900\";s:90:\"http://fonts.gstatic.com/s/arimamadurai/v2/EsCGNPwBfkMk17-w_DTJ4kZ0oshA7r_PlGegwiHddT8.ttf\";}}i:56;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Arimo\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:8:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:6:\"hebrew\";i:7;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/arimo/v9/Gpeo80g-5ji2CcyXWnzh7g.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/arimo/v9/_OdGbnX2-qQ96C4OjhyuPw.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/arimo/v9/ZItXugREyvV9LnbY_gxAmw.ttf\";s:9:\"700italic\";s:83:\"http://fonts.gstatic.com/s/arimo/v9/__nOLWqmeXdhfr0g7GaFePesZW2xOQ-xsNqO47m55DA.ttf\";}}i:57;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Arizonia\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/arizonia/v6/yzJqkHZqryZBTM7RKYV9Wg.ttf\";}}i:58;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Armata\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/armata/v6/1H8FwGgIRrbYtxSfXhOHlQ.ttf\";}}i:59;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Arsenal\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/arsenal/v1/PkcjwJ0AdgwImdsRdyzQQQ.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/arsenal/v1/FvYQ_YMyIFZw-8dXMYPhHg.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/arsenal/v1/6R-JWA0Y5N2Lvul2TLOH3_esZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:85:\"http://fonts.gstatic.com/s/arsenal/v1/AnUIg26c0nuMZMpNWtsDFy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:60;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Artifika\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/artifika/v6/Ekfp4H4QG7D-WsABDOyj8g.ttf\";}}i:61;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Arvo\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/arvo/v9/vvWPwz-PlZEwjOOIKqoZzA.ttf\";s:6:\"italic\";s:61:\"http://fonts.gstatic.com/s/arvo/v9/id5a4BCjbenl5Gkqonw_Rw.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/arvo/v9/OB3FDST7U38u3OjPK_vvRQ.ttf\";s:9:\"700italic\";s:61:\"http://fonts.gstatic.com/s/arvo/v9/Hvl2MuWoXLaCy2v6MD4Yvw.ttf\";}}i:62;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Arya\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/arya/v1/xEVqtU3v8QLospHKpDaYEw.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/arya/v1/N13tgOvG7VTXawiI-fJiQA.ttf\";}}i:63;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Asap\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/asap/v5/2lf-1MDR8tsTpEtvJmr2hA.ttf\";s:6:\"italic\";s:61:\"http://fonts.gstatic.com/s/asap/v5/mwxNHf8QS8gNWCAMwkJNIg.ttf\";s:3:\"500\";s:61:\"http://fonts.gstatic.com/s/asap/v5/bSf7UzaPFkjzB9TuOPVhgw.ttf\";s:9:\"500italic\";s:61:\"http://fonts.gstatic.com/s/asap/v5/RUbFVj3EkB2Yo9QDVzDKLw.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/asap/v5/o5RUA7SsJ80M8oDFBnrDbg.ttf\";s:9:\"700italic\";s:61:\"http://fonts.gstatic.com/s/asap/v5/_rZz9y2oXc09jT5T6BexLQ.ttf\";}}i:64;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Asar\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/asar/v2/mSmn3H5CcMA84CZ586X7WQ.ttf\";}}i:65;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Asset\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/asset/v6/hfPmqY-JzuR1lULlQf9iTg.ttf\";}}i:66;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Assistant\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"hebrew\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"200\";s:87:\"http://fonts.gstatic.com/s/assistant/v1/xXstfiHQzjB9j5ZxYTBoZy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"300\";s:87:\"http://fonts.gstatic.com/s/assistant/v1/vPC3tCw3LOzCSeGCtVp5Wi3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/assistant/v1/2iDwv6DBtyixlK5YHngp1w.ttf\";s:3:\"600\";s:87:\"http://fonts.gstatic.com/s/assistant/v1/Y4UC5nQA69lWpfV0itoWLi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/assistant/v1/dZywGH4pMxP6OVyrppOJxy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"800\";s:87:\"http://fonts.gstatic.com/s/assistant/v1/-mTR0sX8a0RsadH4AMDT8C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:67;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Astloch\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/astloch/v6/fmbitVmHYLQP7MGPuFgpag.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/astloch/v6/aPkhM2tL-tz1jX6aX2rvo_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:68;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Asul\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/asul/v5/9qpsNR_OOwyOYyo2N0IbBw.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/asul/v5/uO8uNmxaq87-DdPmkEg5Gg.ttf\";}}i:69;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Athiti\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"200\";s:63:\"http://fonts.gstatic.com/s/athiti/v1/Ge5skdKwzxRPajVLdOJuIg.ttf\";s:3:\"300\";s:63:\"http://fonts.gstatic.com/s/athiti/v1/OoT7lj4AaSp1JpGJLKn3CA.ttf\";s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/athiti/v1/e7eiIKP18Iz9Kg1xat6AYw.ttf\";s:3:\"500\";s:63:\"http://fonts.gstatic.com/s/athiti/v1/W3pP-ANXfsMOVOG-cqqMFw.ttf\";s:3:\"600\";s:63:\"http://fonts.gstatic.com/s/athiti/v1/kYx3dtUYNEuUlzWczYzsmQ.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/athiti/v1/tyXFOxQyZGXfqHhtqSikdw.ttf\";}}i:70;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Atma\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:7:\"bengali\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:61:\"http://fonts.gstatic.com/s/atma/v1/noxn2r6cT3JgmEDt6Ip5pQ.ttf\";s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/atma/v1/dkXPrLoE_uqcgUFj4JdfRQ.ttf\";s:3:\"500\";s:61:\"http://fonts.gstatic.com/s/atma/v1/Htksg3ZXeAEbSvUdTQX-uw.ttf\";s:3:\"600\";s:61:\"http://fonts.gstatic.com/s/atma/v1/EGUwD65ZZn9IIHp5Y36b4A.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/atma/v1/-fkXl3wADUHjobbwO9d-Wg.ttf\";}}i:71;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Atomic Age\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/atomicage/v7/WvBMe4FxANIKpo6Oi0mVJ_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:72;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Aubrey\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/aubrey/v8/zo9w8klO8bmOQIMajQ2aTA.ttf\";}}i:73;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Audiowide\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/audiowide/v4/yGcwRZB6VmoYhPUYT-mEow.ttf\";}}i:74;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Autour One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/autourone/v5/2xmQBcg7FN72jaQRFZPIDvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:75;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Average\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/average/v4/aHUibBqdDbVYl5FM48pxyQ.ttf\";}}i:76;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Average Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/averagesans/v4/dnU3R-5A_43y5bIyLztPsS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:77;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Averia Gruesa Libre\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/averiagruesalibre/v4/10vbZTOoN6T8D-nvDzwRFyXcKHuZXlCN8VkWHpkUzKM.ttf\";}}i:78;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Averia Libre\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"300\";s:89:\"http://fonts.gstatic.com/s/averialibre/v4/r6hGL8sSLm4dTzOPXgx5XacQoVhARpoaILP7amxE_8g.ttf\";s:9:\"300italic\";s:89:\"http://fonts.gstatic.com/s/averialibre/v4/I6wAYuAvOgT7el2ePj2nkina0FLWfcB-J_SAYmcAXaI.ttf\";s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/averialibre/v4/rYVgHZZQICWnhjguGsBspC3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:89:\"http://fonts.gstatic.com/s/averialibre/v4/1etzuoNxVHR8F533EkD1WfMZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/averialibre/v4/r6hGL8sSLm4dTzOPXgx5XUD2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:89:\"http://fonts.gstatic.com/s/averialibre/v4/I6wAYuAvOgT7el2ePj2nkvAs9-1nE9qOqhChW0m4nDE.ttf\";}}i:79;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Averia Sans Libre\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"300\";s:93:\"http://fonts.gstatic.com/s/averiasanslibre/v4/_9-jTfQjaBsWAF_yp5z-V4CP_KG_g80s1KXiBtJHoNc.ttf\";s:9:\"300italic\";s:93:\"http://fonts.gstatic.com/s/averiasanslibre/v4/o7BEIK-fG3Ykc5Rzteh88YuyGu4JqttndUh4gRKxic0.ttf\";s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/averiasanslibre/v4/yRJpjT39KxACO9F31mj_LqV8_KRn4epKAjTFK1s1fsg.ttf\";s:6:\"italic\";s:93:\"http://fonts.gstatic.com/s/averiasanslibre/v4/COEzR_NPBSUOl3pFwPbPoCZU2HnUZT1xVKaIrHDioao.ttf\";s:3:\"700\";s:93:\"http://fonts.gstatic.com/s/averiasanslibre/v4/_9-jTfQjaBsWAF_yp5z-V8QwVOrz1y5GihpZmtKLhlI.ttf\";s:9:\"700italic\";s:93:\"http://fonts.gstatic.com/s/averiasanslibre/v4/o7BEIK-fG3Ykc5Rzteh88bXy1DXgmJcVtKjM5UWamMs.ttf\";}}i:80;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Averia Serif Libre\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"300\";s:94:\"http://fonts.gstatic.com/s/averiaseriflibre/v5/yvITAdr5D1nlsdFswJAb8SmC4gFJ2PHmfdVKEd_5S9M.ttf\";s:9:\"300italic\";s:94:\"http://fonts.gstatic.com/s/averiaseriflibre/v5/YOLFXyye4sZt6AZk1QybCG2okl0bU63CauowU4iApig.ttf\";s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/averiaseriflibre/v5/fdtF30xa_Erw0zAzOoG4BZqY66i8AUyI16fGqw0iAew.ttf\";s:6:\"italic\";s:94:\"http://fonts.gstatic.com/s/averiaseriflibre/v5/o9qhvK9iT5iDWfyhQUe-6Ru_b0bTq5iipbJ9hhgHJ6U.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/averiaseriflibre/v5/yvITAdr5D1nlsdFswJAb8Q50KV5TaOVolur4zV2iZsg.ttf\";s:9:\"700italic\";s:94:\"http://fonts.gstatic.com/s/averiaseriflibre/v5/YOLFXyye4sZt6AZk1QybCNxohRXP4tNDqG3X4Hqn21k.ttf\";}}i:81;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Bad Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/badscript/v5/cRyUs0nJ2eMQFHwBsZNRXfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:82;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Bahiana\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2017-01-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/bahiana/v1/uUnBWf2QkuMyfXPof7lcwQ.ttf\";}}i:83;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Baloo\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/baloo/v1/uFkbq9GEAWUcT0XNeptJ1Q.ttf\";}}i:84;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Baloo Bhai\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/baloobhai/v1/FQvpC-04bh2QINuWAdnNW_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:85;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Baloo Bhaina\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"oriya\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-08-19\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/baloobhaina/v1/HxxbxOVf9WQem_hKo1MXSi3USBnSvpkopQaUR-2r7iU.ttf\";}}i:86;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Baloo Chettan\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:9:\"malayalam\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-08-19\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/baloochettan/v1/ODsFofLybGVOJ90e_EwdFbyYXtM25qb63HASTPtoTFA.ttf\";}}i:87;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Baloo Da\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:7:\"bengali\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/balooda/v1/RAJ0l2eJl_HDURCVxRE1iQ.ttf\";}}i:88;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Baloo Paaji\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"gurmukhi\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-08-19\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/baloopaaji/v1/KeqAjVRzso6QUEfpMLQ-7KCWcynf_cDxXwCLxiixG1c.ttf\";}}i:89;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Baloo Tamma\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:7:\"kannada\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-08-19\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/balootamma/v1/-FKAYy14SAfG8Gc6YAAaMaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:90;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Baloo Thambi\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"tamil\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/baloothambi/v1/qXK3dZIeU-O-HruaN5cK0y3USBnSvpkopQaUR-2r7iU.ttf\";}}i:91;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Balthazar\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/balthazar/v5/WgbaSIs6dJAGXJ0qbz2xlw.ttf\";}}i:92;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Bangers\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/bangers/v9/WAffdge5w99Xif-DLeqmcA.ttf\";}}i:93;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Barrio\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2017-01-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/barrio/v1/kzvMfZB0agZKzXC5yyRwWA.ttf\";}}i:94;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Basic\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/basic/v6/hNII2mS5Dxw5C0u_m3mXgA.ttf\";}}i:95;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Battambang\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/battambang/v9/MzrUfQLefYum5vVGM3EZVPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/battambang/v9/dezbRtMzfzAA99DmrCYRMgJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:96;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Baumans\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/baumans/v5/o0bFdPW1H5kd5saqqOcoVg.ttf\";}}i:97;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Bayon\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/bayon/v8/yTubusjTnpNRZwA4_50iVw.ttf\";}}i:98;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Belgrano\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/belgrano/v6/iq8DUa2s7g6WRCeMiFrmtQ.ttf\";}}i:99;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Belleza\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/belleza/v4/wchA3BWJlVqvIcSeNZyXew.ttf\";}}i:100;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"BenchNine\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:87:\"http://fonts.gstatic.com/s/benchnine/v4/ah9xtUy9wLQ3qnWa2p-piS3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/benchnine/v4/h3OAlYqU3aOeNkuXgH2Q2w.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/benchnine/v4/qZpi6ZVZg3L2RL_xoBLxWS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:101;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Bentham\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/bentham/v6/5-Mo8Fe7yg5tzV0GlQIuzQ.ttf\";}}i:102;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Berkshire Swash\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/berkshireswash/v4/4RZJjVRPjYnC2939hKCAimKfbtsIjCZP_edQljX9gR0.ttf\";}}i:103;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Bevan\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/bevan/v8/Rtg3zDsCeQiaJ_Qno22OJA.ttf\";}}i:104;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Bigelow Rules\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/bigelowrules/v4/FEJCPLwo07FS-6SK6Al50X8f0n03UdmQgF_CLvNR2vg.ttf\";}}i:105;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Bigshot One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/bigshotone/v6/wSyZjBNTWDQHnvWE2jt6j6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:106;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Bilbo\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/bilbo/v6/-ty-lPs5H7OIucWbnpFrkA.ttf\";}}i:107;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Bilbo Swash Caps\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/bilboswashcaps/v7/UB_-crLvhx-PwGKW1oosDmYeFSdnSpRYv5h9gpdlD1g.ttf\";}}i:108;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"BioRhyme\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"200\";s:86:\"http://fonts.gstatic.com/s/biorhyme/v1/bj-6g_1gJHCc9xQZtLWL36CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/biorhyme/v1/jWqHmLFlu30n7xp12uZd8qCWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/biorhyme/v1/n6v5UkVPy_CjbP3fvsu1CA.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/biorhyme/v1/36KN76U1iKt5TFDm2lBz0KCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"800\";s:86:\"http://fonts.gstatic.com/s/biorhyme/v1/k6bYbUnESjLYnworWvSTL6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:109;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"BioRhyme Expanded\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"200\";s:94:\"http://fonts.gstatic.com/s/biorhymeexpanded/v2/FKL4Vyxmq2vsiDrSOzz2sC7oxZzNh3ej55UHm-HviBI.ttf\";s:3:\"300\";s:94:\"http://fonts.gstatic.com/s/biorhymeexpanded/v2/FKL4Vyxmq2vsiDrSOzz2sFu4cYPPksG4MRjB5UiYPPw.ttf\";s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/biorhymeexpanded/v2/hgBNpgjTRZzGmZxqN5OuVjndr_hij4ilAk2n1d1AhsE.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/biorhymeexpanded/v2/FKL4Vyxmq2vsiDrSOzz2sMVisRVfPEfQ0jijOMQbr0Q.ttf\";s:3:\"800\";s:94:\"http://fonts.gstatic.com/s/biorhymeexpanded/v2/FKL4Vyxmq2vsiDrSOzz2sIv1v1eCT6RPbcYZYQ1T1CE.ttf\";}}i:110;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Biryani\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"200\";s:85:\"http://fonts.gstatic.com/s/biryani/v1/Xx38YzyTFF8n6mRS1Yd88vesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"300\";s:85:\"http://fonts.gstatic.com/s/biryani/v1/u-bneRbizmFMd0VQp5Ze6vesZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/biryani/v1/W7bfR8-IY76Xz0QoB8L2xw.ttf\";s:3:\"600\";s:85:\"http://fonts.gstatic.com/s/biryani/v1/1EdcPCVxBR2txgjrza6_YPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/biryani/v1/qN2MTZ0j1sKSCtfXLB2dR_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"800\";s:85:\"http://fonts.gstatic.com/s/biryani/v1/DJyziS7FEy441v22InYdevesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"900\";s:85:\"http://fonts.gstatic.com/s/biryani/v1/trcLkrIut0lM_PPSyQfAMPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:111;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Bitter\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/bitter/v10/w_BNdJvVZDRmqy5aSfB2kQ.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/bitter/v10/TC0FZEVzXQIGgzmRfKPZbA.ttf\";s:3:\"700\";s:64:\"http://fonts.gstatic.com/s/bitter/v10/4dUtr_4BvHuoRU35suyOAg.ttf\";}}i:112;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Black Ops One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/blackopsone/v7/2XW-DmDsGbDLE372KrMW1Yjjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:113;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Bokor\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/bokor/v8/uAKdo0A85WW23Gs6mcbw7A.ttf\";}}i:114;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Bonbon\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/bonbon/v7/IW3u1yzG1knyW5oz0s9_6Q.ttf\";}}i:115;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Boogaloo\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/boogaloo/v6/4Wu1tvFMoB80fSu8qLgQfQ.ttf\";}}i:116;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Bowlby One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/bowlbyone/v7/eKpHjHfjoxM2bX36YNucefesZW2xOQ-xsNqO47m55DA.ttf\";}}i:117;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Bowlby One SC\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/bowlbyonesc/v8/8ZkeXftTuzKBtmxOYXoRedDkZCMxWJecxjvKm2f8MJw.ttf\";}}i:118;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Brawler\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/brawler/v6/3gfSw6imxQnQxweVITqUrg.ttf\";}}i:119;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Bree Serif\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/breeserif/v5/5h9crBVIrvZqgf34FHcnEfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:120;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Bubblegum Sans\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/bubblegumsans/v5/Y9iTUUNz6lbl6TrvV4iwsytnKWgpfO2iSkLzTz-AABg.ttf\";}}i:121;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Bubbler One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/bubblerone/v4/e8S0qevkZAFaBybtt_SU4qCWcynf_cDxXwCLxiixG1c.ttf\";}}i:122;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Buda\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:3:\"300\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:3:\"300\";s:61:\"http://fonts.gstatic.com/s/buda/v6/hLtAmNUmEMJH2yx7NGUjnA.ttf\";}}i:123;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Buenard\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/buenard/v7/NSpMPGKAUgrLrlstYVvIXQ.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/buenard/v7/yUlGE115dGr7O9w9FlP3UvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:124;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Bungee\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/bungee/v2/0jM4G9s968t1_tpwzM9UDg.ttf\";}}i:125;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Bungee Hairline\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/bungeehairline/v2/8Li3dr3whdkxuk7pmLaZaSom6rTIagUDR1YFcrrRZjQ.ttf\";}}i:126;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Bungee Inline\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/bungeeinline/v2/Tb-1914q4rFpjT-F66PLCYjjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:127;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Bungee Outline\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/bungeeoutline/v2/PcidvzXIcqS2Qwxm_iG6bLAREgn5xbW23GEXXnhMQ5Y.ttf\";}}i:128;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Bungee Shade\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/bungeeshade/v2/HSW7pxPYXBWkq7OSnuXoeC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:129;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Butcherman\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/butcherman/v7/bxiJmD567sPBVpJsT0XR0vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:130;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Butterfly Kids\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/butterflykids/v4/J4NTF5M25htqeTffYImtlUZaDk62iwTBnbnvwSjZciA.ttf\";}}i:131;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Cabin\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":8:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/cabin/v10/XeuAFYo2xAPHxZGBbQtHhA.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/cabin/v10/0tJ9k3DI5xC4GBgs1E_Jxw.ttf\";s:3:\"500\";s:63:\"http://fonts.gstatic.com/s/cabin/v10/HgsCQ-k3_Z_uQ86aFolNBg.ttf\";s:9:\"500italic\";s:84:\"http://fonts.gstatic.com/s/cabin/v10/50sjhrGE0njyO-7mGDhGP_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:63:\"http://fonts.gstatic.com/s/cabin/v10/eUDAvKhBtmTCkeVBsFk34A.ttf\";s:9:\"600italic\";s:84:\"http://fonts.gstatic.com/s/cabin/v10/sFQpQDBd3G2om0Nl5dD2CvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/cabin/v10/4EKhProuY1hq_WCAomq9Dg.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/cabin/v10/K83QKi8MOKLEqj6bgZ7LrfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:132;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Cabin Condensed\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/cabincondensed/v9/B0txb0blf2N29WdYPJjMSiQPsWWoiv__AzYJ9Zzn9II.ttf\";s:3:\"500\";s:92:\"http://fonts.gstatic.com/s/cabincondensed/v9/Ez4zJbsGr2BgXcNUWBVgEARL_-ABKXdjsJSPT0lc2Bk.ttf\";s:3:\"600\";s:92:\"http://fonts.gstatic.com/s/cabincondensed/v9/Ez4zJbsGr2BgXcNUWBVgELS5sSASxc8z4EQTQj7DCAI.ttf\";s:3:\"700\";s:92:\"http://fonts.gstatic.com/s/cabincondensed/v9/Ez4zJbsGr2BgXcNUWBVgEMAWgzcA047xWLixhLCofl8.ttf\";}}i:133;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Cabin Sketch\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/cabinsketch/v10/d9fijO34zQajqQvl3YHRCS3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/cabinsketch/v10/ki3SSN5HMOO0-IOLOj069ED2ttfZwueP-QU272T9-k4.ttf\";}}i:134;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Caesar Dressing\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/caesardressing/v5/2T_WzBgE2Xz3FsyJMq34T9gR43u4FvCuJwIfF5Zxl6Y.ttf\";}}i:135;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Cagliostro\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/cagliostro/v5/i85oXbtdSatNEzss99bpj_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:136;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Cairo\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"200\";s:62:\"http://fonts.gstatic.com/s/cairo/v1/9BU6Hrio9syG9zwo_CNPXg.ttf\";s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/cairo/v1/mpy3SIEJVOIfFnVLujcRDg.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/cairo/v1/-tPnHq7mmAjcjJRSjsuZGA.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/cairo/v1/Ct_3a0tcTEyNNSnuZKDd7g.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/cairo/v1/ONxTSBYfmg-V5CkIwS_5gQ.ttf\";s:3:\"900\";s:62:\"http://fonts.gstatic.com/s/cairo/v1/Fm-hIVCp5OI5mO4Ec71jcw.ttf\";}}i:137;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Calligraffitti\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/calligraffitti/v7/vLVN2Y-z65rVu1R7lWdvyDXz_orj3gX0_NzfmYulrko.ttf\";}}i:138;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Cambay\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/cambay/v1/etU9Bab4VuhzS-OKsb1VXg.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/cambay/v1/ZEz9yNqpEOgejaw1rBhugQ.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/cambay/v1/jw9niBxa04eEhnSwTWCEgw.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/cambay/v1/j-5v_uUr0NXTumWN0siOiaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:139;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Cambo\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/cambo/v5/PnwpRuTdkYCf8qk4ajmNRA.ttf\";}}i:140;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Candal\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/candal/v6/x44dDW28zK7GR1gGDBmj9g.ttf\";}}i:141;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Cantarell\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/cantarell/v6/p5ydP_uWQ5lsFzcP_XVMEw.ttf\";s:6:\"italic\";s:87:\"http://fonts.gstatic.com/s/cantarell/v6/DTCLtOSqP-7dgM-V_xKUjqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/cantarell/v6/Yir4ZDsCn4g1kWopdg-ehC3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:87:\"http://fonts.gstatic.com/s/cantarell/v6/weehrwMeZBXb0QyrWnRwFXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:142;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Cantata One\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/cantataone/v6/-a5FDvnBqaBMDaGgZYnEfqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:143;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Cantora One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2017-03-29\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/cantoraone/v6/oI-DS62RbHI8ZREjp73ehqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:144;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Capriola\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/capriola/v4/JxXPlkdzWwF9Cwelbvi9jA.ttf\";}}i:145;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Cardo\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"greek\";i:1;s:9:\"greek-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/cardo/v8/jbkF2_R0FKUEZTq5dwSknQ.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/cardo/v8/pcv4Np9tUkq0YREYUcEEJQ.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/cardo/v8/lQN30weILimrKvp8rZhF1w.ttf\";}}i:146;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Carme\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/carme/v7/08E0NP1eRBEyFRUadmMfgA.ttf\";}}i:147;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Carrois Gothic\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/carroisgothic/v5/GCgb7bssGpwp7V5ynxmWy2x3d0cwUleGuRTmCYfCUaM.ttf\";}}i:148;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Carrois Gothic SC\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/carroisgothicsc/v5/bVp4nhwFIXU-r3LqUR8DSJTdPW1ioadGi2uRiKgJVCY.ttf\";}}i:149;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Carter One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/carterone/v8/5X_LFvdbcB7OBG7hBgZ7fPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:150;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Catamaran\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"tamil\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2017-03-29\";s:5:\"files\";O:8:\"stdClass\":9:{s:3:\"100\";s:87:\"http://fonts.gstatic.com/s/catamaran/v2/ilWHBiy0krUPdlmYxDuqC6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"200\";s:87:\"http://fonts.gstatic.com/s/catamaran/v2/hFc-HKSsGk6M-psujei1MC3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"300\";s:87:\"http://fonts.gstatic.com/s/catamaran/v2/Aaag4ccR7Oh_4eai-jbrYC3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/catamaran/v2/MdNkM-DU8f6R-25Nxpr_XA.ttf\";s:3:\"500\";s:87:\"http://fonts.gstatic.com/s/catamaran/v2/83WSX3F86qsvj1Z4EI0tQi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"600\";s:87:\"http://fonts.gstatic.com/s/catamaran/v2/a9PlHHnuBWiGGk0TwuFKTi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/catamaran/v2/PpgVtUHUdnBZYNpnzGbScy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"800\";s:87:\"http://fonts.gstatic.com/s/catamaran/v2/6VjB_uSfn3DZ93IQv58CmC3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"900\";s:87:\"http://fonts.gstatic.com/s/catamaran/v2/5ys9TqpQc9Q6gHqbSox6py3USBnSvpkopQaUR-2r7iU.ttf\";}}i:151;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Caudex\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"greek\";i:1;s:9:\"greek-ext\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/caudex/v6/PWEexiHLDmQbn2b1OPZWfg.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/caudex/v6/XjMZF6XCisvV3qapD4oJdw.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/caudex/v6/PetCI4GyQ5Q3LiOzUu_mMg.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/caudex/v6/yT8YeHLjaJvQXlUEYOA8gqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:152;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Caveat\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/caveat/v2/8I23b6N-6rRVbh-C_Vx3yA.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/caveat/v2/LkaFtQENGJry2eUMwGRTeA.ttf\";}}i:153;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Caveat Brush\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/caveatbrush/v2/_d7bgsk3hfC4DXnUEeYKsy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:154;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Cedarville Cursive\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/cedarvillecursive/v7/cuCe6HrkcqrWTWTUE7dw-41zwq9-z_Lf44CzRAA0d0Y.ttf\";}}i:155;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Ceviche One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/cevicheone/v7/WOaXIMBD4VYMy39MsobJhKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:156;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Changa\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"200\";s:63:\"http://fonts.gstatic.com/s/changa/v2/QNWVD9FzsnhVmHzE7HryDQ.ttf\";s:3:\"300\";s:63:\"http://fonts.gstatic.com/s/changa/v2/OKZ0H1bMg3M9EZMVzgQ9fg.ttf\";s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/changa/v2/7_e8qktkj6uKM0DamZJY9Q.ttf\";s:3:\"500\";s:63:\"http://fonts.gstatic.com/s/changa/v2/KrXcHYf9ILB8aFWCj0Vfxg.ttf\";s:3:\"600\";s:63:\"http://fonts.gstatic.com/s/changa/v2/6uCpqxwcsYkfV0M8Ls6WPA.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/changa/v2/vAXzeaPkdpxlejFN7h0ibw.ttf\";s:3:\"800\";s:63:\"http://fonts.gstatic.com/s/changa/v2/H3IsiH2Fx0Pc4_OU4HSpng.ttf\";}}i:157;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Changa One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/changaone/v9/dr4qjce4W3kxFrZRkVD87fesZW2xOQ-xsNqO47m55DA.ttf\";s:6:\"italic\";s:87:\"http://fonts.gstatic.com/s/changaone/v9/wJVQlUs1lAZel-WdTo2U9y3USBnSvpkopQaUR-2r7iU.ttf\";}}i:158;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Chango\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/chango/v5/3W3AeMMtRTH08t5qLOjBmg.ttf\";}}i:159;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Chathura\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"100\";s:86:\"http://fonts.gstatic.com/s/chathura/v1/7tUse0wFXIOSPewsdeNXPvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/chathura/v1/Gmhr6ULHnPDt9spOZrHOfKCWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/chathura/v1/7hRNO-_zjRopkcP2n1rr8g.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/chathura/v1/BO9LvNAseMQ3n1tKWH-uTKCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"800\";s:86:\"http://fonts.gstatic.com/s/chathura/v1/prh_X_5NSsBQefIdGi5B6KCWcynf_cDxXwCLxiixG1c.ttf\";}}i:160;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Chau Philomene One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/chauphilomeneone/v5/KKc5egCL-a2fFVoOA2x6tBFi5dxgSTdxqnMJgWkBJcg.ttf\";s:6:\"italic\";s:94:\"http://fonts.gstatic.com/s/chauphilomeneone/v5/eJj1PY_iN4KiIuyOvtMHJP6uyLkxyiC4WcYA74sfquE.ttf\";}}i:161;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Chela One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/chelaone/v5/h5O0dEnpnIq6jQnWxZybrA.ttf\";}}i:162;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Chelsea Market\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/chelseamarket/v4/qSdzwh2A4BbNemy78sJLfAAI1i8fIftCBXsBF2v9UMI.ttf\";}}i:163;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Chenla\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/chenla/v9/aLNpdAUDq2MZbWz2U1a16g.ttf\";}}i:164;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Cherry Cream Soda\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/cherrycreamsoda/v6/OrD-AUnFcZeeKa6F_c0_WxOiHiuAPYA9ry3O1RG2XIU.ttf\";}}i:165;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Cherry Swash\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/cherryswash/v4/HqOk7C7J1TZ5i3L-ejF0vi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/cherryswash/v4/-CfyMyQqfucZPQNB0nvYyED2ttfZwueP-QU272T9-k4.ttf\";}}i:166;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Chewy\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/chewy/v7/hcDN5cvQdIu6Bx4mg_TSyw.ttf\";}}i:167;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Chicle\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/chicle/v5/xg4q57Ut9ZmyFwLp51JLgg.ttf\";}}i:168;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Chivo\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-26\";s:5:\"files\";O:8:\"stdClass\":8:{s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/chivo/v8/NB24D2RW9gYUd3ctGd-AhA.ttf\";s:9:\"300italic\";s:83:\"http://fonts.gstatic.com/s/chivo/v8/A0NbKkUXhyt-4OxUzvrNT_esZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/chivo/v8/L88PEuzS9eRfHRZhAPhZyw.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/chivo/v8/Oe3-Q-a2kBzPnhHck_baMg.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/chivo/v8/zC8JLnJuu9Lw0_rA3_VYhg.ttf\";s:9:\"700italic\";s:83:\"http://fonts.gstatic.com/s/chivo/v8/2M3ifXA84fdnDIxoCi18JvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"900\";s:62:\"http://fonts.gstatic.com/s/chivo/v8/JAdkiWd46QCW4vOsj3dzTA.ttf\";s:9:\"900italic\";s:83:\"http://fonts.gstatic.com/s/chivo/v8/LoszYnE86q2wJEOjCigBQ_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:169;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Chonburi\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/chonburi/v1/jd9PfbW0x_8Myt_XeUxvSQ.ttf\";}}i:170;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Cinzel\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/cinzel/v4/GF7dy_Nc-a6EaHYSyGd-EA.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/cinzel/v4/nYcFQ6_3pf_6YDrOFjBR8Q.ttf\";s:3:\"900\";s:63:\"http://fonts.gstatic.com/s/cinzel/v4/FTBj72ozM2cEOSxiVsRb3A.ttf\";}}i:171;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Cinzel Decorative\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/cinzeldecorative/v4/fmgK7oaJJIXAkhd9798yQgT5USbJx2F82lQbogPy2bY.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/cinzeldecorative/v4/pXhIVnhFtL_B9Vb1wq2F95-YYVDmZkJErg0zgx9XuZI.ttf\";s:3:\"900\";s:94:\"http://fonts.gstatic.com/s/cinzeldecorative/v4/pXhIVnhFtL_B9Vb1wq2F97Khqbv0zQZa0g-9HOXAalU.ttf\";}}i:172;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Clicker Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/clickerscript/v4/Zupmk8XwADjufGxWB9KThBnpV0hQCek3EmWnCPrvGRM.ttf\";}}i:173;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Coda\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/coda/v11/yHDvulhg-P-p2KRgRrnUYw.ttf\";s:3:\"800\";s:62:\"http://fonts.gstatic.com/s/coda/v11/6ZIw0sbALY0KTMWllZB3hQ.ttf\";}}i:174;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Coda Caption\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:3:\"800\";s:89:\"http://fonts.gstatic.com/s/codacaption/v9/YDl6urZh-DUFhiMBTgAnz_qsay_1ZmRGmC8pVRdIfAg.ttf\";}}i:175;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Codystar\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/codystar/v4/EVaUzfJkcb8Zqx9kzQLXqqCWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/codystar/v4/EN-CPFKYowSI7SuR7-0cZA.ttf\";}}i:176;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Coiny\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"tamil\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/coiny/v1/B-pC9lRxssd2RDK37Rdekw.ttf\";}}i:177;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Combo\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/combo/v5/Nab98KjR3JZSSPGtzLyXNw.ttf\";}}i:178;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Comfortaa\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:6:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:12:\"cyrillic-ext\";i:5;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2017-01-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:87:\"http://fonts.gstatic.com/s/comfortaa/v9/r_tUZNl0G8xCoOmp_JkSCi3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/comfortaa/v9/lZx6C1VViPgSOhCBUP7hXA.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/comfortaa/v9/fND5XPYKrF2tQDwwfWZJIy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:179;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Coming Soon\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/comingsoon/v6/Yz2z3IAe2HSQAOWsSG8COKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:180;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Concert One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/concertone/v7/N5IWCIGhUNdPZn_efTxKN6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:181;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Condiment\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/condiment/v4/CstmdiPpgFSV0FUNL5LrJA.ttf\";}}i:182;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Content\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/content/v8/l8qaLjygvOkDEU2G6-cjfQ.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/content/v8/7PivP8Zvs2qn6F6aNbSQe_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:183;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Contrail One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/contrailone/v6/b41KxjgiyqX-hkggANDU6C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:184;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Convergence\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/convergence/v5/eykrGz1NN_YpQmkAZjW-qKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:185;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Cookie\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/cookie/v7/HxeUC62y_YdDbiFlze357A.ttf\";}}i:186;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Copse\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/copse/v6/wikLrtPGjZDvZ5w2i5HLWg.ttf\";}}i:187;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Corben\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/corben/v9/tTysMZkt-j8Y5yhkgsoajQ.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/corben/v9/lirJaFSQWdGQuV--fksg5g.ttf\";}}i:188;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Cormorant\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2017-01-25\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"300\";s:87:\"http://fonts.gstatic.com/s/cormorant/v3/diggKPcUerIA8GQWRVxsVS3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"300italic\";s:87:\"http://fonts.gstatic.com/s/cormorant/v3/UydD9tmk-DfLnEFRr_bBZy9-WlPSxbfiI49GsXo3q0g.ttf\";s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/cormorant/v3/9vWr5LgrNEgvhv1P3z9uuQ.ttf\";s:6:\"italic\";s:87:\"http://fonts.gstatic.com/s/cormorant/v3/zzcH3j00ejnIc8jicdcz6KCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"500\";s:87:\"http://fonts.gstatic.com/s/cormorant/v3/lwoiMb1lzDf49h802vpRUy3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"500italic\";s:87:\"http://fonts.gstatic.com/s/cormorant/v3/UydD9tmk-DfLnEFRr_bBZ8CNfqCYlB_eIx7H1TVXe60.ttf\";s:3:\"600\";s:87:\"http://fonts.gstatic.com/s/cormorant/v3/LKEtp8XimHLN0gSYqnV9qy3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"600italic\";s:87:\"http://fonts.gstatic.com/s/cormorant/v3/UydD9tmk-DfLnEFRr_bBZ5Z7xm-Bj30Bj2KNdXDzSZg.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/cormorant/v3/vOi7JV5F3JmPzXDgUqUwgS3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:87:\"http://fonts.gstatic.com/s/cormorant/v3/UydD9tmk-DfLnEFRr_bBZ3e1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:189;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Cormorant Garamond\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2017-01-25\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"300\";s:95:\"http://fonts.gstatic.com/s/cormorantgaramond/v3/iEjm9hVxcattz37Y8gZwVXDeRRUpi2fYbqcTC9PsYaU.ttf\";s:9:\"300italic\";s:95:\"http://fonts.gstatic.com/s/cormorantgaramond/v3/zuqx3k1yUEl3Eavo-ZPEAjZXe39LdglsIzDOvKnCCso.ttf\";s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/cormorantgaramond/v3/EI2hhCO6kSfLAy-Dpd8fd7_BES7rBA-D9Lo3vCx9yHc.ttf\";s:6:\"italic\";s:95:\"http://fonts.gstatic.com/s/cormorantgaramond/v3/eGTlzchVxDKKvK6d7drzlkVlEttMzBRhK_wsRQ4MqEE.ttf\";s:3:\"500\";s:95:\"http://fonts.gstatic.com/s/cormorantgaramond/v3/iEjm9hVxcattz37Y8gZwVSkwnhSVYGQY4MSUB3uw374.ttf\";s:9:\"500italic\";s:95:\"http://fonts.gstatic.com/s/cormorantgaramond/v3/zuqx3k1yUEl3Eavo-ZPEAq8qrY1CcUgPLrA3ytfr3SY.ttf\";s:3:\"600\";s:95:\"http://fonts.gstatic.com/s/cormorantgaramond/v3/iEjm9hVxcattz37Y8gZwVVc2xdGA7R8efE0K6NwSoyI.ttf\";s:9:\"600italic\";s:95:\"http://fonts.gstatic.com/s/cormorantgaramond/v3/zuqx3k1yUEl3Eavo-ZPEAqms9Rm_p2hhD4xhClOGPEw.ttf\";s:3:\"700\";s:95:\"http://fonts.gstatic.com/s/cormorantgaramond/v3/iEjm9hVxcattz37Y8gZwVdNg01MkafbqNYmDx8wt95c.ttf\";s:9:\"700italic\";s:95:\"http://fonts.gstatic.com/s/cormorantgaramond/v3/zuqx3k1yUEl3Eavo-ZPEAvEntfLz8TC-DlAIEJQEwCA.ttf\";}}i:190;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Cormorant Infant\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2017-01-25\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"300\";s:93:\"http://fonts.gstatic.com/s/cormorantinfant/v3/MYRpw6pQIf0XStsiZXQWA_alucuYFvoGqpCMGloCN2Y.ttf\";s:9:\"300italic\";s:93:\"http://fonts.gstatic.com/s/cormorantinfant/v3/PK34LKusK6SSQFR2m5-LZgNCjGMFnYSoo4kW2wZNowE.ttf\";s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/cormorantinfant/v3/q5F0I_a42y_qtMoOtqdjagGlf-pqPDOheSBqZOVpkRo.ttf\";s:6:\"italic\";s:93:\"http://fonts.gstatic.com/s/cormorantinfant/v3/U6OamtMgLoVs0zd53Z1pNpbq6_N3pcDBvA-VsecMIAA.ttf\";s:3:\"500\";s:93:\"http://fonts.gstatic.com/s/cormorantinfant/v3/MYRpw6pQIf0XStsiZXQWA4PJQ8Vh-2Qw35Pq7cVYzdo.ttf\";s:9:\"500italic\";s:93:\"http://fonts.gstatic.com/s/cormorantinfant/v3/PK34LKusK6SSQFR2m5-LZq9x-au7fLBTFpfuT52_G64.ttf\";s:3:\"600\";s:93:\"http://fonts.gstatic.com/s/cormorantinfant/v3/MYRpw6pQIf0XStsiZXQWA9G0tNuOpbNMRdNl4S5e-n0.ttf\";s:9:\"600italic\";s:93:\"http://fonts.gstatic.com/s/cormorantinfant/v3/PK34LKusK6SSQFR2m5-LZkZbdnTqrL_1WMEFjxg0OwY.ttf\";s:3:\"700\";s:93:\"http://fonts.gstatic.com/s/cormorantinfant/v3/MYRpw6pQIf0XStsiZXQWAx-3ZynwDtU_450Ho62jf_I.ttf\";s:9:\"700italic\";s:93:\"http://fonts.gstatic.com/s/cormorantinfant/v3/PK34LKusK6SSQFR2m5-LZmKEEmz9BBHY1o7RrRAiUXQ.ttf\";}}i:191;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Cormorant SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2017-01-25\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:89:\"http://fonts.gstatic.com/s/cormorantsc/v3/CCo4fI9EYzhUJcvojQ9Em6cQoVhARpoaILP7amxE_8g.ttf\";s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/cormorantsc/v3/o2HxNCgvhmwJdltu-68tzC3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"500\";s:89:\"http://fonts.gstatic.com/s/cormorantsc/v3/CCo4fI9EYzhUJcvojQ9Em5MQuUSAwdHsY8ov_6tk1oA.ttf\";s:3:\"600\";s:89:\"http://fonts.gstatic.com/s/cormorantsc/v3/CCo4fI9EYzhUJcvojQ9Em2v8CylhIUtwUiYO7Z2wXbE.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/cormorantsc/v3/CCo4fI9EYzhUJcvojQ9Em0D2ttfZwueP-QU272T9-k4.ttf\";}}i:192;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Cormorant Unicase\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2017-01-25\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:94:\"http://fonts.gstatic.com/s/cormorantunicase/v3/-0mwRHhjEGfrz-UDHJ_78TyAYAK5JX1-zBpfFXu9t3Y.ttf\";s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/cormorantunicase/v3/THO7JMNV6qRoZlg7dU5RUz01TLsHlMvD1uPU3gXOh9s.ttf\";s:3:\"500\";s:94:\"http://fonts.gstatic.com/s/cormorantunicase/v3/-0mwRHhjEGfrz-UDHJ_78WActzpz5sLElWWJpZBcHK4.ttf\";s:3:\"600\";s:94:\"http://fonts.gstatic.com/s/cormorantunicase/v3/-0mwRHhjEGfrz-UDHJ_78U0bQT13XmwBbvkXy6Yb64Y.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/cormorantunicase/v3/-0mwRHhjEGfrz-UDHJ_78Z5CFeQBXku3ADXbkP2V7W8.ttf\";}}i:193;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Cormorant Upright\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2017-01-25\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:94:\"http://fonts.gstatic.com/s/cormorantupright/v3/PwJT_lCdbLUyVq-tARIPhjCfCvaSiUMfec2BKBTMAaw.ttf\";s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/cormorantupright/v3/0n68kajKjTOJn9EPQkf1a-ojtTJJf2MtgkoRSid3NcM.ttf\";s:3:\"500\";s:94:\"http://fonts.gstatic.com/s/cormorantupright/v3/PwJT_lCdbLUyVq-tARIPhiWhx5Kr-bzfZXhgF-AnSvk.ttf\";s:3:\"600\";s:94:\"http://fonts.gstatic.com/s/cormorantupright/v3/PwJT_lCdbLUyVq-tARIPhuDigFx2V_wQ4SOTZdg5a2s.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/cormorantupright/v3/PwJT_lCdbLUyVq-tARIPhuO6SP7lRr11seyd3AkK37Q.ttf\";}}i:194;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Courgette\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/courgette/v4/2YO0EYtyE9HUPLZprahpZA.ttf\";}}i:195;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Cousine\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:8:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:6:\"hebrew\";i:7;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/cousine/v10/GYX4bPXObJNJo63QJEUnLg.ttf\";s:6:\"italic\";s:65:\"http://fonts.gstatic.com/s/cousine/v10/1WtIuajLoo8vjVwsrZ3eOg.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/cousine/v10/FXEOnNUcCzhdtoBxiq-lovesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/cousine/v10/y_AZ5Sz-FwL1lux2xLSTZS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:196;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Coustard\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/coustard/v6/iO2Rs5PmqAEAXoU3SkMVBg.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/coustard/v6/W02OCWO6OfMUHz6aVyegQ6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:197;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:21:\"Covered By Your Grace\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:96:\"http://fonts.gstatic.com/s/coveredbyyourgrace/v6/6ozZp4BPlrbDRWPe3EBGA6CVUMdvnk-GcAiZQrX9Gek.ttf\";}}i:198;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Crafty Girls\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/craftygirls/v5/0Sv8UWFFdhQmesHL32H8oy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:199;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Creepster\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/creepster/v5/0vdr5kWJ6aJlOg5JvxnXzQ.ttf\";}}i:200;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Crete Round\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/creteround/v5/B8EwN421qqOCCT8vOH4wJ6CWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:88:\"http://fonts.gstatic.com/s/creteround/v5/5xAt7XK2vkUdjhGtt98unUeOrDcLawS7-ssYqLr2Xp4.ttf\";}}i:201;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Crimson Text\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/crimsontext/v6/3IFMwfRa07i-auYR-B-zNS3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:89:\"http://fonts.gstatic.com/s/crimsontext/v6/a5QZnvmn5amyNI-t2BMkWPMZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"600\";s:89:\"http://fonts.gstatic.com/s/crimsontext/v6/rEy5tGc5HdXy56Xvd4f3I2v8CylhIUtwUiYO7Z2wXbE.ttf\";s:9:\"600italic\";s:89:\"http://fonts.gstatic.com/s/crimsontext/v6/4j4TR-EfnvCt43InYpUNDIR-5-urNOGAobhAyctHvW8.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/crimsontext/v6/rEy5tGc5HdXy56Xvd4f3I0D2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:89:\"http://fonts.gstatic.com/s/crimsontext/v6/4j4TR-EfnvCt43InYpUNDPAs9-1nE9qOqhChW0m4nDE.ttf\";}}i:202;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Croissant One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/croissantone/v4/mPjsOObnC77fp1cvZlOfIYjjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:203;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Crushed\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/crushed/v6/aHwSejs3Kt0Lg95u7j32jA.ttf\";}}i:204;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Cuprum\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-19\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/cuprum/v8/JgXs0F_UiaEdAS74msmFNg.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/cuprum/v8/cLEz0KV6OxInnktSzpk58g.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/cuprum/v8/6tl3_FkDeXSD72oEHuJh4w.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/cuprum/v8/bnkXaBfoYvaJ75axRPSwVKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:205;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Cutive\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/cutive/v8/G2bW-ImyOCwKxBkLyz39YQ.ttf\";}}i:206;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Cutive Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/cutivemono/v5/ncWQtFVKcSs8OW798v30k6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:207;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Damion\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/damion/v6/13XtECwKxhD_VrOqXL4SiA.ttf\";}}i:208;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Dancing Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/dancingscript/v8/DK0eTGXiZjN6yA8zAEyM2RnpV0hQCek3EmWnCPrvGRM.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/dancingscript/v8/KGBfwabt0ZRLA5W1ywjowb_dAmXiKjTPGCuO6G2MbfA.ttf\";}}i:209;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Dangrek\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/dangrek/v8/LOaFhBT-EHNxZjV8DAW_ew.ttf\";}}i:210;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"David Libre\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:6:\"hebrew\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/davidlibre/v1/Fp_YuX4CP0pzlSUtACdOo6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"500\";s:88:\"http://fonts.gstatic.com/s/davidlibre/v1/ea-623K8OFNeGhfSzdpmysCNfqCYlB_eIx7H1TVXe60.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/davidlibre/v1/ea-623K8OFNeGhfSzdpmyne1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:211;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Dawning of a New Day\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/dawningofanewday/v7/JiDsRhiKZt8uz3NJ5xA06gXLnohmOYWQZqo_sW8GLTk.ttf\";}}i:212;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Days One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/daysone/v6/kzwZjNhc1iabMsrc_hKBIA.ttf\";}}i:213;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Dekko\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/dekko/v3/AKtgABKC1rUxgIgS-bpojw.ttf\";}}i:214;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Delius\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/delius/v6/TQA163qafki2-gV-B6F_ag.ttf\";}}i:215;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Delius Swash Caps\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/deliusswashcaps/v8/uXyrEUnoWApxIOICunRq7yIrxb5zDVgU2N3VzXm7zq4.ttf\";}}i:216;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Delius Unicase\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/deliusunicase/v9/b2sKujV3Q48RV2PQ0k1vqu6rPKfVZo7L2bERcf0BDns.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/deliusunicase/v9/7FTMTITcb4dxUp99FAdTqNy5weKXdcrx-wE0cgECMq8.ttf\";}}i:217;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Della Respira\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/dellarespira/v4/F4E6Lo_IZ6L9AJCcbqtDVeDcg5akpSnIcsPhLOFv7l8.ttf\";}}i:218;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Denk One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/denkone/v4/TdXOeA4eA_hEx4W8Sh9wPw.ttf\";}}i:219;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Devonshire\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/devonshire/v5/I3ct_2t12SYizP8ZC-KFi_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:220;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Dhurjati\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/dhurjati/v4/uV6jO5e2iFMbGB0z79Cy5g.ttf\";}}i:221;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Didact Gothic\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:6:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2017-01-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/didactgothic/v10/v8_72sD3DYMKyM0dn3LtWotBLojGU5Qdl8-5NL4v70w.ttf\";}}i:222;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Diplomata\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/diplomata/v8/u-ByBiKgN6rTMA36H3kcKg.ttf\";}}i:223;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Diplomata SC\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/diplomatasc/v5/JdVwAwfE1a_pahXjk5qpNi3USBnSvpkopQaUR-2r7iU.ttf\";}}i:224;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Domine\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/domine/v4/wfVIgamVFjMNQAEWurCiHA.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/domine/v4/phBcG1ZbQFxUIt18hPVxnw.ttf\";}}i:225;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Donegal One\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/donegalone/v4/6kN4-fDxz7T9s5U61HwfF6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:226;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Doppio One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/doppioone/v4/WHZ3HJQotpk_4aSMNBo_t_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:227;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Dorsa\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/dorsa/v7/wCc3cUe6XrmG2LQE6GlIrw.ttf\";}}i:228;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Dosis\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"200\";s:62:\"http://fonts.gstatic.com/s/dosis/v6/ztftab0r6hcd7AeurUGrSQ.ttf\";s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/dosis/v6/awIB6L0h5mb0plIKorXmuA.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/dosis/v6/rJRlixu-w0JZ1MyhJpao_Q.ttf\";s:3:\"500\";s:62:\"http://fonts.gstatic.com/s/dosis/v6/ruEXDOFMxDPGnjCBKRqdAQ.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/dosis/v6/KNAswRNwm3tfONddYyidxg.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/dosis/v6/AEEAj0ONidK8NQQMBBlSig.ttf\";s:3:\"800\";s:62:\"http://fonts.gstatic.com/s/dosis/v6/nlrKd8E69vvUU39XGsvR7Q.ttf\";}}i:229;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Dr Sugiyama\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/drsugiyama/v5/S5Yx3MIckgoyHhhS4C9Tv6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:230;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Droid Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/droidsans/v6/rS9BT6-asrfjpkcV3DXf__esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/droidsans/v6/EFpQQyG9GqCrobXxL-KRMQJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:231;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Droid Sans Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/droidsansmono/v7/ns-m2xQYezAtqh7ai59hJcwD6PD0c3_abh9zHKQtbGU.ttf\";}}i:232;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Droid Serif\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/droidserif/v6/DgAtPy6rIVa2Zx3Xh9KaNaCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:88:\"http://fonts.gstatic.com/s/droidserif/v6/cj2hUnSRBhwmSPr9kS5890eOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/droidserif/v6/QQt14e8dY39u-eYBZmppwXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:88:\"http://fonts.gstatic.com/s/droidserif/v6/c92rD_x0V1LslSFt3-QEps_zJjSACmk0BRPxQqhnNLU.ttf\";}}i:233;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Duru Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/durusans/v9/xn7iYH8xwmSyTvEV_HOxTw.ttf\";}}i:234;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Dynalight\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/dynalight/v5/-CWsIe8OUDWTIHjSAh41kA.ttf\";}}i:235;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"EB Garamond\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/ebgaramond/v7/CDR0kuiFK7I1OZ2hSdR7G6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:236;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Eagle Lake\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/eaglelake/v4/ZKlYin7caemhx9eSg6RvPfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:237;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Eater\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/eater/v5/gm6f3OmYEdbs3lPQtUfBkA.ttf\";}}i:238;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Economica\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/economica/v4/G4rJRujzZbq9Nxngu9l3hg.ttf\";s:6:\"italic\";s:87:\"http://fonts.gstatic.com/s/economica/v4/p5O9AVeUqx_n35xQRinNYaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/economica/v4/UK4l2VEpwjv3gdcwbwXE9C3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:87:\"http://fonts.gstatic.com/s/economica/v4/ac5dlUsedQ03RqGOeay-3Xe1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:239;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Eczar\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":5:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/eczar/v4/uKZcAQ5JBBs1UbeXFRbBRg.ttf\";s:3:\"500\";s:62:\"http://fonts.gstatic.com/s/eczar/v4/Ooe4KaPp2594tF8TbMfdlQ.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/eczar/v4/IjQsWW0bmgkZ6lnN72cnTQ.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/eczar/v4/ELC8RVXfBMb3VuuHtMwBOA.ttf\";s:3:\"800\";s:62:\"http://fonts.gstatic.com/s/eczar/v4/9Uyt6nTZLx_Qj5_WRah-iQ.ttf\";}}i:240;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Ek Mukta\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"200\";s:85:\"http://fonts.gstatic.com/s/ekmukta/v7/crtkNHh5JcM3VJKG0E-B36CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"300\";s:85:\"http://fonts.gstatic.com/s/ekmukta/v7/mpaAv7CIyk0VnZlqSneVxKCWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/ekmukta/v7/aFcjXdC5jyJ1p8w54wIIrg.ttf\";s:3:\"500\";s:85:\"http://fonts.gstatic.com/s/ekmukta/v7/PZ1y2MstFczWvBlFSgzMyaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"600\";s:85:\"http://fonts.gstatic.com/s/ekmukta/v7/Z5Mfzeu6M3emakcJO2QeTqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/ekmukta/v7/4ugcOGR28Jn-oBIn0-qLYaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"800\";s:85:\"http://fonts.gstatic.com/s/ekmukta/v7/O68TH5OjEhVmn9_gIrcfS6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:241;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"El Messiri\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:6:\"arabic\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/elmessiri/v1/dik94vfrFvHFnvdvxaX8N_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"500\";s:87:\"http://fonts.gstatic.com/s/elmessiri/v1/kQW9PA2krAOzditagrX75pp-63r6doWhTEbsfBIRJ7A.ttf\";s:3:\"600\";s:87:\"http://fonts.gstatic.com/s/elmessiri/v1/HYl7TNqFfA1utGLZRWwzLPpTEJqju4Hz1txDWij77d4.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/elmessiri/v1/ji73glXFIetaSqMU3cz7rAJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:242;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Electrolize\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/electrolize/v5/yFVu5iokC-nt4B1Cyfxb9aCWcynf_cDxXwCLxiixG1c.ttf\";}}i:243;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Elsie\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/elsie/v5/gwspePauE45BJu6Ok1QrfQ.ttf\";s:3:\"900\";s:62:\"http://fonts.gstatic.com/s/elsie/v5/1t-9f0N2NFYwAgN7oaISqg.ttf\";}}i:244;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Elsie Swash Caps\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/elsieswashcaps/v4/9L3hIJMPCf6sxCltnxd6X2YeFSdnSpRYv5h9gpdlD1g.ttf\";s:3:\"900\";s:92:\"http://fonts.gstatic.com/s/elsieswashcaps/v4/iZnus9qif0tR5pGaDv5zdKoKBWBozTtxi30NfZDOXXU.ttf\";}}i:245;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Emblema One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/emblemaone/v5/7IlBUjBWPIiw7cr_O2IfSaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:246;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Emilys Candy\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/emilyscandy/v4/PofLVm6v1SwZGOzC8s-I3S3USBnSvpkopQaUR-2r7iU.ttf\";}}i:247;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Engagement\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/engagement/v5/4Uz0Jii7oVPcaFRYmbpU6vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:248;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Englebert\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/englebert/v4/sll38iOvOuarDTYBchlP3Q.ttf\";}}i:249;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Enriqueta\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/enriqueta/v5/_p90TrIwR1SC-vDKtmrv6A.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/enriqueta/v5/I27Pb-wEGH2ajLYP0QrtSC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:250;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Erica One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/ericaone/v7/cIBnH2VAqQMIGYAcE4ufvQ.ttf\";}}i:251;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Esteban\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/esteban/v4/ESyhLgqDDyK5JcFPp2svDw.ttf\";}}i:252;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Euphoria Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/euphoriascript/v4/c4XB4Iijj_NvSsCF4I0O2MxLhO8OSNnfAp53LK1_iRs.ttf\";}}i:253;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Ewert\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/ewert/v4/Em8hrzuzSbfHcTVqMjbAQg.ttf\";}}i:254;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:3:\"Exo\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:60:\"http://fonts.gstatic.com/s/exo/v4/RI7A9uwjRmPbVp0n8e-Jvg.ttf\";s:9:\"100italic\";s:60:\"http://fonts.gstatic.com/s/exo/v4/qtGyZZlWb2EEvby3ZPosxw.ttf\";s:3:\"200\";s:60:\"http://fonts.gstatic.com/s/exo/v4/F8OfC_swrRRxpFt-tlXZQg.ttf\";s:9:\"200italic\";s:60:\"http://fonts.gstatic.com/s/exo/v4/fr4HBfXHYiIngW2_bhlgRw.ttf\";s:3:\"300\";s:60:\"http://fonts.gstatic.com/s/exo/v4/SBrN7TKUqgGUvfxqHqsnNw.ttf\";s:9:\"300italic\";s:60:\"http://fonts.gstatic.com/s/exo/v4/3gmiLjBegIfcDLISjTGA1g.ttf\";s:7:\"regular\";s:60:\"http://fonts.gstatic.com/s/exo/v4/eUEzTFueNXRVhbt4PEB8kQ.ttf\";s:6:\"italic\";s:60:\"http://fonts.gstatic.com/s/exo/v4/cfgolWisMSURhpQeVHl_NA.ttf\";s:3:\"500\";s:60:\"http://fonts.gstatic.com/s/exo/v4/jCg6DmGGXt_OVyp5ofQHPw.ttf\";s:9:\"500italic\";s:60:\"http://fonts.gstatic.com/s/exo/v4/lo5eTdCNJZQVN08p8RnzAQ.ttf\";s:3:\"600\";s:60:\"http://fonts.gstatic.com/s/exo/v4/q_SG5kXUmOcIvFpgtdZnlw.ttf\";s:9:\"600italic\";s:60:\"http://fonts.gstatic.com/s/exo/v4/0cExa8K_pxS2lTuMr68XUA.ttf\";s:3:\"700\";s:60:\"http://fonts.gstatic.com/s/exo/v4/3_jwsL4v9uHjl5Q37G57mw.ttf\";s:9:\"700italic\";s:60:\"http://fonts.gstatic.com/s/exo/v4/0me55yJIxd5vyQ9bF7SsiA.ttf\";s:3:\"800\";s:60:\"http://fonts.gstatic.com/s/exo/v4/yLPuxBuV0lzqibRJyooOJg.ttf\";s:9:\"800italic\";s:60:\"http://fonts.gstatic.com/s/exo/v4/n3LejeKVj_8gtZq5fIgNYw.ttf\";s:3:\"900\";s:60:\"http://fonts.gstatic.com/s/exo/v4/97d0nd6Yv4-SA_X92xAuZA.ttf\";s:9:\"900italic\";s:60:\"http://fonts.gstatic.com/s/exo/v4/JHTkQVhzyLtkY13Ye95TJQ.ttf\";}}i:255;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Exo 2\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/oVOtQy53isv97g4UhBUDqg.ttf\";s:9:\"100italic\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/LNYVgsJcaCxoKFHmd4AZcg.ttf\";s:3:\"200\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/qa-Ci2pBwJdCxciE1ErifQ.ttf\";s:9:\"200italic\";s:82:\"http://fonts.gstatic.com/s/exo2/v3/DCrVxDVvS69n50O-5erZVvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"300\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/nLUBdz_lHHoVIPor05Byhw.ttf\";s:9:\"300italic\";s:82:\"http://fonts.gstatic.com/s/exo2/v3/iSy9VTeUTiqiurQg2ywtu_esZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/Pf_kZuIH5c5WKVkQUaeSWQ.ttf\";s:6:\"italic\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/xxA5ZscX9sTU6U0lZJUlYA.ttf\";s:3:\"500\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/oM0rzUuPqVJpW-VEIpuW5w.ttf\";s:9:\"500italic\";s:82:\"http://fonts.gstatic.com/s/exo2/v3/amzRVCB-gipwdihZZ2LtT_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/YnSn3HsyvyI1feGSdRMYqA.ttf\";s:9:\"600italic\";s:82:\"http://fonts.gstatic.com/s/exo2/v3/Vmo58BiptGwfVFb0teU5gPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/2DiK4XkdTckfTk6we73-bQ.ttf\";s:9:\"700italic\";s:82:\"http://fonts.gstatic.com/s/exo2/v3/Sdo-zW-4_--pDkTg6bYrY_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"800\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/IVYl_7dJruOg8zKRpC8Hrw.ttf\";s:9:\"800italic\";s:82:\"http://fonts.gstatic.com/s/exo2/v3/p0TA6KeOz1o4rySEbvUxI_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"900\";s:61:\"http://fonts.gstatic.com/s/exo2/v3/e8csG8Wnu87AF6uCndkFRQ.ttf\";s:9:\"900italic\";s:82:\"http://fonts.gstatic.com/s/exo2/v3/KPhsGCoT2-7Uj6pMlRscH_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:256;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Expletus Sans\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":8:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/expletussans/v9/gegTSDBDs5le3g6uxU1ZsX8f0n03UdmQgF_CLvNR2vg.ttf\";s:6:\"italic\";s:90:\"http://fonts.gstatic.com/s/expletussans/v9/Y-erXmY0b6DU_i2Qu0hTJj4G9C9ttb0Oz5Cvf0qOitE.ttf\";s:3:\"500\";s:90:\"http://fonts.gstatic.com/s/expletussans/v9/cl6rhMY77Ilk8lB_uYRRwAqQmZ7VjhwksfpNVG0pqGc.ttf\";s:9:\"500italic\";s:90:\"http://fonts.gstatic.com/s/expletussans/v9/sRBNtc46w65uJE451UYmW87DCVO6wo6i5LKIyZDzK40.ttf\";s:3:\"600\";s:90:\"http://fonts.gstatic.com/s/expletussans/v9/cl6rhMY77Ilk8lB_uYRRwCvj1tU7IJMS3CS9kCx2B3U.ttf\";s:9:\"600italic\";s:90:\"http://fonts.gstatic.com/s/expletussans/v9/sRBNtc46w65uJE451UYmW8yKH23ZS6zCKOFHG0e_4JE.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/expletussans/v9/cl6rhMY77Ilk8lB_uYRRwFCbmAUID8LN-q3pJpOk3Ys.ttf\";s:9:\"700italic\";s:90:\"http://fonts.gstatic.com/s/expletussans/v9/sRBNtc46w65uJE451UYmW5F66r9C4AnxxlBlGd7xY4g.ttf\";}}i:257;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Fanwood Text\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2017-02-09\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/fanwoodtext/v6/hDNDHUlsSb8bgnEmDp4T_i3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:89:\"http://fonts.gstatic.com/s/fanwoodtext/v6/0J3SBbkMZqBV-3iGxs5E9_MZXuCXbOrAvx5R0IT5Oyo.ttf\";}}i:258;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Farsan\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/farsan/v1/Hdf9Y76SQ6e1X0Nqk3rHtw.ttf\";}}i:259;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Fascinate\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/fascinate/v5/ZE0637WWkBPKt1AmFaqD3Q.ttf\";}}i:260;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Fascinate Inline\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/fascinateinline/v6/lRguYfMfWArflkm5aOQ5QJmp8DTZ6iHear7UV05iykg.ttf\";}}i:261;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Faster One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/fasterone/v6/YxTOW2sf56uxD1T7byP5K_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:262;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Fasthand\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/fasthand/v7/6XAagHH_KmpZL67wTvsETQ.ttf\";}}i:263;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Fauna One\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/faunaone/v4/8kL-wpAPofcAMELI_5NRnQ.ttf\";}}i:264;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Federant\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/federant/v8/tddZFSiGvxICNOGra0i5aA.ttf\";}}i:265;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Federo\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/federo/v8/JPhe1S2tujeyaR79gXBLeQ.ttf\";}}i:266;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Felipa\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/felipa/v4/SeyfyFZY7abAQXGrOIYnYg.ttf\";}}i:267;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Fenix\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/fenix/v4/Ak8wR3VSlAN7VN_eMeJj7Q.ttf\";}}i:268;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Finger Paint\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/fingerpaint/v5/m_ZRbiY-aPb13R3DWPBGXy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:269;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Fira Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"700\";}s:7:\"subsets\";a:6:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2017-01-10\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/firamono/v5/WQOm1D4RO-yvA9q9trJc8g.ttf\";s:3:\"500\";s:86:\"http://fonts.gstatic.com/s/firamono/v5/PJ4zAY1ucu5ib6LzyvHMkS3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/firamono/v5/l24Wph3FsyKAbJ8dfExTZy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:270;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Fira Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2017-01-10\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/8lKWk2lAb6-y9gc_GLDdPKCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"100italic\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/fmobwZujc_UI4huzQvESm4AWxXGWZ3yJw6KhWS7MxOk.ttf\";s:3:\"200\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/H2QtVYRshA1CFy63P7ykZy3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"200italic\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/6s0YCA9oCTF6hM60YM-qTUnzyIngrzGjGh22wPb6cGM.ttf\";s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/VTBnrK42EiOBncVyQXZ7jy3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"300italic\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/6s0YCA9oCTF6hM60YM-qTS9-WlPSxbfiI49GsXo3q0g.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/firasans/v7/nsT0isDy56OkSX99sFQbXw.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/cPT_2ddmoxsUuMtQqa8zGqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"500\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/zM2u8V3CuPVwAAXFQcDi4C3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"500italic\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/6s0YCA9oCTF6hM60YM-qTcCNfqCYlB_eIx7H1TVXe60.ttf\";s:3:\"600\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/TPhEsJuyxIEzWtby22btfi3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"600italic\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/6s0YCA9oCTF6hM60YM-qTZZ7xm-Bj30Bj2KNdXDzSZg.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/DugPdSljmOTocZOR2CItOi3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/6s0YCA9oCTF6hM60YM-qTXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:3:\"800\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/htOw9f-chtELyJuFCkCrFi3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"800italic\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/6s0YCA9oCTF6hM60YM-qTQ89PwPrYLaRFJ-HNCU9NbA.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/rowJfijyp23uW9P2J-sluC3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"900italic\";s:86:\"http://fonts.gstatic.com/s/firasans/v7/6s0YCA9oCTF6hM60YM-qTSenaqEuufTBk9XMKnKmgDA.ttf\";}}i:271;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Fira Sans Condensed\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2017-01-10\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/-hkH0zXsjNm-yd0g99LvtmzsEJYDLiwza6ZHrdqhthQ.ttf\";s:9:\"100italic\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/Nqqv1KfmeTlTML-ky7aaRPKr3wa5Ugsm4QGD8HSjBf8.ttf\";s:3:\"200\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/k1srRZ14gKpu4XGd0R993IBfX0yoOQz7y6Fa57EWAgY.ttf\";s:9:\"200italic\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/Z87ZCYzj43dcQd7C-kCjDzTCSvnRzshTGhbaUNxVLsY.ttf\";s:3:\"300\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/k1srRZ14gKpu4XGd0R993EMwSSh38KQVJx4ABtsZTnA.ttf\";s:9:\"300italic\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/Z87ZCYzj43dcQd7C-kCjD4_LkTZ_uhAwfmGJ084hlvM.ttf\";s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/HQGj1o4-qj8agzakWWMQw0b2huS6PSilRpwXI3qYZmg.ttf\";s:6:\"italic\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/-hkH0zXsjNm-yd0g99Lvtv745YdnE8ZqDtluSBzScUA.ttf\";s:3:\"500\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/k1srRZ14gKpu4XGd0R993OsjvTPWUq6WFqixIyn02S8.ttf\";s:9:\"500italic\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/Z87ZCYzj43dcQd7C-kCjD4BZvKPjZWiSZqpadd3c-cI.ttf\";s:3:\"600\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/k1srRZ14gKpu4XGd0R993HI2_Em5SxSZLj3SINQVfR0.ttf\";s:9:\"600italic\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/Z87ZCYzj43dcQd7C-kCjD5AgRolq0CFuJyGMzcpUuqI.ttf\";s:3:\"700\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/k1srRZ14gKpu4XGd0R993BEM87DM3yorPOrvA-vB930.ttf\";s:9:\"700italic\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/Z87ZCYzj43dcQd7C-kCjDzkJmEiMQ4xM-o8FMi_9og4.ttf\";s:3:\"800\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/k1srRZ14gKpu4XGd0R993IakE3OFfI2LZ4c6GPO8Mzs.ttf\";s:9:\"800italic\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/Z87ZCYzj43dcQd7C-kCjD07QUKmu2W_Ow4yNN8hZ1i8.ttf\";s:3:\"900\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/k1srRZ14gKpu4XGd0R993BL2AAruu1GYH8xAyPJJAg8.ttf\";s:9:\"900italic\";s:95:\"http://fonts.gstatic.com/s/firasanscondensed/v1/Z87ZCYzj43dcQd7C-kCjD8mJu-lqHNyZBDoYLJNH3Ks.ttf\";}}i:272;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:25:\"Fira Sans Extra Condensed\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2017-01-10\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/_dPmaUiuUAWmL0ibePdArgFORyOzJNaQMfz6m4ejZbGglnMp3_3A8V8Ai8YosRtX.ttf\";s:9:\"100italic\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/G8VKhLxlTd0YOlG3i1R8CfHXjqTqiXVW6z8kDssMYPCAFsVxlmd8icOioVkuzMTp.ttf\";s:3:\"200\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/34whiWDL4CxC1laOcj7OwW_7IC3ILXfeIVwvfWGu4Sgt1EgZ0r6ZKKUGlEftq-4l.ttf\";s:9:\"200italic\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPBJ88iJ4K8xoxodtsD2-nBj.ttf\";s:3:\"300\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/34whiWDL4CxC1laOcj7OwW7O05EUNkkL_mPtCuekiV0t1EgZ0r6ZKKUGlEftq-4l.ttf\";s:9:\"300italic\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPAvflpT0sW34iOPRrF6N6tI.ttf\";s:7:\"regular\";s:100:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/wg_5XrW_o1_ZfuCbAkBfGRreEc6WSk_gssVJg3w2ARQ.ttf\";s:6:\"italic\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/_dPmaUiuUAWmL0ibePdArnKUexidEaHsf8DLYXbriUSglnMp3_3A8V8Ai8YosRtX.ttf\";s:3:\"500\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/34whiWDL4CxC1laOcj7Owdd0GPYAHEVh0EvoffkRAuMt1EgZ0r6ZKKUGlEftq-4l.ttf\";s:9:\"500italic\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPDAjX6gmJQf3iMex9U1V3ut.ttf\";s:3:\"600\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/34whiWDL4CxC1laOcj7OwW8v1dGG_WArVpDmblm5TDot1EgZ0r6ZKKUGlEftq-4l.ttf\";s:9:\"600italic\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPCWe8ZvgY99AY9ijXVw80mY.ttf\";s:3:\"700\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/34whiWDL4CxC1laOcj7OwdEjTMY3GGLBv_AxlS3Ww6ct1EgZ0r6ZKKUGlEftq-4l.ttf\";s:9:\"700italic\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPB3tT3e-lZe80aROzSyUO11.ttf\";s:3:\"800\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/34whiWDL4CxC1laOcj7OwZZWqFq9WyGGQ2ef9bXDKiQt1EgZ0r6ZKKUGlEftq-4l.ttf\";s:9:\"800italic\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPAPPT8D62C2kRSfhzQlPTWw.ttf\";s:3:\"900\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/34whiWDL4CxC1laOcj7OwRPaRBEe7-4iQsBL_zD1FQ8t1EgZ0r6ZKKUGlEftq-4l.ttf\";s:9:\"900italic\";s:121:\"http://fonts.gstatic.com/s/firasansextracondensed/v1/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPAnp2qhLrn0wZPVzCpypoAw.ttf\";}}i:273;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Fjalla One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/fjallaone/v4/3b7vWCfOZsU53vMa8LWsf_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:274;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Fjord One\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/fjordone/v5/R_YHK8au2uFPw5tNu5N7zw.ttf\";}}i:275;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Flamenco\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/flamenco/v6/x9iI5CogvuZVCGoRHwXuo6CWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/flamenco/v6/HC0ugfLLgt26I5_BWD1PZA.ttf\";}}i:276;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Flavors\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/flavors/v5/SPJi5QclATvon8ExcKGRvQ.ttf\";}}i:277;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Fondamento\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-27\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/fondamento/v6/6LWXcjT1B7bnWluAOSNfMPesZW2xOQ-xsNqO47m55DA.ttf\";s:6:\"italic\";s:88:\"http://fonts.gstatic.com/s/fondamento/v6/y6TmwhSbZ8rYq7OTFyo7OS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:278;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Fontdiner Swanky\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/fontdinerswanky/v6/8_GxIO5ixMtn5P6COsF3TlBjMPLzPAFJwRBn-s1U7kA.ttf\";}}i:279;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Forum\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/forum/v7/MZUpsq1VfLrqv8eSDcbrrQ.ttf\";}}i:280;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Francois One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/francoisone/v10/bYbkq2nU2TSx4SwFbz5sCC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:281;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Frank Ruhl Libre\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:6:\"hebrew\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:92:\"http://fonts.gstatic.com/s/frankruhllibre/v1/y8NWif61iD8Hg8bGAmxFPOo9jvbqtCEVUIntIHarXsc.ttf\";s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/frankruhllibre/v1/yDLloNqBpFmakCImLv4OJkfFI6QBbouvcOFcz81E3Ek.ttf\";s:3:\"500\";s:92:\"http://fonts.gstatic.com/s/frankruhllibre/v1/y8NWif61iD8Hg8bGAmxFPC-WNtISbX_UO2d0wZPgXtk.ttf\";s:3:\"700\";s:92:\"http://fonts.gstatic.com/s/frankruhllibre/v1/y8NWif61iD8Hg8bGAmxFPDPYiZEMiRRbPdIFMoTwDbo.ttf\";s:3:\"900\";s:92:\"http://fonts.gstatic.com/s/frankruhllibre/v1/y8NWif61iD8Hg8bGAmxFPNRZIVFRjDx-6MOpcoWbVhA.ttf\";}}i:282;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Freckle Face\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/freckleface/v4/7-B8j9BPJgazdHIGqPNv8y3USBnSvpkopQaUR-2r7iU.ttf\";}}i:283;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Fredericka the Great\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:96:\"http://fonts.gstatic.com/s/frederickathegreat/v5/7Es8Lxoku-e5eOZWpxw18nrnet6gXN1McwdQxS1dVrI.ttf\";}}i:284;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Fredoka One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/fredokaone/v4/QKfwXi-z-KtJAlnO2ethYqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:285;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Freehand\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/freehand/v8/uEBQxvA0lnn_BrD6krlxMw.ttf\";}}i:286;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Fresca\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/fresca/v5/2q7Qm9sCo1tWvVgSDVWNIw.ttf\";}}i:287;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Frijole\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/frijole/v5/L2MfZse-2gCascuD-nLhWg.ttf\";}}i:288;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Fruktur\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2017-03-15\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/fruktur/v9/PnQvfEi1LssAvhJsCwH__w.ttf\";}}i:289;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Fugaz One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/fugazone/v6/5tteVDCwxsr8-5RuSiRWOw.ttf\";}}i:290;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"GFS Didot\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"greek\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/gfsdidot/v6/jQKxZy2RU-h9tkPZcRVluA.ttf\";}}i:291;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"GFS Neohellenic\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"greek\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/gfsneohellenic/v7/B4xRqbn-tANVqVgamMsSDiayCZa0z7CpFzlkqoCHztc.ttf\";s:6:\"italic\";s:92:\"http://fonts.gstatic.com/s/gfsneohellenic/v7/KnaWrO4awITAqigQIIYXKkCTdomiyJpIzPbEbIES3rU.ttf\";s:3:\"700\";s:92:\"http://fonts.gstatic.com/s/gfsneohellenic/v7/7HwjPQa7qNiOsnUce2h4448_BwCLZY3eDSV6kppAwI8.ttf\";s:9:\"700italic\";s:92:\"http://fonts.gstatic.com/s/gfsneohellenic/v7/FwWjoX6XqT-szJFyqsu_GYFF0fM4h-krcpQk7emtCpE.ttf\";}}i:292;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Gabriela\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2017-01-19\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/gabriela/v5/B-2ZfbAO3HDrxqV6lR5tdA.ttf\";}}i:293;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Gafata\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/gafata/v5/aTFqlki_3Dc3geo-FxHTvQ.ttf\";}}i:294;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Galada\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:7:\"bengali\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/galada/v1/xGkllHQb8OOCv9VJ6IObSA.ttf\";}}i:295;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Galdeano\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/galdeano/v6/ZKFMQI6HxEG1jOT0UGSZUg.ttf\";}}i:296;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Galindo\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/galindo/v4/2lafAS_ZEfB33OJryhXDUg.ttf\";}}i:297;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Gentium Basic\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/gentiumbasic/v8/KCktj43blvLkhOTolFn-MYtBLojGU5Qdl8-5NL4v70w.ttf\";s:6:\"italic\";s:90:\"http://fonts.gstatic.com/s/gentiumbasic/v8/qoFz4NSMaYC2UmsMAG3lyTj3mvXnCeAk09uTtmkJGRc.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/gentiumbasic/v8/2qL6yulgGf0wwgOp-UqGyLNuTeOOLg3nUymsEEGmdO0.ttf\";s:9:\"700italic\";s:90:\"http://fonts.gstatic.com/s/gentiumbasic/v8/8N9-c_aQDJ8LbI1NGVMrwtswO1vWwP9exiF8s0wqW10.ttf\";}}i:298;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Gentium Book Basic\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/gentiumbookbasic/v7/IRFxB2matTxrjZt6a3FUnrWDjKAyldGEr6eEi2MBNeY.ttf\";s:6:\"italic\";s:94:\"http://fonts.gstatic.com/s/gentiumbookbasic/v7/qHqW2lwKO8-uTfIkh8FsUfXfjMwrYnmPVsQth2IcAPY.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/gentiumbookbasic/v7/T2vUYmWzlqUtgLYdlemGnaWESMHIjnSjm9UUxYtEOko.ttf\";s:9:\"700italic\";s:94:\"http://fonts.gstatic.com/s/gentiumbookbasic/v7/632u7TMIoFDWQYUaHFUp5PA2A9KyRZEkn4TZVuhsWRM.ttf\";}}i:299;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:3:\"Geo\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:60:\"http://fonts.gstatic.com/s/geo/v8/mJuJYk5Pww84B4uHAQ1XaA.ttf\";s:6:\"italic\";s:60:\"http://fonts.gstatic.com/s/geo/v8/8_r1wToF7nPdDuX1qxel6Q.ttf\";}}i:300;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Geostar\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/geostar/v6/A8WQbhQbpYx3GWWaShJ9GA.ttf\";}}i:301;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Geostar Fill\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/geostarfill/v6/Y5ovXPPOHYTfQzK2aM-hui3USBnSvpkopQaUR-2r7iU.ttf\";}}i:302;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Germania One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/germaniaone/v4/3_6AyUql_-FbDi1e68jHdC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:303;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Gidugu\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/gidugu/v3/Ey6Eq3hrT6MM58iFItFcgw.ttf\";}}i:304;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Gilda Display\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/gildadisplay/v4/8yAVUZLLZ3wb7dSsjix0CADHmap7fRWINAsw8-RaxNg.ttf\";}}i:305;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Give You Glory\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/giveyouglory/v6/DFEWZFgGmfseyIdGRJAxuBwwkpSPZdvjnMtysdqprfI.ttf\";}}i:306;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Glass Antiqua\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/glassantiqua/v4/0yLrXKplgdUDIMz5TnCHNODcg5akpSnIcsPhLOFv7l8.ttf\";}}i:307;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Glegoo\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/glegoo/v5/2tf-h3n2A_SNYXEO0C8bKw.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/glegoo/v5/TlLolbauH0-0Aiz1LUH5og.ttf\";}}i:308;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Gloria Hallelujah\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/gloriahallelujah/v8/CA1k7SlXcY5kvI81M_R28Q3RdPdyebSUyJECJouPsvA.ttf\";}}i:309;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Goblin One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/goblinone/v6/331XtzoXgpVEvNTVcBJ_C_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:310;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Gochi Hand\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/gochihand/v7/KT1-WxgHsittJ34_20IfAPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:311;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Gorditas\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/gorditas/v4/uMgZhXUyH6qNGF3QsjQT5Q.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/gorditas/v4/6-XCeknmxaon8AUqVkMnHaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:312;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:21:\"Goudy Bookletter 1911\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:97:\"http://fonts.gstatic.com/s/goudybookletter1911/v6/l5lwlGTN3pEY5Bf-rQEuIIjNDsyURsIKu4GSfvSE4mA.ttf\";}}i:313;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Graduate\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/graduate/v4/JpAmYLHqcIh9_Ff35HHwiA.ttf\";}}i:314;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Grand Hotel\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/grandhotel/v4/C_A8HiFZjXPpnMt38XnK7qCWcynf_cDxXwCLxiixG1c.ttf\";}}i:315;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Gravitas One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/gravitasone/v6/nBHdBv6zVNU8MtP6w9FwTS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:316;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Great Vibes\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/greatvibes/v4/4Mi5RG_9LjQYrTU55GN_L6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:317;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Griffy\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/griffy/v4/vWkyYGBSyE5xjnShNtJtzw.ttf\";}}i:318;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Gruppo\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/gruppo/v7/pS_JM0cK_piBZve-lfUq9w.ttf\";}}i:319;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Gudea\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/gudea/v4/S-4QqBlkMPiiA3jNeCR5yw.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/gudea/v4/7mNgsGw_vfS-uUgRVXNDSw.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/gudea/v4/lsip4aiWhJ9bx172Y9FN_w.ttf\";}}i:320;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Gurajada\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/gurajada/v4/6Adfkl4PCRyq6XTENACEyA.ttf\";}}i:321;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Habibi\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/habibi/v5/YYyqXF6pWpL7kmKgS_2iUA.ttf\";}}i:322;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Halant\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:63:\"http://fonts.gstatic.com/s/halant/v2/dM3ItAOWNNod_Cf3MnLlEg.ttf\";s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/halant/v2/rEs7Jk3SVyt3cTx6DoTu1w.ttf\";s:3:\"500\";s:63:\"http://fonts.gstatic.com/s/halant/v2/tlsNj3K-hJKtiirTDtUbkQ.ttf\";s:3:\"600\";s:63:\"http://fonts.gstatic.com/s/halant/v2/zNR2WvI_V8o652vIZp3X4Q.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/halant/v2/D9FN7OH89AuCmZDLHbPQfA.ttf\";}}i:323;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Hammersmith One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/hammersmithone/v7/FWNn6ITYqL6or7ZTmBxRhjjVlsJB_M_Q_LtZxsoxvlw.ttf\";}}i:324;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Hanalei\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/hanalei/v6/Sx8vVMBnXSQyK6Cn0CBJ3A.ttf\";}}i:325;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Hanalei Fill\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/hanaleifill/v5/5uPeWLnaDdtm4UBG26Ds6C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:326;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Handlee\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/handlee/v5/6OfkXkyC0E5NZN80ED8u3A.ttf\";}}i:327;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Hanuman\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/hanuman/v9/hRhwOGGmElJSl6KSPvEnOQ.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/hanuman/v9/lzzXZ2l84x88giDrbfq76vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:328;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Happy Monkey\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/happymonkey/v5/c2o0ps8nkBmaOYctqBq1rS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:329;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Harmattan\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/harmattan/v1/xNM1nDKzsLfoCLQtMRztGA.ttf\";}}i:330;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Headland One\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/headlandone/v4/iGmBeOvQGfq9DSbjJ8jDVy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:331;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Heebo\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"hebrew\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"100\";s:62:\"http://fonts.gstatic.com/s/heebo/v2/SoQODIucfpkiveZloUR6ag.ttf\";s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/heebo/v2/dg5T18yyjkKiU_9mmcbDSQ.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/heebo/v2/nyHCGMPliplPNqpssbDSIA.ttf\";s:3:\"500\";s:62:\"http://fonts.gstatic.com/s/heebo/v2/jDb70ZCwdD6JnmQU62ZQZA.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/heebo/v2/NsBYEn6oWei8pPqytA07yA.ttf\";s:3:\"800\";s:62:\"http://fonts.gstatic.com/s/heebo/v2/h4CV2Qq56LKIinGGOStvsw.ttf\";s:3:\"900\";s:62:\"http://fonts.gstatic.com/s/heebo/v2/uDfzHw3R0Bfa6HyIIcj-ow.ttf\";}}i:332;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Henny Penny\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/hennypenny/v4/XRgo3ogXyi3tpsFfjImRF6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:333;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Herr Von Muellerhoff\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:96:\"http://fonts.gstatic.com/s/herrvonmuellerhoff/v6/mmy24EUmk4tjm4gAEjUd7NLGIYrUsBdh-JWHYgiDiMU.ttf\";}}i:334;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Hind\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-02\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:61:\"http://fonts.gstatic.com/s/hind/v6/qa346Adgv9kPDXoD1my4kA.ttf\";s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/hind/v6/mktFHh5Z5P9YjGKSslSUtA.ttf\";s:3:\"500\";s:61:\"http://fonts.gstatic.com/s/hind/v6/2cs8RCVcYtiv4iNDH1UsQQ.ttf\";s:3:\"600\";s:61:\"http://fonts.gstatic.com/s/hind/v6/TUKUmFMXSoxloBP1ni08oA.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/hind/v6/cXJJavLdUbCfjxlsA6DqTw.ttf\";}}i:335;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Hind Guntur\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:88:\"http://fonts.gstatic.com/s/hindguntur/v1/Szg33M7ab5MTWe-PWAcNAi9-WlPSxbfiI49GsXo3q0g.ttf\";s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/hindguntur/v1/MXz-KyAeVZstlFz6v-5SC6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"500\";s:88:\"http://fonts.gstatic.com/s/hindguntur/v1/Szg33M7ab5MTWe-PWAcNAsCNfqCYlB_eIx7H1TVXe60.ttf\";s:3:\"600\";s:88:\"http://fonts.gstatic.com/s/hindguntur/v1/Szg33M7ab5MTWe-PWAcNApZ7xm-Bj30Bj2KNdXDzSZg.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/hindguntur/v1/Szg33M7ab5MTWe-PWAcNAne1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:336;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Hind Madurai\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"tamil\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:89:\"http://fonts.gstatic.com/s/hindmadurai/v1/sdSJTZLdRXJhVTP92m2S66cQoVhARpoaILP7amxE_8g.ttf\";s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/hindmadurai/v1/pJpl47LatORZNWf8rgdiyS3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"500\";s:89:\"http://fonts.gstatic.com/s/hindmadurai/v1/sdSJTZLdRXJhVTP92m2S65MQuUSAwdHsY8ov_6tk1oA.ttf\";s:3:\"600\";s:89:\"http://fonts.gstatic.com/s/hindmadurai/v1/sdSJTZLdRXJhVTP92m2S62v8CylhIUtwUiYO7Z2wXbE.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/hindmadurai/v1/sdSJTZLdRXJhVTP92m2S60D2ttfZwueP-QU272T9-k4.ttf\";}}i:337;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Hind Siliguri\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:7:\"bengali\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-02\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:90:\"http://fonts.gstatic.com/s/hindsiliguri/v2/fBpmjMpv5Rh6S25yVfWJnzoJ52uD-1fmXmi8u0n_zsc.ttf\";s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/hindsiliguri/v2/f2eEi2pbIa8eBfNwpUl0Am_MnNA9OgK8I1F23mNWOpE.ttf\";s:3:\"500\";s:90:\"http://fonts.gstatic.com/s/hindsiliguri/v2/fBpmjMpv5Rh6S25yVfWJn__2zpxNHQ3utWt_82o9dAo.ttf\";s:3:\"600\";s:90:\"http://fonts.gstatic.com/s/hindsiliguri/v2/fBpmjMpv5Rh6S25yVfWJn-x91FDzFvnud68bXrNkpDA.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/hindsiliguri/v2/fBpmjMpv5Rh6S25yVfWJn6iiXuG_rGcOxkuidirlnJE.ttf\";}}i:338;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Hind Vadodara\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-02\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:90:\"http://fonts.gstatic.com/s/hindvadodara/v2/KrZ6f_YevRawHvh0qDBkTbDwfZ__Dotj_J8NiWv76DQ.ttf\";s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/hindvadodara/v2/9c6KKeibr6NtFqknnNxZB-Dcg5akpSnIcsPhLOFv7l8.ttf\";s:3:\"500\";s:90:\"http://fonts.gstatic.com/s/hindvadodara/v2/KrZ6f_YevRawHvh0qDBkTZzEKvFIU9WyojfbAkhDb6c.ttf\";s:3:\"600\";s:90:\"http://fonts.gstatic.com/s/hindvadodara/v2/KrZ6f_YevRawHvh0qDBkTfgXs2VXrZsRiQ1c96pXZKI.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/hindvadodara/v2/KrZ6f_YevRawHvh0qDBkTYGjoH95IEFGA7BjhXnx_eg.ttf\";}}i:339;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Holtwood One SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/holtwoodonesc/v7/sToOq3cIxbfnhbEkgYNuBbAgSRh1LpJXlLfl8IbsmHg.ttf\";}}i:340;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Homemade Apple\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/homemadeapple/v6/yg3UMEsefgZ8IHz_ryz86BiPOmFWYV1WlrJkRafc4c0.ttf\";}}i:341;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Homenaje\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/homenaje/v6/v0YBU0iBRrGdVjDNQILxtA.ttf\";}}i:342;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"IM Fell DW Pica\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/imfelldwpica/v6/W81bfaWiUicLSPbJhW-ATsA5qm663gJGVdtpamafG5A.ttf\";s:6:\"italic\";s:90:\"http://fonts.gstatic.com/s/imfelldwpica/v6/alQJ8SK5aSOZVaelYoyT4PL2asmh5DlYQYCosKo6yQs.ttf\";}}i:343;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"IM Fell DW Pica SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/imfelldwpicasc/v6/xBKKJV4z2KsrtQnmjGO17JZ9RBdEL0H9o5qzT1Rtof4.ttf\";}}i:344;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"IM Fell Double Pica\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/imfelldoublepica/v6/yN1wY_01BkQnO0LYAhXdUol14jEdVOhEmvtCMCVwYak.ttf\";s:6:\"italic\";s:94:\"http://fonts.gstatic.com/s/imfelldoublepica/v6/64odUh2hAw8D9dkFKTlWYq0AWwkgdQfsRHec8TYi4mI.ttf\";}}i:345;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:22:\"IM Fell Double Pica SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:96:\"http://fonts.gstatic.com/s/imfelldoublepicasc/v6/jkrUtrLFpMw4ZazhfkKsGwc4LoC4OJUqLw9omnT3VOU.ttf\";}}i:346;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"IM Fell English\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/imfellenglish/v6/xwIisCqGFi8pff-oa9uSVHGNmx1fDm-u2eBJHQkdrmk.ttf\";s:6:\"italic\";s:91:\"http://fonts.gstatic.com/s/imfellenglish/v6/Z3cnIAI_L3XTRfz4JuZKbuewladMPCWTthtMv9cPS-c.ttf\";}}i:347;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"IM Fell English SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/imfellenglishsc/v6/h3Tn6yWfw4b5qaLD1RWvz5ATixNthKRRR1XVH3rJNiw.ttf\";}}i:348;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"IM Fell French Canon\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/imfellfrenchcanon/v6/iKB0WL1BagSpNPz3NLMdsJ3V2FNpBrlLSvqUnERhBP8.ttf\";s:6:\"italic\";s:95:\"http://fonts.gstatic.com/s/imfellfrenchcanon/v6/owCuNQkLLFW7TBBPJbMnhRa-QL94KdW80H29tcyld2A.ttf\";}}i:349;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:23:\"IM Fell French Canon SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:97:\"http://fonts.gstatic.com/s/imfellfrenchcanonsc/v6/kA3bS19-tQbeT_iG32EZmaiyyzHwYrAbmNulTz423iM.ttf\";}}i:350;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"IM Fell Great Primer\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/imfellgreatprimer/v6/AL8ALGNthei20f9Cu3e93rgeX3ROgtTz44CitKAxzKI.ttf\";s:6:\"italic\";s:95:\"http://fonts.gstatic.com/s/imfellgreatprimer/v6/1a-artkXMVg682r7TTxVY1_YG2SFv8Ma7CxRl1S3o7g.ttf\";}}i:351;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:23:\"IM Fell Great Primer SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:97:\"http://fonts.gstatic.com/s/imfellgreatprimersc/v6/A313vRj97hMMGFjt6rgSJtRg-ciw1Y27JeXb2Zv4lZQ.ttf\";}}i:352;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Iceberg\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/iceberg/v4/p2XVm4M-N0AOEEOymFKC5w.ttf\";}}i:353;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Iceland\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/iceland/v5/kq3uTMGgvzWGNi39B_WxGA.ttf\";}}i:354;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Imprima\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/imprima/v4/eRjquWLjwLGnTEhLH7u3kA.ttf\";}}i:355;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Inconsolata\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/inconsolata/v15/7bMKuoy6Nh0ft0SHnIGMuaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/inconsolata/v15/AIed271kqQlcIRSOnQH0yXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:356;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Inder\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/inder/v5/C38TwecLTfKxIHDc_Adcrw.ttf\";}}i:357;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Indie Flower\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/indieflower/v8/10JVD_humAd5zP2yrFqw6i3USBnSvpkopQaUR-2r7iU.ttf\";}}i:358;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Inika\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/inika/v4/eZCrULQGaIxkrRoGz_DjhQ.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/inika/v4/bl3ZoTyrWsFun2zYbsgJrA.ttf\";}}i:359;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Inknut Antiqua\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"300\";s:91:\"http://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVIg6hmPNSXwHGnJQCeQHKUMo.ttf\";s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/inknutantiqua/v1/VlmmTfOrxr3HfcnhMueX9arFJ4O13IHVxZbM6yoslpo.ttf\";s:3:\"500\";s:91:\"http://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVIiYCDvi1XFzRnTV7qUFsNgk.ttf\";s:3:\"600\";s:91:\"http://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVIjLEgY6PI0GrY6L00mykcEQ.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVIlRhfXn9P4_QueZ7VkUHUNc.ttf\";s:3:\"800\";s:91:\"http://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVInARjXVu2t2krcNTHiCb1qY.ttf\";s:3:\"900\";s:91:\"http://fonts.gstatic.com/s/inknutantiqua/v1/CagoW52rBcslcXzHh6tVIrTsNy1JrFNT1qKy8j7W3CU.ttf\";}}i:360;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Irish Grover\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/irishgrover/v6/kUp7uUPooL-KsLGzeVJbBC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:361;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Istok Web\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/istokweb/v10/RYLSjEXQ0nNtLLc4n7--dQ.ttf\";s:6:\"italic\";s:87:\"http://fonts.gstatic.com/s/istokweb/v10/kvcT2SlTjmGbC3YlZxmrl6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/istokweb/v10/2koEo4AKFSvK4B52O_Mwai3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:87:\"http://fonts.gstatic.com/s/istokweb/v10/ycQ3g52ELrh3o_HYCNNUw3e1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:362;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Italiana\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-10-27\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/italiana/v5/dt95fkCSTOF-c6QNjwSycA.ttf\";}}i:363;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Italianno\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/italianno/v6/HsyHnLpKf8uP7aMpDQHZmg.ttf\";}}i:364;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Itim\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/itim/v1/HHV9WK2x5lUkc5bxMXG8Tw.ttf\";}}i:365;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Jacques Francois\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/jacquesfrancois/v4/_-0XWPQIW6tOzTHg4KaJ_M13D_4KM32Q4UmTSjpuNGQ.ttf\";}}i:366;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:23:\"Jacques Francois Shadow\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:99:\"http://fonts.gstatic.com/s/jacquesfrancoisshadow/v4/V14y0H3vq56fY9SV4OL_FASt0D_oLVawA8L8b9iKjbs.ttf\";}}i:367;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Jaldi\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/jaldi/v2/x1vR-bPW9a1EB-BUVqttCw.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/jaldi/v2/OIbtgjjEp3aVWtjF6WY8mA.ttf\";}}i:368;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Jim Nightshade\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/jimnightshade/v4/_n43lYHXVWNgXegdYRIK9CF1W_bo0EdycfH0kHciIic.ttf\";}}i:369;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Jockey One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/jockeyone/v6/cAucnOZLvFo07w2AbufBCfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:370;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Jolly Lodger\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/jollylodger/v4/RX8HnkBgaEKQSHQyP9itiS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:371;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Jomhuria\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/jomhuria/v2/hrvsccQpBliIgor15WxE6g.ttf\";}}i:372;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Josefin Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"100\";s:89:\"http://fonts.gstatic.com/s/josefinsans/v9/q9w3H4aeBxj0hZ8Osfi3d8SVQ0giZ-l_NELu3lgGyYw.ttf\";s:9:\"100italic\";s:89:\"http://fonts.gstatic.com/s/josefinsans/v9/s7-P1gqRNRNn-YWdOYnAOXXcj1rQwlNLIS625o-SrL0.ttf\";s:3:\"300\";s:89:\"http://fonts.gstatic.com/s/josefinsans/v9/C6HYlRF50SGJq1XyXj04z6cQoVhARpoaILP7amxE_8g.ttf\";s:9:\"300italic\";s:89:\"http://fonts.gstatic.com/s/josefinsans/v9/ppse0J9fKSaoxCIIJb33Gyna0FLWfcB-J_SAYmcAXaI.ttf\";s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/josefinsans/v9/xgzbb53t8j-Mo-vYa23n5i3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:89:\"http://fonts.gstatic.com/s/josefinsans/v9/q9w3H4aeBxj0hZ8Osfi3d_MZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"600\";s:89:\"http://fonts.gstatic.com/s/josefinsans/v9/C6HYlRF50SGJq1XyXj04z2v8CylhIUtwUiYO7Z2wXbE.ttf\";s:9:\"600italic\";s:89:\"http://fonts.gstatic.com/s/josefinsans/v9/ppse0J9fKSaoxCIIJb33G4R-5-urNOGAobhAyctHvW8.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/josefinsans/v9/C6HYlRF50SGJq1XyXj04z0D2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:89:\"http://fonts.gstatic.com/s/josefinsans/v9/ppse0J9fKSaoxCIIJb33G_As9-1nE9qOqhChW0m4nDE.ttf\";}}i:373;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Josefin Slab\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"100\";s:89:\"http://fonts.gstatic.com/s/josefinslab/v6/etsUjZYO8lTLU85lDhZwUsSVQ0giZ-l_NELu3lgGyYw.ttf\";s:9:\"100italic\";s:89:\"http://fonts.gstatic.com/s/josefinslab/v6/8BjDChqLgBF3RJKfwHIYh3Xcj1rQwlNLIS625o-SrL0.ttf\";s:3:\"300\";s:89:\"http://fonts.gstatic.com/s/josefinslab/v6/NbE6ykYuM2IyEwxQxOIi2KcQoVhARpoaILP7amxE_8g.ttf\";s:9:\"300italic\";s:89:\"http://fonts.gstatic.com/s/josefinslab/v6/af9sBoKGPbGO0r21xJulyyna0FLWfcB-J_SAYmcAXaI.ttf\";s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/josefinslab/v6/46aYWdgz-1oFX11flmyEfS3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:89:\"http://fonts.gstatic.com/s/josefinslab/v6/etsUjZYO8lTLU85lDhZwUvMZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"600\";s:89:\"http://fonts.gstatic.com/s/josefinslab/v6/NbE6ykYuM2IyEwxQxOIi2Gv8CylhIUtwUiYO7Z2wXbE.ttf\";s:9:\"600italic\";s:89:\"http://fonts.gstatic.com/s/josefinslab/v6/af9sBoKGPbGO0r21xJuly4R-5-urNOGAobhAyctHvW8.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/josefinslab/v6/NbE6ykYuM2IyEwxQxOIi2ED2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:89:\"http://fonts.gstatic.com/s/josefinslab/v6/af9sBoKGPbGO0r21xJuly_As9-1nE9qOqhChW0m4nDE.ttf\";}}i:374;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Joti One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/jotione/v4/P3r_Th0ESHJdzunsvWgUfQ.ttf\";}}i:375;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Judson\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/judson/v9/znM1AAs0eytUaJzf1CrYZQ.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/judson/v9/GVqQW9P52ygW-ySq-CLwAA.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/judson/v9/he4a2LwiPJc7r8x0oKCKiA.ttf\";}}i:376;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Julee\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/julee/v6/CAib-jsUsSO8SvVRnE9fHA.ttf\";}}i:377;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Julius Sans One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/juliussansone/v5/iU65JP9acQHPDLkdalCF7jjVlsJB_M_Q_LtZxsoxvlw.ttf\";}}i:378;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Junge\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/junge/v4/j4IXCXtxrw9qIBheercp3A.ttf\";}}i:379;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Jura\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";}s:7:\"subsets\";a:5:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:61:\"http://fonts.gstatic.com/s/jura/v7/Rqx_xy1UnN0C7wD3FUSyPQ.ttf\";s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/jura/v7/YAWMwF3sN0KCbynMq-Yr_Q.ttf\";s:3:\"500\";s:61:\"http://fonts.gstatic.com/s/jura/v7/16xhfjHCiaLj3tsqqgmtGg.ttf\";s:3:\"600\";s:61:\"http://fonts.gstatic.com/s/jura/v7/iwseduOwJSdY8wQ1Y6CJdA.ttf\";}}i:380;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Just Another Hand\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/justanotherhand/v7/fKV8XYuRNNagXr38eqbRf99BnJIEGrvoojniP57E51c.ttf\";}}i:381;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:23:\"Just Me Again Down Here\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:97:\"http://fonts.gstatic.com/s/justmeagaindownhere/v8/sN06iTc9ITubLTgXoG-kc3M9eVLpVTSK6TqZTIgBrWQ.ttf\";}}i:382;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Kadwa\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/kadwa/v1/VwEN8oKGqaa0ug9kRpvSSg.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/kadwa/v1/NFPZaBfekj_Io-7vUMz4Ww.ttf\";}}i:383;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Kalam\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/kalam/v7/MgQQlk1SgPEHdlkWMNh7Jg.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/kalam/v7/hNEJkp2K-aql7e5WQish4Q.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/kalam/v7/95nLItUGyWtNLZjSckluLQ.ttf\";}}i:384;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Kameron\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/kameron/v7/9r8HYhqDSwcq9WMjupL82A.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/kameron/v7/rabVVbzlflqvmXJUFlKnu_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:385;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Kanit\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/CYl4qOK-NWwZp3iTKW1eIA.ttf\";s:9:\"100italic\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/NLNtc56MpXmHl1yOrop8oQ.ttf\";s:3:\"200\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/wfLWkj1C4tYl7MoiFWS3bA.ttf\";s:9:\"200italic\";s:83:\"http://fonts.gstatic.com/s/kanit/v1/D8gkrAAM2bvNJ-1i4ot-1_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/SM5qHynYGdOmMKEwGUFIPA.ttf\";s:9:\"300italic\";s:83:\"http://fonts.gstatic.com/s/kanit/v1/IePislKOKy3Bqfpb9V5VM_esZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/L6VKvM17ZmevDynOiw7H9w.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/sHLq5U0-T0oSMTnwTKgv-A.ttf\";s:3:\"500\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/GxoU_USIJyIy8WIcYSUO2g.ttf\";s:9:\"500italic\";s:83:\"http://fonts.gstatic.com/s/kanit/v1/hrCiWCaNv9AaF0mDY1F2zPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/n_qoIVxojeQY0D1pvoNDhA.ttf\";s:9:\"600italic\";s:83:\"http://fonts.gstatic.com/s/kanit/v1/9BkP85yRDoVayTWQwdGLqPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/kEGmYvO8My36j5ILmbUPRg.ttf\";s:9:\"700italic\";s:83:\"http://fonts.gstatic.com/s/kanit/v1/WNo3ZZ9xtOZJknNlvHAFWfesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"800\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/YTp-zAuKXxwnA1YnJIF1rg.ttf\";s:9:\"800italic\";s:83:\"http://fonts.gstatic.com/s/kanit/v1/qiTGrW5sCa9UQp841fWjc_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"900\";s:62:\"http://fonts.gstatic.com/s/kanit/v1/1NIEkusi3bG3GgO9Hor3fQ.ttf\";s:9:\"900italic\";s:83:\"http://fonts.gstatic.com/s/kanit/v1/ogN5dFD1r4BfxNV4Nb-TXfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:386;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Kantumruy\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:87:\"http://fonts.gstatic.com/s/kantumruy/v3/ERRwQE0WG5uanaZWmOFXNi3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/kantumruy/v3/kQfXNYElQxr5dS8FyjD39Q.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/kantumruy/v3/gie_zErpGf_rNzs920C2Ji3USBnSvpkopQaUR-2r7iU.ttf\";}}i:387;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Karla\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/karla/v5/78UgGRwJFkhqaoFimqoKpQ.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/karla/v5/51UBKly9RQOnOkj95ZwEFw.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/karla/v5/JS501sZLxZ4zraLQdncOUA.ttf\";s:9:\"700italic\";s:83:\"http://fonts.gstatic.com/s/karla/v5/3YDyi09gQjCRh-5-SVhTTvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:388;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Karma\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/karma/v5/lH6ijJnguWR2Sz7tEl6MQQ.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/karma/v5/wvqTxAGBUrTqU0urTEoPIw.ttf\";s:3:\"500\";s:62:\"http://fonts.gstatic.com/s/karma/v5/9YGjxi6Hcvz2Kh-rzO_cAw.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/karma/v5/h_CVzXXtqSxjfS2sIwaejA.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/karma/v5/smuSM08oApsQPPVYbHd1CA.ttf\";}}i:389;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Katibeh\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/katibeh/v2/Q-SA43uWR2uu3wBIvedotA.ttf\";}}i:390;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Kaushan Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/kaushanscript/v5/qx1LSqts-NtiKcLw4N03IBnpV0hQCek3EmWnCPrvGRM.ttf\";}}i:391;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Kavivanar\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"tamil\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/kavivanar/v1/VLDrdUtF1irKFc8rFWgDaw.ttf\";}}i:392;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Kavoon\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/kavoon/v5/382m-6baKXqJFQjEgobt6Q.ttf\";}}i:393;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Kdam Thmor\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/kdamthmor/v3/otCdP6UU-VBIrBfVDWBQJ_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:394;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Keania One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/keaniaone/v4/PACrDKZWngXzgo-ucl6buvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:395;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Kelly Slab\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/kellyslab/v6/F_2oS1e9XdYx1MAi8XEVefesZW2xOQ-xsNqO47m55DA.ttf\";}}i:396;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Kenia\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/kenia/v8/OLM9-XfITK9PsTLKbGBrwg.ttf\";}}i:397;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Khand\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/khand/v4/072zRl4OU9Pinjjkg174LA.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/khand/v4/HdLdTNFqNIDGJZl1ZEj84w.ttf\";s:3:\"500\";s:62:\"http://fonts.gstatic.com/s/khand/v4/46_p-SqtuMe56nxQdteWxg.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/khand/v4/zggGWYIiPJyMTgkfxP_kaA.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/khand/v4/0I0UWaN-X5QBmfexpXKhqg.ttf\";}}i:398;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Khmer\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/khmer/v9/vWaBJIbaQuBNz02ALIKJ3A.ttf\";}}i:399;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Khula\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/khula/v1/_1LySU5Upq-sc4OZ1b_GIw.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/khula/v1/izcPIFyCSd16XI1Ak_Wk7Q.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/khula/v1/4ZH86Hce-aeFDaedTnbkbg.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/khula/v1/UGVExGl-Jjs-YPpGv-MZ6w.ttf\";s:3:\"800\";s:62:\"http://fonts.gstatic.com/s/khula/v1/Sccp_oOo8FWgbx5smie7xQ.ttf\";}}i:400;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Kite One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/kiteone/v4/8ojWmgUc97m0f_i6sTqLoQ.ttf\";}}i:401;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Knewave\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/knewave/v5/KGHM4XWr4iKnBMqzZLkPBg.ttf\";}}i:402;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Kotta One\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/kottaone/v4/AB2Q7hVw6niJYDgLvFXu5w.ttf\";}}i:403;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Koulen\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/koulen/v10/AAYOK8RSRO7FTskTzFuzNw.ttf\";}}i:404;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Kranky\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/kranky/v6/C8dxxTS99-fZ84vWk8SDrg.ttf\";}}i:405;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Kreon\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/kreon/v9/HKtJRiq5C2zbq5N1IX32sA.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/kreon/v9/zA_IZt0u0S3cvHJu-n1oEg.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/kreon/v9/jh0dSmaPodjxISiblIUTkw.ttf\";}}i:406;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Kristi\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/kristi/v7/aRsgBQrkQkMlu4UPSnJyOQ.ttf\";}}i:407;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Krona One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/kronaone/v4/zcQj4ljqTo166AdourlF9w.ttf\";}}i:408;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Kumar One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/kumarone/v1/YmcJD6Wky1clGYY5OD-BkQ.ttf\";}}i:409;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Kumar One Outline\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/kumaroneoutline/v1/hnQF47H-55qiLAGgq7C3QyxhoCTLJoiJ-y-zew8F8j0.ttf\";}}i:410;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Kurale\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:10:\"devanagari\";i:3;s:9:\"latin-ext\";i:4;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2017-01-19\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/kurale/v2/rxeyIcvQlT4XAWwNbXFCfw.ttf\";}}i:411;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"La Belle Aurore\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/labelleaurore/v7/Irdbc4ASuUoWDjd_Wc3md123K2iuuhwZgaKapkyRTY8.ttf\";}}i:412;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Laila\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/laila/v2/bLbIVEZF3IWSZ-in72GJvA.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/laila/v2/6iYor3edprH7360qtBGoag.ttf\";s:3:\"500\";s:62:\"http://fonts.gstatic.com/s/laila/v2/tkf8VtFvW9g3VsxQCA6WOQ.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/laila/v2/3EMP2L6JRQ4GaHIxCldCeA.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/laila/v2/R7P4z1xjcjecmjZ9GyhqHQ.ttf\";}}i:413;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Lakki Reddy\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/lakkireddy/v3/Q5EpFa91FjW37t0FCnedaKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:414;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Lalezar\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/lalezar/v1/k4_MPf09PGmL7oyGdPKwcg.ttf\";}}i:415;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Lancelot\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/lancelot/v6/XMT7T_oo_MQUGAnU2v-sdA.ttf\";}}i:416;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Lateef\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/lateef/v10/PAsKCgi1qc7XPwvzo_I-DQ.ttf\";}}i:417;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Lato\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2017-02-09\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"100\";s:62:\"http://fonts.gstatic.com/s/lato/v13/Upp-ka9rLQmHYCsFgwL-eg.ttf\";s:9:\"100italic\";s:62:\"http://fonts.gstatic.com/s/lato/v13/zLegi10uS_9-fnUDISl0KA.ttf\";s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/lato/v13/Ja02qOppOVq9jeRjWekbHg.ttf\";s:9:\"300italic\";s:62:\"http://fonts.gstatic.com/s/lato/v13/dVebFcn7EV7wAKwgYestUg.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/lato/v13/h7rISIcQapZBpei-sXwIwg.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/lato/v13/P_dJOFJylV3A870UIOtr0w.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/lato/v13/iX_QxBBZLhNj5JHlTzHQzg.ttf\";s:9:\"700italic\";s:62:\"http://fonts.gstatic.com/s/lato/v13/WFcZakHrrCKeUJxHA4T_gw.ttf\";s:3:\"900\";s:62:\"http://fonts.gstatic.com/s/lato/v13/8TPEV6NbYWZlNsXjbYVv7w.ttf\";s:9:\"900italic\";s:62:\"http://fonts.gstatic.com/s/lato/v13/draWperrI7n2xi35Cl08fA.ttf\";}}i:418;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"League Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/leaguescript/v7/wnRFLvfabWK_DauqppD6vSeUSrabuTpOsMEiRLtKwk0.ttf\";}}i:419;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Leckerli One\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/leckerlione/v7/S2Y_iLrItTu8kIJTkS7DrC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:420;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Ledger\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/ledger/v4/G432jp-tahOfWHbCYkI0jw.ttf\";}}i:421;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Lekton\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/lekton/v7/r483JYmxf5PjIm4jVAm8Yg.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/lekton/v7/_UbDIPBA1wDqSbhp-OED7A.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/lekton/v7/WZw-uL8WTkx3SBVfTlevXQ.ttf\";}}i:422;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Lemon\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/lemon/v5/wed1nNu4LNSu-3RoRVUhUw.ttf\";}}i:423;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Lemonada\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/lemonada/v2/uM3MufQOcwGHuruj4TsXiqCWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/lemonada/v2/pkzws3AUXmaaAzOi7aydSQ.ttf\";s:3:\"600\";s:86:\"http://fonts.gstatic.com/s/lemonada/v2/9Vd4MNKsOxNyLzlfTXdKLqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/lemonada/v2/9jKcm4hRI511-Dy7FFfQ3aCWcynf_cDxXwCLxiixG1c.ttf\";}}i:424;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Libre Baskerville\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/librebaskerville/v4/pR0sBQVcY0JZc_ciXjFsKyyZRYCSvpCzQKuMWnP5NDY.ttf\";s:6:\"italic\";s:94:\"http://fonts.gstatic.com/s/librebaskerville/v4/QHIOz1iKF3bIEzRdDFaf5QnhapNS5Oi8FPrBRDLbsW4.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/librebaskerville/v4/kH7K4InNTm7mmOXXjrA5v-xuswJKUVpBRfYFpz0W3Iw.ttf\";}}i:425;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Libre Franklin\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/zrsyK9EytLQ07oRM9IZIsX6Zf0VB_l-7q6pFtcZSRCs.ttf\";s:9:\"100italic\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/LHzsuUmxr4UY-IoiG8pRK4gsWNE1DYiT_eIOcNe2Au4.ttf\";s:3:\"200\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/1_DGDtljMiPWFs5rl_p0yCwKTB4uIbnDXE2hyxZaFPY.ttf\";s:9:\"200italic\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/7_V210XP3LBEtEwiCTqho0lu1sSkaQaYEjN61aJ3i1I.ttf\";s:3:\"300\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/1_DGDtljMiPWFs5rl_p0yMhKJW3W9-339CFS_Lie1us.ttf\";s:9:\"300italic\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/7_V210XP3LBEtEwiCTqho14je5cfhxzx5bEvSaoyQQI.ttf\";s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/PFwjf3aDdAQPvNKUrT3U7_fSnedoLXQQjURyDxluu8g.ttf\";s:6:\"italic\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/zrsyK9EytLQ07oRM9IZIsX5kKxjpQfTpnFf2SrDLxlg.ttf\";s:3:\"500\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/1_DGDtljMiPWFs5rl_p0yMBjwrbmxH6gp8HgxjPD8qo.ttf\";s:9:\"500italic\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/7_V210XP3LBEtEwiCTqho5VcuOW5XbZIr02vW37iuvg.ttf\";s:3:\"600\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/1_DGDtljMiPWFs5rl_p0yORt4MKdIUjA60qLK3wI2m8.ttf\";s:9:\"600italic\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/7_V210XP3LBEtEwiCTqhowNPRgU5g4Xymf9hgRWrbNs.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/1_DGDtljMiPWFs5rl_p0yEnStGWSv3WdwjmyyI8xc7Q.ttf\";s:9:\"700italic\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/7_V210XP3LBEtEwiCTqhow7kn3RFjf4gfwsdsBE-Rf4.ttf\";s:3:\"800\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/1_DGDtljMiPWFs5rl_p0yKltwG0cydF-uC1kFVv1hts.ttf\";s:9:\"800italic\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/7_V210XP3LBEtEwiCTqho80d7u0uHUbaRkK-cNyim1w.ttf\";s:3:\"900\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/1_DGDtljMiPWFs5rl_p0yF7duMYIKwoQ5QsTL00fobw.ttf\";s:9:\"900italic\";s:91:\"http://fonts.gstatic.com/s/librefranklin/v1/7_V210XP3LBEtEwiCTqho0THpHUXJVnEwH4tSjkF0wg.ttf\";}}i:426;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Life Savers\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/lifesavers/v6/g49cUDk4Y1P0G5NMkMAm7qCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/lifesavers/v6/THQKqChyYUm97rNPVFdGGXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:427;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Lilita One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/lilitaone/v4/vTxJQjbNV6BCBHx8sGDCVvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:428;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Lily Script One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/lilyscriptone/v4/uPWsLVW8uiXqIBnE8ZwGPDjVlsJB_M_Q_LtZxsoxvlw.ttf\";}}i:429;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Limelight\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/limelight/v7/5dTfN6igsXjLjOy8QQShcg.ttf\";}}i:430;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Linden Hill\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2017-02-09\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/lindenhill/v6/UgsC0txqd-E1yjvjutwm_KCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:88:\"http://fonts.gstatic.com/s/lindenhill/v6/OcS3bZcu8vJvIDH8Zic83keOrDcLawS7-ssYqLr2Xp4.ttf\";}}i:431;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Lobster\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v18\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/lobster/v18/9LpJGtNuM1D8FAZ2BkJH2Q.ttf\";}}i:432;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Lobster Two\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/lobstertwo/v9/xb9aY4w9ceh8JRzobID1naCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:88:\"http://fonts.gstatic.com/s/lobstertwo/v9/Ul_16MSbfayQv1I4QhLEoEeOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/lobstertwo/v9/bmdxOflBqMqjEC0-kGsIiHe1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:88:\"http://fonts.gstatic.com/s/lobstertwo/v9/LEkN2_no_6kFvRfiBZ8xpM_zJjSACmk0BRPxQqhnNLU.ttf\";}}i:433;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Londrina Outline\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/londrinaoutline/v5/lls08GOa1eT74p072l1AWJmp8DTZ6iHear7UV05iykg.ttf\";}}i:434;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Londrina Shadow\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/londrinashadow/v4/dNYuzPS_7eYgXFJBzMoKdbw6Z3rVA5KDSi7aQxS92Nk.ttf\";}}i:435;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Londrina Sketch\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/londrinasketch/v4/p7Ai06aT1Ycp_D2fyE3z69d6z_uhFGnpCOifUY1fJQo.ttf\";}}i:436;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Londrina Solid\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/londrinasolid/v4/yysorIEiYSBb0ylZjg791MR125CwGqh8XBqkBzea0LA.ttf\";}}i:437;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Lora\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2017-01-19\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/lora/v10/aXJ7KVIGcejEy1abawZazg.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/lora/v10/AN2EZaj2tFRpyveuNn9BOg.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/lora/v10/enKND5SfzQKkggBA_VnT1A.ttf\";s:9:\"700italic\";s:62:\"http://fonts.gstatic.com/s/lora/v10/ivs9j3kYU65pR9QD9YFdzQ.ttf\";}}i:438;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:21:\"Love Ya Like A Sister\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/loveyalikeasister/v7/LzkxWS-af0Br2Sk_YgSJY-ad1xEP8DQfgfY8MH9aBUg.ttf\";}}i:439;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Loved by the King\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/lovedbytheking/v6/wg03xD4cWigj4YDufLBSr8io2AFEwwMpu7y5KyiyAJc.ttf\";}}i:440;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Lovers Quarrel\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/loversquarrel/v4/gipdZ8b7pKb89MzQLAtJHLHLxci2ElvNEmOB303HLk0.ttf\";}}i:441;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Luckiest Guy\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/luckiestguy/v6/5718gH8nDy3hFVihOpkY5C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:442;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Lusitana\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/lusitana/v4/l1h9VDomkwbdzbPdmLcUIw.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/lusitana/v4/GWtZyUsONxgkdl3Mc1P7FKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:443;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Lustria\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/lustria/v4/gXAk0s4ai0X-TAOhYzZd1w.ttf\";}}i:444;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Macondo\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/macondo/v5/G6yPNUscRPQ8ufBXs_8yRQ.ttf\";}}i:445;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Macondo Swash Caps\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/macondoswashcaps/v4/SsSR706z-MlvEH7_LS6JAPkkgYRHs6GSG949m-K6x2k.ttf\";}}i:446;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Mada\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:61:\"http://fonts.gstatic.com/s/mada/v1/P46fye2TPh4fVwALgHSXCA.ttf\";s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/mada/v1/io_zUrt5o943T_q45OHLWQ.ttf\";s:3:\"500\";s:61:\"http://fonts.gstatic.com/s/mada/v1/PhhDsBi34sP0LptbpS9m6w.ttf\";s:3:\"900\";s:61:\"http://fonts.gstatic.com/s/mada/v1/aCyc9Kc3rOJLL6fV9VfptA.ttf\";}}i:447;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Magra\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/magra/v4/hoZ13bwCXBxuGZqAudgc5A.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/magra/v4/6fOM5sq5cIn8D0RjX8Lztw.ttf\";}}i:448;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Maiden Orange\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/maidenorange/v6/ZhKIA2SPisEwdhW7g0RUWojjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:449;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Maitree\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"200\";s:85:\"http://fonts.gstatic.com/s/maitree/v1/JTlrRs3bVPV4i05cUIx_z_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"300\";s:85:\"http://fonts.gstatic.com/s/maitree/v1/rEGdABAOaqCHggl37mkWjfesZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/maitree/v1/SpKVJkAjDAYOr1VkdSRspA.ttf\";s:3:\"500\";s:85:\"http://fonts.gstatic.com/s/maitree/v1/2VHD7TXjRhN4Xu74SEPGdvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:85:\"http://fonts.gstatic.com/s/maitree/v1/uuazDnPwt30gW3cKsG-e0_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/maitree/v1/cnHhc9fphsL3q-pistN3IPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:450;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Mako\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/mako/v7/z5zSLmfPlv1uTVAdmJBLXg.ttf\";}}i:451;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Mallanna\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/mallanna/v4/krCTa-CfMbtxqF0689CbuQ.ttf\";}}i:452;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Mandali\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/mandali/v4/0lF8yJ7fkyjXuqtSi5bWbQ.ttf\";}}i:453;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Marcellus\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/marcellus/v4/UjiLZzumxWC9whJ86UtaYw.ttf\";}}i:454;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Marcellus SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/marcellussc/v4/_jugwxhkkynrvsfrxVx8gS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:455;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Marck Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/marckscript/v7/O_D1NAZVOFOobLbVtW3bci3USBnSvpkopQaUR-2r7iU.ttf\";}}i:456;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Margarine\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/margarine/v5/DJnJwIrcO_cGkjSzY3MERw.ttf\";}}i:457;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Marko One\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/markoone/v6/hpP7j861sOAco43iDc4n4w.ttf\";}}i:458;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Marmelad\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/marmelad/v6/jI0_FBlSOIRLL0ePWOhOwQ.ttf\";}}i:459;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Martel\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"200\";s:63:\"http://fonts.gstatic.com/s/martel/v1/_wfGdswZbat7P4tupHLA1w.ttf\";s:3:\"300\";s:63:\"http://fonts.gstatic.com/s/martel/v1/SghoV2F2VPdVU3P0a4fa9w.ttf\";s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/martel/v1/9ALu5czkaaf5zsYk6GJEnQ.ttf\";s:3:\"600\";s:63:\"http://fonts.gstatic.com/s/martel/v1/Kt9uPhH1PvUwuZ5Y6zuAMQ.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/martel/v1/4OzIiKB5wE36xXL2U0vzWQ.ttf\";s:3:\"800\";s:63:\"http://fonts.gstatic.com/s/martel/v1/RVF8drcQoRkRL7l_ZkpTlQ.ttf\";s:3:\"900\";s:63:\"http://fonts.gstatic.com/s/martel/v1/iS0YUpFJoiLRlnyl40rpEA.ttf\";}}i:460;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Martel Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"200\";s:88:\"http://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQEnzyIngrzGjGh22wPb6cGM.ttf\";s:3:\"300\";s:88:\"http://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQC9-WlPSxbfiI49GsXo3q0g.ttf\";s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/martelsans/v2/91c8DPDZncMc0RFfhmc2RqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"600\";s:88:\"http://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQJZ7xm-Bj30Bj2KNdXDzSZg.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQHe1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:3:\"800\";s:88:\"http://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQA89PwPrYLaRFJ-HNCU9NbA.ttf\";s:3:\"900\";s:88:\"http://fonts.gstatic.com/s/martelsans/v2/7ajme85aKKx_SCWF59ImQCenaqEuufTBk9XMKnKmgDA.ttf\";}}i:461;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Marvel\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/marvel/v6/Fg1dO8tWVb-MlyqhsbXEkg.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/marvel/v6/HzyjFB-oR5usrc7Lxz9g8w.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/marvel/v6/WrHDBL1RupWGo2UcdgxB3Q.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/marvel/v6/Gzf5NT09Y6xskdQRj2kz1qCWcynf_cDxXwCLxiixG1c.ttf\";}}i:462;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Mate\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/mate/v5/ooFviPcJ6hZP5bAE71Cawg.ttf\";s:6:\"italic\";s:61:\"http://fonts.gstatic.com/s/mate/v5/5XwW6_cbisGvCX5qmNiqfA.ttf\";}}i:463;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Mate SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/matesc/v5/-YkIT2TZoPZF6pawKzDpWw.ttf\";}}i:464;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Maven Pro\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/mavenpro/v8/sqPJIFG4gqsjl-0q_46Gbw.ttf\";s:3:\"500\";s:86:\"http://fonts.gstatic.com/s/mavenpro/v8/SQVfzoJBbj9t3aVcmbspRi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/mavenpro/v8/uDssvmXgp7Nj3i336k_dSi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/mavenpro/v8/-91TwiFzqeL1F7Kh91APwS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:465;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"McLaren\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/mclaren/v4/OprvTGxaiINBKW_1_U0eoQ.ttf\";}}i:466;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Meddon\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/meddon/v9/f8zJO98uu2EtSj9p7ci9RA.ttf\";}}i:467;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"MedievalSharp\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/medievalsharp/v8/85X_PjV6tftJ0-rX7KYQkOe45sJkivqprK7VkUlzfg0.ttf\";}}i:468;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Medula One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/medulaone/v6/AasPgDQak81dsTGQHc5zUPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:469;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Meera Inimai\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"tamil\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/meerainimai/v1/fWbdJc2ZVZnWCi06NRCxDy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:470;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Megrim\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/megrim/v7/e-9jVUC9lv1zxaFQARuftw.ttf\";}}i:471;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Meie Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/meiescript/v4/oTIWE5MmPye-rCyVp_6KEqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:472;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Merienda\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/merienda/v4/MYY6Og1qZlOQtPW2G95Y3A.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/merienda/v4/GlwcvRLlgiVE2MBFQ4r0sKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:473;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Merienda One\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/meriendaone/v7/bCA-uDdUx6nTO8SjzCLXvS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:474;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Merriweather\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2017-02-06\";s:5:\"files\";O:8:\"stdClass\":8:{s:3:\"300\";s:91:\"http://fonts.gstatic.com/s/merriweather/v15/ZvcMqxEwPfh2qDWBPxn6nqcQoVhARpoaILP7amxE_8g.ttf\";s:9:\"300italic\";s:91:\"http://fonts.gstatic.com/s/merriweather/v15/EYh7Vl4ywhowqULgRdYwICna0FLWfcB-J_SAYmcAXaI.ttf\";s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/merriweather/v15/RFda8w1V0eDZheqfcyQ4EC3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:91:\"http://fonts.gstatic.com/s/merriweather/v15/So5lHxHT37p2SS4-t60SlPMZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/merriweather/v15/ZvcMqxEwPfh2qDWBPxn6nkD2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:91:\"http://fonts.gstatic.com/s/merriweather/v15/EYh7Vl4ywhowqULgRdYwIPAs9-1nE9qOqhChW0m4nDE.ttf\";s:3:\"900\";s:91:\"http://fonts.gstatic.com/s/merriweather/v15/ZvcMqxEwPfh2qDWBPxn6nqObDOjC3UL77puoeHsE3fw.ttf\";s:9:\"900italic\";s:91:\"http://fonts.gstatic.com/s/merriweather/v15/EYh7Vl4ywhowqULgRdYwIBd0_s6jQr9r5s5OZYvtzBY.ttf\";}}i:475;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Merriweather Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":8:{s:3:\"300\";s:94:\"http://fonts.gstatic.com/s/merriweathersans/v8/6LmGj5dOJopQKEkt88Gowan5N8K-_DP0e9e_v51obXQ.ttf\";s:9:\"300italic\";s:94:\"http://fonts.gstatic.com/s/merriweathersans/v8/nAqt4hiqwq3tzCecpgPmVdytE4nGXk2hYD5nJ740tBw.ttf\";s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/merriweathersans/v8/AKu1CjQ4qnV8MUltkAX3sOAj_ty82iuwwDTNEYXGiyQ.ttf\";s:6:\"italic\";s:94:\"http://fonts.gstatic.com/s/merriweathersans/v8/3Mz4hOHzs2npRMG3B1ascZ32VBCoA_HLsn85tSWZmdo.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/merriweathersans/v8/6LmGj5dOJopQKEkt88GowbqxG25nQNOioCZSK4sU-CA.ttf\";s:9:\"700italic\";s:94:\"http://fonts.gstatic.com/s/merriweathersans/v8/nAqt4hiqwq3tzCecpgPmVbuqAJxizi8Dk_SK5et7kMg.ttf\";s:3:\"800\";s:94:\"http://fonts.gstatic.com/s/merriweathersans/v8/6LmGj5dOJopQKEkt88GowYufzO2zUYSj5LqoJ3UGkco.ttf\";s:9:\"800italic\";s:94:\"http://fonts.gstatic.com/s/merriweathersans/v8/nAqt4hiqwq3tzCecpgPmVdDmPrYMy3aZO4LmnZsxTQw.ttf\";}}i:476;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Metal\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/metal/v9/zA3UOP13ooQcxjv04BZX5g.ttf\";}}i:477;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Metal Mania\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/metalmania/v6/isriV_rAUgj6bPWPN6l9QKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:478;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Metamorphous\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/metamorphous/v6/wGqUKXRinIYggz-BTRU9ei3USBnSvpkopQaUR-2r7iU.ttf\";}}i:479;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Metrophobic\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/metrophobic/v9/SaglWZWCrrv_D17u1i4v_aCWcynf_cDxXwCLxiixG1c.ttf\";}}i:480;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Michroma\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/michroma/v7/0c2XrW81_QsiKV8T9thumA.ttf\";}}i:481;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Milonga\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/milonga/v4/dzNdIUSTGFmy2ahovDRcWg.ttf\";}}i:482;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Miltonian\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:67:\"http://fonts.gstatic.com/s/miltonian/v10/Z4HrYZyqm0BnNNzcCUfzoQ.ttf\";}}i:483;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Miltonian Tattoo\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/miltoniantattoo/v11/1oU_8OGYwW46eh02YHydn2uk0YtI6thZkz1Hmh-odwg.ttf\";}}i:484;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Miniver\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/miniver/v5/4yTQohOH_cWKRS5laRFhYg.ttf\";}}i:485;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Miriam Libre\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:6:\"hebrew\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/miriamlibre/v1/Ljtpu8zR5iJWmlN3Faba5S3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/miriamlibre/v1/FLc0J-Gdn8ynDWUkeeesAED2ttfZwueP-QU272T9-k4.ttf\";}}i:486;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Mirza\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/mirza/v1/8oe36Xbgj9BMSLJBaZ8VAQ.ttf\";s:3:\"500\";s:62:\"http://fonts.gstatic.com/s/mirza/v1/dT3HbZoBCx1xbU7PnFEFyQ.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/mirza/v1/6T4uh2Zti9P6Eq_gbAYvVQ.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/mirza/v1/b47CZDHoZdhnplmDpZymFw.ttf\";}}i:487;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Miss Fajardose\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/missfajardose/v6/WcXjlQPKn6nBfr8LY3ktNu6rPKfVZo7L2bERcf0BDns.ttf\";}}i:488;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Mitr\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"200\";s:61:\"http://fonts.gstatic.com/s/mitr/v1/GCzZRAhweqJhxrmM0bPztg.ttf\";s:3:\"300\";s:61:\"http://fonts.gstatic.com/s/mitr/v1/A61rQ_y9i8Ja__oFN7KxiQ.ttf\";s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/mitr/v1/vKMd72X2iT4iBo5GvdCa_A.ttf\";s:3:\"500\";s:61:\"http://fonts.gstatic.com/s/mitr/v1/r_Z6yrJJ0zmkGAqxqjlLRg.ttf\";s:3:\"600\";s:61:\"http://fonts.gstatic.com/s/mitr/v1/42l66tb_XMxM97GKatU9Ng.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/mitr/v1/V-V7Rul5HOZ651R4Tml2Lw.ttf\";}}i:489;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Modak\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-05-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/modak/v2/lMsN0QIKid-pCPvL0hH4nw.ttf\";}}i:490;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Modern Antiqua\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/modernantiqua/v6/8qX_tr6Xzy4t9fvZDXPkh6rFJ4O13IHVxZbM6yoslpo.ttf\";}}i:491;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Mogra\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/mogra/v1/gIxQBn9PseDaI0D4FnOiBQ.ttf\";}}i:492;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Molengo\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/molengo/v7/jcjgeGuzv83I55AzOTpXNQ.ttf\";}}i:493;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Molle\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/molle/v4/9XTdCsjPXifLqo5et-YoGA.ttf\";}}i:494;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Monda\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/monda/v6/qFMHZ9zvR6B_gnoIgosPrw.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/monda/v6/EVOzZUyc_j1w2GuTgTAW1g.ttf\";}}i:495;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Monofett\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/monofett/v6/C6K5L799Rgxzg2brgOaqAw.ttf\";}}i:496;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Monoton\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/monoton/v6/aCz8ja_bE4dg-7agSvExdw.ttf\";}}i:497;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Monsieur La Doulaise\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:96:\"http://fonts.gstatic.com/s/monsieurladoulaise/v5/IMAdMj6Eq9jZ46CPctFtMKP61oAqTJXlx5ZVOBmcPdM.ttf\";}}i:498;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Montaga\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/montaga/v4/PwTwUboiD-M4-mFjZfJs2A.ttf\";}}i:499;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Montez\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/montez/v6/kx58rLOWQQLGFM4pDHv5Ng.ttf\";}}i:500;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Montserrat\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2017-02-09\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/CdKWaRAal2Bxq9mORLKRRS3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"100italic\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/1809Y0aW9bpFOPXsQTFwf8SVQ0giZ-l_NELu3lgGyYw.ttf\";s:3:\"200\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/eWRmKHdPNWGn_iFyeEYja2eudeTO44zf-ht3k-KNzwg.ttf\";s:9:\"200italic\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/zhwB3-BAdyKDf0geWr9FtwQm5IkIgNCodAfQb4ovl18.ttf\";s:3:\"300\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/IVeH6A3MiFyaSEiudUMXE0eOrDcLawS7-ssYqLr2Xp4.ttf\";s:9:\"300italic\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/zhwB3-BAdyKDf0geWr9Ft6cQoVhARpoaILP7amxE_8g.ttf\";s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/Kqy6-utIpx_30Xzecmeo8_esZW2xOQ-xsNqO47m55DA.ttf\";s:6:\"italic\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/-iqwlckIhsmvkx0N6rwPmi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"500\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/BYPM-GE291ZjIXBWrtCwepp-63r6doWhTEbsfBIRJ7A.ttf\";s:9:\"500italic\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/zhwB3-BAdyKDf0geWr9Ft5MQuUSAwdHsY8ov_6tk1oA.ttf\";s:3:\"600\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/q2OIMsAtXEkOulLQVdSl0_pTEJqju4Hz1txDWij77d4.ttf\";s:9:\"600italic\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/zhwB3-BAdyKDf0geWr9Ft2v8CylhIUtwUiYO7Z2wXbE.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/IQHow_FEYlDC4Gzy_m8fcgJKKGfqHaYFsRG-T3ceEVo.ttf\";s:9:\"700italic\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/zhwB3-BAdyKDf0geWr9Ft0D2ttfZwueP-QU272T9-k4.ttf\";s:3:\"800\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/H8_7oktkjVeeX06kbAvc0Kk3bhPBSBJ0bSJQ6acL-0g.ttf\";s:9:\"800italic\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/zhwB3-BAdyKDf0geWr9Ft_qsay_1ZmRGmC8pVRdIfAg.ttf\";s:3:\"900\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/aEu-9ATAroJ1iN4zmQ55Bp0EAVxt0G0biEntp43Qt6E.ttf\";s:9:\"900italic\";s:89:\"http://fonts.gstatic.com/s/montserrat/v10/zhwB3-BAdyKDf0geWr9Ft6ObDOjC3UL77puoeHsE3fw.ttf\";}}i:501;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:21:\"Montserrat Alternates\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2017-02-09\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/oqQkJ7FUCF9bJw9oNhwpltmjtuu7N1WAenNR-bns1HU.ttf\";s:9:\"100italic\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/3-rFIqHz_U7TAmWg7RcpLzob9T7De5a9EmE7cInrugI.ttf\";s:3:\"200\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/YENqOGAVzwIHjYNjmKuAZrWzJnWnTj1NV2WEtcqW8F0.ttf\";s:9:\"200italic\";s:119:\"http://fonts.gstatic.com/s/montserratalternates/v7/AXzeb8s80Wvg1Wkw1cVlATSYqyfLbk4Wyr4DDJHtpar3rGVtsTkPsbDajuO5ueQw.ttf\";s:3:\"300\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/YENqOGAVzwIHjYNjmKuAZoE9JAqK0NEjKMCIBssy61I.ttf\";s:9:\"300italic\";s:119:\"http://fonts.gstatic.com/s/montserratalternates/v7/AXzeb8s80Wvg1Wkw1cVlAX0Ksah31OxOJpZejHsaXyX3rGVtsTkPsbDajuO5ueQw.ttf\";s:7:\"regular\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/z2n1Sjxk9souK3HCtdHuklPuEVRGaG9GCQnmM16YWq0.ttf\";s:6:\"italic\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/oqQkJ7FUCF9bJw9oNhwpliKJhVBtn9MynHVBPiS2bkc.ttf\";s:3:\"500\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/YENqOGAVzwIHjYNjmKuAZkLT1bEhWimL9YDPt6og4ow.ttf\";s:9:\"500italic\";s:119:\"http://fonts.gstatic.com/s/montserratalternates/v7/AXzeb8s80Wvg1Wkw1cVlAbq1yxDcj1rkVNifBkzxbjz3rGVtsTkPsbDajuO5ueQw.ttf\";s:3:\"600\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/YENqOGAVzwIHjYNjmKuAZlzJBia8MVcXq42LmpYhWMY.ttf\";s:9:\"600italic\";s:119:\"http://fonts.gstatic.com/s/montserratalternates/v7/AXzeb8s80Wvg1Wkw1cVlAdzE96w6fJMDbKTKS-tt8C_3rGVtsTkPsbDajuO5ueQw.ttf\";s:3:\"700\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/YENqOGAVzwIHjYNjmKuAZpeqBKvsAhm-s2I4RVSXFfc.ttf\";s:9:\"700italic\";s:119:\"http://fonts.gstatic.com/s/montserratalternates/v7/AXzeb8s80Wvg1Wkw1cVlAVeYZ2vsofSkgKvS_YtoH2b3rGVtsTkPsbDajuO5ueQw.ttf\";s:3:\"800\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/YENqOGAVzwIHjYNjmKuAZkG2AOFTt9I0BIk1fL0aWvI.ttf\";s:9:\"800italic\";s:119:\"http://fonts.gstatic.com/s/montserratalternates/v7/AXzeb8s80Wvg1Wkw1cVlAbM_h-OHjcDf1XWbHqSgRF73rGVtsTkPsbDajuO5ueQw.ttf\";s:3:\"900\";s:98:\"http://fonts.gstatic.com/s/montserratalternates/v7/YENqOGAVzwIHjYNjmKuAZqjHT7NF_e7B-hWEBx2SqPI.ttf\";s:9:\"900italic\";s:119:\"http://fonts.gstatic.com/s/montserratalternates/v7/AXzeb8s80Wvg1Wkw1cVlAX18ggQg0KDcknRVFWguAv_3rGVtsTkPsbDajuO5ueQw.ttf\";}}i:502;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Montserrat Subrayada\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2017-01-26\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:97:\"http://fonts.gstatic.com/s/montserratsubrayada/v4/nzoCWCz0e9c7Mr2Gl8bbgrJymm6ilkk9f0nDA_sC_qk.ttf\";s:3:\"700\";s:97:\"http://fonts.gstatic.com/s/montserratsubrayada/v4/wf-IKpsHcfm0C9uaz9IeGJvEcF1LWArDbGWgKZSH9go.ttf\";}}i:503;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Moul\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/moul/v8/Kb0ALQnfyXawP1a_P_gpTQ.ttf\";}}i:504;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Moulpali\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/moulpali/v9/diD74BprGhmVkJoerKmrKA.ttf\";}}i:505;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:22:\"Mountains of Christmas\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:98:\"http://fonts.gstatic.com/s/mountainsofchristmas/v8/dVGBFPwd6G44IWDbQtPew2Auds3jz1Fxb61CgfaGDr4.ttf\";s:3:\"700\";s:98:\"http://fonts.gstatic.com/s/mountainsofchristmas/v8/PymufKtHszoLrY0uiAYKNM9cPTbSBTrQyTa5TWAe3vE.ttf\";}}i:506;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Mouse Memoirs\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/mousememoirs/v4/NBFaaJFux_j0AQbAsW3QeH8f0n03UdmQgF_CLvNR2vg.ttf\";}}i:507;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Mr Bedfort\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/mrbedfort/v5/81bGgHTRikLs_puEGshl7_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:508;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Mr Dafoe\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/mrdafoe/v5/s32Q1S6ZkT7EaX53mUirvQ.ttf\";}}i:509;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Mr De Haviland\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/mrdehaviland/v5/fD8y4L6PJ4vqDk7z8Y8e27v4lrhng1lzu7-weKO6cw8.ttf\";}}i:510;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Mrs Saint Delafield\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/mrssaintdelafield/v4/vuWagfFT7bj9lFtZOFBwmjHMBelqWf3tJeGyts2SmKU.ttf\";}}i:511;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Mrs Sheppards\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/mrssheppards/v5/2WFsWMV3VUeCz6UVH7UjCn8f0n03UdmQgF_CLvNR2vg.ttf\";}}i:512;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Mukta Vaani\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"200\";s:88:\"http://fonts.gstatic.com/s/muktavaani/v1/X9qyC4rK_D9w1AvSv0mw_0nzyIngrzGjGh22wPb6cGM.ttf\";s:3:\"300\";s:88:\"http://fonts.gstatic.com/s/muktavaani/v1/X9qyC4rK_D9w1AvSv0mw_y9-WlPSxbfiI49GsXo3q0g.ttf\";s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/muktavaani/v1/knS0wTOFNOwOD4CZrdHIxKCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"500\";s:88:\"http://fonts.gstatic.com/s/muktavaani/v1/X9qyC4rK_D9w1AvSv0mw_8CNfqCYlB_eIx7H1TVXe60.ttf\";s:3:\"600\";s:88:\"http://fonts.gstatic.com/s/muktavaani/v1/X9qyC4rK_D9w1AvSv0mw_5Z7xm-Bj30Bj2KNdXDzSZg.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/muktavaani/v1/X9qyC4rK_D9w1AvSv0mw_3e1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:3:\"800\";s:88:\"http://fonts.gstatic.com/s/muktavaani/v1/X9qyC4rK_D9w1AvSv0mw_w89PwPrYLaRFJ-HNCU9NbA.ttf\";}}i:513;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Muli\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":14:{s:3:\"200\";s:62:\"http://fonts.gstatic.com/s/muli/v10/59Vi0Dm-YSaaKxRiSKrm0w.ttf\";s:9:\"200italic\";s:62:\"http://fonts.gstatic.com/s/muli/v10/ZV7FMcmPA9u6IXfXrqyybA.ttf\";s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/muli/v10/VJw4F3ZHRAZ7Hmg3nQu5YQ.ttf\";s:9:\"300italic\";s:62:\"http://fonts.gstatic.com/s/muli/v10/s-NKMCru8HiyjEt0ZDoBoA.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/muli/v10/KJiP6KznxbALQgfJcDdPAw.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/muli/v10/Cg0K_IWANs9xkNoxV7H1_w.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/muli/v10/O4zVJyE-wzb2CQjcHkw-Xg.ttf\";s:9:\"600italic\";s:62:\"http://fonts.gstatic.com/s/muli/v10/xasdEbMzFtnmERn70-CN-A.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/muli/v10/n0UfHdYd8jlanPB1sJ0WYQ.ttf\";s:9:\"700italic\";s:62:\"http://fonts.gstatic.com/s/muli/v10/9vQS_qOVbbe4j6LkPjCG1g.ttf\";s:3:\"800\";s:62:\"http://fonts.gstatic.com/s/muli/v10/QdHPibssQgzNly7JkF7wdw.ttf\";s:9:\"800italic\";s:62:\"http://fonts.gstatic.com/s/muli/v10/jbD7XyPvLT1oJBLbEcQmmg.ttf\";s:3:\"900\";s:62:\"http://fonts.gstatic.com/s/muli/v10/RcGfHFZUYLsFj9c3uAb4Gg.ttf\";s:9:\"900italic\";s:62:\"http://fonts.gstatic.com/s/muli/v10/r4hqeWwjqEvTncJsq5KCSg.ttf\";}}i:514;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Mystery Quest\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/mysteryquest/v4/467jJvg0c7HgucvBB9PLDyeUSrabuTpOsMEiRLtKwk0.ttf\";}}i:515;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:3:\"NTR\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:60:\"http://fonts.gstatic.com/s/ntr/v4/e7H4ZLtGfVOYyOupo6T12g.ttf\";}}i:516;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Neucha\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/neucha/v8/bijdhB-TzQdtpl0ykhGh4Q.ttf\";}}i:517;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Neuton\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"200\";s:63:\"http://fonts.gstatic.com/s/neuton/v9/DA3Mkew3XqSkPpi1f4tJow.ttf\";s:3:\"300\";s:63:\"http://fonts.gstatic.com/s/neuton/v9/xrc_aZ2hx-gdeV0mlY8Vww.ttf\";s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/neuton/v9/9R-MGIOQUdjAVeB6nE6PcQ.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/neuton/v9/uVMT3JOB5BNFi3lgPp6kEg.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/neuton/v9/gnWpkWY7DirkKiovncYrfg.ttf\";s:3:\"800\";s:63:\"http://fonts.gstatic.com/s/neuton/v9/XPzBQV4lY6enLxQG9cF1jw.ttf\";}}i:518;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"New Rocker\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/newrocker/v5/EFUWzHJedEkpW399zYOHofesZW2xOQ-xsNqO47m55DA.ttf\";}}i:519;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"News Cycle\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/newscycle/v13/xyMAr8VfiUzIOvS1abHJO_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/newscycle/v13/G28Ny31cr5orMqEQy6ljtwJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:520;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Niconne\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/niconne/v6/ZA-mFw2QNXodx5y7kfELBg.ttf\";}}i:521;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Nixie One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/nixieone/v7/h6kQfmzm0Shdnp3eswRaqQ.ttf\";}}i:522;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Nobile\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/nobile/v7/lC_lPi1ddtN38iXTCRh6ow.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/nobile/v7/vGmrpKzWQQSrb-PR6FWBIA.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/nobile/v7/9p6M-Yrg_r_QPmSD1skrOg.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/nobile/v7/oQ1eYPaXV638N03KvsNvyKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:523;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Nokora\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/nokora/v9/dRyz1JfnyKPNaRcBNX9F9A.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/nokora/v9/QMqqa4QEOhQpiig3cAPmbQ.ttf\";}}i:524;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Norican\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/norican/v4/SHnSqhYAWG5sZTWcPzEHig.ttf\";}}i:525;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Nosifer\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/nosifer/v5/7eJGoIuHRrtcG00j6CptSA.ttf\";}}i:526;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Nothing You Could Do\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/nothingyoucoulddo/v6/jpk1K3jbJoyoK0XKaSyQAf-TpkXjXYGWiJZAEtBRjPU.ttf\";}}i:527;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Noticia Text\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/noticiatext/v6/wdyV6x3eKpdeUPQ7BJ5uUC3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:89:\"http://fonts.gstatic.com/s/noticiatext/v6/dAuxVpkYE_Q_IwIm6elsKPMZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/noticiatext/v6/pEko-RqEtp45bE2P80AAKUD2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:89:\"http://fonts.gstatic.com/s/noticiatext/v6/-rQ7V8ARjf28_b7kRa0JuvAs9-1nE9qOqhChW0m4nDE.ttf\";}}i:528;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Noto Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:8:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:10:\"devanagari\";i:5;s:9:\"latin-ext\";i:6;s:12:\"cyrillic-ext\";i:7;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/notosans/v6/0Ue9FiUJwVhi4NGfHJS5uA.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/notosans/v6/dLcNKMgJ1H5RVoZFraDz0qCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/notosans/v6/PIbvSEyHEdL91QLOQRnZ1y3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/notosans/v6/9Z3uUWMRR7crzm1TjRicDne1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:529;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Noto Serif\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/notoserif/v4/zW6mc7bC1CWw8dH0yxY8JfesZW2xOQ-xsNqO47m55DA.ttf\";s:6:\"italic\";s:87:\"http://fonts.gstatic.com/s/notoserif/v4/HQXBIwLHsOJCNEQeX9kNzy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/notoserif/v4/lJAvZoKA5NttpPc9yc6lPQJKKGfqHaYFsRG-T3ceEVo.ttf\";s:9:\"700italic\";s:87:\"http://fonts.gstatic.com/s/notoserif/v4/Wreg0Be4tcFGM2t6VWytvED2ttfZwueP-QU272T9-k4.ttf\";}}i:530;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Nova Cut\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/novacut/v8/6q12jWcBvj0KO2cMRP97tA.ttf\";}}i:531;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Nova Flat\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/novaflat/v8/pK7a0CoGzI684qe_XSHBqQ.ttf\";}}i:532;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Nova Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"greek\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/novamono/v7/6-SChr5ZIaaasJFBkgrLNw.ttf\";}}i:533;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Nova Oval\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/novaoval/v8/VuukVpKP8BwUf8o9W5LYQQ.ttf\";}}i:534;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Nova Round\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/novaround/v8/7-cK3Ari_8XYYFgVMxVhDvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:535;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Nova Script\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/novascript/v8/dEvxQDLgx1M1TKY-NmBWYaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:536;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Nova Slim\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/novaslim/v8/rPYXC81_VL2EW-4CzBX65g.ttf\";}}i:537;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Nova Square\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/novasquare/v8/BcBzXoaDzYX78rquGXVuSqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:538;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Numans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/numans/v6/g5snI2p6OEjjTNmTHyBdiQ.ttf\";}}i:539;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Nunito\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":14:{s:3:\"200\";s:63:\"http://fonts.gstatic.com/s/nunito/v8/xtWPP_05UbsUNY9Kdgwt_w.ttf\";s:9:\"200italic\";s:84:\"http://fonts.gstatic.com/s/nunito/v8/EbyHzRpZ3jx6yC2BjZCsQqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"300\";s:63:\"http://fonts.gstatic.com/s/nunito/v8/zXQvrWBJqUooM7Xv98MrQw.ttf\";s:9:\"300italic\";s:84:\"http://fonts.gstatic.com/s/nunito/v8/4BFBxBQCHZfUELdybShAwKCWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/nunito/v8/ySZTeT3IuzJj0GK6uGpbBg.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/nunito/v8/NZNWFpgsC6hUUE2c03CLoQ.ttf\";s:3:\"600\";s:63:\"http://fonts.gstatic.com/s/nunito/v8/B4-BGlpEzQ4WP-D3Zi0PRQ.ttf\";s:9:\"600italic\";s:84:\"http://fonts.gstatic.com/s/nunito/v8/7SyYp8NBEeMV4V7MAKJnZ6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/nunito/v8/aEdlqgMuYbpe4U3TnqOQMA.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/nunito/v8/4cHctiCFYmTpv-a6b6vYsKCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"800\";s:63:\"http://fonts.gstatic.com/s/nunito/v8/GtGHSZwowZF8a9-GAsh20A.ttf\";s:9:\"800italic\";s:84:\"http://fonts.gstatic.com/s/nunito/v8/2TsLUs-EFIKsriUeVTl6nKCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"900\";s:63:\"http://fonts.gstatic.com/s/nunito/v8/QVvFcvcPoFKH9Q71V4WsjQ.ttf\";s:9:\"900italic\";s:84:\"http://fonts.gstatic.com/s/nunito/v8/cIxOb6Vw6BqF9ZoAlenp3qCWcynf_cDxXwCLxiixG1c.ttf\";}}i:540;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Nunito Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2017-01-25\";s:5:\"files\";O:8:\"stdClass\":14:{s:3:\"200\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/XvilrNtBQKRMeiqSPzEFHUnzyIngrzGjGh22wPb6cGM.ttf\";s:9:\"200italic\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/ORCQQ32ldzJ6bFTh_zXqV02YN_dW5g9CXH6iztHQiR4.ttf\";s:3:\"300\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/XvilrNtBQKRMeiqSPzEFHS9-WlPSxbfiI49GsXo3q0g.ttf\";s:9:\"300italic\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/ORCQQ32ldzJ6bFTh_zXqV2o9eWDfYYxG3A176Zl7aIg.ttf\";s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/qDS9UelBO44ppiSawKNcIKCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/w9sy7IRyDFLWACdltghEwUeOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"600\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/XvilrNtBQKRMeiqSPzEFHZZ7xm-Bj30Bj2KNdXDzSZg.ttf\";s:9:\"600italic\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/ORCQQ32ldzJ6bFTh_zXqV5e6We3S5L6hKLscKpOkmlo.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/XvilrNtBQKRMeiqSPzEFHXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/ORCQQ32ldzJ6bFTh_zXqV8_zJjSACmk0BRPxQqhnNLU.ttf\";s:3:\"800\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/XvilrNtBQKRMeiqSPzEFHQ89PwPrYLaRFJ-HNCU9NbA.ttf\";s:9:\"800italic\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/ORCQQ32ldzJ6bFTh_zXqVyad_7rtf4IdDfsLVg-2OV4.ttf\";s:3:\"900\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/XvilrNtBQKRMeiqSPzEFHSenaqEuufTBk9XMKnKmgDA.ttf\";s:9:\"900italic\";s:88:\"http://fonts.gstatic.com/s/nunitosans/v2/ORCQQ32ldzJ6bFTh_zXqV0_yTOUGsoC54csJe1b-IRw.ttf\";}}i:541;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Odor Mean Chey\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/odormeanchey/v8/GK3E7EjPoBkeZhYshGFo0eVKG8sq4NyGgdteJLvqLDs.ttf\";}}i:542;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Offside\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/offside/v4/v0C913SB8wqQUvcu1faUqw.ttf\";}}i:543;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Old Standard TT\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-19\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/oldstandardtt/v8/n6RTCDcIPWSE8UNBa4k-DLcB5jyhm1VsHs65c3QNDr0.ttf\";s:6:\"italic\";s:91:\"http://fonts.gstatic.com/s/oldstandardtt/v8/QQT_AUSp4AV4dpJfIN7U5PWrQzeMtsHf8QsWQ2cZg3c.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/oldstandardtt/v8/5Ywdce7XEbTSbxs__4X1_HJqbZqK7TdZ58X80Q_Lw8Y.ttf\";}}i:544;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Oldenburg\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/oldenburg/v4/dqA_M_uoCVXZbCO-oKBTnQ.ttf\";}}i:545;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Oleo Script\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/oleoscript/v5/21stZcmPyzbQVXtmGegyqKCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/oleoscript/v5/hudNQFKFl98JdNnlo363fne1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:546;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:22:\"Oleo Script Swash Caps\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:97:\"http://fonts.gstatic.com/s/oleoscriptswashcaps/v4/vdWhGqsBUAP-FF3NOYTe4iMF4kXAPemmyaDpMXQ31P0.ttf\";s:3:\"700\";s:97:\"http://fonts.gstatic.com/s/oleoscriptswashcaps/v4/HMO3ftxA9AU5floml9c755reFYaXZ4zuJXJ8fr8OO1g.ttf\";}}i:547;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Open Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";}s:7:\"subsets\";a:7:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"300\";s:87:\"http://fonts.gstatic.com/s/opensans/v13/DXI1ORHCpsQm3Vp6mXoaTS3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"300italic\";s:87:\"http://fonts.gstatic.com/s/opensans/v13/PRmiXeptR36kaC0GEAetxi9-WlPSxbfiI49GsXo3q0g.ttf\";s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/opensans/v13/IgZJs4-7SA1XX_edsoXWog.ttf\";s:6:\"italic\";s:87:\"http://fonts.gstatic.com/s/opensans/v13/O4NhV7_qs9r9seTo7fnsVKCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"600\";s:87:\"http://fonts.gstatic.com/s/opensans/v13/MTP_ySUJH_bn48VBG8sNSi3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"600italic\";s:87:\"http://fonts.gstatic.com/s/opensans/v13/PRmiXeptR36kaC0GEAetxpZ7xm-Bj30Bj2KNdXDzSZg.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/opensans/v13/k3k702ZOKiLJc3WVjuplzC3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:87:\"http://fonts.gstatic.com/s/opensans/v13/PRmiXeptR36kaC0GEAetxne1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:3:\"800\";s:87:\"http://fonts.gstatic.com/s/opensans/v13/EInbV5DfGHOiMmvb1Xr-hi3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"800italic\";s:87:\"http://fonts.gstatic.com/s/opensans/v13/PRmiXeptR36kaC0GEAetxg89PwPrYLaRFJ-HNCU9NbA.ttf\";}}i:548;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Open Sans Condensed\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:7:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:96:\"http://fonts.gstatic.com/s/opensanscondensed/v10/gk5FxslNkTTHtojXrkp-xEMwSSh38KQVJx4ABtsZTnA.ttf\";s:9:\"300italic\";s:96:\"http://fonts.gstatic.com/s/opensanscondensed/v10/jIXlqT1WKafUSwj6s9AzV4_LkTZ_uhAwfmGJ084hlvM.ttf\";s:3:\"700\";s:96:\"http://fonts.gstatic.com/s/opensanscondensed/v10/gk5FxslNkTTHtojXrkp-xBEM87DM3yorPOrvA-vB930.ttf\";}}i:549;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Oranienbaum\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/oranienbaum/v5/M98jYwCSn0PaFhXXgviCoaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:550;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Orbitron\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/orbitron/v7/DY8swouAZjR3RaUPRf0HDQ.ttf\";s:3:\"500\";s:86:\"http://fonts.gstatic.com/s/orbitron/v7/p-y_ffzMdo5JN_7ia0vYEqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/orbitron/v7/PS9_6SLkY1Y6OgPO3APr6qCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/orbitron/v7/2I3-8i9hT294TE_pyjy9SaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:551;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Oregano\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/oregano/v4/UiLhqNixVv2EpjRoBG6axA.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/oregano/v4/_iwqGEht6XsAuEaCbYG64Q.ttf\";}}i:552;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Orienta\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/orienta/v4/_NKSk93mMs0xsqtfjCsB3Q.ttf\";}}i:553;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Original Surfer\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/originalsurfer/v5/gdHw6HpSIN4D6Xt7pi1-qIkEz33TDwAZczo_6fY7eg0.ttf\";}}i:554;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Oswald\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2017-02-14\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"200\";s:64:\"http://fonts.gstatic.com/s/oswald/v13/NFBt4e1rewQyDPftazXlBw.ttf\";s:3:\"300\";s:64:\"http://fonts.gstatic.com/s/oswald/v13/y3tZpCdiRD4oNRRYFcAR5Q.ttf\";s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/oswald/v13/uLEd2g2vJglLPfsBF91DCg.ttf\";s:3:\"500\";s:64:\"http://fonts.gstatic.com/s/oswald/v13/wrHWShuZ7ELtrnx0cnkzXw.ttf\";s:3:\"600\";s:64:\"http://fonts.gstatic.com/s/oswald/v13/JNlamLn5ALW8eKp46JLlQA.ttf\";s:3:\"700\";s:64:\"http://fonts.gstatic.com/s/oswald/v13/7wj8ldV_5Ti37rHa0m1DDw.ttf\";}}i:555;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Over the Rainbow\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/overtherainbow/v7/6gp-gkpI2kie2dHQQLM2jQBdxkZd83xOSx-PAQ2QmiI.ttf\";}}i:556;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Overlock\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/overlock/v5/Z8oYsGi88-E1cUB8YBFMAg.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/overlock/v5/rq6EacukHROOBrFrK_zF6_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/overlock/v5/Fexr8SqXM8Bm_gEVUA7AKaCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/overlock/v5/wFWnYgeXKYBks6gEUwYnfAJKKGfqHaYFsRG-T3ceEVo.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/overlock/v5/YPJCVTT8ZbG3899l_-KIGqCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"900italic\";s:86:\"http://fonts.gstatic.com/s/overlock/v5/iOZhxT2zlg7W5ij_lb-oDp0EAVxt0G0biEntp43Qt6E.ttf\";}}i:557;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Overlock SC\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/overlocksc/v5/8D7HYDsvS_g1GhBnlHzgzaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:558;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Overpass\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":16:{s:3:\"100\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/ywiUWFAguOSxQn0FFeOdWPesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"100italic\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/thg-CA5nD5lyYWLwXbqXXi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"200\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/WrbWRQuVnXt_EslNm2vBt6CWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"200italic\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/Eyj9nfhrJ71MmfPNEwqE02eudeTO44zf-ht3k-KNzwg.ttf\";s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/nqDUqkXaOp0r1j0uaM5VUaCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"300italic\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/R77XtXNe7WC4SXZBLWmy80eOrDcLawS7-ssYqLr2Xp4.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/overpass/v1/1fNed5evrqtu4ZjkbTnCRw.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/lG-Dpm66OH9lPHbYTnITSvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/-GUou309ST_HAHIhkHjkz6CWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"600italic\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/aPYi-s_WVz-zuU4TsgAEjvpTEJqju4Hz1txDWij77d4.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/sBTg-F6_A1NQLJPfW5I7Q6CWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/E5UsN4VY1e_Twk_bY6TpQAJKKGfqHaYFsRG-T3ceEVo.ttf\";s:3:\"800\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/YeZIq305iGwGCyZbaiEbVqCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"800italic\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/j6xjlCEDoKw-D0Co-88A9Kk3bhPBSBJ0bSJQ6acL-0g.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/4lJ8BLdIYI_B9rFwoB4zO6CWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"900italic\";s:86:\"http://fonts.gstatic.com/s/overpass/v1/SegM1mSQIRZG2pJwM_2Nm50EAVxt0G0biEntp43Qt6E.ttf\";}}i:559;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Overpass Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:90:\"http://fonts.gstatic.com/s/overpassmono/v2/JEQ6tXkANEo2u0wZ-MTOPEW1P7_iUBn_wmH5B9p-CEw.ttf\";s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/overpassmono/v2/MarHoIqW2hy_po97b_wS9uV_5zh5b-_HiooIRUBwn1A.ttf\";s:3:\"600\";s:90:\"http://fonts.gstatic.com/s/overpassmono/v2/JEQ6tXkANEo2u0wZ-MTOPCvU6mrnWf1MVbTZ5LZwmOY.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/overpassmono/v2/JEQ6tXkANEo2u0wZ-MTOPO-Cz_5MeePnXDAcLNWyBME.ttf\";}}i:560;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:3:\"Ovo\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:60:\"http://fonts.gstatic.com/s/ovo/v7/mFg27dimu3s9t09qjCwB1g.ttf\";}}i:561;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Oxygen\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:63:\"http://fonts.gstatic.com/s/oxygen/v5/lZ31r0bR1Bzt_DfGZu1S8A.ttf\";s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/oxygen/v5/uhoyAE7XlQL22abzQieHjw.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/oxygen/v5/yLqkmDwuNtt5pSqsJmhyrg.ttf\";}}i:562;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Oxygen Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/oxygenmono/v4/DigTu7k4b7OmM8ubt1Qza6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:563;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"PT Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/ptmono/v4/QUbM8H9yJK5NhpQ0REO6Wg.ttf\";}}i:564;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"PT Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/ptsans/v8/UFoEz2uiuMypUGZL1NKoeg.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/ptsans/v8/yls9EYWOd496wiu7qzfgNg.ttf\";s:3:\"700\";s:84:\"http://fonts.gstatic.com/s/ptsans/v8/F51BEgHuR0tYHxF0bD4vwvesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/ptsans/v8/lILlYDvubYemzYzN7GbLkC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:565;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"PT Sans Caption\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/ptsanscaption/v9/OXYTDOzBcXU8MTNBvBHeSW8by34Z3mUMtM-o4y-SHCY.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/ptsanscaption/v9/Q-gJrFokeE7JydPpxASt25tc0eyfI4QDEsobEEpk_hA.ttf\";}}i:566;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"PT Sans Narrow\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/ptsansnarrow/v7/UyYrYy3ltEffJV9QueSi4ZTvAuddT2xDMbdz0mdLyZY.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/ptsansnarrow/v7/Q_pTky3Sc3ubRibGToTAYsLtdzs3iyjn_YuT226ZsLU.ttf\";}}i:567;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"PT Serif\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/ptserif/v8/sAo427rn3-QL9sWCbMZXhA.ttf\";s:6:\"italic\";s:85:\"http://fonts.gstatic.com/s/ptserif/v8/9khWhKzhpkH0OkNnBKS3n_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/ptserif/v8/kyZw18tqQ5if-_wpmxxOeKCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:85:\"http://fonts.gstatic.com/s/ptserif/v8/Foydq9xJp--nfYIx2TBz9QJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:568;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"PT Serif Caption\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/ptserifcaption/v8/7xkFOeTxxO1GMC1suOUYWVsRioCqs5fohhaYel24W3k.ttf\";s:6:\"italic\";s:92:\"http://fonts.gstatic.com/s/ptserifcaption/v8/0kfPsmrmTSgiec7u_Wa0DB1mqvzPHelJwRcF_s_EUM0.ttf\";}}i:569;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Pacifico\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2017-01-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/pacifico/v9/GIrpeRY1r5CzbfL8r182lw.ttf\";}}i:570;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Padauk\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:7:\"myanmar\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2017-01-10\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/padauk/v3/WdTk6igBu-qn4v8naF9hGQ.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/padauk/v3/XUBO5k0emPIVnqCcQCcEpg.ttf\";}}i:571;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Palanquin\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"100\";s:87:\"http://fonts.gstatic.com/s/palanquin/v1/Hu0eGDVGK_g4saUFu6AK3KCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"200\";s:87:\"http://fonts.gstatic.com/s/palanquin/v1/pqXYXD7-VI5ezTjeqQOcyC3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"300\";s:87:\"http://fonts.gstatic.com/s/palanquin/v1/c0-J5OCAagpFCKkKraz-Ey3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/palanquin/v1/xCwBUoAEV0kzCDwerAZ0Aw.ttf\";s:3:\"500\";s:87:\"http://fonts.gstatic.com/s/palanquin/v1/wLvvkEcZMKy95afLWh2EfC3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"600\";s:87:\"http://fonts.gstatic.com/s/palanquin/v1/405UIAv95_yZkCECrH6y-i3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/palanquin/v1/-UtkePo3NFvxEN3rGCtTvi3USBnSvpkopQaUR-2r7iU.ttf\";}}i:572;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Palanquin Dark\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/palanquindark/v1/PamTqrrgbBh_M3702w39rOfChn3JSg5yz_Q_xmrKQN0.ttf\";s:3:\"500\";s:91:\"http://fonts.gstatic.com/s/palanquindark/v1/iXyBGf5UbFUu6BG8hOY-maMZTo-EwKMRQt3RWHocLi0.ttf\";s:3:\"600\";s:91:\"http://fonts.gstatic.com/s/palanquindark/v1/iXyBGf5UbFUu6BG8hOY-mVNxaunw8i4Gywrk2SigRnk.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/palanquindark/v1/iXyBGf5UbFUu6BG8hOY-mWToair6W0TEE44XrlfKbiM.ttf\";}}i:573;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Pangolin\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2017-02-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/pangolin/v1/i2W796ne6lveehHXs8AFGA.ttf\";}}i:574;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Paprika\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/paprika/v4/b-VpyoRSieBdB5BPJVF8HQ.ttf\";}}i:575;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Parisienne\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/parisienne/v4/TW74B5QISJNx9moxGlmJfvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:576;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Passero One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/passeroone/v8/Yc-7nH5deCCv9Ed0MMnAQqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:577;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Passion One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/passionone/v6/1UIK1tg3bKJ4J3o35M4heqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/passionone/v6/feOcYDy2R-f3Ysy72PYJ2ne1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:3:\"900\";s:88:\"http://fonts.gstatic.com/s/passionone/v6/feOcYDy2R-f3Ysy72PYJ2ienaqEuufTBk9XMKnKmgDA.ttf\";}}i:578;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Pathway Gothic One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/pathwaygothicone/v4/Lqv9ztoTUV8Q0FmQZzPqaA6A6xIYD7vYcYDop1i-K-c.ttf\";}}i:579;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Patrick Hand\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/patrickhand/v10/9BG3JJgt_HlF3NpEUehL0C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:580;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Patrick Hand SC\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/patrickhandsc/v4/OYFWCgfCR-7uHIovjUZXsbAgSRh1LpJXlLfl8IbsmHg.ttf\";}}i:581;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Pattaya\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:4:\"thai\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/pattaya/v1/sJEout1xdD7J8H-1H81pIQ.ttf\";}}i:582;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Patua One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/patuaone/v6/njZwotTYjswR4qdhsW-kJw.ttf\";}}i:583;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Pavanam\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"tamil\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/pavanam/v1/C7yuEhNK5oftNLSL3I0bGw.ttf\";}}i:584;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Paytone One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/paytoneone/v8/3WCxC7JAJjQHQVoIE0ZwvqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:585;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Peddana\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/peddana/v4/zaSZuj_GhmC8AOTugOROnA.ttf\";}}i:586;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Peralta\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/peralta/v4/cTJX5KEuc0GKRU9NXSm-8Q.ttf\";}}i:587;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Permanent Marker\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/permanentmarker/v5/9vYsg5VgPHKK8SXYbf3sMol14xj5tdg9OHF8w4E7StQ.ttf\";}}i:588;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Petit Formal Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/petitformalscript/v4/OEZwr2-ovBsq2n3ACCKoEvVPl2Gjtxj0D6F7QLy1VQc.ttf\";}}i:589;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Petrona\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/petrona/v5/nnQwxlP6dhrGovYEFtemTg.ttf\";}}i:590;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Philosopher\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:12:\"cyrillic-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-19\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/philosopher/v8/oZLTrB9jmJsyV0u_T0TKEaCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:89:\"http://fonts.gstatic.com/s/philosopher/v8/_9Hnc_gz9k7Qq6uKaeHKmUeOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/philosopher/v8/napvkewXG9Gqby5vwGHICHe1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:89:\"http://fonts.gstatic.com/s/philosopher/v8/PuKlryTcvTj7-qZWfLCFIM_zJjSACmk0BRPxQqhnNLU.ttf\";}}i:591;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Piedra\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/piedra/v5/owf-AvEEyAj9LJ2tVZ_3Mw.ttf\";}}i:592;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Pinyon Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/pinyonscript/v6/TzghnhfCn7TuE73f-CBQ0CeUSrabuTpOsMEiRLtKwk0.ttf\";}}i:593;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Pirata One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/pirataone/v4/WnbD86B4vB2ckYcL7oxuhvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:594;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Plaster\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/plaster/v8/O4QG9Z5116CXyfJdR9zxLw.ttf\";}}i:595;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Play\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/play/v7/GWvfObW8LhtsOX333MCpBg.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/play/v7/crPhg6I0alLI-MpB3vW-zw.ttf\";}}i:596;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Playball\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/playball/v6/3hOFiQm_EUzycTpcN9uz4w.ttf\";}}i:597;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Playfair Display\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/playfairdisplay/v10/2NBgzUtEeyB-Xtpr9bm1CV6uyC_qD11hrFQ6EGgTJWI.ttf\";s:6:\"italic\";s:94:\"http://fonts.gstatic.com/s/playfairdisplay/v10/9MkijrV-dEJ0-_NWV7E6NzMsbnvDNEBX25F5HWk9AhI.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/playfairdisplay/v10/UC3ZEjagJi85gF9qFaBgICsv6SrURqJprbhH_C1Mw8w.ttf\";s:9:\"700italic\";s:94:\"http://fonts.gstatic.com/s/playfairdisplay/v10/n7G4PqJvFP2Kubl0VBLDECsYW3XoOVcYyYdp9NzzS9E.ttf\";s:3:\"900\";s:94:\"http://fonts.gstatic.com/s/playfairdisplay/v10/UC3ZEjagJi85gF9qFaBgIKqwMe2wjvZrAR44M0BJZ48.ttf\";s:9:\"900italic\";s:94:\"http://fonts.gstatic.com/s/playfairdisplay/v10/n7G4PqJvFP2Kubl0VBLDEC0JfJ4xmm7j1kL6D7mPxrA.ttf\";}}i:598;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Playfair Display SC\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/playfairdisplaysc/v5/G0-tvBxd4eQRdwFKB8dRkcpjYTDWIvcAwAccqeW9uNM.ttf\";s:6:\"italic\";s:95:\"http://fonts.gstatic.com/s/playfairdisplaysc/v5/myuYiFR-4NTrUT4w6TKls2klJsJYggW8rlNoTOTuau0.ttf\";s:3:\"700\";s:95:\"http://fonts.gstatic.com/s/playfairdisplaysc/v5/5ggqGkvWJU_TtW2W8cEubA-Amcyomnuy4WsCiPxGHjw.ttf\";s:9:\"700italic\";s:95:\"http://fonts.gstatic.com/s/playfairdisplaysc/v5/6X0OQrQhEEnPo56RalREX4krgPi80XvBcbTwmz-rgmU.ttf\";s:3:\"900\";s:95:\"http://fonts.gstatic.com/s/playfairdisplaysc/v5/5ggqGkvWJU_TtW2W8cEubKXL3C32k275YmX_AcBPZ7w.ttf\";s:9:\"900italic\";s:95:\"http://fonts.gstatic.com/s/playfairdisplaysc/v5/6X0OQrQhEEnPo56RalREX8Zag2q3ssKz8uH1RU4a9gs.ttf\";}}i:599;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Podkova\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v10\";s:12:\"lastModified\";s:10:\"2017-02-09\";s:5:\"files\";O:8:\"stdClass\":5:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/podkova/v10/eylljyGVfB8ZUQjYY3WZRQ.ttf\";s:3:\"500\";s:86:\"http://fonts.gstatic.com/s/podkova/v10/8MkhKmKhl0HgqBeKkV0pmvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:86:\"http://fonts.gstatic.com/s/podkova/v10/921xSzgq6uUBjPZXn2IH0PesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/podkova/v10/SqW4aa8m_KVrOgYSydQ33vesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"800\";s:86:\"http://fonts.gstatic.com/s/podkova/v10/ObfRYfRr58NtktZuAa1VhfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:600;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Poiret One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/poiretone/v4/dWcYed048E5gHGDIt8i1CPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:601;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Poller One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/pollerone/v6/dkctmDlTPcZ6boC8662RA_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:602;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Poly\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/poly/v7/bcMAuiacS2qkd54BcwW6_Q.ttf\";s:6:\"italic\";s:61:\"http://fonts.gstatic.com/s/poly/v7/Zkx-eIlZSjKUrPGYhV5PeA.ttf\";}}i:603;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Pompiere\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/pompiere/v6/o_va2p9CD5JfmFohAkGZIA.ttf\";}}i:604;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Pontano Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/pontanosans/v4/gTHiwyxi6S7iiHpqAoiE3C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:605;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Poppins\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:85:\"http://fonts.gstatic.com/s/poppins/v1/VIeViZ2fPtYBt3B2fQZplvesZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/poppins/v1/hlvAxH6aIdOjWlLzgm0jqg.ttf\";s:3:\"500\";s:85:\"http://fonts.gstatic.com/s/poppins/v1/4WGKlFyjcmCFVl8pRsgZ9vesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:85:\"http://fonts.gstatic.com/s/poppins/v1/-zOABrCWORC3lyDh-ajNnPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/poppins/v1/8JitanEsk5aDh7mDYs-fYfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:606;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Port Lligat Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/portlligatsans/v5/CUEdhRk7oC7up0p6t0g4P6mASEpx5X0ZpsuJOuvfOGA.ttf\";}}i:607;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Port Lligat Slab\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/portlligatslab/v5/CUEdhRk7oC7up0p6t0g4PxLSPACXvawUYCBEnHsOe30.ttf\";}}i:608;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Pragati Narrow\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/pragatinarrow/v2/HzG2TfC862qPNsZsV_djPpTvAuddT2xDMbdz0mdLyZY.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/pragatinarrow/v2/DnSI1zRkc0CY-hI5SC3q3MLtdzs3iyjn_YuT226ZsLU.ttf\";}}i:609;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Prata\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:12:\"cyrillic-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2017-01-19\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/prata/v7/3gmx8r842loRRm9iQkCDGg.ttf\";}}i:610;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Preahvihear\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/preahvihear/v8/82tDI-xTc53CxxOzEG4hDaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:611;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Press Start 2P\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";i:3;s:9:\"latin-ext\";i:4;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2017-01-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/pressstart2p/v5/8Lg6LX8-ntOHUQnvQ0E7o1jfl3W46Sz5gOkEVhcFWF4.ttf\";}}i:612;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Pridi\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"200\";s:62:\"http://fonts.gstatic.com/s/pridi/v1/WvKJ-kflGuELyK4uQzpYIA.ttf\";s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/pridi/v1/Ihwk-OGVFS69PINILdqAjQ.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/pridi/v1/Mau018Ghi7LJX7FkGYCZAQ.ttf\";s:3:\"500\";s:62:\"http://fonts.gstatic.com/s/pridi/v1/dPNOrMxU-HjLo-fvkFydsQ.ttf\";s:3:\"600\";s:62:\"http://fonts.gstatic.com/s/pridi/v1/J0i5OZxX07KC4mby5RjNbg.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/pridi/v1/UhCy4jDDJttTB8k8rtWadg.ttf\";}}i:613;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Princess Sofia\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/princesssofia/v4/8g5l8r9BM0t1QsXLTajDe-wjmA7ie-lFcByzHGRhCIg.ttf\";}}i:614;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Prociono\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2017-02-09\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/prociono/v6/43ZYDHWogdFeNBWTl6ksmw.ttf\";}}i:615;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Prompt\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:63:\"http://fonts.gstatic.com/s/prompt/v1/ltjX-trOmfS-yKy_awt70g.ttf\";s:9:\"100italic\";s:84:\"http://fonts.gstatic.com/s/prompt/v1/KvTeArBpVb-tA2mahV6Jk_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"200\";s:63:\"http://fonts.gstatic.com/s/prompt/v1/MNB_CVkbfYHFMWX_UbDC2Q.ttf\";s:9:\"200italic\";s:84:\"http://fonts.gstatic.com/s/prompt/v1/NR0JuXzzCDKpLNVhfyEAiaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"300\";s:63:\"http://fonts.gstatic.com/s/prompt/v1/LzifakiWysr3N3OoAdbdpg.ttf\";s:9:\"300italic\";s:84:\"http://fonts.gstatic.com/s/prompt/v1/ir8BhbeDHM-qnbo-tnpmt6CWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/prompt/v1/nDo1rQFnTFNua4cp-OnD2A.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/prompt/v1/ZD4khIP924SU2fRYOJkraQ.ttf\";s:3:\"500\";s:63:\"http://fonts.gstatic.com/s/prompt/v1/w31OY1otplAgr5iZ21K7Fg.ttf\";s:9:\"500italic\";s:84:\"http://fonts.gstatic.com/s/prompt/v1/dfaeaRx00u9arVHsaDjliaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"600\";s:63:\"http://fonts.gstatic.com/s/prompt/v1/uUrJjg1BGaIb6CAOlUIp9g.ttf\";s:9:\"600italic\";s:84:\"http://fonts.gstatic.com/s/prompt/v1/CJUBMsoNNHMMdFRxm-n7p6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/prompt/v1/HdM_epiStzshOr-49ubVyg.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/prompt/v1/GtXRH7QWy3aLCHoJuR5WIKCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"800\";s:63:\"http://fonts.gstatic.com/s/prompt/v1/GF9cOamDd7mYPHNW1nZLKg.ttf\";s:9:\"800italic\";s:84:\"http://fonts.gstatic.com/s/prompt/v1/kBLgnnEB-VXkOLFCc0pzwqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"900\";s:63:\"http://fonts.gstatic.com/s/prompt/v1/KFgmbwHbRBQb28VFhH3c8Q.ttf\";s:9:\"900italic\";s:84:\"http://fonts.gstatic.com/s/prompt/v1/qjrOe-lEPwDDeUu5g6q_DaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:616;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Prosto One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/prostoone/v5/bsqnAElAqk9kX7eABTRFJPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:617;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Proza Libre\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:10:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":10:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/prozalibre/v1/Hg11OrfE1P_U6mKmrZPknKCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:88:\"http://fonts.gstatic.com/s/prozalibre/v1/ClQTew5IUT7yKo8vyspLxEeOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"500\";s:88:\"http://fonts.gstatic.com/s/prozalibre/v1/4gjxWDPA6RMWrIls_qgQBsCNfqCYlB_eIx7H1TVXe60.ttf\";s:9:\"500italic\";s:88:\"http://fonts.gstatic.com/s/prozalibre/v1/rWq3Qp4ZlPGKduc1qkgLHGnWRcJAYo5PSCx8UfGMHCI.ttf\";s:3:\"600\";s:88:\"http://fonts.gstatic.com/s/prozalibre/v1/4gjxWDPA6RMWrIls_qgQBpZ7xm-Bj30Bj2KNdXDzSZg.ttf\";s:9:\"600italic\";s:88:\"http://fonts.gstatic.com/s/prozalibre/v1/rWq3Qp4ZlPGKduc1qkgLHJe6We3S5L6hKLscKpOkmlo.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/prozalibre/v1/4gjxWDPA6RMWrIls_qgQBne1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:88:\"http://fonts.gstatic.com/s/prozalibre/v1/rWq3Qp4ZlPGKduc1qkgLHM_zJjSACmk0BRPxQqhnNLU.ttf\";s:3:\"800\";s:88:\"http://fonts.gstatic.com/s/prozalibre/v1/4gjxWDPA6RMWrIls_qgQBg89PwPrYLaRFJ-HNCU9NbA.ttf\";s:9:\"800italic\";s:88:\"http://fonts.gstatic.com/s/prozalibre/v1/rWq3Qp4ZlPGKduc1qkgLHCad_7rtf4IdDfsLVg-2OV4.ttf\";}}i:618;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Puritan\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/puritan/v8/wv_RtgVBSCn-or2MC0n4Kg.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/puritan/v8/BqZX8Tp200LeMv1KlzXgLQ.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/puritan/v8/pJS2SdwI0SCiVnO0iQSFT_esZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:85:\"http://fonts.gstatic.com/s/puritan/v8/rFG3XkMJL75nUNZwCEIJqC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:619;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Purple Purse\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/purplepurse/v5/Q5heFUrdmei9axbMITxxxS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:620;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Quando\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/quando/v5/03nDiEZuO2-h3xvtG6UmHg.ttf\";}}i:621;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Quantico\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/quantico/v5/pwSnP8Xpaix2rIz99HrSlQ.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/quantico/v5/KQhDd2OsZi6HiITUeFQ2U_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/quantico/v5/OVZZzjcZ3Hkq2ojVcUtDjaCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/quantico/v5/HeCYRcZbdRso3ZUu01ELbQJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:622;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Quattrocento\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/quattrocento/v8/WZDISdyil4HsmirlOdBRFC3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/quattrocento/v8/Uvi-cRwyvqFpl9j3oT2mqkD2ttfZwueP-QU272T9-k4.ttf\";}}i:623;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Quattrocento Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/quattrocentosans/v9/efd6FGWWGX5Z3ztwLBrG9eAj_ty82iuwwDTNEYXGiyQ.ttf\";s:6:\"italic\";s:94:\"http://fonts.gstatic.com/s/quattrocentosans/v9/8PXYbvM__bjl0rBnKiByg532VBCoA_HLsn85tSWZmdo.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/quattrocentosans/v9/tXSgPxDl7Lk8Zr_5qX8FIbqxG25nQNOioCZSK4sU-CA.ttf\";s:9:\"700italic\";s:94:\"http://fonts.gstatic.com/s/quattrocentosans/v9/8N1PdXpbG6RtFvTjl-5E7buqAJxizi8Dk_SK5et7kMg.ttf\";}}i:624;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Questrial\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/questrial/v6/MoHHaw_WwNs_hd9ob1zTVw.ttf\";}}i:625;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Quicksand\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:87:\"http://fonts.gstatic.com/s/quicksand/v6/qhfoJiLu10kFjChCCTvGlC3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/quicksand/v6/Ngv3fIJjKB7sD-bTUGIFCA.ttf\";s:3:\"500\";s:87:\"http://fonts.gstatic.com/s/quicksand/v6/FRGja7LlrG1Mypm0hCq0Di3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/quicksand/v6/32nyIRHyCu6iqEka_hbKsi3USBnSvpkopQaUR-2r7iU.ttf\";}}i:626;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Quintessential\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/quintessential/v4/mmk6ioesnTrEky_Zb92E5s02lXbtMOtZWfuxKeMZO8Q.ttf\";}}i:627;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Qwigley\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/qwigley/v6/aDqxws-KubFID85TZHFouw.ttf\";}}i:628;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Racing Sans One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/racingsansone/v4/1r3DpWaCiT7y3PD4KgkNyDjVlsJB_M_Q_LtZxsoxvlw.ttf\";}}i:629;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Radley\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/radley/v9/FgE9di09a-mXGzAIyI6Q9Q.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/radley/v9/Z_JcACuPAOO2f9kzQcGRug.ttf\";}}i:630;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Rajdhani\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/rajdhani/v5/9pItuEhQZVGdq8spnHTku6CWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/rajdhani/v5/Wfy5zp4PGFAFS7-Wetehzw.ttf\";s:3:\"500\";s:86:\"http://fonts.gstatic.com/s/rajdhani/v5/nd_5ZpVwm710HcLual0fBqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"600\";s:86:\"http://fonts.gstatic.com/s/rajdhani/v5/5fnmZahByDeTtgxIiqbJSaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/rajdhani/v5/UBK6d2Hg7X7wYLlF92aXW6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:631;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Rakkas\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/rakkas/v1/XWSZpoSbAR4myQgKbSJM9A.ttf\";}}i:632;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Raleway\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:65:\"http://fonts.gstatic.com/s/raleway/v11/UDfD6oxBaBnmFJwQ7XAFNw.ttf\";s:9:\"100italic\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/hUpHtml6IPNuUR-FwVi2UKCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"200\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/LAQwev4hdCtYkOYX4Oc7nPesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"200italic\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/N2DIbZG4399cPGfifZUEQi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/2VvSZU2kb4DZwFfRM4fLQPesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"300italic\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/TVSB8ogXDKMcnAAJ5CqrUi3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/raleway/v11/_dCzxpXzIS3sL-gdJWAP8A.ttf\";s:6:\"italic\";s:65:\"http://fonts.gstatic.com/s/raleway/v11/utU2m1gdZSfuQpArSy5Dbw.ttf\";s:3:\"500\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/348gn6PEmbLDWlHbbV15d_esZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"500italic\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/S7vGLZZ40c85SJgiptJGVy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"600\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/M7no6oPkwKYJkedjB1wqEvesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"600italic\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/OY22yoG8EJ3IN_muVWm29C3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/VGEV9-DrblisWOWLbK-1XPesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/lFxvRPuGFG5ktd7P0WRwKi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"800\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/mMh0JrsYMXcLO69jgJwpUvesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"800italic\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/us4LjTCmlYgh3W8CKujEJi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/ajQQGcDBLcyLpaUfD76UuPesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"900italic\";s:86:\"http://fonts.gstatic.com/s/raleway/v11/oY2RadnkHfshu5f0FLsgVS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:633;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Raleway Dots\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/ralewaydots/v4/lhLgmWCRcyz-QXo8LCzTfC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:634;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Ramabhadra\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/ramabhadra/v5/JyhxLXRVQChLDGADS_c5MPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:635;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Ramaraja\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/ramaraja/v1/XIqzxFapVczstBedHdQTiw.ttf\";}}i:636;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Rambla\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/rambla/v4/YaTmpvm5gFg_ShJKTQmdzg.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/rambla/v4/mhUgsKmp0qw3uATdDDAuwA.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/rambla/v4/C5VZH8BxQKmnBuoC00UPpw.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/rambla/v4/ziMzUZya6QahrKONSI1TzqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:637;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Rammetto One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/rammettoone/v5/mh0uQ1tV8QgSx9v_KyEYPC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:638;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Ranchers\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/ranchers/v4/9ya8CZYhqT66VERfjQ7eLA.ttf\";}}i:639;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Rancho\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/rancho/v6/ekp3-4QykC4--6KaslRgHA.ttf\";}}i:640;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Ranga\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/ranga/v1/xpW6zFTNzY1JykoBIqE1Zg.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/ranga/v1/h8G_gEUH7vHKH-NkjAs34A.ttf\";}}i:641;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Rasa\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:61:\"http://fonts.gstatic.com/s/rasa/v1/XQ1gDq2EqBtGcdadPyPbww.ttf\";s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/rasa/v1/A5PoJUwX_PxTsywxlRB79g.ttf\";s:3:\"500\";s:61:\"http://fonts.gstatic.com/s/rasa/v1/HfsDi_Ls3NARO_YEODINGg.ttf\";s:3:\"600\";s:61:\"http://fonts.gstatic.com/s/rasa/v1/f-fvbq-hWIQCdmT3QHGk3Q.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/rasa/v1/TSF3CG-8Cn72jvaVdqtMMQ.ttf\";}}i:642;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Rationale\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/rationale/v7/7M2eN-di0NGLQse7HzJRfg.ttf\";}}i:643;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Ravi Prakash\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/raviprakash/v3/8EzbM7Rymjk25jWeHxbO6C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:644;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Redressed\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/redressed/v6/3aZ5sTBppH3oSm5SabegtA.ttf\";}}i:645;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Reem Kufi\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-08-22\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/reemkufi/v1/xLwMbK_T1g-h9p-rp60A1Q.ttf\";}}i:646;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Reenie Beanie\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/reeniebeanie/v7/ljpKc6CdXusL1cnGUSamX4jjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:647;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Revalia\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/revalia/v4/1TKw66fF5_poiL0Ktgo4_A.ttf\";}}i:648;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Rhodium Libre\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/rhodiumlibre/v1/Vxr7A4-xE2zsBDDI8BcseIjjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:649;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Ribeye\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/ribeye/v5/e5w3VE8HnWBln4Ll6lUj3Q.ttf\";}}i:650;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Ribeye Marrow\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/ribeyemarrow/v6/q7cBSA-4ErAXBCDFPrhlY0cTNmV93fYG7UKgsLQNQWs.ttf\";}}i:651;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Righteous\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/righteous/v5/0nRRWM_gCGCt2S-BCfN8WQ.ttf\";}}i:652;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Risque\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/risque/v4/92RnElGnl8yHP97-KV3Fyg.ttf\";}}i:653;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Roboto\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:12:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v15\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":12:{s:3:\"100\";s:64:\"http://fonts.gstatic.com/s/roboto/v15/7MygqTe2zs9YkP0adA9QQQ.ttf\";s:9:\"100italic\";s:85:\"http://fonts.gstatic.com/s/roboto/v15/T1xnudodhcgwXCmZQ490TPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"300\";s:64:\"http://fonts.gstatic.com/s/roboto/v15/dtpHsbgPEm2lVWciJZ0P-A.ttf\";s:9:\"300italic\";s:85:\"http://fonts.gstatic.com/s/roboto/v15/iE8HhaRzdhPxC93dOdA056CWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/roboto/v15/W5F8_SL0XFawnjxHGsZjJA.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/roboto/v15/hcKoSgxdnKlbH5dlTwKbow.ttf\";s:3:\"500\";s:64:\"http://fonts.gstatic.com/s/roboto/v15/Uxzkqj-MIMWle-XP2pDNAA.ttf\";s:9:\"500italic\";s:85:\"http://fonts.gstatic.com/s/roboto/v15/daIfzbEw-lbjMyv4rMUUTqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:64:\"http://fonts.gstatic.com/s/roboto/v15/bdHGHleUa-ndQCOrdpfxfw.ttf\";s:9:\"700italic\";s:85:\"http://fonts.gstatic.com/s/roboto/v15/owYYXKukxFDFjr0ZO8NXh6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"900\";s:64:\"http://fonts.gstatic.com/s/roboto/v15/H1vB34nOKWXqzKotq25pcg.ttf\";s:9:\"900italic\";s:85:\"http://fonts.gstatic.com/s/roboto/v15/b9PWBSMHrT2zM5FgUdtu0aCWcynf_cDxXwCLxiixG1c.ttf\";}}i:654;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Roboto Condensed\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v13\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"300\";s:94:\"http://fonts.gstatic.com/s/robotocondensed/v13/b9QBgL0iMZfDSpmcXcE8nJRhFVcex_hajThhFkHyhYk.ttf\";s:9:\"300italic\";s:94:\"http://fonts.gstatic.com/s/robotocondensed/v13/mg0cGfGRUERshzBlvqxeAPYa9bgCHecWXGgisnodcS0.ttf\";s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/robotocondensed/v13/Zd2E9abXLFGSr9G3YK2MsKDbm6fPDOZJsR8PmdG62gY.ttf\";s:6:\"italic\";s:94:\"http://fonts.gstatic.com/s/robotocondensed/v13/BP5K8ZAJv9qEbmuFp8RpJY_eiqgTfYGaH0bJiUDZ5GA.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/robotocondensed/v13/b9QBgL0iMZfDSpmcXcE8nPOYkGiSOYDq_T7HbIOV1hA.ttf\";s:9:\"700italic\";s:94:\"http://fonts.gstatic.com/s/robotocondensed/v13/mg0cGfGRUERshzBlvqxeAE2zk2RGRC3SlyyLLQfjS_8.ttf\";}}i:655;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Roboto Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"100\";s:88:\"http://fonts.gstatic.com/s/robotomono/v4/aOIeRp72J9_Hp_8KwQ9M-YAWxXGWZ3yJw6KhWS7MxOk.ttf\";s:9:\"100italic\";s:88:\"http://fonts.gstatic.com/s/robotomono/v4/rqQ1zSE-ZGCKVZgew-A9dgyDtfpXZi-8rXUZYR4dumU.ttf\";s:3:\"300\";s:88:\"http://fonts.gstatic.com/s/robotomono/v4/N4duVc9C58uwPiY8_59Fzy9-WlPSxbfiI49GsXo3q0g.ttf\";s:9:\"300italic\";s:88:\"http://fonts.gstatic.com/s/robotomono/v4/1OsMuiiO6FCF2x67vzDKA2o9eWDfYYxG3A176Zl7aIg.ttf\";s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/robotomono/v4/eJ4cxQe85Lo39t-LVoKa26CWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:88:\"http://fonts.gstatic.com/s/robotomono/v4/mE0EPT_93c7f86_WQexR3EeOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"500\";s:88:\"http://fonts.gstatic.com/s/robotomono/v4/N4duVc9C58uwPiY8_59Fz8CNfqCYlB_eIx7H1TVXe60.ttf\";s:9:\"500italic\";s:88:\"http://fonts.gstatic.com/s/robotomono/v4/1OsMuiiO6FCF2x67vzDKA2nWRcJAYo5PSCx8UfGMHCI.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/robotomono/v4/N4duVc9C58uwPiY8_59Fz3e1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:88:\"http://fonts.gstatic.com/s/robotomono/v4/1OsMuiiO6FCF2x67vzDKA8_zJjSACmk0BRPxQqhnNLU.ttf\";}}i:656;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Roboto Slab\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"700\";}s:7:\"subsets\";a:7:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"100\";s:88:\"http://fonts.gstatic.com/s/robotoslab/v6/MEz38VLIFL-t46JUtkIEgIAWxXGWZ3yJw6KhWS7MxOk.ttf\";s:3:\"300\";s:88:\"http://fonts.gstatic.com/s/robotoslab/v6/dazS1PrQQuCxC3iOAJFEJS9-WlPSxbfiI49GsXo3q0g.ttf\";s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/robotoslab/v6/3__ulTNA7unv0UtplybPiqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/robotoslab/v6/dazS1PrQQuCxC3iOAJFEJXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:657;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Rochester\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/rochester/v6/bnj8tmQBiOkdji_G_yvypg.ttf\";}}i:658;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Rock Salt\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/rocksalt/v6/Zy7JF9h9WbhD9V3SFMQ1UQ.ttf\";}}i:659;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Rokkitt\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2017-02-09\";s:5:\"files\";O:8:\"stdClass\":9:{s:3:\"100\";s:65:\"http://fonts.gstatic.com/s/rokkitt/v11/_3YC6rPA1FdHK3T5HJAiKA.ttf\";s:3:\"200\";s:86:\"http://fonts.gstatic.com/s/rokkitt/v11/YawjzRx4kAyF2FdhIXfg1_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/rokkitt/v11/Cw0HfZi5axnl2GTVcAe4x_esZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/rokkitt/v11/GMA7Z_ToF8uSvpZAgnp_VQ.ttf\";s:3:\"500\";s:86:\"http://fonts.gstatic.com/s/rokkitt/v11/jSxUaZL9JCo117IMemf-iPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:86:\"http://fonts.gstatic.com/s/rokkitt/v11/b4_SvUo9hy0bV60RoA1RKPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/rokkitt/v11/gxlo-sr3rPmvgSixYog_ofesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"800\";s:86:\"http://fonts.gstatic.com/s/rokkitt/v11/mCok2W9ZHFgB-LY6ITuapfesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/rokkitt/v11/riY221k9xwvseUAhNXMjQPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:660;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Romanesco\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/romanesco/v5/2udIjUrpK_CPzYSxRVzD4Q.ttf\";}}i:661;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Ropa Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/ropasans/v6/Gba7ZzVBuhg6nX_AoSwlkQ.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/ropasans/v6/V1zbhZQscNrh63dy5Jk2nqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:662;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Rosario\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/rosario/v11/bL-cEh8dXtDupB2WccA2LA.ttf\";s:6:\"italic\";s:65:\"http://fonts.gstatic.com/s/rosario/v11/pkflNy18HEuVVx4EOjeb_Q.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/rosario/v11/nrS6PJvDWN42RP4TFWccd_esZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/rosario/v11/EOgFX2Va5VGrkhn_eDpIRS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:663;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Rosarivo\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/rosarivo/v4/EmPiINK0qyqc7KSsNjJamA.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/rosarivo/v4/u3VuWsWQlX1pDqsbz4paNPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:664;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Rouge Script\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/rougescript/v5/AgXDSqZJmy12qS0ixjs6Vy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:665;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Rozha One\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/rozhaone/v2/PyrMHQ6lucEIxwKmhqsX8A.ttf\";}}i:666;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Rubik\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:6:\"hebrew\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2017-01-20\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/rubik/v4/o1vXYO8YwDpErHEAPAxpOg.ttf\";s:9:\"300italic\";s:83:\"http://fonts.gstatic.com/s/rubik/v4/NyXDvUhvZLSWiVfGa5KM-vesZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/rubik/v4/4sMyW_teKWHB3K8Hm-Il6A.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/rubik/v4/elD65ddI0qvNcCh42b1Iqg.ttf\";s:3:\"500\";s:62:\"http://fonts.gstatic.com/s/rubik/v4/D4HihERG27s-BJrQ4dvkbw.ttf\";s:9:\"500italic\";s:83:\"http://fonts.gstatic.com/s/rubik/v4/0hcxMdoMbXtHiEM1ebdN6PesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/rubik/v4/m1GGHcpLe6Mb0_sAyjXE4g.ttf\";s:9:\"700italic\";s:83:\"http://fonts.gstatic.com/s/rubik/v4/R4g_rs714cUXVZcdnRdHw_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"900\";s:62:\"http://fonts.gstatic.com/s/rubik/v4/mOHfPRl5uP4vw7-5-dbnng.ttf\";s:9:\"900italic\";s:83:\"http://fonts.gstatic.com/s/rubik/v4/HH1b7kBbwInqlw8OQxRE5vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:667;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Rubik Mono One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/rubikmonoone/v5/e_cupPtD4BrZzotubJD7UbAREgn5xbW23GEXXnhMQ5Y.ttf\";}}i:668;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Ruda\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/ruda/v7/jPEIPB7DM2DNK_uBGv2HGw.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/ruda/v7/JABOu1SYOHcGXVejUq4w6g.ttf\";s:3:\"900\";s:61:\"http://fonts.gstatic.com/s/ruda/v7/Uzusv-enCjoIrznlJJaBRw.ttf\";}}i:669;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Rufina\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/rufina/v4/s9IFr_fIemiohfZS-ZRDbQ.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/rufina/v4/D0RUjXFr55y4MVZY2Ww_RA.ttf\";}}i:670;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Ruge Boogie\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/rugeboogie/v7/U-TTmltL8aENLVIqYbI5QaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:671;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Ruluko\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/ruluko/v4/lv4cMwJtrx_dzmlK5SDc1g.ttf\";}}i:672;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Rum Raisin\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/rumraisin/v4/kDiL-ntDOEq26B7kYM7cx_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:673;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Ruslan Display\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/ruslandisplay/v7/SREdhlyLNUfU1VssRBfs3rgH88D3l9N4auRNHrNS708.ttf\";}}i:674;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Russo One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/russoone/v5/zfwxZ--UhUc7FVfgT21PRQ.ttf\";}}i:675;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Ruthie\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/ruthie/v6/vJ2LorukHSbWYoEs5juivg.ttf\";}}i:676;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:3:\"Rye\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:60:\"http://fonts.gstatic.com/s/rye/v4/VUrJlpPpSZxspl3w_yNOrQ.ttf\";}}i:677;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Sacramento\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/sacramento/v4/_kv-qycSHMNdhjiv0Kj7BvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:678;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Sahitya\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/sahitya/v1/wQWULcDbZqljdTfjOUtDvw.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/sahitya/v1/Zm5hNvMwUyN3tC4GMkH1l_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:679;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Sail\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/sail/v7/iuEoG6kt-bePGvtdpL0GUQ.ttf\";}}i:680;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Salsa\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/salsa/v6/BnpUCBmYdvggScEPs5JbpA.ttf\";}}i:681;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Sanchez\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/sanchez/v4/BEL8ao-E2LJ5eHPLB2UAiw.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/sanchez/v4/iSrhkWLexUZzDeNxNEHtzA.ttf\";}}i:682;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Sancreek\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/sancreek/v7/8ZacBMraWMvHly4IJI3esw.ttf\";}}i:683;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Sansita\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"800\";i:5;s:9:\"800italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2017-01-26\";s:5:\"files\";O:8:\"stdClass\":8:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/sansita/v1/ey9oYobmakEwtEciY0G5Mg.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/sansita/v1/UkWzQlyaYvMqX8-kX9fI1A.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/sansita/v1/q9hPUXq37zR3BVunMJi2HfesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:85:\"http://fonts.gstatic.com/s/sansita/v1/Izkki8H_L5Nxxk6vpKrxXS3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"800\";s:85:\"http://fonts.gstatic.com/s/sansita/v1/vOIsA3n-LuVE_PeoZ3aSFfesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"800italic\";s:85:\"http://fonts.gstatic.com/s/sansita/v1/4OvihNMj_b3nyu4KlgNNVS3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"900\";s:85:\"http://fonts.gstatic.com/s/sansita/v1/lwgTmJASMyrLsXnTfRSt7fesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"900italic\";s:85:\"http://fonts.gstatic.com/s/sansita/v1/JTPHz0Wyy3AImmVqi8CQTy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:684;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Sarala\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/sarala/v1/ohip9lixCHoBab7hTtgLnw.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/sarala/v1/hpc9cz8KYsazwq2In_oJYw.ttf\";}}i:685;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Sarina\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/sarina/v5/XYtRfaSknHIU3NHdfTdXoQ.ttf\";}}i:686;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Sarpanch\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/sarpanch/v1/YMBZdT27b6O5a1DADbAGSg.ttf\";s:3:\"500\";s:86:\"http://fonts.gstatic.com/s/sarpanch/v1/Ov7BxSrFSZYrfuJxL1LzQaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"600\";s:86:\"http://fonts.gstatic.com/s/sarpanch/v1/WTnP2wnc0qSbUaaDG-2OQ6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/sarpanch/v1/57kYsSpovYmFaEt2hsZhv6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"800\";s:86:\"http://fonts.gstatic.com/s/sarpanch/v1/OKyqPLjdnuVghR-1TV6RzaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/sarpanch/v1/JhYc2cr6kqWTo_P0vfvJR6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:687;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Satisfy\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/satisfy/v6/PRlyepkd-JCGHiN8e9WV2w.ttf\";}}i:688;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Scada\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2017-01-20\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/scada/v5/iZNC3ZEYwe3je6H-28d5Ug.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/scada/v5/PCGyLT1qNawkOUQ3uHFhBw.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/scada/v5/t6XNWdMdVWUz93EuRVmifQ.ttf\";s:9:\"700italic\";s:83:\"http://fonts.gstatic.com/s/scada/v5/kLrBIf7V4mDMwcd_Yw7-D_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:689;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Scheherazade\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:6:\"arabic\";}s:7:\"version\";s:3:\"v12\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/scheherazade/v12/AuKlqGWzUC-8XqMOmsqXiy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/scheherazade/v12/C1wtT46acJkQxc6mPHwvHED2ttfZwueP-QU272T9-k4.ttf\";}}i:690;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Schoolbell\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/schoolbell/v6/95-3djEuubb3cJx-6E7j4vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:691;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Scope One\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/scopeone/v2/ge7dY8Yht-n7_1cLHtoT3w.ttf\";}}i:692;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Seaweed Script\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/seaweedscript/v4/eorWAPpOvvWrPw5IHwE60BnpV0hQCek3EmWnCPrvGRM.ttf\";}}i:693;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Secular One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:6:\"hebrew\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/secularone/v1/yW9qikjpt_X0fh5oQJcdo6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:694;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Sevillana\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/sevillana/v4/6m1Nh35oP7YEt00U80Smiw.ttf\";}}i:695;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Seymour One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/seymourone/v4/HrdG2AEG_870Xb7xBVv6C6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:696;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Shadows Into Light\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/shadowsintolight/v6/clhLqOv7MXn459PTh0gXYAW_5bEze-iLRNvGrRpJsfM.ttf\";}}i:697;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:22:\"Shadows Into Light Two\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:97:\"http://fonts.gstatic.com/s/shadowsintolighttwo/v4/gDxHeefcXIo-lOuZFCn2xVQrZk-Pga5KeEE_oZjkQjQ.ttf\";}}i:698;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Shanti\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/shanti/v8/lc4nG_JG6Q-2FQSOMMhb_w.ttf\";}}i:699;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Share\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/share/v6/1ytD7zSb_-g9I2GG67vmVw.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/share/v6/a9YGdQWFRlNJ0zClJVaY3Q.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/share/v6/XrU8e7a1YKurguyY2azk1Q.ttf\";s:9:\"700italic\";s:83:\"http://fonts.gstatic.com/s/share/v6/A992-bLVYwAflKu6iaznufesZW2xOQ-xsNqO47m55DA.ttf\";}}i:700;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Share Tech\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/sharetech/v6/Dq3DuZ5_0SW3oEfAWFpen_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:701;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Share Tech Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/sharetechmono/v6/RQxK-3RA0Lnf3gnnnNrAscwD6PD0c3_abh9zHKQtbGU.ttf\";}}i:702;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Shojumaru\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/shojumaru/v4/WP8cxonzQQVAoI3RJQ2wug.ttf\";}}i:703;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Short Stack\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/shortstack/v6/v4dXPI0Rm8XN9gk4SDdqlqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:704;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Shrikhand\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"gujarati\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/shrikhand/v1/45jwHiwIDTWCy3Ir85vvKA.ttf\";}}i:705;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Siemreap\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/siemreap/v9/JSK-mOIsXwxo-zE9XDDl_g.ttf\";}}i:706;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Sigmar One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/sigmarone/v7/oh_5NxD5JBZksdo2EntKefesZW2xOQ-xsNqO47m55DA.ttf\";}}i:707;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Signika\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:85:\"http://fonts.gstatic.com/s/signika/v6/0wDPonOzsYeEo-1KO78w4fesZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/signika/v6/WvDswbww0oAtvBg2l1L-9w.ttf\";s:3:\"600\";s:85:\"http://fonts.gstatic.com/s/signika/v6/lQMOF6NUN2ooR7WvB7tADvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/signika/v6/lEcnfPBICWJPv5BbVNnFJPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:708;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Signika Negative\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:93:\"http://fonts.gstatic.com/s/signikanegative/v5/q5TOjIw4CenPw6C-TW06FjYFXpUPtCmIEFDvjUnLLaI.ttf\";s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/signikanegative/v5/Z-Q1hzbY8uAo3TpTyPFMXVM1lnCWMnren5_v6047e5A.ttf\";s:3:\"600\";s:93:\"http://fonts.gstatic.com/s/signikanegative/v5/q5TOjIw4CenPw6C-TW06FrKLaDJM01OezSVA2R_O3qI.ttf\";s:3:\"700\";s:93:\"http://fonts.gstatic.com/s/signikanegative/v5/q5TOjIw4CenPw6C-TW06FpYzPxtVvobH1w3hEppR8WI.ttf\";}}i:709;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Simonetta\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"900\";i:3;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/simonetta/v5/fN8puNuahBo4EYMQgp12Yg.ttf\";s:6:\"italic\";s:87:\"http://fonts.gstatic.com/s/simonetta/v5/ynxQ3FqfF_Nziwy3T9ZwL6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"900\";s:87:\"http://fonts.gstatic.com/s/simonetta/v5/22EwvvJ2r1VwVCxit5LcVi3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"900italic\";s:87:\"http://fonts.gstatic.com/s/simonetta/v5/WUXOpCgBZaRPrWtMCpeKoienaqEuufTBk9XMKnKmgDA.ttf\";}}i:710;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Sintony\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/sintony/v4/IDhCijoIMev2L6Lg5QsduQ.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/sintony/v4/zVXQB1wqJn6PE4dWXoYpvPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:711;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Sirin Stencil\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/sirinstencil/v5/pRpLdo0SawzO7MoBpvowsImg74kgS1F7KeR8rWhYwkU.ttf\";}}i:712;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Six Caps\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/sixcaps/v7/_XeDnO0HOV8Er9u97If1tQ.ttf\";}}i:713;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Skranji\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/skranji/v4/jnOLPS0iZmDL7dfWnW3nIw.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/skranji/v4/Lcrhg-fviVkxiEgoadsI1vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:714;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Slabo 13px\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/slabo13px/v3/jPGWFTjRXfCSzy0qd1nqdvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:715;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Slabo 27px\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/slabo27px/v3/gC0o8B9eU21EafNkXlRAfPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:716;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Slackey\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/slackey/v6/evRIMNhGVCRJvCPv4kteeA.ttf\";}}i:717;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Smokum\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/smokum/v6/8YP4BuAcy97X8WfdKfxVRw.ttf\";}}i:718;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Smythe\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/smythe/v7/yACD1gy_MpbB9Ft42fUvYw.ttf\";}}i:719;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Sniglet\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/sniglet/v8/XWhyQLHH4SpCVsHRPRgu9w.ttf\";s:3:\"800\";s:85:\"http://fonts.gstatic.com/s/sniglet/v8/NLF91nBmcEfkBgcEWbHFa_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:720;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Snippet\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/snippet/v6/eUcYMLq2GtHZovLlQH_9kA.ttf\";}}i:721;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Snowburst One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/snowburstone/v4/zSQzKOPukXRux2oTqfYJjIjjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:722;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Sofadi One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/sofadione/v4/nirf4G12IcJ6KI8Eoj119fesZW2xOQ-xsNqO47m55DA.ttf\";}}i:723;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Sofia\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/sofia/v5/Imnvx0Ag9r6iDBFUY5_RaQ.ttf\";}}i:724;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Sonsie One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/sonsieone/v5/KSP7xT1OSy0q2ob6RQOTWPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:725;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Sorts Mill Goudy\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/sortsmillgoudy/v6/JzRrPKdwEnE8F1TDmDLMUlIL2Qjg-Xlsg_fhGbe2P5U.ttf\";s:6:\"italic\";s:92:\"http://fonts.gstatic.com/s/sortsmillgoudy/v6/UUu1lKiy4hRmBWk599VL1TYNkCNSzLyoucKmbTguvr0.ttf\";}}i:726;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Source Code Pro\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"200\";s:91:\"http://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqaXvKVW_haheDNrHjziJZVk.ttf\";s:3:\"300\";s:91:\"http://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqVP7R5lD_au4SZC6Ks_vyWs.ttf\";s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/sourcecodepro/v6/mrl8jkM18OlOQN8JLgasD9Rl0pGnog23EMYRrBmUzJQ.ttf\";s:3:\"500\";s:91:\"http://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqX63uKwMO11Of4rJWV582wg.ttf\";s:3:\"600\";s:91:\"http://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqeiMeWyi5E_-XkTgB5psiDg.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqfgXsetDviZcdR5OzC1KPcw.ttf\";s:3:\"900\";s:91:\"http://fonts.gstatic.com/s/sourcecodepro/v6/leqv3v-yTsJNC7nFznSMqRA_awHl7mXRjE_LQVochcU.ttf\";}}i:727;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Source Sans Pro\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":12:{s:3:\"200\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/toadOcfmlt9b38dHJxOBGKXvKVW_haheDNrHjziJZVk.ttf\";s:9:\"200italic\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/fpTVHK8qsXbIeTHTrnQH6OptKU7UIBg2hLM7eMTU8bI.ttf\";s:3:\"300\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/toadOcfmlt9b38dHJxOBGFP7R5lD_au4SZC6Ks_vyWs.ttf\";s:9:\"300italic\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/fpTVHK8qsXbIeTHTrnQH6DUpNKoQAsDux-Todp8f29w.ttf\";s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/ODelI1aHBYDBqgeIAH2zlNRl0pGnog23EMYRrBmUzJQ.ttf\";s:6:\"italic\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/M2Jd71oPJhLKp0zdtTvoMwRX4TIfMQQEXLu74GftruE.ttf\";s:3:\"600\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/toadOcfmlt9b38dHJxOBGOiMeWyi5E_-XkTgB5psiDg.ttf\";s:9:\"600italic\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/fpTVHK8qsXbIeTHTrnQH6Pp6lGoTTgjlW0sC4r900Co.ttf\";s:3:\"700\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/toadOcfmlt9b38dHJxOBGPgXsetDviZcdR5OzC1KPcw.ttf\";s:9:\"700italic\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/fpTVHK8qsXbIeTHTrnQH6LVT4locI09aamSzFGQlDMY.ttf\";s:3:\"900\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/toadOcfmlt9b38dHJxOBGBA_awHl7mXRjE_LQVochcU.ttf\";s:9:\"900italic\";s:91:\"http://fonts.gstatic.com/s/sourcesanspro/v9/fpTVHK8qsXbIeTHTrnQH6A0NcF6HPGWR298uWIdxWv0.ttf\";}}i:728;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Source Serif Pro\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"600\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/sourceserifpro/v4/CeUM4np2c42DV49nanp55YGL0S0YDpKs5GpLtZIQ0m4.ttf\";s:3:\"600\";s:92:\"http://fonts.gstatic.com/s/sourceserifpro/v4/yd5lDMt8Sva2PE17yiLarGi4cQnvCGV11m1KlXh97aQ.ttf\";s:3:\"700\";s:92:\"http://fonts.gstatic.com/s/sourceserifpro/v4/yd5lDMt8Sva2PE17yiLarEkpYHRvxGNSCrR82n_RDNk.ttf\";}}i:729;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Space Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/spacemono/v1/B_LOPq3uMVBqC_kmqwURBfesZW2xOQ-xsNqO47m55DA.ttf\";s:6:\"italic\";s:87:\"http://fonts.gstatic.com/s/spacemono/v1/7xgIgvUEl9Gvhtf7tXsRzC3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/spacemono/v1/vdpMRWfyjfCvDYTz00NEPAJKKGfqHaYFsRG-T3ceEVo.ttf\";s:9:\"700italic\";s:87:\"http://fonts.gstatic.com/s/spacemono/v1/y2NWQDXe2-qPj6a6rWkLc0D2ttfZwueP-QU272T9-k4.ttf\";}}i:730;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Special Elite\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/specialelite/v6/9-wW4zu3WNoD5Fjka35Jm4jjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:731;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Spicy Rice\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/spicyrice/v5/WGCtz7cLoggXARPi9OGD6_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:732;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Spinnaker\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/spinnaker/v8/MQdIXivKITpjROUdiN6Jgg.ttf\";}}i:733;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Spirax\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/spirax/v5/IOKqhk-Ccl7y31yDsePPkw.ttf\";}}i:734;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Squada One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/squadaone/v5/3tzGuaJdD65cZVgfQzN8uvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:735;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Sree Krushnadevaraya\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:97:\"http://fonts.gstatic.com/s/sreekrushnadevaraya/v4/CdsXmnHyEqVl1ahzOh5qnzjDZVem5Eb4d0dXjXa0F_Q.ttf\";}}i:736;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Sriracha\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/sriracha/v1/l-TXHmKwoHm6vtjy4oUz8Q.ttf\";}}i:737;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Stalemate\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/stalemate/v4/wQLCnG0qB6mOu2Wit2dt_w.ttf\";}}i:738;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Stalinist One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-10-10\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:74:\"http://fonts.gstatic.com/s/stalinistone/v8/MQpS-WezM9W4Dd7D3B7I-UT7eZ8.ttf\";}}i:739;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Stardos Stencil\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/stardosstencil/v6/ygEOyTW9a6u4fi4OXEZeTFf2eT4jUldwg_9fgfY_tHc.ttf\";s:3:\"700\";s:92:\"http://fonts.gstatic.com/s/stardosstencil/v6/h4ExtgvoXhPtv9Ieqd-XC81wDCbBgmIo8UyjIhmkeSM.ttf\";}}i:740;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:21:\"Stint Ultra Condensed\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:97:\"http://fonts.gstatic.com/s/stintultracondensed/v5/8DqLK6-YSClFZt3u3EgOUYelbRYnLTTQA1Z5cVLnsI4.ttf\";}}i:741;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Stint Ultra Expanded\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:96:\"http://fonts.gstatic.com/s/stintultraexpanded/v4/FeigX-wDDgHMCKuhekhedQ7dxr0N5HY0cZKknTIL6n4.ttf\";}}i:742;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Stoke\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:3:\"300\";s:62:\"http://fonts.gstatic.com/s/stoke/v6/Sell9475FOS8jUqQsfFsUQ.ttf\";s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/stoke/v6/A7qJNoqOm2d6o1E6e0yUFg.ttf\";}}i:743;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Strait\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/strait/v4/m4W73ViNmProETY2ybc-Bg.ttf\";}}i:744;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Sue Ellen Francisco\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/sueellenfrancisco/v7/TwHX4vSxMUnJUdEz1JIgrhzazJzPVbGl8jnf1tisRz4.ttf\";}}i:745;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Suez One\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:6:\"hebrew\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/suezone/v1/xulpHtKbz3V8hoSLE2uKDw.ttf\";}}i:746;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Sumana\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/sumana/v1/wgdl__wAK7pzliiWs0Nlog.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/sumana/v1/8AcM-KAproitONSBBHj3sQ.ttf\";}}i:747;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Sunshiney\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/sunshiney/v6/kaWOb4pGbwNijM7CkxK1sQ.ttf\";}}i:748;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Supermercado One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/supermercadoone/v6/kMGPVTNFiFEp1U274uBMb4mm5hmSKNFf3C5YoMa-lrM.ttf\";}}i:749;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Sura\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/sura/v1/jznKrhTH5NezYxb0-Q5zzA.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/sura/v1/Z5bXQaFGmoWicN1WlcncxA.ttf\";}}i:750;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Suranna\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/suranna/v4/PYmfr6TQeTqZ-r8HnPM-kA.ttf\";}}i:751;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Suravaram\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/suravaram/v3/G4dPee4pel_w2HqzavW4MA.ttf\";}}i:752;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Suwannaphum\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/suwannaphum/v9/1jIPOyXied3T79GCnSlCN6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:753;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Swanky and Moo Moo\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/swankyandmoomoo/v6/orVNZ9kDeE3lWp3U3YELu9DVLKqNC3_XMNHhr8S94FU.ttf\";}}i:754;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Syncopate\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/syncopate/v7/RQVwO52fAH6MI764EcaYtw.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/syncopate/v7/S5z8ixiOoC4WJ1im6jAlYC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:755;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Tangerine\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/tangerine/v7/DTPeM3IROhnkz7aYG2a9sA.ttf\";s:3:\"700\";s:87:\"http://fonts.gstatic.com/s/tangerine/v7/UkFsr-RwJB_d2l9fIWsx3i3USBnSvpkopQaUR-2r7iU.ttf\";}}i:756;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Taprom\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/taprom/v8/-KByU3BaUsyIvQs79qFObg.ttf\";}}i:757;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Tauri\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/tauri/v4/XIWeYJDXNqiVNej0zEqtGg.ttf\";}}i:758;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Taviraj\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:64:\"http://fonts.gstatic.com/s/taviraj/v1/7iDtujKEc7hwcT6D0zLx-A.ttf\";s:9:\"100italic\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/ai0UdHXB1gi5etfpU0CZ6aCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"200\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/fn3qCO_sC_zLuf2hqWE37fesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"200italic\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/eDMMTK5GhTdvvz3R-ZWvay3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"300\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/1EIpbtG_cs5haG6Ba9wX8vesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"300italic\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/IEBfc1xGgsBbdCeXKNAtfS3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/taviraj/v1/AH1eoWagKJhbVx4Poc3M1A.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/taviraj/v1/hAS5RxygdSnG4626KdkXuQ.ttf\";s:3:\"500\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/s8BuqYm5ebG2N1R4JkTp_fesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"500italic\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/319qfe3yzAi9RNFu-dI9zy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"600\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/KscmiA6HGz7nCcHhaddQH_esZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"600italic\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/ofRN6EMiboGiM2Ga3cG_yy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/TY91892tTFNYCeCXjQ1AEPesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/4Yzb6i1xtMRZn9oAQ484nS3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"800\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/oGWJbiDGcxlInLLnrLxTDvesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"800italic\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/MPtY5Qs3hwV4f0LUH-vVmy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"900\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/RfIEodnN0NYWUdZHol5fdPesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"900italic\";s:85:\"http://fonts.gstatic.com/s/taviraj/v1/aDM2JaXSd_qo0nqKiBAq5C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:759;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Teko\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:61:\"http://fonts.gstatic.com/s/teko/v5/OobFGE9eo24rcBpN6zXDaQ.ttf\";s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/teko/v5/UtekqODEqZXSN2L-njejpA.ttf\";s:3:\"500\";s:61:\"http://fonts.gstatic.com/s/teko/v5/FQ0duU7gWM4cSaImOfAjBA.ttf\";s:3:\"600\";s:61:\"http://fonts.gstatic.com/s/teko/v5/QDx_i8H-TZ1IK1JEVrqwEQ.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/teko/v5/xKfTxe_SWpH4xU75vmvylA.ttf\";}}i:760;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Telex\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/telex/v5/24-3xP9ywYeHOcFU3iGk8A.ttf\";}}i:761;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Tenali Ramakrishna\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:95:\"http://fonts.gstatic.com/s/tenaliramakrishna/v3/M0nTmDqv2M7AGoGh-c946BZak5pSBHqWX6uyVMiMFoA.ttf\";}}i:762;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Tenor Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/tenorsans/v7/dUBulmjNJJInvK5vL7O9yfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:763;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Text Me One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/textmeone/v4/9em_3ckd_P5PQkP4aDyDLqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:764;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"The Girl Next Door\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/thegirlnextdoor/v7/cWRA4JVGeEcHGcPl5hmX7kzo0nFFoM60ux_D9BUymX4.ttf\";}}i:765;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Tienne\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/tienne/v8/-IIfDl701C0z7-fy2kmGvA.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/tienne/v8/JvoCDOlyOSEyYGRwCyfs3g.ttf\";s:3:\"900\";s:63:\"http://fonts.gstatic.com/s/tienne/v8/FBano5T521OWexj2iRYLMw.ttf\";}}i:766;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Tillana\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:5:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":5:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/tillana/v1/zN0D-jDPsr1HzU3VRFLY5g.ttf\";s:3:\"500\";s:85:\"http://fonts.gstatic.com/s/tillana/v1/gqdUngSIcY9tSla5eCZky_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:85:\"http://fonts.gstatic.com/s/tillana/v1/fqon6-r15hy8M1cyiYfQBvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/tillana/v1/jGARMTxLrMerzTCpGBpMffesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"800\";s:85:\"http://fonts.gstatic.com/s/tillana/v1/pmTtNH_Ibktj5Cyc1XrP6vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:767;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Timmana\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:6:\"telugu\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/timmana/v1/T25SicsJUJkc2s2sbBsDnA.ttf\";}}i:768;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Tinos\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:8:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:6:\"hebrew\";i:7;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/tinos/v9/EqpUbkVmutfwZ0PjpoGwCg.ttf\";s:6:\"italic\";s:62:\"http://fonts.gstatic.com/s/tinos/v9/slfyzlasCr9vTsaP4lUh9A.ttf\";s:3:\"700\";s:62:\"http://fonts.gstatic.com/s/tinos/v9/vHXfhX8jZuQruowfon93yQ.ttf\";s:9:\"700italic\";s:83:\"http://fonts.gstatic.com/s/tinos/v9/M6kfzvDMM0CdxdraoFpG6vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:769;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Titan One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/titanone/v4/FbvpRvzfV_oipS0De3iAZg.ttf\";}}i:770;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Titillium Web\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:11:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":11:{s:3:\"200\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/anMUvcNT0H1YN4FII8wprzOdCrLccoxq42eaxM802O0.ttf\";s:9:\"200italic\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/RZunN20OBmkvrU7sA4GPPj4N98U-66ThNJvtgddRfBE.ttf\";s:3:\"300\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/anMUvcNT0H1YN4FII8wpr9ZAkYT8DuUZELiKLwMGWAo.ttf\";s:9:\"300italic\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/RZunN20OBmkvrU7sA4GPPrfzCkqg7ORZlRf2cc4mXu8.ttf\";s:7:\"regular\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/7XUFZ5tgS-tD6QamInJTcTyagQBwYgYywpS70xNq8SQ.ttf\";s:6:\"italic\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/r9OmwyQxrgzUAhaLET_KO-ixohbIP6lHkU-1Mgq95cY.ttf\";s:3:\"600\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/anMUvcNT0H1YN4FII8wpr28K9dEd5Ue-HTQrlA7E2xQ.ttf\";s:9:\"600italic\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/RZunN20OBmkvrU7sA4GPPgOhzTSndyK8UWja2yJjKLc.ttf\";s:3:\"700\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/anMUvcNT0H1YN4FII8wpr2-6tpSbB9YhmWtmd1_gi_U.ttf\";s:9:\"700italic\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/RZunN20OBmkvrU7sA4GPPio3LEw-4MM8Ao2j9wPOfpw.ttf\";s:3:\"900\";s:90:\"http://fonts.gstatic.com/s/titilliumweb/v4/anMUvcNT0H1YN4FII8wpr7L0GmZLri-m-nfoo0Vul4Y.ttf\";}}i:771;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Trade Winds\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/tradewinds/v5/sDOCVgAxw6PEUi2xdMsoDaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:772;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Trirong\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:4:\"thai\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:64:\"http://fonts.gstatic.com/s/trirong/v1/A4AP1moxqvtadq5CW3L17A.ttf\";s:9:\"100italic\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/ke-m75CXBPHlqwRHmCTBi6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"200\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/QD8N5qk-agpAEYCSSWullPesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"200italic\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/TLnptEEWKdIVHKJYBO592y3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"300\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/mfCfGz4GqprWJZ47PUMDGfesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"300italic\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/RnkK09k5OfEHFxd_smcYuC3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/trirong/v1/lYu4kez-Enlvh2X-itx6CA.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/trirong/v1/kV0MzmWPKkglEtJf--dQhQ.ttf\";s:3:\"500\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/6CsQ6UR1e8rURaEPxqnGBvesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"500italic\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/I7H5Vf-5oH45BHkyxaUodS3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"600\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/1FjmLIhPhB6Yc7RWqO27mfesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"600italic\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/BXLhSV51vCWUiACSqyWe6i3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/ab8hG5CTSzMAobTnPgcDP_esZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/CEBv6IoZawJuRHdATx4LQi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"800\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/UBRQXGJvi5EHcyI5wwZew_esZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"800italic\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/lGUgSzOvjUqrsrJfnROivC3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"900\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/Lam1ewMdiP3O-bVYT-W6t_esZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"900italic\";s:85:\"http://fonts.gstatic.com/s/trirong/v1/EtuLHyx5DS9oX5NoKhYlkC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:773;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Trocchi\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/trocchi/v5/uldNPaKrUGVeGCVsmacLwA.ttf\";}}i:774;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Trochut\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/trochut/v4/6Y65B0x-2JsnYt16OH5omw.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/trochut/v4/pczUwr4ZFvC79TgNO5cZng.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/trochut/v4/lWqNOv6ISR8ehNzGLFLnJ_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:775;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Trykker\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/trykker/v5/YiVrVJpBFN7I1l_CWk6yYQ.ttf\";}}i:776;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Tulpen One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://fonts.gstatic.com/s/tulpenone/v6/lwcTfVIEVxpZLZlWzR5baPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:777;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Ubuntu\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2016-06-03\";s:5:\"files\";O:8:\"stdClass\":8:{s:3:\"300\";s:63:\"http://fonts.gstatic.com/s/ubuntu/v9/7-wH0j2QCTHKgp7vLh9-sQ.ttf\";s:9:\"300italic\";s:84:\"http://fonts.gstatic.com/s/ubuntu/v9/j-TYDdXcC_eQzhhp386SjaCWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/ubuntu/v9/lhhB5ZCwEkBRbHMSnYuKyA.ttf\";s:6:\"italic\";s:63:\"http://fonts.gstatic.com/s/ubuntu/v9/b9hP8wd30SygxZjGGk4DCQ.ttf\";s:3:\"500\";s:63:\"http://fonts.gstatic.com/s/ubuntu/v9/bMbHEMwSUmkzcK2x_74QbA.ttf\";s:9:\"500italic\";s:84:\"http://fonts.gstatic.com/s/ubuntu/v9/NWdMogIO7U6AtEM4dDdf_aCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:63:\"http://fonts.gstatic.com/s/ubuntu/v9/B7BtHjNYwAp3HgLNagENOQ.ttf\";s:9:\"700italic\";s:84:\"http://fonts.gstatic.com/s/ubuntu/v9/pqisLQoeO9YTDCNnlQ9bf6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:778;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Ubuntu Condensed\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:6:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-06-03\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:93:\"http://fonts.gstatic.com/s/ubuntucondensed/v7/DBCt-NXN57MTAFjitYxdrKDbm6fPDOZJsR8PmdG62gY.ttf\";}}i:779;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Ubuntu Mono\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:5:\"greek\";i:1;s:8:\"cyrillic\";i:2;s:9:\"greek-ext\";i:3;s:5:\"latin\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-06-03\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/ubuntumono/v6/EgeuS9OtEmA0y_JRo03MQaCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:88:\"http://fonts.gstatic.com/s/ubuntumono/v6/KAKuHXAHZOeECOWAHsRKA0eOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"700\";s:88:\"http://fonts.gstatic.com/s/ubuntumono/v6/ceqTZGKHipo8pJj4molytne1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:88:\"http://fonts.gstatic.com/s/ubuntumono/v6/n_d8tv_JOIiYyMXR4eaV9c_zJjSACmk0BRPxQqhnNLU.ttf\";}}i:780;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Ultra\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/ultra/v8/OW8uXkOstRADuhEmGOFQLA.ttf\";}}i:781;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Uncial Antiqua\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:91:\"http://fonts.gstatic.com/s/uncialantiqua/v4/F-leefDiFwQXsyd6eaSllqrFJ4O13IHVxZbM6yoslpo.ttf\";}}i:782;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Underdog\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/underdog/v5/gBv9yjez_-5PnTprHWq0ig.ttf\";}}i:783;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Unica One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/unicaone/v4/KbYKlhWMDpatWViqDkNQgA.ttf\";}}i:784;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"UnifrakturCook\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:3:\"700\";s:92:\"http://fonts.gstatic.com/s/unifrakturcook/v8/ASwh69ykD8iaoYijVEU6RrWZkcsCTHKV51zmcUsafQ0.ttf\";}}i:785;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"UnifrakturMaguntia\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:96:\"http://fonts.gstatic.com/s/unifrakturmaguntia/v7/7KWy3ymCVR_xfAvvcIXm3-kdNg30GQauG_DE-tMYtWk.ttf\";}}i:786;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Unkempt\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/unkempt/v7/NLLBeNSspr0RGs71R5LHWA.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/unkempt/v7/V7H-GCl9bgwGwqFqTTgDHvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:787;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Unlock\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/unlock/v6/rXEQzK7uIAlhoyoAEiMy1w.ttf\";}}i:788;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Unna\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2017-01-26\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/unna/v9/UAS0AM7AmbdCNY_80xyAZQ.ttf\";s:6:\"italic\";s:61:\"http://fonts.gstatic.com/s/unna/v9/CB25jfOme9BL61pT4h1_0A.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/unna/v9/V-r3KRrJqBWlu97fCUB8Nw.ttf\";s:9:\"700italic\";s:61:\"http://fonts.gstatic.com/s/unna/v9/H7rJH2hD4wVI9bOhx98O8A.ttf\";}}i:789;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"VT323\";s:8:\"category\";s:9:\"monospace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-12-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/vt323/v8/ITU2YQfM073o1iYK3nSOmQ.ttf\";}}i:790;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Vampiro One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/vampiroone/v7/OVDs4gY4WpS5u3Qd1gXRW6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:791;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Varela\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/varela/v7/ON7qs0cKUUixhhDFXlZUjw.ttf\";}}i:792;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Varela Round\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:6:\"hebrew\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-11\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/varelaround/v8/APH4jr0uSos5wiut5cpjri3USBnSvpkopQaUR-2r7iU.ttf\";}}i:793;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Vast Shadow\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/vastshadow/v6/io4hqKX3ibiqQQjYfW0-h6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:794;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Vesper Libre\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/vesperlibre/v8/Cg-TeZFsqV8BaOcoVwzu2C3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"500\";s:89:\"http://fonts.gstatic.com/s/vesperlibre/v8/0liLgNkygqH6EOtsVjZDsZMQuUSAwdHsY8ov_6tk1oA.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/vesperlibre/v8/0liLgNkygqH6EOtsVjZDsUD2ttfZwueP-QU272T9-k4.ttf\";s:3:\"900\";s:89:\"http://fonts.gstatic.com/s/vesperlibre/v8/0liLgNkygqH6EOtsVjZDsaObDOjC3UL77puoeHsE3fw.ttf\";}}i:795;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Vibur\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/vibur/v7/xB9aKsUbJo68XP0bAg2iLw.ttf\";}}i:796;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Vidaloka\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/vidaloka/v8/C6Nul0ogKUWkx356rrt9RA.ttf\";}}i:797;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Viga\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/viga/v5/uD87gDbhS7frHLX4uL6agg.ttf\";}}i:798;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Voces\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:62:\"http://fonts.gstatic.com/s/voces/v5/QoBH6g6yKgNIgvL8A2aE2Q.ttf\";}}i:799;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Volkhov\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/volkhov/v8/MDIZAofe1T_J3un5Kgo8zg.ttf\";s:6:\"italic\";s:64:\"http://fonts.gstatic.com/s/volkhov/v8/1rTjmztKEpbkKH06JwF8Yw.ttf\";s:3:\"700\";s:85:\"http://fonts.gstatic.com/s/volkhov/v8/L8PbKS-kEoLHm7nP--NCzPesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:85:\"http://fonts.gstatic.com/s/volkhov/v8/W6oG0QDDjCgj0gmsHE520C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:800;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Vollkorn\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/vollkorn/v6/IiexqYAeh8uII223thYx3w.ttf\";s:6:\"italic\";s:86:\"http://fonts.gstatic.com/s/vollkorn/v6/UuIzosgR1ovBhJFdwVp3fvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/vollkorn/v6/gOwQjJVGXlDOONC12hVoBqCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:86:\"http://fonts.gstatic.com/s/vollkorn/v6/KNiAlx6phRqXCwnZZG51JAJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:801;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Voltaire\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/voltaire/v6/WvqBzaGEBbRV-hrahwO2cA.ttf\";}}i:802;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:23:\"Waiting for the Sunrise\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:98:\"http://fonts.gstatic.com/s/waitingforthesunrise/v7/eNfH7kLpF1PZWpsetF-ha9TChrNgrDiT3Zy6yGf3FnM.ttf\";}}i:803;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Wallpoet\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/wallpoet/v8/hmum4WuBN4A0Z_7367NDIg.ttf\";}}i:804;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Walter Turncoat\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:92:\"http://fonts.gstatic.com/s/walterturncoat/v6/sG9su5g4GXy1KP73cU3hvQplL2YwNeota48DxFlGDUo.ttf\";}}i:805;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Warnes\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/warnes/v6/MXG7_Phj4YpzAXxKGItuBw.ttf\";}}i:806;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Wellfleet\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:66:\"http://fonts.gstatic.com/s/wellfleet/v4/J5tOx72iFRPgHYpbK9J4XQ.ttf\";}}i:807;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Wendy One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/wendyone/v4/R8CJT2oDXdMk_ZtuHTxoxw.ttf\";}}i:808;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Wire One\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:64:\"http://fonts.gstatic.com/s/wireone/v7/sRLhaQOQpWnvXwIx0CycQw.ttf\";}}i:809;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Work Sans\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2016-06-07\";s:5:\"files\";O:8:\"stdClass\":9:{s:3:\"100\";s:86:\"http://fonts.gstatic.com/s/worksans/v2/ZAhtNqLaAViKjGLajtuwWaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"200\";s:86:\"http://fonts.gstatic.com/s/worksans/v2/u_mYNr_qYP37m7vgvmIYZy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"300\";s:86:\"http://fonts.gstatic.com/s/worksans/v2/FD_Udbezj8EHXbdsqLUply3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/worksans/v2/zVvigUiMvx7JVEnrJgc-5Q.ttf\";s:3:\"500\";s:86:\"http://fonts.gstatic.com/s/worksans/v2/Nbre-U_bp6Xktt8cpgwaJC3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"600\";s:86:\"http://fonts.gstatic.com/s/worksans/v2/z9rX03Xuz9ZNHTMg1_ghGS3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:86:\"http://fonts.gstatic.com/s/worksans/v2/4udXuXg54JlPEP5iKO5AmS3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"800\";s:86:\"http://fonts.gstatic.com/s/worksans/v2/IQh-ap2Uqs7kl1YINeeEGi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"900\";s:86:\"http://fonts.gstatic.com/s/worksans/v2/Hjn0acvjHfjY_vAK9Uc6gi3USBnSvpkopQaUR-2r7iU.ttf\";}}i:810;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Yanone Kaffeesatz\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:4:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:10:\"vietnamese\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2017-01-20\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"200\";s:94:\"http://fonts.gstatic.com/s/yanonekaffeesatz/v8/We_iSDqttE3etzfdfhuPRbq92v6XxU4pSv06GI0NsGc.ttf\";s:3:\"300\";s:94:\"http://fonts.gstatic.com/s/yanonekaffeesatz/v8/We_iSDqttE3etzfdfhuPRZlIwXPiNoNT_wxzJ2t3mTE.ttf\";s:7:\"regular\";s:94:\"http://fonts.gstatic.com/s/yanonekaffeesatz/v8/YDAoLskQQ5MOAgvHUQCcLdXn3cHbFGWU4T2HrSN6JF4.ttf\";s:3:\"700\";s:94:\"http://fonts.gstatic.com/s/yanonekaffeesatz/v8/We_iSDqttE3etzfdfhuPRf2R4S6PlKaGXWPfWpHpcl0.ttf\";}}i:811;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Yantramanav\";s:8:\"category\";s:10:\"sans-serif\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"900\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"100\";s:89:\"http://fonts.gstatic.com/s/yantramanav/v1/Rs1I2PF4Z8GAb6qjgvr8wIAWxXGWZ3yJw6KhWS7MxOk.ttf\";s:3:\"300\";s:89:\"http://fonts.gstatic.com/s/yantramanav/v1/HSfbC4Z8I8BZ00wiXeA5bC9-WlPSxbfiI49GsXo3q0g.ttf\";s:7:\"regular\";s:89:\"http://fonts.gstatic.com/s/yantramanav/v1/FwdziO-qWAO8pZg8e376kaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"500\";s:89:\"http://fonts.gstatic.com/s/yantramanav/v1/HSfbC4Z8I8BZ00wiXeA5bMCNfqCYlB_eIx7H1TVXe60.ttf\";s:3:\"700\";s:89:\"http://fonts.gstatic.com/s/yantramanav/v1/HSfbC4Z8I8BZ00wiXeA5bHe1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:3:\"900\";s:89:\"http://fonts.gstatic.com/s/yantramanav/v1/HSfbC4Z8I8BZ00wiXeA5bCenaqEuufTBk9XMKnKmgDA.ttf\";}}i:812;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Yatra One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:5:\"latin\";i:1;s:10:\"devanagari\";i:2;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:65:\"http://fonts.gstatic.com/s/yatraone/v1/ApKQzWF7_vG0Lt5TDqgUvw.ttf\";}}i:813;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Yellowtail\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-10-05\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/yellowtail/v6/HLrU6lhCTjXfLZ7X60LcB_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:814;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Yeseva One\";s:8:\"category\";s:7:\"display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";i:2;s:9:\"latin-ext\";i:3;s:12:\"cyrillic-ext\";i:4;s:10:\"vietnamese\";}s:7:\"version\";s:3:\"v11\";s:12:\"lastModified\";s:10:\"2017-01-20\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/yesevaone/v11/eenQQxvpzSA80JmisGcgX_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:815;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Yesteryear\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://fonts.gstatic.com/s/yesteryear/v5/dv09hP_ZrdjVOfZQXKXuZvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:816;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Yrsa\";s:8:\"category\";s:5:\"serif\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2016-06-20\";s:5:\"files\";O:8:\"stdClass\":5:{s:3:\"300\";s:61:\"http://fonts.gstatic.com/s/yrsa/v1/YI0C1syzAYpkrPx27UnC2w.ttf\";s:7:\"regular\";s:61:\"http://fonts.gstatic.com/s/yrsa/v1/JWX_dCK4_Jq-oqF7r9rFHg.ttf\";s:3:\"500\";s:61:\"http://fonts.gstatic.com/s/yrsa/v1/rWuZmBLHIeKRbnfSvWCvYg.ttf\";s:3:\"600\";s:61:\"http://fonts.gstatic.com/s/yrsa/v1/1413P-oEfrq-tBIdqnslDQ.ttf\";s:3:\"700\";s:61:\"http://fonts.gstatic.com/s/yrsa/v1/iV49zaJV5wyo_4LgxE2yng.ttf\";}}i:817;O:8:\"stdClass\":8:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Zeyada\";s:8:\"category\";s:11:\"handwriting\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2016-05-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:63:\"http://fonts.gstatic.com/s/zeyada/v6/hmonmGYYFwqTZQfG2nRswQ.ttf\";}}}", "yes");
INSERT INTO `myevntl_options` VALUES("208", "ultimate_selected_google_fonts", "a:1:{i:0;a:4:{s:11:\"font_family\";s:9:\"Open+Sans\";s:9:\"font_name\";s:9:\"Open Sans\";s:8:\"variants\";a:9:{i:0;a:2:{s:13:\"variant_value\";s:3:\"300\";s:16:\"variant_selected\";s:5:\"false\";}i:1;a:2:{s:13:\"variant_value\";s:9:\"300italic\";s:16:\"variant_selected\";s:5:\"false\";}i:2;a:2:{s:13:\"variant_value\";s:6:\"italic\";s:16:\"variant_selected\";s:5:\"false\";}i:3;a:2:{s:13:\"variant_value\";s:3:\"600\";s:16:\"variant_selected\";s:5:\"false\";}i:4;a:2:{s:13:\"variant_value\";s:9:\"600italic\";s:16:\"variant_selected\";s:5:\"false\";}i:5;a:2:{s:13:\"variant_value\";s:3:\"700\";s:16:\"variant_selected\";s:5:\"false\";}i:6;a:2:{s:13:\"variant_value\";s:9:\"700italic\";s:16:\"variant_selected\";s:5:\"false\";}i:7;a:2:{s:13:\"variant_value\";s:3:\"800\";s:16:\"variant_selected\";s:5:\"false\";}i:8;a:2:{s:13:\"variant_value\";s:9:\"800italic\";s:16:\"variant_selected\";s:5:\"false\";}}s:7:\"subsets\";a:7:{i:0;a:2:{s:12:\"subset_value\";s:5:\"greek\";s:15:\"subset_selected\";s:5:\"false\";}i:1;a:2:{s:12:\"subset_value\";s:8:\"cyrillic\";s:15:\"subset_selected\";s:5:\"false\";}i:2;a:2:{s:12:\"subset_value\";s:9:\"greek-ext\";s:15:\"subset_selected\";s:5:\"false\";}i:3;a:2:{s:12:\"subset_value\";s:5:\"latin\";s:15:\"subset_selected\";s:5:\"false\";}i:4;a:2:{s:12:\"subset_value\";s:9:\"latin-ext\";s:15:\"subset_selected\";s:5:\"false\";}i:5;a:2:{s:12:\"subset_value\";s:12:\"cyrillic-ext\";s:15:\"subset_selected\";s:5:\"false\";}i:6;a:2:{s:12:\"subset_value\";s:10:\"vietnamese\";s:15:\"subset_selected\";s:5:\"false\";}}}}", "yes");
INSERT INTO `myevntl_options` VALUES("209", "convert_plug_redirect", "", "yes");
INSERT INTO `myevntl_options` VALUES("210", "bsf_force_check_extensions", "", "no");
INSERT INTO `myevntl_options` VALUES("211", "cp_is_new_user", "", "yes");
INSERT INTO `myevntl_options` VALUES("212", "cp_previous_version", "2.3.1", "yes");
INSERT INTO `myevntl_options` VALUES("255", "bsf_installer_menu", "a:1:{s:11:\"ConvertPlug\";a:4:{s:11:\"parent_slug\";s:11:\"convertplug\";s:10:\"page_title\";s:6:\"Addons\";s:10:\"menu_title\";s:6:\"Addons\";s:10:\"product_id\";s:8:\"14058953\";}}", "no");
INSERT INTO `myevntl_options` VALUES("213", "revslider-update-check-short", "1536583654", "yes");
INSERT INTO `myevntl_options` VALUES("214", "revslider-templates-check", "1536583655", "yes");
INSERT INTO `myevntl_options` VALUES("220", "widget_convertplug_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `myevntl_options` VALUES("221", "smile_modal_styles_backup", "", "yes");
INSERT INTO `myevntl_options` VALUES("222", "smile_info_bar_styles_backup", "", "yes");
INSERT INTO `myevntl_options` VALUES("223", "smile_slide_in_styles_backup", "", "yes");
INSERT INTO `myevntl_options` VALUES("224", "cp_multifield_support", "yes", "yes");
INSERT INTO `myevntl_options` VALUES("225", "go_pricing_table_settings", "a:2:{s:5:\"admin\";a:2:{s:4:\"ajax\";i:1;s:10:\"capability\";s:14:\"manage_options\";}s:8:\"currency\";a:1:{i:0;a:5:{s:8:\"currency\";s:3:\"USD\";s:8:\"position\";s:4:\"left\";s:12:\"thousand-sep\";s:1:\",\";s:11:\"decimal-sep\";s:1:\".\";s:10:\"decimal-no\";i:2;}}}", "yes");
INSERT INTO `myevntl_options` VALUES("226", "go_pricing_version", "a:1:{s:6:\"plugin\";s:5:\"3.3.5\";}", "yes");
INSERT INTO `myevntl_options` VALUES("227", "bsf_local_transient", "1536599187", "yes");
INSERT INTO `myevntl_options` VALUES("230", "smile_lists", "a:1:{i:0;a:5:{s:4:\"date\";s:10:\"27-02-2017\";s:9:\"list-name\";s:5:\"First\";s:13:\"list-provider\";s:12:\"Convert Plug\";s:4:\"list\";s:0:\"\";s:13:\"provider_list\";s:0:\"\";}}", "yes");
INSERT INTO `myevntl_options` VALUES("232", "revslider-library-check", "1536128407", "yes");
INSERT INTO `myevntl_options` VALUES("233", "rs-library", "a:2:{s:7:\"objects\";a:169:{i:198;a:11:{s:2:\"id\";s:3:\"198\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";}i:197;a:11:{s:2:\"id\";s:3:\"197\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:196;a:11:{s:2:\"id\";s:3:\"196\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:195;a:11:{s:2:\"id\";s:3:\"195\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:194;a:11:{s:2:\"id\";s:3:\"194\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:193;a:11:{s:2:\"id\";s:3:\"193\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:192;a:11:{s:2:\"id\";s:3:\"192\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:191;a:11:{s:2:\"id\";s:3:\"191\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:190;a:11:{s:2:\"id\";s:3:\"190\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:189;a:11:{s:2:\"id\";s:3:\"189\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:188;a:11:{s:2:\"id\";s:3:\"188\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:187;a:11:{s:2:\"id\";s:3:\"187\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:186;a:11:{s:2:\"id\";s:3:\"186\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:185;a:11:{s:2:\"id\";s:3:\"185\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:184;a:11:{s:2:\"id\";s:3:\"184\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:183;a:11:{s:2:\"id\";s:3:\"183\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:182;a:11:{s:2:\"id\";s:3:\"182\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:181;a:11:{s:2:\"id\";s:3:\"181\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:180;a:11:{s:2:\"id\";s:3:\"180\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:179;a:11:{s:2:\"id\";s:3:\"179\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:177;a:11:{s:2:\"id\";s:3:\"177\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:175;a:11:{s:2:\"id\";s:3:\"175\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:174;a:11:{s:2:\"id\";s:3:\"174\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:173;a:11:{s:2:\"id\";s:3:\"173\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:172;a:11:{s:2:\"id\";s:3:\"172\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:171;a:11:{s:2:\"id\";s:3:\"171\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:170;a:11:{s:2:\"id\";s:3:\"170\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:169;a:11:{s:2:\"id\";s:3:\"169\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:168;a:11:{s:2:\"id\";s:3:\"168\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:167;a:11:{s:2:\"id\";s:3:\"167\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:166;a:11:{s:2:\"id\";s:3:\"166\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:165;a:11:{s:2:\"id\";s:3:\"165\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:164;a:11:{s:2:\"id\";s:3:\"164\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole-punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:163;a:11:{s:2:\"id\";s:3:\"163\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:162;a:11:{s:2:\"id\";s:3:\"162\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:161;a:11:{s:2:\"id\";s:3:\"161\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:160;a:11:{s:2:\"id\";s:3:\"160\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:159;a:11:{s:2:\"id\";s:3:\"159\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:158;a:11:{s:2:\"id\";s:3:\"158\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:157;a:11:{s:2:\"id\";s:3:\"157\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:156;a:11:{s:2:\"id\";s:3:\"156\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:155;a:11:{s:2:\"id\";s:3:\"155\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:154;a:11:{s:2:\"id\";s:3:\"154\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:153;a:11:{s:2:\"id\";s:3:\"153\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:152;a:11:{s:2:\"id\";s:3:\"152\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:151;a:11:{s:2:\"id\";s:3:\"151\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:150;a:11:{s:2:\"id\";s:3:\"150\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:149;a:11:{s:2:\"id\";s:3:\"149\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:148;a:11:{s:2:\"id\";s:3:\"148\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:147;a:11:{s:2:\"id\";s:3:\"147\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:146;a:11:{s:2:\"id\";s:3:\"146\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:145;a:11:{s:2:\"id\";s:3:\"145\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:144;a:11:{s:2:\"id\";s:3:\"144\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:143;a:11:{s:2:\"id\";s:3:\"143\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:142;a:11:{s:2:\"id\";s:3:\"142\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:141;a:11:{s:2:\"id\";s:3:\"141\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:140;a:11:{s:2:\"id\";s:3:\"140\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:139;a:11:{s:2:\"id\";s:3:\"139\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:138;a:11:{s:2:\"id\";s:3:\"138\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:137;a:11:{s:2:\"id\";s:3:\"137\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:136;a:11:{s:2:\"id\";s:3:\"136\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:135;a:11:{s:2:\"id\";s:3:\"135\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:134;a:11:{s:2:\"id\";s:3:\"134\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:133;a:11:{s:2:\"id\";s:3:\"133\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:132;a:11:{s:2:\"id\";s:3:\"132\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:131;a:11:{s:2:\"id\";s:3:\"131\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:130;a:11:{s:2:\"id\";s:3:\"130\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:129;a:11:{s:2:\"id\";s:3:\"129\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:128;a:11:{s:2:\"id\";s:3:\"128\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:127;a:11:{s:2:\"id\";s:3:\"127\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:126;a:11:{s:2:\"id\";s:3:\"126\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:125;a:11:{s:2:\"id\";s:3:\"125\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:124;a:11:{s:2:\"id\";s:3:\"124\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:123;a:11:{s:2:\"id\";s:3:\"123\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:122;a:11:{s:2:\"id\";s:3:\"122\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:121;a:11:{s:2:\"id\";s:3:\"121\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:120;a:11:{s:2:\"id\";s:3:\"120\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:119;a:11:{s:2:\"id\";s:3:\"119\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:118;a:11:{s:2:\"id\";s:3:\"118\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:117;a:11:{s:2:\"id\";s:3:\"117\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:116;a:11:{s:2:\"id\";s:3:\"116\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:115;a:11:{s:2:\"id\";s:3:\"115\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:114;a:11:{s:2:\"id\";s:3:\"114\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:113;a:11:{s:2:\"id\";s:3:\"113\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:112;a:11:{s:2:\"id\";s:3:\"112\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:111;a:11:{s:2:\"id\";s:3:\"111\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:110;a:11:{s:2:\"id\";s:3:\"110\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:109;a:11:{s:2:\"id\";s:3:\"109\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:108;a:11:{s:2:\"id\";s:3:\"108\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:107;a:11:{s:2:\"id\";s:3:\"107\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:106;a:11:{s:2:\"id\";s:3:\"106\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:105;a:11:{s:2:\"id\";s:3:\"105\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:104;a:11:{s:2:\"id\";s:3:\"104\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:103;a:11:{s:2:\"id\";s:3:\"103\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:102;a:11:{s:2:\"id\";s:3:\"102\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:101;a:11:{s:2:\"id\";s:3:\"101\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:100;a:11:{s:2:\"id\";s:3:\"100\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:99;a:11:{s:2:\"id\";s:2:\"99\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:98;a:11:{s:2:\"id\";s:2:\"98\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:97;a:11:{s:2:\"id\";s:2:\"97\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:96;a:11:{s:2:\"id\";s:2:\"96\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:95;a:11:{s:2:\"id\";s:2:\"95\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:94;a:11:{s:2:\"id\";s:2:\"94\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:93;a:11:{s:2:\"id\";s:2:\"93\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:92;a:11:{s:2:\"id\";s:2:\"92\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:91;a:11:{s:2:\"id\";s:2:\"91\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:90;a:11:{s:2:\"id\";s:2:\"90\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:89;a:11:{s:2:\"id\";s:2:\"89\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:88;a:11:{s:2:\"id\";s:2:\"88\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:87;a:11:{s:2:\"id\";s:2:\"87\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:86;a:11:{s:2:\"id\";s:2:\"86\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:85;a:11:{s:2:\"id\";s:2:\"85\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:84;a:11:{s:2:\"id\";s:2:\"84\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:83;a:11:{s:2:\"id\";s:2:\"83\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:82;a:11:{s:2:\"id\";s:2:\"82\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:81;a:11:{s:2:\"id\";s:2:\"81\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:80;a:11:{s:2:\"id\";s:2:\"80\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:79;a:11:{s:2:\"id\";s:2:\"79\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:78;a:11:{s:2:\"id\";s:2:\"78\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:77;a:11:{s:2:\"id\";s:2:\"77\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:76;a:11:{s:2:\"id\";s:2:\"76\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:75;a:11:{s:2:\"id\";s:2:\"75\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:74;a:11:{s:2:\"id\";s:2:\"74\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:73;a:11:{s:2:\"id\";s:2:\"73\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:72;a:11:{s:2:\"id\";s:2:\"72\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:71;a:11:{s:2:\"id\";s:2:\"71\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:70;a:11:{s:2:\"id\";s:2:\"70\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:69;a:11:{s:2:\"id\";s:2:\"69\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:68;a:11:{s:2:\"id\";s:2:\"68\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:67;a:11:{s:2:\"id\";s:2:\"67\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:66;a:11:{s:2:\"id\";s:2:\"66\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:65;a:11:{s:2:\"id\";s:2:\"65\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:64;a:11:{s:2:\"id\";s:2:\"64\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:63;a:11:{s:2:\"id\";s:2:\"63\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:62;a:11:{s:2:\"id\";s:2:\"62\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:49;a:11:{s:2:\"id\";s:2:\"49\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:48;a:11:{s:2:\"id\";s:2:\"48\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:47;a:11:{s:2:\"id\";s:2:\"47\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:46;a:11:{s:2:\"id\";s:2:\"46\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:45;a:11:{s:2:\"id\";s:2:\"45\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:44;a:11:{s:2:\"id\";s:2:\"44\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:43;a:11:{s:2:\"id\";s:2:\"43\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:42;a:11:{s:2:\"id\";s:2:\"42\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:41;a:11:{s:2:\"id\";s:2:\"41\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:40;a:11:{s:2:\"id\";s:2:\"40\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:39;a:11:{s:2:\"id\";s:2:\"39\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:38;a:11:{s:2:\"id\";s:2:\"38\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:37;a:11:{s:2:\"id\";s:2:\"37\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:36;a:11:{s:2:\"id\";s:2:\"36\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:35;a:11:{s:2:\"id\";s:2:\"35\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:34;a:11:{s:2:\"id\";s:2:\"34\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:33;a:11:{s:2:\"id\";s:2:\"33\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:32;a:11:{s:2:\"id\";s:2:\"32\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:31;a:11:{s:2:\"id\";s:2:\"31\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:30;a:11:{s:2:\"id\";s:2:\"30\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:29;a:11:{s:2:\"id\";s:2:\"29\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:28;a:11:{s:2:\"id\";s:2:\"28\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:27;a:11:{s:2:\"id\";s:2:\"27\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:26;a:11:{s:2:\"id\";s:2:\"26\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:25;a:11:{s:2:\"id\";s:2:\"25\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:24;a:11:{s:2:\"id\";s:2:\"24\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:23;a:11:{s:2:\"id\";s:2:\"23\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:22;a:11:{s:2:\"id\";s:2:\"22\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:21;a:11:{s:2:\"id\";s:2:\"21\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:20;a:11:{s:2:\"id\";s:2:\"20\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:11;a:11:{s:2:\"id\";s:2:\"11\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:10;a:11:{s:2:\"id\";s:2:\"10\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:9;a:11:{s:2:\"id\";s:1:\"9\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:8;a:11:{s:2:\"id\";s:1:\"8\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}}s:4:\"tags\";a:13:{i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}}", "no");
INSERT INTO `myevntl_options` VALUES("234", "revslider_checktables", "1", "yes");
INSERT INTO `myevntl_options` VALUES("235", "rs_tables_created", "1", "yes");
INSERT INTO `myevntl_options` VALUES("236", "revslider_table_version", "1.0.6", "yes");
INSERT INTO `myevntl_options` VALUES("237", "revslider-global-settings", "a:18:{s:4:\"role\";s:6:\"editor\";s:17:\"includes_globally\";s:2:\"on\";s:18:\"pages_for_includes\";s:0:\"\";s:12:\"js_to_footer\";s:3:\"off\";s:8:\"js_defer\";s:3:\"off\";s:19:\"load_all_javascript\";s:3:\"off\";s:15:\"show_dev_export\";s:3:\"off\";s:19:\"change_font_loading\";s:0:\"\";s:5:\"width\";s:4:\"1240\";s:14:\"width_notebook\";s:4:\"1024\";s:12:\"width_tablet\";s:3:\"778\";s:12:\"width_mobile\";s:3:\"480\";s:14:\"stage_collapse\";s:3:\"off\";s:18:\"enable_newschannel\";s:2:\"on\";s:11:\"enable_logs\";s:3:\"off\";s:20:\"force_activation_box\";s:3:\"off\";s:18:\"pack_page_creation\";s:2:\"on\";s:20:\"single_page_creation\";s:3:\"off\";}", "yes");
INSERT INTO `myevntl_options` VALUES("239", "ultimate_row", "enable", "yes");
INSERT INTO `myevntl_options` VALUES("240", "ultimate_animation", "disable", "yes");
INSERT INTO `myevntl_options` VALUES("241", "ultimate_vc_addons_redirect", "", "yes");
INSERT INTO `myevntl_options` VALUES("242", "ultimate_js", "enable", "yes");
INSERT INTO `myevntl_options` VALUES("243", "ultimate_css", "enable", "yes");
INSERT INTO `myevntl_options` VALUES("287", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `myevntl_options` VALUES("256", "brainstrom_products", "a:1:{s:7:\"plugins\";a:2:{i:14058953;a:12:{s:8:\"template\";s:27:\"convertplug/convertplug.php\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:8:\"14058953\";s:12:\"product_name\";s:11:\"ConvertPlug\";s:7:\"version\";s:5:\"2.3.1\";s:6:\"remote\";s:5:\"3.3.4\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:4:\"true\";s:15:\"is_product_free\";s:5:\"false\";s:10:\"short_name\";s:0:\"\";s:13:\"changelog_url\";s:43:\"https://www.convertplug.com/plus/changelog/\";s:12:\"purchase_url\";s:75:\"https://codecanyon.net/cart/add_items?item_ids=14058953&ref=BrainstormForce\";}i:6892199;a:12:{s:8:\"template\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:7:\"6892199\";s:12:\"product_name\";s:35:\"Ultimate Addons for Visual Composer\";s:7:\"version\";s:6:\"3.16.7\";s:6:\"remote\";s:7:\"3.16.25\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:4:\"true\";s:15:\"is_product_free\";s:5:\"false\";s:10:\"short_name\";s:0:\"\";s:13:\"changelog_url\";s:46:\"http://changelog.brainstormforce.com/ultimate/\";s:12:\"purchase_url\";s:74:\"https://codecanyon.net/cart/add_items?item_ids=6892199&ref=BrainstormForce\";}}}", "yes");
INSERT INTO `myevntl_options` VALUES("246", "revslider_update_version", "5.2.5.5", "yes");
INSERT INTO `myevntl_options` VALUES("376", "ljmm-content", "<h1 style=\"text-align: center;\"></h1>\r\n<h1 style=\"text-align: center;\">We\'re launching soon!</h1>\r\n<p style=\"text-align: center;\">Our Website is currently undergoing development.</p>\r\n<p style=\"text-align: center;\">Please check back soon.</p>", "yes");
INSERT INTO `myevntl_options` VALUES("377", "ljmm-mode", "default", "yes");
INSERT INTO `myevntl_options` VALUES("380", "ljmm-enabled", "1", "yes");
INSERT INTO `myevntl_options` VALUES("381", "ljmm-site-title", "", "yes");
INSERT INTO `myevntl_options` VALUES("382", "ljmm-roles", "", "yes");
INSERT INTO `myevntl_options` VALUES("385", "revslider-connection", "1", "yes");
INSERT INTO `myevntl_options` VALUES("386", "revslider-latest-version", "5.4.8", "yes");
INSERT INTO `myevntl_options` VALUES("387", "revslider-stable-version", "4.2", "yes");
INSERT INTO `myevntl_options` VALUES("388", "revslider-notices", "a:10:{i:0;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.0.9\";s:4:\"text\";s:220:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow51_banner.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1 is out\" ></a>\";s:4:\"code\";s:9:\"TPRS51-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.1.4\";s:4:\"text\";s:232:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=515b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_banner515.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS515-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.1.6\";s:4:\"text\";s:230:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=52b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_banner52.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS515-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.2.9\";s:4:\"text\";s:239:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=530b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_banner_large_5.3.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.3.0 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS530-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.3.9\";s:4:\"text\";s:222:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=54b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_54.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS540-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:5;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.4.1\";s:4:\"text\";s:239:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=542b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_banner_large_542.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.2 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS540-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:6;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.4.4\";s:4:\"text\";s:226:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=545b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_545.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS545-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:7;O:8:\"stdClass\":7:{s:7:\"version\";s:7:\"5.4.5.1\";s:4:\"text\";s:242:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=5452b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_banner_large5452.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.5.2 is out\" ></a>\";s:4:\"code\";s:11:\"TPRS5452-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:8;O:8:\"stdClass\":7:{s:7:\"version\";s:7:\"5.4.5.2\";s:4:\"text\";s:223:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=546b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/546_update.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.6 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS546-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:9;O:8:\"stdClass\":7:{s:7:\"version\";s:7:\"5.4.7.9\";s:4:\"text\";s:231:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=548\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/revsliderbanner_548.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.8 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS548-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `myevntl_options` VALUES("389", "revslider-dashboard", "O:8:\"stdClass\":1:{s:11:\"test-handle\";O:8:\"stdClass\":5:{s:12:\"version_from\";s:5:\"5.0.0\";s:10:\"version_to\";s:5:\"5.0.0\";s:5:\"order\";i:5;s:7:\"content\";s:181:\"<div class=\"rs-dash-widget\"><div class=\"rs-dash-title-wrap\"><div class=\"rs-dash-title\">your version is: {{current_version}}</div></div><div class=\"rs-dash-widget-inner\"></div></div>\";s:4:\"code\";s:0:\"\";}}", "yes");
INSERT INTO `myevntl_options` VALUES("390", "revslider-addons", "O:8:\"stdClass\":26:{s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:65:\"//updates.themepunch.tools/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"5.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"1.1.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch.tools/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:55:\"//updates.themepunch.tools/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:59:\"//updates.themepunch.tools/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:54:\"//updates.themepunch.tools/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:56:\"//updates.themepunch.tools/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:62:\"//updates.themepunch.tools/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:58:\"//updates.themepunch.tools/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:23:\"Display images in 360°\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:59:\"//updates.themepunch.tools/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:58:\"//updates.themepunch.tools/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:62:\"//updates.themepunch.tools/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}}", "yes");
INSERT INTO `myevntl_options` VALUES("451", "WP_HPUW", "a:3:{s:3:\"ver\";s:3:\"1.0\";s:13:\"notifications\";i:1;s:7:\"updates\";a:0:{}}", "yes");
INSERT INTO `myevntl_options` VALUES("3054", "wplc_db_version", "7.0.06", "yes");
INSERT INTO `myevntl_options` VALUES("3055", "WPLC_SETTINGS", "a:44:{s:19:\"wplc_settings_align\";s:1:\"2\";s:16:\"wplc_environment\";s:1:\"1\";s:20:\"wplc_settings_color1\";s:6:\"3DCC13\";s:18:\"wplc_settings_fill\";s:6:\"3DCC13\";s:20:\"wplc_settings_color2\";s:6:\"FFFFFF\";s:18:\"wplc_settings_font\";s:6:\"FFFFFF\";s:20:\"wplc_settings_color3\";s:6:\"EEEEEE\";s:20:\"wplc_settings_color4\";s:6:\"666666\";s:21:\"wplc_settings_enabled\";s:1:\"1\";s:22:\"wplc_require_user_info\";s:1:\"1\";s:23:\"wplc_loggedin_user_info\";s:1:\"0\";s:26:\"wplc_user_alternative_text\";s:70:\"Please click \\&#039;Start Chat\\&#039; to initiate a chat with an agent\";s:22:\"wplc_enabled_on_mobile\";s:1:\"1\";s:27:\"wplc_redirect_thank_you_url\";s:0:\"\";s:22:\"wplc_record_ip_address\";s:1:\"1\";s:21:\"wplc_enable_msg_sound\";s:1:\"1\";s:11:\"wplc_pro_na\";s:29:\"Chat offline. Leave a message\";s:27:\"wplc_pro_chat_email_address\";s:20:\"info@myeventology.ph\";s:35:\"wplc_pro_chat_email_offline_subject\";s:46:\"Offline Chat Message from MyEventology Online!\";s:17:\"wplc_pro_offline1\";s:89:\"We are currently offline. Please leave a message and we\\&#039;ll get back to you shortly.\";s:17:\"wplc_pro_offline2\";s:18:\"Sending message...\";s:17:\"wplc_pro_offline3\";s:55:\"Thank you for your message. We will be in contact soon.\";s:13:\"wplc_pro_fst1\";s:10:\"Questions?\";s:13:\"wplc_pro_fst2\";s:13:\"Chat with us!\";s:13:\"wplc_pro_sst1\";s:10:\"Start Chat\";s:20:\"wplc_pro_sst1_survey\";s:23:\"Or chat to an agent now\";s:21:\"wplc_pro_sst1e_survey\";s:10:\"Chat ended\";s:13:\"wplc_pro_sst2\";s:32:\"Connecting. Please be patient...\";s:13:\"wplc_pro_tst1\";s:34:\"Reactivating your previous chat...\";s:14:\"wplc_pro_intro\";s:56:\"Hello. Please input your details so that I may help you.\";s:15:\"wplc_user_enter\";s:32:\"Press ENTER to send your message\";s:16:\"wplc_welcome_msg\";s:84:\"Please standby for an agent. While you wait for the agent you may type your message.\";s:10:\"wplc_theme\";s:7:\"theme-6\";s:13:\"wplc_newtheme\";s:7:\"theme-2\";s:24:\"wplc_elem_trigger_action\";s:1:\"0\";s:22:\"wplc_elem_trigger_type\";s:1:\"0\";s:20:\"wplc_elem_trigger_id\";s:0:\"\";s:14:\"wplc_show_date\";s:1:\"1\";s:14:\"wplc_show_time\";s:1:\"1\";s:14:\"wplc_show_name\";s:1:\"1\";s:16:\"wplc_show_avatar\";s:1:\"1\";s:19:\"wplc_user_no_answer\";s:43:\"There is No Answer. Please Try Again Later.\";s:13:\"wplc_pro_fst3\";s:15:\"Start live chat\";s:22:\"wplc_user_welcome_chat\";s:28:\"Welcome. How may I help you?\";}", "yes");
INSERT INTO `myevntl_options` VALUES("3056", "WPLC_HIDE_CHAT", "", "yes");
INSERT INTO `myevntl_options` VALUES("3057", "WPLC_FIRST_TIME", "", "yes");
INSERT INTO `myevntl_options` VALUES("3058", "wplc_api_secret_token", "f2deda02d4e888042e1b492853fc3a2f", "yes");
INSERT INTO `myevntl_options` VALUES("3059", "wplc_node_server_secret_token", "d198b6c388096a2e02a55f218352d036", "yes");
INSERT INTO `myevntl_options` VALUES("3060", "wplc_current_version", "7.0.06", "yes");
INSERT INTO `myevntl_options` VALUES("3171", "brainstrom_bundled_products", "a:1:{i:14058953;a:41:{i:0;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:15:\"connects-mymail\";s:4:\"init\";s:35:\"connects-mymail/connects-mymail.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:19:\"connects-mymail.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - MailSter Mailer\";s:10:\"short_name\";s:8:\"Mailster\";s:7:\"version\";s:5:\"2.2.0\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:15:\"connects-mymail\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2016/03/MyMail.png\";s:11:\"description\";s:42:\"Integration with Mailster Email Solutions.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:1;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-madmimi\";s:4:\"init\";s:37:\"connects-madmimi/connects-madmimi.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-madmimi.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - Mad Mimi Mailer\";s:10:\"short_name\";s:8:\"Mad Mimi\";s:7:\"version\";s:5:\"1.1.0\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:16:\"connects-madmimi\";s:13:\"product_image\";s:68:\"//support.brainstormforce.com/wp-content/uploads/2016/03/MadMini.png\";s:11:\"description\";s:51:\"Integration with Mad Mimi Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:2;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:23:\"connects-activecampaign\";s:4:\"init\";s:51:\"connects-activecampaign/connects-activecampaign.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:27:\"connects-activecampaign.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:32:\"Connects - ActiveCampaign Mailer\";s:10:\"short_name\";s:14:\"ActiveCampaign\";s:7:\"version\";s:5:\"3.0.3\";s:6:\"tested\";s:5:\"4.9.5\";s:4:\"slug\";s:23:\"connects-activecampaign\";s:13:\"product_image\";s:76:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Active-Campaign.png\";s:11:\"description\";s:81:\"Integrate ActiveCampaign with Connects for Email marketing, Marketing Automation.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"3.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:3;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:13:\"connects-emma\";s:4:\"init\";s:33:\"connects-myemma/connects-emma.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:19:\"connects-myemma.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Connects - My Emma Mailer\";s:10:\"short_name\";s:7:\"My Emma\";s:7:\"version\";s:5:\"1.0.2\";s:6:\"tested\";s:5:\"4.6.1\";s:4:\"slug\";s:15:\"connects-myemma\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2016/03/MyEmma.png\";s:11:\"description\";s:48:\"Integrate with My Emma Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:4;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:18:\"connects-mailchimp\";s:4:\"init\";s:41:\"connects-mailchimp/connects-mailchimp.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:22:\"connects-mailchimp.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:27:\"Connects - MailChimp Mailer\";s:10:\"short_name\";s:9:\"MailChimp\";s:7:\"version\";s:5:\"2.2.1\";s:6:\"tested\";s:5:\"4.9.6\";s:4:\"slug\";s:18:\"connects-mailchimp\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Mailchimp.png\";s:11:\"description\";s:52:\"Integration with MailChimp Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:5;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-hubspot\";s:4:\"init\";s:37:\"connects-hubspot/connects-hubspot.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-hubspot.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Connects - HubSpot Mailer\";s:10:\"short_name\";s:7:\"HubSpot\";s:7:\"version\";s:5:\"1.1.2\";s:6:\"tested\";s:5:\"4.9.7\";s:4:\"slug\";s:16:\"connects-hubspot\";s:13:\"product_image\";s:68:\"//support.brainstormforce.com/wp-content/uploads/2016/03/hubspot.png\";s:11:\"description\";s:62:\"Integration with HubSpot Inbound Marketing and Sales Software.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:6;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:17:\"connects-icontact\";s:4:\"init\";s:39:\"connects-icontact/connects-icontact.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"connects-icontact.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - iContact Mailer\";s:10:\"short_name\";s:8:\"iContact\";s:7:\"version\";s:5:\"1.1.0\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:17:\"connects-icontact\";s:13:\"product_image\";s:69:\"//support.brainstormforce.com/wp-content/uploads/2016/03/iContact.png\";s:11:\"description\";s:51:\"Integration with iContact Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:7;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:15:\"connects-aweber\";s:4:\"init\";s:35:\"connects-aweber/connects-aweber.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:19:\"connects-aweber.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Connects - Aweber Mailer\";s:10:\"short_name\";s:7:\"AWeber \";s:7:\"version\";s:5:\"2.1.3\";s:6:\"tested\";s:5:\"4.9.5\";s:4:\"slug\";s:15:\"connects-aweber\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2016/03/AWEBER.png\";s:11:\"description\";s:58:\"Integration with AWeber Email Marketing and Autoresponder.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.1.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:8;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:24:\"connects-campaignmonitor\";s:4:\"init\";s:53:\"connects-campaignmonitor/connects-campaignmonitor.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:28:\"connects-campaignmonitor.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:34:\"Connects - Campaign Monitor Mailer\";s:10:\"short_name\";s:16:\"Campaign Monitor\";s:7:\"version\";s:5:\"1.1.1\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:24:\"connects-campaignmonitor\";s:13:\"product_image\";s:76:\"//support.brainstormforce.com/wp-content/uploads/2016/03/CampaignMonitor.png\";s:11:\"description\";s:50:\"Integration with Campaign Monitor Email Marketing.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:9;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:18:\"connects-sendreach\";s:4:\"init\";s:41:\"connects-sendreach/connects-sendreach.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:22:\"connects-sendreach.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:27:\"Connects - SendReach Mailer\";s:10:\"short_name\";s:9:\"SendReach\";s:7:\"version\";s:5:\"1.1.0\";s:6:\"tested\";s:5:\"4.6.1\";s:4:\"slug\";s:18:\"connects-sendreach\";s:13:\"product_image\";s:73:\"//support.brainstormforce.com/wp-content/uploads/2016/03/SendReach150.png\";s:11:\"description\";s:43:\"Integration with SendReach Email Marketing.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:10;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:19:\"connects-sendinblue\";s:4:\"init\";s:43:\"connects-sendinblue/connects-sendinblue.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:23:\"connects-sendinblue.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:28:\"Connects - SendinBlue Mailer\";s:10:\"short_name\";s:10:\"SendinBlue\";s:7:\"version\";s:5:\"2.1.3\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:19:\"connects-sendinblue\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2016/03/sendinblue.png\";s:11:\"description\";s:66:\"Integrate with SendinBlue Online Email Marketing & SMS Marketing .\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.1.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:11;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:19:\"connects-mailerlite\";s:4:\"init\";s:43:\"connects-mailerlite/connects-mailerlite.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:23:\"connects-mailerlite.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:28:\"Connects - MailerLite Mailer\";s:10:\"short_name\";s:10:\"MailerLite\";s:7:\"version\";s:5:\"2.2.2\";s:6:\"tested\";s:3:\"4.8\";s:4:\"slug\";s:19:\"connects-mailerlite\";s:13:\"product_image\";s:73:\"//support.brainstormforce.com/wp-content/uploads/2016/03/MailerLite-1.png\";s:11:\"description\";s:64:\"Integrate with MailerLite Email Marketing software and Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:12;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:20:\"connects-getresponse\";s:4:\"init\";s:45:\"connects-getresponse/connects-getresponse.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:24:\"connects-getresponse.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:29:\"Connects - GetResponse Mailer\";s:10:\"short_name\";s:11:\"GetResponse\";s:7:\"version\";s:5:\"2.2.0\";s:6:\"tested\";s:5:\"4.9.2\";s:4:\"slug\";s:20:\"connects-getresponse\";s:13:\"product_image\";s:78:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Get-Response-Logo.png\";s:11:\"description\";s:72:\"Integration with GetResponse Email Marketing software and Autoresponder.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:13;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:24:\"connects-constantcontact\";s:4:\"init\";s:53:\"connects-constantcontact/connects-constantcontact.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:28:\"connects-constantcontact.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:34:\"Connects - Constant Contact Mailer\";s:10:\"short_name\";s:16:\"Constant Contact\";s:7:\"version\";s:5:\"2.2.0\";s:6:\"tested\";s:5:\"4.7.2\";s:4:\"slug\";s:24:\"connects-constantcontact\";s:13:\"product_image\";s:77:\"//support.brainstormforce.com/wp-content/uploads/2016/03/constant-contact.png\";s:11:\"description\";s:59:\"Integration with Constant Contact Email Marketing Software.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:14;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:18:\"connects-totalsend\";s:4:\"init\";s:41:\"connects-totalsend/connects-totalsend.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:22:\"connects-totalsend.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:27:\"Connects - TotalSend Mailer\";s:10:\"short_name\";s:9:\"TotalSend\";s:7:\"version\";s:5:\"2.0.3\";s:6:\"tested\";s:5:\"4.6.1\";s:4:\"slug\";s:18:\"connects-totalsend\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2016/03/TotalSend.png\";s:11:\"description\";s:70:\"Integrate TotalSend with Connects to collect lead and email marketing.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:15;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:19:\"connects-convertkit\";s:4:\"init\";s:43:\"connects-convertkit/connects-convertkit.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:23:\"connects-convertkit.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:28:\"Connects - ConvertKit Mailer\";s:10:\"short_name\";s:10:\"ConvertKit\";s:7:\"version\";s:5:\"2.2.1\";s:6:\"tested\";s:5:\"4.9.7\";s:4:\"slug\";s:19:\"connects-convertkit\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2016/03/ConvertKit.png\";s:11:\"description\";s:55:\"Integration with ConvertKit Email Marketing Automation.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:16;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:19:\"connects-simplycast\";s:4:\"init\";s:43:\"connects-simplycast/connects-simplycast.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:23:\"connects-simplycast.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:28:\"Connects - SimplyCast Mailer\";s:10:\"short_name\";s:10:\"SimplyCast\";s:7:\"version\";s:5:\"2.0.2\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:19:\"connects-simplycast\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2016/03/SimplYcast.png\";s:11:\"description\";s:55:\"Integration with SimplyCast Email Marketing Automation.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.0.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:17;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-campayn\";s:4:\"init\";s:37:\"connects-campayn/connects-campayn.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-campayn.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Connects - Campayn Mailer\";s:10:\"short_name\";s:7:\"Campayn\";s:7:\"version\";s:5:\"2.1.0\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:16:\"connects-campayn\";s:13:\"product_image\";s:68:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Campayn.png\";s:11:\"description\";s:57:\"Integration with Campayn Simple Email Marketing solution.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.1.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:18;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:17:\"connects-mailpoet\";s:4:\"init\";s:39:\"connects-mailpoet/connects-mailpoet.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"connects-mailpoet.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - MailPoet Mailer\";s:10:\"short_name\";s:8:\"MailPoet\";s:7:\"version\";s:5:\"2.2.1\";s:6:\"tested\";s:5:\"4.9.4\";s:4:\"slug\";s:17:\"connects-mailpoet\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2016/03/MailPoet2.png\";s:11:\"description\";s:38:\"Integration with MailPoet Newsletters.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:19;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:21:\"connects-infusionsoft\";s:4:\"init\";s:47:\"connects-infusionsoft/connects-infusionsoft.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:25:\"connects-infusionsoft.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:30:\"Connects - Infusionsoft Mailer\";s:10:\"short_name\";s:12:\"Infusionsoft\";s:7:\"version\";s:5:\"2.2.2\";s:6:\"tested\";s:5:\"4.9.5\";s:4:\"slug\";s:21:\"connects-infusionsoft\";s:13:\"product_image\";s:80:\"//support.brainstormforce.com/wp-content/uploads/2016/03/InfusionSoft150x150.png\";s:11:\"description\";s:46:\"Integration with Infusionsoft Email Marketing.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:20;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-mailjet\";s:4:\"init\";s:37:\"connects-mailjet/connects-mailjet.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-mailjet.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Connects - Mailjet Mailer\";s:10:\"short_name\";s:7:\"Mailjet\";s:7:\"version\";s:5:\"2.1.2\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:15:\"connect-mailjet\";s:13:\"product_image\";s:73:\"//support.brainstormforce.com/wp-content/uploads/2016/03/mailjet-logo.png\";s:11:\"description\";s:53:\"Integrate with Mailjet Bulk Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.1.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:21;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:23:\"connects-benchmarkemail\";s:4:\"init\";s:51:\"connects-benchmarkemail/connects-benchmarkemail.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:27:\"connects-benchmarkemail.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:33:\"Connects - Benchmark Email Mailer\";s:10:\"short_name\";s:15:\"Benchmark Email\";s:7:\"version\";s:5:\"2.0.3\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:23:\"connects-benchmarkemail\";s:13:\"product_image\";s:62:\"//support.brainstormforce.com/wp-content/uploads/2017/07/1.png\";s:11:\"description\";s:52:\"Integration with Benchmark Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:22;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:20:\"connects-cleverreach\";s:4:\"init\";s:45:\"connects-cleverreach/connects-cleverreach.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:24:\"connects-cleverreach.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:29:\"Connects - CleverReach Mailer\";s:10:\"short_name\";s:11:\"CleverReach\";s:7:\"version\";s:5:\"2.3.1\";s:6:\"tested\";s:5:\"4.8.3\";s:4:\"slug\";s:20:\"connects-cleverreach\";s:13:\"product_image\";s:72:\"//support.brainstormforce.com/wp-content/uploads/2016/03/cleverreach.png\";s:11:\"description\";s:53:\"Integration with CleverReach Email Marketing sofware.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.3.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:23;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:14:\"convertplug-vc\";s:4:\"init\";s:33:\"convertplug-vc/convertplug-vc.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:18:\"convertplug-vc.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:44:\"ConvertPlus Addons for WPBakery Page Builder\";s:10:\"short_name\";s:21:\"WPBakery Page Builder\";s:7:\"version\";s:5:\"2.0.2\";s:6:\"tested\";s:5:\"4.9.5\";s:4:\"slug\";s:14:\"convertplug-vc\";s:13:\"product_image\";s:91:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Convert-plug-Addon-for-VC-Logo.png\";s:11:\"description\";s:51:\"Easy to use form builder for WPBakery Page Builder.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.0.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:24;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:23:\"connects-contact-form-7\";s:4:\"init\";s:51:\"connects-contact-form-7/connects-contact-form-7.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:27:\"connects-contact-form-7.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Connects - Contact Form 7\";s:10:\"short_name\";s:14:\"Contact Form 7\";s:7:\"version\";s:5:\"1.1.1\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:23:\"connects-contact-form-7\";s:13:\"product_image\";s:75:\"//support.brainstormforce.com/wp-content/uploads/2016/03/contact-form-7.png\";s:11:\"description\";s:34:\"Collect leads from Contact Form 7.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:25;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:20:\"connects-woocommerce\";s:4:\"init\";s:50:\"connects-woocommerce/connects-woocommerce-form.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:24:\"connects-woocommerce.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:20:\"Connects WooCommerce\";s:10:\"short_name\";s:20:\"Connects WooCommerce\";s:7:\"version\";s:5:\"1.1.2\";s:6:\"tested\";s:5:\"4.9.7\";s:4:\"slug\";s:20:\"connects-woocommerce\";s:13:\"product_image\";s:76:\"//support.brainstormforce.com/wp-content/uploads/2017/07/woocom-checkout.png\";s:11:\"description\";s:46:\"Collect leads from WooCommerce checkout forms.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:58:\"https://changelog.brainstormforce.com/connects-woocommerce\";}i:26;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:24:\"connects-wp-comment-form\";s:4:\"init\";s:53:\"connects-wp-comment-form/connects-wp-comment-form.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:28:\"connects-wp-comment-form.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - WP Comment Form\";s:10:\"short_name\";s:15:\"WP Comment Form\";s:7:\"version\";s:5:\"1.0.3\";s:6:\"tested\";s:5:\"4.7.1\";s:4:\"slug\";s:24:\"connects-wp-comment-form\";s:13:\"product_image\";s:76:\"//support.brainstormforce.com/wp-content/uploads/2016/03/WP-Comment-Form.png\";s:11:\"description\";s:42:\"Collect leads from WordPress Comment Form.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:27;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:29:\"connects-wp-registration-form\";s:4:\"init\";s:63:\"connects-wp-registration-form/connects-wp-registration-form.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:33:\"connects-wp-registration-form.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:31:\"Connects - WP Registration Form\";s:10:\"short_name\";s:20:\"WP Registration Form\";s:7:\"version\";s:5:\"1.0.3\";s:6:\"tested\";s:5:\"4.6.1\";s:4:\"slug\";s:29:\"connects-wp-registration-form\";s:13:\"product_image\";s:79:\"//support.brainstormforce.com/wp-content/uploads/2016/03/WP-gistration-Form.png\";s:11:\"description\";s:47:\"Collect leads from WordPress Registration Form.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:28;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:18:\"connects-ontraport\";s:4:\"init\";s:41:\"connects-ontraport/connects-ontraport.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:22:\"connects-ontraport.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:27:\"Connects - OntraPort Mailer\";s:10:\"short_name\";s:9:\"ONTRAPORT\";s:7:\"version\";s:5:\"1.0.1\";s:6:\"tested\";s:5:\"4.6.1\";s:4:\"slug\";s:18:\"connects-ontraport\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2016/03/ONTRAPORT.png\";s:11:\"description\";s:47:\"Integrate ONTRAPORT Email Marketing Automation.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:29;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:26:\"connects-mautic-form-addon\";s:4:\"init\";s:57:\"connects-mautic-form-addon/connects-mautic-form-addon.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:30:\"connects-mautic-form-addon.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects Mautic Form Addon\";s:10:\"short_name\";s:6:\"Mautic\";s:7:\"version\";s:5:\"1.0.3\";s:6:\"tested\";s:3:\"4.8\";s:4:\"slug\";s:26:\"connects-mautic-form-addon\";s:13:\"product_image\";s:65:\"//support.brainstormforce.com/wp-content/uploads/2017/02/logo.png\";s:11:\"description\";s:53:\"Integration with Mautic Marketing Automation Platform\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:0:\"\";}i:30;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:13:\"connects-drip\";s:4:\"init\";s:31:\"connects-drip/connects-drip.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:17:\"connects-drip.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:22:\"Connects - Drip Mailer\";s:10:\"short_name\";s:4:\"Drip\";s:7:\"version\";s:5:\"1.0.1\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:13:\"connects-drip\";s:13:\"product_image\";s:65:\"//support.brainstormforce.com/wp-content/uploads/2017/03/logo.png\";s:11:\"description\";s:52:\"Integration with Drip Marketing Automation Platform.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:0:\"\";}i:31;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:14:\"connects-sendy\";s:4:\"init\";s:33:\"connects-sendy/connects-sendy.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:18:\"connects-sendy.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:23:\"Connects - Sendy Mailer\";s:10:\"short_name\";s:5:\"Sendy\";s:7:\"version\";s:5:\"2.1.3\";s:6:\"tested\";s:5:\"4.9.6\";s:4:\"slug\";s:14:\"connects-sendy\";s:13:\"product_image\";s:66:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Sendy.png\";s:11:\"description\";s:46:\"Integration with Sendy Newsletter Application.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.1.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:32;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-mailget\";s:4:\"init\";s:37:\"connects-mailget/connects-mailget.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-mailget.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:22:\"Connects MailGet Addon\";s:10:\"short_name\";s:7:\"MailGet\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:3:\"4.8\";s:4:\"slug\";s:16:\"connects-mailget\";s:13:\"product_image\";s:65:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo.png\";s:11:\"description\";s:50:\"Integration with MailGet Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:33;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-mailgun\";s:4:\"init\";s:37:\"connects-mailgun/connects-mailgun.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-mailgun.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"Connects - Mailgun\";s:10:\"short_name\";s:7:\"Mailgun\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:3:\"4.8\";s:4:\"slug\";s:16:\"connects-mailgun\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-1.png\";s:11:\"description\";s:48:\"Integrate with Mailgun Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:34;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-klaviyo\";s:4:\"init\";s:37:\"connects-klaviyo/connects-klaviyo.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-klaviyo.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Connects - Klaviyo Addon\";s:10:\"short_name\";s:8:\"Klaviyo \";s:7:\"version\";s:5:\"1.0.2\";s:6:\"tested\";s:5:\"4.9.5\";s:4:\"slug\";s:16:\"connects-klaviyo\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-2.png\";s:11:\"description\";s:54:\"Use this plugin to integrate Klaviyo with Convert Plus\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:35;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:17:\"connects-sendlane\";s:4:\"init\";s:39:\"connects-sendlane/connects-sendlane.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"connects-sendlane.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - Sendlane Mailer\";s:10:\"short_name\";s:8:\"Sendlane\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:5:\"4.9.2\";s:4:\"slug\";s:17:\"connects-sendlane\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-3.png\";s:11:\"description\";s:42:\"Integration with Sendlane Email Marketing.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:36;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:20:\"connects-elasticmail\";s:4:\"init\";s:47:\"connects-elasticmail/connects-elastic-email.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:24:\"connects-elasticmail.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Connects - Elastic Email\";s:10:\"short_name\";s:13:\"Elastic Email\";s:7:\"version\";s:5:\"1.0.1\";s:6:\"tested\";s:5:\"4.9.6\";s:4:\"slug\";s:20:\"connects-elasticmail\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-4.png\";s:11:\"description\";s:38:\"Integrate with Elastic Email Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:0:\"\";}i:37;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:17:\"connects-mailwizz\";s:4:\"init\";s:39:\"connects-mailwizz/connects-mailwizz.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"connects-mailwizz.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - MailWizz Mailer\";s:10:\"short_name\";s:8:\"MailWizz\";s:7:\"version\";s:5:\"1.0.2\";s:6:\"tested\";s:5:\"4.9.6\";s:4:\"slug\";s:17:\"connects-mailwizz\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-5.png\";s:11:\"description\";s:65:\"Integrate MailWizz email Marketing application with Convert Plus.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:38;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:17:\"connects-sendgrid\";s:4:\"init\";s:39:\"connects-sendgrid/connects-sendgrid.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"connects-sendgrid.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - SendGrid Mailer\";s:10:\"short_name\";s:8:\"SendGrid\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:5:\"4.9.6\";s:4:\"slug\";s:17:\"connects-sendgrid\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-6.png\";s:11:\"description\";s:51:\"Integration with SendGrid email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:0:\"\";}i:39;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:15:\"connects-zapier\";s:4:\"init\";s:35:\"connects-zapier/connects-zapier.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:19:\"connects-zapier.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Connects - Zapier Mailer\";s:10:\"short_name\";s:7:\"Zapier \";s:7:\"version\";s:5:\"1.0.1\";s:6:\"tested\";s:5:\"4.9.8\";s:4:\"slug\";s:15:\"connects-zapier\";s:13:\"product_image\";s:82:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-7-e1534416295165.png\";s:11:\"description\";s:31:\"Integrate Zapier with connects.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:0:\"\";}i:40;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:19:\"connects-convertfox\";s:4:\"init\";s:43:\"connects-convertfox/connects-convertfox.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:23:\"connects-convertfox.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:21:\"Connects - ConvertFox\";s:10:\"short_name\";s:10:\"ConvertFox\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:5:\"4.9.7\";s:4:\"slug\";s:19:\"connects-convertfox\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-8.png\";s:11:\"description\";s:32:\"Collect leads using Convert Fox.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}}}", "yes");
INSERT INTO `myevntl_options` VALUES("3063", "wplc_stats", "a:2:{s:14:\"chat_dashboard\";a:3:{s:5:\"views\";i:10;s:13:\"last_accessed\";s:19:\"2017-05-09 05:41:29\";s:14:\"first_accessed\";s:19:\"2017-03-06 12:04:35\";}s:8:\"settings\";a:3:{s:5:\"views\";i:43;s:13:\"last_accessed\";s:19:\"2017-05-09 05:39:28\";s:14:\"first_accessed\";s:19:\"2017-03-06 12:05:22\";}}", "yes");
INSERT INTO `myevntl_options` VALUES("3064", "WPLC_FIRST_TIME_TUTORIAL", "1", "yes");
INSERT INTO `myevntl_options` VALUES("3069", "WPLC_POWERED_BY", "0", "yes");
INSERT INTO `myevntl_options` VALUES("3070", "WPLC_CUSTOM_CSS", "#wplc_hovercard {<br />\r\n    right: 50px;<br />\r\n}<br />\r\n#wp-live-chat-header {<br />\r\n    margin-right: -25px;<br />\r\n}<br />\r\n#wplc_na_msg_btn {<br />\r\n    color: #fff !important;<br />\r\n}<br />\r\n", "yes");
INSERT INTO `myevntl_options` VALUES("3071", "WPLC_CUSTOM_JS", "", "yes");
INSERT INTO `myevntl_options` VALUES("3072", "WPLC_SURVEY_SETTINGS", "a:4:{s:19:\"wplc_enable_surveys\";i:0;s:6:\"survey\";N;s:11:\"survey_user\";N;s:14:\"survey_display\";s:1:\"1\";}", "yes");
INSERT INTO `myevntl_options` VALUES("3073", "WPLC_GA_SETTINGS", "a:1:{s:14:\"wplc_enable_ga\";s:1:\"1\";}", "yes");
INSERT INTO `myevntl_options` VALUES("3074", "WPLC_BANNED_IP_ADDRESSES", "s:17:\"a:1:{i:0;s:0:\"\";}\";", "yes");
INSERT INTO `myevntl_options` VALUES("3075", "wplc_advanced_settings", "a:2:{s:15:\"wplc_iterations\";s:2:\"20\";s:24:\"wplc_delay_between_loops\";s:7:\"1000000\";}", "yes");
INSERT INTO `myevntl_options` VALUES("3076", "wplc_mail_type", "wp_mail", "yes");
INSERT INTO `myevntl_options` VALUES("3077", "wplc_mail_host", "", "yes");
INSERT INTO `myevntl_options` VALUES("3078", "wplc_mail_port", "", "yes");
INSERT INTO `myevntl_options` VALUES("3079", "wplc_mail_username", "My Eventology Admin", "yes");
INSERT INTO `myevntl_options` VALUES("3080", "wplc_mail_password", "WAMx#N3RvJQx^9oc57", "yes");
INSERT INTO `myevntl_options` VALUES("3186", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"info@cebuwebconcepts.com\";s:7:\"version\";s:5:\"4.7.4\";s:9:\"timestamp\";i:1492746101;}", "no");
INSERT INTO `myevntl_options` VALUES("33930", "_site_transient_timeout_browser_c89882595a0b6fb065599d15013dcdb5", "1520389363", "no");
INSERT INTO `myevntl_options` VALUES("33931", "_site_transient_browser_c89882595a0b6fb065599d15013dcdb5", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"63.0.3239.132\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `myevntl_options` VALUES("55484", "rs-templates-new", "", "no");
INSERT INTO `myevntl_options` VALUES("38286", "_site_transient_timeout_browser_cffcb8140921e0d14b31935178051df3", "1523431145", "no");
INSERT INTO `myevntl_options` VALUES("38287", "_site_transient_browser_cffcb8140921e0d14b31935178051df3", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"65.0.3325.181\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `myevntl_options` VALUES("39293", "_site_transient_timeout_browser_f486628b8b3cd381d361bdc25237d08d", "1524015847", "no");
INSERT INTO `myevntl_options` VALUES("39294", "_site_transient_browser_f486628b8b3cd381d361bdc25237d08d", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"65.0.3325.181\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `myevntl_options` VALUES("14604", "_site_transient_timeout_browser_ba081c70c62b1a73f7586809b37ba98f", "1500448342", "no");
INSERT INTO `myevntl_options` VALUES("14605", "_site_transient_browser_ba081c70c62b1a73f7586809b37ba98f", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"59.0.3071.115\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "no");
INSERT INTO `myevntl_options` VALUES("55570", "_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1536684972", "no");
INSERT INTO `myevntl_options` VALUES("55571", "_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"\n	Mon, 03 Sep 2018 11:00:43 +0000	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.0-alpha-43631\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"The Month in WordPress: August 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2018/09/the-month-in-wordpress-august-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Sep 2018 11:00:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6191\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:355:\"Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August. WordPress 4.9.8 is Released WordPress 4.9.8 was [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5554:\"<p>Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>WordPress 4.9.8 is Released</h2>\n\n<p><a href=\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\">WordPress 4.9.8 was released</a> at the beginning of the month. While this was a maintenance release fixing 46 bugs, it was significant for Core development because it made a point of highlighting Gutenberg — the new WordPress editor that is currently in development (more on that below).<br /></p>\n\n<p>This release also included some important updates to the privacy tools that were added to Core earlier this year.<br /></p>\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>New WordPress Editor Development Continues</h2>\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/08/31/whats-new-in-gutenberg-31st-august/\">The latest version</a> features a number of important user experience improvements, including a new unified toolbar and support for a more focussed writing mode.<br /></p>\n\n<p>Users can test Gutenberg right now by installing <a href=\"https://wordpress.org/plugins/gutenberg/\">the plugin</a>, which currently has nearly 300,000 active installs. Along with that, <a href=\"https://wordpress.org/gutenberg/handbook/reference/faq/\">the Gutenberg Handbook</a> has some very useful information about how to use and develop for the new editor.<br /></p>\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg/\">the #gutenberg tag on the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Planning Begins for the Next Global WordPress Translation Day</h2>\n\n<p>The Global WordPress Translation Day is a 24-hour event held online and all across the world. It is designed to bring communities together to translate WordPress into their local languages, and to help them connect with other communities doing the same thing.<br /></p>\n\n<p>There have been three Translation Days since April 2016, and <a href=\"https://make.wordpress.org/polyglots/2018/08/29/global-wordpress-translation-day-4-preliminary-planning/\">the fourth edition is in the planning stages now</a>. The Polyglots team, who organizes these events, is currently looking for input on the date, format, and content for the event and would love some feedback from the community.<br /></p>\n\n<p>Want to get involved in translating WordPress into your own language? Follow <a href=\"https://make.wordpress.org/polyglots/\">the Polyglots team blog</a> and join the #polyglots channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.<br /></p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li><a href=\"https://wordpress.org/support/upgrade-php/\">The Update PHP page on WordPress.org</a> has been revised and improved to make the reasons for upgrading more clear.</li><li>The Mobile team is looking for people to help test the latest versions of the <a href=\"https://make.wordpress.org/mobile/2018/08/29/call-for-testing-wordpress-for-android-10-8/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2018/08/28/call-for-testing-wordpress-for-ios-10-8/\">iOS</a> apps for WordPress.</li><li><a href=\"https://wordbits.io/\">WordBits</a> is a innovative new platform for publishing WordPress-based code snippets with the ability to download each snippet as a working plugin.</li><li>The Community Team <a href=\"https://make.wordpress.org/community/2018/08/27/wordcamp-incubator-2018-update-thread-august-edition/\">has some updates</a> about how things are going with this year’s WordCamp Incubator program.</li><li>The WordPress Support Forums <a href=\"https://make.wordpress.org/support/2018/08/august-16th-support-team-meeting-summary/\">now include a feature</a> allowing forum volunteers to easily report a post to the moderators for a follow-up.</li><li>WordCamp Kochi, India <a href=\"https://2018.kochi.wordcamp.org/wordcamp-kochi-2018-is-postponed-to-november-3rd-2018-saturday/\">has unfortunately had to postpone their event</a> due to floods in the region.</li><li><a href=\"http://www.wpglossary.net/\">WP Glossary</a> is a new site that offers helpful definitions of words that you could encounter when using WordPress.</li><li>A few WordPress community members <a href=\"https://make.wordpress.org/community/2018/08/13/in-the-words-of-the/\">have started a working group</a> to tackle the idea of building diverse WordPress  communities all across the world.</li><li>A new <a href=\"https://editorblockswp.com/library/\">Gutenberg Block Library</a> is available, listing the details of the many blocks available for the new editor.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6191\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 4.9.8 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2018 21:25:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6165\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:398:\"We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme. Following are the highlights of what is now available. “Try Gutenberg” callout Most users will now be presented with a notice in their WordPress dashboard. This “Try Gutenberg” [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Paul Biron\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10398:\"<p>We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme.</p>\n<p><span style=\"font-weight: 400\">Following are the highlights of what is now available.</span></p>\n<h2>“Try Gutenberg” callout</h2>\n<p><span style=\"font-weight: 400\">Most users will now be presented with a notice in their WordPress dashboard. This </span>“Try Gutenberg” is an opportunity for users to use the Gutenberg block editor before it is released in WordPress 5.0.</p>\n<p><img class=\"alignnone wp-image-6168 size-full\" src=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=632%2C392&#038;ssl=1\" alt=\"\" width=\"632\" height=\"392\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=2528&amp;ssl=1 2528w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=300%2C186&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=768%2C476&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=1024%2C634&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>In WordPress 4.9.8, the callout will be shown to the following users:</p>\n<ul>\n<li>If Gutenberg <em>is not</em> installed or activated, the callout will be shown to Admin users on single sites, and Super Admin users on multisites.</li>\n<li>If Gutenberg <em>is</em> installed and activated, the callout will be shown to Contributor users and above.</li>\n<li>If the Classic Editor plugin is installed and activated, the callout will be hidden for all users.</li>\n</ul>\n<p class=\"entry-title\"><span style=\"font-weight: 400\">You can learn more by reading  </span><a href=\"https://make.wordpress.org/core/2018/08/02/try-gutenberg-callout-in-wordpress-4-9-8/\">“Try Gutenberg” Callout in WordPress 4.9.8</a>.</p>\n<h2>Privacy fixes/enhancements</h2>\n<p>This release includes 18 Privacy fixes focused on ensuring consistency and flexibility in the new personal data tools <span style=\"font-weight: 400\">that were </span>added in 4.9.6, including:</p>\n<ul>\n<li>The type of request being confirmed is now included in the subject line for all privacy confirmation emails.</li>\n<li>Improved consistency with site name being used for privacy emails in multisite.</li>\n<li>Pagination for Privacy request admin screens can now be adjusted.</li>\n<li>Increased the test coverage for several core privacy functions.</li>\n</ul>\n<p><a href=\"https://make.wordpress.org/core/2018/08/02/wordpress-4-9-8/\">This post has more information about all of the issues fixed in 4.9.8 if you&#8217;d like to learn more</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.8</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n<p>Thank you to everyone who contributed to WordPress 4.9.8:</p>\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">Abdullah Ramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/allendav/\">Allen Snook</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewtaylor-1/\">Andrew Taylor</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/chrislema/\">Chris Lema</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danieltj/\">Daniel James</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dontstealmyfish/\">dontstealmyfish</a>, <a href=\"https://profiles.wordpress.org/dyrer/\">dyrer</a>, <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fclaussen/\">Fernando Claussen</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/gm_alex/\">GM_Alex</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">JJJ</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/joshuawold/\">JoshuaWold</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">kjellr</a>, <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a>, <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mensmaximus/\">mensmaximus</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/michelleweber/\">michelleweber</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/xpertone/\">Muhammad Kashif</a>, <a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a>, <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>, <a href=\"https://profiles.wordpress.org/presstigers/\">PressTigers</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/rafsuntaskin/\">Rafsun Chowdhury</a>, <a href=\"https://profiles.wordpress.org/redcastor/\">redcastor</a>, <a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/pross/\">Simon Prosser</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/spyderbytes/\">spyderbytes</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a>, <a href=\"https://profiles.wordpress.org/timbowesohft/\">timbowesohft</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/usmankhalid/\">Usman Khalid</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6165\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: July 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/08/the-month-in-wordpress-july-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Aug 2018 09:11:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6158\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:333:\"With WordPress 5.0 coming closer, there’s lots of work going on all across the project. Read on to learn about how we progressed in July. Release of WordPress 4.9.7 On July 5, WordPress 4.9.7 was released,  fixing one security issue and 17 other bugs across the platform. While this is a minor release, incremental fixes [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6411:\"<p>With WordPress 5.0 coming closer, there’s lots of work going on all across the project. Read on to learn about how we progressed in July.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Release of WordPress 4.9.7</h2>\n\n<p>On July 5, <a href=\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\">WordPress 4.9.7 was released</a>,  fixing one security issue and 17 other bugs across the platform.<br /></p>\n\n<p>While this is a minor release, incremental fixes are essential to keep WordPress running smoothly. Everyone is encouraged to update as soon as possible and to make sure that automatic updates are switched on.<br /></p>\n\n<p>Would you like to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>The New WordPress Editor</h2>\n\n<p>In the upcoming minor release of WordPress, 4.9.8, a new section in the dashboard will feature Gutenberg, the upcoming content editor for WordPress.<br /></p>\n\n<p>While the official release of Gutenberg <a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">is scheduled</a> for the coming months, you can already install it as <a href=\"https://wordpress.org/plugins/gutenberg/\">a plugin</a> to test it out right now. Additionally, <a href=\"https://wordpress.org/gutenberg/\">a brand new demo page</a> is now available — play around with the many features the editor has to offer, without installing it on your own site.<br /></p>\n\n<p>Would you like to help build or test Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Page Design Updates on WordPress.org</h2>\n\n<p>Bit by bit we’re refreshing the design of WordPress.org. The latest pages to get a new treatment have been <a href=\"https://wordpress.org/download/\">the Download page</a> and <a href=\"https://profiles.wordpress.org/matt/\">user profiles</a>.<br /></p>\n\n<p>The Meta and Design teams worked hard to make these new designs a reality, with notable contributions from <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/obenland/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>obenland</a>, <a href=\'https://profiles.wordpress.org/mapk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mapk</a>, and <a href=\'https://profiles.wordpress.org/kjellr/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kjellr</a>. The new designs enhance the overall look of the site and provide more relevant information to those searching.<br /></p>\n\n<p>Would you like to get involved in the design refresh? Follow the <a href=\"https://make.wordpress.org/meta/\">Meta</a> and <a href=\"https://make.wordpress.org/design/\">Design</a> team blogs and join the #meta and #design channels in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>The First WP-CLI Hack Day</h2>\n\n<p>On Friday July 20, the WP-CLI team <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">held their first hack day</a> — a global event encouraging people to contribute to the official command line tool for WordPress.<br /></p>\n\n<p>Run by <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a>, the event <a href=\"https://make.wordpress.org/cli/2018/07/21/wp-cli-hack-day-results/\"> was a great success</a>. Twelve pull requests were  merged and another 13 submitted. It also included a video chat to give all contributors a space to meet each other and connect directly.<br /></p>\n\n<p>Would  you like to get involved in contributing to WP-CLI? Follow <a href=\"https://make.wordpress.org/cli/\">the team blog</a> and join the #cli channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li>The WordPress Foundation is <a href=\"https://wordpressfoundation.org/2018/call-for-organizers-introduction-to-open-source-workshops-for-2018/\">looking for local community organizers to run introductory open-source workshops</a> in 2018.</li><li><a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a> compiled <a href=\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\">updates for the last quarter</a> from the contribution teams all across the WordPress project.</li><li>In a great move for internationalization, <a href=\"https://en.blog.wordpress.com/2018/03/29/the-wordpress-mobile-apps-now-support-right-to-left-languages/\">the WordPress Mobile Apps now support right-to-left languages</a>.</li><li><a href=\"https://make.wordpress.org/community/2018/07/10/stripe-is-now-available-to-all-wordcamps/\">WordCamp events can now accept payment via Stripe</a> — PayPal remains an alternative option.</li><li>The WP-CLI team will soon <a href=\"https://make.wordpress.org/cli/2018/07/19/details-on-the-upcoming-major-release/\">release v2.0</a> of the official WordPress command line tool.</li><li>The Fields API project in WordPress Core <a href=\"https://wptavern.com/wordpress-core-fields-api-project-is-seeking-new-leadership\">is looking for a new lead</a> to drive it forward.</li><li>In WordPress 4.9.8, <a href=\"https://make.wordpress.org/core/2018/07/27/registering-metadata-in-4-9-8/\">it will  be possible</a> for developers to fully register the meta fields used by their plugins and themes.</li><li>After many years of hard work, <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards\">v1.0.0 of the WordPress Coding Standards for PHP_CodeSniffer</a> has been released.</li><li>The Mobile team <a href=\"https://make.wordpress.org/mobile/2018/07/31/call-for-testing-wordpress-for-ios-10-6/\">is looking for people to help test</a> v10.6 of WordPress for iOS.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6158\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Quarterly Updates | Q2 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jul 2018 14:50:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6140\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s listed representatives. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:15622:\"<p><em>To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s <a href=\"https://make.wordpress.org/updates/team-reps/\">listed representatives</a>. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to each team&#8217;s site in the headings.﻿</em></p>\n\n<h2><a href=\"https://make.wordpress.org/accessibility/\">Accessibility</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/rianrietveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rianrietveld</a>, <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/afercia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>afercia</a></li>\n	<li><strong>Priority</strong>: Working to make sure that Gutenberg is reasonably accessible prior to merge. ETA is before 5.0</li>\n	<li><strong>Struggle</strong>: Lack of developers and accessibility experts to help test and code the milestone issues. <em>The team is doing outreach to help solve this problem.</em></li>\n	<li><strong>Big Win</strong>: Interest from companies like The Paciello Group and Tenon.io to help out with Gutenberg code review and testing tools.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/cli/\">CLI</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: @danielbachhuber, <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a></li>\n	<li><strong>Priority</strong>: Very first global <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">Hack Day</a> is coming up July 20. Version 2.0.0 is still in progress (new <a href=\"https://github.com/wp-cli/wp-cli/issues/4752\">ETA</a> is end of July).</li>\n	<li><strong>Struggle</strong>: The team continues to need new contributors. The current team is tiny but tough.</li>\n	<li><strong>Big Win</strong>: WP-CLI is currently one of the project&#8217;s four main focuses, as mentioned in the Summer Update at WordCamp Europe.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/community/\">Community</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/francina/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>francina</a>, <a href=\'https://profiles.wordpress.org/hlashbrooke/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hlashbrooke</a></li>\n	<li><strong>Priority</strong>: Focusing on smoothing out the processes in our community management by building up our team of volunteers and establishing what tools we need to keep things running well. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: Our two biggest struggles at the moment are tracking what we need to get done, and making final decisions on things. <em>There is current work on the tools available to assist with tracking progress.﻿</em></li>\n	<li><strong>Big Win</strong>: After making a concerted effort to get more contributors on the Community Team, we now have a much larger group of volunteers working as deputies and WordCamp mentors</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/core/\">Core</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a></li>\n	<li><strong>Priority</strong>: Following the <a href=\"https://wordpress.tv/2018/07/04/matt-mullenweg-a-summertime-update-keynote-and-qa/\">WordCamp Europe summer update</a> ﻿(and the companion post <a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">here</a>), the team is getting Gutenberg (the new WordPress editing experience) into a strong state for the 5.0 release. Potential ETA as soon as August.</li>\n	<li><strong>Struggle</strong>: Coordinating momentum and direction as we start seeing more contributors offering their time. Still working our way through open issues. <em>﻿The team is starting multiple bug scrubs each week to work through these more quickly and transparently.</em></li>\n	<li><strong>Big Win</strong>: Had a <a href=\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\">sizable release in 4.9.6</a> which featured major updates around privacy tools and functionality in Core.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/design/\">Design</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/boemedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>boemedia</a>, <a href=\'https://profiles.wordpress.org/joshuawold/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joshuawold</a>, <a href=\'https://profiles.wordpress.org/mizejewski/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mizejewski</a></li>\n	<li><strong>Priority</strong>: Better on-boarding of new contributors, especially creating better documentation. ETA is end of July.</li>\n	<li><strong>Struggle</strong>: It&#8217;s hard to identify reasonably small tasks for first-time contributors.</li>\n	<li><strong>Big Win</strong>: The team is much more organized now which has helped clear out the design backlog, bring in new contributors, and also keep current contributors coming back. <em>Bonus: Joshua Wold will co-lead the upcoming release.</em></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/docs/\">Documentation</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/kenshino/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kenshino</a><br /></li>\n	<li><strong>Priority</strong>: Opening up the work on <a href=\"https://make.wordpress.org/docs/2018/02/26/state-of-helphub-february-2018/\">HelpHub</a> to new contributors and easing the onboarding process. No ETA.<br /></li>\n	<li><strong>Struggle</strong>: Some blockers with making sure the code and database can be ready to launch on https://wordpress.org/support/<br /></li>\n	<li><strong>Big Win</strong>: The <a href=\"https://wp-helphub.com/\">first phase of HelpHub</a> creation is complete, which means content updates (current info, more readable, easier discovery), internal search, design improvements, and REST API endpoints.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/hosting/\">Hosting</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/mikeschroder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mikeschroder</a>, <a href=\'https://profiles.wordpress.org/jadonn/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jadonn</a></li>\n	<li><strong>Priority</strong>: Preparing hosts for supporting Gutenberg, especially support questions they&#8217;re likely to see when the &#8220;Try Gutenberg&#8221; callout is released. ETA July 31st, then before WordPress 5.0<br /><strong></strong></li>\n	<li><strong>Struggle</strong>: Most contributions are still made a by a small team of volunteers. Seeing a few more people join, but progress is slow.<br /><strong></strong></li>\n	<li><strong>﻿Big Win</strong>: New team members and hosting companies have joined the #hosting-community team and have started contributing.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/marketing/\">Marketing</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bridgetwillard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bridgetwillard</a></li>\n	<li><strong>Priority</strong>: Continuing to write and publish case studies from the community. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: No current team struggles.</li>\n	<li><strong>Big Win</strong>: Wrote and designed a short <a href=\"https://make.wordpress.org/marketing/2018/04/24/contributor-day-onboarding-pdf/\">Contributor Day onboarding card</a>. It was used at Contributor Day at WCEU and onboarding time went down to 1 hour instead of 3 hours.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/meta/\">Meta</a> (WordPress.org Site)</h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/tellyworth/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tellyworth</a>, <a href=\'https://profiles.wordpress.org/coffee2code/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>coffee2code</a></li>\n	<li><strong>Priority</strong>: Reducing manual work around the contributor space (theme review, GDPR/privacy, plugin review). ETA for small wins is end of quarter, larger efforts after that.</li>\n	<li><strong>Struggle</strong>: Maintaining momentum on tickets. <em>There are also some discussions about updating the ticket management process across teams that use the Meta trac system.</em></li>\n	<li><strong>Big Win</strong>: The new About page launched and has been translated across most locale sites.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/mobile/\">Mobile</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/elibud/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>elibud</a></li>\n	<li><strong>Priority</strong>: Getting Gutenberg in the mobile applications. ETA is late December.</li>\n	<li><strong>Struggle</strong>: Consuming the Gutenberg source in the ReactNative app directly. <em>More info can be found here: https://make.wordpress.org/mobile/2018/07/09/next-steps-for-gutenberg-mobile/</em></li>\n	<li><strong>Big Win</strong>: The WordPress mobile applications now fully support right-to-left languages and are compliant with the latest standards for accessibility.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/plugins/\">Plugins</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/ipstenu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ipstenu</a></li>\n	<li><strong>Priority</strong>: Clearing ~8,000 unused plugins from the queues. Likely ETA is September.<br /></li>\n	<li><strong>Struggles</strong>: Had to triage a lot of false claims around plugins offering GDPR compliance.</li>\n	<li><strong>Big Win</strong>: Released 4.9.6 and <a href=\"https://make.wordpress.org/plugins/2018/05/17/wp-4-9-6-privacy-hooks-and-you/\">updated expectations</a> with plugin authors. Huge thanks to the Core Privacy team for their hard work on this.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/polyglots/\">Polyglots</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/petya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>petya</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/nao/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nao</a>, <a href=\'https://profiles.wordpress.org/chantalc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chantalc</a>, <a href=\'https://profiles.wordpress.org/deconf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>deconf</a>, <a href=\'https://profiles.wordpress.org/casiepa/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>casiepa</a></li>\n	<li><strong>Priority</strong>: Keep WordPress releases translated to 100% and then concentrate on the top 100 plugins and themes. ETA is ongoing.<br /><strong></strong></li>\n	<li><strong>﻿Struggle</strong>: Getting new PTEs fast enough, and complex tools/systems. Overall, the volume of strings awaiting approval.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/support/\">Support</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/clorith/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clorith</a></li>\n	<li><strong>Priority:</strong> Getting ready for the Gutenberg callout (it got pushed last quarter). Needing a better presence on the official support forums, and outreach for that is underway, ETA end of July. <br /></li>\n	<li><strong>Struggle</strong>: Keeping contributors participating post-contributor days/drives. <em>﻿Considering the creation of a dedicated post-contributor day survey to get some insight here.</em></li>\n	<li><strong>Big Win</strong>: The increase in international liaisons joining for weekly meetings, helping bring the wider support community together.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/themes/\">Theme Review</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/acosmin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>acosmin</a>, <a href=\'https://profiles.wordpress.org/rabmalin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rabmalin</a>, <a href=\'https://profiles.wordpress.org/thinkupthemes/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>thinkupthemes</a>, <a href=\'https://profiles.wordpress.org/williampatton/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>williampatton</a></li>\n	<li><strong>Priority</strong>: Building a better Theme Check/Sniffer in order to automate most of the checks done right now by reviewers. ETA late 2018, early 2019.</li>\n	<li><strong>Struggle</strong>: Bringing in new contributors to the team.</li>\n	<li><strong>Big Win</strong>: <a href=\"https://make.wordpress.org/themes/2018/04/30/trusted-authors-program/\">Trusted Authors program﻿</a></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/tide/\">Tide</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/valendesigns/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>valendesigns</a> (but usually <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>)</li>\n	<li><strong>Priority</strong>: Storing PHPCompatibilty results inside the WordPress.org API and building a UI to display those results, an endpoint to request an audit is required for this work to continue.</li>\n	<li><strong>Struggle</strong>: Development has dramatically slowed down while team members are on leave or pulled into internal client work.</li>\n	<li><strong>Big Win</strong>: Migration to Google Cloud Platform (GCP) from Amazon Web Services (AWS) is complete and the audit servers have all been rewritten in Go. (This allows us to be faster with greater capacity and less cost.)</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/training/\">Training</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bethsoderberg/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bethsoderberg</a>, <a href=\'https://profiles.wordpress.org/juliek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>juliek</a></li>\n	<li><strong>Priority:</strong> Lesson plan production. ETA is ongoing.</li>\n	<li><strong>Struggle:</strong> The workflow is a little complex, so recruiting and training enough contributors to keep the process moving is a struggle.</li>\n	<li><strong>Big Win</strong>: WordCamp Europe&#8217;s Contributor Day was very productive. New tools/workflow are in place and two team representatives were there to lead and help.</li>\n</ul>\n\n<p><em>Interested in updates from the first quarter of this year? You can find those here: <a href=\"https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/\"><em>https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/</em></a>\n	</em>\n</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6140\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Update on Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/news/2018/07/update-on-gutenberg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jul 2018 19:23:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Focus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6118\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"Progress on the Gutenberg project, the new content creating experience coming to WordPress, has come a long way. Since the start of the project, there have been 30 releases and 12 of those happened after WordCamp US 2017. In total since then, there have been 1,764 issues opened and 1,115 closed as of WordCamp Europe. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Tammie Lister\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2261:\"<p>Progress on the Gutenberg project, the new content creating experience coming to WordPress, has come a long way. Since the start of the project, there have been 30 releases and 12 of those happened after WordCamp US 2017. In total since then, there have been 1,764 issues opened and 1,115 closed as of WordCamp Europe. As the work on phase one moves into its final stretch, here is what you can expect.<br /></p>\n\n<h4>In Progress</h4>\n\n<ul>\n	<li>Freeze new features in Gutenberg (the feature list can be found <a href=\"https://github.com/WordPress/gutenberg/issues/4894\">here</a>).</li>\n	<li>Hosts, agencies, teachers invited to opt-in sites they have influence over.</li>\n	<li>WordPress.com has opt-in for wp-admin users. The number of sites and posts will be tracked.</li>\n	<li>Mobile app support for Gutenberg will be across iOS and Android.</li>\n</ul>\n\n<h4>July</h4>\n\n<ul>\n	<li>4.9.x release with an invitation to install either Gutenberg or Classic Editor plugin.</li>\n	<li>WordPress.com will move to opt-out. There will be tracking to see who opts out and why.</li>\n	<li>Triage increases and bug gardening escalates to get blockers in Gutenberg down to zero.</li>\n	<li>Gutenberg phase two, Customization exploration begins by moving beyond the post.</li>\n</ul>\n\n<h4>August and beyond</h4>\n\n<ul>\n	<li>All critical issues within Gutenberg are resolved.</li>\n	<li>There is full integration with Calypso and there is opt-in for users there.</li>\n	<li>A goal will be 100k+ sites having made 250k+ posts using Gutenberg.</li>\n	<li>Core merge of Gutenberg begins the 5.0 release cycle.</li>\n	<li>5.0 moves into beta releases and translations are completed.</li>\n	<li>There will be a mobile version of Gutenberg by the end of the year.</li>\n</ul>\n\n<p>WordPress 5.0 could be as soon as August with hundreds of thousands of sites using Gutenberg before release. Learn more about Gutenberg <a href=\"https://wordpress.org/gutenberg/\">here</a>, take it for a <a href=\"https://testgutenberg.com/\">test drive</a>, <a href=\"https://wordpress.org/plugins/gutenberg/\">install</a> on your site, follow along on <a href=\"https://github.com/WordPress/gutenberg\">GitHub</a> and give your <a href=\"https://wordpressdotorg.polldaddy.com/s/gutenberg-support\">feedback</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6118\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.9.7 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Jul 2018 17:00:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6091\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"WordPress 4.9.7 is now available. This is a security and maintenance release for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately. WordPress versions 4.9.6 and earlier are affected by a media issue that could potentially allow a user with certain capabilities to attempt to delete files outside the uploads [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3984:\"<p>WordPress 4.9.7 is now available. This is a <strong>security and maintenance release</strong> for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately.</p>\n\n<p>WordPress versions 4.9.6 and earlier are affected by a media issue that could potentially allow a user with certain capabilities to attempt to delete files outside the uploads directory.</p>\n\n<p>Thank you to <a href=\"https://hackerone.com/slavco\">Slavco</a> for reporting the original issue and <a href=\"https://www.wordfence.com/\">Matt Barry</a> for reporting related issues.</p>\n\n<p>Seventeen other bugs were fixed in WordPress 4.9.7. Particularly of note were:</p>\n\n<ul>\n	<li>Taxonomy: Improve cache handling for term queries.</li>\n	<li>Posts, Post Types: Clear post password cookie when logging out.</li>\n	<li>Widgets: Allow basic HTML tags in sidebar descriptions on Widgets admin screen.</li>\n	<li>Community Events Dashboard: Always show the nearest WordCamp if one is coming up, even if there are multiple Meetups happening first.</li>\n	<li>Privacy: Make sure default privacy policy content does not cause a fatal error when flushing rewrite rules outside of the admin context.</li>\n</ul>\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.7</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n\n<p>The previously scheduled 4.9.7 is now referred to as 4.9.8, and will follow the <a href=\"https://make.wordpress.org/core/2018/07/04/dev-chat-summary-july-4th-4-9-7-week-7/\">release schedule posted yesterday</a>.</p>\n\n<p>Thank you to everyone who contributed to WordPress 4.9.7:</p>\n\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">abdullahramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/jbpaul17/\">Migrated to @jeffpaul</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6091\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: June 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/07/the-month-in-wordpress-june-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Jul 2018 09:28:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6087\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"With one of the two flagship WordCamp events taking place this month, as well as some important WordPress project announcements, there’s no shortage of news. Learn more about what happened in the WordPress community in June. Another Successful WordCamp Europe On June 14th, WordCamp Europe kicked off three days of learning and contributions in Belgrade. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4627:\"<p>With one of the two flagship WordCamp events taking place this month, as well as some important WordPress project announcements, there’s no shortage of news. Learn more about what happened in the WordPress community in June.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Another Successful WordCamp Europe</h2>\n\n<p>On June 14th, WordCamp Europe kicked off three days of learning and contributions in Belgrade. Over 2,000 people attended in person, with hundreds more watching live streams of the sessions.</p>\n\n<p>The WordCamp was a great success with plenty of first-time attendees and new WordPress contributors getting involved in the project and community. Recorded sessions from the 65 speakers at the event will be available on WordPress.tv in the coming weeks. In the meantime, check out the <a href=\"https://www.flickr.com/photos/wceu/albums\">photos from the event</a>.</p>\n\n<p><a href=\"https://2018.europe.wordcamp.org/2018/06/16/wordcamp-europe-2019/\">The next WordCamp Europe</a> takes place on June 20-22 2019 in Berlin, Germany. If you’re based in Europe and would like to serve on the organizing team, <a href=\"https://2019.europe.wordcamp.org/2018/06/16/call-wordcamp-europe-2019-organizers/\">fill in the application form</a>.</p>\n\n<h2>Updated Roadmap for the New WordPress Content Editor</h2>\n\n<p>During his keynote session at WordCamp Europe, Matt Mullenweg presented <a href=\"https://gutenbergtimes.com/mullenweg-on-gutenberg-roll-out-plan/\">an updated roadmap</a> for <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new content editor coming in WordPress 5.0.</p>\n\n<p>While the editor is in rapid development, <a href=\"https://make.wordpress.org/core/2018/06/21/whats-new-in-gutenberg-21st-june/\">with v3.1 being released this past month</a>, the team is aiming to ship Gutenberg with WordPress Core in August, 2018. This is not set in stone — the release date may shift as development progresses — but this gives the first realistic idea of when we can expect the editor to be released.</p>\n\n<p>If you would like to contribute to Gutenberg, read <a href=\"https://wordpress.org/gutenberg/handbook/\">the handbook</a>, follow the <a href=\"https://make.wordpress.org/core/\">Core team blog</a>, and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>WordCamp Incubator Cities Announced</h2>\n\n<p>The WordCamp Incubator program helps spread WordPress to underserved communities by providing organizing support for their first WordCamp. The first iteration of this program ran successfully in 2016 and empowered three cities to start their own WordPress communities.</p>\n\n<p>This year, the Community Team is running the Incubator program again. After receiving applications from 104 communities, <a href=\"https://make.wordpress.org/community/2018/06/26/wordcamp-incubator-program-2018-locations-announcement/\">they have selected</a> Montevideo, Uruguay and Kota Kinabalu, Malaysia to participate in the program. Both cities will receive direct help from experienced WordCamp organizers to run their first-ever WordCamp as a way to help their WordPress community get started.</p>\n\n<p>To find out more about the Incubator program follow the <a href=\"https://make.wordpress.org/community/\">Community team blog</a>, and join the #community-events channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n	<li>The WordPress community of Spain recently <a href=\"https://twitter.com/wp_es/status/1004681694660603904\">received an award</a> for being the best open-source community in the country.</li>\n	<li>This month, WordPress reached <a href=\"https://w3techs.com/technologies/details/cm-wordpress/all/all\">the milestone of powering 31% of websites</a>.</li>\n	<li><a href=\"https://wprig.io/introducing-wprig-wordpress/\">WP Rig</a> is a brand new tool to help WordPress developers build better themes.</li>\n	<li><a href=\"https://richtabor.com/gutenberg-block-unit-test/\">Block Unit Test</a> is a new plugin to help theme developers prepare for Gutenberg.</li>\n	<li>Near the end of the month, Zac Gordon hosted <a href=\"https://javascriptforwp.com/conference/\">an online conference</a> focused on JavaScript development in WordPress &#8211; the session videos will be available on YouTube soon.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6087\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"The Month in WordPress: May 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2018/06/the-month-in-wordpress-may-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Jun 2018 09:09:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6065\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"This month saw two significant milestones in the WordPress community — the 15th anniversary of the project, and GDPR-related privacy tools coming to WordPress Core. Read on to find out more about this and everything else that happened in the WordPress community in May. Local Communities Celebrate the 15th Anniversary of WordPress Last Sunday, May [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4537:\"<p>This month saw two significant milestones in the WordPress community — the 15th anniversary of the project, and GDPR-related privacy tools coming to WordPress Core. Read on to find out more about this and everything else that happened in the WordPress community in May.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Local Communities Celebrate the 15th Anniversary of WordPress</h2>\n\n<p>Last Sunday, May 27, WordPress turned 15 years old. This is a noteworthy occasion for an open-source project like WordPress and one well worth celebrating. To mark the occasion, <a href=\"https://wp15.wordpress.net/\">WordPress communities across the world gathered</a> for parties and meetups in honor of the milestone.</p>\n\n<p>Altogether, there were 224 events globally, with <a href=\"https://wp15.wordpress.net/about/\">a few more of those still scheduled</a> to take place in some communities — attend one in your area if you can.</p>\n\n<p>If your city doesn’t have a WordPress meetup group, this is a great opportunity to start one! Learn how with <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/welcome/\">the Meetup Organizer Handbook</a>, and join the #community-events channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Privacy Tools added to WordPress core</h2>\n\n<p>In light of recent changes to data privacy regulations in the EU, WordPress Core shipped important updates <a href=\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\">in the v4.9.6 release</a>, giving site owners tools to help them comply with the new General Data Protection Regulation (GDPR). It is worth noting, however, that WordPress cannot ensure you are compliant — this is still a site owner’s responsibility.</p>\n\n<p>The new privacy tools include a number of features focused on providing privacy and personal data management to all site users — asking commenters for explicit consent to store their details in a cookie, providing site owners with an easy way to publish a Privacy Policy, and providing data export and erasure tools to all site users that can be extended by plugins to allow the handling of data that they introduce.</p>\n\n<p>To find out more about these features and the other updates, read the <a href=\"https://make.wordpress.org/core/2018/05/17/4-9-6-update-guide/\">4.9.6 update guide</a>. You can also get involved in contributing to this part of WordPress Core by jumping into the #core-privacy channel in the<a href=\"https://make.wordpress.org/chat/\"> Making WordPress Slack group</a>, and following<a href=\"https://make.wordpress.org/core/\"> the Core team blog</a>.</p>\n\n<h2>Updates to the WordPress.org Privacy Policy</h2>\n\n<p>In a similar vein, WordPress.org itself has received <a href=\"https://wordpress.org/about/privacy/\">an updated Privacy Policy</a> to make clear what is being tracked and how your data is handled. Along with that, a <a href=\"https://wordpress.org/about/privacy/cookies/\">Cookie Policy</a> has also been added to explain just what is collected and stored in your browser when using the site.</p>\n\n<p>These policies cover all sites on the WordPress.org network — including WordPress.org, WordPress.net, WordCamp.org, BuddyPress.org, bbPress.org, and other related domains and subdomains. It’s important to note that this does not mean that anything has changed in terms of data storage; rather that these documents clarify what data is stored and how it is handled.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n	<li>WordCamp US 2018 has <a href=\"https://2018.us.wordcamp.org/2018/05/29/speak-at-wordcamp-us/\">opened up speaker submissions</a> for the December event.</li>\n	<li><a href=\"https://2018.europe.wordcamp.org/2018/05/15/wceu-live-stream-tickets/\">Live stream tickets are now available for WordCamp Europe</a>, happening on June 14-16.</li>\n	<li>Gutenberg, the new editor for WordPress Core, is getting ever closer to the final stages with <a href=\"https://make.wordpress.org/core/2018/05/18/whats-new-in-gutenberg-18th-may/\">a major update</a> this month.</li>\n	<li>In preparation for Gutenberg, <a href=\"https://core.trac.wordpress.org/changeset/43309\">significant work has been done</a> to improve WordPress Core’s build process.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6065\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"WordPress.org Privacy Policy Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2018/05/wordpress-org-privacy-policy-updates/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 25 May 2018 08:06:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"privacy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6047\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:325:\"The WordPress.org privacy policy has been updated, hurray! While we weren&#8217;t able to remove all the long sentences, we hope you find the revisions make it easier to understand: how we collect and use data, how long the data we collect is retained, and how you can request a copy of the data you&#8217;ve shared [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:657:\"<p>The <a href=\"https://wordpress.org/about/privacy/\">WordPress.org privacy policy</a> has been updated, hurray! While we weren&#8217;t able to remove <strong>all</strong> the long sentences, we hope you find the revisions make it easier to understand:</p>\n<ul>\n<li>how we collect and use data,</li>\n<li>how long the data we collect is retained, and</li>\n<li>how you can request a copy of the data you&#8217;ve shared with us.</li>\n</ul>\n<p>There hasn&#8217;t been any change to the data that WordPress.org collects or how that data is used; the privacy policy just provides more detail now. Happy reading, and thanks for using WordPress!</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6047\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress 4.9.6 Privacy and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 May 2018 19:21:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5920\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"WordPress 4.9.6 is now available. This is a privacy and maintenance release. We encourage you to update your sites to take advantage of the new privacy features. Privacy The European Union&#8217;s General Data Protection Regulation (GDPR) takes effect on May 25. The GDPR requires companies and site owners to be transparent about how they collect, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Allen Snook\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13399:\"<p>WordPress 4.9.6 is now available. This is a <strong>privacy and maintenance release</strong>. We encourage you to update your sites to take advantage of the new privacy features.</p>\n\n<figure class=\"wp-block-image\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?w=632&#038;ssl=1\" alt=\"A decorative header featuring the text &quot;GDPR&quot; and a lock inside of a blue shield, on multicolor green background.\" class=\"wp-image-5988\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=300%2C150&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=768%2C384&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=1024%2C512&amp;ssl=1 1024w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<h2 style=\"text-align:left\">Privacy</h2>\n\n<p>The European Union&#8217;s General Data Protection Regulation (<strong>GDPR</strong>) takes effect on May 25. The GDPR requires companies and site owners to be transparent about how they collect, use, and share personal data. It also gives individuals more access and choice when it comes to how their own personal data is collected, used, and shared.<br /></p>\n\n<p>It’s important to understand that while the GDPR is a European regulation, its requirements apply to all sites and online businesses that collect, store, and process personal data about EU residents no matter where the business is located.<br /></p>\n\n<p>You can learn more about the GDPR from the European Commission&#8217;s <a href=\"http://ec.europa.eu/justice/smedataprotect/index_en.htm\">Data Protection page</a>.<br /></p>\n\n<p>We&#8217;re committed to supporting site owners around the world in their work to comply with this important law. As part of that effort, we’ve added a number of new privacy features in this release.</p>\n\n<h2 style=\"text-align:left\">Comments</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?w=632&#038;ssl=1\" alt=\"A screenshot of a comment form, where the new &quot;Save my name, email, and website in this browser for the next time I comment&quot; checkbox is featured.\" class=\"wp-image-5986\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=300%2C291&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=768%2C744&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=1024%2C992&amp;ssl=1 1024w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<p>Logged-out commenters will be given a choice on whether their name, email address, and website are saved in a cookie on their browser.</p>\n\n<h2 style=\"text-align:left\">Privacy Policy Page</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=632&#038;ssl=1\" alt=\"A screenshot of the new Privacy Settings page.\" class=\"wp-image-5995\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=1898&amp;ssl=1 1898w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=300%2C177&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=768%2C453&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=1024%2C604&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<p>Site owners can now designate a privacy policy page. This page will be shown on your login and registration pages. You should manually add a link to your policy to every page on your website. If you have a footer menu, that’s a great place to include your privacy policy.<br /></p>\n\n<p>In addition, we’ve created a guide that includes insights from WordPress and participating plugins on how they handle personal data. These insights can be copied and pasted into your site&#8217;s privacy policy to help you get started.<br /></p>\n\n<p>If you maintain a plugin that collects data, we recommend including that information in WordPress’ privacy policy guide. <a href=\"https://developer.wordpress.org/plugins/privacy/\">Learn more in our Privacy section of the Plugin Handbook</a>.</p>\n\n<h2 style=\"text-align:left\">Data Handling</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=632&#038;ssl=1\" alt=\"A screenshot of the new Export Personal Data tools page. Several export requests are listed on the page, to demonstrate how the new feature will work.\" class=\"wp-image-5999\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=2372&amp;ssl=1 2372w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=300%2C221&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=768%2C565&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=1024%2C753&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<div class=\"wp-block-columns has-2-columns\">\n		<h3 class=\"layout-column-1\">Data Export</h3>\n	\n		<p class=\"layout-column-1\">Site owners can export a ZIP file containing a user&#8217;s personal data, using data gathered by WordPress and participating plugins.</p>\n	\n		<h3 class=\"layout-column-2\">Data Erasure</h3>\n	\n		<p class=\"layout-column-2\">Site owners can erase a user&#8217;s personal data, including data collected by participating plugins.</p>\n	</div>\n\n<blockquote class=\"wp-block-quote\">\n	<p>Howdy,</p>\n	<p>A request has been made to perform the following action on your account:<br /> </p>\n	<p><strong>Export Personal Data</strong><br /> </p>\n	<p>To confirm this, please click on the following link:<br /><a href=\"#\">http://.wordpress.org/wp-login.php?action=confirmaction&#8230;</a><br /> </p>\n	<p>You can safely ignore and delete this email if you do not want to<br /> take this action.<br /> </p>\n	<p>This email has been sent to <a href=\"#\">you@example.com</a>.<br /> </p>\n	<p>Regards,<br /><em>Your friends at WordPress</em><br /><a href=\"http://wordpress.org\"><em> http://wordpress.org</em></a></p>\n</blockquote>\n\n<p>Site owners have a new email-based method that they can use to confirm personal data requests. This request confirmation tool works for both export and erasure requests, and for both registered users and commenters.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2 style=\"text-align:left\">Maintenance</h2>\n\n<p>95 updates were made in WordPress 4.9.6. In addition to the above, particularly of note were:<br /></p>\n\n<ul>\n	<li>&#8220;Mine&#8221; has been added as a filter in the media library.</li>\n	<li>When viewing a plugin in the admin, it will now tell you the minimum PHP version required.</li>\n	<li>We&#8217;ve added new PHP polyfills for forwards-compatibility and proper variable validation.</li>\n	<li>TinyMCE was updated to the latest version (4.7.11).<br /></li>\n</ul>\n\n<p><a href=\"https://make.wordpress.org/core/2018/05/17/4-9-6-update-guide/\">This post has more information about all of the issues fixed in 4.9.6 if you&#8217;d like to learn more</a>.</p>\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.6</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates will start updating soon.<br /></p>\n\n<p class=\"has-background has-very-light-gray-background-color\">Please note that if you’re currently on WordPress 4.9.3, you should manually update your site immediately.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<p>Thank you to everyone who contributed to WordPress 4.9.6:<br /><a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">abdullahramzan</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/allendav/\">allendav</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andreamiddleton/\">Andrea Middleton</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bridgetwillard/\">bridgetwillard</a>, <a href=\"https://profiles.wordpress.org/burlingtonbytes/\">Burlington Bytes</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/claudiu/\">claudiu</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/ericdaams/\">Eric Daams</a>, <a href=\"https://profiles.wordpress.org/fclaussen/\">Fernando Claussen</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a>, <a href=\"https://profiles.wordpress.org/herregroen/\">herregroen</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jesperher/\">Jesper V Nielsen</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">JJJ</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/dejliglama/\">Kåre Mulvad Steffensen</a>, <a href=\"https://profiles.wordpress.org/lakenh/\">Laken Hafner</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a>, <a href=\"https://profiles.wordpress.org/pbarthmaier/\">pbrocks</a>, <a href=\"https://profiles.wordpress.org/postphotos/\">postphotos</a>, <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>, <a href=\"https://profiles.wordpress.org/presstigers/\">PressTigers</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/satollo/\">Stefano Lissa</a>, <a href=\"https://profiles.wordpress.org/stephdau/\">Stephane Daury (stephdau)</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/teddytime/\">teddytime</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">thomasplevy</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/voneff/\">voneff</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, and <a href=\"https://profiles.wordpress.org/xkon/\">Xenos (xkon) Konstantinos</a>.<br /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5920\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 11 Sep 2018 04:56:13 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Mon, 03 Sep 2018 11:00:43 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20170420112649\";}", "no");
INSERT INTO `myevntl_options` VALUES("55572", "_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1536684972", "no");
INSERT INTO `myevntl_options` VALUES("55573", "_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca", "1536641772", "no");
INSERT INTO `myevntl_options` VALUES("55574", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1536684973", "no");
INSERT INTO `myevntl_options` VALUES("55575", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Meetup Group Organizers Can Now Earn A WordPress.org User Profile Badge\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83806\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/meetup-group-organizers-can-now-earn-a-wordpress-org-user-profile-badge\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2241:\"<p>The WordPress Community team <a href=\"https://make.wordpress.org/community/2018/09/10/new-tool-for-community-deputies-meetup-tracker/\">has unveiled</a> a new tool called Meetup Tracker. This tool replaces the Meetup Status Document and will enable Global Community Team members to more easily track all Meetup.com groups.</p>\n\n<p>There&#8217;s also a <a href=\"https://central.wordcamp.org/meetup-organizer-application/\">new application form</a> available for organizers looking to join the <a href=\"https://make.wordpress.org/community/handbook/community-deputy/meetup-program-basics/\">WordPress Meetup Chapter Program</a>. Groups that are part of the program have their Meetup.com fees paid for by WordPress Community Support PBC.<br /></p>\n\n<p>Thanks to the new system that is hosted on the backend of <a href=\"https://central.wordcamp.org/\">WordCamp Central</a>, the community team is able to award badges to meetup organizers which will be displayed on their WordPress.org user profiles.</p>\n\n<div class=\"wp-block-image\"><img />Example of Contribution Badges Displayed on WordPress.org User Profiles</div>\n\n<p>In order to receive a badge and to fill the new system with updated information, organizers with meetups that are part of the chapter program are required to add the following information to this <a href=\"https://docs.google.com/spreadsheets/d/1LYnNDDpBQC7przZyufG4W5mdO67BcTTy_yz8eHY24lc/edit#gid=0\">Google Document</a>.</p>\n\n<ul><li> <strong>WordPress.org username for main contact</strong> <br /></li><li><strong>WordPress.org usernames of all organizers</strong> <br /></li><li><strong>Whether or not the contact’s WordPress.org email address is still valid</strong> <br /></li></ul>\n\n<p>Badges were added to WordPress.org <a href=\"https://wptavern.com/wordpress-org-profile-redesign-is-live\">user profiles as part of a redesign in 2014</a> and are a quick way to gauge a person&#8217;s activity and or interests across the WordPress project. </p>\n\n<p>The meetup organizer&#8217;s badge design has yet to be determined. For more information or if you have questions, please leave a comment on the <a href=\"https://make.wordpress.org/community/2018/09/10/calling-all-meetup-group-orgnisers/\">announcement post</a>. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Sep 2018 02:52:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: WordPress Coding Standards 1.1.0 Released\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83804\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wptavern.com/wordpress-coding-standards-1-1-0-released\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:688:\"<p>The WordPress Coding Standards version 1.1.0 has <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/releases/tag/1.1.0\">been released</a> on GitHub. This release includes more stringent function call formatting checks which are <a href=\"https://make.wordpress.org/core/handbook/best-practices/coding-standards/php/#multiline-function-calls\">explained</a> in the handbook. There&#8217;s also stricter checks for overrides of WordPress global variables. </p>\n\n<p>To see a full list of what was changed, fixed, and added, check out the <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/releases/tag/1.1.0\">changelog</a>. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Sep 2018 01:16:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Matt: Seth Godin on Customer Service\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48340\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://ma.tt/2018/09/seth-godin-on-customer-service/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:236:\"<p>This morning <a href=\"https://seths.blog/2015/03/what-is-customer-service-for/\">I&#8217;m enjoying Seth Godin&#8217;s classic on Customer Service</a>. <cite>Hat tip: <a href=\"https://andrewspittle.com/\">Andrew Spittle</a>.</cite></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Sep 2018 16:39:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Matt: Responsibility of Technology\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48337\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://ma.tt/2018/09/responsibility-of-technology/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:834:\"<p>There&#8217;s <a href=\"https://www.buzzfeednews.com/article/daveyalba/facebook-philippines-dutertes-drug-war\">fascinating and terrifying feature article about Facebook, Duterte, and the drug war in the Philippines</a>, written <a href=\"https://twitter.com/daveyalba/status/1036917302061608960\">by Davey Alba</a>. My first trip there was actually to Davao, and having been to the country several times and met so many bloggers there it&#8217;s hard to imagine what&#8217;s described. There are definitely echoes of <a href=\"https://www.wired.com/story/how-facebooks-rise-fueled-chaos-and-confusion-in-myanmar/\">the Wired feature on Facebook and ethnic cleansing in Myanmar</a>. Both are good reminders that as technologists the tools we create can be used and leveraged in ways we wouldn&#8217;t imagine in our worst nightmares.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 09 Sep 2018 17:46:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Biratnagar, Nepal to Host Its First WordCamp – December 22, 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83719\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/biratnagar-nepal-to-host-its-first-wordcamp-december-22-2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2614:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/09/wordcamp-biratnagar.png?ssl=1\"><img /></a></p>\n<p>Biratnagar, one of the oldest cities in Nepal, is gearing up to <a href=\"https://2018.biratnagar.wordcamp.org/\" rel=\"noopener noreferrer\" target=\"_blank\">host its first WordCamp</a> on December 22, 2018. The local community organized its first meetup in 2011 with 40 participants. Since that time the community has grown and recently hosted 250 members for <a href=\"http://wp.tecnepal.com/\" rel=\"noopener noreferrer\" target=\"_blank\">a two-day meetup</a> in January 2018.</p>\n<p>&#8220;WordPress Biratnagar has a remarkably large number of enthusiastic participants in local WordPress meetups, more than any other meetups in Nepal,&#8221; lead organizer Ganga Kafle said. Kafle is a developer and WordPress.org theme reviewer. He said his local community is full of energetic youth who are excited to make the WordCamp happen.</p>\n<p>&#8220;From an 8th grade student in a government school to a 56-year-old passionate retired army soldier, all are members of the WordPress Biratnagar community. This community is diverse, open, and has the ability to have fun together. They help each other out a lot, sharing tips and tricks, and solve problems together.&#8221;</p>\n<p>Kafle said the topics of most interest to the local community include WordPress SEO, blogging, and WordPress theme development, as the majority of community members are students, developers, freelancers, and designers. He expects the WordCamp will attract attendees from different cities inside Nepal and from nearby countries, including India, Bangladesh, Pakistan, and other South Asian countries. Sessions will be conducted in both English and Nepali.</p>\n<p>WordCamp Biratnagar will be the seventh WordCamp held in Nepal, following WordCamp Pokhara which is scheduled one month earlier on November 24. Pokhara is 11 hours away by car so the two WordPress communities are quite a distance away from each other. WordCamp Biratnagar is the last camp on the global WordCamp calendar for 2018.</p>\n<p>Kafle said he hopes the event will bring the Biratnagar WordPress community opportunities that will lead to more entrepreneurship and contribution to the greater tech community in the region. The event has <a href=\"https://2018.biratnagar.wordcamp.org/wordcamp-biratnagar-tickets/\" rel=\"noopener noreferrer\" target=\"_blank\">200 tickets available</a> and the capacity to expand if there is a greater demand. Early Bird Tickets are now on sale at Rs 1000. Once those are sold, Regular Tickets will be available for Rs 1500.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 08 Sep 2018 01:40:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: Dark Mode is Possibly Coming to a WordPress Dashboard Near You\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83660\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wptavern.com/dark-mode-is-possibly-coming-to-a-wordpress-dashboard-near-you\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4514:\"<p>For the past year, <a href=\"https://profiles.wordpress.org/danieltj\">Daniel James</a> has been developing the <a href=\"https://wordpress.org/plugins/dark-mode/\">Dark Mode</a> plugin for WordPress. The plugin is actively installed on more than 1K sites. Dark Mode replaces the white and grey colors in the backend with darker colors that are easier on the eyes.</p>\n\n<div class=\"wp-block-image\"><img />Dark Mode for WordPress</div>\n\n<p>James has published <a href=\"https://make.wordpress.org/core/2018/08/30/merge-proposal-dark-mode/\">a proposal</a> to merge the plugin into core. There are three things to know about Dark Mode up front. It does not have a high contrast mode to meet accessibility needs, is not a new admin color scheme for the backend, and is not a tool that helps people with vision issues. </p>\n\n<p>By default, WordPress ships with eight admin color schemes. However, color schemes are only applied to the WordPress sidebar and Admin toolbar. Dark Mode is applied to the main content area of the dashboard. This gives users the ability to use Dark Mode and an Admin Color Scheme in tandem. </p>\n\n<img />Admin Color Schemes\n\n<p>Dark Mode is not compatible with Gutenberg but is compatible with TinyMCE. Because of the speed at which Gutenberg is being developed as a plugin, James decided that a merge proposal without Gutenberg support is the best way forward. Compatibility with Gutenberg will likely arrive once it is merged into core.</p>\n\n<p>Because Dark Mode affects the content area of the WordPress Dashboard, if it&#8217;s merged into core, plugins will need to support two different color schemes. </p>\n\n<p>There is no easy way for Dark Mode to support every plugin, especially when many of them use custom user interface elements. <a href=\"https://github.com/danieltj27/Dark-Mode/wiki/Help:-Plugin-Compatibility-Guide\">This guide</a> on the <a href=\"https://github.com/danieltj27/Dark-Mode\">plugin&#8217;s GitHub page</a> explains how developers can add support for Dark Mode.</p>\n\n<h2>Proposal Hits a Snag</h2>\n\n<p>Within the comments on the proposal, members of the core and accessibility teams weighed in. Gary Pendergast, a WordPress core developer, <a href=\"https://make.wordpress.org/core/2018/08/30/merge-proposal-dark-mode/#comment-33913\">outlined</a> a list of requirements from the <a href=\"https://make.wordpress.org/core/handbook/about/release-cycle/features-as-plugins/#feature-plugin-merge-criteria\">Core Handbook</a> that the plugin has yet to achieve. </p>\n\n<p>James <a href=\"https://make.wordpress.org/core/2018/08/30/merge-proposal-dark-mode/#comment-33928\">responded</a> by explaining the process of merging a feature plugin into core as outlined in the Core Handbook does not lend itself to all projects. </p>\n\n<p>&#8220;For example, weekly meetings, or kick-off posts etc,&#8221; James said. &#8220;I understand that Gutenberg is probably a top priority right now but it’d be great if I could have some help on what to do to push this forward. I think an introduction of Gutenberg <strong>and</strong> Dark Mode would be a great addition to shout about in 5.0.&#8221;</p>\n\n<h2>Some of the Benefits of Dark Mode</h2>\n\n<p>One of the obvious benefits is that Dark Mode is aesthetically pleasing, especially after sunset. Depending on the <a href=\"https://www.quora.com/Does-a-white-background-use-more-energy-on-an-LCD-than-if-it-was-set-to-black\">screen technology</a>, darker colors are more energy efficient. It&#8217;s also a mode that&#8217;s gaining in popularity. For example, earlier this year, <a href=\"https://developer.apple.com/videos/play/wwdc2018/210/\">Apple announced</a> Dark Mode will be available in macOS Mojave.<br /></p>\n\n<p>I find myself using Dark Mode on Reddit, the Twitter app on my iPhone, and now WordPress. I like to browse the web on my phone while laying in bed and my partner enjoys not seeing a bright screen shining in her direction.<br /></p>\n\n<p>Based on <a href=\"https://make.wordpress.org/core/2018/08/30/merge-proposal-dark-mode/#comment-33929\">comments made</a> to the proposal and on <a href=\"https://twitter.com/mikelikethebike/status/1035513986836570112\">social media</a>, there is a definitive interest in having a Dark Mode option in WordPress. Is Dark Mode something you&#8217;d like to see be part of core? Also, I&#8217;m curious as to which Admin Color scheme you use. Please vote in the poll below. </p>\n\nNote: There is a poll embedded within this post, please visit the site to participate in this post\'s poll.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 08 Sep 2018 00:14:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: The State of JavaScript 2018 Survey is Now Open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83749\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/the-state-of-javascript-2018-survey-is-now-open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3004:\"<p>The annual <a href=\"https://stateofjs.com/\" rel=\"noopener noreferrer\" target=\"_blank\">State of JavaScript 2018 Survey</a> is in its third year running and is now open for participants. <a href=\"http://sachagreif.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Sacha Greif</a>, an Osaka-based web designer and developer, said he created the survey to get more data about recent trends after hearing all the online discussion about “JavaScript fatigue.”</p>\n<p>Last year&#8217;s survey had more than 20,000 participants, a 115% increase over the previous year&#8217;s 9,300 responses. In the popular front-end frameworks category, React won out again as the framework with the greatest number of respondents indicating that they had used it and would use it again.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-07-at-12.35.08-PM.png?ssl=1\"><img /></a></p>\n<p>The 2017 survey participants were asked to rate their happiness with the current state of front-end tools on a scale of 1-5. The results averaged a 3.8, so there is room in the front-end tools category for things to shift quite a bit over a year.</p>\n<p>The salary ranges data is particularly useful for job seekers or those new to JavaScript who are trying to decide what libraries to learn. Backbone and Ember commanded the highest salaries for participants, with Vue and Angular 2 coming in at the lower end.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-07-at-12.53.47-PM.png?ssl=1\"><img /></a></p>\n<p>Check out the full <a href=\"https://2017.stateofjs.com/2017/introduction/\" rel=\"noopener noreferrer\" target=\"_blank\">2017 results</a> for more data on participants&#8217; opinions on state management tools, back-end frameworks, build tools, and more.</p>\n<p>&#8220;The main change this year is that we added some extra logic to the survey: if you