/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2018-09-22 09:59:52 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `trvlite_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_aiowps_failed_logins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `failed_login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_attempt_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_aiowps_login_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `login_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `logout_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `login_country` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `browser_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `release_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_datalist` (
  `url` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `full_content` smallint(6) NOT NULL,
  PRIMARY KEY (`url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

CREATE TABLE `trvlite_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=203603 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=31327 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=2919 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `params` longtext NOT NULL,
  `advanced` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=112 DEFAULT CHARSET=latin1;

CREATE TABLE `trvlite_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `trvlite_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `trvlite_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

CREATE TABLE `trvlite_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=latin1;

CREATE TABLE `trvlite_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

CREATE TABLE `trvlite_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=560 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `trvlite_vfb_pro_entries` (
  `entries_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `user_id` bigint(20) DEFAULT '1',
  `data` longtext NOT NULL,
  `subject` text,
  `sender_name` varchar(255) DEFAULT NULL,
  `sender_email` varchar(255) DEFAULT NULL,
  `emails_to` text,
  `date_submitted` datetime DEFAULT NULL,
  `ip_address` varchar(25) DEFAULT NULL,
  `notes` text,
  `akismet` text,
  `entry_approved` varchar(20) DEFAULT '1',
  PRIMARY KEY (`entries_id`)
) ENGINE=MyISAM AUTO_INCREMENT=139 DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_vfb_pro_fields` (
  `field_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `field_key` varchar(255) NOT NULL,
  `field_type` varchar(25) NOT NULL,
  `field_options` text,
  `field_options_other` varchar(255) DEFAULT NULL,
  `field_description` text,
  `field_name` text NOT NULL,
  `field_sequence` bigint(20) DEFAULT '0',
  `field_parent` bigint(20) DEFAULT '0',
  `field_validation` varchar(25) DEFAULT NULL,
  `field_required` varchar(25) DEFAULT NULL,
  `field_size` varchar(25) DEFAULT 'medium',
  `field_css` varchar(255) DEFAULT NULL,
  `field_layout` varchar(255) DEFAULT NULL,
  `field_default` text,
  `field_rule_setting` tinyint(1) DEFAULT NULL,
  `field_rule` longtext,
  PRIMARY KEY (`field_id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_vfb_pro_forms` (
  `form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_key` tinytext NOT NULL,
  `form_title` text NOT NULL,
  `form_email_subject` text,
  `form_email_to` text,
  `form_email_from` varchar(255) DEFAULT NULL,
  `form_email_from_name` varchar(255) DEFAULT NULL,
  `form_email_from_override` varchar(255) DEFAULT NULL,
  `form_email_from_name_override` varchar(255) DEFAULT NULL,
  `form_email_rule_setting` tinyint(1) DEFAULT NULL,
  `form_email_rule` longtext,
  `form_success_type` varchar(25) DEFAULT 'text',
  `form_success_message` text,
  `form_notification_setting` varchar(25) DEFAULT NULL,
  `form_notification_email_name` varchar(255) DEFAULT NULL,
  `form_notification_email_from` varchar(255) DEFAULT NULL,
  `form_notification_email` varchar(25) DEFAULT NULL,
  `form_notification_subject` varchar(255) DEFAULT NULL,
  `form_notification_message` text,
  `form_notification_entry` varchar(25) DEFAULT NULL,
  `form_email_design` text,
  `form_paypal_setting` varchar(25) DEFAULT NULL,
  `form_paypal_email` varchar(255) DEFAULT NULL,
  `form_paypal_currency` varchar(25) DEFAULT 'USD',
  `form_paypal_shipping` varchar(255) DEFAULT NULL,
  `form_paypal_tax` varchar(255) DEFAULT NULL,
  `form_paypal_field_price` text,
  `form_paypal_item_name` varchar(255) DEFAULT NULL,
  `form_label_alignment` varchar(25) DEFAULT NULL,
  `form_verification` tinyint(1) DEFAULT '1',
  `form_entries_allowed` varchar(25) DEFAULT NULL,
  `form_entries_schedule` varchar(100) DEFAULT NULL,
  `form_unique_entry` tinyint(1) DEFAULT '0',
  `form_status` varchar(20) DEFAULT 'publish',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfBadLeechers` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfBlockedCommentLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'gsb',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfBlockedIPLog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfBlocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM AUTO_INCREMENT=104 DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfConfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfCrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfFileChanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfFileMods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfHits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=10990 DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfHoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=261 DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfKnownFileList` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7421 DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfLeechers` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfLiveTrafficHuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfLocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfLogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfNotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfPendingIssues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfReverseCache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfSNIPCache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=139 DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfScanners` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hits` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfStatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=11571 DEFAULT CHARSET=utf8;

CREATE TABLE `trvlite_wfVulnScanners` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: trvlite_aiowps_failed_logins */
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("1", "2", "travelite", "2018-08-29 04:57:21", "185.225.36.126");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("2", "0", "cwc-dev", "2018-08-29 07:27:54", "138.128.170.114");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("3", "0", "cwc-dev", "2018-08-29 08:59:53", "103.215.176.200");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("4", "2", "travelite", "2018-08-29 16:48:15", "45.64.104.140");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("5", "2", "travelite", "2018-08-29 17:11:59", "64.37.61.154");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("6", "0", "cwc-dev", "2018-08-29 21:23:23", "185.42.105.31");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("7", "0", "cwc-dev", "2018-08-29 21:47:33", "185.51.191.43");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("8", "2", "travelite", "2018-08-30 05:56:06", "67.23.238.106");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("9", "2", "travelite", "2018-08-30 07:03:56", "78.153.213.8");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("10", "0", "cwc-dev", "2018-08-30 09:51:32", "176.122.166.158");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("11", "0", "cwc-dev", "2018-08-30 12:15:05", "107.150.58.98");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("12", "2", "travelite", "2018-08-30 18:18:51", "107.190.135.50");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("13", "2", "travelite", "2018-08-30 21:19:57", "46.17.46.46");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("14", "0", "cwc-dev", "2018-08-30 22:25:35", "107.180.109.8");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("15", "0", "cwc-dev", "2018-08-31 19:18:50", "66.147.244.139");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("16", "2", "travelite", "2018-08-31 23:33:14", "89.252.187.151");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("17", "0", "cwc-dev", "2018-09-01 03:48:39", "34.201.229.191");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("18", "2", "travelite", "2018-09-01 04:31:30", "72.52.171.225");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("19", "0", "cwc-dev", "2018-09-01 09:34:41", "204.110.9.160");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("20", "2", "travelite", "2018-09-01 12:27:38", "41.185.8.231");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("21", "0", "cwc-dev", "2018-09-01 16:25:05", "153.92.0.20");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("22", "2", "travelite", "2018-09-01 18:46:40", "162.144.214.129");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("23", "0", "cwc-dev", "2018-09-01 23:58:04", "89.39.208.20");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("24", "2", "travelite", "2018-09-02 00:59:29", "103.67.235.72");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("25", "0", "cwc-dev", "2018-09-02 04:46:53", "79.172.211.91");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("26", "13", "rosalejosg", "2018-09-07 18:58:10", "180.190.194.77");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("27", "14", "shejojo2002", "2018-09-10 14:21:28", "49.146.7.102");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("28", "2", "travelite", "2018-09-11 10:06:04", "103.6.198.152");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("29", "0", "cwc-dev", "2018-09-11 13:59:11", "64.20.52.82");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("30", "2", "travelite", "2018-09-11 22:27:35", "89.252.186.141");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("31", "0", "cwc-dev", "2018-09-12 02:38:50", "82.196.25.106");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("32", "2", "travelite", "2018-09-12 11:03:44", "136.243.22.104");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("33", "0", "cwc-dev", "2018-09-12 15:10:52", "149.56.22.159");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("34", "2", "travelite", "2018-09-12 23:43:05", "188.40.82.56");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("35", "0", "cwc-dev", "2018-09-13 04:04:43", "185.207.37.140");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("36", "2", "travelite", "2018-09-13 12:52:13", "37.139.121.121");
INSERT INTO `trvlite_aiowps_failed_logins` VALUES("37", "0", "cwc-dev", "2018-09-13 17:15:27", "160.153.154.152");

/* INSERT TABLE DATA: trvlite_aiowps_login_activity */
INSERT INTO `trvlite_aiowps_login_activity` VALUES("1", "2", "Travelite", "2018-09-11 12:01:00", "2018-09-11 12:06:58", "122.53.56.168", "", "");
INSERT INTO `trvlite_aiowps_login_activity` VALUES("2", "1", "CWC Dev", "2018-09-11 12:42:44", "2018-09-11 12:49:51", "49.145.139.41", "", "");
INSERT INTO `trvlite_aiowps_login_activity` VALUES("3", "11", "getupgotours", "2018-09-11 15:49:59", "0000-00-00 00:00:00", "49.147.102.222", "", "");
INSERT INTO `trvlite_aiowps_login_activity` VALUES("4", "1", "CWC Dev", "2018-09-12 18:01:52", "2018-09-12 19:10:04", "49.145.143.41", "", "");
INSERT INTO `trvlite_aiowps_login_activity` VALUES("5", "1", "CWC Dev", "2018-09-15 17:19:34", "0000-00-00 00:00:00", "49.145.131.41", "", "");
INSERT INTO `trvlite_aiowps_login_activity` VALUES("6", "1", "CWC Dev", "2018-09-22 16:36:52", "0000-00-00 00:00:00", "49.145.133.20", "", "");

/* INSERT TABLE DATA: trvlite_duplicator_packages */
INSERT INTO `trvlite_duplicator_packages` VALUES("5", "20180705_travelitetravelandtours", "d9a5ef1ef61035827146_20180922095821", "20", "2018-09-22 09:59:52", "CWC Dev", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-09-22 09:58:21\";s:7:\"Version\";s:6:\"1.2.46\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.7.23\";s:10:\"VersionPHP\";s:6:\"5.6.38\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:5;s:4:\"Name\";s:32:\"20180705_travelitetravelandtours\";s:4:\"Hash\";s:35:\"d9a5ef1ef61035827146_20180922095821\";s:8:\"NameHash\";s:68:\"20180705_travelitetravelandtours_d9a5ef1ef61035827146_20180922095821\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:58:\"/home/travel/public_html/travelite.com.ph/wp-snapshots/tmp\";s:8:\"StoreURL\";s:37:\"http://travelite.com.ph/wp-snapshots/\";s:8:\"ScanFile\";s:78:\"20180705_travelitetravelandtours_d9a5ef1ef61035827146_20180922095821_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";s:7:\"CWC Dev\";s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:80:\"20180705_travelitetravelandtours_d9a5ef1ef61035827146_20180922095821_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:41:\"/home/travel/public_html/travelite.com.ph\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-09-22 09:58:21\";s:7:\"Version\";s:6:\"1.2.46\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.7.23\";s:10:\"VersionPHP\";s:6:\"5.6.38\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20180705_travelitetravelandtours\";s:4:\"Hash\";s:35:\"d9a5ef1ef61035827146_20180922095821\";s:8:\"NameHash\";s:68:\"20180705_travelitetravelandtours_d9a5ef1ef61035827146_20180922095821\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:58:\"/home/travel/public_html/travelite.com.ph/wp-snapshots/tmp\";s:8:\"StoreURL\";s:37:\"http://travelite.com.ph/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";s:82:\"20180705_travelitetravelandtours_d9a5ef1ef61035827146_20180922095821_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:10:\"\0*\0Package\";r:58;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:81:\"20180705_travelitetravelandtours_d9a5ef1ef61035827146_20180922095821_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:50:\"/home/travel/public_html/travelite.com.ph/wp-admin\";i:1;s:60:\"/home/travel/public_html/travelite.com.ph/wp-content/uploads\";i:2;s:62:\"/home/travel/public_html/travelite.com.ph/wp-content/languages\";i:3;s:60:\"/home/travel/public_html/travelite.com.ph/wp-content/plugins\";i:4;s:59:\"/home/travel/public_html/travelite.com.ph/wp-content/themes\";i:5;s:53:\"/home/travel/public_html/travelite.com.ph/wp-includes\";}}s:9:\"Installer\";r:80;s:8:\"Database\";r:90;}");

/* INSERT TABLE DATA: trvlite_options */
INSERT INTO `trvlite_options` VALUES("1", "siteurl", "http://travelite.com.ph", "yes");
INSERT INTO `trvlite_options` VALUES("2", "home", "http://travelite.com.ph", "yes");
INSERT INTO `trvlite_options` VALUES("3", "blogname", "Travelite Travel and Tours", "yes");
INSERT INTO `trvlite_options` VALUES("4", "blogdescription", "A DMC in the Philippines", "yes");
INSERT INTO `trvlite_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `trvlite_options` VALUES("6", "admin_email", "info@cebuwebconcepts.com", "yes");
INSERT INTO `trvlite_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `trvlite_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `trvlite_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `trvlite_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `trvlite_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `trvlite_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `trvlite_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `trvlite_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `trvlite_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `trvlite_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `trvlite_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `trvlite_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `trvlite_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `trvlite_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `trvlite_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `trvlite_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `trvlite_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `trvlite_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `trvlite_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `trvlite_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `trvlite_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `trvlite_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `trvlite_options` VALUES("29", "rewrite_rules", "a:243:{s:41:\"um-api/([^/]+)/([^/]+)/([^/]+)/([^/]+)/?$\";s:111:\"index.php?um_page=api&um_action=$matches[1]&um_resource=$matches[2]&um_method=$matches[3]&um_verify=$matches[4]\";s:15:\"user/([^/]+)/?$\";s:48:\"index.php?page_id=2689&um_user=$matches[1]&lang=\";s:17:\"account/([^/]+)?$\";s:47:\"index.php?page_id=2699&um_tab=$matches[1]&lang=\";s:8:\"tours/?$\";s:32:\"index.php?post_type=dt_portfolio\";s:38:\"tours/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=dt_portfolio&feed=$matches[1]\";s:33:\"tours/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=dt_portfolio&feed=$matches[1]\";s:25:\"tours/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=dt_portfolio&paged=$matches[1]\";s:15:\"dt_slideshow/?$\";s:32:\"index.php?post_type=dt_slideshow\";s:45:\"dt_slideshow/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=dt_slideshow&feed=$matches[1]\";s:40:\"dt_slideshow/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=dt_slideshow&feed=$matches[1]\";s:32:\"dt_slideshow/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=dt_slideshow&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/um-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&um-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/um-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&um-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:35:\"um_form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"um_form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"um_form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"um_form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"um_form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"um_form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"um_form/([^/]+)/embed/?$\";s:40:\"index.php?um_form=$matches[1]&embed=true\";s:28:\"um_form/([^/]+)/trackback/?$\";s:34:\"index.php?um_form=$matches[1]&tb=1\";s:36:\"um_form/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?um_form=$matches[1]&paged=$matches[2]\";s:43:\"um_form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?um_form=$matches[1]&cpage=$matches[2]\";s:33:\"um_form/([^/]+)/um-api(/(.*))?/?$\";s:48:\"index.php?um_form=$matches[1]&um-api=$matches[3]\";s:39:\"um_form/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:50:\"um_form/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:32:\"um_form/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?um_form=$matches[1]&page=$matches[2]\";s:24:\"um_form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"um_form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"um_form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"um_form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"um_form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"um_form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"tours/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"tours/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"tours/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"tours/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"tours/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"tours/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"tours/([^/]+)/embed/?$\";s:45:\"index.php?dt_portfolio=$matches[1]&embed=true\";s:26:\"tours/([^/]+)/trackback/?$\";s:39:\"index.php?dt_portfolio=$matches[1]&tb=1\";s:46:\"tours/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?dt_portfolio=$matches[1]&feed=$matches[2]\";s:41:\"tours/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?dt_portfolio=$matches[1]&feed=$matches[2]\";s:34:\"tours/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?dt_portfolio=$matches[1]&paged=$matches[2]\";s:41:\"tours/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?dt_portfolio=$matches[1]&cpage=$matches[2]\";s:31:\"tours/([^/]+)/um-api(/(.*))?/?$\";s:53:\"index.php?dt_portfolio=$matches[1]&um-api=$matches[3]\";s:37:\"tours/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:48:\"tours/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:30:\"tours/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?dt_portfolio=$matches[1]&page=$matches[2]\";s:22:\"tours/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"tours/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"tours/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"tours/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"tours/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"tours/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"project-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?dt_portfolio_category=$matches[1]&feed=$matches[2]\";s:52:\"project-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?dt_portfolio_category=$matches[1]&feed=$matches[2]\";s:33:\"project-category/([^/]+)/embed/?$\";s:54:\"index.php?dt_portfolio_category=$matches[1]&embed=true\";s:45:\"project-category/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?dt_portfolio_category=$matches[1]&paged=$matches[2]\";s:27:\"project-category/([^/]+)/?$\";s:43:\"index.php?dt_portfolio_category=$matches[1]\";s:40:\"dt_slideshow/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"dt_slideshow/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"dt_slideshow/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"dt_slideshow/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"dt_slideshow/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"dt_slideshow/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"dt_slideshow/([^/]+)/embed/?$\";s:45:\"index.php?dt_slideshow=$matches[1]&embed=true\";s:33:\"dt_slideshow/([^/]+)/trackback/?$\";s:39:\"index.php?dt_slideshow=$matches[1]&tb=1\";s:53:\"dt_slideshow/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?dt_slideshow=$matches[1]&feed=$matches[2]\";s:48:\"dt_slideshow/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?dt_slideshow=$matches[1]&feed=$matches[2]\";s:41:\"dt_slideshow/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?dt_slideshow=$matches[1]&paged=$matches[2]\";s:48:\"dt_slideshow/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?dt_slideshow=$matches[1]&cpage=$matches[2]\";s:38:\"dt_slideshow/([^/]+)/um-api(/(.*))?/?$\";s:53:\"index.php?dt_slideshow=$matches[1]&um-api=$matches[3]\";s:44:\"dt_slideshow/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:55:\"dt_slideshow/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:37:\"dt_slideshow/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?dt_slideshow=$matches[1]&page=$matches[2]\";s:29:\"dt_slideshow/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"dt_slideshow/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"dt_slideshow/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"dt_slideshow/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"dt_slideshow/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"dt_slideshow/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:46:\"arrow_twitter_feed/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"arrow_twitter_feed/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"arrow_twitter_feed/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"arrow_twitter_feed/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"arrow_twitter_feed/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"arrow_twitter_feed/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"arrow_twitter_feed/([^/]+)/embed/?$\";s:50:\"index.php?tfba_twitter_feed=$matches[1]&embed=true\";s:39:\"arrow_twitter_feed/([^/]+)/trackback/?$\";s:44:\"index.php?tfba_twitter_feed=$matches[1]&tb=1\";s:47:\"arrow_twitter_feed/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?tfba_twitter_feed=$matches[1]&paged=$matches[2]\";s:54:\"arrow_twitter_feed/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?tfba_twitter_feed=$matches[1]&cpage=$matches[2]\";s:44:\"arrow_twitter_feed/([^/]+)/um-api(/(.*))?/?$\";s:58:\"index.php?tfba_twitter_feed=$matches[1]&um-api=$matches[3]\";s:50:\"arrow_twitter_feed/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:61:\"arrow_twitter_feed/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:43:\"arrow_twitter_feed/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?tfba_twitter_feed=$matches[1]&page=$matches[2]\";s:35:\"arrow_twitter_feed/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"arrow_twitter_feed/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"arrow_twitter_feed/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"arrow_twitter_feed/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"arrow_twitter_feed/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"arrow_twitter_feed/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:38:\"vc_grid_item/([^/]+)/um-api(/(.*))?/?$\";s:53:\"index.php?vc_grid_item=$matches[1]&um-api=$matches[3]\";s:44:\"vc_grid_item/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:55:\"vc_grid_item/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:36:\"mc4wp-form/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&um-api=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:17:\"um-api(/(.*))?/?$\";s:29:\"index.php?&um-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/um-api(/(.*))?/?$\";s:29:\"index.php?&um-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/um-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&um-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/um-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&um-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/um-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&um-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/um-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&um-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/um-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&um-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/um-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&um-api=$matches[3]\";s:31:\".?.+?/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/um-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&um-api=$matches[3]\";s:31:\"[^/]+/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/um-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&um-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `trvlite_options` VALUES("200743", "akismet_spam_count", "26", "yes");
INSERT INTO `trvlite_options` VALUES("200778", "wordfence_version", "7.1.12", "yes");
INSERT INTO `trvlite_options` VALUES("200779", "wordfence_installed", "1", "yes");
INSERT INTO `trvlite_options` VALUES("200780", "wordfenceActivated", "1", "yes");
INSERT INTO `trvlite_options` VALUES("200781", "wf_plugin_act_error", "", "yes");
INSERT INTO `trvlite_options` VALUES("200802", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1537607904;s:7:\"checked\";a:2:{s:15:\"travelite-child\";s:5:\"1.0.0\";s:9:\"travelite\";s:5:\"4.2.2\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `trvlite_options` VALUES("200818", "aiowpsec_db_version", "1.9", "yes");
INSERT INTO `trvlite_options` VALUES("200819", "aio_wp_security_configs", "a:89:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:0:\"\";s:25:\"aiowps_prevent_hotlinking\";s:1:\"1\";s:28:\"aiowps_enable_login_lockdown\";s:1:\"1\";s:28:\"aiowps_allow_unlock_requests\";s:0:\"\";s:25:\"aiowps_max_login_attempts\";i:5;s:24:\"aiowps_retry_time_period\";i:5;s:26:\"aiowps_lockout_time_length\";i:60;s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:24:\"info@cebuwebconcepts.com\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"0kiuvizv4alkdcsytiim\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:27:\"aiowps_enable_login_captcha\";s:1:\"1\";s:34:\"aiowps_enable_custom_login_captcha\";s:1:\"1\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:25:\"aiowps_captcha_secret_key\";s:20:\"8llcb0vi4x1ean68q2ai\";s:42:\"aiowps_enable_manual_registration_approval\";s:0:\"\";s:39:\"aiowps_enable_registration_page_captcha\";s:0:\"\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:31:\"aiowps_enable_automated_backups\";s:0:\"\";s:26:\"aiowps_db_backup_frequency\";s:1:\"4\";s:25:\"aiowps_db_backup_interval\";s:1:\"2\";s:26:\"aiowps_backup_files_stored\";s:1:\"2\";s:32:\"aiowps_send_backup_email_address\";s:0:\"\";s:27:\"aiowps_backup_email_address\";s:24:\"info@cebuwebconcepts.com\";s:27:\"aiowps_disable_file_editing\";s:1:\"1\";s:37:\"aiowps_prevent_default_wp_file_access\";s:1:\"1\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:1:\"1\";s:31:\"aiowps_enable_pingback_firewall\";s:0:\"\";s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:0:\"\";s:34:\"aiowps_block_debug_log_file_access\";s:0:\"\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:28:\"aiowps_forbid_proxy_comments\";s:0:\"\";s:29:\"aiowps_deny_bad_query_strings\";s:0:\"\";s:34:\"aiowps_advanced_char_string_filter\";s:0:\"\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:0:\"\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:1:\"1\";s:28:\"aiowps_enable_login_honeypot\";s:1:\"1\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:0:\"\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:0:\"\";s:30:\"aiowps_enable_spambot_blocking\";s:0:\"\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:0:\"\";s:33:\"aiowps_spam_ip_min_comments_block\";s:0:\"\";s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";s:1:\"4\";s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:0:\"\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:24:\"info@cebuwebconcepts.com\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:0:\"\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:25:\"aiowps_ip_retrieve_method\";s:1:\"0\";s:22:\"aiowps_login_page_slug\";s:25:\"travelite-login-cms-admin\";s:35:\"aiowps_enable_lost_password_captcha\";s:1:\"1\";}", "yes");
INSERT INTO `trvlite_options` VALUES("200766", "!sbi_header_973906762", "%7B%22data%22:%7B%22id%22:%22973906762%22,%22username%22:%22travelite_ph%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22bio%22:%22%F0%9F%93%AE%20Manila%20I%20Cebu%20I%20Davao%5Cn%E2%98%8E%20Manila%20-%20(02)%20633%208434;%20Cebu%20-%20(032)%20255%203264;%20Davao%20-%20(082)%20305%200146%5Cn#traveliteph%20#travelwithtravelite%22,%22website%22:%22http://www.travelite.com.ph/%22,%22is_business%22:true,%22counts%22:%7B%22media%22:299,%22follows%22:127,%22followed_by%22:999%7D%7D,%22meta%22:%7B%22code%22:200%7D%7D", "no");
INSERT INTO `trvlite_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `trvlite_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `trvlite_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `trvlite_options` VALUES("33", "active_plugins", "a:23:{i:0;s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:3;s:51:\"arrow-twitter-feed/twitter-feed-by-arrowplugins.php\";i:4;s:47:\"bop-search-box-item-type-for-nav-menus/init.php\";i:6;s:59:\"change-default-login-logo-url-and-title/change-logo-url.php\";i:7;s:36:\"contact-form-7/wp-contact-form-7.php\";i:8;s:27:\"convertplug/convertplug.php\";i:9;s:29:\"copy-menu/menu-duplicator.php\";i:10;s:29:\"dt-the7-core/dt-the7-core.php\";i:11;s:33:\"duplicate-post/duplicate-post.php\";i:12;s:25:\"duplicator/duplicator.php\";i:13;s:59:\"editor-menu-and-widget-access/editor-menu-widget-access.php\";i:14;s:31:\"fb-messenger-livechat/fbmsg.php\";i:15;s:33:\"instagram-feed/instagram-feed.php\";i:16;s:27:\"js_composer/js_composer.php\";i:17;s:21:\"like-box/like-box.php\";i:18;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:19;s:23:\"revslider/revslider.php\";i:20;s:33:\"search-exclude/search-exclude.php\";i:21;s:35:\"ultimate-member/ultimate-member.php\";i:22;s:51:\"visual-form-builder-pro/visual-form-builder-pro.php\";i:23;s:23:\"wordfence/wordfence.php\";}", "yes");
INSERT INTO `trvlite_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `trvlite_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `trvlite_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `trvlite_options` VALUES("37", "gmt_offset", "8", "yes");
INSERT INTO `trvlite_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `trvlite_options` VALUES("39", "recently_edited", "a:5:{i:0;s:80:\"/home/travel/public_html/travelite.com.ph/wp-content/plugins/akismet/akismet.php\";i:1;s:92:\"/home/travel/public_html/travelite.com.ph/wp-content/plugins/fb-messenger-livechat/fbmsg.php\";i:3;s:83:\"/home/travel/public_html/travelite.com.ph/wp-content/themes/travelite/functions.php\";i:4;s:85:\"/home/travel/public_html/travelite.com.ph/wp-content/themes/travelite-child/style.css\";i:5;s:79:\"/home/travel/public_html/travelite.com.ph/wp-content/themes/travelite/style.css\";}", "no");
INSERT INTO `trvlite_options` VALUES("40", "template", "travelite", "yes");
INSERT INTO `trvlite_options` VALUES("41", "stylesheet", "travelite-child", "yes");
INSERT INTO `trvlite_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `trvlite_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `trvlite_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `trvlite_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `trvlite_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `trvlite_options` VALUES("47", "default_role", "um_member", "yes");
INSERT INTO `trvlite_options` VALUES("48", "db_version", "38590", "yes");
INSERT INTO `trvlite_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `trvlite_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `trvlite_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `trvlite_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `trvlite_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `trvlite_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `trvlite_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `trvlite_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `trvlite_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `trvlite_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `trvlite_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `trvlite_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `trvlite_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `trvlite_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `trvlite_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `trvlite_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `trvlite_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `trvlite_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `trvlite_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `trvlite_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `trvlite_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `trvlite_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `trvlite_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `trvlite_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `trvlite_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `trvlite_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `trvlite_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `trvlite_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `trvlite_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("78", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("79", "widget_text", "a:5:{i:2;a:3:{s:5:\"title\";s:4:\"CEBU\";s:4:\"text\";s:637:\"<table style=\"width:100%\">\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Address:</th>\r\n    <th class=\"cwc-table-sec-row\">Unit 10, One Mango Avenue, General Maxilom Avenue, Cebu City 6000 Philippines</th> \r\n  </tr>\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Telephone no:</th>\r\n    <th class=\"cwc-table-sec-row\">+6332 255-3264; 261-4316; 406-8314</th> \r\n  </tr>\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Fax no:</th>\r\n    <th class=\"cwc-table-sec-row\">+6332 253-6080</th> \r\n  </tr>\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Mobile no:</th>\r\n    <th class=\"cwc-table-sec-row\">+63917-3081668; +63919-9911013</th> \r\n  </tr>\r\n</table>\";s:6:\"filter\";b:0;}i:3;a:3:{s:5:\"title\";s:6:\"MANILA\";s:4:\"text\";s:613:\"<table style=\"width:100%\">\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Address:</th>\r\n    <th class=\"cwc-table-sec-row\">Unit 1707 Tycoon Center, Pearl Drive, Ortigas Center, Pasig City 1600 Philippines</th> \r\n  </tr>\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Telephone no:</th>\r\n    <th class=\"cwc-table-sec-row\">+632 633-8434; 633-8423</th> \r\n  </tr>\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Fax no:</th>\r\n    <th class=\"cwc-table-sec-row\">+632 633-8434</th> \r\n  </tr>\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Mobile no:</th>\r\n    <th class=\"cwc-table-sec-row\">+63995-6101655</th> \r\n  </tr>\r\n</table>\";s:6:\"filter\";b:0;}i:4;a:3:{s:5:\"title\";s:5:\"DAVAO\";s:4:\"text\";s:1132:\"<table style=\"width:100%\">\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Address:</th>\r\n    <th class=\"cwc-table-sec-row\">Unit 3B Wheels N More Drive, J.P. Laurel Avenue, Bajada, Davao City 8000 Philippines</th> \r\n  </tr>\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Telephone no:</th>\r\n    <th class=\"cwc-table-sec-row\">+6382 305-0146; 330-6372</th> \r\n  </tr>\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Fax no:</th>\r\n    <th class=\"cwc-table-sec-row\">+6382 305-0146</th> \r\n  </tr>\r\n  <tr>\r\n    <th class=\"cwc-table-first-row\">Mobile no:</th>\r\n    <th class=\"cwc-table-sec-row\">+63917-7096473</th> \r\n  </tr>\r\n</table>\r\n<!-- Start of LiveChat (www.livechatinc.com) code -->\r\n<script type=\"text/javascript\">\r\nwindow.__lc = window.__lc || {};\r\nwindow.__lc.license = 8799086;\r\n(function() {\r\n  var lc = document.createElement(\'script\'); lc.type = \'text/javascript\'; lc.async = true;\r\n  lc.src = (\'https:\' == document.location.protocol ? \'https://\' : \'http://\') + \'cdn.livechatinc.com/tracking.js\';\r\n  var s = document.getElementsByTagName(\'script\')[0]; s.parentNode.insertBefore(lc, s);\r\n})();\r\n</script>\r\n<!-- End of LiveChat code -->\";s:6:\"filter\";b:0;}i:6;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:367:\"<div class=\"cwc-title\">REQUEST A QUOTE</div>\r\n<div style=\"padding: 0 25px;\">\r\n<p style=\"font-size: 14px; line-height: 22px;padding-top: 15px;\">Our travel agent will acknowledge your email within 24 hours from Monday-Friday, 8:30am-5:30pm Philippine time.</p>\r\n\r\n<p style=\"font-size: 12px; line-height: 22px;\">Fields marked with * are required.</p>\r\n[vfb id=1]\r\n</div>\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("80", "widget_rss", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("81", "uninstall_plugins", "a:6:{s:35:\"rename-wp-login/rename-wp-login.php\";a:2:{i:0;s:15:\"Rename_WP_Login\";i:1;s:9:\"uninstall\";}s:25:\"go_pricing/go_pricing.php\";a:2:{i:0;s:12:\"GW_GoPricing\";i:1;s:9:\"uninstall\";}s:45:\"hide-plugin-updates-notifications/wphdpuw.php\";s:15:\"wphpuw_unistall\";s:33:\"instagram-feed/instagram-feed.php\";s:22:\"sb_instagram_uninstall\";s:37:\"wp-require-login/wp-require-login.php\";s:12:\"rl_uninstall\";s:19:\"captcha/captcha.php\";s:20:\"cptch_delete_options\";}", "no");
INSERT INTO `trvlite_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `trvlite_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `trvlite_options` VALUES("84", "page_on_front", "2", "yes");
INSERT INTO `trvlite_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `trvlite_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `trvlite_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `trvlite_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `trvlite_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `trvlite_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `trvlite_options` VALUES("91", "initial_db_version", "38590", "yes");
INSERT INTO `trvlite_options` VALUES("92", "trvlite_user_roles", "a:7:{s:13:\"administrator\";a:16:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:86:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:10:\"copy_posts\";b:1;s:16:\"vfb_create_forms\";b:1;s:14:\"vfb_edit_forms\";b:1;s:14:\"vfb_copy_forms\";b:1;s:16:\"vfb_delete_forms\";b:1;s:16:\"vfb_import_forms\";b:1;s:16:\"vfb_export_forms\";b:1;s:16:\"vfb_view_entries\";b:1;s:16:\"vfb_edit_entries\";b:1;s:18:\"vfb_delete_entries\";b:1;s:21:\"vfb_edit_email_design\";b:1;s:18:\"vfb_view_analytics\";b:1;s:17:\"vfb_edit_settings\";b:1;s:9:\"access_cp\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:29:\"tablepress_import_tables_wptr\";b:1;s:23:\"tablepress_edit_options\";b:1;}s:22:\"_um_can_access_wpadmin\";i:1;s:24:\"_um_can_not_see_adminbar\";i:0;s:21:\"_um_can_edit_everyone\";i:1;s:23:\"_um_can_delete_everyone\";i:1;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:20:\"_um_default_homepage\";i:1;s:15:\"_um_after_login\";s:14:\"redirect_admin\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:1;s:30:\"_um_can_access_private_profile\";i:1;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}s:6:\"editor\";a:16:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:48:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:10:\"copy_posts\";b:1;s:16:\"vfb_view_entries\";b:1;s:16:\"vfb_edit_entries\";b:1;s:18:\"vfb_delete_entries\";b:1;s:18:\"vfb_view_analytics\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;}s:22:\"_um_can_access_wpadmin\";i:0;s:24:\"_um_can_not_see_adminbar\";i:1;s:21:\"_um_can_edit_everyone\";i:0;s:23:\"_um_can_delete_everyone\";i:0;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:15:\"_um_after_login\";s:16:\"redirect_profile\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:20:\"_um_default_homepage\";i:1;s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:0;s:30:\"_um_can_access_private_profile\";i:0;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}s:6:\"author\";a:16:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:10:\"copy_posts\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;}s:22:\"_um_can_access_wpadmin\";i:0;s:24:\"_um_can_not_see_adminbar\";i:1;s:21:\"_um_can_edit_everyone\";i:0;s:23:\"_um_can_delete_everyone\";i:0;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:15:\"_um_after_login\";s:16:\"redirect_profile\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:20:\"_um_default_homepage\";i:1;s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:0;s:30:\"_um_can_access_private_profile\";i:0;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}s:11:\"contributor\";a:16:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}s:22:\"_um_can_access_wpadmin\";i:0;s:24:\"_um_can_not_see_adminbar\";i:1;s:21:\"_um_can_edit_everyone\";i:0;s:23:\"_um_can_delete_everyone\";i:0;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:15:\"_um_after_login\";s:16:\"redirect_profile\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:20:\"_um_default_homepage\";i:1;s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:0;s:30:\"_um_can_access_private_profile\";i:0;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}s:10:\"subscriber\";a:35:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}s:22:\"_um_can_access_wpadmin\";s:1:\"0\";s:24:\"_um_can_not_see_adminbar\";s:1:\"1\";s:21:\"_um_can_edit_everyone\";s:1:\"0\";s:23:\"_um_can_delete_everyone\";s:1:\"0\";s:20:\"_um_can_edit_profile\";s:1:\"1\";s:22:\"_um_can_delete_profile\";s:1:\"0\";s:15:\"_um_after_login\";s:12:\"redirect_url\";s:16:\"_um_after_logout\";s:12:\"redirect_url\";s:20:\"_um_default_homepage\";s:1:\"1\";s:16:\"_um_can_view_all\";s:1:\"0\";s:28:\"_um_can_make_private_profile\";s:1:\"0\";s:30:\"_um_can_access_private_profile\";s:1:\"0\";s:10:\"_um_status\";s:7:\"pending\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";s:13:\"_um_is_custom\";s:1:\"0\";s:12:\"_um_priority\";s:0:\"\";s:18:\"_um_can_edit_roles\";s:0:\"\";s:20:\"_um_can_delete_roles\";s:0:\"\";s:18:\"_um_can_view_roles\";s:0:\"\";s:21:\"_um_redirect_homepage\";s:0:\"\";s:20:\"_um_auto_approve_url\";s:0:\"\";s:24:\"_um_login_email_activate\";s:1:\"0\";s:20:\"_um_checkmail_action\";s:12:\"show_message\";s:21:\"_um_checkmail_message\";s:147:\"Thank you for registering. Before you can login we need you to activate your account by clicking the activation link in the email we just sent you.\";s:17:\"_um_checkmail_url\";s:0:\"\";s:22:\"_um_url_email_activate\";s:0:\"\";s:18:\"_um_pending_action\";s:12:\"show_message\";s:19:\"_um_pending_message\";s:187:\"Thanks for sending your registration as Travel Agent to our website. We will review your details and send you an email letting you know whether your registration has been approved or not.\";s:15:\"_um_pending_url\";s:0:\"\";s:22:\"_um_login_redirect_url\";s:44:\"http://travelite.com.ph/promo-tour-packages/\";s:23:\"_um_logout_redirect_url\";s:30:\"http://travelite.com.ph/login/\";s:16:\"_um_after_delete\";s:13:\"redirect_home\";s:23:\"_um_delete_redirect_url\";s:0:\"\";}s:9:\"um_member\";a:35:{s:13:\"_um_is_custom\";s:1:\"1\";s:4:\"name\";s:6:\"Member\";s:12:\"_um_priority\";s:0:\"\";s:22:\"_um_can_access_wpadmin\";s:1:\"0\";s:24:\"_um_can_not_see_adminbar\";s:1:\"1\";s:21:\"_um_can_edit_everyone\";s:1:\"0\";s:18:\"_um_can_edit_roles\";s:0:\"\";s:23:\"_um_can_delete_everyone\";s:1:\"0\";s:20:\"_um_can_delete_roles\";s:0:\"\";s:20:\"_um_can_edit_profile\";s:1:\"1\";s:22:\"_um_can_delete_profile\";s:1:\"0\";s:16:\"_um_can_view_all\";s:1:\"0\";s:18:\"_um_can_view_roles\";s:0:\"\";s:28:\"_um_can_make_private_profile\";s:1:\"0\";s:30:\"_um_can_access_private_profile\";s:1:\"0\";s:20:\"_um_default_homepage\";s:1:\"1\";s:21:\"_um_redirect_homepage\";s:0:\"\";s:10:\"_um_status\";s:7:\"pending\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";s:20:\"_um_auto_approve_url\";s:0:\"\";s:24:\"_um_login_email_activate\";s:1:\"0\";s:20:\"_um_checkmail_action\";s:12:\"show_message\";s:21:\"_um_checkmail_message\";s:147:\"Thank you for registering. Before you can login we need you to activate your account by clicking the activation link in the email we just sent you.\";s:17:\"_um_checkmail_url\";s:0:\"\";s:22:\"_um_url_email_activate\";s:0:\"\";s:18:\"_um_pending_action\";s:12:\"show_message\";s:19:\"_um_pending_message\";s:187:\"Thanks for sending your registration as Travel Agent to our website. We will review your details and send you an email letting you know whether your registration has been approved or not.\";s:15:\"_um_pending_url\";s:0:\"\";s:15:\"_um_after_login\";s:12:\"redirect_url\";s:22:\"_um_login_redirect_url\";s:44:\"http://travelite.com.ph/promo-tour-packages/\";s:16:\"_um_after_logout\";s:12:\"redirect_url\";s:23:\"_um_logout_redirect_url\";s:30:\"http://travelite.com.ph/login/\";s:16:\"_um_after_delete\";s:13:\"redirect_home\";s:23:\"_um_delete_redirect_url\";s:0:\"\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:8:\"um_admin\";a:17:{s:22:\"_um_can_access_wpadmin\";s:1:\"1\";s:24:\"_um_can_not_see_adminbar\";s:1:\"0\";s:21:\"_um_can_edit_everyone\";s:1:\"1\";s:23:\"_um_can_delete_everyone\";s:1:\"1\";s:20:\"_um_can_edit_profile\";s:1:\"1\";s:22:\"_um_can_delete_profile\";s:1:\"1\";s:16:\"_um_can_view_all\";s:1:\"1\";s:28:\"_um_can_make_private_profile\";s:1:\"1\";s:30:\"_um_can_access_private_profile\";s:1:\"1\";s:20:\"_um_default_homepage\";s:1:\"1\";s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";s:15:\"_um_after_login\";s:14:\"redirect_admin\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:4:\"name\";s:5:\"Admin\";s:13:\"_um_is_custom\";b:1;s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}}", "yes");
INSERT INTO `trvlite_options` VALUES("93", "fresh_site", "0", "yes");
INSERT INTO `trvlite_options` VALUES("94", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("95", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("96", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("97", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("98", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("99", "sidebars_widgets", "a:12:{s:19:\"wp_inactive_widgets\";a:3:{i:0;s:4:\"9022\";i:1;s:4:\"9022\";i:2;s:4:\"9022\";}s:9:\"sidebar_1\";a:1:{i:0;s:6:\"text-6\";}s:9:\"sidebar_2\";a:3:{i:0;s:6:\"text-2\";i:1;s:6:\"text-3\";i:2;s:6:\"text-4\";}s:9:\"sidebar_3\";a:1:{i:0;s:18:\"like_box_facbook-2\";}s:9:\"sidebar_4\";a:1:{i:0;s:10:\"nav_menu-2\";}s:9:\"sidebar_5\";a:1:{i:0;s:10:\"nav_menu-3\";}s:9:\"sidebar_6\";a:1:{i:0;s:10:\"nav_menu-4\";}s:9:\"sidebar_7\";a:1:{i:0;s:10:\"nav_menu-5\";}s:9:\"sidebar_8\";a:0:{}s:9:\"sidebar_9\";a:1:{i:0;s:10:\"nav_menu-7\";}s:10:\"sidebar_10\";a:1:{i:0;s:10:\"nav_menu-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `trvlite_options` VALUES("244", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `trvlite_options` VALUES("245", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.0.4\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1490047720;s:7:\"version\";s:3:\"4.7\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `trvlite_options` VALUES("243", "vc_version", "5.0.1", "yes");
INSERT INTO `trvlite_options` VALUES("246", "convert_plug_modules", "a:3:{i:0;s:11:\"Modal_Popup\";i:1;s:8:\"Info_Bar\";i:2;s:14:\"Slide_In_Popup\";}", "yes");
INSERT INTO `trvlite_options` VALUES("100", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("101", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("102", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("103", "widget_nav_menu", "a:7:{i:2;a:2:{s:5:\"title\";s:16:\"VISA INFORMATION\";s:8:\"nav_menu\";i:48;}i:3;a:1:{s:8:\"nav_menu\";i:53;}i:4;a:1:{s:8:\"nav_menu\";i:54;}i:5;a:1:{s:8:\"nav_menu\";i:55;}i:6;a:2:{s:5:\"title\";s:12:\"USER PROFILE\";s:8:\"nav_menu\";i:60;}i:7;a:2:{s:5:\"title\";s:13:\"TOUR PACKAGES\";s:8:\"nav_menu\";i:61;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("104", "cron", "a:22:{i:1537611702;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1537612189;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1537612867;a:1:{s:24:\"aiowps_hourly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1537613898;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537613931;a:1:{s:26:\"um_hourly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1537617531;a:1:{s:30:\"um_twicedaily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1537637294;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1537641667;a:1:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537650171;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537654924;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537655165;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537656563;a:1:{s:28:\"um_check_extensions_licenses\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537660731;a:1:{s:25:\"um_daily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537677300;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537694492;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537694502;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537776000;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1537778999;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"525d8fff98f2516f6afed453b2bddc27\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1537778999;}}}}i:1538038199;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"2f2daa42f60b5ce9836087946e33f09c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1538038199;}}}}i:1538088622;a:1:{s:26:\"um_weekly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1538297399;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"e5400dca04335f3d4726d05320eb9ffa\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1538297399;}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `trvlite_options` VALUES("105", "theme_mods_twentyseventeen", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1490045566;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}", "yes");
INSERT INTO `trvlite_options` VALUES("120", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"info@cebuwebconcepts.com\";s:7:\"version\";s:5:\"4.7.4\";s:9:\"timestamp\";i:1492738503;}", "no");
INSERT INTO `trvlite_options` VALUES("141", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("142", "akismet_strictness", "0", "yes");
INSERT INTO `trvlite_options` VALUES("143", "akismet_show_user_comments_approved", "0", "yes");
INSERT INTO `trvlite_options` VALUES("144", "wordpress_api_key", "e2e8d458a3f9", "yes");
INSERT INTO `trvlite_options` VALUES("2827", "duplicate_post_title_prefix", "", "yes");
INSERT INTO `trvlite_options` VALUES("2828", "duplicate_post_title_suffix", "", "yes");
INSERT INTO `trvlite_options` VALUES("2829", "duplicate_post_increase_menu_order_by", "", "yes");
INSERT INTO `trvlite_options` VALUES("2830", "duplicate_post_roles", "a:3:{i:0;s:13:\"administrator\";i:1;s:6:\"editor\";i:2;s:6:\"author\";}", "yes");
INSERT INTO `trvlite_options` VALUES("8279", "widget_urwa_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("8280", "widget_urwa_widget_logged_in", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("8317", "emwa_settings", "a:43:{s:15:\"emwa_chk_custom\";s:1:\"1\";s:17:\"edit-comments.php\";s:1:\"1\";s:5:\"wpcf7\";s:1:\"1\";s:9:\"wpcf7-new\";s:1:\"1\";s:17:\"wpcf7-integration\";s:1:\"1\";s:9:\"tools.php\";s:1:\"1\";s:10:\"import.php\";s:1:\"1\";s:10:\"export.php\";s:1:\"1\";s:10:\"vc-general\";s:1:\"1\";s:31:\"edit.php?post_type=vc_grid_item\";s:1:\"1\";s:10:\"vc-welcome\";s:1:\"1\";s:11:\"vfb-add-new\";s:1:\"1\";s:16:\"vfb-email-design\";s:1:\"1\";s:11:\"vfb-reports\";s:1:\"1\";s:10:\"vfb-import\";s:1:\"1\";s:10:\"vfb-export\";s:1:\"1\";s:12:\"vfb-settings\";s:1:\"1\";s:17:\"of-options-wizard\";s:1:\"1\";s:13:\"of-skins-menu\";s:1:\"1\";s:16:\"of-branding-menu\";s:1:\"1\";s:17:\"options-framework\";s:1:\"1\";s:13:\"of-fonts-menu\";s:1:\"1\";s:14:\"of-header-menu\";s:1:\"1\";s:19:\"of-contentarea-menu\";s:1:\"1\";s:15:\"of-sidebar-menu\";s:1:\"1\";s:14:\"of-footer-menu\";s:1:\"1\";s:15:\"of-stripes-menu\";s:1:\"1\";s:15:\"of-buttons-menu\";s:1:\"1\";s:26:\"of-blog-and-portfolio-menu\";s:1:\"1\";s:26:\"of-archives-templates-menu\";s:1:\"1\";s:18:\"of-imghoovers-menu\";s:1:\"1\";s:19:\"of-likebuttons-menu\";s:1:\"1\";s:19:\"of-widgetareas-menu\";s:1:\"1\";s:20:\"of-importexport-menu\";s:1:\"1\";s:16:\"of-advanced-menu\";s:1:\"1\";s:11:\"convertplug\";s:1:\"1\";s:20:\"smile-modal-designer\";s:1:\"1\";s:23:\"smile-info_bar-designer\";s:1:\"1\";s:23:\"smile-slide_in-designer\";s:1:\"1\";s:12:\"cp-resources\";s:1:\"1\";s:15:\"contact-manager\";s:1:\"1\";s:23:\"bsf-google-font-manager\";s:1:\"1\";s:14:\"knowledge-base\";s:1:\"1\";}", "yes");
INSERT INTO `trvlite_options` VALUES("2139", "revslider-connection", "1", "yes");
INSERT INTO `trvlite_options` VALUES("2140", "revslider-latest-version", "5.4.8", "yes");
INSERT INTO `trvlite_options` VALUES("2141", "revslider-stable-version", "4.2", "yes");
INSERT INTO `trvlite_options` VALUES("2142", "revslider-notices", "a:10:{i:0;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.0.9\";s:4:\"text\";s:220:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow51_banner.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1 is out\" ></a>\";s:4:\"code\";s:9:\"TPRS51-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.1.4\";s:4:\"text\";s:232:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=515b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_banner515.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS515-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.1.6\";s:4:\"text\";s:230:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=52b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_banner52.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.1.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS515-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.2.9\";s:4:\"text\";s:239:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=530b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_banner_large_5.3.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.3.0 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS530-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.3.9\";s:4:\"text\";s:222:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=54b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_54.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS540-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:5;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.4.1\";s:4:\"text\";s:239:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=542b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_banner_large_542.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.2 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS540-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:6;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.4.4\";s:4:\"text\";s:226:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=545b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_545.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.5 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS545-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:7;O:8:\"stdClass\":7:{s:7:\"version\";s:7:\"5.4.5.1\";s:4:\"text\";s:242:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=5452b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/updatenow_banner_large5452.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.5.2 is out\" ></a>\";s:4:\"code\";s:11:\"TPRS5452-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:8;O:8:\"stdClass\":7:{s:7:\"version\";s:7:\"5.4.5.2\";s:4:\"text\";s:223:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=546b\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/546_update.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.6 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS546-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}i:9;O:8:\"stdClass\":7:{s:7:\"version\";s:7:\"5.4.7.9\";s:4:\"text\";s:231:\"<a href=\"//revolution.themepunch.com/direct-customer-benefits/?ref=548\" target=\"_blank\"><img src=\"//updates.themepunch.tools/banners/revsliderbanner_548.jpg\" style=\"min-width: 50%; max-width:100%\" alt=\"revslider 5.4.8 is out\" ></a>\";s:4:\"code\";s:10:\"TPRS548-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `trvlite_options` VALUES("138", "can_compress_scripts", "1", "no");
INSERT INTO `trvlite_options` VALUES("139", "recently_activated", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("155", "cwll_logo_url", "http://travelite.com.ph", "yes");
INSERT INTO `trvlite_options` VALUES("156", "cwll_logo_title", "Travelite Travel & Tours", "yes");
INSERT INTO `trvlite_options` VALUES("157", "cwll_logo_ad_image_path", "http://travelite.com.ph/wp-content/uploads/2017/05/travelite-admin-logo.png", "yes");
INSERT INTO `trvlite_options` VALUES("150", "rwl_page", "travelite-login-cms-admin", "yes");
INSERT INTO `trvlite_options` VALUES("167", "current_theme", "Travelite Travel &amp; Tours Child Theme", "yes");
INSERT INTO `trvlite_options` VALUES("168", "theme_mods_travelite-child", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:6:{s:7:\"primary\";i:10;s:3:\"top\";i:11;s:10:\"split_left\";i:0;s:11:\"split_right\";i:0;s:6:\"mobile\";i:0;s:6:\"bottom\";i:0;}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `trvlite_options` VALUES("169", "theme_switched", "", "yes");
INSERT INTO `trvlite_options` VALUES("181", "the7_db_version", "4.1.1", "yes");
INSERT INTO `trvlite_options` VALUES("182", "the7_force_regen_css", "", "yes");
INSERT INTO `trvlite_options` VALUES("183", "the7_beautiful_loader_inline_css", "body #load {\n  display: block;\n  height: 100%;\n  overflow: hidden;\n  position: fixed;\n  width: 100%;\n  z-index: 9901;\n  opacity: 1;\n  visibility: visible;\n  -webkit-transition: all .35s ease-out;\n  transition: all .35s ease-out;\n}\nbody #load.loader-removed {\n  opacity: 0;\n  visibility: hidden;\n}\n.load-wrap {\n  width: 100%;\n  height: 100%;\n  background-position: center center;\n  background-repeat: no-repeat;\n  text-align: center;\n}\n.load-wrap > svg {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  -ms-transform: translate(-50%,-50%);\n  -webkit-transform: translate(-50%,-50%);\n  transform: translate(-50%,-50%);\n}\n#load {\n  background-color: #fcfcfb;\n}\n.uil-default rect:not(.bk) {\n  fill: #78cc6d;\n}\n.uil-ring > path {\n  fill: #78cc6d;\n}\n.ring-loader .circle {\n  fill: #78cc6d;\n}\n.ring-loader .moving-circle {\n  fill: #78cc6d;\n}\n.uil-hourglass .glass {\n  stroke: #78cc6d;\n}\n.uil-hourglass .sand {\n  fill: #78cc6d;\n}\n.spinner-loader .load-wrap {\n  background-image: url(\"data:image/svg+xml,%3Csvg width=\'75px\' height=\'75px\' xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 100 100\' preserveAspectRatio=\'xMidYMid\' class=\'uil-default\'%3E%3Crect x=\'0\' y=\'0\' width=\'100\' height=\'100\' fill=\'none\' class=\'bk\'%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(0 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(30 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.08333333333333333s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(60 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.16666666666666666s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(90 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.25s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(120 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.3333333333333333s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(150 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.4166666666666667s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(180 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.5s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(210 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.5833333333333334s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(240 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.6666666666666666s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(270 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.75s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(300 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.8333333333333334s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3Crect  x=\'46.5\' y=\'40\' width=\'7\' height=\'20\' rx=\'5\' ry=\'5\' fill=\'%2378cc6d\' transform=\'rotate(330 50 50) translate(0 -30)\'%3E  %3Canimate attributeName=\'opacity\' from=\'1\' to=\'0\' dur=\'1s\' begin=\'0.9166666666666666s\' repeatCount=\'indefinite\'/%3E%3C/rect%3E%3C/svg%3E\");\n}\n.ring-loader .load-wrap {\n  background-image: url(\"data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 32 32\' width=\'72\' height=\'72\' fill=\'%2378cc6d\'%3E   %3Cpath opacity=\'.25\' d=\'M16 0 A16 16 0 0 0 16 32 A16 16 0 0 0 16 0 M16 4 A12 12 0 0 1 16 28 A12 12 0 0 1 16 4\'/%3E   %3Cpath d=\'M16 0 A16 16 0 0 1 32 16 L28 16 A12 12 0 0 0 16 4z\'%3E     %3CanimateTransform attributeName=\'transform\' type=\'rotate\' from=\'0 16 16\' to=\'360 16 16\' dur=\'0.8s\' repeatCount=\'indefinite\' /%3E   %3C/path%3E %3C/svg%3E\");\n}\n.hourglass-loader .load-wrap {\n  background-image: url(\"data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 32 32\' width=\'72\' height=\'72\' fill=\'%2378cc6d\'%3E   %3Cpath transform=\'translate(2)\' d=\'M0 12 V20 H4 V12z\'%3E      %3Canimate attributeName=\'d\' values=\'M0 12 V20 H4 V12z; M0 4 V28 H4 V4z; M0 12 V20 H4 V12z; M0 12 V20 H4 V12z\' dur=\'1.2s\' repeatCount=\'indefinite\' begin=\'0\' keytimes=\'0;.2;.5;1\' keySplines=\'0.2 0.2 0.4 0.8;0.2 0.6 0.4 0.8;0.2 0.8 0.4 0.8\' calcMode=\'spline\'  /%3E   %3C/path%3E   %3Cpath transform=\'translate(8)\' d=\'M0 12 V20 H4 V12z\'%3E     %3Canimate attributeName=\'d\' values=\'M0 12 V20 H4 V12z; M0 4 V28 H4 V4z; M0 12 V20 H4 V12z; M0 12 V20 H4 V12z\' dur=\'1.2s\' repeatCount=\'indefinite\' begin=\'0.2\' keytimes=\'0;.2;.5;1\' keySplines=\'0.2 0.2 0.4 0.8;0.2 0.6 0.4 0.8;0.2 0.8 0.4 0.8\' calcMode=\'spline\'  /%3E   %3C/path%3E   %3Cpath transform=\'translate(14)\' d=\'M0 12 V20 H4 V12z\'%3E     %3Canimate attributeName=\'d\' values=\'M0 12 V20 H4 V12z; M0 4 V28 H4 V4z; M0 12 V20 H4 V12z; M0 12 V20 H4 V12z\' dur=\'1.2s\' repeatCount=\'indefinite\' begin=\'0.4\' keytimes=\'0;.2;.5;1\' keySplines=\'0.2 0.2 0.4 0.8;0.2 0.6 0.4 0.8;0.2 0.8 0.4 0.8\' calcMode=\'spline\' /%3E   %3C/path%3E   %3Cpath transform=\'translate(20)\' d=\'M0 12 V20 H4 V12z\'%3E     %3Canimate attributeName=\'d\' values=\'M0 12 V20 H4 V12z; M0 4 V28 H4 V4z; M0 12 V20 H4 V12z; M0 12 V20 H4 V12z\' dur=\'1.2s\' repeatCount=\'indefinite\' begin=\'0.6\' keytimes=\'0;.2;.5;1\' keySplines=\'0.2 0.2 0.4 0.8;0.2 0.6 0.4 0.8;0.2 0.8 0.4 0.8\' calcMode=\'spline\' /%3E   %3C/path%3E   %3Cpath transform=\'translate(26)\' d=\'M0 12 V20 H4 V12z\'%3E     %3Canimate attributeName=\'d\' values=\'M0 12 V20 H4 V12z; M0 4 V28 H4 V4z; M0 12 V20 H4 V12z; M0 12 V20 H4 V12z\' dur=\'1.2s\' repeatCount=\'indefinite\' begin=\'0.8\' keytimes=\'0;.2;.5;1\' keySplines=\'0.2 0.2 0.4 0.8;0.2 0.6 0.4 0.8;0.2 0.8 0.4 0.8\' calcMode=\'spline\' /%3E   %3C/path%3E %3C/svg%3E\");\n}\n", "yes");
INSERT INTO `trvlite_options` VALUES("184", "the7_style_version", "4.2.2.b1701171530", "yes");
INSERT INTO `trvlite_options` VALUES("172", "widget_presscore-contact-info-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("173", "widget_presscore-custom-menu-1", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("174", "widget_presscore-custom-menu-2", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("175", "widget_presscore-blog-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("176", "widget_presscore-blog-categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("177", "widget_presscore-progress-bars-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("178", "widget_presscore-contact-form-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("179", "widget_presscore-accordion-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("180", "dt_the7pt_installed_once", "yes", "yes");
INSERT INTO `trvlite_options` VALUES("353", "vfb_pro_db_version", "2.6", "yes");
INSERT INTO `trvlite_options` VALUES("187", "optionsframework", "a:2:{s:2:\"id\";s:33:\"travelitetravelamptourschildtheme\";s:12:\"knownoptions\";a:1:{i:0;s:33:\"travelitetravelamptourschildtheme\";}}", "yes");
INSERT INTO `trvlite_options` VALUES("188", "travelitetravelamptourschildtheme", "a:723:{s:21:\"general-content_width\";s:6:\"1300px\";s:14:\"general-layout\";s:4:\"wide\";s:17:\"general-box_width\";s:6:\"1500px\";s:22:\"general-boxed_bg_color\";s:7:\"#ffffff\";s:22:\"general-boxed_bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:27:\"general-boxed_bg_fullscreen\";b:0;s:22:\"general-boxed_bg_fixed\";b:0;s:16:\"general-bg_color\";s:7:\"#ffffff\";s:18:\"general-bg_opacity\";i:100;s:16:\"general-bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:3:\"top\";}s:21:\"general-bg_fullscreen\";b:0;s:16:\"general-bg_fixed\";b:0;s:30:\"general-content_boxes_bg_color\";s:7:\"#ffffff\";s:32:\"general-content_boxes_bg_opacity\";i:100;s:32:\"general-content_boxes_decoration\";s:6:\"shadow\";s:46:\"general-content_boxes_decoration_outline_color\";s:7:\"#000000\";s:48:\"general-content_boxes_decoration_outline_opacity\";i:0;s:14:\"dividers-color\";s:7:\"#adb0b6\";s:16:\"dividers-opacity\";i:30;s:25:\"general-accent_color_mode\";s:5:\"color\";s:23:\"general-accent_bg_color\";s:7:\"#78cc6d\";s:32:\"general-accent_bg_color_gradient\";a:2:{i:0;s:7:\"#2578e9\";i:1;s:7:\"#3fe7d9\";}s:21:\"general-border_radius\";i:3;s:26:\"general-contact_form_style\";s:7:\"minimal\";s:31:\"general-slideshow_bullets_style\";s:6:\"accent\";s:25:\"general-beautiful_loading\";s:8:\"disabled\";s:37:\"general-fullscreen_overlay_color_mode\";s:5:\"color\";s:32:\"general-fullscreen_overlay_color\";s:7:\"#fcfcfb\";s:35:\"general-fullscreen_overlay_gradient\";a:2:{i:0;s:7:\"#8224e3\";i:1;s:7:\"#dd3333\";}s:34:\"general-fullscreen_overlay_opacity\";i:100;s:21:\"general-spinner_color\";s:7:\"#78cc6d\";s:23:\"general-spinner_opacity\";i:100;s:20:\"general-loader_style\";s:14:\"double_circles\";s:21:\"general-custom_loader\";s:0:\"\";s:6:\"preset\";s:7:\"skin11r\";s:13:\"header-layout\";s:6:\"inline\";s:28:\"header-classic-show_elements\";s:1:\"1\";s:26:\"header-classic-icons_style\";s:4:\"bold\";s:23:\"header-classic-elements\";a:4:{s:12:\"top_bar_left\";a:2:{i:0;s:11:\"custom_menu\";i:1;s:4:\"cart\";}s:13:\"top_bar_right\";a:1:{i:0;s:6:\"search\";}s:15:\"near_menu_right\";a:1:{i:0;s:12:\"social_icons\";}s:15:\"near_logo_right\";a:2:{i:0;s:5:\"phone\";i:1;s:5:\"email\";}}s:51:\"header-classic-elements-near_menu_right-padding-top\";i:0;s:53:\"header-classic-elements-near_menu_right-padding-right\";i:0;s:54:\"header-classic-elements-near_menu_right-padding-bottom\";i:0;s:52:\"header-classic-elements-near_menu_right-padding-left\";i:40;s:50:\"header-classic-elements-near_logo_left-padding-top\";i:0;s:52:\"header-classic-elements-near_logo_left-padding-right\";i:0;s:53:\"header-classic-elements-near_logo_left-padding-bottom\";i:0;s:51:\"header-classic-elements-near_logo_left-padding-left\";i:0;s:51:\"header-classic-elements-near_logo_right-padding-top\";i:0;s:53:\"header-classic-elements-near_logo_right-padding-right\";i:0;s:54:\"header-classic-elements-near_logo_right-padding-bottom\";i:0;s:52:\"header-classic-elements-near_logo_right-padding-left\";i:0;s:27:\"header-inline-show_elements\";s:1:\"1\";s:25:\"header-inline-icons_style\";s:4:\"bold\";s:22:\"header-inline-elements\";a:3:{s:12:\"top_bar_left\";a:1:{i:0;s:5:\"email\";}s:13:\"top_bar_right\";a:1:{i:0;s:11:\"custom_menu\";}s:15:\"near_menu_right\";a:1:{i:0;s:12:\"social_icons\";}}s:50:\"header-inline-elements-near_menu_right-padding-top\";i:0;s:52:\"header-inline-elements-near_menu_right-padding-right\";i:4;s:53:\"header-inline-elements-near_menu_right-padding-bottom\";i:0;s:51:\"header-inline-elements-near_menu_right-padding-left\";i:27;s:26:\"header-split-show_elements\";s:1:\"1\";s:24:\"header-split-icons_style\";s:4:\"bold\";s:21:\"header-split-elements\";a:1:{s:14:\"near_menu_left\";a:1:{i:0;s:5:\"phone\";}}s:48:\"header-split-elements-near_menu_left-padding-top\";i:0;s:50:\"header-split-elements-near_menu_left-padding-right\";i:0;s:51:\"header-split-elements-near_menu_left-padding-bottom\";i:0;s:49:\"header-split-elements-near_menu_left-padding-left\";i:0;s:49:\"header-split-elements-near_menu_right-padding-top\";i:0;s:51:\"header-split-elements-near_menu_right-padding-right\";i:0;s:52:\"header-split-elements-near_menu_right-padding-bottom\";i:0;s:50:\"header-split-elements-near_menu_right-padding-left\";i:0;s:25:\"header-side-show_elements\";s:1:\"1\";s:23:\"header-side-icons_style\";s:4:\"bold\";s:20:\"header-side-elements\";a:1:{s:10:\"below_menu\";a:3:{i:0;s:12:\"social_icons\";i:1;s:5:\"email\";i:2;s:5:\"skype\";}}s:43:\"header-side-elements-below_menu-padding-top\";i:0;s:45:\"header-side-elements-below_menu-padding-right\";i:35;s:46:\"header-side-elements-below_menu-padding-bottom\";i:0;s:44:\"header-side-elements-below_menu-padding-left\";i:35;s:30:\"header-slide_out-show_elements\";s:1:\"1\";s:28:\"header-slide_out-icons_style\";s:4:\"bold\";s:25:\"header-slide_out-elements\";a:1:{s:13:\"side_top_line\";a:3:{i:0;s:5:\"phone\";i:1;s:5:\"email\";i:2;s:5:\"skype\";}}s:46:\"header-slide_out-elements-top_line-padding-top\";i:0;s:48:\"header-slide_out-elements-top_line-padding-right\";i:40;s:49:\"header-slide_out-elements-top_line-padding-bottom\";i:0;s:47:\"header-slide_out-elements-top_line-padding-left\";i:40;s:48:\"header-slide_out-elements-below_menu-padding-top\";i:0;s:50:\"header-slide_out-elements-below_menu-padding-right\";i:0;s:51:\"header-slide_out-elements-below_menu-padding-bottom\";i:0;s:49:\"header-slide_out-elements-below_menu-padding-left\";i:0;s:28:\"header-overlay-show_elements\";s:1:\"1\";s:26:\"header-overlay-icons_style\";s:4:\"bold\";s:23:\"header-overlay-elements\";a:2:{s:10:\"below_menu\";a:2:{i:0;s:6:\"search\";i:1;s:4:\"cart\";}s:13:\"side_top_line\";a:3:{i:0;s:12:\"social_icons\";i:1;s:9:\"text_area\";i:2;s:5:\"phone\";}}s:44:\"header-overlay-elements-top_line-padding-top\";i:0;s:46:\"header-overlay-elements-top_line-padding-right\";i:40;s:47:\"header-overlay-elements-top_line-padding-bottom\";i:0;s:45:\"header-overlay-elements-top_line-padding-left\";i:40;s:46:\"header-overlay-elements-below_menu-padding-top\";i:0;s:48:\"header-overlay-elements-below_menu-padding-right\";i:0;s:49:\"header-overlay-elements-below_menu-padding-bottom\";i:0;s:47:\"header-overlay-elements-below_menu-padding-left\";i:0;s:28:\"header-classic-logo-position\";s:4:\"left\";s:28:\"header-classic-menu-position\";s:4:\"left\";s:30:\"header-classic-menu-margin-top\";i:0;s:33:\"header-classic-menu-margin-bottom\";i:0;s:21:\"header-classic-height\";i:180;s:27:\"header-classic-is_fullwidth\";s:1:\"0\";s:27:\"header-inline-menu-position\";s:5:\"right\";s:20:\"header-inline-height\";i:85;s:26:\"header-inline-is_fullwidth\";s:1:\"0\";s:26:\"header-split-menu-position\";s:7:\"justify\";s:19:\"header-split-height\";i:100;s:25:\"header-split-is_fullwidth\";s:1:\"0\";s:20:\"header-side-position\";s:5:\"right\";s:17:\"header-side-width\";s:5:\"300px\";s:25:\"header-side-content-width\";s:5:\"300px\";s:28:\"header-side-content-position\";s:6:\"center\";s:31:\"header-side-content-padding-top\";i:50;s:33:\"header-side-content-padding-right\";i:0;s:34:\"header-side-content-padding-bottom\";i:40;s:32:\"header-side-content-padding-left\";i:0;s:25:\"header-side-menu-position\";s:5:\"v_top\";s:25:\"header-side-logo-position\";s:6:\"inside\";s:28:\"header-side-menu-padding-top\";i:50;s:31:\"header-side-menu-padding-bottom\";i:50;s:32:\"header-side-menu-items_alignment\";s:6:\"center\";s:27:\"header-side-menu-items_link\";s:9:\"fullwidth\";s:23:\"header-slide_out-layout\";s:9:\"menu_icon\";s:52:\"header-slide_out-layout-menu_icon-show_floating_logo\";s:1:\"1\";s:39:\"header-slide_out-layout-top_line-height\";i:90;s:45:\"header-slide_out-layout-top_line-is_fullwidth\";s:1:\"1\";s:46:\"header-slide_out-layout-top_line-logo-position\";s:4:\"left\";s:39:\"header-slide_out-layout-side_line-width\";i:60;s:42:\"header-slide_out-layout-side_line-position\";s:5:\"under\";s:25:\"header-slide_out-position\";s:4:\"left\";s:34:\"header-slide_out-overlay-animation\";s:4:\"fade\";s:22:\"header-slide_out-width\";s:5:\"400px\";s:30:\"header-slide_out-content-width\";s:5:\"350px\";s:33:\"header-slide_out-content-position\";s:6:\"center\";s:36:\"header-slide_out-content-padding-top\";i:50;s:38:\"header-slide_out-content-padding-right\";i:0;s:39:\"header-slide_out-content-padding-bottom\";i:50;s:37:\"header-slide_out-content-padding-left\";i:0;s:30:\"header-slide_out-menu-position\";s:5:\"v_top\";s:30:\"header-slide_out-logo-position\";s:12:\"fully_inside\";s:33:\"header-slide_out-menu-padding-top\";i:40;s:36:\"header-slide_out-menu-padding-bottom\";i:40;s:37:\"header-slide_out-menu-items_alignment\";s:6:\"center\";s:32:\"header-slide_out-menu-items_link\";s:9:\"fullwidth\";s:21:\"header-overlay-layout\";s:9:\"menu_icon\";s:50:\"header-overlay-layout-menu_icon-show_floating_logo\";s:1:\"1\";s:37:\"header-overlay-layout-top_line-height\";i:130;s:43:\"header-overlay-layout-top_line-is_fullwidth\";s:1:\"0\";s:44:\"header-overlay-layout-top_line-logo-position\";s:4:\"left\";s:37:\"header-overlay-layout-side_line-width\";i:60;s:28:\"header-overlay-content-width\";s:5:\"300px\";s:31:\"header-overlay-content-position\";s:6:\"center\";s:34:\"header-overlay-content-padding-top\";i:0;s:36:\"header-overlay-content-padding-right\";i:0;s:37:\"header-overlay-content-padding-bottom\";i:0;s:35:\"header-overlay-content-padding-left\";i:0;s:28:\"header-overlay-menu-position\";s:8:\"v_center\";s:28:\"header-overlay-logo-position\";s:12:\"fully_inside\";s:31:\"header-overlay-menu-padding-top\";i:40;s:34:\"header-overlay-menu-padding-bottom\";i:40;s:35:\"header-overlay-menu-items_alignment\";s:6:\"center\";s:30:\"header-overlay-menu-items_link\";s:9:\"fullwidth\";s:19:\"top_bar-font-family\";s:13:\"Open Sans:600\";s:17:\"top_bar-font-size\";i:13;s:27:\"top_bar-font-is_capitalized\";b:0;s:18:\"top_bar-font-color\";s:7:\"#ffffff\";s:20:\"top_bar-paddings-top\";i:6;s:23:\"top_bar-paddings-bottom\";i:6;s:27:\"top_bar-paddings-horizontal\";i:6;s:16:\"top_bar-bg-style\";s:5:\"solid\";s:16:\"top_bar-bg-color\";s:7:\"#46a24d\";s:18:\"top_bar-bg-opacity\";i:100;s:16:\"top_bar-bg-image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:15:\"header-bg-color\";s:7:\"#fcfcfb\";s:17:\"header-bg-opacity\";i:100;s:15:\"header-bg-image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:23:\"header-bg-is_fullscreen\";b:0;s:18:\"header-bg-is_fixed\";b:0;s:17:\"header-decoration\";s:6:\"shadow\";s:23:\"header-decoration-color\";s:7:\"#dd3333\";s:25:\"header-decoration-opacity\";i:100;s:28:\"header-classic-menu-bg-style\";s:5:\"solid\";s:28:\"header-classic-menu-bg-color\";s:7:\"#000000\";s:30:\"header-classic-menu-bg-opacity\";i:100;s:21:\"header-menu_icon-size\";s:6:\"medium\";s:22:\"header-menu_icon-color\";s:7:\"#000000\";s:25:\"header-menu_icon-bg-color\";s:7:\"#ffffff\";s:27:\"header-menu_icon-bg-opacity\";i:75;s:28:\"header-menu_icon-hover-color\";s:7:\"#000000\";s:31:\"header-menu_icon-hover-bg-color\";s:7:\"#ffffff\";s:33:\"header-menu_icon-hover-bg-opacity\";i:75;s:27:\"header-menu_icon-margin-top\";i:0;s:29:\"header-menu_icon-margin-right\";i:0;s:30:\"header-menu_icon-margin-bottom\";i:0;s:28:\"header-menu_icon-margin-left\";i:0;s:24:\"header-menu_icon-bg-size\";i:54;s:33:\"header-menu_icon-bg-border-radius\";i:0;s:23:\"header-mixed-decoration\";s:6:\"shadow\";s:29:\"header-mixed-decoration-color\";s:7:\"#dd9933\";s:31:\"header-mixed-decoration-opacity\";i:100;s:21:\"header-mixed-bg-color\";s:7:\"#ffffff\";s:23:\"header-mixed-bg-opacity\";i:100;s:39:\"header-slide_out-overlay-bg-color-style\";s:5:\"color\";s:33:\"header-slide_out-overlay-bg-color\";s:7:\"#000000\";s:36:\"header-slide_out-overlay-bg-gradient\";a:2:{i:0;s:7:\"#cdb7e2\";i:1;s:7:\"#821482\";}s:35:\"header-slide_out-overlay-bg-opacity\";i:50;s:29:\"header-slide_out-overlay-blur\";s:1:\"0\";s:33:\"header-slide_out-overlay-x_cursor\";s:1:\"0\";s:39:\"header-slide_out-overlay-x_cursor-color\";s:7:\"#ffffff\";s:41:\"header-slide_out-overlay-x_cursor-opacity\";i:100;s:23:\"header-menu-font-family\";s:13:\"Open Sans:700\";s:21:\"header-menu-font-size\";i:16;s:31:\"header-menu-font-is_capitalized\";s:1:\"1\";s:32:\"header-menu-subtitle-font-family\";s:15:\"Arial:400italic\";s:30:\"header-menu-subtitle-font-size\";i:11;s:22:\"header-menu-font-color\";s:7:\"#3a3a3a\";s:34:\"header-menu-hover-font-color-style\";s:6:\"accent\";s:28:\"header-menu-hover-font-color\";s:7:\"#ffffff\";s:31:\"header-menu-hover-font-gradient\";a:2:{i:0;s:7:\"#8224e3\";i:1;s:7:\"#751257\";}s:40:\"header-menu-active_item-font-color-style\";s:6:\"accent\";s:34:\"header-menu-active_item-font-color\";s:7:\"#ffffff\";s:37:\"header-menu-active_item-font-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:21:\"header-menu-icon-size\";i:14;s:31:\"header-menu-show_next_lvl_icons\";b:0;s:28:\"header-menu-item-padding-top\";i:10;s:30:\"header-menu-item-padding-right\";i:18;s:31:\"header-menu-item-padding-bottom\";i:10;s:29:\"header-menu-item-padding-left\";i:18;s:27:\"header-menu-item-margin-top\";i:10;s:29:\"header-menu-item-margin-right\";i:5;s:30:\"header-menu-item-margin-bottom\";i:10;s:28:\"header-menu-item-margin-left\";i:5;s:39:\"header-menu-item-surround_margins-style\";s:8:\"disabled\";s:47:\"header-menu-item-surround_margins-custom-margin\";i:-20;s:47:\"header-menu-decoration-other-links-is_justified\";s:1:\"0\";s:25:\"header-menu-show_dividers\";s:1:\"0\";s:33:\"header-menu-dividers-height-style\";s:6:\"custom\";s:27:\"header-menu-dividers-height\";i:20;s:29:\"header-menu-dividers-surround\";s:1:\"0\";s:26:\"header-menu-dividers-color\";s:7:\"#000000\";s:28:\"header-menu-dividers-opacity\";i:15;s:28:\"header-menu-decoration-style\";s:5:\"other\";s:42:\"header-menu-decoration-underline-direction\";s:7:\"upwards\";s:44:\"header-menu-decoration-underline-color-style\";s:6:\"accent\";s:38:\"header-menu-decoration-underline-color\";s:7:\"#ffffff\";s:41:\"header-menu-decoration-underline-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:42:\"header-menu-decoration-underline-line_size\";s:1:\"2\";s:40:\"header-menu-decoration-other-hover-style\";s:10:\"background\";s:46:\"header-menu-decoration-other-hover-color-style\";s:6:\"accent\";s:40:\"header-menu-decoration-other-hover-color\";s:7:\"#ffffff\";s:43:\"header-menu-decoration-other-hover-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:36:\"header-menu-decoration-other-opacity\";i:15;s:39:\"header-menu-decoration-other-hover-line\";s:1:\"0\";s:51:\"header-menu-decoration-other-hover-line-color-style\";s:8:\"gradient\";s:45:\"header-menu-decoration-other-hover-line-color\";s:7:\"#dd3333\";s:48:\"header-menu-decoration-other-hover-line-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:47:\"header-menu-decoration-other-hover-line-opacity\";i:23;s:41:\"header-menu-decoration-other-active-style\";s:10:\"background\";s:47:\"header-menu-decoration-other-active-color-style\";s:6:\"accent\";s:41:\"header-menu-decoration-other-active-color\";s:7:\"#ffffff\";s:44:\"header-menu-decoration-other-active-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:43:\"header-menu-decoration-other-active-opacity\";i:0;s:40:\"header-menu-decoration-other-active-line\";s:1:\"0\";s:52:\"header-menu-decoration-other-active-line-color-style\";s:5:\"color\";s:46:\"header-menu-decoration-other-active-line-color\";s:7:\"#8224e3\";s:49:\"header-menu-decoration-other-active-line-gradient\";a:2:{i:0;s:7:\"#dd3333\";i:1;s:7:\"#81d742\";}s:48:\"header-menu-decoration-other-active-line-opacity\";i:30;s:40:\"header-menu-decoration-other-click_decor\";s:1:\"1\";s:52:\"header-menu-decoration-other-click_decor-color-style\";s:5:\"color\";s:46:\"header-menu-decoration-other-click_decor-color\";s:7:\"#ffffff\";s:49:\"header-menu-decoration-other-click_decor-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:48:\"header-menu-decoration-other-click_decor-opacity\";i:30;s:42:\"header-menu-decoration-other-border-radius\";i:25;s:38:\"header-menu-decoration-other-line_size\";s:1:\"2\";s:31:\"header-menu-submenu-font-family\";s:13:\"Open Sans:600\";s:29:\"header-menu-submenu-font-size\";i:15;s:37:\"header-menu-submenu-font-is_uppercase\";s:1:\"1\";s:40:\"header-menu-submenu-subtitle-font-family\";s:15:\"Arial:400italic\";s:38:\"header-menu-submenu-subtitle-font-size\";i:10;s:30:\"header-menu-submenu-font-color\";s:7:\"#ffffff\";s:42:\"header-menu-submenu-hover-font-color-style\";s:5:\"color\";s:36:\"header-menu-submenu-hover-font-color\";s:7:\"#ffffff\";s:39:\"header-menu-submenu-hover-font-gradient\";a:2:{i:0;s:7:\"#81d742\";i:1;s:7:\"#eeee22\";}s:43:\"header-menu-submenu-active-font-color-style\";s:5:\"color\";s:37:\"header-menu-submenu-active-font-color\";s:7:\"#000000\";s:40:\"header-menu-submenu-active-font-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:29:\"header-menu-submenu-icon-size\";i:14;s:39:\"header-menu-submenu-show_next_lvl_icons\";s:1:\"1\";s:39:\"header-menu-submenu-parent_is_clickable\";s:1:\"1\";s:36:\"header-menu-submenu-item-padding-top\";i:8;s:38:\"header-menu-submenu-item-padding-right\";i:10;s:39:\"header-menu-submenu-item-padding-bottom\";i:8;s:37:\"header-menu-submenu-item-padding-left\";i:10;s:35:\"header-menu-submenu-item-margin-top\";i:0;s:37:\"header-menu-submenu-item-margin-right\";i:0;s:38:\"header-menu-submenu-item-margin-bottom\";i:0;s:36:\"header-menu-submenu-item-margin-left\";i:0;s:28:\"header-menu-submenu-bg-color\";s:7:\"#46a24d\";s:30:\"header-menu-submenu-bg-opacity\";i:100;s:28:\"header-menu-submenu-bg-width\";i:250;s:28:\"header-menu-submenu-bg-hover\";s:19:\"animated_background\";s:33:\"header-side-menu-submenu-position\";s:4:\"down\";s:37:\"header-elements-near_menu-font_family\";s:13:\"Open Sans:600\";s:35:\"header-elements-near_menu-font_size\";i:15;s:36:\"header-elements-near_menu-font_color\";s:7:\"#3a3a3a\";s:37:\"header-elements-near_logo-font_family\";s:13:\"Open Sans:600\";s:35:\"header-elements-near_logo-font_size\";i:14;s:36:\"header-elements-near_logo-font_color\";s:7:\"#3a3a3a\";s:30:\"header-elements-search-caption\";s:19:\"Search this website\";s:27:\"header-elements-search-icon\";s:1:\"1\";s:34:\"header-elements-search-on-desktops\";s:4:\"show\";s:42:\"header-elements-search-first-header-switch\";s:9:\"near_logo\";s:43:\"header-elements-search-second-header-switch\";s:9:\"near_logo\";s:39:\"header-elements-contact-address-caption\";s:44:\"8500 Beverly Boulevard Los Angeles, CA 90048\";s:36:\"header-elements-contact-address-icon\";s:1:\"1\";s:43:\"header-elements-contact-address-on-desktops\";s:4:\"show\";s:51:\"header-elements-contact-address-first-header-switch\";s:9:\"near_logo\";s:52:\"header-elements-contact-address-second-header-switch\";s:7:\"in_menu\";s:37:\"header-elements-contact-phone-caption\";s:14:\"+6332 255-3264\";s:34:\"header-elements-contact-phone-icon\";s:1:\"1\";s:41:\"header-elements-contact-phone-on-desktops\";s:4:\"show\";s:49:\"header-elements-contact-phone-first-header-switch\";s:9:\"near_logo\";s:50:\"header-elements-contact-phone-second-header-switch\";s:6:\"hidden\";s:37:\"header-elements-contact-email-caption\";s:64:\"<a href=\"mailto:info@travelite.com.ph\">info@travelite.com.ph</a>\";s:34:\"header-elements-contact-email-icon\";s:1:\"1\";s:41:\"header-elements-contact-email-on-desktops\";s:4:\"show\";s:49:\"header-elements-contact-email-first-header-switch\";s:9:\"near_logo\";s:50:\"header-elements-contact-email-second-header-switch\";s:6:\"hidden\";s:37:\"header-elements-contact-skype-caption\";s:10:\"Your_Skype\";s:34:\"header-elements-contact-skype-icon\";s:1:\"1\";s:41:\"header-elements-contact-skype-on-desktops\";s:4:\"show\";s:49:\"header-elements-contact-skype-first-header-switch\";s:9:\"near_logo\";s:50:\"header-elements-contact-skype-second-header-switch\";s:7:\"in_menu\";s:37:\"header-elements-contact-clock-caption\";s:31:\"Monday – Saturday 9AM – 6PM\";s:34:\"header-elements-contact-clock-icon\";s:1:\"1\";s:41:\"header-elements-contact-clock-on-desktops\";s:4:\"show\";s:49:\"header-elements-contact-clock-first-header-switch\";s:9:\"near_logo\";s:50:\"header-elements-contact-clock-second-header-switch\";s:6:\"hidden\";s:29:\"header-elements-login-caption\";s:5:\"Login\";s:30:\"header-elements-logout-caption\";s:6:\"Logout\";s:26:\"header-elements-login-icon\";s:1:\"1\";s:33:\"header-elements-login-on-desktops\";s:4:\"show\";s:41:\"header-elements-login-first-header-switch\";s:9:\"near_logo\";s:42:\"header-elements-login-second-header-switch\";s:7:\"in_menu\";s:25:\"header-elements-login-url\";s:22:\"http://themeforest.net\";s:32:\"header-elements-text-on-desktops\";s:4:\"show\";s:40:\"header-elements-text-first-header-switch\";s:9:\"near_logo\";s:41:\"header-elements-text-second-header-switch\";s:7:\"in_menu\";s:20:\"header-elements-text\";s:35:\"Some call to action text goes here!\";s:34:\"header-elements-text-2-on-desktops\";s:4:\"show\";s:42:\"header-elements-text-2-first-header-switch\";s:9:\"near_logo\";s:43:\"header-elements-text-2-second-header-switch\";s:7:\"in_menu\";s:22:\"header-elements-text-2\";s:35:\"Some call to action text goes here!\";s:34:\"header-elements-text-3-on-desktops\";s:4:\"show\";s:42:\"header-elements-text-3-first-header-switch\";s:9:\"near_logo\";s:43:\"header-elements-text-3-second-header-switch\";s:7:\"in_menu\";s:22:\"header-elements-text-3\";s:35:\"Some call to action text goes here!\";s:32:\"header-elements-menu-on-desktops\";s:4:\"show\";s:40:\"header-elements-menu-first-header-switch\";s:9:\"near_logo\";s:41:\"header-elements-menu-second-header-switch\";s:7:\"in_menu\";s:26:\"header-elements-menu-style\";s:4:\"list\";s:37:\"header-elements-soc_icons-on-desktops\";s:4:\"show\";s:45:\"header-elements-soc_icons-first-header-switch\";s:9:\"near_logo\";s:46:\"header-elements-soc_icons-second-header-switch\";s:7:\"in_menu\";s:31:\"header-elements-soc_icons-color\";s:7:\"#ffffff\";s:28:\"header-elements-soc_icons-bg\";s:8:\"disabled\";s:34:\"header-elements-soc_icons-bg-color\";s:7:\"#78cc6d\";s:36:\"header-elements-soc_icons-bg-opacity\";i:100;s:37:\"header-elements-soc_icons-bg-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:37:\"header-elements-soc_icons-hover-color\";s:7:\"#ffffff\";s:34:\"header-elements-soc_icons-hover-bg\";s:5:\"color\";s:40:\"header-elements-soc_icons-hover-bg-color\";s:7:\"#000000\";s:42:\"header-elements-soc_icons-bg-hover-opacity\";i:100;s:43:\"header-elements-soc_icons-hover-bg-gradient\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:25:\"header-elements-soc_icons\";a:5:{i:1;a:2:{s:4:\"icon\";s:8:\"facebook\";s:3:\"url\";s:46:\"https://www.facebook.com/travelitephilippines/\";}i:3;a:2:{s:4:\"icon\";s:9:\"instagram\";s:3:\"url\";s:39:\"https://www.instagram.com/travelite_ph/\";}i:2;a:2:{s:4:\"icon\";s:7:\"twitter\";s:3:\"url\";s:34:\"https://twitter.com/travelite_cebu\";}i:4;a:2:{s:4:\"icon\";s:8:\"you-tube\";s:3:\"url\";s:50:\"https://www.youtube.com/user/travelitephilippines/\";}i:5;a:2:{s:4:\"icon\";s:8:\"linkedin\";s:3:\"url\";s:65:\"https://www.linkedin.com/in/travelite-travel-and-tours-a86458141/\";}}s:31:\"header-show_floating_navigation\";s:1:\"1\";s:32:\"header-floating_navigation-style\";s:4:\"fade\";s:37:\"header-floating_navigation-show_after\";i:140;s:33:\"header-floating_navigation-height\";i:60;s:35:\"header-floating_navigation-bg-color\";s:7:\"#fcfcfb\";s:37:\"header-floating_navigation-bg-opacity\";i:100;s:37:\"header-floating_navigation-decoration\";s:6:\"shadow\";s:43:\"header-floating_navigation-decoration-color\";s:7:\"#dd3333\";s:45:\"header-floating_navigation-decoration-opacity\";i:100;s:32:\"header-mobile-first_switch-after\";i:990;s:33:\"header-mobile-first_switch-layout\";s:12:\"right_center\";s:33:\"header-mobile-first_switch-height\";i:80;s:33:\"header-mobile-second_switch-after\";i:600;s:34:\"header-mobile-second_switch-layout\";s:12:\"right_center\";s:34:\"header-mobile-second_switch-height\";i:80;s:33:\"header-mobile-floating_navigation\";s:9:\"menu_icon\";s:30:\"header-mobile-menu-font-family\";s:13:\"Open Sans:700\";s:28:\"header-mobile-menu-font-size\";i:16;s:38:\"header-mobile-menu-font-is_capitalized\";s:1:\"1\";s:33:\"header-mobile-submenu-font-family\";s:13:\"Open Sans:700\";s:31:\"header-mobile-submenu-font-size\";i:16;s:41:\"header-mobile-submenu-font-is_capitalized\";b:0;s:29:\"header-mobile-menu-font-color\";s:7:\"#3a3a3a\";s:41:\"header-mobile-menu-font-hover-color-style\";s:6:\"accent\";s:35:\"header-mobile-menu-font-hover-color\";s:7:\"#3c3e45\";s:38:\"header-mobile-menu-font-hover-gradient\";a:2:{i:0;s:7:\"#b78ce2\";i:1;s:7:\"#1e73be\";}s:27:\"header-mobile-menu-bg-color\";s:7:\"#fcfcfb\";s:29:\"header-mobile-menu-bg-opacity\";i:100;s:27:\"header-mobile-menu-bg-width\";i:330;s:24:\"header-mobile-menu-align\";s:5:\"right\";s:19:\"header-logo_regular\";a:2:{i:0;s:75:\"/wp-content/uploads/2017/04/travelite-travel-and-tours-philippines-logo.png\";i:1;i:1022;}s:14:\"header-logo_hd\";a:2:{i:0;s:75:\"/wp-content/uploads/2017/04/travelite-travel-and-tours-philippines-logo.png\";i:1;i:1022;}s:23:\"header-logo-padding-top\";i:0;s:25:\"header-logo-padding-right\";i:5;s:26:\"header-logo-padding-bottom\";i:0;s:24:\"header-logo-padding-left\";i:5;s:37:\"header-style-transparent-logo_regular\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:32:\"header-style-transparent-logo_hd\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:41:\"header-style-transparent-logo-padding-top\";i:0;s:43:\"header-style-transparent-logo-padding-right\";i:5;s:44:\"header-style-transparent-logo-padding-bottom\";i:0;s:42:\"header-style-transparent-logo-padding-left\";i:5;s:31:\"header-style-mixed-logo_regular\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:26:\"header-style-mixed-logo_hd\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:35:\"header-style-mixed-logo-padding-top\";i:0;s:37:\"header-style-mixed-logo-padding-right\";i:0;s:38:\"header-style-mixed-logo-padding-bottom\";i:0;s:36:\"header-style-mixed-logo-padding-left\";i:0;s:33:\"header-style-floating-choose_logo\";s:6:\"custom\";s:34:\"header-style-floating-logo_regular\";a:2:{i:0;s:82:\"/wp-content/uploads/2017/04/travelite-travel-and-tours-philippines-logo-sticky.png\";i:1;i:1023;}s:29:\"header-style-floating-logo_hd\";a:2:{i:0;s:82:\"/wp-content/uploads/2017/04/travelite-travel-and-tours-philippines-logo-sticky.png\";i:1;i:1023;}s:38:\"header-style-floating-logo-padding-top\";i:0;s:40:\"header-style-floating-logo-padding-right\";i:5;s:41:\"header-style-floating-logo-padding-bottom\";i:0;s:39:\"header-style-floating-logo-padding-left\";i:5;s:31:\"header-mobile-first_switch-logo\";s:7:\"desktop\";s:32:\"header-mobile-second_switch-logo\";s:7:\"desktop\";s:32:\"header-style-mobile-logo_regular\";a:2:{i:0;s:38:\"/images/logo-small-dummy.png?w=60&h=60\";i:1;i:0;}s:27:\"header-style-mobile-logo_hd\";a:2:{i:0;s:43:\"/images/logo-small-dummy-hd.png?w=120&h=120\";i:1;i:0;}s:36:\"header-style-mobile-logo-padding-top\";i:0;s:38:\"header-style-mobile-logo-padding-right\";i:0;s:39:\"header-style-mobile-logo-padding-bottom\";i:0;s:37:\"header-style-mobile-logo-padding-left\";i:0;s:23:\"bottom_bar-logo_regular\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:18:\"bottom_bar-logo_hd\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:27:\"bottom_bar-logo-padding-top\";i:0;s:29:\"bottom_bar-logo-padding-right\";i:0;s:30:\"bottom_bar-logo-padding-bottom\";i:0;s:28:\"bottom_bar-logo-padding-left\";i:0;s:15:\"general-favicon\";s:35:\"/wp-content/uploads/2017/03/fav.png\";s:18:\"general-favicon_hd\";s:35:\"/wp-content/uploads/2017/03/fav.png\";s:32:\"general-handheld_icon-old_iphone\";s:0:\"\";s:30:\"general-handheld_icon-old_ipad\";s:0:\"\";s:35:\"general-handheld_icon-retina_iphone\";s:0:\"\";s:33:\"general-handheld_icon-retina_ipad\";s:0:\"\";s:21:\"bottom_bar-copyrights\";s:125:\"<i class=\"fa fa-copyright\"></i> 2018 <a href=\"http://travelite.com.ph\">Travelite Travel &amp; Tours</a>. All Rights Reserved.\";s:18:\"bottom_bar-credits\";b:0;s:22:\"stripes-stripe_1_color\";s:7:\"#1d1d1d\";s:25:\"stripes-stripe_1_bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:24:\"stripes-stripe_1_outline\";s:4:\"hide\";s:30:\"stripes-stripe_1_outline_color\";s:7:\"#44bb70\";s:32:\"stripes-stripe_1_outline_opacity\";i:100;s:39:\"stripes-stripe_1_content_boxes_bg_color\";s:7:\"#ffffff\";s:41:\"stripes-stripe_1_content_boxes_bg_opacity\";i:15;s:41:\"stripes-stripe_1_content_boxes_decoration\";s:4:\"none\";s:55:\"stripes-stripe_1_content_boxes_decoration_outline_color\";s:7:\"#dd3333\";s:57:\"stripes-stripe_1_content_boxes_decoration_outline_opacity\";i:100;s:30:\"stripes-stripe_1_headers_color\";s:7:\"#fcfcfb\";s:27:\"stripes-stripe_1_text_color\";s:7:\"#ffffff\";s:22:\"stripes-stripe_2_color\";s:7:\"#e6e4e1\";s:25:\"stripes-stripe_2_bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:24:\"stripes-stripe_2_outline\";s:4:\"hide\";s:30:\"stripes-stripe_2_outline_color\";s:7:\"#c1edaf\";s:32:\"stripes-stripe_2_outline_opacity\";i:100;s:39:\"stripes-stripe_2_content_boxes_bg_color\";s:7:\"#fcfcfb\";s:41:\"stripes-stripe_2_content_boxes_bg_opacity\";i:100;s:41:\"stripes-stripe_2_content_boxes_decoration\";s:6:\"shadow\";s:55:\"stripes-stripe_2_content_boxes_decoration_outline_color\";s:7:\"#807e7d\";s:57:\"stripes-stripe_2_content_boxes_decoration_outline_opacity\";i:18;s:30:\"stripes-stripe_2_headers_color\";s:7:\"#3a3a3a\";s:27:\"stripes-stripe_2_text_color\";s:7:\"#807e7d\";s:22:\"stripes-stripe_3_color\";s:7:\"#1d1d1d\";s:25:\"stripes-stripe_3_bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:24:\"stripes-stripe_3_outline\";s:4:\"hide\";s:30:\"stripes-stripe_3_outline_color\";s:7:\"#FFFFFF\";s:32:\"stripes-stripe_3_outline_opacity\";i:100;s:39:\"stripes-stripe_3_content_boxes_bg_color\";s:7:\"#fcfcfb\";s:41:\"stripes-stripe_3_content_boxes_bg_opacity\";i:15;s:41:\"stripes-stripe_3_content_boxes_decoration\";s:4:\"none\";s:55:\"stripes-stripe_3_content_boxes_decoration_outline_color\";s:7:\"#ffffff\";s:57:\"stripes-stripe_3_content_boxes_decoration_outline_opacity\";i:100;s:30:\"stripes-stripe_3_headers_color\";s:7:\"#fcfcfb\";s:27:\"stripes-stripe_3_text_color\";s:7:\"#fcfcfb\";s:13:\"sidebar-width\";i:30;s:25:\"sidebar-vertical_distance\";i:50;s:20:\"sidebar-visual_style\";s:15:\"with_widgets_bg\";s:24:\"sidebar-divider-vertical\";s:1:\"1\";s:26:\"sidebar-divider-horizontal\";s:1:\"0\";s:16:\"sidebar-bg_color\";s:7:\"#ffed62\";s:18:\"sidebar-bg_opacity\";i:100;s:16:\"sidebar-bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:18:\"sidebar-decoration\";s:4:\"none\";s:32:\"sidebar-decoration_outline_color\";s:7:\"#000000\";s:34:\"sidebar-decoration_outline_opacity\";i:6;s:21:\"sidebar-headers_color\";s:7:\"#000000\";s:26:\"sidebar-primary_text_color\";s:7:\"#000000\";s:12:\"footer-style\";s:16:\"solid_background\";s:15:\"footer-bg_color\";s:7:\"#0c0808\";s:17:\"footer-bg_opacity\";i:100;s:17:\"footer-decoration\";s:4:\"none\";s:31:\"footer-decoration_outline_color\";s:7:\"#81d742\";s:33:\"footer-decoration_outline_opacity\";i:96;s:15:\"footer-bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:3:\"top\";}s:21:\"footer-slide-out-mode\";s:1:\"0\";s:20:\"footer-headers_color\";s:7:\"#fcfcfb\";s:25:\"footer-primary_text_color\";s:7:\"#bdbbba\";s:18:\"footer-padding-top\";i:50;s:21:\"footer-padding-bottom\";i:10;s:23:\"footer-paddings-columns\";i:22;s:13:\"footer-layout\";s:11:\"1/3+1/3+1/3\";s:21:\"footer-collapse_after\";i:970;s:18:\"bottom_bar-enabled\";s:1:\"1\";s:16:\"bottom_bar-style\";s:16:\"solid_background\";s:19:\"bottom_bar-bg_color\";s:7:\"#1c1c1c\";s:21:\"bottom_bar-bg_opacity\";i:100;s:19:\"bottom_bar-bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:3:\"top\";}s:16:\"bottom_bar-color\";s:7:\"#7d7d7d\";s:15:\"bottom_bar-text\";s:107:\"<span style=\"font-size:12px\">*No part of this site may be reproduced without our written permission.</span>\";s:20:\"general-filter_style\";s:7:\"minimal\";s:42:\"general-filter_style-minimal-border_radius\";i:100;s:39:\"general-filter_style-material-line_size\";i:2;s:26:\"general-filter-font-family\";s:13:\"Open Sans:600\";s:24:\"general-filter-font-size\";i:13;s:20:\"general-filter_ucase\";b:0;s:26:\"general-filter-padding-top\";i:6;s:28:\"general-filter-padding-right\";i:15;s:29:\"general-filter-padding-bottom\";i:6;s:27:\"general-filter-padding-left\";i:16;s:25:\"general-filter-margin-top\";i:0;s:27:\"general-filter-margin-right\";i:5;s:28:\"general-filter-margin-bottom\";i:0;s:26:\"general-filter-margin-left\";i:0;s:25:\"general-navigation_margin\";i:40;s:21:\"blog-fancy_date-style\";s:6:\"circle\";s:20:\"post-show_fancy_date\";b:0;s:26:\"post-show_fancy_categories\";b:0;s:19:\"blog-thumbnail_size\";s:6:\"resize\";s:26:\"blog-thumbnail_proportions\";a:2:{s:5:\"width\";i:2;s:6:\"height\";i:1;}s:27:\"general-show_author_in_blog\";s:1:\"0\";s:25:\"general-next_prev_in_blog\";s:1:\"1\";s:32:\"general-show_back_button_in_post\";s:1:\"0\";s:20:\"general-blog_meta_on\";s:1:\"0\";s:22:\"general-blog_meta_date\";s:1:\"1\";s:24:\"general-blog_meta_author\";b:0;s:28:\"general-blog_meta_categories\";b:0;s:26:\"general-blog_meta_comments\";b:0;s:22:\"general-blog_meta_tags\";b:0;s:22:\"general-show_rel_posts\";s:1:\"1\";s:28:\"general-rel_posts_head_title\";s:12:\"Related news\";s:21:\"general-rel_posts_max\";i:4;s:19:\"general-title_align\";s:4:\"left\";s:20:\"general-title_height\";i:120;s:22:\"page_title-padding-top\";i:2;s:25:\"page_title-padding-bottom\";i:0;s:19:\"general-show_titles\";s:1:\"1\";s:18:\"general-title_size\";s:2:\"h3\";s:19:\"general-title_color\";s:7:\"#3a3a3a\";s:24:\"general-show_breadcrumbs\";s:1:\"1\";s:25:\"general-breadcrumbs_color\";s:7:\"#807e7d\";s:28:\"general-breadcrumbs_bg_color\";s:8:\"disabled\";s:21:\"general-title_bg_mode\";s:10:\"background\";s:17:\"header-background\";s:6:\"normal\";s:27:\"header-transparent_bg_color\";s:7:\"#ffffff\";s:29:\"header-transparent_bg_opacity\";i:100;s:52:\"page_title-background-style-transparent-color_scheme\";s:5:\"light\";s:22:\"general-title_bg_color\";s:7:\"#e8e6e3\";s:24:\"general-title_bg_opacity\";i:100;s:24:\"general-title_decoration\";s:4:\"none\";s:38:\"general-title_decoration_outline_color\";s:7:\"#1e73be\";s:40:\"general-title_decoration_outline_opacity\";i:0;s:25:\"general-title_bg_gradient\";a:2:{i:0;s:7:\"#4a66d6\";i:1;s:7:\"#12b4ea\";}s:22:\"general-title_bg_image\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:27:\"general-title_bg_fullscreen\";b:0;s:22:\"general-title_bg_fixed\";b:0;s:25:\"general-title_bg_parallax\";s:0:\"\";s:21:\"content-headers_color\";s:7:\"#232323\";s:26:\"content-primary_text_color\";s:7:\"#3f3f3f\";s:28:\"content-secondary_text_color\";s:7:\"#3f3f3f\";s:17:\"fonts-font_family\";s:9:\"Open Sans\";s:14:\"fonts-big_size\";i:15;s:26:\"fonts-big_size_line_height\";i:26;s:17:\"fonts-normal_size\";i:15;s:29:\"fonts-normal_size_line_height\";i:25;s:16:\"fonts-small_size\";i:14;s:28:\"fonts-small_size_line_height\";i:24;s:20:\"fonts-h1_font_family\";s:13:\"Open Sans:800\";s:18:\"fonts-h1_font_size\";i:38;s:20:\"fonts-h1_line_height\";i:45;s:18:\"fonts-h1_uppercase\";b:0;s:20:\"fonts-h2_font_family\";s:13:\"Open Sans:700\";s:18:\"fonts-h2_font_size\";i:30;s:20:\"fonts-h2_line_height\";i:40;s:18:\"fonts-h2_uppercase\";b:0;s:20:\"fonts-h3_font_family\";s:13:\"Open Sans:600\";s:18:\"fonts-h3_font_size\";i:24;s:20:\"fonts-h3_line_height\";i:32;s:18:\"fonts-h3_uppercase\";b:0;s:20:\"fonts-h4_font_family\";s:9:\"Open Sans\";s:18:\"fonts-h4_font_size\";i:20;s:20:\"fonts-h4_line_height\";i:28;s:18:\"fonts-h4_uppercase\";b:0;s:20:\"fonts-h5_font_family\";s:9:\"Open Sans\";s:18:\"fonts-h5_font_size\";i:16;s:20:\"fonts-h5_line_height\";i:24;s:18:\"fonts-h5_uppercase\";b:0;s:20:\"fonts-h6_font_family\";s:9:\"Open Sans\";s:18:\"fonts-h6_font_size\";i:14;s:20:\"fonts-h6_line_height\";i:22;s:18:\"fonts-h6_uppercase\";b:0;s:13:\"buttons-style\";s:8:\"material\";s:18:\"buttons-color_mode\";s:6:\"accent\";s:13:\"buttons-color\";s:7:\"#4f4f4f\";s:22:\"buttons-color_gradient\";a:2:{i:0;s:7:\"#dd3333\";i:1;s:7:\"#3a892a\";}s:24:\"buttons-hover_color_mode\";s:5:\"color\";s:19:\"buttons-hover_color\";s:7:\"#6cb762\";s:28:\"buttons-hover_color_gradient\";a:2:{i:0;s:7:\"#cc4789\";i:1;s:7:\"#e57544\";}s:23:\"buttons-text_color_mode\";s:5:\"color\";s:18:\"buttons-text_color\";s:7:\"#ffffff\";s:29:\"buttons-text_hover_color_mode\";s:5:\"color\";s:24:\"buttons-text_hover_color\";s:7:\"#ffffff\";s:21:\"buttons-s_font_family\";s:13:\"Open Sans:700\";s:19:\"buttons-s_font_size\";i:14;s:19:\"buttons-s_uppercase\";b:0;s:21:\"buttons-s_line_height\";i:30;s:23:\"buttons-s_border_radius\";i:3;s:21:\"buttons-m_font_family\";s:13:\"Open Sans:700\";s:19:\"buttons-m_font_size\";i:16;s:19:\"buttons-m_uppercase\";b:0;s:21:\"buttons-m_line_height\";i:44;s:23:\"buttons-m_border_radius\";i:3;s:21:\"buttons-l_font_family\";s:13:\"Open Sans:700\";s:19:\"buttons-l_font_size\";i:22;s:19:\"buttons-l_uppercase\";s:1:\"1\";s:21:\"buttons-l_line_height\";i:60;s:23:\"buttons-l_border_radius\";i:3;s:17:\"image_hover-style\";s:4:\"none\";s:29:\"image_hover-onclick_animation\";s:1:\"1\";s:24:\"image_hover-default_icon\";s:4:\"none\";s:22:\"image_hover-color_mode\";s:5:\"color\";s:17:\"image_hover-color\";s:7:\"#000000\";s:26:\"image_hover-color_gradient\";a:2:{i:0;s:7:\"#000000\";i:1;s:7:\"#303030\";}s:19:\"image_hover-opacity\";i:30;s:31:\"image_hover-project_icons_style\";s:7:\"outline\";s:34:\"image_hover-album_miniatures_style\";s:7:\"style_2\";s:39:\"image_hover-project_rollover_color_mode\";s:5:\"color\";s:34:\"image_hover-project_rollover_color\";s:7:\"#000000\";s:43:\"image_hover-project_rollover_color_gradient\";a:2:{i:0;s:7:\"#6ae5e6\";i:1;s:7:\"#1190c9\";}s:36:\"image_hover-project_rollover_opacity\";i:50;s:25:\"social_buttons-visibility\";s:7:\"allways\";s:32:\"social_buttons-post-button_title\";s:15:\"Share this post\";s:19:\"social_buttons-post\";a:0:{}s:42:\"social_buttons-portfolio_post-button_title\";s:0:\"\";s:29:\"social_buttons-portfolio_post\";a:0:{}s:33:\"social_buttons-photo-button_title\";s:0:\"\";s:20:\"social_buttons-photo\";a:0:{}s:32:\"social_buttons-page-button_title\";s:0:\"\";s:19:\"social_buttons-page\";a:0:{}s:11:\"widgetareas\";a:10:{i:1;a:2:{s:12:\"sidebar_name\";s:15:\"Default Sidebar\";s:12:\"sidebar_desc\";s:27:\"Sidebar primary widget area\";}i:2;a:2:{s:12:\"sidebar_name\";s:14:\"Default Footer\";s:12:\"sidebar_desc\";s:26:\"Footer primary widget area\";}i:3;a:2:{s:12:\"sidebar_name\";s:13:\"eNews Sidebar\";s:12:\"sidebar_desc\";s:0:\"\";}i:4;a:2:{s:12:\"sidebar_name\";s:16:\"Visa Information\";s:12:\"sidebar_desc\";s:5:\"visas\";}i:5;a:2:{s:12:\"sidebar_name\";s:11:\"VISA Info 1\";s:12:\"sidebar_desc\";s:0:\"\";}i:6;a:2:{s:12:\"sidebar_name\";s:11:\"VISA Info 2\";s:12:\"sidebar_desc\";s:0:\"\";}i:7;a:2:{s:12:\"sidebar_name\";s:11:\"VISA Info 3\";s:12:\"sidebar_desc\";s:0:\"\";}i:8;a:2:{s:12:\"sidebar_name\";s:11:\"VISA Info 4\";s:12:\"sidebar_desc\";s:0:\"\";}i:9;a:2:{s:12:\"sidebar_name\";s:20:\"User Profile Sidebar\";s:12:\"sidebar_desc\";s:0:\"\";}i:10;a:2:{s:12:\"sidebar_name\";s:20:\"Members area Sidebar\";s:12:\"sidebar_desc\";s:0:\"\";}}s:31:\"general-page_content_top_margin\";i:70;s:34:\"general-page_content_bottom_margin\";i:70;s:18:\"general-responsive\";s:1:\"1\";s:31:\"general-responsiveness-treshold\";i:970;s:29:\"general-side_content_paddings\";i:60;s:31:\"general-switch_content_paddings\";i:768;s:36:\"general-mobile_side_content_paddings\";i:40;s:27:\"general-images_lazy_loading\";s:1:\"1\";s:21:\"general-smooth_scroll\";s:3:\"off\";s:33:\"general-contact_form_send_mail_to\";s:21:\"info@travelite.com.ph\";s:34:\"general-hide_plugins_notifications\";s:1:\"1\";s:18:\"general-custom_css\";s:7822:\"/*Homepage Destinations*/\r\n.shortcode-banner:hover {\r\n-webkit-transform:scale(1.1);\r\ntransform:scale(1.1);\r\n}\r\n.um-profile-nav-posts a, .um-profile-nav-comments a, .um-profile-note {\r\n    display: none !important;\r\n}\r\nol {\r\nmargin-bottom: 25px !important;\r\npadding-left: 15px;\r\n}\r\n.sidebar-content .menu .current-menu-item > a {\r\ntext-decoration: line-through;\r\n}\r\n.content ol li, .content ul li {\r\npadding-bottom: 5px;\r\n}\r\n.paginator:not(.paginator-more-button) a {\r\n    color: #ffffff;\r\n    background-color: #69c354;\r\n}\r\n.main-nav .sub-nav > li.act:not(.dt-mega-parent):not(.wpml-ls-item) > a .menu-text {\r\n    color: #9ce891 !important;\r\n}\r\n.page-title.solid-bg {\r\n    background-color: #e8e8e8 !important;\r\n}\r\n.sidebar-right .sidebar {\r\n    z-index: 0;\r\n}\r\n.bg-under-widget .sidebar-content .widget {\r\n    border-radius: 15px;\r\n}\r\n.slider-post-inner h4 {\r\n    display: none;\r\n}\r\n.text-big:hover h2 {\r\nvisibility: hidden;\r\n}\r\n.wpb_wrapper {\r\noverflow:hidden;\r\n}\r\n.shortcode-banner {\r\n-webkit-transition: all 0.7s ease;\r\ntransition: all 0.7s ease;\r\n}\r\n.shortcode-banner-bg {\r\n    background: rgba(6,5,5,.2);\r\n}\r\n.shortcode-banner-bg:hover {\r\n    background: rgba(6,5,5,0);\r\n}\r\n.widget-title {\r\n    font-weight: 700;\r\n    font-size: 22px;\r\n}\r\n#bottom-bar {\r\n    padding: 0 0 25px;\r\n}\r\n.scroll-top {\r\n    background-color: rgba(136, 204, 109, 0.5);\r\n    bottom: 90px;\r\n    display: none !important;\r\n}\r\n\r\n/*Tour Packages Pages*/\r\n.iso-grid .bg-on .project-list-content>* {\r\n    padding-left: 40px;\r\n    padding-right: 40px;\r\n}\r\nh3 a {\r\n    font-size: 22px;\r\n    font-weight: 700;\r\n}\r\n.shadow-element-decoration .description-under-image .ts-viewport:not(.photoSlider-wrap) {\r\n    height: 380px !important;\r\n}\r\n\r\n/*Others*/\r\n.mini-nav li:last-child {\r\n    margin-right: 0 !important;\r\n}\r\n#phantom {\r\n    z-index: 1;\r\n}\r\n.branding a img, .branding img {\r\n    margin-top: -5px;\r\n}\r\n.wpb_content_element {\r\n    margin-bottom: 25px !important;\r\n}\r\n.main-nav .sub-nav > li:not(.wpml-ls-item) > a:hover {\r\nbackground-color: #65b65b;\r\n}\r\n.aio-icon-header h3.aio-icon-title {\r\n    font-size: 23px !important;\r\n    line-height: 25px !important;\r\n    font-weight: 800 !important;\r\n}\r\n.buttons-on-img {\r\n    background-color: #000;\r\n}\r\n.shadow-element-decoration .post.bg-on {\r\n    -webkit-box-shadow: 0 6px 18px rgba(0,0,0,0);\r\n    box-shadow: 0 6px 18px rgba(0,0,0,0);\r\n}\r\nh3.entry-title {\r\n    font-weight: 700;\r\n}\r\n.iso-grid .bg-on .project-list-content>* {\r\n    color: #000;\r\n    font-weight: 600;\r\n}\r\n\r\n/*Social icons*/\r\n.dt-mobile-header .menu-select, .dt-mobile-header .mini-nav > ul > li > a {\r\n    font: bold 14px / 20px \"Open Sans\", Helvetica, Arial, Verdana, sans-serif;\r\n}\r\n.soc-ico a .icon {\r\n    position: relative;\r\n    top: 0;\r\n    left: 0;\r\n    width: 28px;\r\n    height: 30px;\r\n}\r\n.masthead .soc-ico a {\r\n    border-radius: 25px;\r\n}\r\n.soc-ico a:after, .soc-ico a:before {\r\n    width: 30px;\r\n    height: 30px;\r\n    -webkit-border-radius: 25px;\r\n    border-radius: 25px;\r\n}\r\n.soc-ico a {\r\n    width: 30px;\r\n    height: 30px;\r\n    -webkit-border-radius: 0;\r\n    border-radius: 0;\r\n}\r\n.dt-mobile-header .soc-ico a .icon {\r\n    fill: #ffffff;\r\n    background-color: #78cc6d;\r\n}\r\n.soc-ico .facebook {\r\n    background-color: #3b5998;\r\n}\r\n.soc-ico .instagram {\r\nbackground: #f09433; \r\nbackground: -moz-linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%); \r\nbackground: -webkit-linear-gradient(45deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%); \r\nbackground: linear-gradient(45deg, #f09433 0%,#e6683c 25%,#dc2743 50%,#cc2366 75%,#bc1888 100%); \r\nfilter: progid:DXImageTransform.Microsoft.gradient( startColorstr=\'#f09433\', endColorstr=\'#bc1888\',GradientType=1 );\r\n}\r\n.soc-ico .twitter {\r\n    background-color: #2aaae0;\r\n}\r\n.soc-ico .you-tube {\r\n    background-color: #c8302a;\r\n}\r\n.soc-ico .linkedin {\r\n    background-color: #007ab9;\r\n}\r\n\r\n/*Table Footer*/\r\n.cwc-table-first-row {\r\n    width: 65px;\r\n    font-style: italic;\r\n    vertical-align: top;\r\n    text-align: left;\r\n    font-size: 13px;\r\n    font-weight: 300;\r\n}\r\n.cwc-table-sec-row {\r\n    width: 150px;\r\n    vertical-align: top;\r\n    text-align: left;\r\n    font-size: 13px;\r\n    font-weight: 300;\r\n}\r\n.footer .widget-title {\r\n    color: #78cc6d;\r\n    font-size: 20px;\r\n    font-weight: 700;\r\n}\r\n#bottom-bar {\r\n    font-size: 12px;\r\n    line-height: 22px;\r\n}\r\n\r\n/*Search Box*/\r\n.screen-reader-text {\r\ndisplay:none;\r\n}\r\ninput[type=\"text\"], input[placeholder=\"Search this site\"] {\r\ncolor: #000;\r\n}\r\n#searchsubmit {\r\n    font-size: 13px;\r\n    line-height: 25px;\r\n    margin: 0;\r\n    padding: 0 10px;\r\n    background: #78cc6d;\r\n    border: none;\r\n    border-radius: 0;\r\n}\r\n#s {\r\n    font-size: 12px;\r\n    display: inline-block;\r\n    margin: 0;\r\n    width: 180px;\r\n    padding: 5px 8px;\r\n    border: none;\r\n    border-radius: 0;\r\n    height: 25px;\r\n}\r\n.btn-material input[type=\"submit\"] {\r\n    -webkit-box-shadow: 0 1px 6px rgba(0,0,0,0);\r\n    box-shadow: 0 1px 6px rgba(0,0,0,0);\r\n}\r\n.entry-meta, .entry-tags, .portfolio-categories, .author-link {\r\n    display: none !important;\r\n}\r\n.project-zoom {\r\n    display: none !important;\r\n}\r\n\r\n/*Visual Form Builder Pro*/\r\n.visual-form-builder li {\r\n    padding: 2px 1% 2px!important;\r\n}\r\nform.visual-form-builder {\r\n    margin: 0;\r\n}\r\nlabel.vfb-desc {\r\n    font-weight: 400;\r\n}\r\n.visual-form-builder .vfb-legend h3 {\r\n    color: #000;\r\n    font-weight: 700;\r\n    font-size: 17px;\r\n    line-height: 1.8em;\r\n}\r\n.visual-form-builder fieldset {\r\n    border-radius: 0;\r\n    margin: 0;\r\n    border: 0px solid transparent;\r\n    background-color: transparent;\r\n}\r\ninput.vfb-text {\r\n    border: 0px solid transparent;\r\n    border-radius: 0;\r\n    padding: 6px 0;\r\n    background: none repeat scroll 0 0 transparent;\r\n    -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,0);\r\n    -moz-box-shadow: inset 0 1px 1px rgba(0,0,0,0);\r\n    box-shadow: inset 0 1px 1px rgba(0,0,0,0);\r\n}\r\nselect.vfb-select {\r\n    border: 1px solid #a0a0a0;\r\n    border-radius: 0;\r\n    background: none repeat scroll 0 0 #ffffff;\r\n    -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,0);\r\n    -moz-box-shadow: inset 0 1px 1px rgba(0,0,0,0);\r\n    box-shadow: inset 0 1px 1px rgba(0,0,0,0);\r\n}\r\ninput[type=\"text\"].vfb-text, .contact-form-minimal input[type=\"email\"], textarea.vfb-medium {\r\n    border: 1px solid #a0a0a0;\r\n    border-radius: 0;\r\n    padding: 6px 10px;\r\n    background: none repeat scroll 0 0 #ffffff;\r\n    -webkit-box-shadow: inset 0 1px 1px rgba(0,0,0,0);\r\n    -moz-box-shadow: inset 0 1px 1px rgba(0,0,0,0);\r\n    box-shadow: inset 0 1px 1px rgba(0,0,0,0);\r\n}\r\nlabel.vfb-desc {\r\n    display: inline-block;\r\n    width: 110px;\r\n}\r\nselect.vfb-select {\r\n    padding: 5px 0 5px 5px;\r\n}\r\nform.visual-form-builder {\r\n    padding: 0;\r\n    background-color: transparent;\r\n}\r\n.visual-form-builder .vfb-legend {\r\n    margin: 0 0 10px 0;\r\n    padding: 5px 0;\r\n    border-bottom: 1px solid #e8d332;\r\n    color: #000;\r\n}\r\ntextarea.vfb-textarea {\r\n    background-color: #ffffff !important;\r\n}\r\n.visual-form-builder ul, .entry-content .visual-form-builder ul, .comment-content .visual-form-builder ul, .mu_register .visual-form-builder ul, .visual-form-builder ol, .entry-content .visual-form-builder ol, .comment-content .visual-form-builder ol, .mu_register .visual-form-builder ol {\r\n    margin: 0 !important;\r\n}\r\ninput.vfb-medium, input[type=\"text\"].vfb-medium, input[type=\"tel\"].vfb-medium, input[type=\"email\"].vfb-medium, input[type=\"url\"].vfb-medium, select.vfb-medium {\r\n    width: 60%;\r\n}\r\ninput[type=\"submit\"], .nsu-submit {\r\n    background-color: #000000;\r\n}\r\nul li.vfb-item-secret label.vfb-desc {\r\n    width: 300px;\r\n}\r\n\r\n@media screen and (max-width: 990px) {\r\n#s {\r\n    border: 1px solid #ededed;\r\n    margin-top: 10px;\r\n}\r\n.dt-mobile-header .soc-ico a .icon {\r\n    background-color: transparent;\r\n}\r\n}\";s:21:\"general-tracking_code\";s:0:\"\";s:39:\"general-post_back_button_target_page_id\";i:0;s:30:\"general-next_prev_in_portfolio\";s:1:\"0\";s:35:\"general-show_back_button_in_project\";s:1:\"0\";s:42:\"general-project_back_button_target_page_id\";i:0;s:25:\"general-portfolio_meta_on\";s:1:\"1\";s:27:\"general-portfolio_meta_date\";b:0;s:29:\"general-portfolio_meta_author\";b:0;s:33:\"general-portfolio_meta_categories\";b:0;s:31:\"general-portfolio_meta_comments\";b:0;s:25:\"general-show_rel_projects\";s:1:\"1\";s:31:\"general-rel_projects_head_title\";s:13:\"Related Tours\";s:26:\"general-rel_projects_title\";s:1:\"1\";s:28:\"general-rel_projects_excerpt\";s:1:\"1\";s:30:\"general-rel_projects_info_date\";b:0;s:32:\"general-rel_projects_info_author\";b:0;s:34:\"general-rel_projects_info_comments\";b:0;s:36:\"general-rel_projects_info_categories\";b:0;s:25:\"general-rel_projects_link\";s:1:\"1\";s:25:\"general-rel_projects_zoom\";b:0;s:28:\"general-rel_projects_details\";s:1:\"1\";s:24:\"general-rel_projects_max\";i:2;s:37:\"general-rel_projects_fullwidth_height\";i:320;s:42:\"general-rel_projects_fullwidth_width_style\";s:5:\"fixed\";s:36:\"general-rel_projects_fullwidth_width\";i:200;s:27:\"general-rel_projects_height\";i:250;s:32:\"general-rel_projects_width_style\";s:5:\"fixed\";s:26:\"general-rel_projects_width\";i:350;s:26:\"general-next_prev_in_album\";s:1:\"1\";s:33:\"general-show_back_button_in_album\";s:1:\"1\";s:40:\"general-album_back_button_target_page_id\";i:0;s:21:\"general-album_meta_on\";s:1:\"1\";s:23:\"general-album_meta_date\";s:1:\"1\";s:25:\"general-album_meta_author\";b:0;s:29:\"general-album_meta_categories\";s:1:\"1\";s:27:\"general-album_meta_comments\";b:0;s:24:\"modules-portfolio-status\";s:7:\"enabled\";s:27:\"modules-testimonials-status\";s:8:\"disabled\";s:19:\"modules-team-status\";s:8:\"disabled\";s:20:\"modules-logos-status\";s:8:\"disabled\";s:23:\"modules-benefits-status\";s:8:\"disabled\";s:21:\"modules-albums-status\";s:8:\"disabled\";s:24:\"modules-slideshow-status\";s:7:\"enabled\";s:32:\"general-post_type_portfolio_slug\";s:5:\"tours\";s:30:\"general-post_type_gallery_slug\";s:10:\"dt_gallery\";s:27:\"general-post_type_team_slug\";s:7:\"dt_team\";}", "yes");
INSERT INTO `trvlite_options` VALUES("247", "cp_image_compatibility_check", "1", "yes");
INSERT INTO `trvlite_options` VALUES("248", "ultimate_google_fonts", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("249", "ultimate_selected_google_fonts", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("250", "convert_plug_redirect", "", "yes");
INSERT INTO `trvlite_options` VALUES("251", "bsf_force_check_extensions", "", "no");
INSERT INTO `trvlite_options` VALUES("252", "cp_is_new_user", "", "yes");
INSERT INTO `trvlite_options` VALUES("253", "cp_previous_version", "2.3.1", "yes");
INSERT INTO `trvlite_options` VALUES("254", "widget_convertplug_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("255", "smile_modal_styles_backup", "", "yes");
INSERT INTO `trvlite_options` VALUES("256", "smile_info_bar_styles_backup", "", "yes");
INSERT INTO `trvlite_options` VALUES("257", "smile_slide_in_styles_backup", "", "yes");
INSERT INTO `trvlite_options` VALUES("258", "cp_multifield_support", "yes", "yes");
INSERT INTO `trvlite_options` VALUES("269", "ultimate_js", "enable", "yes");
INSERT INTO `trvlite_options` VALUES("270", "ultimate_css", "enable", "yes");
INSERT INTO `trvlite_options` VALUES("262", "go_pricing_table_settings", "a:2:{s:5:\"admin\";a:2:{s:4:\"ajax\";i:1;s:10:\"capability\";s:14:\"manage_options\";}s:8:\"currency\";a:1:{i:0;a:5:{s:8:\"currency\";s:3:\"USD\";s:8:\"position\";s:4:\"left\";s:12:\"thousand-sep\";s:1:\",\";s:11:\"decimal-sep\";s:1:\".\";s:10:\"decimal-no\";i:2;}}}", "yes");
INSERT INTO `trvlite_options` VALUES("263", "go_pricing_version", "a:1:{s:6:\"plugin\";s:5:\"3.3.5\";}", "yes");
INSERT INTO `trvlite_options` VALUES("282", "revslider-update-check-short", "1537583347", "yes");
INSERT INTO `trvlite_options` VALUES("283", "revslider-templates-check", "1537435929", "yes");
INSERT INTO `trvlite_options` VALUES("267", "ultimate_animation", "disable", "yes");
INSERT INTO `trvlite_options` VALUES("268", "ultimate_vc_addons_redirect", "", "yes");
INSERT INTO `trvlite_options` VALUES("271", "the7pt_flush_rewrite_rules", "", "yes");
INSERT INTO `trvlite_options` VALUES("266", "ultimate_row", "enable", "yes");
INSERT INTO `trvlite_options` VALUES("272", "widget_presscore-portfolio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("273", "widget_presscore-photos", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("274", "widget_presscore-team", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("275", "widget_presscore-testimonials-list", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("276", "widget_presscore-testimonials-slider", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("277", "widget_presscore-logos", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("288", "revslider-library-check", "1537435953", "yes");
INSERT INTO `trvlite_options` VALUES("289", "rs-library", "a:2:{s:7:\"objects\";a:169:{i:198;a:11:{s:2:\"id\";s:3:\"198\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";}i:197;a:11:{s:2:\"id\";s:3:\"197\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:196;a:11:{s:2:\"id\";s:3:\"196\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:195;a:11:{s:2:\"id\";s:3:\"195\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:194;a:11:{s:2:\"id\";s:3:\"194\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:193;a:11:{s:2:\"id\";s:3:\"193\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:192;a:11:{s:2:\"id\";s:3:\"192\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:191;a:11:{s:2:\"id\";s:3:\"191\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:190;a:11:{s:2:\"id\";s:3:\"190\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:189;a:11:{s:2:\"id\";s:3:\"189\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:188;a:11:{s:2:\"id\";s:3:\"188\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:187;a:11:{s:2:\"id\";s:3:\"187\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:186;a:11:{s:2:\"id\";s:3:\"186\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:185;a:11:{s:2:\"id\";s:3:\"185\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:184;a:11:{s:2:\"id\";s:3:\"184\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:183;a:11:{s:2:\"id\";s:3:\"183\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:182;a:11:{s:2:\"id\";s:3:\"182\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:181;a:11:{s:2:\"id\";s:3:\"181\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:180;a:11:{s:2:\"id\";s:3:\"180\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:179;a:11:{s:2:\"id\";s:3:\"179\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:177;a:11:{s:2:\"id\";s:3:\"177\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:175;a:11:{s:2:\"id\";s:3:\"175\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:174;a:11:{s:2:\"id\";s:3:\"174\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:173;a:11:{s:2:\"id\";s:3:\"173\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:172;a:11:{s:2:\"id\";s:3:\"172\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:171;a:11:{s:2:\"id\";s:3:\"171\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:170;a:11:{s:2:\"id\";s:3:\"170\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:169;a:11:{s:2:\"id\";s:3:\"169\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:168;a:11:{s:2:\"id\";s:3:\"168\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:167;a:11:{s:2:\"id\";s:3:\"167\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:166;a:11:{s:2:\"id\";s:3:\"166\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:165;a:11:{s:2:\"id\";s:3:\"165\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:164;a:11:{s:2:\"id\";s:3:\"164\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole-punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:163;a:11:{s:2:\"id\";s:3:\"163\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:162;a:11:{s:2:\"id\";s:3:\"162\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:161;a:11:{s:2:\"id\";s:3:\"161\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:160;a:11:{s:2:\"id\";s:3:\"160\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:159;a:11:{s:2:\"id\";s:3:\"159\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:158;a:11:{s:2:\"id\";s:3:\"158\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:157;a:11:{s:2:\"id\";s:3:\"157\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:156;a:11:{s:2:\"id\";s:3:\"156\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:155;a:11:{s:2:\"id\";s:3:\"155\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:154;a:11:{s:2:\"id\";s:3:\"154\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:153;a:11:{s:2:\"id\";s:3:\"153\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:152;a:11:{s:2:\"id\";s:3:\"152\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:151;a:11:{s:2:\"id\";s:3:\"151\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:150;a:11:{s:2:\"id\";s:3:\"150\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:149;a:11:{s:2:\"id\";s:3:\"149\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:148;a:11:{s:2:\"id\";s:3:\"148\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:147;a:11:{s:2:\"id\";s:3:\"147\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:146;a:11:{s:2:\"id\";s:3:\"146\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:145;a:11:{s:2:\"id\";s:3:\"145\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:144;a:11:{s:2:\"id\";s:3:\"144\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:143;a:11:{s:2:\"id\";s:3:\"143\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:142;a:11:{s:2:\"id\";s:3:\"142\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:141;a:11:{s:2:\"id\";s:3:\"141\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:140;a:11:{s:2:\"id\";s:3:\"140\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:139;a:11:{s:2:\"id\";s:3:\"139\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:138;a:11:{s:2:\"id\";s:3:\"138\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:137;a:11:{s:2:\"id\";s:3:\"137\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:136;a:11:{s:2:\"id\";s:3:\"136\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:135;a:11:{s:2:\"id\";s:3:\"135\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:134;a:11:{s:2:\"id\";s:3:\"134\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:133;a:11:{s:2:\"id\";s:3:\"133\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:132;a:11:{s:2:\"id\";s:3:\"132\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:131;a:11:{s:2:\"id\";s:3:\"131\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:130;a:11:{s:2:\"id\";s:3:\"130\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:129;a:11:{s:2:\"id\";s:3:\"129\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:128;a:11:{s:2:\"id\";s:3:\"128\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:127;a:11:{s:2:\"id\";s:3:\"127\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:126;a:11:{s:2:\"id\";s:3:\"126\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:125;a:11:{s:2:\"id\";s:3:\"125\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:124;a:11:{s:2:\"id\";s:3:\"124\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:123;a:11:{s:2:\"id\";s:3:\"123\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:122;a:11:{s:2:\"id\";s:3:\"122\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:121;a:11:{s:2:\"id\";s:3:\"121\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:120;a:11:{s:2:\"id\";s:3:\"120\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:119;a:11:{s:2:\"id\";s:3:\"119\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:118;a:11:{s:2:\"id\";s:3:\"118\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:117;a:11:{s:2:\"id\";s:3:\"117\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:116;a:11:{s:2:\"id\";s:3:\"116\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:115;a:11:{s:2:\"id\";s:3:\"115\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:114;a:11:{s:2:\"id\";s:3:\"114\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:113;a:11:{s:2:\"id\";s:3:\"113\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:112;a:11:{s:2:\"id\";s:3:\"112\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:111;a:11:{s:2:\"id\";s:3:\"111\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:110;a:11:{s:2:\"id\";s:3:\"110\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:109;a:11:{s:2:\"id\";s:3:\"109\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:108;a:11:{s:2:\"id\";s:3:\"108\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:107;a:11:{s:2:\"id\";s:3:\"107\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:106;a:11:{s:2:\"id\";s:3:\"106\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:105;a:11:{s:2:\"id\";s:3:\"105\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:104;a:11:{s:2:\"id\";s:3:\"104\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:103;a:11:{s:2:\"id\";s:3:\"103\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:102;a:11:{s:2:\"id\";s:3:\"102\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:101;a:11:{s:2:\"id\";s:3:\"101\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:100;a:11:{s:2:\"id\";s:3:\"100\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:99;a:11:{s:2:\"id\";s:2:\"99\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:98;a:11:{s:2:\"id\";s:2:\"98\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:97;a:11:{s:2:\"id\";s:2:\"97\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:96;a:11:{s:2:\"id\";s:2:\"96\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:95;a:11:{s:2:\"id\";s:2:\"95\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:94;a:11:{s:2:\"id\";s:2:\"94\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:93;a:11:{s:2:\"id\";s:2:\"93\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:92;a:11:{s:2:\"id\";s:2:\"92\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:91;a:11:{s:2:\"id\";s:2:\"91\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:90;a:11:{s:2:\"id\";s:2:\"90\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:89;a:11:{s:2:\"id\";s:2:\"89\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:88;a:11:{s:2:\"id\";s:2:\"88\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:87;a:11:{s:2:\"id\";s:2:\"87\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:86;a:11:{s:2:\"id\";s:2:\"86\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:85;a:11:{s:2:\"id\";s:2:\"85\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:84;a:11:{s:2:\"id\";s:2:\"84\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:83;a:11:{s:2:\"id\";s:2:\"83\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:82;a:11:{s:2:\"id\";s:2:\"82\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:81;a:11:{s:2:\"id\";s:2:\"81\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:80;a:11:{s:2:\"id\";s:2:\"80\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:79;a:11:{s:2:\"id\";s:2:\"79\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:78;a:11:{s:2:\"id\";s:2:\"78\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:77;a:11:{s:2:\"id\";s:2:\"77\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:76;a:11:{s:2:\"id\";s:2:\"76\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:75;a:11:{s:2:\"id\";s:2:\"75\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:74;a:11:{s:2:\"id\";s:2:\"74\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:73;a:11:{s:2:\"id\";s:2:\"73\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:72;a:11:{s:2:\"id\";s:2:\"72\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:71;a:11:{s:2:\"id\";s:2:\"71\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:70;a:11:{s:2:\"id\";s:2:\"70\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:69;a:11:{s:2:\"id\";s:2:\"69\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:68;a:11:{s:2:\"id\";s:2:\"68\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:67;a:11:{s:2:\"id\";s:2:\"67\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:66;a:11:{s:2:\"id\";s:2:\"66\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:65;a:11:{s:2:\"id\";s:2:\"65\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:64;a:11:{s:2:\"id\";s:2:\"64\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:63;a:11:{s:2:\"id\";s:2:\"63\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:62;a:11:{s:2:\"id\";s:2:\"62\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:49;a:11:{s:2:\"id\";s:2:\"49\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:48;a:11:{s:2:\"id\";s:2:\"48\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:47;a:11:{s:2:\"id\";s:2:\"47\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:46;a:11:{s:2:\"id\";s:2:\"46\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:45;a:11:{s:2:\"id\";s:2:\"45\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:44;a:11:{s:2:\"id\";s:2:\"44\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:43;a:11:{s:2:\"id\";s:2:\"43\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:42;a:11:{s:2:\"id\";s:2:\"42\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:41;a:11:{s:2:\"id\";s:2:\"41\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:40;a:11:{s:2:\"id\";s:2:\"40\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:39;a:11:{s:2:\"id\";s:2:\"39\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:38;a:11:{s:2:\"id\";s:2:\"38\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:37;a:11:{s:2:\"id\";s:2:\"37\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:36;a:11:{s:2:\"id\";s:2:\"36\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:35;a:11:{s:2:\"id\";s:2:\"35\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:34;a:11:{s:2:\"id\";s:2:\"34\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:33;a:11:{s:2:\"id\";s:2:\"33\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:32;a:11:{s:2:\"id\";s:2:\"32\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:31;a:11:{s:2:\"id\";s:2:\"31\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:30;a:11:{s:2:\"id\";s:2:\"30\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:29;a:11:{s:2:\"id\";s:2:\"29\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:28;a:11:{s:2:\"id\";s:2:\"28\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:27;a:11:{s:2:\"id\";s:2:\"27\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:26;a:11:{s:2:\"id\";s:2:\"26\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:25;a:11:{s:2:\"id\";s:2:\"25\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:24;a:11:{s:2:\"id\";s:2:\"24\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:23;a:11:{s:2:\"id\";s:2:\"23\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:22;a:11:{s:2:\"id\";s:2:\"22\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:21;a:11:{s:2:\"id\";s:2:\"21\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:20;a:11:{s:2:\"id\";s:2:\"20\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:11;a:11:{s:2:\"id\";s:2:\"11\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:10;a:11:{s:2:\"id\";s:2:\"10\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:9;a:11:{s:2:\"id\";s:1:\"9\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:8;a:11:{s:2:\"id\";s:1:\"8\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}}s:4:\"tags\";a:13:{i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}}", "no");
INSERT INTO `trvlite_options` VALUES("290", "revslider_checktables", "1", "yes");
INSERT INTO `trvlite_options` VALUES("291", "rs_tables_created", "1", "yes");
INSERT INTO `trvlite_options` VALUES("292", "revslider_table_version", "1.0.6", "yes");
INSERT INTO `trvlite_options` VALUES("293", "revslider-global-settings", "a:18:{s:4:\"role\";s:6:\"editor\";s:17:\"includes_globally\";s:2:\"on\";s:18:\"pages_for_includes\";s:0:\"\";s:12:\"js_to_footer\";s:3:\"off\";s:8:\"js_defer\";s:3:\"off\";s:19:\"load_all_javascript\";s:3:\"off\";s:15:\"show_dev_export\";s:3:\"off\";s:19:\"change_font_loading\";s:0:\"\";s:5:\"width\";s:4:\"1240\";s:14:\"width_notebook\";s:4:\"1024\";s:12:\"width_tablet\";s:3:\"778\";s:12:\"width_mobile\";s:3:\"480\";s:14:\"stage_collapse\";s:3:\"off\";s:18:\"enable_newschannel\";s:2:\"on\";s:11:\"enable_logs\";s:3:\"off\";s:20:\"force_activation_box\";s:3:\"off\";s:18:\"pack_page_creation\";s:2:\"on\";s:20:\"single_page_creation\";s:3:\"off\";}", "yes");
INSERT INTO `trvlite_options` VALUES("294", "revslider_update_version", "5.2.5.5", "yes");
INSERT INTO `trvlite_options` VALUES("297", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("448", "vfb_ignore_notice", "1", "yes");
INSERT INTO `trvlite_options` VALUES("459", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `trvlite_options` VALUES("320", "duplicate_post_copytitle", "1", "yes");
INSERT INTO `trvlite_options` VALUES("321", "duplicate_post_copydate", "", "yes");
INSERT INTO `trvlite_options` VALUES("322", "duplicate_post_copystatus", "", "yes");
INSERT INTO `trvlite_options` VALUES("323", "duplicate_post_copyslug", "1", "yes");
INSERT INTO `trvlite_options` VALUES("324", "duplicate_post_copyexcerpt", "1", "yes");
INSERT INTO `trvlite_options` VALUES("325", "duplicate_post_copycontent", "1", "yes");
INSERT INTO `trvlite_options` VALUES("326", "duplicate_post_copythumbnail", "1", "yes");
INSERT INTO `trvlite_options` VALUES("327", "duplicate_post_copytemplate", "1", "yes");
INSERT INTO `trvlite_options` VALUES("328", "duplicate_post_copyformat", "1", "yes");
INSERT INTO `trvlite_options` VALUES("329", "duplicate_post_copyauthor", "", "yes");
INSERT INTO `trvlite_options` VALUES("330", "duplicate_post_copypassword", "", "yes");
INSERT INTO `trvlite_options` VALUES("331", "duplicate_post_copyattachments", "", "yes");
INSERT INTO `trvlite_options` VALUES("332", "duplicate_post_copychildren", "", "yes");
INSERT INTO `trvlite_options` VALUES("333", "duplicate_post_copycomments", "", "yes");
INSERT INTO `trvlite_options` VALUES("334", "duplicate_post_copymenuorder", "1", "yes");
INSERT INTO `trvlite_options` VALUES("335", "duplicate_post_taxonomies_blacklist", "", "yes");
INSERT INTO `trvlite_options` VALUES("336", "duplicate_post_blacklist", "", "yes");
INSERT INTO `trvlite_options` VALUES("337", "duplicate_post_types_enabled", "a:4:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:12:\"dt_portfolio\";i:3;s:12:\"dt_slideshow\";}", "yes");
INSERT INTO `trvlite_options` VALUES("338", "duplicate_post_show_row", "1", "yes");
INSERT INTO `trvlite_options` VALUES("339", "duplicate_post_show_adminbar", "1", "yes");
INSERT INTO `trvlite_options` VALUES("340", "duplicate_post_show_submitbox", "1", "yes");
INSERT INTO `trvlite_options` VALUES("341", "duplicate_post_show_bulkactions", "1", "yes");
INSERT INTO `trvlite_options` VALUES("200745", "duplicate_post_version", "3.2.2", "yes");
INSERT INTO `trvlite_options` VALUES("200746", "duplicate_post_show_notice", "0", "no");
INSERT INTO `trvlite_options` VALUES("344", "WP_HPUW", "a:3:{s:3:\"ver\";s:3:\"1.0\";s:13:\"notifications\";i:1;s:7:\"updates\";a:0:{}}", "yes");
INSERT INTO `trvlite_options` VALUES("354", "widget_vfb_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("2144", "revslider-addons", "O:8:\"stdClass\":26:{s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:65:\"//updates.themepunch.tools/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"5.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"1.1.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch.tools/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:55:\"//updates.themepunch.tools/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:59:\"//updates.themepunch.tools/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:54:\"//updates.themepunch.tools/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:56:\"//updates.themepunch.tools/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:62:\"//updates.themepunch.tools/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:58:\"//updates.themepunch.tools/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:23:\"Display images in 360°\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:59:\"//updates.themepunch.tools/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:58:\"//updates.themepunch.tools/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:62:\"//updates.themepunch.tools/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}}", "yes");
INSERT INTO `trvlite_options` VALUES("388", "bsf_local_transient", "1537561179", "yes");
INSERT INTO `trvlite_options` VALUES("391", "bsf_installer_menu", "a:1:{s:11:\"ConvertPlug\";a:4:{s:11:\"parent_slug\";s:11:\"convertplug\";s:10:\"page_title\";s:6:\"Addons\";s:10:\"menu_title\";s:6:\"Addons\";s:10:\"product_id\";s:8:\"14058953\";}}", "no");
INSERT INTO `trvlite_options` VALUES("392", "smile_lists", "a:1:{i:0;a:5:{s:4:\"date\";s:10:\"20-03-2017\";s:9:\"list-name\";s:5:\"First\";s:13:\"list-provider\";s:12:\"Convert Plug\";s:4:\"list\";s:0:\"\";s:13:\"provider_list\";s:0:\"\";}}", "yes");
INSERT INTO `trvlite_options` VALUES("393", "brainstrom_products", "a:1:{s:7:\"plugins\";a:2:{i:14058953;a:12:{s:8:\"template\";s:27:\"convertplug/convertplug.php\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:8:\"14058953\";s:12:\"product_name\";s:11:\"ConvertPlug\";s:7:\"version\";s:5:\"2.3.1\";s:6:\"remote\";s:5:\"3.3.5\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:4:\"true\";s:15:\"is_product_free\";s:5:\"false\";s:10:\"short_name\";s:0:\"\";s:13:\"changelog_url\";s:43:\"https://www.convertplug.com/plus/changelog/\";s:12:\"purchase_url\";s:75:\"https://codecanyon.net/cart/add_items?item_ids=14058953&ref=BrainstormForce\";}i:6892199;a:12:{s:8:\"template\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:4:\"type\";s:6:\"plugin\";s:2:\"id\";s:7:\"6892199\";s:12:\"product_name\";s:35:\"Ultimate Addons for Visual Composer\";s:7:\"version\";s:6:\"3.16.7\";s:6:\"remote\";s:7:\"3.16.25\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:4:\"true\";s:15:\"is_product_free\";s:5:\"false\";s:10:\"short_name\";s:0:\"\";s:13:\"changelog_url\";s:46:\"http://changelog.brainstormforce.com/ultimate/\";s:12:\"purchase_url\";s:74:\"https://codecanyon.net/cart/add_items?item_ids=6892199&ref=BrainstormForce\";}}}", "yes");
INSERT INTO `trvlite_options` VALUES("394", "bsf_local_transient_bundled", "1537548689", "yes");
INSERT INTO `trvlite_options` VALUES("397", "brainstrom_bundled_products", "a:1:{i:14058953;a:41:{i:0;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:15:\"connects-mymail\";s:4:\"init\";s:35:\"connects-mymail/connects-mymail.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:19:\"connects-mymail.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - MailSter Mailer\";s:10:\"short_name\";s:8:\"Mailster\";s:7:\"version\";s:5:\"2.2.0\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:15:\"connects-mymail\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2016/03/MyMail.png\";s:11:\"description\";s:42:\"Integration with Mailster Email Solutions.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:1;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-madmimi\";s:4:\"init\";s:37:\"connects-madmimi/connects-madmimi.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-madmimi.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - Mad Mimi Mailer\";s:10:\"short_name\";s:8:\"Mad Mimi\";s:7:\"version\";s:5:\"1.1.0\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:16:\"connects-madmimi\";s:13:\"product_image\";s:68:\"//support.brainstormforce.com/wp-content/uploads/2016/03/MadMini.png\";s:11:\"description\";s:51:\"Integration with Mad Mimi Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:2;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:23:\"connects-activecampaign\";s:4:\"init\";s:51:\"connects-activecampaign/connects-activecampaign.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:27:\"connects-activecampaign.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:32:\"Connects - ActiveCampaign Mailer\";s:10:\"short_name\";s:14:\"ActiveCampaign\";s:7:\"version\";s:5:\"3.0.3\";s:6:\"tested\";s:5:\"4.9.5\";s:4:\"slug\";s:23:\"connects-activecampaign\";s:13:\"product_image\";s:76:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Active-Campaign.png\";s:11:\"description\";s:81:\"Integrate ActiveCampaign with Connects for Email marketing, Marketing Automation.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"3.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:3;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:13:\"connects-emma\";s:4:\"init\";s:33:\"connects-myemma/connects-emma.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:19:\"connects-myemma.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Connects - My Emma Mailer\";s:10:\"short_name\";s:7:\"My Emma\";s:7:\"version\";s:5:\"1.0.2\";s:6:\"tested\";s:5:\"4.6.1\";s:4:\"slug\";s:15:\"connects-myemma\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2016/03/MyEmma.png\";s:11:\"description\";s:48:\"Integrate with My Emma Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:4;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:18:\"connects-mailchimp\";s:4:\"init\";s:41:\"connects-mailchimp/connects-mailchimp.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:22:\"connects-mailchimp.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:27:\"Connects - MailChimp Mailer\";s:10:\"short_name\";s:9:\"MailChimp\";s:7:\"version\";s:5:\"2.2.1\";s:6:\"tested\";s:5:\"4.9.6\";s:4:\"slug\";s:18:\"connects-mailchimp\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Mailchimp.png\";s:11:\"description\";s:52:\"Integration with MailChimp Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:5;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-hubspot\";s:4:\"init\";s:37:\"connects-hubspot/connects-hubspot.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-hubspot.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Connects - HubSpot Mailer\";s:10:\"short_name\";s:7:\"HubSpot\";s:7:\"version\";s:5:\"1.1.2\";s:6:\"tested\";s:5:\"4.9.7\";s:4:\"slug\";s:16:\"connects-hubspot\";s:13:\"product_image\";s:68:\"//support.brainstormforce.com/wp-content/uploads/2016/03/hubspot.png\";s:11:\"description\";s:62:\"Integration with HubSpot Inbound Marketing and Sales Software.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:6;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:17:\"connects-icontact\";s:4:\"init\";s:39:\"connects-icontact/connects-icontact.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"connects-icontact.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - iContact Mailer\";s:10:\"short_name\";s:8:\"iContact\";s:7:\"version\";s:5:\"1.1.0\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:17:\"connects-icontact\";s:13:\"product_image\";s:69:\"//support.brainstormforce.com/wp-content/uploads/2016/03/iContact.png\";s:11:\"description\";s:51:\"Integration with iContact Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:7;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:15:\"connects-aweber\";s:4:\"init\";s:35:\"connects-aweber/connects-aweber.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:19:\"connects-aweber.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Connects - Aweber Mailer\";s:10:\"short_name\";s:7:\"AWeber \";s:7:\"version\";s:5:\"2.1.3\";s:6:\"tested\";s:5:\"4.9.5\";s:4:\"slug\";s:15:\"connects-aweber\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2016/03/AWEBER.png\";s:11:\"description\";s:58:\"Integration with AWeber Email Marketing and Autoresponder.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.1.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:8;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:24:\"connects-campaignmonitor\";s:4:\"init\";s:53:\"connects-campaignmonitor/connects-campaignmonitor.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:28:\"connects-campaignmonitor.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:34:\"Connects - Campaign Monitor Mailer\";s:10:\"short_name\";s:16:\"Campaign Monitor\";s:7:\"version\";s:5:\"1.1.1\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:24:\"connects-campaignmonitor\";s:13:\"product_image\";s:76:\"//support.brainstormforce.com/wp-content/uploads/2016/03/CampaignMonitor.png\";s:11:\"description\";s:50:\"Integration with Campaign Monitor Email Marketing.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:9;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:18:\"connects-sendreach\";s:4:\"init\";s:41:\"connects-sendreach/connects-sendreach.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:22:\"connects-sendreach.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:27:\"Connects - SendReach Mailer\";s:10:\"short_name\";s:9:\"SendReach\";s:7:\"version\";s:5:\"1.1.0\";s:6:\"tested\";s:5:\"4.6.1\";s:4:\"slug\";s:18:\"connects-sendreach\";s:13:\"product_image\";s:73:\"//support.brainstormforce.com/wp-content/uploads/2016/03/SendReach150.png\";s:11:\"description\";s:43:\"Integration with SendReach Email Marketing.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:10;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:19:\"connects-sendinblue\";s:4:\"init\";s:43:\"connects-sendinblue/connects-sendinblue.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:23:\"connects-sendinblue.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:28:\"Connects - SendinBlue Mailer\";s:10:\"short_name\";s:10:\"SendinBlue\";s:7:\"version\";s:5:\"2.1.3\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:19:\"connects-sendinblue\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2016/03/sendinblue.png\";s:11:\"description\";s:66:\"Integrate with SendinBlue Online Email Marketing & SMS Marketing .\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.1.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:11;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:19:\"connects-mailerlite\";s:4:\"init\";s:43:\"connects-mailerlite/connects-mailerlite.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:23:\"connects-mailerlite.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:28:\"Connects - MailerLite Mailer\";s:10:\"short_name\";s:10:\"MailerLite\";s:7:\"version\";s:5:\"2.2.2\";s:6:\"tested\";s:3:\"4.8\";s:4:\"slug\";s:19:\"connects-mailerlite\";s:13:\"product_image\";s:73:\"//support.brainstormforce.com/wp-content/uploads/2016/03/MailerLite-1.png\";s:11:\"description\";s:64:\"Integrate with MailerLite Email Marketing software and Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:12;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:20:\"connects-getresponse\";s:4:\"init\";s:45:\"connects-getresponse/connects-getresponse.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:24:\"connects-getresponse.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:29:\"Connects - GetResponse Mailer\";s:10:\"short_name\";s:11:\"GetResponse\";s:7:\"version\";s:5:\"2.2.0\";s:6:\"tested\";s:5:\"4.9.2\";s:4:\"slug\";s:20:\"connects-getresponse\";s:13:\"product_image\";s:78:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Get-Response-Logo.png\";s:11:\"description\";s:72:\"Integration with GetResponse Email Marketing software and Autoresponder.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:13;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:24:\"connects-constantcontact\";s:4:\"init\";s:53:\"connects-constantcontact/connects-constantcontact.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:28:\"connects-constantcontact.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:34:\"Connects - Constant Contact Mailer\";s:10:\"short_name\";s:16:\"Constant Contact\";s:7:\"version\";s:5:\"2.2.0\";s:6:\"tested\";s:5:\"4.7.2\";s:4:\"slug\";s:24:\"connects-constantcontact\";s:13:\"product_image\";s:77:\"//support.brainstormforce.com/wp-content/uploads/2016/03/constant-contact.png\";s:11:\"description\";s:59:\"Integration with Constant Contact Email Marketing Software.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:14;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:18:\"connects-totalsend\";s:4:\"init\";s:41:\"connects-totalsend/connects-totalsend.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:22:\"connects-totalsend.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:27:\"Connects - TotalSend Mailer\";s:10:\"short_name\";s:9:\"TotalSend\";s:7:\"version\";s:5:\"2.0.3\";s:6:\"tested\";s:5:\"4.6.1\";s:4:\"slug\";s:18:\"connects-totalsend\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2016/03/TotalSend.png\";s:11:\"description\";s:70:\"Integrate TotalSend with Connects to collect lead and email marketing.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:15;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:19:\"connects-convertkit\";s:4:\"init\";s:43:\"connects-convertkit/connects-convertkit.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:23:\"connects-convertkit.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:28:\"Connects - ConvertKit Mailer\";s:10:\"short_name\";s:10:\"ConvertKit\";s:7:\"version\";s:5:\"2.2.1\";s:6:\"tested\";s:5:\"4.9.7\";s:4:\"slug\";s:19:\"connects-convertkit\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2016/03/ConvertKit.png\";s:11:\"description\";s:55:\"Integration with ConvertKit Email Marketing Automation.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:16;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:19:\"connects-simplycast\";s:4:\"init\";s:43:\"connects-simplycast/connects-simplycast.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:23:\"connects-simplycast.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:28:\"Connects - SimplyCast Mailer\";s:10:\"short_name\";s:10:\"SimplyCast\";s:7:\"version\";s:5:\"2.0.2\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:19:\"connects-simplycast\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2016/03/SimplYcast.png\";s:11:\"description\";s:55:\"Integration with SimplyCast Email Marketing Automation.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.0.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:17;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-campayn\";s:4:\"init\";s:37:\"connects-campayn/connects-campayn.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-campayn.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Connects - Campayn Mailer\";s:10:\"short_name\";s:7:\"Campayn\";s:7:\"version\";s:5:\"2.1.0\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:16:\"connects-campayn\";s:13:\"product_image\";s:68:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Campayn.png\";s:11:\"description\";s:57:\"Integration with Campayn Simple Email Marketing solution.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.1.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:18;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:17:\"connects-mailpoet\";s:4:\"init\";s:39:\"connects-mailpoet/connects-mailpoet.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"connects-mailpoet.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - MailPoet Mailer\";s:10:\"short_name\";s:8:\"MailPoet\";s:7:\"version\";s:5:\"2.2.1\";s:6:\"tested\";s:5:\"4.9.4\";s:4:\"slug\";s:17:\"connects-mailpoet\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2016/03/MailPoet2.png\";s:11:\"description\";s:38:\"Integration with MailPoet Newsletters.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:19;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:21:\"connects-infusionsoft\";s:4:\"init\";s:47:\"connects-infusionsoft/connects-infusionsoft.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:25:\"connects-infusionsoft.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:30:\"Connects - Infusionsoft Mailer\";s:10:\"short_name\";s:12:\"Infusionsoft\";s:7:\"version\";s:5:\"2.2.2\";s:6:\"tested\";s:5:\"4.9.5\";s:4:\"slug\";s:21:\"connects-infusionsoft\";s:13:\"product_image\";s:80:\"//support.brainstormforce.com/wp-content/uploads/2016/03/InfusionSoft150x150.png\";s:11:\"description\";s:46:\"Integration with Infusionsoft Email Marketing.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.2.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:20;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-mailjet\";s:4:\"init\";s:37:\"connects-mailjet/connects-mailjet.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-mailjet.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Connects - Mailjet Mailer\";s:10:\"short_name\";s:7:\"Mailjet\";s:7:\"version\";s:5:\"2.1.2\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:15:\"connect-mailjet\";s:13:\"product_image\";s:73:\"//support.brainstormforce.com/wp-content/uploads/2016/03/mailjet-logo.png\";s:11:\"description\";s:53:\"Integrate with Mailjet Bulk Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.1.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:21;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:23:\"connects-benchmarkemail\";s:4:\"init\";s:51:\"connects-benchmarkemail/connects-benchmarkemail.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:27:\"connects-benchmarkemail.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:33:\"Connects - Benchmark Email Mailer\";s:10:\"short_name\";s:15:\"Benchmark Email\";s:7:\"version\";s:5:\"2.0.3\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:23:\"connects-benchmarkemail\";s:13:\"product_image\";s:62:\"//support.brainstormforce.com/wp-content/uploads/2017/07/1.png\";s:11:\"description\";s:52:\"Integration with Benchmark Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:22;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:20:\"connects-cleverreach\";s:4:\"init\";s:45:\"connects-cleverreach/connects-cleverreach.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:24:\"connects-cleverreach.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:29:\"Connects - CleverReach Mailer\";s:10:\"short_name\";s:11:\"CleverReach\";s:7:\"version\";s:5:\"2.3.1\";s:6:\"tested\";s:5:\"4.8.3\";s:4:\"slug\";s:20:\"connects-cleverreach\";s:13:\"product_image\";s:72:\"//support.brainstormforce.com/wp-content/uploads/2016/03/cleverreach.png\";s:11:\"description\";s:53:\"Integration with CleverReach Email Marketing sofware.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.3.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:23;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:14:\"convertplug-vc\";s:4:\"init\";s:33:\"convertplug-vc/convertplug-vc.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:18:\"convertplug-vc.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:44:\"ConvertPlus Addons for WPBakery Page Builder\";s:10:\"short_name\";s:21:\"WPBakery Page Builder\";s:7:\"version\";s:5:\"2.0.2\";s:6:\"tested\";s:5:\"4.9.5\";s:4:\"slug\";s:14:\"convertplug-vc\";s:13:\"product_image\";s:91:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Convert-plug-Addon-for-VC-Logo.png\";s:11:\"description\";s:51:\"Easy to use form builder for WPBakery Page Builder.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.0.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:24;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:23:\"connects-contact-form-7\";s:4:\"init\";s:51:\"connects-contact-form-7/connects-contact-form-7.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:27:\"connects-contact-form-7.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:25:\"Connects - Contact Form 7\";s:10:\"short_name\";s:14:\"Contact Form 7\";s:7:\"version\";s:5:\"1.1.1\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:23:\"connects-contact-form-7\";s:13:\"product_image\";s:75:\"//support.brainstormforce.com/wp-content/uploads/2016/03/contact-form-7.png\";s:11:\"description\";s:34:\"Collect leads from Contact Form 7.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:25;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:20:\"connects-woocommerce\";s:4:\"init\";s:50:\"connects-woocommerce/connects-woocommerce-form.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:24:\"connects-woocommerce.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:20:\"Connects WooCommerce\";s:10:\"short_name\";s:20:\"Connects WooCommerce\";s:7:\"version\";s:5:\"1.1.2\";s:6:\"tested\";s:5:\"4.9.7\";s:4:\"slug\";s:20:\"connects-woocommerce\";s:13:\"product_image\";s:76:\"//support.brainstormforce.com/wp-content/uploads/2017/07/woocom-checkout.png\";s:11:\"description\";s:46:\"Collect leads from WooCommerce checkout forms.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.1.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:58:\"https://changelog.brainstormforce.com/connects-woocommerce\";}i:26;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:24:\"connects-wp-comment-form\";s:4:\"init\";s:53:\"connects-wp-comment-form/connects-wp-comment-form.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:28:\"connects-wp-comment-form.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - WP Comment Form\";s:10:\"short_name\";s:15:\"WP Comment Form\";s:7:\"version\";s:5:\"1.0.3\";s:6:\"tested\";s:5:\"4.7.1\";s:4:\"slug\";s:24:\"connects-wp-comment-form\";s:13:\"product_image\";s:76:\"//support.brainstormforce.com/wp-content/uploads/2016/03/WP-Comment-Form.png\";s:11:\"description\";s:42:\"Collect leads from WordPress Comment Form.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:27;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:29:\"connects-wp-registration-form\";s:4:\"init\";s:63:\"connects-wp-registration-form/connects-wp-registration-form.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:33:\"connects-wp-registration-form.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:31:\"Connects - WP Registration Form\";s:10:\"short_name\";s:20:\"WP Registration Form\";s:7:\"version\";s:5:\"1.0.3\";s:6:\"tested\";s:5:\"4.6.1\";s:4:\"slug\";s:29:\"connects-wp-registration-form\";s:13:\"product_image\";s:79:\"//support.brainstormforce.com/wp-content/uploads/2016/03/WP-gistration-Form.png\";s:11:\"description\";s:47:\"Collect leads from WordPress Registration Form.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:28;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:18:\"connects-ontraport\";s:4:\"init\";s:41:\"connects-ontraport/connects-ontraport.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:22:\"connects-ontraport.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:27:\"Connects - OntraPort Mailer\";s:10:\"short_name\";s:9:\"ONTRAPORT\";s:7:\"version\";s:5:\"1.0.1\";s:6:\"tested\";s:5:\"4.6.1\";s:4:\"slug\";s:18:\"connects-ontraport\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2016/03/ONTRAPORT.png\";s:11:\"description\";s:47:\"Integrate ONTRAPORT Email Marketing Automation.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:29;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:26:\"connects-mautic-form-addon\";s:4:\"init\";s:57:\"connects-mautic-form-addon/connects-mautic-form-addon.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:30:\"connects-mautic-form-addon.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects Mautic Form Addon\";s:10:\"short_name\";s:6:\"Mautic\";s:7:\"version\";s:5:\"1.0.3\";s:6:\"tested\";s:3:\"4.8\";s:4:\"slug\";s:26:\"connects-mautic-form-addon\";s:13:\"product_image\";s:65:\"//support.brainstormforce.com/wp-content/uploads/2017/02/logo.png\";s:11:\"description\";s:53:\"Integration with Mautic Marketing Automation Platform\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:0:\"\";}i:30;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:13:\"connects-drip\";s:4:\"init\";s:31:\"connects-drip/connects-drip.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:17:\"connects-drip.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:22:\"Connects - Drip Mailer\";s:10:\"short_name\";s:4:\"Drip\";s:7:\"version\";s:5:\"1.0.1\";s:6:\"tested\";s:5:\"4.7.3\";s:4:\"slug\";s:13:\"connects-drip\";s:13:\"product_image\";s:65:\"//support.brainstormforce.com/wp-content/uploads/2017/03/logo.png\";s:11:\"description\";s:52:\"Integration with Drip Marketing Automation Platform.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:0:\"\";}i:31;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:14:\"connects-sendy\";s:4:\"init\";s:33:\"connects-sendy/connects-sendy.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:18:\"connects-sendy.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:23:\"Connects - Sendy Mailer\";s:10:\"short_name\";s:5:\"Sendy\";s:7:\"version\";s:5:\"2.1.3\";s:6:\"tested\";s:5:\"4.9.6\";s:4:\"slug\";s:14:\"connects-sendy\";s:13:\"product_image\";s:66:\"//support.brainstormforce.com/wp-content/uploads/2016/03/Sendy.png\";s:11:\"description\";s:46:\"Integration with Sendy Newsletter Application.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"2.1.3\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:32;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-mailget\";s:4:\"init\";s:37:\"connects-mailget/connects-mailget.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-mailget.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:22:\"Connects MailGet Addon\";s:10:\"short_name\";s:7:\"MailGet\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:3:\"4.8\";s:4:\"slug\";s:16:\"connects-mailget\";s:13:\"product_image\";s:65:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo.png\";s:11:\"description\";s:50:\"Integration with MailGet Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:33;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-mailgun\";s:4:\"init\";s:37:\"connects-mailgun/connects-mailgun.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-mailgun.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:18:\"Connects - Mailgun\";s:10:\"short_name\";s:7:\"Mailgun\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:3:\"4.8\";s:4:\"slug\";s:16:\"connects-mailgun\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-1.png\";s:11:\"description\";s:48:\"Integrate with Mailgun Email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:34;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:16:\"connects-klaviyo\";s:4:\"init\";s:37:\"connects-klaviyo/connects-klaviyo.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:20:\"connects-klaviyo.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Connects - Klaviyo Addon\";s:10:\"short_name\";s:8:\"Klaviyo \";s:7:\"version\";s:5:\"1.0.2\";s:6:\"tested\";s:5:\"4.9.5\";s:4:\"slug\";s:16:\"connects-klaviyo\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-2.png\";s:11:\"description\";s:54:\"Use this plugin to integrate Klaviyo with Convert Plus\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:35;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:17:\"connects-sendlane\";s:4:\"init\";s:39:\"connects-sendlane/connects-sendlane.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"connects-sendlane.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - Sendlane Mailer\";s:10:\"short_name\";s:8:\"Sendlane\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:5:\"4.9.2\";s:4:\"slug\";s:17:\"connects-sendlane\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-3.png\";s:11:\"description\";s:42:\"Integration with Sendlane Email Marketing.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:36;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:20:\"connects-elasticmail\";s:4:\"init\";s:47:\"connects-elasticmail/connects-elastic-email.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:24:\"connects-elasticmail.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Connects - Elastic Email\";s:10:\"short_name\";s:13:\"Elastic Email\";s:7:\"version\";s:5:\"1.0.1\";s:6:\"tested\";s:5:\"4.9.6\";s:4:\"slug\";s:20:\"connects-elasticmail\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-4.png\";s:11:\"description\";s:38:\"Integrate with Elastic Email Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:0:\"\";}i:37;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:17:\"connects-mailwizz\";s:4:\"init\";s:39:\"connects-mailwizz/connects-mailwizz.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"connects-mailwizz.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - MailWizz Mailer\";s:10:\"short_name\";s:8:\"MailWizz\";s:7:\"version\";s:5:\"1.0.2\";s:6:\"tested\";s:5:\"4.9.6\";s:4:\"slug\";s:17:\"connects-mailwizz\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-5.png\";s:11:\"description\";s:65:\"Integrate MailWizz email Marketing application with Convert Plus.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.2\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}i:38;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:17:\"connects-sendgrid\";s:4:\"init\";s:39:\"connects-sendgrid/connects-sendgrid.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"connects-sendgrid.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:26:\"Connects - SendGrid Mailer\";s:10:\"short_name\";s:8:\"SendGrid\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:5:\"4.9.6\";s:4:\"slug\";s:17:\"connects-sendgrid\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-6.png\";s:11:\"description\";s:51:\"Integration with SendGrid email Marketing Services.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:0:\"\";}i:39;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:15:\"connects-zapier\";s:4:\"init\";s:35:\"connects-zapier/connects-zapier.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:19:\"connects-zapier.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:24:\"Connects - Zapier Mailer\";s:10:\"short_name\";s:7:\"Zapier \";s:7:\"version\";s:5:\"1.0.1\";s:6:\"tested\";s:5:\"4.9.8\";s:4:\"slug\";s:15:\"connects-zapier\";s:13:\"product_image\";s:82:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-7-e1534416295165.png\";s:11:\"description\";s:31:\"Integrate Zapier with connects.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.1\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:0:\"\";}i:40;O:8:\"stdClass\":19:{s:15:\"licence_require\";s:4:\"true\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:19:\"connects-convertfox\";s:4:\"init\";s:43:\"connects-convertfox/connects-convertfox.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:23:\"connects-convertfox.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:21:\"Connects - ConvertFox\";s:10:\"short_name\";s:10:\"ConvertFox\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:5:\"4.9.7\";s:4:\"slug\";s:19:\"connects-convertfox\";s:13:\"product_image\";s:67:\"//support.brainstormforce.com/wp-content/uploads/2017/07/logo-8.png\";s:11:\"description\";s:32:\"Collect leads using Convert Fox.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:6:\"parent\";s:8:\"14058953\";s:13:\"changelog_url\";s:57:\"https://changelog.brainstormforce.com/convertplug-addons/\";}}}", "yes");
INSERT INTO `trvlite_options` VALUES("200734", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.9.8.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.9.8.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.9.8-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.9.8-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.9.8\";s:7:\"version\";s:5:\"4.9.8\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1537608781;s:15:\"version_checked\";s:5:\"4.9.8\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `trvlite_options` VALUES("400", "ultimate_updater", "disabled", "yes");
INSERT INTO `trvlite_options` VALUES("401", "ultimate_constants", "a:3:{s:24:\"ULTIMATE_NO_UPDATE_CHECK\";b:1;s:28:\"ULTIMATE_NO_EDIT_PAGE_NOTICE\";b:1;s:30:\"ULTIMATE_NO_PLUGIN_PAGE_NOTICE\";b:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("402", "ultimate_modules", "a:41:{i:0;s:18:\"ultimate_animation\";i:1;s:16:\"ultimate_buttons\";i:2;s:18:\"ultimate_countdown\";i:3;s:17:\"ultimate_flip_box\";i:4;s:20:\"ultimate_google_maps\";i:5;s:22:\"ultimate_google_trends\";i:6;s:17:\"ultimate_headings\";i:7;s:22:\"ultimate_icon_timeline\";i:8;s:17:\"ultimate_info_box\";i:9;s:20:\"ultimate_info_circle\";i:10;s:18:\"ultimate_info_list\";i:11;s:20:\"ultimate_info_tables\";i:12;s:28:\"ultimate_interactive_banners\";i:13;s:29:\"ultimate_interactive_banner_2\";i:14;s:15:\"ultimate_modals\";i:15;s:17:\"ultimate_parallax\";i:16;s:23:\"ultimate_pricing_tables\";i:17;s:15:\"ultimate_spacer\";i:18;s:22:\"ultimate_stats_counter\";i:19;s:20:\"ultimate_swatch_book\";i:20;s:14:\"ultimate_icons\";i:21;s:18:\"ultimate_list_icon\";i:22;s:17:\"ultimate_carousel\";i:23;s:18:\"ultimate_fancytext\";i:24;s:22:\"ultimate_highlight_box\";i:25;s:20:\"ultimate_info_banner\";i:26;s:15:\"ultimate_ihover\";i:27;s:16:\"ultimate_hotspot\";i:28;s:21:\"ultimate_video_banner\";i:29;s:11:\"woocomposer\";i:30;s:20:\"ultimate_dual_button\";i:31;s:13:\"ultimate_link\";i:32;s:19:\"ultimate_fancy_text\";i:33;s:23:\"ultimate_hightlight_box\";i:34;s:20:\"ultimate_content_box\";i:35;s:24:\"ultimate_image_separator\";i:36;s:27:\"ultimate_expandable_section\";i:37;s:12:\"ultimate_tab\";i:38;s:23:\"ultimate_sticky_section\";i:39;s:13:\"ultimate_team\";i:40;s:21:\"ultimate_range_slider\";}", "yes");
INSERT INTO `trvlite_options` VALUES("403", "smile_fonts", "a:1:{s:8:\"Defaults\";a:4:{s:7:\"include\";s:20:\"smile_fonts/Defaults\";s:6:\"folder\";s:20:\"smile_fonts/Defaults\";s:5:\"style\";s:21:\"Defaults/Defaults.css\";s:6:\"config\";s:11:\"charmap.php\";}}", "yes");
INSERT INTO `trvlite_options` VALUES("171851", "category_children", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("414", "dt_gallery_category_children", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("415", "dt_team_category_children", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("416", "dt_testimonials_category_children", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("417", "dt_benefits_category_children", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("418", "dt_logos_category_children", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("419", "the7_options_saved", "1", "no");
INSERT INTO `trvlite_options` VALUES("6771", "bop_nav_search_box_item_version", "1.6.0", "no");
INSERT INTO `trvlite_options` VALUES("421", "presscore_less_css_is_writable", "1", "yes");
INSERT INTO `trvlite_options` VALUES("422", "wp_less_stylesheet_data_fc6280e885d8c32d1db8b71940b8edbd", "a:1:{s:10:\"target_uri\";s:93:\"http://travelite.com.ph/wp-content/uploads/wp-less/travelite/css/custom-old-ie-a333972310.css\";}", "yes");
INSERT INTO `trvlite_options` VALUES("425", "wp_less_stylesheet_data_dd31d353a894258d12e04e3169fee910", "a:1:{s:10:\"target_uri\";s:86:\"http://travelite.com.ph/wp-content/uploads/wp-less/travelite/css/custom-a333972310.css\";}", "yes");
INSERT INTO `trvlite_options` VALUES("428", "wp_less_stylesheet_data_932bbcc109b2b79c8a8a8fc4354e24c8", "a:1:{s:10:\"target_uri\";s:85:\"http://travelite.com.ph/wp-content/uploads/wp-less/travelite/css/media-a333972310.css\";}", "yes");
INSERT INTO `trvlite_options` VALUES("431", "wp_less_stylesheet_data_d51fd0f089cd989d92e95fae2b5c1585", "a:1:{s:10:\"target_uri\";s:97:\"http://travelite.com.ph/wp-content/uploads/wp-less/travelite/css/post-type-dynamic-a333972310.css\";}", "yes");
INSERT INTO `trvlite_options` VALUES("434", "rs_cache_overlay", "5.3.1.5", "yes");
INSERT INTO `trvlite_options` VALUES("441", "WPLANG", "", "yes");
INSERT INTO `trvlite_options` VALUES("2143", "revslider-dashboard", "O:8:\"stdClass\":1:{s:11:\"test-handle\";O:8:\"stdClass\":5:{s:12:\"version_from\";s:5:\"5.0.0\";s:10:\"version_to\";s:5:\"5.0.0\";s:5:\"order\";i:5;s:7:\"content\";s:181:\"<div class=\"rs-dash-widget\"><div class=\"rs-dash-title-wrap\"><div class=\"rs-dash-title\">your version is: {{current_version}}</div></div><div class=\"rs-dash-widget-inner\"></div></div>\";s:4:\"code\";s:0:\"\";}}", "yes");
INSERT INTO `trvlite_options` VALUES("7252", "wp_less_stylesheet_data_eb6943918b85f5ac68d6b4c8eb969e33", "a:1:{s:10:\"target_uri\";s:93:\"http://travelite.com.ph/wp-content/uploads/wp-less/travelite/css/custom-old-ie-a19689ef8a.css\";}", "yes");
INSERT INTO `trvlite_options` VALUES("7255", "wp_less_stylesheet_data_f2eaec7b8f937b04c74811adb11c0b75", "a:1:{s:10:\"target_uri\";s:86:\"http://travelite.com.ph/wp-content/uploads/wp-less/travelite/css/custom-a19689ef8a.css\";}", "yes");
INSERT INTO `trvlite_options` VALUES("7258", "wp_less_stylesheet_data_e061d93671a8af0d3e1d055f19cc9f19", "a:1:{s:10:\"target_uri\";s:85:\"http://travelite.com.ph/wp-content/uploads/wp-less/travelite/css/media-a19689ef8a.css\";}", "yes");
INSERT INTO `trvlite_options` VALUES("132109", "um_existing_rows_2685", "a:1:{i:0;s:9:\"_um_row_1\";}", "yes");
INSERT INTO `trvlite_options` VALUES("132110", "um_form_rowdata_2685", "a:1:{s:9:\"_um_row_1\";a:5:{s:4:\"type\";s:3:\"row\";s:2:\"id\";s:9:\"_um_row_1\";s:8:\"sub_rows\";s:1:\"1\";s:4:\"cols\";s:1:\"1\";s:6:\"origin\";s:9:\"_um_row_1\";}}", "yes");
INSERT INTO `trvlite_options` VALUES("2154", "revslider-notices-dc", "a:5:{i:0;s:10:\"TPRS540-01\";i:1;s:11:\"TPRS5452-01\";i:2;s:10:\"TPRS545-01\";i:3;s:10:\"TPRS546-01\";i:4;s:10:\"TPRS548-01\";}", "yes");
INSERT INTO `trvlite_options` VALUES("7134", "sep_exclude", "a:76:{i:0;i:1413;i:1;i:1412;i:2;i:1411;i:3;i:1410;i:4;i:1409;i:5;i:1408;i:6;i:1407;i:7;i:1406;i:8;i:1405;i:9;i:1404;i:10;i:1403;i:11;i:1402;i:12;i:1379;i:13;i:1378;i:14;i:1377;i:15;i:1376;i:16;i:1375;i:17;i:1374;i:18;i:1373;i:19;i:1372;i:20;i:1371;i:21;i:1370;i:22;i:1369;i:23;i:1368;i:24;i:1367;i:25;i:1366;i:26;i:1365;i:27;i:1364;i:28;i:1363;i:29;i:1362;i:30;i:1361;i:31;i:1360;i:32;i:1359;i:33;i:1358;i:34;i:1100;i:35;i:753;i:36;i:726;i:37;i:1244;i:38;i:1241;i:39;i:1186;i:40;i:1191;i:41;i:1247;i:42;i:922;i:43;i:1196;i:44;i:1249;i:45;i:1251;i:46;i:1334;i:47;i:684;i:48;i:1474;i:49;i:1456;i:50;i:1446;i:51;i:1444;i:52;i:1439;i:53;i:1461;i:54;i:1450;i:55;i:1458;i:56;i:1448;i:57;i:1442;i:58;i:1454;i:59;i:1452;i:60;i:2;i:61;i:1501;i:62;i:764;i:63;i:789;i:64;i:848;i:65;i:927;i:66;i:2286;i:67;i:2298;i:68;i:548;i:69;i:2328;i:70;i:2337;i:71;i:2375;i:72;i:2378;i:73;i:2381;i:74;i:2384;i:75;i:2664;}", "yes");
INSERT INTO `trvlite_options` VALUES("7230", "duplicator_version_plugin", "1.2.46", "yes");
INSERT INTO `trvlite_options` VALUES("131005", "__ultimatemember_sitekey", "travelite.com.ph-1IkNlfi40bsrrsrzIV37", "yes");
INSERT INTO `trvlite_options` VALUES("131006", "um_is_installed", "1", "yes");
INSERT INTO `trvlite_options` VALUES("131007", "um_core_forms", "a:3:{i:2685;i:2685;i:2686;i:2686;i:2687;i:2687;}", "yes");
INSERT INTO `trvlite_options` VALUES("131008", "um_core_directories", "a:1:{i:2688;i:2688;}", "yes");
INSERT INTO `trvlite_options` VALUES("172538", "um_last_version_upgrade", "2.0.10", "yes");
INSERT INTO `trvlite_options` VALUES("131010", "um_options", "a:183:{s:8:\"last_tab\";s:0:\"\";s:9:\"core_user\";s:4:\"2689\";s:12:\"core_account\";s:4:\"2699\";s:12:\"core_members\";s:4:\"2695\";s:13:\"core_register\";s:4:\"2693\";s:10:\"core_login\";s:4:\"2691\";s:11:\"core_logout\";s:4:\"2697\";s:19:\"core_password-reset\";s:4:\"2701\";s:12:\"default_role\";s:6:\"member\";s:14:\"permalink_base\";s:7:\"user_id\";s:12:\"display_name\";s:9:\"full_name\";s:18:\"display_name_field\";s:0:\"\";s:29:\"force_display_name_capitlized\";s:1:\"1\";s:15:\"author_redirect\";s:1:\"0\";s:12:\"members_page\";s:1:\"0\";s:13:\"use_gravatars\";s:1:\"1\";s:37:\"use_um_gravatar_default_builtin_image\";s:2:\"mm\";s:29:\"use_um_gravatar_default_image\";s:1:\"0\";s:24:\"reset_require_strongpass\";s:1:\"0\";s:33:\"editable_primary_email_in_profile\";s:1:\"0\";s:20:\"account_tab_password\";s:1:\"1\";s:19:\"account_tab_privacy\";s:1:\"0\";s:25:\"account_tab_notifications\";s:1:\"1\";s:18:\"account_tab_delete\";s:1:\"0\";s:19:\"delete_account_text\";s:150:\"Are you sure you want to delete your account? This will erase all of your account data from the site. To delete your account enter your password below\";s:12:\"account_name\";s:1:\"1\";s:20:\"account_name_disable\";s:1:\"0\";s:20:\"account_name_require\";s:1:\"1\";s:13:\"account_email\";s:1:\"0\";s:25:\"account_hide_in_directory\";s:1:\"0\";s:26:\"account_require_strongpass\";s:1:\"0\";s:9:\"panic_key\";s:10:\"AOiKEXDrGo\";s:10:\"accessible\";s:1:\"0\";s:15:\"access_redirect\";s:0:\"\";s:20:\"home_page_accessible\";s:1:\"1\";s:24:\"category_page_accessible\";s:1:\"1\";s:13:\"wpadmin_login\";s:1:\"0\";s:25:\"deny_admin_frontend_login\";s:1:\"0\";s:22:\"wpadmin_login_redirect\";s:13:\"um_login_page\";s:26:\"wpadmin_login_redirect_url\";s:0:\"\";s:16:\"wpadmin_register\";s:1:\"0\";s:25:\"wpadmin_register_redirect\";s:16:\"um_register_page\";s:29:\"wpadmin_register_redirect_url\";s:7:\"/login/\";s:24:\"access_widget_admin_only\";s:1:\"1\";s:27:\"enable_reset_password_limit\";s:1:\"1\";s:27:\"reset_password_limit_number\";s:1:\"5\";s:34:\"disable_admin_reset_password_limit\";s:1:\"0\";s:17:\"wpadmin_allow_ips\";s:0:\"\";s:11:\"blocked_ips\";s:0:\"\";s:14:\"blocked_emails\";s:0:\"\";s:13:\"blocked_words\";s:47:\"admin\r\nadministrator\r\nwebmaster\r\nsupport\r\nstaff\";s:9:\"mail_from\";s:26:\"Travelite Travel and Tours\";s:14:\"mail_from_addr\";s:21:\"info@travelite.com.ph\";s:10:\"email_html\";b:0;s:16:\"welcome_email_on\";s:1:\"1\";s:17:\"welcome_email_sub\";s:23:\"Welcome to {site_name}!\";s:13:\"welcome_email\";s:306:\"Hi {display_name},\r\n\r\nThank you for signing up with {site_name}! Your account is now active.\r\n\r\nTo login please visit the following url:\r\n\r\n{login_url}\r\n\r\nYour account e-mail: {email}\r\nYour account username: {username}\r\n\r\nIf you have any problems, please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:18:\"checkmail_email_on\";s:1:\"1\";s:19:\"checkmail_email_sub\";s:28:\"Please activate your account\";s:15:\"checkmail_email\";s:266:\"Hi {display_name},\r\n\r\nThank you for signing up with {site_name}! To activate your account, please click the link below to confirm your email address:\r\n\r\n{account_activation_link}\r\n\r\nIf you have any problems, please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:16:\"pending_email_on\";s:1:\"1\";s:17:\"pending_email_sub\";s:30:\"Your account is pending review\";s:13:\"pending_email\";s:272:\"Hi {display_name},\r\n\r\nThank you for signing up with {site_name}! Your account is currently being reviewed by a member of our team.\r\n\r\nPlease allow us some time to process your request.\r\n\r\nIf you have any problems, please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:17:\"approved_email_on\";s:1:\"1\";s:18:\"approved_email_sub\";s:41:\"Your account at {site_name} is now active\";s:14:\"approved_email\";s:378:\"Hi {display_name},\r\n\r\nThank you for signing up with {site_name}! Your account has been approved and is now active.\r\n\r\nTo login please visit the following url:\r\n\r\n{login_url}\r\n\r\nYour account e-mail: {email}\r\nYour account username: {username}\r\nSet your account password: {password_reset_link}\r\n\r\nIf you have any problems, please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:17:\"rejected_email_on\";s:1:\"1\";s:18:\"rejected_email_sub\";s:30:\"Your account has been rejected\";s:14:\"rejected_email\";s:260:\"Hi {display_name},\r\n\r\nThank you for applying for membership to {site_name}! We have reviewed your information and unfortunately we are unable to accept you as a member at this moment.\r\n\r\nPlease feel free to apply again at a future date.\r\n\r\nThanks,\r\n{site_name}\";s:17:\"inactive_email_on\";s:1:\"1\";s:18:\"inactive_email_sub\";s:33:\"Your account has been deactivated\";s:14:\"inactive_email\";s:222:\"Hi {display_name},\r\n\r\nThis is an automated email to let you know your {site_name} account has been deactivated.\r\n\r\nIf you would like your account to be reactivated please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:17:\"deletion_email_on\";s:1:\"1\";s:18:\"deletion_email_sub\";s:29:\"Your account has been deleted\";s:14:\"deletion_email\";s:332:\"Hi {display_name},\r\n\r\nThis is an automated email to let you know your {site_name} account has been deleted. All of your personal information has been permanently deleted and you will no longer be able to login to {site_name}.\r\n\r\nIf your account has been deleted by accident please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:16:\"resetpw_email_on\";s:1:\"1\";s:17:\"resetpw_email_sub\";s:19:\"Reset your password\";s:13:\"resetpw_email\";s:266:\"Hi {display_name},\r\n\r\nWe received a request to reset the password for your account. If you made this request, click the link below to change your password:\r\n\r\n{password_reset_link}\r\n\r\nIf you didn\'t make this request, you can ignore this email\r\n\r\nThanks,\r\n{site_name}\";s:18:\"changedpw_email_on\";s:1:\"1\";s:19:\"changedpw_email_sub\";s:42:\"Your {site_name} password has been changed\";s:15:\"changedpw_email\";s:279:\"Hi {display_name},\r\n\r\nYou recently changed the password associated with your {site_name} account.\r\n\r\nIf you did not make this change and believe your {site_name} account has been compromised, please contact us at the following email address: {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:11:\"admin_email\";s:21:\"info@travelite.com.ph\";s:24:\"notification_new_user_on\";s:1:\"1\";s:25:\"notification_new_user_sub\";s:30:\"[{site_name}] New user account\";s:21:\"notification_new_user\";s:187:\"{display_name} has just created an account on {site_name}. To view their profile click here:\r\n\r\n{user_profile_link}\r\n\r\nHere is the submitted registration form:\r\n\r\n{submitted_registration}\";s:22:\"notification_review_on\";s:1:\"1\";s:23:\"notification_review_sub\";s:60:\"[{site_name}] New Travel Agent registration awaiting review!\";s:19:\"notification_review\";s:245:\"{display_name} has just applied for membership to {site_name} and is waiting to be reviewed.\r\n\r\nTo review this member please click the following link:\r\n\r\n{user_profile_link}\r\n\r\nHere is the submitted registration form:\r\n\r\n{submitted_registration}\";s:24:\"notification_deletion_on\";s:1:\"0\";s:25:\"notification_deletion_sub\";s:29:\"[{site_name}] Account deleted\";s:21:\"notification_deletion\";s:58:\"{display_name} has just deleted their {site_name} account.\";s:22:\"profile_photo_max_size\";s:6:\"500000\";s:20:\"cover_photo_max_size\";s:7:\"1000000\";s:17:\"photo_thumb_sizes\";a:3:{i:0;s:2:\"40\";i:1;s:2:\"80\";i:2;s:3:\"190\";}s:17:\"cover_thumb_sizes\";a:2:{i:0;s:3:\"200\";i:1;s:3:\"200\";}s:17:\"image_compression\";s:2:\"60\";s:15:\"image_max_width\";s:4:\"1500\";s:15:\"cover_min_width\";s:3:\"800\";s:13:\"profile_title\";s:43:\"{display_name} | Travelite Travel and Tours\";s:12:\"profile_desc\";s:83:\"{display_name} is on {site_name}. Join {site_name} to view {display_name}\'s profile\";s:18:\"directory_template\";s:7:\"members\";s:13:\"form_asterisk\";s:1:\"0\";s:16:\"profile_template\";s:7:\"profile\";s:17:\"profile_max_width\";s:6:\"1000px\";s:22:\"profile_area_max_width\";s:5:\"600px\";s:13:\"profile_icons\";s:5:\"label\";s:24:\"profile_primary_btn_word\";s:14:\"Update Profile\";s:21:\"profile_secondary_btn\";s:1:\"1\";s:26:\"profile_secondary_btn_word\";s:6:\"Cancel\";s:12:\"profile_role\";s:1:\"0\";s:15:\"profile_main_bg\";s:0:\"\";s:17:\"profile_header_bg\";s:0:\"\";s:14:\"default_avatar\";a:5:{s:2:\"id\";s:4:\"1020\";s:5:\"width\";s:2:\"80\";s:6:\"height\";s:2:\"95\";s:9:\"thumbnail\";s:0:\"\";s:3:\"url\";s:80:\"http://travelite.com.ph/wp-content/uploads/2017/04/admin-logo-e1493965153866.png\";}s:13:\"default_cover\";a:5:{s:2:\"id\";s:0:\"\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";s:3:\"url\";s:0:\"\";}s:17:\"profile_photosize\";s:5:\"190px\";s:21:\"profile_cover_enabled\";s:1:\"1\";s:19:\"profile_cover_ratio\";s:5:\"2.7:1\";s:21:\"profile_show_metaicon\";s:1:\"0\";s:17:\"profile_show_name\";s:1:\"1\";s:25:\"profile_show_social_links\";s:1:\"0\";s:16:\"profile_show_bio\";s:1:\"1\";s:21:\"profile_show_html_bio\";s:1:\"0\";s:20:\"profile_bio_maxchars\";s:3:\"180\";s:19:\"profile_header_menu\";s:2:\"bc\";s:18:\"profile_empty_text\";s:1:\"1\";s:22:\"profile_empty_text_emo\";s:1:\"1\";s:12:\"profile_menu\";s:1:\"1\";s:16:\"profile_tab_main\";s:1:\"1\";s:24:\"profile_tab_main_privacy\";s:1:\"0\";s:17:\"profile_tab_posts\";s:1:\"1\";s:25:\"profile_tab_posts_privacy\";s:1:\"0\";s:20:\"profile_tab_comments\";s:1:\"1\";s:28:\"profile_tab_comments_privacy\";s:1:\"0\";s:24:\"profile_menu_default_tab\";s:4:\"main\";s:18:\"profile_menu_icons\";s:1:\"1\";s:17:\"register_template\";s:8:\"register\";s:18:\"register_max_width\";s:5:\"450px\";s:14:\"register_icons\";s:5:\"label\";s:25:\"register_primary_btn_word\";s:8:\"Register\";s:22:\"register_secondary_btn\";s:1:\"1\";s:27:\"register_secondary_btn_word\";s:5:\"Login\";s:26:\"register_secondary_btn_url\";s:0:\"\";s:13:\"register_role\";s:1:\"0\";s:14:\"login_template\";s:5:\"login\";s:15:\"login_max_width\";s:5:\"450px\";s:11:\"login_icons\";s:5:\"label\";s:22:\"login_primary_btn_word\";s:5:\"Login\";s:19:\"login_secondary_btn\";s:1:\"1\";s:24:\"login_secondary_btn_word\";s:8:\"Register\";s:23:\"login_secondary_btn_url\";s:0:\"\";s:22:\"login_forgot_pass_link\";s:1:\"1\";s:21:\"login_show_rememberme\";s:1:\"1\";s:28:\"um_profile_object_cache_stop\";s:1:\"1\";s:13:\"um_flush_stop\";s:1:\"0\";s:29:\"um_generate_slug_in_directory\";s:1:\"0\";s:18:\"current_url_method\";s:11:\"SERVER_NAME\";s:22:\"um_port_forwarding_url\";s:1:\"0\";s:21:\"um_force_utf8_strings\";s:1:\"0\";s:14:\"enable_timebot\";s:1:\"1\";s:14:\"disable_minify\";s:1:\"0\";s:12:\"disable_menu\";s:1:\"0\";s:19:\"js_css_exlcude_home\";s:1:\"0\";s:17:\"enable_custom_css\";s:1:\"0\";s:14:\"allow_tracking\";s:1:\"0\";s:24:\"addon_bp_avatar_transfer\";s:0:\"\";s:23:\"addon_gravatar_transfer\";s:0:\"\";s:27:\"addon_generate_random_users\";s:0:\"\";s:18:\"addon_install_info\";s:0:\"\";s:19:\"access_exclude_uris\";a:0:{}s:22:\"profile_tab_main_roles\";s:0:\"\";s:23:\"profile_tab_posts_roles\";s:0:\"\";s:26:\"profile_tab_comments_roles\";s:0:\"\";s:14:\"js_css_exclude\";a:0:{}s:14:\"js_css_include\";a:0:{}s:30:\"restricted_access_post_metabox\";a:6:{s:4:\"post\";b:1;s:4:\"page\";b:1;s:10:\"attachment\";b:1;s:12:\"dt_portfolio\";b:1;s:12:\"dt_slideshow\";b:1;s:17:\"tfba_twitter_feed\";b:1;}s:19:\"uninstall_on_delete\";i:0;s:22:\"custom_roles_increment\";i:1;s:23:\"changedaccount_email_on\";b:1;s:24:\"changedaccount_email_sub\";s:39:\"Your account at {site_name} was updated\";s:20:\"changedaccount_email\";s:278:\"Hi {display_name},<br /><br />You recently updated your {site_name} account.<br /><br />If you did not make this change and believe your {site_name} account has been compromised, please contact us at the following email address: {admin_email}<br /><br />Thanks,<br />{site_name}\";s:16:\"directory_header\";s:21:\"{total_users} Members\";s:23:\"directory_header_single\";s:20:\"{total_users} Member\";s:34:\"restricted_access_taxonomy_metabox\";a:3:{s:8:\"category\";b:1;s:8:\"post_tag\";b:1;s:21:\"dt_portfolio_category\";b:1;}}", "yes");
INSERT INTO `trvlite_options` VALUES("131011", "um_first_setup_roles", "1", "yes");
INSERT INTO `trvlite_options` VALUES("131012", "um_hashed_passwords_fix", "1", "yes");
INSERT INTO `trvlite_options` VALUES("131040", "um_tracking_notice", "1", "yes");
INSERT INTO `trvlite_options` VALUES("131014", "redux_version_upgraded_from", "3.6.2", "yes");
INSERT INTO `trvlite_options` VALUES("171834", "duplicator_ui_view_state", "a:1:{s:22:\"dup-pack-archive-panel\";s:1:\"1\";}", "yes");
INSERT INTO `trvlite_options` VALUES("171835", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-09-22 09:58:21\";s:7:\"Version\";s:6:\"1.2.46\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.7.23\";s:10:\"VersionPHP\";s:6:\"5.6.38\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20180705_travelitetravelandtours\";s:4:\"Hash\";s:35:\"d9a5ef1ef61035827146_20180922095821\";s:8:\"NameHash\";s:68:\"20180705_travelitetravelandtours_d9a5ef1ef61035827146_20180922095821\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:58:\"/home/travel/public_html/travelite.com.ph/wp-snapshots/tmp\";s:8:\"StoreURL\";s:37:\"http://travelite.com.ph/wp-snapshots/\";s:8:\"ScanFile\";s:78:\"20180705_travelitetravelandtours_d9a5ef1ef61035827146_20180922095821_scan.json\";s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":19:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:41:\"/home/travel/public_html/travelite.com.ph\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":4:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":5:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":2:{s:4:\"Core\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2018-09-22 09:58:21\";s:7:\"Version\";s:6:\"1.2.46\";s:9:\"VersionWP\";s:5:\"4.9.8\";s:9:\"VersionDB\";s:6:\"5.7.23\";s:10:\"VersionPHP\";s:6:\"5.6.38\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:32:\"20180705_travelitetravelandtours\";s:4:\"Hash\";s:35:\"d9a5ef1ef61035827146_20180922095821\";s:8:\"NameHash\";s:68:\"20180705_travelitetravelandtours_d9a5ef1ef61035827146_20180922095821\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:58:\"/home/travel/public_html/travelite.com.ph/wp-snapshots/tmp\";s:8:\"StoreURL\";s:37:\"http://travelite.com.ph/wp-snapshots/\";s:8:\"ScanFile\";N;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";N;s:6:\"WPUser\";N;s:7:\"Archive\";r:22;s:9:\"Installer\";O:13:\"DUP_Installer\":9:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:10:\"\0*\0Package\";r:58;}s:8:\"Database\";O:12:\"DUP_Database\":13:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:10:\"\0*\0Package\";r:58;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:6:{i:0;s:50:\"/home/travel/public_html/travelite.com.ph/wp-admin\";i:1;s:60:\"/home/travel/public_html/travelite.com.ph/wp-content/uploads\";i:2;s:62:\"/home/travel/public_html/travelite.com.ph/wp-content/languages\";i:3;s:60:\"/home/travel/public_html/travelite.com.ph/wp-content/plugins\";i:4;s:59:\"/home/travel/public_html/travelite.com.ph/wp-content/themes\";i:5;s:53:\"/home/travel/public_html/travelite.com.ph/wp-includes\";}}s:9:\"Installer\";r:80;s:8:\"Database\";r:90;}", "yes");
INSERT INTO `trvlite_options` VALUES("132121", "um_cached_role_member", "a:31:{s:4:\"role\";s:6:\"member\";s:4:\"core\";s:6:\"member\";s:18:\"can_access_wpadmin\";s:1:\"0\";s:20:\"can_not_see_adminbar\";s:1:\"1\";s:17:\"can_edit_everyone\";s:1:\"0\";s:19:\"can_delete_everyone\";s:1:\"0\";s:16:\"can_edit_profile\";s:1:\"1\";s:18:\"can_delete_profile\";s:1:\"0\";s:12:\"can_view_all\";s:1:\"0\";s:24:\"can_make_private_profile\";s:1:\"0\";s:26:\"can_access_private_profile\";s:1:\"0\";s:16:\"default_homepage\";s:1:\"1\";s:6:\"status\";s:7:\"pending\";s:16:\"auto_approve_act\";s:16:\"redirect_profile\";s:11:\"after_login\";s:16:\"redirect_profile\";s:12:\"after_logout\";s:13:\"redirect_home\";s:11:\"synced_role\";s:1:\"0\";s:17:\"redirect_homepage\";s:0:\"\";s:16:\"auto_approve_url\";s:0:\"\";s:20:\"login_email_activate\";s:1:\"0\";s:16:\"checkmail_action\";s:12:\"show_message\";s:17:\"checkmail_message\";s:147:\"Thank you for registering. Before you can login we need you to activate your account by clicking the activation link in the email we just sent you.\";s:13:\"checkmail_url\";s:0:\"\";s:18:\"url_email_activate\";s:0:\"\";s:14:\"pending_action\";s:12:\"show_message\";s:15:\"pending_message\";s:170:\"Thank you for applying for membership to our site. We will review your details and send you an email letting you know whether your application has been successful or not.\";s:11:\"pending_url\";s:0:\"\";s:18:\"login_redirect_url\";s:0:\"\";s:19:\"logout_redirect_url\";s:0:\"\";s:12:\"after_delete\";s:13:\"redirect_home\";s:19:\"delete_redirect_url\";s:0:\"\";}", "yes");
INSERT INTO `trvlite_options` VALUES("131018", "um_options-transients", "a:3:{s:14:\"changed_values\";a:2:{s:22:\"profile_photo_max_size\";s:3:\"500\";s:20:\"cover_photo_max_size\";s:4:\"1000\";}s:9:\"last_save\";i:1520992435;s:13:\"last_compiler\";i:1520990203;}", "yes");
INSERT INTO `trvlite_options` VALUES("131002", "widget_um_search_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("131003", "um_cached_role_admin", "a:15:{s:4:\"core\";s:5:\"admin\";s:18:\"can_access_wpadmin\";i:1;s:20:\"can_not_see_adminbar\";i:0;s:17:\"can_edit_everyone\";i:1;s:19:\"can_delete_everyone\";i:1;s:16:\"can_edit_profile\";i:1;s:18:\"can_delete_profile\";i:1;s:12:\"can_view_all\";i:1;s:24:\"can_make_private_profile\";i:1;s:26:\"can_access_private_profile\";i:1;s:16:\"default_homepage\";i:1;s:6:\"status\";s:8:\"approved\";s:16:\"auto_approve_act\";s:16:\"redirect_profile\";s:11:\"after_login\";s:14:\"redirect_admin\";s:12:\"after_logout\";s:13:\"redirect_home\";}", "yes");
INSERT INTO `trvlite_options` VALUES("12644", "widget_like_box_facbook", "a:2:{i:2;a:8:{s:5:\"title\";s:20:\"Like Us on Facebook!\";s:10:\"profile_id\";s:20:\"travelitephilippines\";s:11:\"connections\";s:4:\"show\";s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"550\";s:6:\"header\";s:5:\"small\";s:11:\"cover_photo\";s:4:\"show\";s:6:\"locale\";s:5:\"en_US\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("12702", "mc4wp_flash_messages", "a:0:{}", "no");
INSERT INTO `trvlite_options` VALUES("12703", "mc4wp", "a:4:{s:7:\"api_key\";s:36:\"28f72b6100e1c09241bcc294ad896636-us3\";s:20:\"allow_usage_tracking\";i:0;s:15:\"debug_log_level\";s:7:\"warning\";s:18:\"first_activated_on\";i:1495772349;}", "yes");
INSERT INTO `trvlite_options` VALUES("12706", "mc4wp_mailchimp_list_ids", "a:19:{i:0;s:10:\"0c034b97cb\";i:1;s:10:\"10b21522fd\";i:2;s:10:\"1707e0cea8\";i:3;s:10:\"23089158c8\";i:4;s:10:\"2b9c89dc24\";i:5;s:10:\"30548e1033\";i:6;s:10:\"35eee68413\";i:7;s:10:\"422ddead73\";i:8;s:10:\"7fb6b33e20\";i:9;s:10:\"8bd500584a\";i:10;s:10:\"91f72f4c92\";i:11;s:10:\"9c544ae962\";i:12;s:10:\"a85b37c4b8\";i:13;s:10:\"b462ee9c1a\";i:14;s:10:\"b931cc8dba\";i:15;s:10:\"be73db82c2\";i:16;s:10:\"cbec1c39a9\";i:17;s:10:\"fc18acd5bb\";i:18;s:10:\"fdf838c990\";}", "no");
INSERT INTO `trvlite_options` VALUES("12707", "mc4wp_mailchimp_list_23089158c8", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"23089158c8\";s:6:\"web_id\";i:265521;s:4:\"name\";s:42:\"Travelite Travel and Tours (Agents-VISMIN)\";s:16:\"subscriber_count\";i:405;s:12:\"merge_fields\";a:5:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:7:\"MMERGE3\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"MMERGE4\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:34:\"Travelite Travel & Tours Marketing\";s:10:\"from_email\";s:25:\"tim.tio@travelitecebu.com\";}}", "no");
INSERT INTO `trvlite_options` VALUES("131099", "new_admin_email", "info@cebuwebconcepts.com", "yes");
INSERT INTO `trvlite_options` VALUES("131100", "adminhash", "a:2:{s:4:\"hash\";s:32:\"b9ecfe0cd5250968db0f50fb38e23abf\";s:8:\"newemail\";s:21:\"info@travelite.com.ph\";}", "yes");
INSERT INTO `trvlite_options` VALUES("108848", "facebook_messenger_user", "https://www.facebook.com/travelitephilippines/", "yes");
INSERT INTO `trvlite_options` VALUES("108849", "facebook_messenger_backgroud", "#0075FF", "yes");
INSERT INTO `trvlite_options` VALUES("108850", "facebook_messenger_lang", "en_US", "yes");
INSERT INTO `trvlite_options` VALUES("108851", "facebook_messenger_woo_position", "3", "yes");
INSERT INTO `trvlite_options` VALUES("108852", "facebook_messenger_display", "1", "yes");
INSERT INTO `trvlite_options` VALUES("108853", "facebook_messenger_text_botton", "Send us a message!", "yes");
INSERT INTO `trvlite_options` VALUES("108854", "facebook_messenger_app", "", "yes");
INSERT INTO `trvlite_options` VALUES("108855", "facebook_messenger_app_text", "Send message via your Messenger App", "yes");
INSERT INTO `trvlite_options` VALUES("108856", "facebook_messenger_text_img", "https://cebuwebconcepts.com/wp-content/plugins/wp-facebook-messenger/frontend/images/facebook-messenger.svg", "yes");
INSERT INTO `trvlite_options` VALUES("108857", "widget_ninja_facebook_messenger_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("108865", "facebook_messenger_type", "0", "yes");
INSERT INTO `trvlite_options` VALUES("108866", "facebook_messenger_postion", "0", "yes");
INSERT INTO `trvlite_options` VALUES("108867", "facebook_messenger_hide_display", "0", "yes");
INSERT INTO `trvlite_options` VALUES("108868", "facebook_messenger_hide_page", "", "yes");
INSERT INTO `trvlite_options` VALUES("108869", "facebook_messenger_show_page", "", "yes");
INSERT INTO `trvlite_options` VALUES("108994", "sbi_rating_notice", "dismissed", "yes");
INSERT INTO `trvlite_options` VALUES("108995", "sb_instagram_settings", "a:40:{s:15:\"sb_instagram_at\";s:0:\"\";s:20:\"sb_instagram_user_id\";a:1:{i:0;s:9:\"973906762\";}s:30:\"sb_instagram_preserve_settings\";s:0:\"\";s:23:\"sb_instagram_ajax_theme\";s:0:\"\";s:23:\"sb_instagram_cache_time\";s:1:\"1\";s:28:\"sb_instagram_cache_time_unit\";s:5:\"hours\";s:18:\"sb_instagram_width\";i:100;s:23:\"sb_instagram_width_unit\";s:1:\"%\";s:28:\"sb_instagram_feed_width_resp\";s:0:\"\";s:19:\"sb_instagram_height\";s:0:\"\";s:16:\"sb_instagram_num\";i:7;s:24:\"sb_instagram_height_unit\";s:2:\"px\";s:17:\"sb_instagram_cols\";s:1:\"1\";s:27:\"sb_instagram_disable_mobile\";s:0:\"\";s:26:\"sb_instagram_image_padding\";i:5;s:31:\"sb_instagram_image_padding_unit\";s:2:\"px\";s:17:\"sb_instagram_sort\";s:4:\"none\";s:23:\"sb_instagram_background\";s:0:\"\";s:21:\"sb_instagram_show_btn\";s:2:\"on\";s:27:\"sb_instagram_btn_background\";s:0:\"\";s:27:\"sb_instagram_btn_text_color\";s:0:\"\";s:21:\"sb_instagram_btn_text\";s:12:\"Load More...\";s:22:\"sb_instagram_image_res\";s:4:\"auto\";s:24:\"sb_instagram_show_header\";s:2:\"on\";s:25:\"sb_instagram_header_color\";s:0:\"\";s:28:\"sb_instagram_show_follow_btn\";s:2:\"on\";s:33:\"sb_instagram_folow_btn_background\";s:0:\"\";s:34:\"sb_instagram_follow_btn_text_color\";s:0:\"\";s:28:\"sb_instagram_follow_btn_text\";s:19:\"Follow on Instagram\";s:23:\"sb_instagram_custom_css\";s:0:\"\";s:22:\"sb_instagram_custom_js\";s:0:\"\";s:17:\"sb_instagram_cron\";s:2:\"no\";s:9:\"check_api\";b:1;s:19:\"sb_instagram_backup\";b:1;s:24:\"enqueue_css_in_shortcode\";b:0;s:30:\"sb_instagram_disable_mob_swipe\";b:0;s:15:\"sbi_font_method\";s:3:\"svg\";s:28:\"sb_instagram_disable_awesome\";s:0:\"\";s:21:\"sb_instagram_show_bio\";s:2:\"on\";s:18:\"connected_accounts\";a:1:{i:973906762;a:6:{s:12:\"access_token\";s:68:\"973906762.M2E4MWE5Zg==.NDRkZTU5YjFkNmQwN.DQxM2I5NTYwZDc2NTk4Y2ZhZGU=\";s:7:\"user_id\";s:9:\"973906762\";s:8:\"username\";s:12:\"travelite_ph\";s:8:\"is_valid\";b:1;s:12:\"last_checked\";i:1535477688;s:15:\"profile_picture\";s:132:\"https://scontent.cdninstagram.com/vp/e3212ec738a45d8568cb455672048439/5C1AFB29/t51.2885-19/10534980_684751634912422_2104182813_a.jpg\";}}}", "yes");
INSERT INTO `trvlite_options` VALUES("108932", "fbmsg_timeline", "true", "yes");
INSERT INTO `trvlite_options` VALUES("108923", "fbmsg_title", "Send us a message!", "yes");
INSERT INTO `trvlite_options` VALUES("108924", "fbmsg_page", "https://www.facebook.com/travelitephilippines/", "yes");
INSERT INTO `trvlite_options` VALUES("108925", "fbmsg_pos", "right", "yes");
INSERT INTO `trvlite_options` VALUES("108926", "fbmsg_version", "1.3", "yes");
INSERT INTO `trvlite_options` VALUES("108937", "fbmsg_events", "true", "yes");
INSERT INTO `trvlite_options` VALUES("125221", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("125222", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("125223", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("125224", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("125225", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("130999", "redux-framework-tracking", "a:3:{s:8:\"dev_mode\";b:0;s:4:\"hash\";s:32:\"d36a5c3b875ad1245374cbd202f4cfb9\";s:14:\"allow_tracking\";s:2:\"no\";}", "yes");
INSERT INTO `trvlite_options` VALUES("131000", "um_version", "2.0.20", "yes");
INSERT INTO `trvlite_options` VALUES("131001", "um_cache_fonticons", "a:1218:{i:0;s:13:\"um-icon-alert\";i:1;s:21:\"um-icon-alert-circled\";i:2;s:19:\"um-icon-android-add\";i:3;s:26:\"um-icon-android-add-circle\";i:4;s:27:\"um-icon-android-alarm-clock\";i:5;s:21:\"um-icon-android-alert\";i:6;s:20:\"um-icon-android-apps\";i:7;s:23:\"um-icon-android-archive\";i:8;s:26:\"um-icon-android-arrow-back\";i:9;s:26:\"um-icon-android-arrow-down\";i:10;s:30:\"um-icon-android-arrow-dropdown\";i:11;s:37:\"um-icon-android-arrow-dropdown-circle\";i:12;s:30:\"um-icon-android-arrow-dropleft\";i:13;s:37:\"um-icon-android-arrow-dropleft-circle\";i:14;s:31:\"um-icon-android-arrow-dropright\";i:15;s:38:\"um-icon-android-arrow-dropright-circle\";i:16;s:28:\"um-icon-android-arrow-dropup\";i:17;s:35:\"um-icon-android-arrow-dropup-circle\";i:18;s:29:\"um-icon-android-arrow-forward\";i:19;s:24:\"um-icon-android-arrow-up\";i:20;s:22:\"um-icon-android-attach\";i:21;s:19:\"um-icon-android-bar\";i:22;s:23:\"um-icon-android-bicycle\";i:23;s:20:\"um-icon-android-boat\";i:24;s:24:\"um-icon-android-bookmark\";i:25;s:20:\"um-icon-android-bulb\";i:26;s:19:\"um-icon-android-bus\";i:27;s:24:\"um-icon-android-calendar\";i:28;s:20:\"um-icon-android-call\";i:29;s:22:\"um-icon-android-camera\";i:30;s:22:\"um-icon-android-cancel\";i:31;s:19:\"um-icon-android-car\";i:32;s:20:\"um-icon-android-cart\";i:33;s:20:\"um-icon-android-chat\";i:34;s:24:\"um-icon-android-checkbox\";i:35;s:30:\"um-icon-android-checkbox-blank\";i:36;s:32:\"um-icon-android-checkbox-outline\";i:37;s:38:\"um-icon-android-checkbox-outline-blank\";i:38;s:32:\"um-icon-android-checkmark-circle\";i:39;s:25:\"um-icon-android-clipboard\";i:40;s:21:\"um-icon-android-close\";i:41;s:21:\"um-icon-android-cloud\";i:42;s:28:\"um-icon-android-cloud-circle\";i:43;s:26:\"um-icon-android-cloud-done\";i:44;s:29:\"um-icon-android-cloud-outline\";i:45;s:29:\"um-icon-android-color-palette\";i:46;s:23:\"um-icon-android-compass\";i:47;s:23:\"um-icon-android-contact\";i:48;s:24:\"um-icon-android-contacts\";i:49;s:24:\"um-icon-android-contract\";i:50;s:22:\"um-icon-android-create\";i:51;s:22:\"um-icon-android-delete\";i:52;s:23:\"um-icon-android-desktop\";i:53;s:24:\"um-icon-android-document\";i:54;s:20:\"um-icon-android-done\";i:55;s:24:\"um-icon-android-done-all\";i:56;s:24:\"um-icon-android-download\";i:57;s:22:\"um-icon-android-drafts\";i:58;s:20:\"um-icon-android-exit\";i:59;s:22:\"um-icon-android-expand\";i:60;s:24:\"um-icon-android-favorite\";i:61;s:32:\"um-icon-android-favorite-outline\";i:62;s:20:\"um-icon-android-film\";i:63;s:22:\"um-icon-android-folder\";i:64;s:27:\"um-icon-android-folder-open\";i:65;s:22:\"um-icon-android-funnel\";i:66;s:21:\"um-icon-android-globe\";i:67;s:20:\"um-icon-android-hand\";i:68;s:23:\"um-icon-android-hangout\";i:69;s:21:\"um-icon-android-happy\";i:70;s:20:\"um-icon-android-home\";i:71;s:21:\"um-icon-android-image\";i:72;s:22:\"um-icon-android-laptop\";i:73;s:20:\"um-icon-android-list\";i:74;s:22:\"um-icon-android-locate\";i:75;s:20:\"um-icon-android-lock\";i:76;s:20:\"um-icon-android-mail\";i:77;s:19:\"um-icon-android-map\";i:78;s:20:\"um-icon-android-menu\";i:79;s:26:\"um-icon-android-microphone\";i:80;s:30:\"um-icon-android-microphone-off\";i:81;s:31:\"um-icon-android-more-horizontal\";i:82;s:29:\"um-icon-android-more-vertical\";i:83;s:24:\"um-icon-android-navigate\";i:84;s:29:\"um-icon-android-notifications\";i:85;s:34:\"um-icon-android-notifications-none\";i:86;s:33:\"um-icon-android-notifications-off\";i:87;s:20:\"um-icon-android-open\";i:88;s:23:\"um-icon-android-options\";i:89;s:22:\"um-icon-android-people\";i:90;s:22:\"um-icon-android-person\";i:91;s:26:\"um-icon-android-person-add\";i:92;s:31:\"um-icon-android-phone-landscape\";i:93;s:30:\"um-icon-android-phone-portrait\";i:94;s:19:\"um-icon-android-pin\";i:95;s:21:\"um-icon-android-plane\";i:96;s:25:\"um-icon-android-playstore\";i:97;s:21:\"um-icon-android-print\";i:98;s:32:\"um-icon-android-radio-button-off\";i:99;s:31:\"um-icon-android-radio-button-on\";i:100;s:23:\"um-icon-android-refresh\";i:101;s:22:\"um-icon-android-remove\";i:102;s:29:\"um-icon-android-remove-circle\";i:103;s:26:\"um-icon-android-restaurant\";i:104;s:19:\"um-icon-android-sad\";i:105;s:22:\"um-icon-android-search\";i:106;s:20:\"um-icon-android-send\";i:107;s:24:\"um-icon-android-settings\";i:108;s:21:\"um-icon-android-share\";i:109;s:25:\"um-icon-android-share-alt\";i:110;s:20:\"um-icon-android-star\";i:111;s:25:\"um-icon-android-star-half\";i:112;s:28:\"um-icon-android-star-outline\";i:113;s:25:\"um-icon-android-stopwatch\";i:114;s:22:\"um-icon-android-subway\";i:115;s:21:\"um-icon-android-sunny\";i:116;s:20:\"um-icon-android-sync\";i:117;s:23:\"um-icon-android-textsms\";i:118;s:20:\"um-icon-android-time\";i:119;s:21:\"um-icon-android-train\";i:120;s:22:\"um-icon-android-unlock\";i:121;s:22:\"um-icon-android-upload\";i:122;s:27:\"um-icon-android-volume-down\";i:123;s:27:\"um-icon-android-volume-mute\";i:124;s:26:\"um-icon-android-volume-off\";i:125;s:25:\"um-icon-android-volume-up\";i:126;s:20:\"um-icon-android-walk\";i:127;s:23:\"um-icon-android-warning\";i:128;s:21:\"um-icon-android-watch\";i:129;s:20:\"um-icon-android-wifi\";i:130;s:16:\"um-icon-aperture\";i:131;s:15:\"um-icon-archive\";i:132;s:20:\"um-icon-arrow-down-a\";i:133;s:20:\"um-icon-arrow-down-b\";i:134;s:20:\"um-icon-arrow-down-c\";i:135;s:20:\"um-icon-arrow-expand\";i:136;s:29:\"um-icon-arrow-graph-down-left\";i:137;s:30:\"um-icon-arrow-graph-down-right\";i:138;s:27:\"um-icon-arrow-graph-up-left\";i:139;s:28:\"um-icon-arrow-graph-up-right\";i:140;s:20:\"um-icon-arrow-left-a\";i:141;s:20:\"um-icon-arrow-left-b\";i:142;s:20:\"um-icon-arrow-left-c\";i:143;s:18:\"um-icon-arrow-move\";i:144;s:20:\"um-icon-arrow-resize\";i:145;s:25:\"um-icon-arrow-return-left\";i:146;s:26:\"um-icon-arrow-return-right\";i:147;s:21:\"um-icon-arrow-right-a\";i:148;s:21:\"um-icon-arrow-right-b\";i:149;s:21:\"um-icon-arrow-right-c\";i:150;s:20:\"um-icon-arrow-shrink\";i:151;s:18:\"um-icon-arrow-swap\";i:152;s:18:\"um-icon-arrow-up-a\";i:153;s:18:\"um-icon-arrow-up-b\";i:154;s:18:\"um-icon-arrow-up-c\";i:155;s:16:\"um-icon-asterisk\";i:156;s:10:\"um-icon-at\";i:157;s:17:\"um-icon-backspace\";i:158;s:25:\"um-icon-backspace-outline\";i:159;s:11:\"um-icon-bag\";i:160;s:24:\"um-icon-battery-charging\";i:161;s:21:\"um-icon-battery-empty\";i:162;s:20:\"um-icon-battery-full\";i:163;s:20:\"um-icon-battery-half\";i:164;s:19:\"um-icon-battery-low\";i:165;s:14:\"um-icon-beaker\";i:166;s:12:\"um-icon-beer\";i:167;s:17:\"um-icon-bluetooth\";i:168;s:15:\"um-icon-bonfire\";i:169;s:16:\"um-icon-bookmark\";i:170;s:14:\"um-icon-bowtie\";i:171;s:17:\"um-icon-briefcase\";i:172;s:11:\"um-icon-bug\";i:173;s:18:\"um-icon-calculator\";i:174;s:16:\"um-icon-calendar\";i:175;s:14:\"um-icon-camera\";i:176;s:12:\"um-icon-card\";i:177;s:12:\"um-icon-cash\";i:178;s:15:\"um-icon-chatbox\";i:179;s:23:\"um-icon-chatbox-working\";i:180;s:17:\"um-icon-chatboxes\";i:181;s:18:\"um-icon-chatbubble\";i:182;s:26:\"um-icon-chatbubble-working\";i:183;s:19:\"um-icon-chatbubbles\";i:184;s:17:\"um-icon-checkmark\";i:185;s:25:\"um-icon-checkmark-circled\";i:186;s:23:\"um-icon-checkmark-round\";i:187;s:20:\"um-icon-chevron-down\";i:188;s:20:\"um-icon-chevron-left\";i:189;s:21:\"um-icon-chevron-right\";i:190;s:18:\"um-icon-chevron-up\";i:191;s:17:\"um-icon-clipboard\";i:192;s:13:\"um-icon-clock\";i:193;s:13:\"um-icon-close\";i:194;s:21:\"um-icon-close-circled\";i:195;s:19:\"um-icon-close-round\";i:196;s:25:\"um-icon-closed-captioning\";i:197;s:13:\"um-icon-cloud\";i:198;s:12:\"um-icon-code\";i:199;s:21:\"um-icon-code-download\";i:200;s:20:\"um-icon-code-working\";i:201;s:14:\"um-icon-coffee\";i:202;s:15:\"um-icon-compass\";i:203;s:15:\"um-icon-compose\";i:204;s:23:\"um-icon-connection-bars\";i:205;s:16:\"um-icon-contrast\";i:206;s:12:\"um-icon-crop\";i:207;s:12:\"um-icon-cube\";i:208;s:12:\"um-icon-disc\";i:209;s:16:\"um-icon-document\";i:210;s:21:\"um-icon-document-text\";i:211;s:12:\"um-icon-drag\";i:212;s:13:\"um-icon-earth\";i:213;s:13:\"um-icon-easel\";i:214;s:12:\"um-icon-edit\";i:215;s:11:\"um-icon-egg\";i:216;s:13:\"um-icon-eject\";i:217;s:13:\"um-icon-email\";i:218;s:20:\"um-icon-email-unread\";i:219;s:24:\"um-icon-erlenmeyer-flask\";i:220;s:32:\"um-icon-erlenmeyer-flask-bubbles\";i:221;s:11:\"um-icon-eye\";i:222;s:20:\"um-icon-eye-disabled\";i:223;s:14:\"um-icon-female\";i:224;s:14:\"um-icon-filing\";i:225;s:19:\"um-icon-film-marker\";i:226;s:16:\"um-icon-fireball\";i:227;s:12:\"um-icon-flag\";i:228;s:13:\"um-icon-flame\";i:229;s:13:\"um-icon-flash\";i:230;s:17:\"um-icon-flash-off\";i:231;s:14:\"um-icon-folder\";i:232;s:12:\"um-icon-fork\";i:233;s:17:\"um-icon-fork-repo\";i:234;s:15:\"um-icon-forward\";i:235;s:14:\"um-icon-funnel\";i:236;s:14:\"um-icon-gear-a\";i:237;s:14:\"um-icon-gear-b\";i:238;s:12:\"um-icon-grid\";i:239;s:14:\"um-icon-hammer\";i:240;s:13:\"um-icon-happy\";i:241;s:21:\"um-icon-happy-outline\";i:242;s:17:\"um-icon-headphone\";i:243;s:13:\"um-icon-heart\";i:244;s:20:\"um-icon-heart-broken\";i:245;s:12:\"um-icon-help\";i:246;s:17:\"um-icon-help-buoy\";i:247;s:20:\"um-icon-help-circled\";i:248;s:12:\"um-icon-home\";i:249;s:16:\"um-icon-icecream\";i:250;s:13:\"um-icon-image\";i:251;s:14:\"um-icon-images\";i:252;s:19:\"um-icon-information\";i:253;s:27:\"um-icon-information-circled\";i:254;s:13:\"um-icon-ionic\";i:255;s:17:\"um-icon-ios-alarm\";i:256;s:25:\"um-icon-ios-alarm-outline\";i:257;s:18:\"um-icon-ios-albums\";i:258;s:26:\"um-icon-ios-albums-outline\";i:259;s:28:\"um-icon-ios-americanfootball\";i:260;s:36:\"um-icon-ios-americanfootball-outline\";i:261;s:21:\"um-icon-ios-analytics\";i:262;s:29:\"um-icon-ios-analytics-outline\";i:263;s:22:\"um-icon-ios-arrow-back\";i:264;s:22:\"um-icon-ios-arrow-down\";i:265;s:25:\"um-icon-ios-arrow-forward\";i:266;s:22:\"um-icon-ios-arrow-left\";i:267;s:23:\"um-icon-ios-arrow-right\";i:268;s:27:\"um-icon-ios-arrow-thin-down\";i:269;s:27:\"um-icon-ios-arrow-thin-left\";i:270;s:28:\"um-icon-ios-arrow-thin-right\";i:271;s:25:\"um-icon-ios-arrow-thin-up\";i:272;s:20:\"um-icon-ios-arrow-up\";i:273;s:14:\"um-icon-ios-at\";i:274;s:22:\"um-icon-ios-at-outline\";i:275;s:19:\"um-icon-ios-barcode\";i:276;s:27:\"um-icon-ios-barcode-outline\";i:277;s:20:\"um-icon-ios-baseball\";i:278;s:28:\"um-icon-ios-baseball-outline\";i:279;s:22:\"um-icon-ios-basketball\";i:280;s:30:\"um-icon-ios-basketball-outline\";i:281;s:16:\"um-icon-ios-bell\";i:282;s:24:\"um-icon-ios-bell-outline\";i:283;s:16:\"um-icon-ios-body\";i:284;s:24:\"um-icon-ios-body-outline\";i:285;s:16:\"um-icon-ios-bolt\";i:286;s:24:\"um-icon-ios-bolt-outline\";i:287;s:16:\"um-icon-ios-book\";i:288;s:24:\"um-icon-ios-book-outline\";i:289;s:21:\"um-icon-ios-bookmarks\";i:290;s:29:\"um-icon-ios-bookmarks-outline\";i:291;s:15:\"um-icon-ios-box\";i:292;s:23:\"um-icon-ios-box-outline\";i:293;s:21:\"um-icon-ios-briefcase\";i:294;s:29:\"um-icon-ios-briefcase-outline\";i:295;s:20:\"um-icon-ios-browsers\";i:296;s:28:\"um-icon-ios-browsers-outline\";i:297;s:22:\"um-icon-ios-calculator\";i:298;s:30:\"um-icon-ios-calculator-outline\";i:299;s:20:\"um-icon-ios-calendar\";i:300;s:28:\"um-icon-ios-calendar-outline\";i:301;s:18:\"um-icon-ios-camera\";i:302;s:26:\"um-icon-ios-camera-outline\";i:303;s:16:\"um-icon-ios-cart\";i:304;s:24:\"um-icon-ios-cart-outline\";i:305;s:21:\"um-icon-ios-chatboxes\";i:306;s:29:\"um-icon-ios-chatboxes-outline\";i:307;s:22:\"um-icon-ios-chatbubble\";i:308;s:30:\"um-icon-ios-chatbubble-outline\";i:309;s:21:\"um-icon-ios-checkmark\";i:310;s:27:\"um-icon-ios-checkmark-empty\";i:311;s:29:\"um-icon-ios-checkmark-outline\";i:312;s:25:\"um-icon-ios-circle-filled\";i:313;s:26:\"um-icon-ios-circle-outline\";i:314;s:17:\"um-icon-ios-clock\";i:315;s:25:\"um-icon-ios-clock-outline\";i:316;s:17:\"um-icon-ios-close\";i:317;s:23:\"um-icon-ios-close-empty\";i:318;s:25:\"um-icon-ios-close-outline\";i:319;s:17:\"um-icon-ios-cloud\";i:320;s:26:\"um-icon-ios-cloud-download\";i:321;s:34:\"um-icon-ios-cloud-download-outline\";i:322;s:25:\"um-icon-ios-cloud-outline\";i:323;s:24:\"um-icon-ios-cloud-upload\";i:324;s:32:\"um-icon-ios-cloud-upload-outline\";i:325;s:18:\"um-icon-ios-cloudy\";i:326;s:24:\"um-icon-ios-cloudy-night\";i:327;s:32:\"um-icon-ios-cloudy-night-outline\";i:328;s:26:\"um-icon-ios-cloudy-outline\";i:329;s:15:\"um-icon-ios-cog\";i:330;s:23:\"um-icon-ios-cog-outline\";i:331;s:24:\"um-icon-ios-color-filter\";i:332;s:32:\"um-icon-ios-color-filter-outline\";i:333;s:22:\"um-icon-ios-color-wand\";i:334;s:30:\"um-icon-ios-color-wand-outline\";i:335;s:19:\"um-icon-ios-compose\";i:336;s:27:\"um-icon-ios-compose-outline\";i:337;s:19:\"um-icon-ios-contact\";i:338;s:27:\"um-icon-ios-contact-outline\";i:339;s:16:\"um-icon-ios-copy\";i:340;s:24:\"um-icon-ios-copy-outline\";i:341;s:16:\"um-icon-ios-crop\";i:342;s:23:\"um-icon-ios-crop-strong\";i:343;s:20:\"um-icon-ios-download\";i:344;s:28:\"um-icon-ios-download-outline\";i:345;s:16:\"um-icon-ios-drag\";i:346;s:17:\"um-icon-ios-email\";i:347;s:25:\"um-icon-ios-email-outline\";i:348;s:15:\"um-icon-ios-eye\";i:349;s:23:\"um-icon-ios-eye-outline\";i:350;s:23:\"um-icon-ios-fastforward\";i:351;s:31:\"um-icon-ios-fastforward-outline\";i:352;s:18:\"um-icon-ios-filing\";i:353;s:26:\"um-icon-ios-filing-outline\";i:354;s:16:\"um-icon-ios-film\";i:355;s:24:\"um-icon-ios-film-outline\";i:356;s:16:\"um-icon-ios-flag\";i:357;s:24:\"um-icon-ios-flag-outline\";i:358;s:17:\"um-icon-ios-flame\";i:359;s:25:\"um-icon-ios-flame-outline\";i:360;s:17:\"um-icon-ios-flask\";i:361;s:25:\"um-icon-ios-flask-outline\";i:362;s:18:\"um-icon-ios-flower\";i:363;s:26:\"um-icon-ios-flower-outline\";i:364;s:18:\"um-icon-ios-folder\";i:365;s:26:\"um-icon-ios-folder-outline\";i:366;s:20:\"um-icon-ios-football\";i:367;s:28:\"um-icon-ios-football-outline\";i:368;s:29:\"um-icon-ios-game-controller-a\";i:369;s:37:\"um-icon-ios-game-controller-a-outline\";i:370;s:29:\"um-icon-ios-game-controller-b\";i:371;s:37:\"um-icon-ios-game-controller-b-outline\";i:372;s:16:\"um-icon-ios-gear\";i:373;s:24:\"um-icon-ios-gear-outline\";i:374;s:19:\"um-icon-ios-glasses\";i:375;s:27:\"um-icon-ios-glasses-outline\";i:376;s:21:\"um-icon-ios-grid-view\";i:377;s:29:\"um-icon-ios-grid-view-outline\";i:378;s:17:\"um-icon-ios-heart\";i:379;s:25:\"um-icon-ios-heart-outline\";i:380;s:16:\"um-icon-ios-help\";i:381;s:22:\"um-icon-ios-help-empty\";i:382;s:24:\"um-icon-ios-help-outline\";i:383;s:16:\"um-icon-ios-home\";i:384;s:24:\"um-icon-ios-home-outline\";i:385;s:20:\"um-icon-ios-infinite\";i:386;s:28:\"um-icon-ios-infinite-outline\";i:387;s:23:\"um-icon-ios-information\";i:388;s:29:\"um-icon-ios-information-empty\";i:389;s:31:\"um-icon-ios-information-outline\";i:390;s:25:\"um-icon-ios-ionic-outline\";i:391;s:18:\"um-icon-ios-keypad\";i:392;s:26:\"um-icon-ios-keypad-outline\";i:393;s:21:\"um-icon-ios-lightbulb\";i:394;s:29:\"um-icon-ios-lightbulb-outline\";i:395;s:16:\"um-icon-ios-list\";i:396;s:24:\"um-icon-ios-list-outline\";i:397;s:20:\"um-icon-ios-location\";i:398;s:28:\"um-icon-ios-location-outline\";i:399;s:18:\"um-icon-ios-locked\";i:400;s:26:\"um-icon-ios-locked-outline\";i:401;s:16:\"um-icon-ios-loop\";i:402;s:23:\"um-icon-ios-loop-strong\";i:403;s:19:\"um-icon-ios-medical\";i:404;s:27:\"um-icon-ios-medical-outline\";i:405;s:18:\"um-icon-ios-medkit\";i:406;s:26:\"um-icon-ios-medkit-outline\";i:407;s:15:\"um-icon-ios-mic\";i:408;s:19:\"um-icon-ios-mic-off\";i:409;s:23:\"um-icon-ios-mic-outline\";i:410;s:17:\"um-icon-ios-minus\";i:411;s:23:\"um-icon-ios-minus-empty\";i:412;s:25:\"um-icon-ios-minus-outline\";i:413;s:19:\"um-icon-ios-monitor\";i:414;s:27:\"um-icon-ios-monitor-outline\";i:415;s:16:\"um-icon-ios-moon\";i:416;s:24:\"um-icon-ios-moon-outline\";i:417;s:16:\"um-icon-ios-more\";i:418;s:24:\"um-icon-ios-more-outline\";i:419;s:24:\"um-icon-ios-musical-note\";i:420;s:25:\"um-icon-ios-musical-notes\";i:421;s:20:\"um-icon-ios-navigate\";i:422;s:28:\"um-icon-ios-navigate-outline\";i:423;s:21:\"um-icon-ios-nutrition\";i:424;s:29:\"um-icon-ios-nutrition-outline\";i:425;s:17:\"um-icon-ios-paper\";i:426;s:25:\"um-icon-ios-paper-outline\";i:427;s:22:\"um-icon-ios-paperplane\";i:428;s:30:\"um-icon-ios-paperplane-outline\";i:429;s:23:\"um-icon-ios-partlysunny\";i:430;s:31:\"um-icon-ios-partlysunny-outline\";i:431;s:17:\"um-icon-ios-pause\";i:432;s:25:\"um-icon-ios-pause-outline\";i:433;s:15:\"um-icon-ios-paw\";i:434;s:23:\"um-icon-ios-paw-outline\";i:435;s:18:\"um-icon-ios-people\";i:436;s:26:\"um-icon-ios-people-outline\";i:437;s:18:\"um-icon-ios-person\";i:438;s:26:\"um-icon-ios-person-outline\";i:439;s:21:\"um-icon-ios-personadd\";i:440;s:29:\"um-icon-ios-personadd-outline\";i:441;s:18:\"um-icon-ios-photos\";i:442;s:26:\"um-icon-ios-photos-outline\";i:443;s:15:\"um-icon-ios-pie\";i:444;s:23:\"um-icon-ios-pie-outline\";i:445;s:16:\"um-icon-ios-pint\";i:446;s:24:\"um-icon-ios-pint-outline\";i:447;s:16:\"um-icon-ios-play\";i:448;s:24:\"um-icon-ios-play-outline\";i:449;s:16:\"um-icon-ios-plus\";i:450;s:22:\"um-icon-ios-plus-empty\";i:451;s:24:\"um-icon-ios-plus-outline\";i:452;s:20:\"um-icon-ios-pricetag\";i:453;s:28:\"um-icon-ios-pricetag-outline\";i:454;s:21:\"um-icon-ios-pricetags\";i:455;s:29:\"um-icon-ios-pricetags-outline\";i:456;s:19:\"um-icon-ios-printer\";i:457;s:27:\"um-icon-ios-printer-outline\";i:458;s:17:\"um-icon-ios-pulse\";i:459;s:24:\"um-icon-ios-pulse-strong\";i:460;s:17:\"um-icon-ios-rainy\";i:461;s:25:\"um-icon-ios-rainy-outline\";i:462;s:21:\"um-icon-ios-recording\";i:463;s:29:\"um-icon-ios-recording-outline\";i:464;s:16:\"um-icon-ios-redo\";i:465;s:24:\"um-icon-ios-redo-outline\";i:466;s:19:\"um-icon-ios-refresh\";i:467;s:25:\"um-icon-ios-refresh-empty\";i:468;s:27:\"um-icon-ios-refresh-outline\";i:469;s:18:\"um-icon-ios-reload\";i:470;s:26:\"um-icon-ios-reverse-camera\";i:471;s:34:\"um-icon-ios-reverse-camera-outline\";i:472;s:18:\"um-icon-ios-rewind\";i:473;s:26:\"um-icon-ios-rewind-outline\";i:474;s:16:\"um-icon-ios-rose\";i:475;s:24:\"um-icon-ios-rose-outline\";i:476;s:18:\"um-icon-ios-search\";i:477;s:25:\"um-icon-ios-search-strong\";i:478;s:20:\"um-icon-ios-settings\";i:479;s:27:\"um-icon-ios-settings-strong\";i:480;s:19:\"um-icon-ios-shuffle\";i:481;s:26:\"um-icon-ios-shuffle-strong\";i:482;s:24:\"um-icon-ios-skipbackward\";i:483;s:32:\"um-icon-ios-skipbackward-outline\";i:484;s:23:\"um-icon-ios-skipforward\";i:485;s:31:\"um-icon-ios-skipforward-outline\";i:486;s:17:\"um-icon-ios-snowy\";i:487;s:23:\"um-icon-ios-speedometer\";i:488;s:31:\"um-icon-ios-speedometer-outline\";i:489;s:16:\"um-icon-ios-star\";i:490;s:21:\"um-icon-ios-star-half\";i:491;s:24:\"um-icon-ios-star-outline\";i:492;s:21:\"um-icon-ios-stopwatch\";i:493;s:29:\"um-icon-ios-stopwatch-outline\";i:494;s:17:\"um-icon-ios-sunny\";i:495;s:25:\"um-icon-ios-sunny-outline\";i:496;s:21:\"um-icon-ios-telephone\";i:497;s:29:\"um-icon-ios-telephone-outline\";i:498;s:22:\"um-icon-ios-tennisball\";i:499;s:30:\"um-icon-ios-tennisball-outline\";i:500;s:24:\"um-icon-ios-thunderstorm\";i:501;s:32:\"um-icon-ios-thunderstorm-outline\";i:502;s:16:\"um-icon-ios-time\";i:503;s:24:\"um-icon-ios-time-outline\";i:504;s:17:\"um-icon-ios-timer\";i:505;s:25:\"um-icon-ios-timer-outline\";i:506;s:18:\"um-icon-ios-toggle\";i:507;s:26:\"um-icon-ios-toggle-outline\";i:508;s:17:\"um-icon-ios-trash\";i:509;s:25:\"um-icon-ios-trash-outline\";i:510;s:16:\"um-icon-ios-undo\";i:511;s:24:\"um-icon-ios-undo-outline\";i:512;s:20:\"um-icon-ios-unlocked\";i:513;s:28:\"um-icon-ios-unlocked-outline\";i:514;s:18:\"um-icon-ios-upload\";i:515;s:26:\"um-icon-ios-upload-outline\";i:516;s:20:\"um-icon-ios-videocam\";i:517;s:28:\"um-icon-ios-videocam-outline\";i:518;s:23:\"um-icon-ios-volume-high\";i:519;s:22:\"um-icon-ios-volume-low\";i:520;s:21:\"um-icon-ios-wineglass\";i:521;s:29:\"um-icon-ios-wineglass-outline\";i:522;s:17:\"um-icon-ios-world\";i:523;s:25:\"um-icon-ios-world-outline\";i:524;s:12:\"um-icon-ipad\";i:525;s:14:\"um-icon-iphone\";i:526;s:12:\"um-icon-ipod\";i:527;s:11:\"um-icon-jet\";i:528;s:11:\"um-icon-key\";i:529;s:13:\"um-icon-knife\";i:530;s:14:\"um-icon-laptop\";i:531;s:12:\"um-icon-leaf\";i:532;s:14:\"um-icon-levels\";i:533;s:17:\"um-icon-lightbulb\";i:534;s:12:\"um-icon-link\";i:535;s:14:\"um-icon-load-a\";i:536;s:14:\"um-icon-load-b\";i:537;s:14:\"um-icon-load-c\";i:538;s:14:\"um-icon-load-d\";i:539;s:16:\"um-icon-location\";i:540;s:24:\"um-icon-lock-combination\";i:541;s:14:\"um-icon-locked\";i:542;s:14:\"um-icon-log-in\";i:543;s:15:\"um-icon-log-out\";i:544;s:12:\"um-icon-loop\";i:545;s:14:\"um-icon-magnet\";i:546;s:12:\"um-icon-male\";i:547;s:11:\"um-icon-man\";i:548;s:11:\"um-icon-map\";i:549;s:14:\"um-icon-medkit\";i:550;s:13:\"um-icon-merge\";i:551;s:13:\"um-icon-mic-a\";i:552;s:13:\"um-icon-mic-b\";i:553;s:13:\"um-icon-mic-c\";i:554;s:13:\"um-icon-minus\";i:555;s:21:\"um-icon-minus-circled\";i:556;s:19:\"um-icon-minus-round\";i:557;s:15:\"um-icon-model-s\";i:558;s:15:\"um-icon-monitor\";i:559;s:12:\"um-icon-more\";i:560;s:13:\"um-icon-mouse\";i:561;s:18:\"um-icon-music-note\";i:562;s:15:\"um-icon-navicon\";i:563;s:21:\"um-icon-navicon-round\";i:564;s:16:\"um-icon-navigate\";i:565;s:15:\"um-icon-network\";i:566;s:18:\"um-icon-no-smoking\";i:567;s:15:\"um-icon-nuclear\";i:568;s:14:\"um-icon-outlet\";i:569;s:18:\"um-icon-paintbrush\";i:570;s:19:\"um-icon-paintbucket\";i:571;s:22:\"um-icon-paper-airplane\";i:572;s:17:\"um-icon-paperclip\";i:573;s:13:\"um-icon-pause\";i:574;s:14:\"um-icon-person\";i:575;s:18:\"um-icon-person-add\";i:576;s:22:\"um-icon-person-stalker\";i:577;s:17:\"um-icon-pie-graph\";i:578;s:11:\"um-icon-pin\";i:579;s:16:\"um-icon-pinpoint\";i:580;s:13:\"um-icon-pizza\";i:581;s:13:\"um-icon-plane\";i:582;s:14:\"um-icon-planet\";i:583;s:12:\"um-icon-play\";i:584;s:19:\"um-icon-playstation\";i:585;s:12:\"um-icon-plus\";i:586;s:20:\"um-icon-plus-circled\";i:587;s:18:\"um-icon-plus-round\";i:588;s:14:\"um-icon-podium\";i:589;s:13:\"um-icon-pound\";i:590;s:13:\"um-icon-power\";i:591;s:16:\"um-icon-pricetag\";i:592;s:17:\"um-icon-pricetags\";i:593;s:15:\"um-icon-printer\";i:594;s:20:\"um-icon-pull-request\";i:595;s:18:\"um-icon-qr-scanner\";i:596;s:13:\"um-icon-quote\";i:597;s:19:\"um-icon-radio-waves\";i:598;s:14:\"um-icon-record\";i:599;s:15:\"um-icon-refresh\";i:600;s:13:\"um-icon-reply\";i:601;s:17:\"um-icon-reply-all\";i:602;s:16:\"um-icon-ribbon-a\";i:603;s:16:\"um-icon-ribbon-b\";i:604;s:11:\"um-icon-sad\";i:605;s:19:\"um-icon-sad-outline\";i:606;s:16:\"um-icon-scissors\";i:607;s:14:\"um-icon-search\";i:608;s:16:\"um-icon-settings\";i:609;s:13:\"um-icon-share\";i:610;s:15:\"um-icon-shuffle\";i:611;s:21:\"um-icon-skip-backward\";i:612;s:20:\"um-icon-skip-forward\";i:613;s:22:\"um-icon-social-android\";i:614;s:30:\"um-icon-social-android-outline\";i:615;s:22:\"um-icon-social-angular\";i:616;s:30:\"um-icon-social-angular-outline\";i:617;s:20:\"um-icon-social-apple\";i:618;s:28:\"um-icon-social-apple-outline\";i:619;s:22:\"um-icon-social-bitcoin\";i:620;s:30:\"um-icon-social-bitcoin-outline\";i:621;s:21:\"um-icon-social-buffer\";i:622;s:29:\"um-icon-social-buffer-outline\";i:623;s:21:\"um-icon-social-chrome\";i:624;s:29:\"um-icon-social-chrome-outline\";i:625;s:22:\"um-icon-social-codepen\";i:626;s:30:\"um-icon-social-codepen-outline\";i:627;s:19:\"um-icon-social-css3\";i:628;s:27:\"um-icon-social-css3-outline\";i:629;s:27:\"um-icon-social-designernews\";i:630;s:35:\"um-icon-social-designernews-outline\";i:631;s:23:\"um-icon-social-dribbble\";i:632;s:31:\"um-icon-social-dribbble-outline\";i:633;s:22:\"um-icon-social-dropbox\";i:634;s:30:\"um-icon-social-dropbox-outline\";i:635;s:19:\"um-icon-social-euro\";i:636;s:27:\"um-icon-social-euro-outline\";i:637;s:23:\"um-icon-social-facebook\";i:638;s:31:\"um-icon-social-facebook-outline\";i:639;s:25:\"um-icon-social-foursquare\";i:640;s:33:\"um-icon-social-foursquare-outline\";i:641;s:28:\"um-icon-social-freebsd-devil\";i:642;s:21:\"um-icon-social-github\";i:643;s:29:\"um-icon-social-github-outline\";i:644;s:21:\"um-icon-social-google\";i:645;s:29:\"um-icon-social-google-outline\";i:646;s:25:\"um-icon-social-googleplus\";i:647;s:33:\"um-icon-social-googleplus-outline\";i:648;s:25:\"um-icon-social-hackernews\";i:649;s:33:\"um-icon-social-hackernews-outline\";i:650;s:20:\"um-icon-social-html5\";i:651;s:28:\"um-icon-social-html5-outline\";i:652;s:24:\"um-icon-social-instagram\";i:653;s:32:\"um-icon-social-instagram-outline\";i:654;s:25:\"um-icon-social-javascript\";i:655;s:33:\"um-icon-social-javascript-outline\";i:656;s:23:\"um-icon-social-linkedin\";i:657;s:31:\"um-icon-social-linkedin-outline\";i:658;s:23:\"um-icon-social-markdown\";i:659;s:21:\"um-icon-social-nodejs\";i:660;s:22:\"um-icon-social-octocat\";i:661;s:24:\"um-icon-social-pinterest\";i:662;s:32:\"um-icon-social-pinterest-outline\";i:663;s:21:\"um-icon-social-python\";i:664;s:21:\"um-icon-social-reddit\";i:665;s:29:\"um-icon-social-reddit-outline\";i:666;s:18:\"um-icon-social-rss\";i:667;s:26:\"um-icon-social-rss-outline\";i:668;s:19:\"um-icon-social-sass\";i:669;s:20:\"um-icon-social-skype\";i:670;s:28:\"um-icon-social-skype-outline\";i:671;s:23:\"um-icon-social-snapchat\";i:672;s:31:\"um-icon-social-snapchat-outline\";i:673;s:21:\"um-icon-social-tumblr\";i:674;s:29:\"um-icon-social-tumblr-outline\";i:675;s:18:\"um-icon-social-tux\";i:676;s:21:\"um-icon-social-twitch\";i:677;s:29:\"um-icon-social-twitch-outline\";i:678;s:22:\"um-icon-social-twitter\";i:679;s:30:\"um-icon-social-twitter-outline\";i:680;s:18:\"um-icon-social-usd\";i:681;s:26:\"um-icon-social-usd-outline\";i:682;s:20:\"um-icon-social-vimeo\";i:683;s:28:\"um-icon-social-vimeo-outline\";i:684;s:23:\"um-icon-social-whatsapp\";i:685;s:31:\"um-icon-social-whatsapp-outline\";i:686;s:22:\"um-icon-social-windows\";i:687;s:30:\"um-icon-social-windows-outline\";i:688;s:24:\"um-icon-social-wordpress\";i:689;s:32:\"um-icon-social-wordpress-outline\";i:690;s:20:\"um-icon-social-yahoo\";i:691;s:28:\"um-icon-social-yahoo-outline\";i:692;s:18:\"um-icon-social-yen\";i:693;s:26:\"um-icon-social-yen-outline\";i:694;s:22:\"um-icon-social-youtube\";i:695;s:30:\"um-icon-social-youtube-outline\";i:696;s:16:\"um-icon-soup-can\";i:697;s:24:\"um-icon-soup-can-outline\";i:698;s:20:\"um-icon-speakerphone\";i:699;s:19:\"um-icon-speedometer\";i:700;s:13:\"um-icon-spoon\";i:701;s:12:\"um-icon-star\";i:702;s:18:\"um-icon-stats-bars\";i:703;s:13:\"um-icon-steam\";i:704;s:12:\"um-icon-stop\";i:705;s:19:\"um-icon-thermometer\";i:706;s:18:\"um-icon-thumbsdown\";i:707;s:16:\"um-icon-thumbsup\";i:708;s:14:\"um-icon-toggle\";i:709;s:21:\"um-icon-toggle-filled\";i:710;s:19:\"um-icon-transgender\";i:711;s:15:\"um-icon-trash-a\";i:712;s:15:\"um-icon-trash-b\";i:713;s:14:\"um-icon-trophy\";i:714;s:14:\"um-icon-tshirt\";i:715;s:22:\"um-icon-tshirt-outline\";i:716;s:16:\"um-icon-umbrella\";i:717;s:18:\"um-icon-university\";i:718;s:16:\"um-icon-unlocked\";i:719;s:14:\"um-icon-upload\";i:720;s:11:\"um-icon-usb\";i:721;s:19:\"um-icon-videocamera\";i:722;s:19:\"um-icon-volume-high\";i:723;s:18:\"um-icon-volume-low\";i:724;s:21:\"um-icon-volume-medium\";i:725;s:19:\"um-icon-volume-mute\";i:726;s:12:\"um-icon-wand\";i:727;s:17:\"um-icon-waterdrop\";i:728;s:12:\"um-icon-wifi\";i:729;s:17:\"um-icon-wineglass\";i:730;s:13:\"um-icon-woman\";i:731;s:14:\"um-icon-wrench\";i:732;s:12:\"um-icon-xbox\";i:733;s:15:\"um-faicon-glass\";i:734;s:15:\"um-faicon-music\";i:735;s:16:\"um-faicon-search\";i:736;s:20:\"um-faicon-envelope-o\";i:737;s:15:\"um-faicon-heart\";i:738;s:14:\"um-faicon-star\";i:739;s:16:\"um-faicon-star-o\";i:740;s:14:\"um-faicon-user\";i:741;s:14:\"um-faicon-film\";i:742;s:18:\"um-faicon-th-large\";i:743;s:12:\"um-faicon-th\";i:744;s:17:\"um-faicon-th-list\";i:745;s:15:\"um-faicon-check\";i:746;s:15:\"um-faicon-times\";i:747;s:21:\"um-faicon-search-plus\";i:748;s:22:\"um-faicon-search-minus\";i:749;s:19:\"um-faicon-power-off\";i:750;s:16:\"um-faicon-signal\";i:751;s:13:\"um-faicon-cog\";i:752;s:17:\"um-faicon-trash-o\";i:753;s:14:\"um-faicon-home\";i:754;s:16:\"um-faicon-file-o\";i:755;s:17:\"um-faicon-clock-o\";i:756;s:14:\"um-faicon-road\";i:757;s:18:\"um-faicon-download\";i:758;s:29:\"um-faicon-arrow-circle-o-down\";i:759;s:27:\"um-faicon-arrow-circle-o-up\";i:760;s:15:\"um-faicon-inbox\";i:761;s:23:\"um-faicon-play-circle-o\";i:762;s:16:\"um-faicon-repeat\";i:763;s:17:\"um-faicon-refresh\";i:764;s:18:\"um-faicon-list-alt\";i:765;s:14:\"um-faicon-lock\";i:766;s:14:\"um-faicon-flag\";i:767;s:20:\"um-faicon-headphones\";i:768;s:20:\"um-faicon-volume-off\";i:769;s:21:\"um-faicon-volume-down\";i:770;s:19:\"um-faicon-volume-up\";i:771;s:16:\"um-faicon-qrcode\";i:772;s:17:\"um-faicon-barcode\";i:773;s:13:\"um-faicon-tag\";i:774;s:14:\"um-faicon-tags\";i:775;s:14:\"um-faicon-book\";i:776;s:18:\"um-faicon-bookmark\";i:777;s:15:\"um-faicon-print\";i:778;s:16:\"um-faicon-camera\";i:779;s:14:\"um-faicon-font\";i:780;s:14:\"um-faicon-bold\";i:781;s:16:\"um-faicon-italic\";i:782;s:21:\"um-faicon-text-height\";i:783;s:20:\"um-faicon-text-width\";i:784;s:20:\"um-faicon-align-left\";i:785;s:22:\"um-faicon-align-center\";i:786;s:21:\"um-faicon-align-right\";i:787;s:23:\"um-faicon-align-justify\";i:788;s:14:\"um-faicon-list\";i:789;s:17:\"um-faicon-outdent\";i:790;s:16:\"um-faicon-indent\";i:791;s:22:\"um-faicon-video-camera\";i:792;s:19:\"um-faicon-picture-o\";i:793;s:16:\"um-faicon-pencil\";i:794;s:20:\"um-faicon-map-marker\";i:795;s:16:\"um-faicon-adjust\";i:796;s:14:\"um-faicon-tint\";i:797;s:25:\"um-faicon-pencil-square-o\";i:798;s:24:\"um-faicon-share-square-o\";i:799;s:24:\"um-faicon-check-square-o\";i:800;s:16:\"um-faicon-arrows\";i:801;s:23:\"um-faicon-step-backward\";i:802;s:23:\"um-faicon-fast-backward\";i:803;s:18:\"um-faicon-backward\";i:804;s:14:\"um-faicon-play\";i:805;s:15:\"um-faicon-pause\";i:806;s:14:\"um-faicon-stop\";i:807;s:17:\"um-faicon-forward\";i:808;s:22:\"um-faicon-fast-forward\";i:809;s:22:\"um-faicon-step-forward\";i:810;s:15:\"um-faicon-eject\";i:811;s:22:\"um-faicon-chevron-left\";i:812;s:23:\"um-faicon-chevron-right\";i:813;s:21:\"um-faicon-plus-circle\";i:814;s:22:\"um-faicon-minus-circle\";i:815;s:22:\"um-faicon-times-circle\";i:816;s:22:\"um-faicon-check-circle\";i:817;s:25:\"um-faicon-question-circle\";i:818;s:21:\"um-faicon-info-circle\";i:819;s:20:\"um-faicon-crosshairs\";i:820;s:24:\"um-faicon-times-circle-o\";i:821;s:24:\"um-faicon-check-circle-o\";i:822;s:13:\"um-faicon-ban\";i:823;s:20:\"um-faicon-arrow-left\";i:824;s:21:\"um-faicon-arrow-right\";i:825;s:18:\"um-faicon-arrow-up\";i:826;s:20:\"um-faicon-arrow-down\";i:827;s:15:\"um-faicon-share\";i:828;s:16:\"um-faicon-expand\";i:829;s:18:\"um-faicon-compress\";i:830;s:14:\"um-faicon-plus\";i:831;s:15:\"um-faicon-minus\";i:832;s:18:\"um-faicon-asterisk\";i:833;s:28:\"um-faicon-exclamation-circle\";i:834;s:14:\"um-faicon-gift\";i:835;s:14:\"um-faicon-leaf\";i:836;s:14:\"um-faicon-fire\";i:837;s:13:\"um-faicon-eye\";i:838;s:19:\"um-faicon-eye-slash\";i:839;s:30:\"um-faicon-exclamation-triangle\";i:840;s:15:\"um-faicon-plane\";i:841;s:18:\"um-faicon-calendar\";i:842;s:16:\"um-faicon-random\";i:843;s:17:\"um-faicon-comment\";i:844;s:16:\"um-faicon-magnet\";i:845;s:20:\"um-faicon-chevron-up\";i:846;s:22:\"um-faicon-chevron-down\";i:847;s:17:\"um-faicon-retweet\";i:848;s:23:\"um-faicon-shopping-cart\";i:849;s:16:\"um-faicon-folder\";i:850;s:21:\"um-faicon-folder-open\";i:851;s:18:\"um-faicon-arrows-v\";i:852;s:18:\"um-faicon-arrows-h\";i:853;s:19:\"um-faicon-bar-chart\";i:854;s:24:\"um-faicon-twitter-square\";i:855;s:25:\"um-faicon-facebook-square\";i:856;s:22:\"um-faicon-camera-retro\";i:857;s:13:\"um-faicon-key\";i:858;s:14:\"um-faicon-cogs\";i:859;s:18:\"um-faicon-comments\";i:860;s:21:\"um-faicon-thumbs-o-up\";i:861;s:23:\"um-faicon-thumbs-o-down\";i:862;s:19:\"um-faicon-star-half\";i:863;s:17:\"um-faicon-heart-o\";i:864;s:18:\"um-faicon-sign-out\";i:865;s:25:\"um-faicon-linkedin-square\";i:866;s:20:\"um-faicon-thumb-tack\";i:867;s:23:\"um-faicon-external-link\";i:868;s:17:\"um-faicon-sign-in\";i:869;s:16:\"um-faicon-trophy\";i:870;s:23:\"um-faicon-github-square\";i:871;s:16:\"um-faicon-upload\";i:872;s:17:\"um-faicon-lemon-o\";i:873;s:15:\"um-faicon-phone\";i:874;s:18:\"um-faicon-square-o\";i:875;s:20:\"um-faicon-bookmark-o\";i:876;s:22:\"um-faicon-phone-square\";i:877;s:17:\"um-faicon-twitter\";i:878;s:18:\"um-faicon-facebook\";i:879;s:16:\"um-faicon-github\";i:880;s:16:\"um-faicon-unlock\";i:881;s:21:\"um-faicon-credit-card\";i:882;s:13:\"um-faicon-rss\";i:883;s:15:\"um-faicon-hdd-o\";i:884;s:18:\"um-faicon-bullhorn\";i:885;s:14:\"um-faicon-bell\";i:886;s:21:\"um-faicon-certificate\";i:887;s:22:\"um-faicon-hand-o-right\";i:888;s:21:\"um-faicon-hand-o-left\";i:889;s:19:\"um-faicon-hand-o-up\";i:890;s:21:\"um-faicon-hand-o-down\";i:891;s:27:\"um-faicon-arrow-circle-left\";i:892;s:28:\"um-faicon-arrow-circle-right\";i:893;s:25:\"um-faicon-arrow-circle-up\";i:894;s:27:\"um-faicon-arrow-circle-down\";i:895;s:15:\"um-faicon-globe\";i:896;s:16:\"um-faicon-wrench\";i:897;s:15:\"um-faicon-tasks\";i:898;s:16:\"um-faicon-filter\";i:899;s:19:\"um-faicon-briefcase\";i:900;s:20:\"um-faicon-arrows-alt\";i:901;s:15:\"um-faicon-users\";i:902;s:14:\"um-faicon-link\";i:903;s:15:\"um-faicon-cloud\";i:904;s:15:\"um-faicon-flask\";i:905;s:18:\"um-faicon-scissors\";i:906;s:17:\"um-faicon-files-o\";i:907;s:19:\"um-faicon-paperclip\";i:908;s:18:\"um-faicon-floppy-o\";i:909;s:16:\"um-faicon-square\";i:910;s:14:\"um-faicon-bars\";i:911;s:17:\"um-faicon-list-ul\";i:912;s:17:\"um-faicon-list-ol\";i:913;s:23:\"um-faicon-strikethrough\";i:914;s:19:\"um-faicon-underline\";i:915;s:15:\"um-faicon-table\";i:916;s:15:\"um-faicon-magic\";i:917;s:15:\"um-faicon-truck\";i:918;s:19:\"um-faicon-pinterest\";i:919;s:26:\"um-faicon-pinterest-square\";i:920;s:28:\"um-faicon-google-plus-square\";i:921;s:21:\"um-faicon-google-plus\";i:922;s:15:\"um-faicon-money\";i:923;s:20:\"um-faicon-caret-down\";i:924;s:18:\"um-faicon-caret-up\";i:925;s:20:\"um-faicon-caret-left\";i:926;s:21:\"um-faicon-caret-right\";i:927;s:17:\"um-faicon-columns\";i:928;s:14:\"um-faicon-sort\";i:929;s:19:\"um-faicon-sort-desc\";i:930;s:18:\"um-faicon-sort-asc\";i:931;s:18:\"um-faicon-envelope\";i:932;s:18:\"um-faicon-linkedin\";i:933;s:14:\"um-faicon-undo\";i:934;s:15:\"um-faicon-gavel\";i:935;s:20:\"um-faicon-tachometer\";i:936;s:19:\"um-faicon-comment-o\";i:937;s:20:\"um-faicon-comments-o\";i:938;s:14:\"um-faicon-bolt\";i:939;s:17:\"um-faicon-sitemap\";i:940;s:18:\"um-faicon-umbrella\";i:941;s:19:\"um-faicon-clipboard\";i:942;s:21:\"um-faicon-lightbulb-o\";i:943;s:18:\"um-faicon-exchange\";i:944;s:24:\"um-faicon-cloud-download\";i:945;s:22:\"um-faicon-cloud-upload\";i:946;s:17:\"um-faicon-user-md\";i:947;s:21:\"um-faicon-stethoscope\";i:948;s:18:\"um-faicon-suitcase\";i:949;s:16:\"um-faicon-bell-o\";i:950;s:16:\"um-faicon-coffee\";i:951;s:17:\"um-faicon-cutlery\";i:952;s:21:\"um-faicon-file-text-o\";i:953;s:20:\"um-faicon-building-o\";i:954;s:20:\"um-faicon-hospital-o\";i:955;s:19:\"um-faicon-ambulance\";i:956;s:16:\"um-faicon-medkit\";i:957;s:21:\"um-faicon-fighter-jet\";i:958;s:14:\"um-faicon-beer\";i:959;s:18:\"um-faicon-h-square\";i:960;s:21:\"um-faicon-plus-square\";i:961;s:27:\"um-faicon-angle-double-left\";i:962;s:28:\"um-faicon-angle-double-right\";i:963;s:25:\"um-faicon-angle-double-up\";i:964;s:27:\"um-faicon-angle-double-down\";i:965;s:20:\"um-faicon-angle-left\";i:966;s:21:\"um-faicon-angle-right\";i:967;s:18:\"um-faicon-angle-up\";i:968;s:20:\"um-faicon-angle-down\";i:969;s:17:\"um-faicon-desktop\";i:970;s:16:\"um-faicon-laptop\";i:971;s:16:\"um-faicon-tablet\";i:972;s:16:\"um-faicon-mobile\";i:973;s:18:\"um-faicon-circle-o\";i:974;s:20:\"um-faicon-quote-left\";i:975;s:21:\"um-faicon-quote-right\";i:976;s:17:\"um-faicon-spinner\";i:977;s:14:\"um-faicon-spin\";i:978;s:16:\"um-faicon-circle\";i:979;s:15:\"um-faicon-reply\";i:980;s:20:\"um-faicon-github-alt\";i:981;s:18:\"um-faicon-folder-o\";i:982;s:23:\"um-faicon-folder-open-o\";i:983;s:17:\"um-faicon-smile-o\";i:984;s:17:\"um-faicon-frown-o\";i:985;s:15:\"um-faicon-meh-o\";i:986;s:17:\"um-faicon-gamepad\";i:987;s:20:\"um-faicon-keyboard-o\";i:988;s:16:\"um-faicon-flag-o\";i:989;s:24:\"um-faicon-flag-checkered\";i:990;s:18:\"um-faicon-terminal\";i:991;s:14:\"um-faicon-code\";i:992;s:19:\"um-faicon-reply-all\";i:993;s:21:\"um-faicon-star-half-o\";i:994;s:24:\"um-faicon-location-arrow\";i:995;s:14:\"um-faicon-crop\";i:996;s:19:\"um-faicon-code-fork\";i:997;s:22:\"um-faicon-chain-broken\";i:998;s:18:\"um-faicon-question\";i:999;s:14:\"um-faicon-info\";i:1000;s:21:\"um-faicon-exclamation\";i:1001;s:21:\"um-faicon-superscript\";i:1002;s:19:\"um-faicon-subscript\";i:1003;s:16:\"um-faicon-eraser\";i:1004;s:22:\"um-faicon-puzzle-piece\";i:1005;s:20:\"um-faicon-microphone\";i:1006;s:26:\"um-faicon-microphone-slash\";i:1007;s:16:\"um-faicon-shield\";i:1008;s:20:\"um-faicon-calendar-o\";i:1009;s:27:\"um-faicon-fire-extinguisher\";i:1010;s:16:\"um-faicon-rocket\";i:1011;s:16:\"um-faicon-maxcdn\";i:1012;s:29:\"um-faicon-chevron-circle-left\";i:1013;s:30:\"um-faicon-chevron-circle-right\";i:1014;s:27:\"um-faicon-chevron-circle-up\";i:1015;s:29:\"um-faicon-chevron-circle-down\";i:1016;s:15:\"um-faicon-html5\";i:1017;s:14:\"um-faicon-css3\";i:1018;s:16:\"um-faicon-anchor\";i:1019;s:20:\"um-faicon-unlock-alt\";i:1020;s:18:\"um-faicon-bullseye\";i:1021;s:20:\"um-faicon-ellipsis-h\";i:1022;s:20:\"um-faicon-ellipsis-v\";i:1023;s:20:\"um-faicon-rss-square\";i:1024;s:21:\"um-faicon-play-circle\";i:1025;s:16:\"um-faicon-ticket\";i:1026;s:22:\"um-faicon-minus-square\";i:1027;s:24:\"um-faicon-minus-square-o\";i:1028;s:18:\"um-faicon-level-up\";i:1029;s:20:\"um-faicon-level-down\";i:1030;s:22:\"um-faicon-check-square\";i:1031;s:23:\"um-faicon-pencil-square\";i:1032;s:30:\"um-faicon-external-link-square\";i:1033;s:22:\"um-faicon-share-square\";i:1034;s:17:\"um-faicon-compass\";i:1035;s:29:\"um-faicon-caret-square-o-down\";i:1036;s:27:\"um-faicon-caret-square-o-up\";i:1037;s:30:\"um-faicon-caret-square-o-right\";i:1038;s:13:\"um-faicon-eur\";i:1039;s:13:\"um-faicon-gbp\";i:1040;s:13:\"um-faicon-usd\";i:1041;s:13:\"um-faicon-inr\";i:1042;s:13:\"um-faicon-jpy\";i:1043;s:13:\"um-faicon-rub\";i:1044;s:13:\"um-faicon-krw\";i:1045;s:13:\"um-faicon-btc\";i:1046;s:14:\"um-faicon-file\";i:1047;s:19:\"um-faicon-file-text\";i:1048;s:24:\"um-faicon-sort-alpha-asc\";i:1049;s:25:\"um-faicon-sort-alpha-desc\";i:1050;s:25:\"um-faicon-sort-amount-asc\";i:1051;s:26:\"um-faicon-sort-amount-desc\";i:1052;s:26:\"um-faicon-sort-numeric-asc\";i:1053;s:27:\"um-faicon-sort-numeric-desc\";i:1054;s:19:\"um-faicon-thumbs-up\";i:1055;s:21:\"um-faicon-thumbs-down\";i:1056;s:24:\"um-faicon-youtube-square\";i:1057;s:17:\"um-faicon-youtube\";i:1058;s:14:\"um-faicon-xing\";i:1059;s:21:\"um-faicon-xing-square\";i:1060;s:22:\"um-faicon-youtube-play\";i:1061;s:17:\"um-faicon-dropbox\";i:1062;s:24:\"um-faicon-stack-overflow\";i:1063;s:19:\"um-faicon-instagram\";i:1064;s:16:\"um-faicon-flickr\";i:1065;s:13:\"um-faicon-adn\";i:1066;s:19:\"um-faicon-bitbucket\";i:1067;s:26:\"um-faicon-bitbucket-square\";i:1068;s:16:\"um-faicon-tumblr\";i:1069;s:23:\"um-faicon-tumblr-square\";i:1070;s:25:\"um-faicon-long-arrow-down\";i:1071;s:23:\"um-faicon-long-arrow-up\";i:1072;s:25:\"um-faicon-long-arrow-left\";i:1073;s:26:\"um-faicon-long-arrow-right\";i:1074;s:15:\"um-faicon-apple\";i:1075;s:17:\"um-faicon-windows\";i:1076;s:17:\"um-faicon-android\";i:1077;s:15:\"um-faicon-linux\";i:1078;s:18:\"um-faicon-dribbble\";i:1079;s:15:\"um-faicon-skype\";i:1080;s:20:\"um-faicon-foursquare\";i:1081;s:16:\"um-faicon-trello\";i:1082;s:16:\"um-faicon-female\";i:1083;s:14:\"um-faicon-male\";i:1084;s:16:\"um-faicon-gittip\";i:1085;s:15:\"um-faicon-sun-o\";i:1086;s:16:\"um-faicon-moon-o\";i:1087;s:17:\"um-faicon-archive\";i:1088;s:13:\"um-faicon-bug\";i:1089;s:12:\"um-faicon-vk\";i:1090;s:15:\"um-faicon-weibo\";i:1091;s:16:\"um-faicon-renren\";i:1092;s:19:\"um-faicon-pagelines\";i:1093;s:24:\"um-faicon-stack-exchange\";i:1094;s:30:\"um-faicon-arrow-circle-o-right\";i:1095;s:29:\"um-faicon-arrow-circle-o-left\";i:1096;s:29:\"um-faicon-caret-square-o-left\";i:1097;s:22:\"um-faicon-dot-circle-o\";i:1098;s:20:\"um-faicon-wheelchair\";i:1099;s:22:\"um-faicon-vimeo-square\";i:1100;s:13:\"um-faicon-try\";i:1101;s:23:\"um-faicon-plus-square-o\";i:1102;s:23:\"um-faicon-space-shuttle\";i:1103;s:15:\"um-faicon-slack\";i:1104;s:25:\"um-faicon-envelope-square\";i:1105;s:19:\"um-faicon-wordpress\";i:1106;s:16:\"um-faicon-openid\";i:1107;s:20:\"um-faicon-university\";i:1108;s:24:\"um-faicon-graduation-cap\";i:1109;s:15:\"um-faicon-yahoo\";i:1110;s:16:\"um-faicon-google\";i:1111;s:16:\"um-faicon-reddit\";i:1112;s:23:\"um-faicon-reddit-square\";i:1113;s:28:\"um-faicon-stumbleupon-circle\";i:1114;s:21:\"um-faicon-stumbleupon\";i:1115;s:19:\"um-faicon-delicious\";i:1116;s:14:\"um-faicon-digg\";i:1117;s:20:\"um-faicon-pied-piper\";i:1118;s:24:\"um-faicon-pied-piper-alt\";i:1119;s:16:\"um-faicon-drupal\";i:1120;s:16:\"um-faicon-joomla\";i:1121;s:18:\"um-faicon-language\";i:1122;s:13:\"um-faicon-fax\";i:1123;s:18:\"um-faicon-building\";i:1124;s:15:\"um-faicon-child\";i:1125;s:13:\"um-faicon-paw\";i:1126;s:15:\"um-faicon-spoon\";i:1127;s:14:\"um-faicon-cube\";i:1128;s:15:\"um-faicon-cubes\";i:1129;s:17:\"um-faicon-behance\";i:1130;s:24:\"um-faicon-behance-square\";i:1131;s:15:\"um-faicon-steam\";i:1132;s:22:\"um-faicon-steam-square\";i:1133;s:17:\"um-faicon-recycle\";i:1134;s:13:\"um-faicon-car\";i:1135;s:14:\"um-faicon-taxi\";i:1136;s:14:\"um-faicon-tree\";i:1137;s:17:\"um-faicon-spotify\";i:1138;s:20:\"um-faicon-deviantart\";i:1139;s:20:\"um-faicon-soundcloud\";i:1140;s:18:\"um-faicon-database\";i:1141;s:20:\"um-faicon-file-pdf-o\";i:1142;s:21:\"um-faicon-file-word-o\";i:1143;s:22:\"um-faicon-file-excel-o\";i:1144;s:27:\"um-faicon-file-powerpoint-o\";i:1145;s:22:\"um-faicon-file-image-o\";i:1146;s:24:\"um-faicon-file-archive-o\";i:1147;s:22:\"um-faicon-file-audio-o\";i:1148;s:22:\"um-faicon-file-video-o\";i:1149;s:21:\"um-faicon-file-code-o\";i:1150;s:14:\"um-faicon-vine\";i:1151;s:17:\"um-faicon-codepen\";i:1152;s:18:\"um-faicon-jsfiddle\";i:1153;s:19:\"um-faicon-life-ring\";i:1154;s:24:\"um-faicon-circle-o-notch\";i:1155;s:15:\"um-faicon-rebel\";i:1156;s:16:\"um-faicon-empire\";i:1157;s:20:\"um-faicon-git-square\";i:1158;s:13:\"um-faicon-git\";i:1159;s:21:\"um-faicon-hacker-news\";i:1160;s:23:\"um-faicon-tencent-weibo\";i:1161;s:12:\"um-faicon-qq\";i:1162;s:16:\"um-faicon-weixin\";i:1163;s:21:\"um-faicon-paper-plane\";i:1164;s:23:\"um-faicon-paper-plane-o\";i:1165;s:17:\"um-faicon-history\";i:1166;s:21:\"um-faicon-circle-thin\";i:1167;s:16:\"um-faicon-header\";i:1168;s:19:\"um-faicon-paragraph\";i:1169;s:17:\"um-faicon-sliders\";i:1170;s:19:\"um-faicon-share-alt\";i:1171;s:26:\"um-faicon-share-alt-square\";i:1172;s:14:\"um-faicon-bomb\";i:1173;s:18:\"um-faicon-futbol-o\";i:1174;s:13:\"um-faicon-tty\";i:1175;s:20:\"um-faicon-binoculars\";i:1176;s:14:\"um-faicon-plug\";i:1177;s:20:\"um-faicon-slideshare\";i:1178;s:16:\"um-faicon-twitch\";i:1179;s:14:\"um-faicon-yelp\";i:1180;s:21:\"um-faicon-newspaper-o\";i:1181;s:14:\"um-faicon-wifi\";i:1182;s:20:\"um-faicon-calculator\";i:1183;s:16:\"um-faicon-paypal\";i:1184;s:23:\"um-faicon-google-wallet\";i:1185;s:17:\"um-faicon-cc-visa\";i:1186;s:23:\"um-faicon-cc-mastercard\";i:1187;s:21:\"um-faicon-cc-discover\";i:1188;s:17:\"um-faicon-cc-amex\";i:1189;s:19:\"um-faicon-cc-paypal\";i:1190;s:19:\"um-faicon-cc-stripe\";i:1191;s:20:\"um-faicon-bell-slash\";i:1192;s:22:\"um-faicon-bell-slash-o\";i:1193;s:15:\"um-faicon-trash\";i:1194;s:19:\"um-faicon-copyright\";i:1195;s:12:\"um-faicon-at\";i:1196;s:20:\"um-faicon-eyedropper\";i:1197;s:21:\"um-faicon-paint-brush\";i:1198;s:23:\"um-faicon-birthday-cake\";i:1199;s:20:\"um-faicon-area-chart\";i:1200;s:19:\"um-faicon-pie-chart\";i:1201;s:20:\"um-faicon-line-chart\";i:1202;s:16:\"um-faicon-lastfm\";i:1203;s:23:\"um-faicon-lastfm-square\";i:1204;s:20:\"um-faicon-toggle-off\";i:1205;s:19:\"um-faicon-toggle-on\";i:1206;s:17:\"um-faicon-bicycle\";i:1207;s:13:\"um-faicon-bus\";i:1208;s:17:\"um-faicon-ioxhost\";i:1209;s:19:\"um-faicon-angellist\";i:1210;s:12:\"um-faicon-cc\";i:1211;s:13:\"um-faicon-ils\";i:1212;s:18:\"um-faicon-meanpath\";i:1213;s:14:\"um-faicon-spin\";i:1214;s:14:\"um-faicon-spin\";i:1215;s:14:\"um-faicon-spin\";i:1216;s:14:\"um-faicon-spin\";i:1217;s:14:\"um-faicon-spin\";}", "yes");
INSERT INTO `trvlite_options` VALUES("7237", "wp_less_stylesheet_data_207d09a3707ee647aed5e01890d145c4", "a:1:{s:10:\"target_uri\";s:97:\"http://travelite.com.ph/wp-content/uploads/wp-less/travelite/css/post-type-dynamic-a19689ef8a.css\";}", "yes");
INSERT INTO `trvlite_options` VALUES("7240", "duplicator_settings", "a:10:{s:7:\"version\";s:5:\"1.2.6\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:0;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;}", "yes");
INSERT INTO `trvlite_options` VALUES("5346", "vfb_dashboard_widget_options", "a:1:{s:28:\"vfb_dashboard_recent_entries\";a:1:{s:5:\"items\";i:5;}}", "yes");
INSERT INTO `trvlite_options` VALUES("5359", "vfb-settings", "a:6:{s:15:\"always-load-css\";s:1:\"1\";s:11:\"spam-points\";s:1:\"4\";s:15:\"max-upload-size\";s:2:\"25\";s:18:\"sender-mail-header\";s:32:\"wordpress@beta.travelitecebu.com\";s:20:\"recaptcha-public-key\";s:40:\"6LehZx8UAAAAAOUrPjSljIJlfmfO5gpol93ixKgU\";s:21:\"recaptcha-private-key\";s:40:\"6LehZx8UAAAAAD0kUf4z-kYAfpTyOGmeWY94s3ra\";}", "yes");
INSERT INTO `trvlite_options` VALUES("191055", "dt_portfolio_category_children", "a:3:{i:12;a:14:{i:0;i:13;i:1;i:14;i:2;i:15;i:3;i:16;i:4;i:17;i:5;i:18;i:6;i:19;i:7;i:20;i:8;i:21;i:9;i:34;i:10;i:45;i:11;i:46;i:12;i:47;i:13;i:58;}i:3;a:12:{i:0;i:22;i:1;i:23;i:2;i:24;i:3;i:25;i:4;i:26;i:5;i:27;i:6;i:28;i:7;i:29;i:8;i:30;i:9;i:31;i:10;i:32;i:11;i:33;}i:14;a:13:{i:0;i:35;i:1;i:36;i:2;i:37;i:3;i:38;i:4;i:39;i:5;i:40;i:6;i:41;i:7;i:42;i:8;i:43;i:9;i:44;i:10;i:57;i:11;i:59;i:12;i:62;}}", "yes");
INSERT INTO `trvlite_options` VALUES("12700", "widget_mc4wp_form_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("12701", "mc4wp_version", "4.2.5", "yes");
INSERT INTO `trvlite_options` VALUES("12708", "mc4wp_mailchimp_list_dee9ae2c39", "O:20:\"MC4WP_MailChimp_List\":6:{s:2:\"id\";s:10:\"dee9ae2c39\";s:6:\"web_id\";i:398981;s:4:\"name\";s:36:\"Travelite Travel and Tours (CLIENTS)\";s:16:\"subscriber_count\";i:1901;s:12:\"merge_fields\";a:5:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:7:\"MMERGE3\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"MMERGE4\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}}", "no");
INSERT INTO `trvlite_options` VALUES("12709", "mc4wp_mailchimp_list_4a911f81dc", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"4a911f81dc\";s:6:\"web_id\";i:515145;s:4:\"name\";s:37:\"Travelite Travel & Tours (Agents NCR)\";s:16:\"subscriber_count\";i:637;s:12:\"merge_fields\";a:5:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:7:\"MMERGE3\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"MMERGE4\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:14:\"Crissy Rellora\";s:10:\"from_email\";s:31:\"crissy.rellora@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("12715", "mc4wp_form_stylesheets", "a:0:{}", "yes");
INSERT INTO `trvlite_options` VALUES("12712", "mc4wp_default_form_id", "1587", "yes");
INSERT INTO `trvlite_options` VALUES("109031", "widget_custom-twitter-feeds-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("125228", "tablepress_plugin_options", "{\"plugin_options_db_version\":36,\"table_scheme_db_version\":3,\"prev_tablepress_version\":\"0\",\"tablepress_version\":\"1.9\",\"first_activation\":1519942923,\"message_plugin_update\":false,\"message_donation_nag\":true,\"use_custom_css\":true,\"use_custom_css_file\":true,\"custom_css\":\"\",\"custom_css_minified\":\"\",\"custom_css_version\":0}", "yes");
INSERT INTO `trvlite_options` VALUES("172484", "um_role_subscriber_meta", "a:34:{s:13:\"_um_is_custom\";s:1:\"0\";s:4:\"name\";s:10:\"Subscriber\";s:12:\"_um_priority\";s:0:\"\";s:22:\"_um_can_access_wpadmin\";s:1:\"0\";s:24:\"_um_can_not_see_adminbar\";s:1:\"1\";s:21:\"_um_can_edit_everyone\";s:1:\"0\";s:18:\"_um_can_edit_roles\";s:0:\"\";s:23:\"_um_can_delete_everyone\";s:1:\"0\";s:20:\"_um_can_delete_roles\";s:0:\"\";s:20:\"_um_can_edit_profile\";s:1:\"1\";s:22:\"_um_can_delete_profile\";s:1:\"0\";s:16:\"_um_can_view_all\";s:1:\"0\";s:18:\"_um_can_view_roles\";s:0:\"\";s:28:\"_um_can_make_private_profile\";s:1:\"0\";s:30:\"_um_can_access_private_profile\";s:1:\"0\";s:20:\"_um_default_homepage\";s:1:\"1\";s:21:\"_um_redirect_homepage\";s:0:\"\";s:10:\"_um_status\";s:7:\"pending\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";s:20:\"_um_auto_approve_url\";s:0:\"\";s:24:\"_um_login_email_activate\";s:1:\"0\";s:20:\"_um_checkmail_action\";s:12:\"show_message\";s:21:\"_um_checkmail_message\";s:147:\"Thank you for registering. Before you can login we need you to activate your account by clicking the activation link in the email we just sent you.\";s:17:\"_um_checkmail_url\";s:0:\"\";s:22:\"_um_url_email_activate\";s:0:\"\";s:18:\"_um_pending_action\";s:12:\"show_message\";s:19:\"_um_pending_message\";s:187:\"Thanks for sending your registration as Travel Agent to our website. We will review your details and send you an email letting you know whether your registration has been approved or not.\";s:15:\"_um_pending_url\";s:0:\"\";s:15:\"_um_after_login\";s:12:\"redirect_url\";s:22:\"_um_login_redirect_url\";s:44:\"http://travelite.com.ph/promo-tour-packages/\";s:16:\"_um_after_logout\";s:12:\"redirect_url\";s:23:\"_um_logout_redirect_url\";s:30:\"http://travelite.com.ph/login/\";s:16:\"_um_after_delete\";s:13:\"redirect_home\";s:23:\"_um_delete_redirect_url\";s:0:\"\";}", "yes");
INSERT INTO `trvlite_options` VALUES("172485", "um_role_author_meta", "a:14:{s:22:\"_um_can_access_wpadmin\";i:0;s:24:\"_um_can_not_see_adminbar\";i:1;s:21:\"_um_can_edit_everyone\";i:0;s:23:\"_um_can_delete_everyone\";i:0;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:15:\"_um_after_login\";s:16:\"redirect_profile\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:20:\"_um_default_homepage\";i:1;s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:0;s:30:\"_um_can_access_private_profile\";i:0;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}", "yes");
INSERT INTO `trvlite_options` VALUES("172486", "um_role_contributor_meta", "a:14:{s:22:\"_um_can_access_wpadmin\";i:0;s:24:\"_um_can_not_see_adminbar\";i:1;s:21:\"_um_can_edit_everyone\";i:0;s:23:\"_um_can_delete_everyone\";i:0;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:15:\"_um_after_login\";s:16:\"redirect_profile\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:20:\"_um_default_homepage\";i:1;s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:0;s:30:\"_um_can_access_private_profile\";i:0;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}", "yes");
INSERT INTO `trvlite_options` VALUES("172487", "um_role_editor_meta", "a:14:{s:22:\"_um_can_access_wpadmin\";i:0;s:24:\"_um_can_not_see_adminbar\";i:1;s:21:\"_um_can_edit_everyone\";i:0;s:23:\"_um_can_delete_everyone\";i:0;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:15:\"_um_after_login\";s:16:\"redirect_profile\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:20:\"_um_default_homepage\";i:1;s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:0;s:30:\"_um_can_access_private_profile\";i:0;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}", "yes");
INSERT INTO `trvlite_options` VALUES("172488", "um_role_administrator_meta", "a:14:{s:22:\"_um_can_access_wpadmin\";i:1;s:24:\"_um_can_not_see_adminbar\";i:0;s:21:\"_um_can_edit_everyone\";i:1;s:23:\"_um_can_delete_everyone\";i:1;s:20:\"_um_can_edit_profile\";i:1;s:22:\"_um_can_delete_profile\";i:1;s:20:\"_um_default_homepage\";i:1;s:15:\"_um_after_login\";s:14:\"redirect_admin\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:16:\"_um_can_view_all\";i:1;s:28:\"_um_can_make_private_profile\";i:1;s:30:\"_um_can_access_private_profile\";i:1;s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";}", "yes");
INSERT INTO `trvlite_options` VALUES("172533", "um_options_backup20", "a:209:{s:8:\"last_tab\";s:0:\"\";s:9:\"core_user\";s:4:\"2689\";s:12:\"core_account\";s:4:\"2699\";s:12:\"core_members\";s:4:\"2695\";s:13:\"core_register\";s:4:\"2693\";s:10:\"core_login\";s:4:\"2691\";s:11:\"core_logout\";s:4:\"2697\";s:19:\"core_password-reset\";s:4:\"2701\";s:12:\"default_role\";s:6:\"member\";s:14:\"permalink_base\";s:10:\"user_login\";s:12:\"display_name\";s:9:\"full_name\";s:18:\"display_name_field\";s:0:\"\";s:29:\"force_display_name_capitlized\";s:1:\"1\";s:15:\"author_redirect\";s:1:\"0\";s:12:\"members_page\";s:1:\"0\";s:13:\"use_gravatars\";s:1:\"1\";s:37:\"use_um_gravatar_default_builtin_image\";s:2:\"mm\";s:29:\"use_um_gravatar_default_image\";s:1:\"0\";s:24:\"reset_require_strongpass\";s:1:\"0\";s:33:\"editable_primary_email_in_profile\";s:1:\"0\";s:20:\"account_tab_password\";s:1:\"1\";s:19:\"account_tab_privacy\";s:1:\"0\";s:25:\"account_tab_notifications\";s:1:\"1\";s:18:\"account_tab_delete\";s:1:\"0\";s:19:\"delete_account_text\";s:150:\"Are you sure you want to delete your account? This will erase all of your account data from the site. To delete your account enter your password below\";s:12:\"account_name\";s:1:\"1\";s:20:\"account_name_disable\";s:1:\"0\";s:20:\"account_name_require\";s:1:\"1\";s:13:\"account_email\";s:1:\"0\";s:25:\"account_hide_in_directory\";s:1:\"0\";s:26:\"account_require_strongpass\";s:1:\"0\";s:9:\"panic_key\";s:10:\"AOiKEXDrGo\";s:10:\"accessible\";s:1:\"0\";s:15:\"access_redirect\";s:0:\"\";s:20:\"home_page_accessible\";s:1:\"1\";s:24:\"category_page_accessible\";s:1:\"1\";s:13:\"wpadmin_login\";s:1:\"0\";s:25:\"deny_admin_frontend_login\";s:1:\"0\";s:22:\"wpadmin_login_redirect\";s:13:\"um_login_page\";s:26:\"wpadmin_login_redirect_url\";s:0:\"\";s:16:\"wpadmin_register\";s:1:\"0\";s:25:\"wpadmin_register_redirect\";s:16:\"um_register_page\";s:29:\"wpadmin_register_redirect_url\";s:7:\"/login/\";s:24:\"access_widget_admin_only\";s:1:\"1\";s:27:\"enable_reset_password_limit\";s:1:\"1\";s:27:\"reset_password_limit_number\";s:1:\"5\";s:34:\"disable_admin_reset_password_limit\";s:1:\"0\";s:17:\"wpadmin_allow_ips\";s:0:\"\";s:11:\"blocked_ips\";s:0:\"\";s:14:\"blocked_emails\";s:0:\"\";s:13:\"blocked_words\";s:47:\"admin\r\nadministrator\r\nwebmaster\r\nsupport\r\nstaff\";s:9:\"mail_from\";s:26:\"Travelite Travel and Tours\";s:14:\"mail_from_addr\";s:21:\"info@travelite.com.ph\";s:10:\"email_html\";s:1:\"0\";s:16:\"welcome_email_on\";s:1:\"1\";s:17:\"welcome_email_sub\";s:23:\"Welcome to {site_name}!\";s:13:\"welcome_email\";s:306:\"Hi {display_name},\r\n\r\nThank you for signing up with {site_name}! Your account is now active.\r\n\r\nTo login please visit the following url:\r\n\r\n{login_url}\r\n\r\nYour account e-mail: {email}\r\nYour account username: {username}\r\n\r\nIf you have any problems, please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:18:\"checkmail_email_on\";s:1:\"1\";s:19:\"checkmail_email_sub\";s:28:\"Please activate your account\";s:15:\"checkmail_email\";s:266:\"Hi {display_name},\r\n\r\nThank you for signing up with {site_name}! To activate your account, please click the link below to confirm your email address:\r\n\r\n{account_activation_link}\r\n\r\nIf you have any problems, please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:16:\"pending_email_on\";s:1:\"1\";s:17:\"pending_email_sub\";s:30:\"Your account is pending review\";s:13:\"pending_email\";s:272:\"Hi {display_name},\r\n\r\nThank you for signing up with {site_name}! Your account is currently being reviewed by a member of our team.\r\n\r\nPlease allow us some time to process your request.\r\n\r\nIf you have any problems, please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:17:\"approved_email_on\";s:1:\"1\";s:18:\"approved_email_sub\";s:41:\"Your account at {site_name} is now active\";s:14:\"approved_email\";s:378:\"Hi {display_name},\r\n\r\nThank you for signing up with {site_name}! Your account has been approved and is now active.\r\n\r\nTo login please visit the following url:\r\n\r\n{login_url}\r\n\r\nYour account e-mail: {email}\r\nYour account username: {username}\r\nSet your account password: {password_reset_link}\r\n\r\nIf you have any problems, please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:17:\"rejected_email_on\";s:1:\"1\";s:18:\"rejected_email_sub\";s:30:\"Your account has been rejected\";s:14:\"rejected_email\";s:260:\"Hi {display_name},\r\n\r\nThank you for applying for membership to {site_name}! We have reviewed your information and unfortunately we are unable to accept you as a member at this moment.\r\n\r\nPlease feel free to apply again at a future date.\r\n\r\nThanks,\r\n{site_name}\";s:17:\"inactive_email_on\";s:1:\"1\";s:18:\"inactive_email_sub\";s:33:\"Your account has been deactivated\";s:14:\"inactive_email\";s:222:\"Hi {display_name},\r\n\r\nThis is an automated email to let you know your {site_name} account has been deactivated.\r\n\r\nIf you would like your account to be reactivated please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:17:\"deletion_email_on\";s:1:\"1\";s:18:\"deletion_email_sub\";s:29:\"Your account has been deleted\";s:14:\"deletion_email\";s:332:\"Hi {display_name},\r\n\r\nThis is an automated email to let you know your {site_name} account has been deleted. All of your personal information has been permanently deleted and you will no longer be able to login to {site_name}.\r\n\r\nIf your account has been deleted by accident please contact us at {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:16:\"resetpw_email_on\";s:1:\"1\";s:17:\"resetpw_email_sub\";s:19:\"Reset your password\";s:13:\"resetpw_email\";s:266:\"Hi {display_name},\r\n\r\nWe received a request to reset the password for your account. If you made this request, click the link below to change your password:\r\n\r\n{password_reset_link}\r\n\r\nIf you didn\'t make this request, you can ignore this email\r\n\r\nThanks,\r\n{site_name}\";s:18:\"changedpw_email_on\";s:1:\"1\";s:19:\"changedpw_email_sub\";s:42:\"Your {site_name} password has been changed\";s:15:\"changedpw_email\";s:279:\"Hi {display_name},\r\n\r\nYou recently changed the password associated with your {site_name} account.\r\n\r\nIf you did not make this change and believe your {site_name} account has been compromised, please contact us at the following email address: {admin_email}\r\n\r\nThanks,\r\n{site_name}\";s:11:\"admin_email\";s:21:\"info@travelite.com.ph\";s:24:\"notification_new_user_on\";s:1:\"1\";s:25:\"notification_new_user_sub\";s:30:\"[{site_name}] New user account\";s:21:\"notification_new_user\";s:187:\"{display_name} has just created an account on {site_name}. To view their profile click here:\r\n\r\n{user_profile_link}\r\n\r\nHere is the submitted registration form:\r\n\r\n{submitted_registration}\";s:22:\"notification_review_on\";s:1:\"0\";s:23:\"notification_review_sub\";s:38:\"[{site_name}] New user awaiting review\";s:19:\"notification_review\";s:245:\"{display_name} has just applied for membership to {site_name} and is waiting to be reviewed.\r\n\r\nTo review this member please click the following link:\r\n\r\n{user_profile_link}\r\n\r\nHere is the submitted registration form:\r\n\r\n{submitted_registration}\";s:24:\"notification_deletion_on\";s:1:\"0\";s:25:\"notification_deletion_sub\";s:29:\"[{site_name}] Account deleted\";s:21:\"notification_deletion\";s:58:\"{display_name} has just deleted their {site_name} account.\";s:22:\"profile_photo_max_size\";s:6:\"500000\";s:20:\"cover_photo_max_size\";s:7:\"1000000\";s:17:\"photo_thumb_sizes\";a:3:{i:0;s:2:\"40\";i:1;s:2:\"80\";i:2;s:3:\"190\";}s:17:\"cover_thumb_sizes\";a:2:{i:0;s:3:\"200\";i:1;s:3:\"200\";}s:17:\"image_compression\";s:2:\"60\";s:15:\"image_max_width\";s:4:\"1500\";s:15:\"cover_min_width\";s:3:\"800\";s:13:\"profile_title\";s:43:\"{display_name} | Travelite Travel and Tours\";s:12:\"profile_desc\";s:83:\"{display_name} is on {site_name}. Join {site_name} to view {display_name}\'s profile\";s:18:\"directory_template\";s:7:\"members\";s:12:\"active_color\";s:7:\"#3ba1da\";s:15:\"secondary_color\";s:7:\"#44b0ec\";s:17:\"primary_btn_color\";s:7:\"#3ba1da\";s:17:\"primary_btn_hover\";s:7:\"#44b0ec\";s:16:\"primary_btn_text\";s:7:\"#ffffff\";s:19:\"secondary_btn_color\";s:7:\"#eeeeee\";s:19:\"secondary_btn_hover\";s:7:\"#e5e5e5\";s:18:\"secondary_btn_text\";s:7:\"#666666\";s:14:\"help_tip_color\";s:7:\"#cccccc\";s:16:\"form_field_label\";s:7:\"#555555\";s:11:\"form_border\";s:14:\"2px solid #ddd\";s:17:\"form_border_hover\";s:14:\"2px solid #bbb\";s:13:\"form_bg_color\";s:7:\"#ffffff\";s:19:\"form_bg_color_focus\";s:7:\"#ffffff\";s:15:\"form_text_color\";s:7:\"#666666\";s:16:\"form_placeholder\";s:7:\"#aaaaaa\";s:15:\"form_icon_color\";s:7:\"#aaaaaa\";s:13:\"form_asterisk\";s:1:\"0\";s:19:\"form_asterisk_color\";s:7:\"#aaaaaa\";s:16:\"profile_template\";s:7:\"profile\";s:17:\"profile_max_width\";s:6:\"1000px\";s:22:\"profile_area_max_width\";s:5:\"600px\";s:13:\"profile_align\";s:6:\"center\";s:13:\"profile_icons\";s:5:\"label\";s:24:\"profile_primary_btn_word\";s:14:\"Update Profile\";s:21:\"profile_secondary_btn\";s:1:\"1\";s:26:\"profile_secondary_btn_word\";s:6:\"Cancel\";s:12:\"profile_role\";s:1:\"0\";s:15:\"profile_main_bg\";s:0:\"\";s:17:\"profile_header_bg\";s:0:\"\";s:14:\"default_avatar\";a:5:{s:3:\"url\";s:88:\"http://travelite.com.ph/wp-content/plugins/ultimate-member/assets/img/default_avatar.jpg\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:13:\"default_cover\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:17:\"profile_photosize\";s:5:\"190px\";s:19:\"profile_photocorner\";s:1:\"1\";s:21:\"profile_cover_enabled\";s:1:\"1\";s:19:\"profile_cover_ratio\";s:5:\"2.7:1\";s:21:\"profile_show_metaicon\";s:1:\"0\";s:19:\"profile_header_text\";s:7:\"#999999\";s:25:\"profile_header_link_color\";s:7:\"#555555\";s:26:\"profile_header_link_hcolor\";s:7:\"#444444\";s:25:\"profile_header_icon_color\";s:7:\"#aaaaaa\";s:26:\"profile_header_icon_hcolor\";s:7:\"#3ba1da\";s:17:\"profile_show_name\";s:1:\"1\";s:25:\"profile_show_social_links\";s:1:\"0\";s:16:\"profile_show_bio\";s:1:\"1\";s:21:\"profile_show_html_bio\";s:0:\"\";s:20:\"profile_bio_maxchars\";s:3:\"180\";s:19:\"profile_header_menu\";s:2:\"bc\";s:18:\"profile_empty_text\";s:1:\"1\";s:22:\"profile_empty_text_emo\";s:1:\"1\";s:12:\"profile_menu\";s:1:\"1\";s:16:\"profile_tab_main\";s:1:\"1\";s:24:\"profile_tab_main_privacy\";s:1:\"0\";s:17:\"profile_tab_posts\";s:1:\"1\";s:25:\"profile_tab_posts_privacy\";s:1:\"0\";s:20:\"profile_tab_comments\";s:1:\"1\";s:28:\"profile_tab_comments_privacy\";s:1:\"0\";s:24:\"profile_menu_default_tab\";s:4:\"main\";s:18:\"profile_menu_icons\";s:1:\"1\";s:17:\"register_template\";s:8:\"register\";s:18:\"register_max_width\";s:5:\"450px\";s:14:\"register_align\";s:6:\"center\";s:14:\"register_icons\";s:5:\"label\";s:25:\"register_primary_btn_word\";s:8:\"Register\";s:22:\"register_secondary_btn\";s:1:\"1\";s:27:\"register_secondary_btn_word\";s:5:\"Login\";s:26:\"register_secondary_btn_url\";s:0:\"\";s:13:\"register_role\";s:1:\"0\";s:14:\"login_template\";s:5:\"login\";s:15:\"login_max_width\";s:5:\"450px\";s:11:\"login_align\";s:6:\"center\";s:11:\"login_icons\";s:5:\"label\";s:22:\"login_primary_btn_word\";s:5:\"Login\";s:19:\"login_secondary_btn\";s:1:\"1\";s:24:\"login_secondary_btn_word\";s:8:\"Register\";s:23:\"login_secondary_btn_url\";s:0:\"\";s:22:\"login_forgot_pass_link\";s:1:\"1\";s:21:\"login_show_rememberme\";s:1:\"1\";s:28:\"um_profile_object_cache_stop\";s:1:\"1\";s:13:\"um_flush_stop\";s:1:\"0\";s:29:\"um_generate_slug_in_directory\";s:1:\"0\";s:18:\"current_url_method\";s:11:\"SERVER_NAME\";s:22:\"um_port_forwarding_url\";s:1:\"0\";s:21:\"um_force_utf8_strings\";s:1:\"0\";s:14:\"enable_timebot\";s:1:\"1\";s:14:\"disable_minify\";s:1:\"0\";s:12:\"disable_menu\";s:1:\"0\";s:19:\"js_css_exlcude_home\";s:1:\"0\";s:17:\"enable_custom_css\";s:1:\"0\";s:14:\"allow_tracking\";s:1:\"0\";s:24:\"addon_bp_avatar_transfer\";s:0:\"\";s:23:\"addon_gravatar_transfer\";s:0:\"\";s:27:\"addon_generate_random_users\";s:0:\"\";s:18:\"addon_install_info\";s:0:\"\";s:19:\"access_exclude_uris\";a:0:{}s:22:\"profile_tab_main_roles\";s:0:\"\";s:23:\"profile_tab_posts_roles\";s:0:\"\";s:26:\"profile_tab_comments_roles\";s:0:\"\";s:14:\"js_css_exclude\";a:0:{}s:14:\"js_css_include\";a:0:{}s:30:\"restricted_access_post_metabox\";a:2:{s:4:\"post\";i:1;s:4:\"page\";i:1;}s:19:\"uninstall_on_delete\";i:0;s:22:\"custom_roles_increment\";i:1;s:23:\"changedaccount_email_on\";b:1;s:24:\"changedaccount_email_sub\";s:39:\"Your account at {site_name} was updated\";s:20:\"changedaccount_email\";s:278:\"Hi {display_name},<br /><br />You recently updated your {site_name} account.<br /><br />If you did not make this change and believe your {site_name} account has been compromised, please contact us at the following email address: {admin_email}<br /><br />Thanks,<br />{site_name}\";s:16:\"directory_header\";s:21:\"{total_users} Members\";s:23:\"directory_header_single\";s:20:\"{total_users} Member\";}", "yes");
INSERT INTO `trvlite_options` VALUES("172534", "um_role_member_meta", "a:35:{s:13:\"_um_is_custom\";s:1:\"1\";s:4:\"name\";s:6:\"Member\";s:12:\"_um_priority\";s:0:\"\";s:22:\"_um_can_access_wpadmin\";s:1:\"0\";s:24:\"_um_can_not_see_adminbar\";s:1:\"1\";s:21:\"_um_can_edit_everyone\";s:1:\"0\";s:18:\"_um_can_edit_roles\";s:0:\"\";s:23:\"_um_can_delete_everyone\";s:1:\"0\";s:20:\"_um_can_delete_roles\";s:0:\"\";s:20:\"_um_can_edit_profile\";s:1:\"1\";s:22:\"_um_can_delete_profile\";s:1:\"0\";s:16:\"_um_can_view_all\";s:1:\"0\";s:18:\"_um_can_view_roles\";s:0:\"\";s:28:\"_um_can_make_private_profile\";s:1:\"0\";s:30:\"_um_can_access_private_profile\";s:1:\"0\";s:20:\"_um_default_homepage\";s:1:\"1\";s:21:\"_um_redirect_homepage\";s:0:\"\";s:10:\"_um_status\";s:7:\"pending\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";s:20:\"_um_auto_approve_url\";s:0:\"\";s:24:\"_um_login_email_activate\";s:1:\"0\";s:20:\"_um_checkmail_action\";s:12:\"show_message\";s:21:\"_um_checkmail_message\";s:147:\"Thank you for registering. Before you can login we need you to activate your account by clicking the activation link in the email we just sent you.\";s:17:\"_um_checkmail_url\";s:0:\"\";s:22:\"_um_url_email_activate\";s:0:\"\";s:18:\"_um_pending_action\";s:12:\"show_message\";s:19:\"_um_pending_message\";s:187:\"Thanks for sending your registration as Travel Agent to our website. We will review your details and send you an email letting you know whether your registration has been approved or not.\";s:15:\"_um_pending_url\";s:0:\"\";s:15:\"_um_after_login\";s:12:\"redirect_url\";s:22:\"_um_login_redirect_url\";s:44:\"http://travelite.com.ph/promo-tour-packages/\";s:16:\"_um_after_logout\";s:12:\"redirect_url\";s:23:\"_um_logout_redirect_url\";s:30:\"http://travelite.com.ph/login/\";s:16:\"_um_after_delete\";s:13:\"redirect_home\";s:23:\"_um_delete_redirect_url\";s:0:\"\";s:15:\"wp_capabilities\";a:1:{s:4:\"read\";s:1:\"1\";}}", "yes");
INSERT INTO `trvlite_options` VALUES("172535", "um_role_admin_meta", "a:17:{s:22:\"_um_can_access_wpadmin\";s:1:\"1\";s:24:\"_um_can_not_see_adminbar\";s:1:\"0\";s:21:\"_um_can_edit_everyone\";s:1:\"1\";s:23:\"_um_can_delete_everyone\";s:1:\"1\";s:20:\"_um_can_edit_profile\";s:1:\"1\";s:22:\"_um_can_delete_profile\";s:1:\"1\";s:16:\"_um_can_view_all\";s:1:\"1\";s:28:\"_um_can_make_private_profile\";s:1:\"1\";s:30:\"_um_can_access_private_profile\";s:1:\"1\";s:20:\"_um_default_homepage\";s:1:\"1\";s:10:\"_um_status\";s:8:\"approved\";s:20:\"_um_auto_approve_act\";s:16:\"redirect_profile\";s:15:\"_um_after_login\";s:14:\"redirect_admin\";s:16:\"_um_after_logout\";s:13:\"redirect_home\";s:4:\"name\";s:5:\"Admin\";s:15:\"wp_capabilities\";a:1:{s:4:\"read\";b:1;}s:13:\"_um_is_custom\";b:1;}", "yes");
INSERT INTO `trvlite_options` VALUES("172536", "um_roles", "a:2:{i:0;s:6:\"member\";i:1;s:5:\"admin\";}", "yes");
INSERT INTO `trvlite_options` VALUES("200704", "_transient_optionsframework_clean_options", "a:733:{s:21:\"general-content_width\";a:6:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:30:\"Content width (in \"px\" or \"%\")\";s:2:\"id\";s:21:\"general-content_width\";s:3:\"std\";s:6:\"1200px\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:9:\"css_width\";}s:14:\"general-layout\";a:7:{s:4:\"name\";s:6:\"Layout\";s:2:\"id\";s:14:\"general-layout\";s:3:\"std\";s:4:\"wide\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{s:4:\"wide\";a:2:{s:5:\"title\";s:4:\"Wide\";s:3:\"src\";s:48:\"/inc/admin/assets/images/general-layout-wide.gif\";}s:5:\"boxed\";a:2:{s:5:\"title\";s:5:\"Boxed\";s:3:\"src\";s:49:\"/inc/admin/assets/images/general-layout-boxed.gif\";}}s:9:\"show_hide\";a:1:{s:5:\"boxed\";b:1;}}s:17:\"general-box_width\";a:6:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:26:\"Box width (in \"px\" or \"%\")\";s:2:\"id\";s:17:\"general-box_width\";s:3:\"std\";s:6:\"1320px\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:9:\"css_width\";}s:22:\"general-boxed_bg_color\";a:4:{s:4:\"name\";s:16:\"Background color\";s:2:\"id\";s:22:\"general-boxed_bg_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:22:\"general-boxed_bg_image\";a:4:{s:4:\"type\";s:14:\"background_img\";s:2:\"id\";s:22:\"general-boxed_bg_image\";s:4:\"name\";s:20:\"Add background image\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}}s:27:\"general-boxed_bg_fullscreen\";a:4:{s:4:\"name\";s:11:\"Fullscreen \";s:2:\"id\";s:27:\"general-boxed_bg_fullscreen\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:22:\"general-boxed_bg_fixed\";a:4:{s:4:\"name\";s:17:\"Fixed background \";s:2:\"id\";s:22:\"general-boxed_bg_fixed\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:16:\"general-bg_color\";a:4:{s:4:\"name\";s:5:\"Color\";s:2:\"id\";s:16:\"general-bg_color\";s:3:\"std\";s:7:\"#252525\";s:4:\"type\";s:5:\"color\";}s:18:\"general-bg_opacity\";a:5:{s:4:\"name\";s:7:\"Opacity\";s:4:\"desc\";s:48:\"\"Opacity\" isn\'t compatible with slide-out footer\";s:2:\"id\";s:18:\"general-bg_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:16:\"general-bg_image\";a:4:{s:4:\"name\";s:20:\"Add background image\";s:2:\"id\";s:16:\"general-bg_image\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:4:\"type\";s:14:\"background_img\";}s:21:\"general-bg_fullscreen\";a:4:{s:4:\"name\";s:10:\"Fullscreen\";s:2:\"id\";s:21:\"general-bg_fullscreen\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:16:\"general-bg_fixed\";a:5:{s:4:\"type\";s:8:\"checkbox\";s:2:\"id\";s:16:\"general-bg_fixed\";s:4:\"name\";s:16:\"Fixed background\";s:4:\"desc\";s:69:\"\"Fixed\" setting isn\'t compatible with \"overlapping\" title area style.\";s:3:\"std\";i:0;}s:30:\"general-content_boxes_bg_color\";a:4:{s:4:\"name\";s:16:\"Background color\";s:2:\"id\";s:30:\"general-content_boxes_bg_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:32:\"general-content_boxes_bg_opacity\";a:4:{s:4:\"name\";s:18:\"Background opacity\";s:2:\"id\";s:32:\"general-content_boxes_bg_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:32:\"general-content_boxes_decoration\";a:7:{s:4:\"name\";s:10:\"Decoration\";s:2:\"id\";s:32:\"general-content_boxes_decoration\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:1:{s:7:\"outline\";b:1;}s:7:\"options\";a:3:{s:4:\"none\";a:2:{s:5:\"title\";s:4:\"None\";s:3:\"src\";s:66:\"/inc/admin/assets/images/general-content_boxes_decoration-none.gif\";}s:6:\"shadow\";a:2:{s:5:\"title\";s:6:\"Shadow\";s:3:\"src\";s:68:\"/inc/admin/assets/images/general-content_boxes_decoration-shadow.gif\";}s:7:\"outline\";a:2:{s:5:\"title\";s:7:\"Outline\";s:3:\"src\";s:69:\"/inc/admin/assets/images/general-content_boxes_decoration-outline.gif\";}}}s:46:\"general-content_boxes_decoration_outline_color\";a:4:{s:4:\"name\";s:24:\"Decoration outline color\";s:2:\"id\";s:46:\"general-content_boxes_decoration_outline_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:48:\"general-content_boxes_decoration_outline_opacity\";a:4:{s:4:\"name\";s:26:\"Decoration outline opacity\";s:2:\"id\";s:48:\"general-content_boxes_decoration_outline_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:14:\"dividers-color\";a:4:{s:4:\"name\";s:14:\"Dividers color\";s:2:\"id\";s:14:\"dividers-color\";s:3:\"std\";s:7:\"#cccccc\";s:4:\"type\";s:5:\"color\";}s:16:\"dividers-opacity\";a:4:{s:4:\"name\";s:16:\"Dividers opacity\";s:2:\"id\";s:16:\"dividers-opacity\";s:3:\"std\";i:50;s:4:\"type\";s:6:\"slider\";}s:25:\"general-accent_color_mode\";a:7:{s:4:\"name\";s:12:\"Accent color\";s:2:\"id\";s:25:\"general-accent_color_mode\";s:3:\"std\";s:5:\"color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:2:{s:5:\"color\";s:31:\"general-accent_color_mode-color\";s:8:\"gradient\";s:34:\"general-accent_color_mode-gradient\";}s:7:\"options\";a:2:{s:5:\"color\";a:2:{s:5:\"title\";s:11:\"Solid color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:8:\"Gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:23:\"general-accent_bg_color\";a:4:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:23:\"general-accent_bg_color\";s:3:\"std\";s:7:\"#D73B37\";s:4:\"type\";s:5:\"color\";}s:32:\"general-accent_bg_color_gradient\";a:4:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:32:\"general-accent_bg_color_gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:4:\"type\";s:8:\"gradient\";}s:21:\"general-border_radius\";a:5:{s:4:\"name\";s:18:\"Border Radius (px)\";s:2:\"id\";s:21:\"general-border_radius\";s:3:\"std\";s:1:\"8\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:10:\"dimensions\";}s:26:\"general-contact_form_style\";a:6:{s:4:\"name\";s:5:\"Style\";s:2:\"id\";s:26:\"general-contact_form_style\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:3:\"ios\";s:7:\"options\";a:3:{s:3:\"ios\";a:2:{s:5:\"title\";s:3:\"iOS\";s:3:\"src\";s:59:\"/inc/admin/assets/images/general-contact_form_style-ios.gif\";}s:7:\"minimal\";a:2:{s:5:\"title\";s:7:\"Minimal\";s:3:\"src\";s:63:\"/inc/admin/assets/images/general-contact_form_style-minimal.gif\";}s:8:\"material\";a:2:{s:5:\"title\";s:15:\"Material design\";s:3:\"src\";s:64:\"/inc/admin/assets/images/general-contact_form_style-material.gif\";}}}s:31:\"general-slideshow_bullets_style\";a:6:{s:4:\"name\";s:5:\"Style\";s:2:\"id\";s:31:\"general-slideshow_bullets_style\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:7:\"outline\";s:7:\"options\";a:3:{s:11:\"transparent\";a:2:{s:5:\"title\";s:15:\"Semitransparent\";s:3:\"src\";s:65:\"/inc/admin/assets/images/general-slideshow_bullets_style-semi.gif\";}s:6:\"accent\";a:2:{s:5:\"title\";s:12:\"Accent color\";s:3:\"src\";s:67:\"/inc/admin/assets/images/general-slideshow_bullets_style-accent.gif\";}s:7:\"outline\";a:2:{s:5:\"title\";s:8:\"Outlines\";s:3:\"src\";s:69:\"/inc/admin/assets/images/general-slideshow_bullets_style-outlines.gif\";}}}s:25:\"general-beautiful_loading\";a:7:{s:4:\"name\";s:17:\"Beautiful loading\";s:2:\"id\";s:25:\"general-beautiful_loading\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:7:\"enabled\";s:7:\"options\";a:2:{s:7:\"enabled\";a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:62:\"/inc/admin/assets/images/general-beautiful_loading-enabled.gif\";}s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:63:\"/inc/admin/assets/images/general-beautiful_loading-disabled.gif\";}}s:9:\"show_hide\";a:1:{s:7:\"enabled\";b:1;}}s:37:\"general-fullscreen_overlay_color_mode\";a:6:{s:4:\"name\";s:24:\"Fullscreen overlay color\";s:2:\"id\";s:37:\"general-fullscreen_overlay_color_mode\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:32:\"general-fullscreen_overlay_color\";a:5:{s:4:\"name\";s:31:\"Fullscreen overlay custom color\";s:2:\"id\";s:32:\"general-fullscreen_overlay_color\";s:10:\"dependency\";a:1:{i:0;a:2:{i:0;a:3:{s:5:\"field\";s:37:\"general-fullscreen_overlay_color_mode\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}i:1;a:3:{s:5:\"field\";s:25:\"general-beautiful_loading\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:7:\"enabled\";}}}s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:35:\"general-fullscreen_overlay_gradient\";a:5:{s:4:\"name\";s:34:\"Fullscreen overlay custom gradient\";s:2:\"id\";s:35:\"general-fullscreen_overlay_gradient\";s:10:\"dependency\";a:1:{i:0;a:2:{i:0;a:3:{s:5:\"field\";s:37:\"general-fullscreen_overlay_color_mode\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}i:1;a:3:{s:5:\"field\";s:25:\"general-beautiful_loading\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:7:\"enabled\";}}}s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#ffffff\";}}s:34:\"general-fullscreen_overlay_opacity\";a:5:{s:4:\"name\";s:26:\"Fullscreen overlay opacity\";s:2:\"id\";s:34:\"general-fullscreen_overlay_opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;s:7:\"options\";a:3:{s:3:\"max\";i:100;s:3:\"min\";i:0;s:4:\"step\";i:1;}}s:21:\"general-spinner_color\";a:4:{s:4:\"name\";s:13:\"Spinner color\";s:2:\"id\";s:21:\"general-spinner_color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:23:\"general-spinner_opacity\";a:5:{s:4:\"name\";s:15:\"Spinner opacity\";s:2:\"id\";s:23:\"general-spinner_opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;s:7:\"options\";a:3:{s:3:\"max\";i:100;s:3:\"min\";i:0;s:4:\"step\";i:1;}}s:20:\"general-loader_style\";a:6:{s:4:\"name\";s:12:\"Loader style\";s:2:\"id\";s:20:\"general-loader_style\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:14:\"double_circles\";s:7:\"options\";a:4:{s:14:\"double_circles\";s:7:\"Spinner\";s:16:\"square_jelly_box\";s:4:\"Ring\";s:17:\"ball_elastic_dots\";s:4:\"Bars\";s:6:\"custom\";s:6:\"Custom\";}s:9:\"show_hide\";a:1:{s:6:\"custom\";b:1;}}s:21:\"general-custom_loader\";a:5:{s:2:\"id\";s:21:\"general-custom_loader\";s:4:\"type\";s:8:\"textarea\";s:3:\"std\";b:0;s:8:\"sanitize\";s:16:\"without_sanitize\";s:8:\"settings\";a:1:{s:4:\"rows\";i:8;}}s:6:\"preset\";a:4:{s:2:\"id\";s:6:\"preset\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"images\";s:7:\"options\";a:32:{s:7:\"skin11r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin11r.gif\";s:5:\"title\";s:7:\"skin11r\";}s:6:\"skin22\";a:2:{s:3:\"src\";s:29:\"/inc/presets/icons/skin22.gif\";s:5:\"title\";s:6:\"skin22\";}s:7:\"skin07s\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin07s.gif\";s:5:\"title\";s:7:\"skin07s\";}s:7:\"skin01r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin01r.gif\";s:5:\"title\";s:7:\"skin01r\";}s:7:\"skin04r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin04r.gif\";s:5:\"title\";s:7:\"skin04r\";}s:7:\"skin05r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin05r.gif\";s:5:\"title\";s:7:\"skin05r\";}s:7:\"skin06b\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin06b.gif\";s:5:\"title\";s:7:\"skin06b\";}s:7:\"skin06r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin06r.gif\";s:5:\"title\";s:7:\"skin06r\";}s:7:\"skin07b\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin07b.gif\";s:5:\"title\";s:7:\"skin07b\";}s:7:\"skin07c\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin07c.gif\";s:5:\"title\";s:7:\"skin07c\";}s:7:\"skin09r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin09r.gif\";s:5:\"title\";s:7:\"skin09r\";}s:7:\"skin10r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin10r.gif\";s:5:\"title\";s:7:\"skin10r\";}s:7:\"skin11b\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin11b.gif\";s:5:\"title\";s:7:\"skin11b\";}s:7:\"skin12r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin12r.gif\";s:5:\"title\";s:7:\"skin12r\";}s:7:\"skin13r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin13r.gif\";s:5:\"title\";s:7:\"skin13r\";}s:7:\"skin14r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin14r.gif\";s:5:\"title\";s:7:\"skin14r\";}s:7:\"skin15r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin15r.gif\";s:5:\"title\";s:7:\"skin15r\";}s:7:\"skin16r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin16r.gif\";s:5:\"title\";s:7:\"skin16r\";}s:7:\"skin18r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin18r.gif\";s:5:\"title\";s:7:\"skin18r\";}s:7:\"skin19b\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin19b.gif\";s:5:\"title\";s:7:\"skin19b\";}s:7:\"skin19r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin19r.gif\";s:5:\"title\";s:7:\"skin19r\";}s:7:\"skin19s\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin19s.gif\";s:5:\"title\";s:7:\"skin19s\";}s:7:\"skin20r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin20r.gif\";s:5:\"title\";s:7:\"skin20r\";}s:6:\"skin21\";a:2:{s:3:\"src\";s:29:\"/inc/presets/icons/skin21.gif\";s:5:\"title\";s:6:\"skin21\";}s:7:\"skin02r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin02r.gif\";s:5:\"title\";s:7:\"skin02r\";}s:7:\"skin03r\";a:2:{s:3:\"src\";s:30:\"/inc/presets/icons/skin03r.gif\";s:5:\"title\";s:7:\"skin03r\";}s:8:\"wizard01\";a:2:{s:3:\"src\";s:31:\"/inc/presets/icons/wizard01.gif\";s:5:\"title\";s:8:\"wizard01\";}s:8:\"wizard02\";a:2:{s:3:\"src\";s:31:\"/inc/presets/icons/wizard02.gif\";s:5:\"title\";s:8:\"wizard02\";}s:8:\"wizard03\";a:2:{s:3:\"src\";s:31:\"/inc/presets/icons/wizard03.gif\";s:5:\"title\";s:8:\"wizard03\";}s:8:\"wizard04\";a:2:{s:3:\"src\";s:31:\"/inc/presets/icons/wizard04.gif\";s:5:\"title\";s:8:\"wizard04\";}s:8:\"wizard05\";a:2:{s:3:\"src\";s:31:\"/inc/presets/icons/wizard05.gif\";s:5:\"title\";s:8:\"wizard05\";}s:8:\"wizard06\";a:2:{s:3:\"src\";s:31:\"/inc/presets/icons/wizard06.gif\";s:5:\"title\";s:8:\"wizard06\";}}}s:13:\"header-layout\";a:8:{s:2:\"id\";s:13:\"header-layout\";s:4:\"name\";s:13:\"Choose layout\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:7:\"classic\";s:5:\"style\";s:8:\"vertical\";s:5:\"class\";s:20:\"option-header-layout\";s:7:\"options\";a:6:{s:7:\"classic\";a:2:{s:5:\"title\";s:14:\"Classic header\";s:3:\"src\";s:43:\"/inc/admin/assets/images/classic-header.gif\";}s:6:\"inline\";a:2:{s:5:\"title\";s:13:\"Inline header\";s:3:\"src\";s:42:\"/inc/admin/assets/images/inline-header.gif\";}s:5:\"split\";a:2:{s:5:\"title\";s:12:\"Split header\";s:3:\"src\";s:41:\"/inc/admin/assets/images/split-header.gif\";}s:4:\"side\";a:2:{s:5:\"title\";s:11:\"Side header\";s:3:\"src\";s:40:\"/inc/admin/assets/images/side-header.gif\";}s:9:\"slide_out\";a:2:{s:5:\"title\";s:24:\"Side navigation on click\";s:3:\"src\";s:45:\"/inc/admin/assets/images/slide-out-header.gif\";}s:7:\"overlay\";a:2:{s:5:\"title\";s:18:\"Overlay navigation\";s:3:\"src\";s:43:\"/inc/admin/assets/images/overlay-header.gif\";}}s:9:\"show_hide\";a:6:{s:7:\"classic\";a:2:{i:0;s:34:\"header-layout-classic-microwidgets\";i:1;s:30:\"header-layout-classic-settings\";}s:6:\"inline\";a:2:{i:0;s:33:\"header-layout-inline-microwidgets\";i:1;s:29:\"header-layout-inline-settings\";}s:5:\"split\";a:2:{i:0;s:32:\"header-layout-split-microwidgets\";i:1;s:28:\"header-layout-split-settings\";}s:4:\"side\";a:2:{i:0;s:31:\"header-layout-side-microwidgets\";i:1;s:27:\"header-layout-side-settings\";}s:9:\"slide_out\";a:2:{i:0;s:36:\"header-layout-slide_out-microwidgets\";i:1;s:32:\"header-layout-slide_out-settings\";}s:7:\"overlay\";a:2:{i:0;s:34:\"header-layout-overlay-microwidgets\";i:1;s:30:\"header-layout-overlay-settings\";}}}s:28:\"header-classic-show_elements\";a:8:{s:2:\"id\";s:28:\"header-classic-show_elements\";s:4:\"name\";s:12:\"Microwidgets\";s:4:\"desc\";s:105:\"When enabled, microwidgets can  be rearranged below. You can set them up in dedicated \"Microwidgets\" tab.\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:49:\"/inc/admin/assets/images/microwidgets-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:26:\"header-classic-icons_style\";a:6:{s:4:\"name\";s:5:\"Icons\";s:2:\"id\";s:26:\"header-classic-icons_style\";s:3:\"std\";s:5:\"light\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{s:5:\"light\";a:2:{s:5:\"title\";s:5:\"Light\";s:3:\"src\";s:54:\"/inc/admin/assets/images/general-icons_style-light.gif\";}s:4:\"bold\";a:2:{s:5:\"title\";s:4:\"Bold\";s:3:\"src\";s:53:\"/inc/admin/assets/images/general-icons_style-bold.gif\";}}}s:23:\"header-classic-elements\";a:6:{s:2:\"id\";s:23:\"header-classic-elements\";s:4:\"type\";s:8:\"sortable\";s:3:\"std\";a:0:{}s:13:\"palette_title\";s:17:\"Inactive elements\";s:5:\"items\";a:13:{s:12:\"social_icons\";a:2:{s:5:\"title\";s:12:\"Social icons\";s:5:\"class\";s:0:\"\";}s:6:\"search\";a:2:{s:5:\"title\";s:6:\"Search\";s:5:\"class\";s:0:\"\";}s:4:\"cart\";a:2:{s:5:\"title\";s:4:\"Cart\";s:5:\"class\";s:0:\"\";}s:11:\"custom_menu\";a:2:{s:5:\"title\";s:11:\"Custom menu\";s:5:\"class\";s:0:\"\";}s:5:\"login\";a:2:{s:5:\"title\";s:5:\"Login\";s:5:\"class\";s:0:\"\";}s:9:\"text_area\";a:2:{s:5:\"title\";s:6:\"Text 1\";s:5:\"class\";s:0:\"\";}s:10:\"text2_area\";a:2:{s:5:\"title\";s:6:\"Text 2\";s:5:\"class\";s:0:\"\";}s:10:\"text3_area\";a:2:{s:5:\"title\";s:6:\"Text 3\";s:5:\"class\";s:0:\"\";}s:5:\"skype\";a:2:{s:5:\"title\";s:5:\"Skype\";s:5:\"class\";s:0:\"\";}s:5:\"email\";a:2:{s:5:\"title\";s:4:\"Mail\";s:5:\"class\";s:0:\"\";}s:7:\"address\";a:2:{s:5:\"title\";s:7:\"Address\";s:5:\"class\";s:0:\"\";}s:5:\"phone\";a:2:{s:5:\"title\";s:5:\"Phone\";s:5:\"class\";s:0:\"\";}s:13:\"working_hours\";a:2:{s:5:\"title\";s:13:\"Working hours\";s:5:\"class\";s:0:\"\";}}s:6:\"fields\";a:5:{s:12:\"top_bar_left\";a:2:{s:5:\"title\";s:12:\"Top bar left\";s:5:\"class\";s:10:\"field-blue\";}s:13:\"top_bar_right\";a:2:{s:5:\"title\";s:13:\"Top bar right\";s:5:\"class\";s:10:\"field-blue\";}s:15:\"near_menu_right\";a:2:{s:5:\"title\";s:9:\"Near menu\";s:5:\"class\";s:11:\"field-green\";}s:14:\"near_logo_left\";a:2:{s:5:\"title\";s:16:\"Near logo (left)\";s:5:\"class\";s:9:\"field-red\";}s:15:\"near_logo_right\";a:2:{s:5:\"title\";s:17:\"Near logo (right)\";s:5:\"class\";s:9:\"field-red\";}}}s:51:\"header-classic-elements-near_menu_right-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:51:\"header-classic-elements-near_menu_right-padding-top\";}s:53:\"header-classic-elements-near_menu_right-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:53:\"header-classic-elements-near_menu_right-padding-right\";}s:54:\"header-classic-elements-near_menu_right-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:54:\"header-classic-elements-near_menu_right-padding-bottom\";}s:52:\"header-classic-elements-near_menu_right-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:52:\"header-classic-elements-near_menu_right-padding-left\";}s:50:\"header-classic-elements-near_logo_left-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:50:\"header-classic-elements-near_logo_left-padding-top\";}s:52:\"header-classic-elements-near_logo_left-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:52:\"header-classic-elements-near_logo_left-padding-right\";}s:53:\"header-classic-elements-near_logo_left-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:53:\"header-classic-elements-near_logo_left-padding-bottom\";}s:51:\"header-classic-elements-near_logo_left-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:51:\"header-classic-elements-near_logo_left-padding-left\";}s:51:\"header-classic-elements-near_logo_right-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:51:\"header-classic-elements-near_logo_right-padding-top\";}s:53:\"header-classic-elements-near_logo_right-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:53:\"header-classic-elements-near_logo_right-padding-right\";}s:54:\"header-classic-elements-near_logo_right-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:54:\"header-classic-elements-near_logo_right-padding-bottom\";}s:52:\"header-classic-elements-near_logo_right-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:52:\"header-classic-elements-near_logo_right-padding-left\";}s:27:\"header-inline-show_elements\";a:8:{s:2:\"id\";s:27:\"header-inline-show_elements\";s:4:\"name\";s:12:\"Microwidgets\";s:4:\"desc\";s:105:\"When enabled, microwidgets can  be rearranged below. You can set them up in dedicated \"Microwidgets\" tab.\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:49:\"/inc/admin/assets/images/microwidgets-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:25:\"header-inline-icons_style\";a:6:{s:4:\"name\";s:5:\"Icons\";s:2:\"id\";s:25:\"header-inline-icons_style\";s:3:\"std\";s:5:\"light\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{s:5:\"light\";a:2:{s:5:\"title\";s:5:\"Light\";s:3:\"src\";s:54:\"/inc/admin/assets/images/general-icons_style-light.gif\";}s:4:\"bold\";a:2:{s:5:\"title\";s:4:\"Bold\";s:3:\"src\";s:53:\"/inc/admin/assets/images/general-icons_style-bold.gif\";}}}s:22:\"header-inline-elements\";a:6:{s:2:\"id\";s:22:\"header-inline-elements\";s:4:\"type\";s:8:\"sortable\";s:3:\"std\";a:0:{}s:13:\"palette_title\";s:17:\"Inactive elements\";s:5:\"items\";a:13:{s:12:\"social_icons\";a:2:{s:5:\"title\";s:12:\"Social icons\";s:5:\"class\";s:0:\"\";}s:6:\"search\";a:2:{s:5:\"title\";s:6:\"Search\";s:5:\"class\";s:0:\"\";}s:4:\"cart\";a:2:{s:5:\"title\";s:4:\"Cart\";s:5:\"class\";s:0:\"\";}s:11:\"custom_menu\";a:2:{s:5:\"title\";s:11:\"Custom menu\";s:5:\"class\";s:0:\"\";}s:5:\"login\";a:2:{s:5:\"title\";s:5:\"Login\";s:5:\"class\";s:0:\"\";}s:9:\"text_area\";a:2:{s:5:\"title\";s:6:\"Text 1\";s:5:\"class\";s:0:\"\";}s:10:\"text2_area\";a:2:{s:5:\"title\";s:6:\"Text 2\";s:5:\"class\";s:0:\"\";}s:10:\"text3_area\";a:2:{s:5:\"title\";s:6:\"Text 3\";s:5:\"class\";s:0:\"\";}s:5:\"skype\";a:2:{s:5:\"title\";s:5:\"Skype\";s:5:\"class\";s:0:\"\";}s:5:\"email\";a:2:{s:5:\"title\";s:4:\"Mail\";s:5:\"class\";s:0:\"\";}s:7:\"address\";a:2:{s:5:\"title\";s:7:\"Address\";s:5:\"class\";s:0:\"\";}s:5:\"phone\";a:2:{s:5:\"title\";s:5:\"Phone\";s:5:\"class\";s:0:\"\";}s:13:\"working_hours\";a:2:{s:5:\"title\";s:13:\"Working hours\";s:5:\"class\";s:0:\"\";}}s:6:\"fields\";a:3:{s:12:\"top_bar_left\";a:2:{s:5:\"title\";s:12:\"Top bar left\";s:5:\"class\";s:10:\"field-blue\";}s:13:\"top_bar_right\";a:2:{s:5:\"title\";s:13:\"Top bar right\";s:5:\"class\";s:10:\"field-blue\";}s:15:\"near_menu_right\";a:2:{s:5:\"title\";s:9:\"Near menu\";s:5:\"class\";s:11:\"field-green\";}}}s:50:\"header-inline-elements-near_menu_right-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:50:\"header-inline-elements-near_menu_right-padding-top\";}s:52:\"header-inline-elements-near_menu_right-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:52:\"header-inline-elements-near_menu_right-padding-right\";}s:53:\"header-inline-elements-near_menu_right-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:53:\"header-inline-elements-near_menu_right-padding-bottom\";}s:51:\"header-inline-elements-near_menu_right-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:51:\"header-inline-elements-near_menu_right-padding-left\";}s:26:\"header-split-show_elements\";a:8:{s:2:\"id\";s:26:\"header-split-show_elements\";s:4:\"name\";s:12:\"Microwidgets\";s:4:\"desc\";s:105:\"When enabled, microwidgets can  be rearranged below. You can set them up in dedicated \"Microwidgets\" tab.\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:49:\"/inc/admin/assets/images/microwidgets-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:24:\"header-split-icons_style\";a:6:{s:4:\"name\";s:5:\"Icons\";s:2:\"id\";s:24:\"header-split-icons_style\";s:3:\"std\";s:5:\"light\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{s:5:\"light\";a:2:{s:5:\"title\";s:5:\"Light\";s:3:\"src\";s:54:\"/inc/admin/assets/images/general-icons_style-light.gif\";}s:4:\"bold\";a:2:{s:5:\"title\";s:4:\"Bold\";s:3:\"src\";s:53:\"/inc/admin/assets/images/general-icons_style-bold.gif\";}}}s:21:\"header-split-elements\";a:6:{s:2:\"id\";s:21:\"header-split-elements\";s:4:\"type\";s:8:\"sortable\";s:3:\"std\";a:0:{}s:13:\"palette_title\";s:17:\"Inactive elements\";s:5:\"items\";a:13:{s:12:\"social_icons\";a:2:{s:5:\"title\";s:12:\"Social icons\";s:5:\"class\";s:0:\"\";}s:6:\"search\";a:2:{s:5:\"title\";s:6:\"Search\";s:5:\"class\";s:0:\"\";}s:4:\"cart\";a:2:{s:5:\"title\";s:4:\"Cart\";s:5:\"class\";s:0:\"\";}s:11:\"custom_menu\";a:2:{s:5:\"title\";s:11:\"Custom menu\";s:5:\"class\";s:0:\"\";}s:5:\"login\";a:2:{s:5:\"title\";s:5:\"Login\";s:5:\"class\";s:0:\"\";}s:9:\"text_area\";a:2:{s:5:\"title\";s:6:\"Text 1\";s:5:\"class\";s:0:\"\";}s:10:\"text2_area\";a:2:{s:5:\"title\";s:6:\"Text 2\";s:5:\"class\";s:0:\"\";}s:10:\"text3_area\";a:2:{s:5:\"title\";s:6:\"Text 3\";s:5:\"class\";s:0:\"\";}s:5:\"skype\";a:2:{s:5:\"title\";s:5:\"Skype\";s:5:\"class\";s:0:\"\";}s:5:\"email\";a:2:{s:5:\"title\";s:4:\"Mail\";s:5:\"class\";s:0:\"\";}s:7:\"address\";a:2:{s:5:\"title\";s:7:\"Address\";s:5:\"class\";s:0:\"\";}s:5:\"phone\";a:2:{s:5:\"title\";s:5:\"Phone\";s:5:\"class\";s:0:\"\";}s:13:\"working_hours\";a:2:{s:5:\"title\";s:13:\"Working hours\";s:5:\"class\";s:0:\"\";}}s:6:\"fields\";a:4:{s:12:\"top_bar_left\";a:2:{s:5:\"title\";s:12:\"Top bar left\";s:5:\"class\";s:10:\"field-blue\";}s:13:\"top_bar_right\";a:2:{s:5:\"title\";s:13:\"Top bar right\";s:5:\"class\";s:10:\"field-blue\";}s:14:\"near_menu_left\";a:2:{s:5:\"title\";s:16:\"Near menu (left)\";s:5:\"class\";s:11:\"field-green\";}s:15:\"near_menu_right\";a:2:{s:5:\"title\";s:17:\"Near menu (right)\";s:5:\"class\";s:11:\"field-green\";}}}s:48:\"header-split-elements-near_menu_left-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:48:\"header-split-elements-near_menu_left-padding-top\";}s:50:\"header-split-elements-near_menu_left-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:50:\"header-split-elements-near_menu_left-padding-right\";}s:51:\"header-split-elements-near_menu_left-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:51:\"header-split-elements-near_menu_left-padding-bottom\";}s:49:\"header-split-elements-near_menu_left-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:49:\"header-split-elements-near_menu_left-padding-left\";}s:49:\"header-split-elements-near_menu_right-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:49:\"header-split-elements-near_menu_right-padding-top\";}s:51:\"header-split-elements-near_menu_right-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:51:\"header-split-elements-near_menu_right-padding-right\";}s:52:\"header-split-elements-near_menu_right-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:52:\"header-split-elements-near_menu_right-padding-bottom\";}s:50:\"header-split-elements-near_menu_right-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:50:\"header-split-elements-near_menu_right-padding-left\";}s:25:\"header-side-show_elements\";a:8:{s:2:\"id\";s:25:\"header-side-show_elements\";s:4:\"name\";s:12:\"Microwidgets\";s:4:\"desc\";s:105:\"When enabled, microwidgets can  be rearranged below. You can set them up in dedicated \"Microwidgets\" tab.\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:49:\"/inc/admin/assets/images/microwidgets-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:23:\"header-side-icons_style\";a:6:{s:4:\"name\";s:5:\"Icons\";s:2:\"id\";s:23:\"header-side-icons_style\";s:3:\"std\";s:5:\"light\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{s:5:\"light\";a:2:{s:5:\"title\";s:5:\"Light\";s:3:\"src\";s:54:\"/inc/admin/assets/images/general-icons_style-light.gif\";}s:4:\"bold\";a:2:{s:5:\"title\";s:4:\"Bold\";s:3:\"src\";s:53:\"/inc/admin/assets/images/general-icons_style-bold.gif\";}}}s:20:\"header-side-elements\";a:6:{s:2:\"id\";s:20:\"header-side-elements\";s:4:\"type\";s:8:\"sortable\";s:3:\"std\";a:0:{}s:13:\"palette_title\";s:17:\"Inactive elements\";s:5:\"items\";a:13:{s:12:\"social_icons\";a:2:{s:5:\"title\";s:12:\"Social icons\";s:5:\"class\";s:0:\"\";}s:6:\"search\";a:2:{s:5:\"title\";s:6:\"Search\";s:5:\"class\";s:0:\"\";}s:4:\"cart\";a:2:{s:5:\"title\";s:4:\"Cart\";s:5:\"class\";s:0:\"\";}s:11:\"custom_menu\";a:2:{s:5:\"title\";s:11:\"Custom menu\";s:5:\"class\";s:0:\"\";}s:5:\"login\";a:2:{s:5:\"title\";s:5:\"Login\";s:5:\"class\";s:0:\"\";}s:9:\"text_area\";a:2:{s:5:\"title\";s:6:\"Text 1\";s:5:\"class\";s:0:\"\";}s:10:\"text2_area\";a:2:{s:5:\"title\";s:6:\"Text 2\";s:5:\"class\";s:0:\"\";}s:10:\"text3_area\";a:2:{s:5:\"title\";s:6:\"Text 3\";s:5:\"class\";s:0:\"\";}s:5:\"skype\";a:2:{s:5:\"title\";s:5:\"Skype\";s:5:\"class\";s:0:\"\";}s:5:\"email\";a:2:{s:5:\"title\";s:4:\"Mail\";s:5:\"class\";s:0:\"\";}s:7:\"address\";a:2:{s:5:\"title\";s:7:\"Address\";s:5:\"class\";s:0:\"\";}s:5:\"phone\";a:2:{s:5:\"title\";s:5:\"Phone\";s:5:\"class\";s:0:\"\";}s:13:\"working_hours\";a:2:{s:5:\"title\";s:13:\"Working hours\";s:5:\"class\";s:0:\"\";}}s:6:\"fields\";a:1:{s:10:\"below_menu\";a:2:{s:5:\"title\";s:10:\"Below menu\";s:5:\"class\";s:11:\"field-green\";}}}s:43:\"header-side-elements-below_menu-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:43:\"header-side-elements-below_menu-padding-top\";}s:45:\"header-side-elements-below_menu-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:45:\"header-side-elements-below_menu-padding-right\";}s:46:\"header-side-elements-below_menu-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:46:\"header-side-elements-below_menu-padding-bottom\";}s:44:\"header-side-elements-below_menu-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:44:\"header-side-elements-below_menu-padding-left\";}s:30:\"header-slide_out-show_elements\";a:8:{s:2:\"id\";s:30:\"header-slide_out-show_elements\";s:4:\"name\";s:12:\"Microwidgets\";s:4:\"desc\";s:105:\"When enabled, microwidgets can  be rearranged below. You can set them up in dedicated \"Microwidgets\" tab.\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:49:\"/inc/admin/assets/images/microwidgets-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:28:\"header-slide_out-icons_style\";a:6:{s:4:\"name\";s:5:\"Icons\";s:2:\"id\";s:28:\"header-slide_out-icons_style\";s:3:\"std\";s:5:\"light\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{s:5:\"light\";a:2:{s:5:\"title\";s:5:\"Light\";s:3:\"src\";s:54:\"/inc/admin/assets/images/general-icons_style-light.gif\";}s:4:\"bold\";a:2:{s:5:\"title\";s:4:\"Bold\";s:3:\"src\";s:53:\"/inc/admin/assets/images/general-icons_style-bold.gif\";}}}s:25:\"header-slide_out-elements\";a:6:{s:2:\"id\";s:25:\"header-slide_out-elements\";s:4:\"type\";s:8:\"sortable\";s:3:\"std\";a:0:{}s:13:\"palette_title\";s:17:\"Inactive elements\";s:5:\"items\";a:13:{s:12:\"social_icons\";a:2:{s:5:\"title\";s:12:\"Social icons\";s:5:\"class\";s:0:\"\";}s:6:\"search\";a:2:{s:5:\"title\";s:6:\"Search\";s:5:\"class\";s:0:\"\";}s:4:\"cart\";a:2:{s:5:\"title\";s:4:\"Cart\";s:5:\"class\";s:0:\"\";}s:11:\"custom_menu\";a:2:{s:5:\"title\";s:11:\"Custom menu\";s:5:\"class\";s:0:\"\";}s:5:\"login\";a:2:{s:5:\"title\";s:5:\"Login\";s:5:\"class\";s:0:\"\";}s:9:\"text_area\";a:2:{s:5:\"title\";s:6:\"Text 1\";s:5:\"class\";s:0:\"\";}s:10:\"text2_area\";a:2:{s:5:\"title\";s:6:\"Text 2\";s:5:\"class\";s:0:\"\";}s:10:\"text3_area\";a:2:{s:5:\"title\";s:6:\"Text 3\";s:5:\"class\";s:0:\"\";}s:5:\"skype\";a:2:{s:5:\"title\";s:5:\"Skype\";s:5:\"class\";s:0:\"\";}s:5:\"email\";a:2:{s:5:\"title\";s:4:\"Mail\";s:5:\"class\";s:0:\"\";}s:7:\"address\";a:2:{s:5:\"title\";s:7:\"Address\";s:5:\"class\";s:0:\"\";}s:5:\"phone\";a:2:{s:5:\"title\";s:5:\"Phone\";s:5:\"class\";s:0:\"\";}s:13:\"working_hours\";a:2:{s:5:\"title\";s:13:\"Working hours\";s:5:\"class\";s:0:\"\";}}s:6:\"fields\";a:2:{s:13:\"side_top_line\";a:2:{s:5:\"title\";s:8:\"Top line\";s:5:\"class\";s:9:\"field-red\";}s:10:\"below_menu\";a:2:{s:5:\"title\";s:10:\"Below menu\";s:5:\"class\";s:11:\"field-green\";}}}s:46:\"header-slide_out-elements-top_line-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:46:\"header-slide_out-elements-top_line-padding-top\";}s:48:\"header-slide_out-elements-top_line-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:48:\"header-slide_out-elements-top_line-padding-right\";}s:49:\"header-slide_out-elements-top_line-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:49:\"header-slide_out-elements-top_line-padding-bottom\";}s:47:\"header-slide_out-elements-top_line-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:47:\"header-slide_out-elements-top_line-padding-left\";}s:48:\"header-slide_out-elements-below_menu-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:48:\"header-slide_out-elements-below_menu-padding-top\";}s:50:\"header-slide_out-elements-below_menu-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:50:\"header-slide_out-elements-below_menu-padding-right\";}s:51:\"header-slide_out-elements-below_menu-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:51:\"header-slide_out-elements-below_menu-padding-bottom\";}s:49:\"header-slide_out-elements-below_menu-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:49:\"header-slide_out-elements-below_menu-padding-left\";}s:28:\"header-overlay-show_elements\";a:8:{s:2:\"id\";s:28:\"header-overlay-show_elements\";s:4:\"name\";s:12:\"Microwidgets\";s:4:\"desc\";s:105:\"When enabled, microwidgets can  be rearranged below. You can set them up in dedicated \"Microwidgets\" tab.\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:49:\"/inc/admin/assets/images/microwidgets-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:26:\"header-overlay-icons_style\";a:6:{s:4:\"name\";s:5:\"Icons\";s:2:\"id\";s:26:\"header-overlay-icons_style\";s:3:\"std\";s:5:\"light\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{s:5:\"light\";a:2:{s:5:\"title\";s:5:\"Light\";s:3:\"src\";s:54:\"/inc/admin/assets/images/general-icons_style-light.gif\";}s:4:\"bold\";a:2:{s:5:\"title\";s:4:\"Bold\";s:3:\"src\";s:53:\"/inc/admin/assets/images/general-icons_style-bold.gif\";}}}s:23:\"header-overlay-elements\";a:6:{s:2:\"id\";s:23:\"header-overlay-elements\";s:4:\"type\";s:8:\"sortable\";s:3:\"std\";a:0:{}s:13:\"palette_title\";s:17:\"Inactive elements\";s:5:\"items\";a:13:{s:12:\"social_icons\";a:2:{s:5:\"title\";s:12:\"Social icons\";s:5:\"class\";s:0:\"\";}s:6:\"search\";a:2:{s:5:\"title\";s:6:\"Search\";s:5:\"class\";s:0:\"\";}s:4:\"cart\";a:2:{s:5:\"title\";s:4:\"Cart\";s:5:\"class\";s:0:\"\";}s:11:\"custom_menu\";a:2:{s:5:\"title\";s:11:\"Custom menu\";s:5:\"class\";s:0:\"\";}s:5:\"login\";a:2:{s:5:\"title\";s:5:\"Login\";s:5:\"class\";s:0:\"\";}s:9:\"text_area\";a:2:{s:5:\"title\";s:6:\"Text 1\";s:5:\"class\";s:0:\"\";}s:10:\"text2_area\";a:2:{s:5:\"title\";s:6:\"Text 2\";s:5:\"class\";s:0:\"\";}s:10:\"text3_area\";a:2:{s:5:\"title\";s:6:\"Text 3\";s:5:\"class\";s:0:\"\";}s:5:\"skype\";a:2:{s:5:\"title\";s:5:\"Skype\";s:5:\"class\";s:0:\"\";}s:5:\"email\";a:2:{s:5:\"title\";s:4:\"Mail\";s:5:\"class\";s:0:\"\";}s:7:\"address\";a:2:{s:5:\"title\";s:7:\"Address\";s:5:\"class\";s:0:\"\";}s:5:\"phone\";a:2:{s:5:\"title\";s:5:\"Phone\";s:5:\"class\";s:0:\"\";}s:13:\"working_hours\";a:2:{s:5:\"title\";s:13:\"Working hours\";s:5:\"class\";s:0:\"\";}}s:6:\"fields\";a:2:{s:13:\"side_top_line\";a:2:{s:5:\"title\";s:8:\"Top line\";s:5:\"class\";s:58:\"field-red hide-if-js header-overlay-elements-side_top_line\";}s:10:\"below_menu\";a:2:{s:5:\"title\";s:10:\"Below menu\";s:5:\"class\";s:11:\"field-green\";}}}s:44:\"header-overlay-elements-top_line-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:44:\"header-overlay-elements-top_line-padding-top\";}s:46:\"header-overlay-elements-top_line-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:46:\"header-overlay-elements-top_line-padding-right\";}s:47:\"header-overlay-elements-top_line-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:47:\"header-overlay-elements-top_line-padding-bottom\";}s:45:\"header-overlay-elements-top_line-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:45:\"header-overlay-elements-top_line-padding-left\";}s:46:\"header-overlay-elements-below_menu-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:46:\"header-overlay-elements-below_menu-padding-top\";}s:48:\"header-overlay-elements-below_menu-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:48:\"header-overlay-elements-below_menu-padding-right\";}s:49:\"header-overlay-elements-below_menu-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:49:\"header-overlay-elements-below_menu-padding-bottom\";}s:47:\"header-overlay-elements-below_menu-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:47:\"header-overlay-elements-below_menu-padding-left\";}s:28:\"header-classic-logo-position\";a:6:{s:2:\"id\";s:28:\"header-classic-logo-position\";s:4:\"name\";s:13:\"Logo position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:2:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-classic-logo-position-left.gif\";}s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:64:\"/inc/admin/assets/images/header-classic-logo-position-center.gif\";}}s:5:\"class\";s:5:\"small\";}s:28:\"header-classic-menu-position\";a:6:{s:2:\"id\";s:28:\"header-classic-menu-position\";s:4:\"name\";s:13:\"Menu position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:3:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-classic-menu-position-left.gif\";}s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:64:\"/inc/admin/assets/images/header-classic-menu-position-center.gif\";}s:7:\"justify\";a:2:{s:5:\"title\";s:9:\"Justified\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-classic-menu-position-justify.gif\";}}s:5:\"class\";s:5:\"small\";}s:30:\"header-classic-menu-margin-top\";a:6:{s:2:\"id\";s:30:\"header-classic-menu-margin-top\";s:4:\"name\";s:22:\"Margin above menu (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:33:\"header-classic-menu-margin-bottom\";a:6:{s:2:\"id\";s:33:\"header-classic-menu-margin-bottom\";s:4:\"name\";s:22:\"Margin below menu (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:21:\"header-classic-height\";a:6:{s:2:\"id\";s:21:\"header-classic-height\";s:4:\"name\";s:18:\"Header height (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"140\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:27:\"header-classic-is_fullwidth\";a:6:{s:2:\"id\";s:27:\"header-classic-is_fullwidth\";s:4:\"name\";s:17:\"Full-width header\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:63:\"/inc/admin/assets/images/header-classic-isfullwidth-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:64:\"/inc/admin/assets/images/header-classic-isfullwidth-disabled.gif\";}}}s:27:\"header-inline-menu-position\";a:6:{s:2:\"id\";s:27:\"header-inline-menu-position\";s:4:\"name\";s:13:\"Menu position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:5:\"right\";s:7:\"options\";a:4:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-inline-menu-position-left.gif\";}s:5:\"right\";a:2:{s:5:\"title\";s:5:\"Right\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-inline-menu-position-right.gif\";}s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:63:\"/inc/admin/assets/images/header-inline-menu-position-center.gif\";}s:7:\"justify\";a:2:{s:5:\"title\";s:9:\"Justified\";s:3:\"src\";s:64:\"/inc/admin/assets/images/header-inline-menu-position-justify.gif\";}}s:5:\"class\";s:5:\"small\";}s:20:\"header-inline-height\";a:6:{s:2:\"id\";s:20:\"header-inline-height\";s:4:\"name\";s:18:\"Header height (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"140\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:26:\"header-inline-is_fullwidth\";a:6:{s:2:\"id\";s:26:\"header-inline-is_fullwidth\";s:4:\"name\";s:17:\"Full-width header\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-inline-isfullwidth-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:63:\"/inc/admin/assets/images/header-inline-isfullwidth-disabled.gif\";}}}s:26:\"header-split-menu-position\";a:6:{s:2:\"id\";s:26:\"header-split-menu-position\";s:4:\"name\";s:13:\"Menu position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:6:\"inside\";s:7:\"options\";a:4:{s:7:\"justify\";a:2:{s:5:\"title\";s:9:\"Justified\";s:3:\"src\";s:63:\"/inc/admin/assets/images/header-split-menu-position-justify.gif\";}s:6:\"inside\";a:2:{s:5:\"title\";s:33:\"Menu inside, microwidgets outside\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-split-menu-position-inside.gif\";}s:12:\"fully_inside\";a:2:{s:5:\"title\";s:32:\"Menu inside, microwidgets inside\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-split-menu-position-fullyinside.gif\";}s:7:\"outside\";a:2:{s:5:\"title\";s:34:\"Menu outside, microwidgets outside\";s:3:\"src\";s:63:\"/inc/admin/assets/images/header-split-menu-position-outside.gif\";}}s:5:\"class\";s:5:\"small\";}s:19:\"header-split-height\";a:6:{s:2:\"id\";s:19:\"header-split-height\";s:4:\"name\";s:18:\"Header height (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"100\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:25:\"header-split-is_fullwidth\";a:6:{s:2:\"id\";s:25:\"header-split-is_fullwidth\";s:4:\"name\";s:17:\"Full-width header\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-split-isfullwidth-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-split-isfullwidth-disabled.gif\";}}}s:20:\"header-side-position\";a:6:{s:2:\"id\";s:20:\"header-side-position\";s:4:\"name\";s:15:\"Header position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:2:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:54:\"/inc/admin/assets/images/header-side-position-left.gif\";}s:5:\"right\";a:2:{s:5:\"title\";s:5:\"Right\";s:3:\"src\";s:55:\"/inc/admin/assets/images/header-side-position-right.gif\";}}s:5:\"class\";s:5:\"small\";}s:17:\"header-side-width\";a:5:{s:2:\"id\";s:17:\"header-side-width\";s:4:\"name\";s:22:\"Header width (px or %)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:5:\"300px\";s:8:\"sanitize\";s:9:\"css_width\";}s:25:\"header-side-content-width\";a:5:{s:4:\"name\";s:33:\"Width of header content (px or %)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:5:\"220px\";s:8:\"sanitize\";s:9:\"css_width\";s:2:\"id\";s:25:\"header-side-content-width\";}s:28:\"header-side-content-position\";a:6:{s:4:\"name\";s:26:\"Position of header content\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:3:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-side-content-position-left.gif\";}s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:64:\"/inc/admin/assets/images/header-side-content-position-center.gif\";}s:5:\"right\";a:2:{s:5:\"title\";s:5:\"Right\";s:3:\"src\";s:63:\"/inc/admin/assets/images/header-side-content-position-right.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:28:\"header-side-content-position\";}s:31:\"header-side-content-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:31:\"header-side-content-padding-top\";}s:33:\"header-side-content-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:33:\"header-side-content-padding-right\";}s:34:\"header-side-content-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:34:\"header-side-content-padding-bottom\";}s:32:\"header-side-content-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:32:\"header-side-content-padding-left\";}s:25:\"header-side-menu-position\";a:6:{s:4:\"name\";s:13:\"Menu position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:5:\"v_top\";s:7:\"options\";a:3:{s:5:\"v_top\";a:2:{s:5:\"title\";s:3:\"Top\";s:3:\"src\";s:58:\"/inc/admin/assets/images/header-side-menu-position-top.gif\";}s:8:\"v_center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-side-menu-position-center.gif\";}s:8:\"v_bottom\";a:2:{s:5:\"title\";s:6:\"Bottom\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-side-menu-position-bottom.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:25:\"header-side-menu-position\";}s:25:\"header-side-logo-position\";a:6:{s:4:\"name\";s:33:\"Logo and additional info position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:12:\"fully_inside\";s:7:\"options\";a:2:{s:12:\"fully_inside\";a:2:{s:5:\"title\";s:23:\"Along the edges of menu\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-side-logo-position-fullyinside.gif\";}s:6:\"inside\";a:2:{s:5:\"title\";s:33:\"Along the edges of entire content\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-side-logo-position-inside.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:25:\"header-side-logo-position\";}s:28:\"header-side-menu-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:28:\"header-side-menu-padding-top\";}s:31:\"header-side-menu-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:31:\"header-side-menu-padding-bottom\";}s:32:\"header-side-menu-items_alignment\";a:6:{s:4:\"name\";s:20:\"Menu items alignment\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:2:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-side-menu-itemsalignment-left.gif\";}s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-side-menu-itemsalignment-center.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:32:\"header-side-menu-items_alignment\";}s:27:\"header-side-menu-items_link\";a:6:{s:4:\"name\";s:20:\"Menu items link area\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:9:\"fullwidth\";s:7:\"options\";a:2:{s:9:\"fullwidth\";a:2:{s:5:\"title\";s:10:\"Full-width\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-side-menu-itemslink-fullwidth.gif\";}s:9:\"textwidth\";a:2:{s:5:\"title\";s:10:\"Text-width\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-side-menu-itemslink-textwidth.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:27:\"header-side-menu-items_link\";}s:23:\"header-slide_out-layout\";a:6:{s:4:\"name\";s:6:\"Layout\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:9:\"menu_icon\";s:7:\"options\";a:3:{s:9:\"menu_icon\";a:2:{s:5:\"title\";s:14:\"Menu icon only\";s:3:\"src\";s:60:\"/inc/admin/assets/images/header-slideout-layout-menuicon.gif\";}s:8:\"top_line\";a:2:{s:5:\"title\";s:8:\"Top line\";s:3:\"src\";s:59:\"/inc/admin/assets/images/header-slideout-layout-topline.gif\";}s:9:\"side_line\";a:2:{s:5:\"title\";s:9:\"Side line\";s:3:\"src\";s:60:\"/inc/admin/assets/images/header-slideout-layout-sideline.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:23:\"header-slide_out-layout\";}s:52:\"header-slide_out-layout-menu_icon-show_floating_logo\";a:7:{s:4:\"name\";s:13:\"Floating logo\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:1:\"1\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:85:\"/inc/admin/assets/images/header-slideout-layout-menuicon-showfloatinglogo-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:86:\"/inc/admin/assets/images/header-slideout-layout-menuicon-showfloatinglogo-disabled.gif\";}}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:23:\"header-slide_out-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:9:\"menu_icon\";}}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:52:\"header-slide_out-layout-menu_icon-show_floating_logo\";}s:39:\"header-slide_out-layout-top_line-height\";a:7:{s:4:\"name\";s:11:\"Height (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"130\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:23:\"header-slide_out-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"top_line\";}}}s:2:\"id\";s:39:\"header-slide_out-layout-top_line-height\";}s:45:\"header-slide_out-layout-top_line-is_fullwidth\";a:7:{s:4:\"name\";s:10:\"Full width\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-topline-fullwidth-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-topline-fullwidth-disabled.gif\";}}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:23:\"header-slide_out-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"top_line\";}}}s:2:\"id\";s:45:\"header-slide_out-layout-top_line-is_fullwidth\";}s:46:\"header-slide_out-layout-top_line-logo-position\";a:7:{s:4:\"name\";s:13:\"Logo position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:2:{s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:80:\"/inc/admin/assets/images/header-slideout-layout-topline-logo-position-center.gif\";}s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Side\";s:3:\"src\";s:78:\"/inc/admin/assets/images/header-slideout-layout-topline-logo-position-left.gif\";}}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:23:\"header-slide_out-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"top_line\";}}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:46:\"header-slide_out-layout-top_line-logo-position\";}s:39:\"header-slide_out-layout-side_line-width\";a:7:{s:4:\"name\";s:10:\"Width (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:2:\"60\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:23:\"header-slide_out-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:9:\"side_line\";}}}s:2:\"id\";s:39:\"header-slide_out-layout-side_line-width\";}s:42:\"header-slide_out-layout-side_line-position\";a:7:{s:4:\"name\";s:11:\"Show header\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:5:\"above\";s:7:\"options\";a:2:{s:5:\"above\";a:2:{s:5:\"title\";s:14:\"Above the line\";s:3:\"src\";s:75:\"/inc/admin/assets/images/header-slideout-layout-sideline-position-above.gif\";}s:5:\"under\";a:2:{s:5:\"title\";s:14:\"Under the line\";s:3:\"src\";s:75:\"/inc/admin/assets/images/header-slideout-layout-sideline-position-under.gif\";}}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:23:\"header-slide_out-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:9:\"side_line\";}}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:42:\"header-slide_out-layout-side_line-position\";}s:25:\"header-slide_out-position\";a:6:{s:2:\"id\";s:25:\"header-slide_out-position\";s:4:\"name\";s:15:\"Header position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:2:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:54:\"/inc/admin/assets/images/header-side-position-left.gif\";}s:5:\"right\";a:2:{s:5:\"title\";s:5:\"Right\";s:3:\"src\";s:55:\"/inc/admin/assets/images/header-side-position-right.gif\";}}s:5:\"class\";s:5:\"small\";}s:34:\"header-slide_out-overlay-animation\";a:6:{s:2:\"id\";s:34:\"header-slide_out-overlay-animation\";s:4:\"name\";s:9:\"Animation\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"fade\";s:7:\"options\";a:3:{s:4:\"fade\";a:2:{s:5:\"title\";s:4:\"Fade\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-slideout-overlay-animation-fade.gif\";}s:5:\"slide\";a:2:{s:5:\"title\";s:5:\"Slide\";s:3:\"src\";s:68:\"/inc/admin/assets/images/header-slideout-overlay-animation-slide.gif\";}s:4:\"move\";a:2:{s:5:\"title\";s:4:\"Move\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-slideout-overlay-animation-move.gif\";}}s:5:\"class\";s:5:\"small\";}s:22:\"header-slide_out-width\";a:5:{s:2:\"id\";s:22:\"header-slide_out-width\";s:4:\"name\";s:22:\"Header width (px or %)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:5:\"300px\";s:8:\"sanitize\";s:9:\"css_width\";}s:30:\"header-slide_out-content-width\";a:5:{s:4:\"name\";s:33:\"Width of header content (px or %)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:5:\"220px\";s:8:\"sanitize\";s:9:\"css_width\";s:2:\"id\";s:30:\"header-slide_out-content-width\";}s:33:\"header-slide_out-content-position\";a:6:{s:4:\"name\";s:26:\"Position of header content\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:3:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-side-content-position-left.gif\";}s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:64:\"/inc/admin/assets/images/header-side-content-position-center.gif\";}s:5:\"right\";a:2:{s:5:\"title\";s:5:\"Right\";s:3:\"src\";s:63:\"/inc/admin/assets/images/header-side-content-position-right.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:33:\"header-slide_out-content-position\";}s:36:\"header-slide_out-content-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:36:\"header-slide_out-content-padding-top\";}s:38:\"header-slide_out-content-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:38:\"header-slide_out-content-padding-right\";}s:39:\"header-slide_out-content-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:39:\"header-slide_out-content-padding-bottom\";}s:37:\"header-slide_out-content-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:37:\"header-slide_out-content-padding-left\";}s:30:\"header-slide_out-menu-position\";a:6:{s:4:\"name\";s:13:\"Menu position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:5:\"v_top\";s:7:\"options\";a:3:{s:5:\"v_top\";a:2:{s:5:\"title\";s:3:\"Top\";s:3:\"src\";s:58:\"/inc/admin/assets/images/header-side-menu-position-top.gif\";}s:8:\"v_center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-side-menu-position-center.gif\";}s:8:\"v_bottom\";a:2:{s:5:\"title\";s:6:\"Bottom\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-side-menu-position-bottom.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:30:\"header-slide_out-menu-position\";}s:30:\"header-slide_out-logo-position\";a:6:{s:4:\"name\";s:33:\"Logo and additional info position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:12:\"fully_inside\";s:7:\"options\";a:2:{s:12:\"fully_inside\";a:2:{s:5:\"title\";s:23:\"Along the edges of menu\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-side-logo-position-fullyinside.gif\";}s:6:\"inside\";a:2:{s:5:\"title\";s:33:\"Along the edges of entire content\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-side-logo-position-inside.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:30:\"header-slide_out-logo-position\";}s:33:\"header-slide_out-menu-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:33:\"header-slide_out-menu-padding-top\";}s:36:\"header-slide_out-menu-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:36:\"header-slide_out-menu-padding-bottom\";}s:37:\"header-slide_out-menu-items_alignment\";a:6:{s:4:\"name\";s:20:\"Menu items alignment\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:2:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-side-menu-itemsalignment-left.gif\";}s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-side-menu-itemsalignment-center.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:37:\"header-slide_out-menu-items_alignment\";}s:32:\"header-slide_out-menu-items_link\";a:6:{s:4:\"name\";s:20:\"Menu items link area\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:9:\"fullwidth\";s:7:\"options\";a:2:{s:9:\"fullwidth\";a:2:{s:5:\"title\";s:10:\"Full-width\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-side-menu-itemslink-fullwidth.gif\";}s:9:\"textwidth\";a:2:{s:5:\"title\";s:10:\"Text-width\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-side-menu-itemslink-textwidth.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:32:\"header-slide_out-menu-items_link\";}s:21:\"header-overlay-layout\";a:6:{s:4:\"name\";s:6:\"Layout\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:9:\"menu_icon\";s:7:\"options\";a:3:{s:9:\"menu_icon\";a:2:{s:5:\"title\";s:14:\"Menu icon only\";s:3:\"src\";s:60:\"/inc/admin/assets/images/header-slideout-layout-menuicon.gif\";}s:8:\"top_line\";a:2:{s:5:\"title\";s:8:\"Top line\";s:3:\"src\";s:59:\"/inc/admin/assets/images/header-slideout-layout-topline.gif\";}s:9:\"side_line\";a:2:{s:5:\"title\";s:9:\"Side line\";s:3:\"src\";s:60:\"/inc/admin/assets/images/header-slideout-layout-sideline.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:21:\"header-overlay-layout\";}s:50:\"header-overlay-layout-menu_icon-show_floating_logo\";a:7:{s:4:\"name\";s:13:\"Floating logo\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:1:\"1\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:85:\"/inc/admin/assets/images/header-slideout-layout-menuicon-showfloatinglogo-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:86:\"/inc/admin/assets/images/header-slideout-layout-menuicon-showfloatinglogo-disabled.gif\";}}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:21:\"header-overlay-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:9:\"menu_icon\";}}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:50:\"header-overlay-layout-menu_icon-show_floating_logo\";}s:37:\"header-overlay-layout-top_line-height\";a:7:{s:4:\"name\";s:11:\"Height (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"130\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:21:\"header-overlay-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"top_line\";}}}s:2:\"id\";s:37:\"header-overlay-layout-top_line-height\";}s:43:\"header-overlay-layout-top_line-is_fullwidth\";a:7:{s:4:\"name\";s:10:\"Full width\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-topline-fullwidth-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-topline-fullwidth-disabled.gif\";}}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:21:\"header-overlay-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"top_line\";}}}s:2:\"id\";s:43:\"header-overlay-layout-top_line-is_fullwidth\";}s:44:\"header-overlay-layout-top_line-logo-position\";a:7:{s:4:\"name\";s:13:\"Logo position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:2:{s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:80:\"/inc/admin/assets/images/header-slideout-layout-topline-logo-position-center.gif\";}s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Side\";s:3:\"src\";s:78:\"/inc/admin/assets/images/header-slideout-layout-topline-logo-position-left.gif\";}}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:21:\"header-overlay-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"top_line\";}}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:44:\"header-overlay-layout-top_line-logo-position\";}s:37:\"header-overlay-layout-side_line-width\";a:7:{s:4:\"name\";s:10:\"Width (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:2:\"60\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:21:\"header-overlay-layout\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:9:\"side_line\";}}}s:2:\"id\";s:37:\"header-overlay-layout-side_line-width\";}s:28:\"header-overlay-content-width\";a:5:{s:4:\"name\";s:48:\"Width of content in overlay navigation (px or %)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:5:\"400px\";s:8:\"sanitize\";s:9:\"css_width\";s:2:\"id\";s:28:\"header-overlay-content-width\";}s:31:\"header-overlay-content-position\";a:6:{s:4:\"name\";s:41:\"Position of content in overlay navigation\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:3:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-overlay-content-position-left.gif\";}s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-overlay-content-position-center.gif\";}s:5:\"right\";a:2:{s:5:\"title\";s:5:\"Right\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-overlay-content-position-right.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:31:\"header-overlay-content-position\";}s:34:\"header-overlay-content-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:34:\"header-overlay-content-padding-top\";}s:36:\"header-overlay-content-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:36:\"header-overlay-content-padding-right\";}s:37:\"header-overlay-content-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:37:\"header-overlay-content-padding-bottom\";}s:35:\"header-overlay-content-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:35:\"header-overlay-content-padding-left\";}s:28:\"header-overlay-menu-position\";a:6:{s:4:\"name\";s:13:\"Menu position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:5:\"v_top\";s:7:\"options\";a:3:{s:5:\"v_top\";a:2:{s:5:\"title\";s:3:\"Top\";s:3:\"src\";s:58:\"/inc/admin/assets/images/header-side-menu-position-top.gif\";}s:8:\"v_center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-side-menu-position-center.gif\";}s:8:\"v_bottom\";a:2:{s:5:\"title\";s:6:\"Bottom\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-side-menu-position-bottom.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:28:\"header-overlay-menu-position\";}s:28:\"header-overlay-logo-position\";a:6:{s:4:\"name\";s:33:\"Logo and additional info position\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:12:\"fully_inside\";s:7:\"options\";a:2:{s:12:\"fully_inside\";a:2:{s:5:\"title\";s:23:\"Along the edges of menu\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-side-logo-position-fullyinside.gif\";}s:6:\"inside\";a:2:{s:5:\"title\";s:33:\"Along the edges of entire content\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-side-logo-position-inside.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:28:\"header-overlay-logo-position\";}s:31:\"header-overlay-menu-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:31:\"header-overlay-menu-padding-top\";}s:34:\"header-overlay-menu-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:34:\"header-overlay-menu-padding-bottom\";}s:35:\"header-overlay-menu-items_alignment\";a:6:{s:4:\"name\";s:20:\"Menu items alignment\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:2:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-side-menu-itemsalignment-left.gif\";}s:6:\"center\";a:2:{s:5:\"title\";s:6:\"Center\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-side-menu-itemsalignment-center.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:35:\"header-overlay-menu-items_alignment\";}s:30:\"header-overlay-menu-items_link\";a:6:{s:4:\"name\";s:20:\"Menu items link area\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:9:\"fullwidth\";s:7:\"options\";a:2:{s:9:\"fullwidth\";a:2:{s:5:\"title\";s:10:\"Full-width\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-side-menu-itemslink-fullwidth.gif\";}s:9:\"textwidth\";a:2:{s:5:\"title\";s:10:\"Text-width\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-side-menu-itemslink-textwidth.gif\";}}s:5:\"class\";s:5:\"small\";s:2:\"id\";s:30:\"header-overlay-menu-items_link\";}s:19:\"top_bar-font-family\";a:5:{s:2:\"id\";s:19:\"top_bar-font-family\";s:4:\"name\";s:12:\"Top bar font\";s:4:\"type\";s:9:\"web_fonts\";s:3:\"std\";s:9:\"Open Sans\";s:5:\"fonts\";s:3:\"all\";}s:17:\"top_bar-font-size\";a:6:{s:2:\"id\";s:17:\"top_bar-font-size\";s:4:\"name\";s:17:\"Top bar font size\";s:4:\"type\";s:6:\"slider\";s:8:\"sanitize\";s:9:\"font_size\";s:3:\"std\";i:16;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}}s:27:\"top_bar-font-is_capitalized\";a:4:{s:2:\"id\";s:27:\"top_bar-font-is_capitalized\";s:4:\"name\";s:11:\"Capitalize \";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:18:\"top_bar-font-color\";a:4:{s:2:\"id\";s:18:\"top_bar-font-color\";s:4:\"name\";s:18:\"Top bar font color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#686868\";}s:20:\"top_bar-paddings-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:20:\"top_bar-paddings-top\";}s:23:\"top_bar-paddings-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:23:\"top_bar-paddings-bottom\";}s:27:\"top_bar-paddings-horizontal\";a:6:{s:2:\"id\";s:27:\"top_bar-paddings-horizontal\";s:4:\"name\";s:18:\"Side paddings (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:16:\"top_bar-bg-style\";a:6:{s:2:\"id\";s:16:\"top_bar-bg-style\";s:4:\"name\";s:25:\"Top bar background / line\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:12:\"content_line\";s:7:\"options\";a:4:{s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:53:\"/inc/admin/assets/images/topbar-bg-style-disabled.gif\";}s:12:\"content_line\";a:2:{s:5:\"title\";s:18:\"Content-width line\";s:3:\"src\";s:56:\"/inc/admin/assets/images/topbar-bg-style-contentline.gif\";}s:14:\"fullwidth_line\";a:2:{s:5:\"title\";s:15:\"Full-width line\";s:3:\"src\";s:58:\"/inc/admin/assets/images/topbar-bg-style-fullwidthline.gif\";}s:5:\"solid\";a:2:{s:5:\"title\";s:10:\"Background\";s:3:\"src\";s:50:\"/inc/admin/assets/images/topbar-bg-style-solid.gif\";}}s:5:\"class\";s:5:\"small\";}s:16:\"top_bar-bg-color\";a:6:{s:2:\"id\";s:16:\"top_bar-bg-color\";s:4:\"name\";s:23:\"Background (line) color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:7:\"divider\";s:3:\"top\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:16:\"top_bar-bg-style\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:8:\"disabled\";}}}}s:18:\"top_bar-bg-opacity\";a:5:{s:2:\"id\";s:18:\"top_bar-bg-opacity\";s:4:\"name\";s:25:\"Background (line) opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:16:\"top_bar-bg-style\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:8:\"disabled\";}}}}s:16:\"top_bar-bg-image\";a:5:{s:2:\"id\";s:16:\"top_bar-bg-image\";s:4:\"name\";s:20:\"Add background image\";s:4:\"type\";s:14:\"background_img\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:16:\"top_bar-bg-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"solid\";}}}}s:15:\"header-bg-color\";a:4:{s:2:\"id\";s:15:\"header-bg-color\";s:4:\"name\";s:16:\"Background color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#000000\";}s:17:\"header-bg-opacity\";a:4:{s:2:\"id\";s:17:\"header-bg-opacity\";s:4:\"name\";s:18:\"Background opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:15:\"header-bg-image\";a:4:{s:2:\"id\";s:15:\"header-bg-image\";s:4:\"name\";s:20:\"Add background image\";s:4:\"type\";s:14:\"background_img\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}}s:23:\"header-bg-is_fullscreen\";a:4:{s:2:\"id\";s:23:\"header-bg-is_fullscreen\";s:4:\"name\";s:11:\"Fullscreen \";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:18:\"header-bg-is_fixed\";a:4:{s:2:\"id\";s:18:\"header-bg-is_fixed\";s:4:\"name\";s:17:\"Fixed background \";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:17:\"header-decoration\";a:6:{s:2:\"id\";s:17:\"header-decoration\";s:4:\"name\";s:17:\"Header decoration\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:6:\"shadow\";s:7:\"options\";a:3:{s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:55:\"/inc/admin/assets/images/header-decoration-disabled.gif\";}s:6:\"shadow\";a:2:{s:5:\"title\";s:6:\"Shadow\";s:3:\"src\";s:53:\"/inc/admin/assets/images/header-decoration-shadow.gif\";}s:4:\"line\";a:2:{s:5:\"title\";s:4:\"Line\";s:3:\"src\";s:51:\"/inc/admin/assets/images/header-decoration-line.gif\";}}s:5:\"class\";s:5:\"small\";}s:23:\"header-decoration-color\";a:5:{s:2:\"id\";s:23:\"header-decoration-color\";s:4:\"name\";s:10:\"Line color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:17:\"header-decoration\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"line\";}}}}s:25:\"header-decoration-opacity\";a:5:{s:2:\"id\";s:25:\"header-decoration-opacity\";s:4:\"name\";s:12:\"Line opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:17:\"header-decoration\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"line\";}}}}s:28:\"header-classic-menu-bg-style\";a:6:{s:2:\"id\";s:28:\"header-classic-menu-bg-style\";s:4:\"name\";s:22:\"Menu background / line\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:8:\"disabled\";s:7:\"options\";a:4:{s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-classic-menu-bg-style-disabled.gif\";}s:12:\"content_line\";a:2:{s:5:\"title\";s:18:\"Content-width line\";s:3:\"src\";s:69:\"/inc/admin/assets/images/header-classic-menu-bg-style-contentline.gif\";}s:14:\"fullwidth_line\";a:2:{s:5:\"title\";s:15:\"Full-width line\";s:3:\"src\";s:71:\"/inc/admin/assets/images/header-classic-menu-bg-style-fullwidthline.gif\";}s:5:\"solid\";a:2:{s:5:\"title\";s:10:\"Background\";s:3:\"src\";s:63:\"/inc/admin/assets/images/header-classic-menu-bg-style-solid.gif\";}}s:5:\"class\";s:5:\"small\";}s:28:\"header-classic-menu-bg-color\";a:5:{s:2:\"id\";s:28:\"header-classic-menu-bg-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:28:\"header-classic-menu-bg-style\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:8:\"disabled\";}}}}s:30:\"header-classic-menu-bg-opacity\";a:5:{s:2:\"id\";s:30:\"header-classic-menu-bg-opacity\";s:4:\"name\";s:7:\"Opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:28:\"header-classic-menu-bg-style\";s:8:\"operator\";s:2:\"!=\";s:5:\"value\";s:8:\"disabled\";}}}}s:21:\"header-menu_icon-size\";a:5:{s:2:\"id\";s:21:\"header-menu_icon-size\";s:4:\"name\";s:9:\"Icon size\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:5:\"small\";s:7:\"options\";a:3:{s:5:\"small\";s:5:\"Small\";s:6:\"medium\";s:6:\"Medium\";s:5:\"large\";s:5:\"Large\";}}s:22:\"header-menu_icon-color\";a:4:{s:2:\"id\";s:22:\"header-menu_icon-color\";s:4:\"name\";s:22:\"\"Open menu\" icon color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:25:\"header-menu_icon-bg-color\";a:4:{s:2:\"id\";s:25:\"header-menu_icon-bg-color\";s:4:\"name\";s:22:\"\"Open menu\" background\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:27:\"header-menu_icon-bg-opacity\";a:4:{s:2:\"id\";s:27:\"header-menu_icon-bg-opacity\";s:4:\"name\";s:30:\"\"Open menu\" background opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:28:\"header-menu_icon-hover-color\";a:4:{s:2:\"id\";s:28:\"header-menu_icon-hover-color\";s:4:\"name\";s:23:\"\"Close menu\" icon color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:31:\"header-menu_icon-hover-bg-color\";a:4:{s:2:\"id\";s:31:\"header-menu_icon-hover-bg-color\";s:4:\"name\";s:23:\"\"Close menu\" background\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:33:\"header-menu_icon-hover-bg-opacity\";a:4:{s:2:\"id\";s:33:\"header-menu_icon-hover-bg-opacity\";s:4:\"name\";s:31:\"\"Close menu\" background opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:27:\"header-menu_icon-margin-top\";a:6:{s:4:\"name\";s:15:\"Top margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:27:\"header-menu_icon-margin-top\";}s:29:\"header-menu_icon-margin-right\";a:6:{s:4:\"name\";s:17:\"Right margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:29:\"header-menu_icon-margin-right\";}s:30:\"header-menu_icon-margin-bottom\";a:6:{s:4:\"name\";s:18:\"Bottom margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:30:\"header-menu_icon-margin-bottom\";}s:28:\"header-menu_icon-margin-left\";a:6:{s:4:\"name\";s:16:\"Left margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:28:\"header-menu_icon-margin-left\";}s:24:\"header-menu_icon-bg-size\";a:6:{s:2:\"id\";s:24:\"header-menu_icon-bg-size\";s:4:\"name\";s:20:\"Background size (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:2:\"54\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:33:\"header-menu_icon-bg-border-radius\";a:6:{s:2:\"id\";s:33:\"header-menu_icon-bg-border-radius\";s:4:\"name\";s:29:\"Background border radius (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:23:\"header-mixed-decoration\";a:6:{s:2:\"id\";s:23:\"header-mixed-decoration\";s:4:\"name\";s:17:\"Header decoration\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:6:\"shadow\";s:7:\"options\";a:3:{s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-mixed-decoration-disabled.gif\";}s:6:\"shadow\";a:2:{s:5:\"title\";s:6:\"Shadow\";s:3:\"src\";s:59:\"/inc/admin/assets/images/header-mixed-decoration-shadow.gif\";}s:4:\"line\";a:2:{s:5:\"title\";s:4:\"Line\";s:3:\"src\";s:57:\"/inc/admin/assets/images/header-mixed-decoration-line.gif\";}}s:5:\"class\";s:5:\"small\";}s:29:\"header-mixed-decoration-color\";a:5:{s:2:\"id\";s:29:\"header-mixed-decoration-color\";s:4:\"name\";s:10:\"Line color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:23:\"header-mixed-decoration\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"line\";}}}}s:31:\"header-mixed-decoration-opacity\";a:5:{s:2:\"id\";s:31:\"header-mixed-decoration-opacity\";s:4:\"name\";s:12:\"Line opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:23:\"header-mixed-decoration\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"line\";}}}}s:21:\"header-mixed-bg-color\";a:4:{s:2:\"id\";s:21:\"header-mixed-bg-color\";s:4:\"name\";s:16:\"Background color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#000000\";}s:23:\"header-mixed-bg-opacity\";a:4:{s:2:\"id\";s:23:\"header-mixed-bg-opacity\";s:4:\"name\";s:18:\"Background opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:39:\"header-slide_out-overlay-bg-color-style\";a:6:{s:4:\"name\";s:24:\"Background overlay color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}s:2:\"id\";s:39:\"header-slide_out-overlay-bg-color-style\";}s:33:\"header-slide_out-overlay-bg-color\";a:5:{s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:39:\"header-slide_out-overlay-bg-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}s:2:\"id\";s:33:\"header-slide_out-overlay-bg-color\";}s:36:\"header-slide_out-overlay-bg-gradient\";a:5:{s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:39:\"header-slide_out-overlay-bg-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}s:2:\"id\";s:36:\"header-slide_out-overlay-bg-gradient\";}s:35:\"header-slide_out-overlay-bg-opacity\";a:4:{s:2:\"id\";s:35:\"header-slide_out-overlay-bg-opacity\";s:4:\"name\";s:26:\"Background overlay opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:50;}s:29:\"header-slide_out-overlay-blur\";a:7:{s:2:\"id\";s:29:\"header-slide_out-overlay-blur\";s:4:\"name\";s:11:\"Blur effect\";s:4:\"desc\";s:50:\"Also works for overlay navigation and mobile menu.\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-slide_out-overlay-blur-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-slide_out-overlay-blur-disabled.gif\";}}s:5:\"class\";s:5:\"small\";}s:33:\"header-slide_out-overlay-x_cursor\";a:5:{s:2:\"id\";s:33:\"header-slide_out-overlay-x_cursor\";s:4:\"name\";s:15:\"\"X\" cursor icon\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;s:7:\"Enabled\";i:0;s:8:\"Disabled\";}}s:39:\"header-slide_out-overlay-x_cursor-color\";a:5:{s:2:\"id\";s:39:\"header-slide_out-overlay-x_cursor-color\";s:4:\"name\";s:10:\"Icon color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#000000\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-slide_out-overlay-x_cursor\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}}}s:41:\"header-slide_out-overlay-x_cursor-opacity\";a:5:{s:2:\"id\";s:41:\"header-slide_out-overlay-x_cursor-opacity\";s:4:\"name\";s:12:\"Icon opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:90;s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-slide_out-overlay-x_cursor\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}}}s:23:\"header-menu-font-family\";a:5:{s:2:\"id\";s:23:\"header-menu-font-family\";s:4:\"name\";s:4:\"Font\";s:4:\"type\";s:9:\"web_fonts\";s:3:\"std\";s:9:\"Open Sans\";s:5:\"fonts\";s:3:\"all\";}s:21:\"header-menu-font-size\";a:6:{s:2:\"id\";s:21:\"header-menu-font-size\";s:4:\"name\";s:9:\"Font size\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:16;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:31:\"header-menu-font-is_capitalized\";a:4:{s:2:\"id\";s:31:\"header-menu-font-is_capitalized\";s:4:\"name\";s:11:\"Capitalize \";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:32:\"header-menu-subtitle-font-family\";a:5:{s:2:\"id\";s:32:\"header-menu-subtitle-font-family\";s:4:\"name\";s:14:\"Subtitles font\";s:4:\"type\";s:9:\"web_fonts\";s:3:\"std\";s:5:\"Arial\";s:5:\"fonts\";s:3:\"all\";}s:30:\"header-menu-subtitle-font-size\";a:6:{s:2:\"id\";s:30:\"header-menu-subtitle-font-size\";s:4:\"name\";s:19:\"Subtitles font size\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:10;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:22:\"header-menu-font-color\";a:4:{s:2:\"id\";s:22:\"header-menu-font-color\";s:4:\"name\";s:17:\"Normal font color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:34:\"header-menu-hover-font-color-style\";a:7:{s:2:\"id\";s:34:\"header-menu-hover-font-color-style\";s:4:\"name\";s:16:\"Hover font color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"divider\";s:3:\"top\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:28:\"header-menu-hover-font-color\";a:5:{s:2:\"id\";s:28:\"header-menu-hover-font-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:34:\"header-menu-hover-font-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:31:\"header-menu-hover-font-gradient\";a:5:{s:2:\"id\";s:31:\"header-menu-hover-font-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:34:\"header-menu-hover-font-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:40:\"header-menu-active_item-font-color-style\";a:7:{s:2:\"id\";s:40:\"header-menu-active_item-font-color-style\";s:4:\"name\";s:22:\"Active item font color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"divider\";s:3:\"top\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:34:\"header-menu-active_item-font-color\";a:5:{s:2:\"id\";s:34:\"header-menu-active_item-font-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:40:\"header-menu-active_item-font-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:37:\"header-menu-active_item-font-gradient\";a:5:{s:2:\"id\";s:37:\"header-menu-active_item-font-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:40:\"header-menu-active_item-font-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:21:\"header-menu-icon-size\";a:6:{s:2:\"id\";s:21:\"header-menu-icon-size\";s:4:\"name\";s:14:\"Menu icon size\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:16;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:31:\"header-menu-show_next_lvl_icons\";a:5:{s:2:\"id\";s:31:\"header-menu-show_next_lvl_icons\";s:4:\"name\";s:31:\"Show next level indicator icons\";s:4:\"desc\";s:91:\"Icons are always visible if parent menu items are clickable (for side and overlay headers).\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:28:\"header-menu-item-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"5\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:28:\"header-menu-item-padding-top\";}s:30:\"header-menu-item-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:2:\"10\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:30:\"header-menu-item-padding-right\";}s:31:\"header-menu-item-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"5\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:31:\"header-menu-item-padding-bottom\";}s:29:\"header-menu-item-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:2:\"10\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:29:\"header-menu-item-padding-left\";}s:27:\"header-menu-item-margin-top\";a:6:{s:4:\"name\";s:15:\"Top margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:27:\"header-menu-item-margin-top\";}s:29:\"header-menu-item-margin-right\";a:6:{s:4:\"name\";s:17:\"Right margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:29:\"header-menu-item-margin-right\";}s:30:\"header-menu-item-margin-bottom\";a:6:{s:4:\"name\";s:18:\"Bottom margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:30:\"header-menu-item-margin-bottom\";}s:28:\"header-menu-item-margin-left\";a:6:{s:4:\"name\";s:16:\"Left margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:28:\"header-menu-item-margin-left\";}s:39:\"header-menu-item-surround_margins-style\";a:9:{s:2:\"id\";s:39:\"header-menu-item-surround_margins-style\";s:4:\"name\";s:42:\"Side margins for first and last menu items\";s:4:\"desc\";s:26:\"Works for top headers only\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:7:\"regular\";s:7:\"options\";a:4:{s:7:\"regular\";a:2:{s:5:\"title\";s:7:\"Regular\";s:3:\"src\";s:75:\"/inc/admin/assets/images/header-menu-item-surroundmargins-style-regular.gif\";}s:6:\"double\";a:2:{s:5:\"title\";s:6:\"Double\";s:3:\"src\";s:74:\"/inc/admin/assets/images/header-menu-item-surroundmargins-style-double.gif\";}s:6:\"custom\";a:2:{s:5:\"title\";s:6:\"Custom\";s:3:\"src\";s:74:\"/inc/admin/assets/images/header-menu-item-surroundmargins-style-custom.gif\";}s:8:\"disabled\";a:2:{s:5:\"title\";s:6:\"Remove\";s:3:\"src\";s:76:\"/inc/admin/assets/images/header-menu-item-surroundmargins-style-disabled.gif\";}}s:7:\"divider\";s:3:\"top\";s:5:\"style\";s:8:\"vertical\";}s:47:\"header-menu-item-surround_margins-custom-margin\";a:7:{s:2:\"id\";s:47:\"header-menu-item-surround_margins-custom-margin\";s:4:\"name\";s:18:\"Custom margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:39:\"header-menu-item-surround_margins-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"custom\";}}}}s:47:\"header-menu-decoration-other-links-is_justified\";a:8:{s:2:\"id\";s:47:\"header-menu-decoration-other-links-is_justified\";s:4:\"name\";s:30:\"Full height & full width links\";s:4:\"desc\";s:26:\"Works for top headers only\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:83:\"/inc/admin/assets/images/header-menu-decoration-other-links-isjustified-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:84:\"/inc/admin/assets/images/header-menu-decoration-other-links-isjustified-disabled.gif\";}}s:7:\"divider\";s:3:\"top\";}s:25:\"header-menu-show_dividers\";a:7:{s:2:\"id\";s:25:\"header-menu-show_dividers\";s:4:\"name\";s:8:\"Dividers\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-menu-showdividers-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-menu-showdividers-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:33:\"header-menu-dividers-height-style\";a:6:{s:2:\"id\";s:33:\"header-menu-dividers-height-style\";s:4:\"name\";s:22:\"Divider height (width)\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:4:\"full\";s:7:\"options\";a:2:{s:4:\"full\";a:2:{s:5:\"title\";s:4:\"100%\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-menu-dividers-height-style-full.gif\";}s:6:\"custom\";a:2:{s:5:\"title\";s:14:\"Custom (in px)\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-menu-showdividers-enabled.gif\";}}}s:27:\"header-menu-dividers-height\";a:6:{s:2:\"id\";s:27:\"header-menu-dividers-height\";s:4:\"name\";s:11:\"Height (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";i:20;s:8:\"sanitize\";s:6:\"slider\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-menu-dividers-height-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"custom\";}}}}s:29:\"header-menu-dividers-surround\";a:6:{s:2:\"id\";s:29:\"header-menu-dividers-surround\";s:4:\"name\";s:21:\"First & last dividers\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:61:\"/inc/admin/assets/images/header-menu-showdividers-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-menu-dividers-surround-disabled.gif\";}}}s:26:\"header-menu-dividers-color\";a:4:{s:2:\"id\";s:26:\"header-menu-dividers-color\";s:4:\"name\";s:14:\"Dividers color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#999999\";}s:28:\"header-menu-dividers-opacity\";a:4:{s:2:\"id\";s:28:\"header-menu-dividers-opacity\";s:4:\"name\";s:16:\"Dividers opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:30;}s:28:\"header-menu-decoration-style\";a:7:{s:2:\"id\";s:28:\"header-menu-decoration-style\";s:4:\"name\";s:10:\"Decoration\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:4:\"none\";s:7:\"options\";a:3:{s:4:\"none\";a:2:{s:5:\"title\";s:4:\"None\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-menu-decoration-style-none.gif\";}s:9:\"underline\";a:2:{s:5:\"title\";s:9:\"Underline\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-menu-decoration-style-underline.gif\";}s:5:\"other\";a:2:{s:5:\"title\";s:27:\"Background / outline / line\";s:3:\"src\";s:63:\"/inc/admin/assets/images/header-menu-decoration-style-other.gif\";}}s:9:\"show_hide\";a:2:{s:9:\"underline\";s:20:\"decoration-underline\";s:5:\"other\";s:16:\"decoration-other\";}}s:42:\"header-menu-decoration-underline-direction\";a:7:{s:2:\"id\";s:42:\"header-menu-decoration-underline-direction\";s:4:\"name\";s:9:\"Direction\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"divider\";s:3:\"top\";s:3:\"std\";s:13:\"left_to_right\";s:7:\"options\";a:4:{s:13:\"left_to_right\";a:2:{s:5:\"title\";s:13:\"Left to right\";s:3:\"src\";s:83:\"/inc/admin/assets/images/header-menu-decoration-underline-direction-lefttoright.gif\";}s:11:\"from_center\";a:2:{s:5:\"title\";s:11:\"From center\";s:3:\"src\";s:82:\"/inc/admin/assets/images/header-menu-decoration-underline-direction-fromcenter.gif\";}s:7:\"upwards\";a:2:{s:5:\"title\";s:7:\"Upwards\";s:3:\"src\";s:79:\"/inc/admin/assets/images/header-menu-decoration-underline-direction-upwards.gif\";}s:9:\"downwards\";a:2:{s:5:\"title\";s:9:\"Downwards\";s:3:\"src\";s:81:\"/inc/admin/assets/images/header-menu-decoration-underline-direction-downwards.gif\";}}}s:44:\"header-menu-decoration-underline-color-style\";a:7:{s:2:\"id\";s:44:\"header-menu-decoration-underline-color-style\";s:4:\"name\";s:15:\"Underline color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"divider\";s:3:\"top\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:38:\"header-menu-decoration-underline-color\";a:5:{s:2:\"id\";s:38:\"header-menu-decoration-underline-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:44:\"header-menu-decoration-underline-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:41:\"header-menu-decoration-underline-gradient\";a:5:{s:2:\"id\";s:41:\"header-menu-decoration-underline-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:44:\"header-menu-decoration-underline-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:42:\"header-menu-decoration-underline-line_size\";a:4:{s:2:\"id\";s:42:\"header-menu-decoration-underline-line_size\";s:4:\"name\";s:14:\"Line size (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"2\";}s:40:\"header-menu-decoration-other-hover-style\";a:6:{s:2:\"id\";s:40:\"header-menu-decoration-other-hover-style\";s:4:\"name\";s:11:\"Hover style\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:7:\"outline\";s:7:\"options\";a:2:{s:7:\"outline\";a:2:{s:5:\"title\";s:7:\"Outline\";s:3:\"src\";s:77:\"/inc/admin/assets/images/header-menu-decoration-other-hover-style-outline.gif\";}s:10:\"background\";a:2:{s:5:\"title\";s:10:\"Background\";s:3:\"src\";s:80:\"/inc/admin/assets/images/header-menu-decoration-other-hover-style-background.gif\";}}}s:46:\"header-menu-decoration-other-hover-color-style\";a:7:{s:2:\"id\";s:46:\"header-menu-decoration-other-hover-color-style\";s:4:\"name\";s:11:\"Hover color\";s:4:\"desc\";s:24:\"Of outline or background\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:40:\"header-menu-decoration-other-hover-color\";a:5:{s:2:\"id\";s:40:\"header-menu-decoration-other-hover-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:46:\"header-menu-decoration-other-hover-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:43:\"header-menu-decoration-other-hover-gradient\";a:5:{s:2:\"id\";s:43:\"header-menu-decoration-other-hover-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:46:\"header-menu-decoration-other-hover-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:36:\"header-menu-decoration-other-opacity\";a:4:{s:2:\"id\";s:36:\"header-menu-decoration-other-opacity\";s:4:\"name\";s:13:\"Hover opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:39:\"header-menu-decoration-other-hover-line\";a:7:{s:2:\"id\";s:39:\"header-menu-decoration-other-hover-line\";s:4:\"name\";s:10:\"Hover line\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:76:\"/inc/admin/assets/images/header-menu-decoration-other-hover-line-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:77:\"/inc/admin/assets/images/header-menu-decoration-other-hover-line-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:51:\"header-menu-decoration-other-hover-line-color-style\";a:6:{s:2:\"id\";s:51:\"header-menu-decoration-other-hover-line-color-style\";s:4:\"name\";s:16:\"Hover line color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:45:\"header-menu-decoration-other-hover-line-color\";a:5:{s:2:\"id\";s:45:\"header-menu-decoration-other-hover-line-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:51:\"header-menu-decoration-other-hover-line-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:48:\"header-menu-decoration-other-hover-line-gradient\";a:5:{s:2:\"id\";s:48:\"header-menu-decoration-other-hover-line-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:51:\"header-menu-decoration-other-hover-line-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:47:\"header-menu-decoration-other-hover-line-opacity\";a:4:{s:2:\"id\";s:47:\"header-menu-decoration-other-hover-line-opacity\";s:4:\"name\";s:18:\"Hover line opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:41:\"header-menu-decoration-other-active-style\";a:6:{s:2:\"id\";s:41:\"header-menu-decoration-other-active-style\";s:4:\"name\";s:12:\"Active style\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:7:\"outline\";s:7:\"options\";a:2:{s:7:\"outline\";a:2:{s:5:\"title\";s:7:\"Outline\";s:3:\"src\";s:78:\"/inc/admin/assets/images/header-menu-decoration-other-active-style-outline.gif\";}s:10:\"background\";a:2:{s:5:\"title\";s:10:\"Background\";s:3:\"src\";s:81:\"/inc/admin/assets/images/header-menu-decoration-other-active-style-background.gif\";}}}s:47:\"header-menu-decoration-other-active-color-style\";a:7:{s:2:\"id\";s:47:\"header-menu-decoration-other-active-color-style\";s:4:\"name\";s:12:\"Active color\";s:4:\"desc\";s:24:\"Of outline or background\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:41:\"header-menu-decoration-other-active-color\";a:5:{s:2:\"id\";s:41:\"header-menu-decoration-other-active-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:47:\"header-menu-decoration-other-active-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:44:\"header-menu-decoration-other-active-gradient\";a:5:{s:2:\"id\";s:44:\"header-menu-decoration-other-active-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:47:\"header-menu-decoration-other-active-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:43:\"header-menu-decoration-other-active-opacity\";a:4:{s:2:\"id\";s:43:\"header-menu-decoration-other-active-opacity\";s:4:\"name\";s:14:\"Active opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:40:\"header-menu-decoration-other-active-line\";a:7:{s:2:\"id\";s:40:\"header-menu-decoration-other-active-line\";s:4:\"name\";s:11:\"Active line\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:77:\"/inc/admin/assets/images/header-menu-decoration-other-active-line-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:78:\"/inc/admin/assets/images/header-menu-decoration-other-active-line-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:52:\"header-menu-decoration-other-active-line-color-style\";a:6:{s:2:\"id\";s:52:\"header-menu-decoration-other-active-line-color-style\";s:4:\"name\";s:17:\"Active line color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:46:\"header-menu-decoration-other-active-line-color\";a:5:{s:2:\"id\";s:46:\"header-menu-decoration-other-active-line-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:52:\"header-menu-decoration-other-active-line-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:49:\"header-menu-decoration-other-active-line-gradient\";a:5:{s:2:\"id\";s:49:\"header-menu-decoration-other-active-line-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:52:\"header-menu-decoration-other-active-line-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:48:\"header-menu-decoration-other-active-line-opacity\";a:4:{s:2:\"id\";s:48:\"header-menu-decoration-other-active-line-opacity\";s:4:\"name\";s:19:\"Active line opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:40:\"header-menu-decoration-other-click_decor\";a:7:{s:2:\"id\";s:40:\"header-menu-decoration-other-click_decor\";s:4:\"name\";s:18:\"Animation on click\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"0\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:76:\"/inc/admin/assets/images/header-menu-decoration-other-clickdecor-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:77:\"/inc/admin/assets/images/header-menu-decoration-other-clickdecor-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:52:\"header-menu-decoration-other-click_decor-color-style\";a:6:{s:2:\"id\";s:52:\"header-menu-decoration-other-click_decor-color-style\";s:4:\"name\";s:15:\"Animation color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:46:\"header-menu-decoration-other-click_decor-color\";a:5:{s:2:\"id\";s:46:\"header-menu-decoration-other-click_decor-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:52:\"header-menu-decoration-other-click_decor-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:49:\"header-menu-decoration-other-click_decor-gradient\";a:5:{s:2:\"id\";s:49:\"header-menu-decoration-other-click_decor-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:52:\"header-menu-decoration-other-click_decor-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:48:\"header-menu-decoration-other-click_decor-opacity\";a:4:{s:2:\"id\";s:48:\"header-menu-decoration-other-click_decor-opacity\";s:4:\"name\";s:17:\"Animation opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:42:\"header-menu-decoration-other-border-radius\";a:6:{s:2:\"id\";s:42:\"header-menu-decoration-other-border-radius\";s:4:\"name\";s:13:\"Border radius\";s:4:\"type\";s:6:\"slider\";s:7:\"divider\";s:3:\"top\";s:3:\"std\";i:0;s:7:\"options\";a:2:{s:3:\"min\";i:0;s:3:\"max\";i:120;}}s:38:\"header-menu-decoration-other-line_size\";a:5:{s:2:\"id\";s:38:\"header-menu-decoration-other-line_size\";s:4:\"name\";s:14:\"Line size (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"2\";s:7:\"divider\";s:3:\"top\";}s:31:\"header-menu-submenu-font-family\";a:5:{s:2:\"id\";s:31:\"header-menu-submenu-font-family\";s:4:\"name\";s:4:\"Font\";s:4:\"type\";s:9:\"web_fonts\";s:3:\"std\";s:9:\"Open Sans\";s:5:\"fonts\";s:3:\"all\";}s:29:\"header-menu-submenu-font-size\";a:6:{s:2:\"id\";s:29:\"header-menu-submenu-font-size\";s:4:\"name\";s:9:\"Font size\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:16;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:37:\"header-menu-submenu-font-is_uppercase\";a:4:{s:2:\"id\";s:37:\"header-menu-submenu-font-is_uppercase\";s:4:\"name\";s:10:\"Capitalize\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:40:\"header-menu-submenu-subtitle-font-family\";a:5:{s:2:\"id\";s:40:\"header-menu-submenu-subtitle-font-family\";s:4:\"name\";s:14:\"Subtitles font\";s:4:\"type\";s:9:\"web_fonts\";s:3:\"std\";s:5:\"Arial\";s:5:\"fonts\";s:3:\"all\";}s:38:\"header-menu-submenu-subtitle-font-size\";a:6:{s:2:\"id\";s:38:\"header-menu-submenu-subtitle-font-size\";s:4:\"name\";s:19:\"Subtitles font size\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:10;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:30:\"header-menu-submenu-font-color\";a:4:{s:2:\"id\";s:30:\"header-menu-submenu-font-color\";s:4:\"name\";s:17:\"Normal font color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:42:\"header-menu-submenu-hover-font-color-style\";a:6:{s:2:\"id\";s:42:\"header-menu-submenu-hover-font-color-style\";s:4:\"name\";s:16:\"Hover font color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:36:\"header-menu-submenu-hover-font-color\";a:5:{s:2:\"id\";s:36:\"header-menu-submenu-hover-font-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:42:\"header-menu-submenu-hover-font-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:39:\"header-menu-submenu-hover-font-gradient\";a:5:{s:2:\"id\";s:39:\"header-menu-submenu-hover-font-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:42:\"header-menu-submenu-hover-font-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:43:\"header-menu-submenu-active-font-color-style\";a:6:{s:2:\"id\";s:43:\"header-menu-submenu-active-font-color-style\";s:4:\"name\";s:17:\"Active font color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:37:\"header-menu-submenu-active-font-color\";a:5:{s:2:\"id\";s:37:\"header-menu-submenu-active-font-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:43:\"header-menu-submenu-active-font-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:40:\"header-menu-submenu-active-font-gradient\";a:5:{s:2:\"id\";s:40:\"header-menu-submenu-active-font-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:43:\"header-menu-submenu-active-font-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:29:\"header-menu-submenu-icon-size\";a:5:{s:2:\"id\";s:29:\"header-menu-submenu-icon-size\";s:4:\"name\";s:14:\"Menu icon size\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:14;s:7:\"options\";a:2:{s:3:\"min\";i:8;s:3:\"max\";i:50;}}s:39:\"header-menu-submenu-show_next_lvl_icons\";a:5:{s:2:\"id\";s:39:\"header-menu-submenu-show_next_lvl_icons\";s:4:\"name\";s:31:\"Show next level indicator icons\";s:4:\"desc\";s:91:\"Icons are always visible if parent menu items are clickable (for side and overlay headers).\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:39:\"header-menu-submenu-parent_is_clickable\";a:4:{s:2:\"id\";s:39:\"header-menu-submenu-parent_is_clickable\";s:4:\"name\";s:32:\"Make parent menu items clickable\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:36:\"header-menu-submenu-item-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"5\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:36:\"header-menu-submenu-item-padding-top\";}s:38:\"header-menu-submenu-item-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:2:\"10\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:38:\"header-menu-submenu-item-padding-right\";}s:39:\"header-menu-submenu-item-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"5\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:39:\"header-menu-submenu-item-padding-bottom\";}s:37:\"header-menu-submenu-item-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:2:\"10\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:37:\"header-menu-submenu-item-padding-left\";}s:35:\"header-menu-submenu-item-margin-top\";a:6:{s:4:\"name\";s:15:\"Top margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:35:\"header-menu-submenu-item-margin-top\";}s:37:\"header-menu-submenu-item-margin-right\";a:6:{s:4:\"name\";s:17:\"Right margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:37:\"header-menu-submenu-item-margin-right\";}s:38:\"header-menu-submenu-item-margin-bottom\";a:6:{s:4:\"name\";s:18:\"Bottom margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:38:\"header-menu-submenu-item-margin-bottom\";}s:36:\"header-menu-submenu-item-margin-left\";a:6:{s:4:\"name\";s:16:\"Left margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:36:\"header-menu-submenu-item-margin-left\";}s:28:\"header-menu-submenu-bg-color\";a:4:{s:2:\"id\";s:28:\"header-menu-submenu-bg-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:30:\"header-menu-submenu-bg-opacity\";a:4:{s:2:\"id\";s:30:\"header-menu-submenu-bg-opacity\";s:4:\"name\";s:7:\"Opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:30;}s:28:\"header-menu-submenu-bg-width\";a:6:{s:2:\"id\";s:28:\"header-menu-submenu-bg-width\";s:4:\"name\";s:5:\"Width\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"240\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:28:\"header-menu-submenu-bg-hover\";a:6:{s:2:\"id\";s:28:\"header-menu-submenu-bg-hover\";s:4:\"name\";s:16:\"Hover background\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:4:\"none\";s:7:\"options\";a:3:{s:4:\"none\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:62:\"/inc/admin/assets/images/header-menu-decoration-style-none.gif\";}s:10:\"background\";a:2:{s:5:\"title\";s:16:\"Plain background\";s:3:\"src\";s:80:\"/inc/admin/assets/images/header-menu-decoration-other-hover-style-background.gif\";}s:19:\"animated_background\";a:2:{s:5:\"title\";s:34:\"Background with animation on click\";s:3:\"src\";s:92:\"/inc/admin/assets/images/header-menu-submenu-bg-hover-background-with-animation-on-click.gif\";}}}s:33:\"header-side-menu-submenu-position\";a:6:{s:2:\"id\";s:33:\"header-side-menu-submenu-position\";s:4:\"name\";s:4:\"Show\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:4:\"side\";s:7:\"options\";a:2:{s:4:\"side\";a:2:{s:5:\"title\";s:8:\"Sideways\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-side-menu-submenu-position-side.gif\";}s:4:\"down\";a:2:{s:5:\"title\";s:9:\"Downwards\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-side-menu-submenu-position-down.gif\";}}}s:37:\"header-elements-near_menu-font_family\";a:5:{s:2:\"id\";s:37:\"header-elements-near_menu-font_family\";s:4:\"name\";s:4:\"Font\";s:4:\"type\";s:9:\"web_fonts\";s:3:\"std\";s:5:\"Arial\";s:5:\"fonts\";s:3:\"all\";}s:35:\"header-elements-near_menu-font_size\";a:6:{s:2:\"id\";s:35:\"header-elements-near_menu-font_size\";s:4:\"name\";s:9:\"Font size\";s:4:\"type\";s:6:\"slider\";s:8:\"sanitize\";s:9:\"font_size\";s:3:\"std\";i:14;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}}s:36:\"header-elements-near_menu-font_color\";a:4:{s:2:\"id\";s:36:\"header-elements-near_menu-font_color\";s:4:\"name\";s:10:\"Font color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#888888\";}s:37:\"header-elements-near_logo-font_family\";a:5:{s:2:\"id\";s:37:\"header-elements-near_logo-font_family\";s:4:\"name\";s:4:\"Font\";s:4:\"type\";s:9:\"web_fonts\";s:3:\"std\";s:5:\"Arial\";s:5:\"fonts\";s:3:\"all\";}s:35:\"header-elements-near_logo-font_size\";a:6:{s:2:\"id\";s:35:\"header-elements-near_logo-font_size\";s:4:\"name\";s:9:\"Font size\";s:4:\"type\";s:6:\"slider\";s:8:\"sanitize\";s:9:\"font_size\";s:3:\"std\";i:16;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}}s:36:\"header-elements-near_logo-font_color\";a:4:{s:2:\"id\";s:36:\"header-elements-near_logo-font_color\";s:4:\"name\";s:10:\"Font color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#888888\";}s:25:\"microwidgets-search-block\";a:4:{s:4:\"name\";s:6:\"Search\";s:2:\"id\";s:25:\"microwidgets-search-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:30:\"header-elements-search-caption\";a:6:{s:4:\"name\";s:7:\"Caption\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:0:\"\";s:8:\"sanitize\";s:8:\"textarea\";s:7:\"divider\";b:0;s:2:\"id\";s:30:\"header-elements-search-caption\";}s:27:\"header-elements-search-icon\";a:4:{s:4:\"name\";s:17:\"Show graphic icon\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";s:1:\"1\";s:2:\"id\";s:27:\"header-elements-search-icon\";}s:34:\"header-elements-search-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:34:\"header-elements-search-on-desktops\";}s:42:\"header-elements-search-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:42:\"header-elements-search-first-header-switch\";}s:43:\"header-elements-search-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:43:\"header-elements-search-second-header-switch\";}s:26:\"microwidgets-address-block\";a:4:{s:4:\"name\";s:7:\"Address\";s:2:\"id\";s:26:\"microwidgets-address-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:39:\"header-elements-contact-address-caption\";a:7:{s:4:\"name\";s:7:\"Address\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:0:\"\";s:8:\"sanitize\";s:8:\"textarea\";s:7:\"divider\";b:0;s:5:\"class\";s:4:\"wide\";s:2:\"id\";s:39:\"header-elements-contact-address-caption\";}s:36:\"header-elements-contact-address-icon\";a:4:{s:4:\"name\";s:17:\"Show graphic icon\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";s:1:\"1\";s:2:\"id\";s:36:\"header-elements-contact-address-icon\";}s:43:\"header-elements-contact-address-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:43:\"header-elements-contact-address-on-desktops\";}s:51:\"header-elements-contact-address-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:51:\"header-elements-contact-address-first-header-switch\";}s:52:\"header-elements-contact-address-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:52:\"header-elements-contact-address-second-header-switch\";}s:24:\"microwidgets-phone-block\";a:4:{s:4:\"name\";s:5:\"Phone\";s:2:\"id\";s:24:\"microwidgets-phone-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:37:\"header-elements-contact-phone-caption\";a:7:{s:4:\"name\";s:5:\"Phone\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:0:\"\";s:8:\"sanitize\";s:8:\"textarea\";s:7:\"divider\";b:0;s:5:\"class\";s:4:\"wide\";s:2:\"id\";s:37:\"header-elements-contact-phone-caption\";}s:34:\"header-elements-contact-phone-icon\";a:4:{s:4:\"name\";s:17:\"Show graphic icon\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";s:1:\"1\";s:2:\"id\";s:34:\"header-elements-contact-phone-icon\";}s:41:\"header-elements-contact-phone-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:41:\"header-elements-contact-phone-on-desktops\";}s:49:\"header-elements-contact-phone-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:49:\"header-elements-contact-phone-first-header-switch\";}s:50:\"header-elements-contact-phone-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:50:\"header-elements-contact-phone-second-header-switch\";}s:24:\"microwidgets-email-block\";a:4:{s:4:\"name\";s:5:\"Email\";s:2:\"id\";s:24:\"microwidgets-email-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:37:\"header-elements-contact-email-caption\";a:7:{s:4:\"name\";s:5:\"Email\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:0:\"\";s:8:\"sanitize\";s:8:\"textarea\";s:7:\"divider\";b:0;s:5:\"class\";s:4:\"wide\";s:2:\"id\";s:37:\"header-elements-contact-email-caption\";}s:34:\"header-elements-contact-email-icon\";a:4:{s:4:\"name\";s:17:\"Show graphic icon\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";s:1:\"1\";s:2:\"id\";s:34:\"header-elements-contact-email-icon\";}s:41:\"header-elements-contact-email-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:41:\"header-elements-contact-email-on-desktops\";}s:49:\"header-elements-contact-email-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:49:\"header-elements-contact-email-first-header-switch\";}s:50:\"header-elements-contact-email-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:50:\"header-elements-contact-email-second-header-switch\";}s:24:\"microwidgets-skype-block\";a:4:{s:4:\"name\";s:5:\"Skype\";s:2:\"id\";s:24:\"microwidgets-skype-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:37:\"header-elements-contact-skype-caption\";a:7:{s:4:\"name\";s:5:\"Skype\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:0:\"\";s:8:\"sanitize\";s:8:\"textarea\";s:7:\"divider\";b:0;s:5:\"class\";s:4:\"wide\";s:2:\"id\";s:37:\"header-elements-contact-skype-caption\";}s:34:\"header-elements-contact-skype-icon\";a:4:{s:4:\"name\";s:17:\"Show graphic icon\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";s:1:\"1\";s:2:\"id\";s:34:\"header-elements-contact-skype-icon\";}s:41:\"header-elements-contact-skype-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:41:\"header-elements-contact-skype-on-desktops\";}s:49:\"header-elements-contact-skype-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:49:\"header-elements-contact-skype-first-header-switch\";}s:50:\"header-elements-contact-skype-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:50:\"header-elements-contact-skype-second-header-switch\";}s:32:\"microwidgets-working_hours-block\";a:4:{s:4:\"name\";s:13:\"Working hours\";s:2:\"id\";s:32:\"microwidgets-working_hours-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:37:\"header-elements-contact-clock-caption\";a:7:{s:4:\"name\";s:13:\"Working hours\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:0:\"\";s:8:\"sanitize\";s:8:\"textarea\";s:7:\"divider\";b:0;s:5:\"class\";s:4:\"wide\";s:2:\"id\";s:37:\"header-elements-contact-clock-caption\";}s:34:\"header-elements-contact-clock-icon\";a:4:{s:4:\"name\";s:17:\"Show graphic icon\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";s:1:\"1\";s:2:\"id\";s:34:\"header-elements-contact-clock-icon\";}s:41:\"header-elements-contact-clock-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:41:\"header-elements-contact-clock-on-desktops\";}s:49:\"header-elements-contact-clock-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:49:\"header-elements-contact-clock-first-header-switch\";}s:50:\"header-elements-contact-clock-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:50:\"header-elements-contact-clock-second-header-switch\";}s:24:\"microwidgets-login-block\";a:4:{s:4:\"name\";s:5:\"Login\";s:2:\"id\";s:24:\"microwidgets-login-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:29:\"header-elements-login-caption\";a:4:{s:2:\"id\";s:29:\"header-elements-login-caption\";s:4:\"name\";s:13:\"Login caption\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:5:\"Login\";}s:30:\"header-elements-logout-caption\";a:4:{s:2:\"id\";s:30:\"header-elements-logout-caption\";s:4:\"name\";s:14:\"Logout caption\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:6:\"Logout\";}s:26:\"header-elements-login-icon\";a:4:{s:2:\"id\";s:26:\"header-elements-login-icon\";s:4:\"name\";s:17:\"Show graphic icon\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";s:1:\"1\";}s:33:\"header-elements-login-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:33:\"header-elements-login-on-desktops\";}s:41:\"header-elements-login-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:41:\"header-elements-login-first-header-switch\";}s:42:\"header-elements-login-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:42:\"header-elements-login-second-header-switch\";}s:25:\"header-elements-login-url\";a:4:{s:2:\"id\";s:25:\"header-elements-login-url\";s:4:\"name\";s:4:\"Link\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:0:\"\";}s:28:\"microwidgets-text_area-block\";a:4:{s:4:\"name\";s:6:\"Text 1\";s:2:\"id\";s:28:\"microwidgets-text_area-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:32:\"header-elements-text-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:32:\"header-elements-text-on-desktops\";}s:40:\"header-elements-text-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:40:\"header-elements-text-first-header-switch\";}s:41:\"header-elements-text-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:41:\"header-elements-text-second-header-switch\";}s:20:\"header-elements-text\";a:5:{s:2:\"id\";s:20:\"header-elements-text\";s:4:\"type\";s:8:\"textarea\";s:3:\"std\";b:0;s:7:\"divider\";s:3:\"top\";s:8:\"sanitize\";s:16:\"without_sanitize\";}s:29:\"microwidgets-text2_area-block\";a:4:{s:4:\"name\";s:6:\"Text 2\";s:2:\"id\";s:29:\"microwidgets-text2_area-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:34:\"header-elements-text-2-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:34:\"header-elements-text-2-on-desktops\";}s:42:\"header-elements-text-2-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:42:\"header-elements-text-2-first-header-switch\";}s:43:\"header-elements-text-2-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:43:\"header-elements-text-2-second-header-switch\";}s:22:\"header-elements-text-2\";a:5:{s:2:\"id\";s:22:\"header-elements-text-2\";s:4:\"type\";s:8:\"textarea\";s:3:\"std\";b:0;s:7:\"divider\";s:3:\"top\";s:8:\"sanitize\";s:16:\"without_sanitize\";}s:29:\"microwidgets-text3_area-block\";a:4:{s:4:\"name\";s:6:\"Text 3\";s:2:\"id\";s:29:\"microwidgets-text3_area-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:34:\"header-elements-text-3-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:34:\"header-elements-text-3-on-desktops\";}s:42:\"header-elements-text-3-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:42:\"header-elements-text-3-first-header-switch\";}s:43:\"header-elements-text-3-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:43:\"header-elements-text-3-second-header-switch\";}s:22:\"header-elements-text-3\";a:5:{s:2:\"id\";s:22:\"header-elements-text-3\";s:4:\"type\";s:8:\"textarea\";s:3:\"std\";b:0;s:7:\"divider\";s:3:\"top\";s:8:\"sanitize\";s:16:\"without_sanitize\";}s:30:\"microwidgets-custom_menu-block\";a:4:{s:4:\"name\";s:11:\"Custom menu\";s:2:\"id\";s:30:\"microwidgets-custom_menu-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:32:\"header-elements-menu-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:32:\"header-elements-menu-on-desktops\";}s:40:\"header-elements-menu-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:40:\"header-elements-menu-first-header-switch\";}s:41:\"header-elements-menu-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:41:\"header-elements-menu-second-header-switch\";}s:26:\"header-elements-menu-style\";a:5:{s:2:\"id\";s:26:\"header-elements-menu-style\";s:4:\"name\";s:10:\"Menu style\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:8:\"dropdown\";s:7:\"options\";a:2:{s:8:\"dropdown\";s:8:\"Dropdown\";s:4:\"list\";s:4:\"List\";}}s:31:\"microwidgets-social_icons-block\";a:4:{s:4:\"name\";s:12:\"Social icons\";s:2:\"id\";s:31:\"microwidgets-social_icons-block\";s:5:\"class\";s:14:\"block-disabled\";s:4:\"type\";s:5:\"block\";}s:37:\"header-elements-soc_icons-on-desktops\";a:5:{s:4:\"name\";s:11:\"On desktops\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:4:\"show\";s:7:\"options\";a:2:{s:4:\"show\";s:4:\"Show\";s:4:\"hide\";s:4:\"Hide\";}s:2:\"id\";s:37:\"header-elements-soc_icons-on-desktops\";}s:45:\"header-elements-soc_icons-first-header-switch\";a:5:{s:4:\"name\";s:34:\"First header switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:9:\"near_logo\";s:7:\"options\";a:3:{s:9:\"near_logo\";s:11:\"Leave as is\";s:7:\"in_menu\";s:16:\"Show in the menu\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:45:\"header-elements-soc_icons-first-header-switch\";}s:46:\"header-elements-soc_icons-second-header-switch\";a:5:{s:4:\"name\";s:34:\"Second header switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"in_menu\";s:7:\"options\";a:3:{s:7:\"in_menu\";s:16:\"Show in the menu\";s:9:\"near_logo\";s:14:\"Show near logo\";s:6:\"hidden\";s:4:\"Hide\";}s:2:\"id\";s:46:\"header-elements-soc_icons-second-header-switch\";}s:31:\"header-elements-soc_icons-color\";a:5:{s:2:\"id\";s:31:\"header-elements-soc_icons-color\";s:4:\"name\";s:11:\"Icons color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#828282\";s:7:\"divider\";s:8:\"surround\";}s:28:\"header-elements-soc_icons-bg\";a:6:{s:2:\"id\";s:28:\"header-elements-soc_icons-bg\";s:4:\"name\";s:22:\"Icons background color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:5:{s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:43:\"/inc/admin/assets/images/color-disabled.gif\";}s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}s:7:\"outline\";a:2:{s:5:\"title\";s:20:\"Custom color outline\";s:3:\"src\";s:49:\"/inc/admin/assets/images/color-custom-outline.gif\";}}}s:34:\"header-elements-soc_icons-bg-color\";a:5:{s:2:\"id\";s:34:\"header-elements-soc_icons-bg-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:2:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:28:\"header-elements-soc_icons-bg\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}i:1;a:1:{i:0;a:3:{s:5:\"field\";s:28:\"header-elements-soc_icons-bg\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:7:\"outline\";}}}}s:36:\"header-elements-soc_icons-bg-opacity\";a:5:{s:2:\"id\";s:36:\"header-elements-soc_icons-bg-opacity\";s:4:\"name\";s:7:\"Opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:28:\"header-elements-soc_icons-bg\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:37:\"header-elements-soc_icons-bg-gradient\";a:5:{s:2:\"id\";s:37:\"header-elements-soc_icons-bg-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:28:\"header-elements-soc_icons-bg\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:37:\"header-elements-soc_icons-hover-color\";a:4:{s:2:\"id\";s:37:\"header-elements-soc_icons-hover-color\";s:4:\"name\";s:11:\"Icons hover\";s:3:\"std\";s:7:\"#828282\";s:4:\"type\";s:5:\"color\";}s:34:\"header-elements-soc_icons-hover-bg\";a:6:{s:2:\"id\";s:34:\"header-elements-soc_icons-hover-bg\";s:4:\"name\";s:28:\"Icons hover background color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:5:{s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:43:\"/inc/admin/assets/images/color-disabled.gif\";}s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}s:7:\"outline\";a:2:{s:5:\"title\";s:20:\"Custom color outline\";s:3:\"src\";s:49:\"/inc/admin/assets/images/color-custom-outline.gif\";}}}s:40:\"header-elements-soc_icons-hover-bg-color\";a:5:{s:2:\"id\";s:40:\"header-elements-soc_icons-hover-bg-color\";s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:2:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:34:\"header-elements-soc_icons-hover-bg\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}i:1;a:1:{i:0;a:3:{s:5:\"field\";s:34:\"header-elements-soc_icons-hover-bg\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:7:\"outline\";}}}}s:42:\"header-elements-soc_icons-bg-hover-opacity\";a:5:{s:2:\"id\";s:42:\"header-elements-soc_icons-bg-hover-opacity\";s:4:\"name\";s:7:\"Opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:34:\"header-elements-soc_icons-hover-bg\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:43:\"header-elements-soc_icons-hover-bg-gradient\";a:5:{s:2:\"id\";s:43:\"header-elements-soc_icons-hover-bg-gradient\";s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:34:\"header-elements-soc_icons-hover-bg\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:25:\"header-elements-soc_icons\";a:4:{s:2:\"id\";s:25:\"header-elements-soc_icons\";s:4:\"type\";s:16:\"fields_generator\";s:3:\"std\";a:1:{i:0;a:2:{s:4:\"icon\";s:0:\"\";s:3:\"url\";s:0:\"\";}}s:7:\"options\";a:1:{s:6:\"fields\";a:2:{s:4:\"icon\";a:6:{s:4:\"type\";s:6:\"select\";s:5:\"class\";s:19:\"of_fields_gen_title\";s:11:\"description\";s:4:\"Icon\";s:4:\"wrap\";s:23:\"<label>%2$s%1$s</label>\";s:9:\"desc_wrap\";s:4:\"%2$s\";s:7:\"options\";a:33:{s:8:\"facebook\";s:8:\"Facebook\";s:7:\"twitter\";s:7:\"Twitter\";s:6:\"google\";s:7:\"Google+\";s:8:\"dribbble\";s:8:\"Dribbble\";s:8:\"you-tube\";s:7:\"YouTube\";s:3:\"rss\";s:3:\"Rss\";s:9:\"delicious\";s:9:\"Delicious\";s:6:\"flickr\";s:6:\"Flickr\";s:6:\"forrst\";s:6:\"Forrst\";s:6:\"lastfm\";s:6:\"Lastfm\";s:8:\"linkedin\";s:8:\"Linkedin\";s:5:\"vimeo\";s:5:\"Vimeo\";s:7:\"tumbler\";s:6:\"Tumblr\";s:9:\"pinterest\";s:9:\"Pinterest\";s:6:\"devian\";s:10:\"Deviantart\";s:5:\"skype\";s:5:\"Skype\";s:6:\"github\";s:6:\"Github\";s:9:\"instagram\";s:9:\"Instagram\";s:11:\"stumbleupon\";s:11:\"Stumbleupon\";s:7:\"behance\";s:7:\"Behance\";s:4:\"mail\";s:4:\"Mail\";s:7:\"website\";s:7:\"Website\";s:6:\"px-500\";s:5:\"500px\";s:11:\"tripedvisor\";s:11:\"TripAdvisor\";s:2:\"vk\";s:2:\"VK\";s:10:\"foursquare\";s:10:\"Foursquare\";s:4:\"xing\";s:4:\"XING\";s:5:\"weibo\";s:5:\"Weibo\";s:13:\"odnoklassniki\";s:13:\"Odnoklassniki\";s:13:\"research-gate\";s:12:\"ResearchGate\";s:4:\"yelp\";s:4:\"Yelp\";s:7:\"blogger\";s:7:\"Blogger\";s:10:\"soundcloud\";s:10:\"SoundCloud\";}}s:3:\"url\";a:4:{s:4:\"type\";s:4:\"text\";s:11:\"description\";s:3:\"Url\";s:4:\"wrap\";s:23:\"<label>%2$s%1$s</label>\";s:9:\"desc_wrap\";s:4:\"%2$s\";}}}}s:31:\"header-show_floating_navigation\";a:7:{s:2:\"id\";s:31:\"header-show_floating_navigation\";s:4:\"name\";s:19:\"Floating navigation\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"1\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-showfloatingnavigation-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-showfloatingnavigation-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:32:\"header-floating_navigation-style\";a:6:{s:2:\"id\";s:32:\"header-floating_navigation-style\";s:4:\"name\";s:6:\"Effect\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:4:\"fade\";s:7:\"options\";a:3:{s:4:\"fade\";a:2:{s:5:\"title\";s:14:\"Fade on scroll\";s:3:\"src\";s:64:\"/inc/admin/assets/images/header-floatingnavigationstyle-fade.gif\";}s:5:\"slide\";a:2:{s:5:\"title\";s:15:\"Slide on scroll\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-floatingnavigationstyle-slide.gif\";}s:6:\"sticky\";a:2:{s:5:\"title\";s:6:\"Sticky\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-floatingnavigationstyle-sticky.gif\";}}}s:37:\"header-floating_navigation-show_after\";a:5:{s:2:\"id\";s:37:\"header-floating_navigation-show_after\";s:4:\"name\";s:25:\"Show after scrolling (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"150\";s:8:\"sanitize\";s:6:\"slider\";}s:33:\"header-floating_navigation-height\";a:5:{s:2:\"id\";s:33:\"header-floating_navigation-height\";s:4:\"name\";s:11:\"Height (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"100\";s:8:\"sanitize\";s:6:\"slider\";}s:35:\"header-floating_navigation-bg-color\";a:4:{s:2:\"id\";s:35:\"header-floating_navigation-bg-color\";s:4:\"name\";s:16:\"Background color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:37:\"header-floating_navigation-bg-opacity\";a:4:{s:2:\"id\";s:37:\"header-floating_navigation-bg-opacity\";s:4:\"name\";s:18:\"Background opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:90;}s:37:\"header-floating_navigation-decoration\";a:6:{s:2:\"id\";s:37:\"header-floating_navigation-decoration\";s:4:\"name\";s:10:\"Decoration\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:8:\"disabled\";s:7:\"options\";a:3:{s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:74:\"/inc/admin/assets/images/header-floatingnavigation-decoration-disabled.gif\";}s:6:\"shadow\";a:2:{s:5:\"title\";s:6:\"Shadow\";s:3:\"src\";s:72:\"/inc/admin/assets/images/header-floatingnavigation-decoration-shadow.gif\";}s:4:\"line\";a:2:{s:5:\"title\";s:4:\"Line\";s:3:\"src\";s:70:\"/inc/admin/assets/images/header-floatingnavigation-decoration-line.gif\";}}}s:43:\"header-floating_navigation-decoration-color\";a:5:{s:2:\"id\";s:43:\"header-floating_navigation-decoration-color\";s:4:\"name\";s:10:\"Line color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:37:\"header-floating_navigation-decoration\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"line\";}}}}s:45:\"header-floating_navigation-decoration-opacity\";a:5:{s:2:\"id\";s:45:\"header-floating_navigation-decoration-opacity\";s:4:\"name\";s:12:\"Line opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:37:\"header-floating_navigation-decoration\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"line\";}}}}s:32:\"header-mobile-first_switch-after\";a:7:{s:4:\"name\";s:17:\"Switch after (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:4:\"1024\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:4:\"desc\";s:77:\"To skip this switch point set the same value as for the second (phone) point.\";s:2:\"id\";s:32:\"header-mobile-first_switch-after\";}s:33:\"header-mobile-first_switch-layout\";a:7:{s:4:\"name\";s:6:\"Layout\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:10:\"left_right\";s:7:\"options\";a:4:{s:10:\"left_right\";a:2:{s:5:\"title\";s:22:\"Left menu + right logo\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-mobile-firstswitch-layout-l-r.gif\";}s:11:\"left_center\";a:2:{s:5:\"title\";s:25:\"Left menu + centered logo\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-mobile-firstswitch-layout-l-c.gif\";}s:10:\"right_left\";a:2:{s:5:\"title\";s:22:\"Right menu + left logo\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-mobile-firstswitch-layout-r-l.gif\";}s:12:\"right_center\";a:2:{s:5:\"title\";s:26:\"Right menu + centered logo\";s:3:\"src\";s:65:\"/inc/admin/assets/images/header-mobile-firstswitch-layout-r-c.gif\";}}s:7:\"divider\";s:3:\"top\";s:5:\"class\";s:5:\"small\";s:2:\"id\";s:33:\"header-mobile-first_switch-layout\";}s:33:\"header-mobile-first_switch-height\";a:7:{s:4:\"name\";s:18:\"Header height (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"150\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:7:\"divider\";s:3:\"top\";s:2:\"id\";s:33:\"header-mobile-first_switch-height\";}s:33:\"header-mobile-second_switch-after\";a:7:{s:4:\"name\";s:17:\"Switch after (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"760\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:4:\"desc\";s:38:\"To skip this switch point set it to 0.\";s:2:\"id\";s:33:\"header-mobile-second_switch-after\";}s:34:\"header-mobile-second_switch-layout\";a:7:{s:4:\"name\";s:6:\"Layout\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:10:\"left_right\";s:7:\"options\";a:4:{s:10:\"left_right\";a:2:{s:5:\"title\";s:22:\"Left menu + right logo\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-mobile-secondswitch-layout-l-r.gif\";}s:11:\"left_center\";a:2:{s:5:\"title\";s:25:\"Left menu + centered logo\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-mobile-secondswitch-layout-l-c.gif\";}s:10:\"right_left\";a:2:{s:5:\"title\";s:22:\"Right menu + left logo\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-mobile-secondswitch-layout-r-l.gif\";}s:12:\"right_center\";a:2:{s:5:\"title\";s:26:\"Right menu + centered logo\";s:3:\"src\";s:66:\"/inc/admin/assets/images/header-mobile-secondswitch-layout-r-c.gif\";}}s:7:\"divider\";s:3:\"top\";s:5:\"class\";s:5:\"small\";s:2:\"id\";s:34:\"header-mobile-second_switch-layout\";}s:34:\"header-mobile-second_switch-height\";a:7:{s:4:\"name\";s:18:\"Header height (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"100\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:7:\"divider\";s:3:\"top\";s:2:\"id\";s:34:\"header-mobile-second_switch-height\";}s:33:\"header-mobile-floating_navigation\";a:6:{s:2:\"id\";s:33:\"header-mobile-floating_navigation\";s:4:\"name\";s:26:\"Floating mobile navigation\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:9:\"menu_icon\";s:7:\"options\";a:3:{s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:71:\"/inc/admin/assets/images/header-mobile-floating_navigation-disabled.gif\";}s:6:\"sticky\";a:2:{s:5:\"title\";s:20:\"Sticky mobile header\";s:3:\"src\";s:76:\"/inc/admin/assets/images/header-mobile-floating_navigation-sticky-header.gif\";}s:9:\"menu_icon\";a:2:{s:5:\"title\";s:18:\"Floating menu icon\";s:3:\"src\";s:67:\"/inc/admin/assets/images/header-mobile-floating_navigation-icon.gif\";}}s:5:\"class\";s:5:\"small\";}s:30:\"header-mobile-menu-font-family\";a:5:{s:2:\"id\";s:30:\"header-mobile-menu-font-family\";s:4:\"name\";s:9:\"Menu font\";s:4:\"type\";s:9:\"web_fonts\";s:3:\"std\";s:9:\"Open Sans\";s:5:\"fonts\";s:3:\"all\";}s:28:\"header-mobile-menu-font-size\";a:6:{s:2:\"id\";s:28:\"header-mobile-menu-font-size\";s:4:\"name\";s:14:\"Menu font size\";s:4:\"type\";s:6:\"slider\";s:8:\"sanitize\";s:9:\"font_size\";s:3:\"std\";i:16;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}}s:38:\"header-mobile-menu-font-is_capitalized\";a:5:{s:2:\"id\";s:38:\"header-mobile-menu-font-is_capitalized\";s:4:\"name\";s:15:\"Capitalize menu\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;s:7:\"divider\";s:6:\"bottom\";}s:33:\"header-mobile-submenu-font-family\";a:5:{s:2:\"id\";s:33:\"header-mobile-submenu-font-family\";s:4:\"name\";s:12:\"Submenu font\";s:4:\"type\";s:9:\"web_fonts\";s:3:\"std\";s:9:\"Open Sans\";s:5:\"fonts\";s:3:\"all\";}s:31:\"header-mobile-submenu-font-size\";a:6:{s:2:\"id\";s:31:\"header-mobile-submenu-font-size\";s:4:\"name\";s:17:\"Submenu font size\";s:4:\"type\";s:6:\"slider\";s:8:\"sanitize\";s:9:\"font_size\";s:3:\"std\";i:16;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}}s:41:\"header-mobile-submenu-font-is_capitalized\";a:5:{s:2:\"id\";s:41:\"header-mobile-submenu-font-is_capitalized\";s:4:\"name\";s:18:\"Capitalize submenu\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;s:7:\"divider\";s:6:\"bottom\";}s:29:\"header-mobile-menu-font-color\";a:4:{s:2:\"id\";s:29:\"header-mobile-menu-font-color\";s:4:\"name\";s:17:\"Normal font color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:41:\"header-mobile-menu-font-hover-color-style\";a:6:{s:4:\"name\";s:25:\"Active & hover font color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"accent\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}s:2:\"id\";s:41:\"header-mobile-menu-font-hover-color-style\";}s:35:\"header-mobile-menu-font-hover-color\";a:5:{s:4:\"name\";s:5:\"Color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:41:\"header-mobile-menu-font-hover-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}s:2:\"id\";s:35:\"header-mobile-menu-font-hover-color\";}s:38:\"header-mobile-menu-font-hover-gradient\";a:5:{s:4:\"name\";s:8:\"Gradient\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:41:\"header-mobile-menu-font-hover-color-style\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}s:2:\"id\";s:38:\"header-mobile-menu-font-hover-gradient\";}s:27:\"header-mobile-menu-bg-color\";a:4:{s:2:\"id\";s:27:\"header-mobile-menu-bg-color\";s:4:\"name\";s:16:\"Background color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#111111\";}s:29:\"header-mobile-menu-bg-opacity\";a:4:{s:2:\"id\";s:29:\"header-mobile-menu-bg-opacity\";s:4:\"name\";s:18:\"Background opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:27:\"header-mobile-menu-bg-width\";a:6:{s:2:\"id\";s:27:\"header-mobile-menu-bg-width\";s:4:\"name\";s:29:\"Maximum background width (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"400\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:24:\"header-mobile-menu-align\";a:6:{s:2:\"id\";s:24:\"header-mobile-menu-align\";s:4:\"name\";s:23:\"Mobile menu slides from\";s:4:\"type\";s:6:\"images\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:2:{s:4:\"left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:58:\"/inc/admin/assets/images/header-mobile-menu-align-left.gif\";}s:5:\"right\";a:2:{s:5:\"title\";s:5:\"Right\";s:3:\"src\";s:59:\"/inc/admin/assets/images/header-mobile-menu-align-right.gif\";}}s:5:\"class\";s:5:\"small\";}s:19:\"header-logo_regular\";a:5:{s:4:\"name\";s:4:\"Logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:19:\"header-logo_regular\";}s:14:\"header-logo_hd\";a:5:{s:4:\"name\";s:22:\"High-DPI (retina) logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:14:\"header-logo_hd\";}s:23:\"header-logo-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:23:\"header-logo-padding-top\";}s:25:\"header-logo-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:25:\"header-logo-padding-right\";}s:26:\"header-logo-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:26:\"header-logo-padding-bottom\";}s:24:\"header-logo-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:24:\"header-logo-padding-left\";}s:37:\"header-style-transparent-logo_regular\";a:5:{s:4:\"name\";s:4:\"Logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:37:\"header-style-transparent-logo_regular\";}s:32:\"header-style-transparent-logo_hd\";a:5:{s:4:\"name\";s:22:\"High-DPI (retina) logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:32:\"header-style-transparent-logo_hd\";}s:41:\"header-style-transparent-logo-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:41:\"header-style-transparent-logo-padding-top\";}s:43:\"header-style-transparent-logo-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:43:\"header-style-transparent-logo-padding-right\";}s:44:\"header-style-transparent-logo-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:44:\"header-style-transparent-logo-padding-bottom\";}s:42:\"header-style-transparent-logo-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:42:\"header-style-transparent-logo-padding-left\";}s:24:\"branding-menu-icon-block\";a:3:{s:4:\"name\";s:30:\"Menu icon, top line, side line\";s:2:\"id\";s:24:\"branding-menu-icon-block\";s:4:\"type\";s:5:\"block\";}s:31:\"header-style-mixed-logo_regular\";a:5:{s:4:\"name\";s:4:\"Logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:31:\"header-style-mixed-logo_regular\";}s:26:\"header-style-mixed-logo_hd\";a:5:{s:4:\"name\";s:22:\"High-DPI (retina) logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:26:\"header-style-mixed-logo_hd\";}s:35:\"header-style-mixed-logo-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:35:\"header-style-mixed-logo-padding-top\";}s:37:\"header-style-mixed-logo-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:37:\"header-style-mixed-logo-padding-right\";}s:38:\"header-style-mixed-logo-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:38:\"header-style-mixed-logo-padding-bottom\";}s:36:\"header-style-mixed-logo-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:36:\"header-style-mixed-logo-padding-left\";}s:27:\"branding-floating-nav-block\";a:3:{s:4:\"name\";s:19:\"Floating navigation\";s:2:\"id\";s:27:\"branding-floating-nav-block\";s:4:\"type\";s:5:\"block\";}s:33:\"header-style-floating-choose_logo\";a:5:{s:2:\"id\";s:33:\"header-style-floating-choose_logo\";s:4:\"name\";s:9:\"Show logo\";s:3:\"std\";s:6:\"custom\";s:4:\"type\";s:5:\"radio\";s:7:\"options\";a:3:{s:6:\"custom\";s:11:\"Custom logo\";s:4:\"main\";s:9:\"Main logo\";s:4:\"none\";s:10:\"Don\'t show\";}}s:34:\"header-style-floating-logo_regular\";a:6:{s:4:\"name\";s:4:\"Logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:34:\"header-style-floating-logo_regular\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-style-floating-choose_logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"custom\";}}}}s:29:\"header-style-floating-logo_hd\";a:6:{s:4:\"name\";s:22:\"High-DPI (retina) logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:29:\"header-style-floating-logo_hd\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-style-floating-choose_logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"custom\";}}}}s:38:\"header-style-floating-logo-padding-top\";a:8:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:7:\"divider\";s:3:\"top\";s:2:\"id\";s:38:\"header-style-floating-logo-padding-top\";s:10:\"dependency\";a:2:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-style-floating-choose_logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"custom\";}}i:1;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-style-floating-choose_logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"main\";}}}}s:40:\"header-style-floating-logo-padding-right\";a:7:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:40:\"header-style-floating-logo-padding-right\";s:10:\"dependency\";a:2:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-style-floating-choose_logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"custom\";}}i:1;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-style-floating-choose_logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"main\";}}}}s:41:\"header-style-floating-logo-padding-bottom\";a:7:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:41:\"header-style-floating-logo-padding-bottom\";s:10:\"dependency\";a:2:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-style-floating-choose_logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"custom\";}}i:1;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-style-floating-choose_logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"main\";}}}}s:39:\"header-style-floating-logo-padding-left\";a:7:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:39:\"header-style-floating-logo-padding-left\";s:10:\"dependency\";a:2:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-style-floating-choose_logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"custom\";}}i:1;a:1:{i:0;a:3:{s:5:\"field\";s:33:\"header-style-floating-choose_logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"main\";}}}}s:31:\"header-mobile-first_switch-logo\";a:5:{s:2:\"id\";s:31:\"header-mobile-first_switch-logo\";s:4:\"name\";s:27:\"First switch point (tablet)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:6:\"mobile\";s:7:\"options\";a:2:{s:7:\"desktop\";s:9:\"Main logo\";s:6:\"mobile\";s:11:\"Custom logo\";}}s:32:\"header-mobile-second_switch-logo\";a:5:{s:2:\"id\";s:32:\"header-mobile-second_switch-logo\";s:4:\"name\";s:27:\"Second switch point (phone)\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:6:\"mobile\";s:7:\"options\";a:2:{s:7:\"desktop\";s:9:\"Main logo\";s:6:\"mobile\";s:11:\"Custom logo\";}}s:32:\"header-style-mobile-logo_regular\";a:6:{s:4:\"name\";s:4:\"Logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:32:\"header-style-mobile-logo_regular\";s:10:\"dependency\";a:2:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:31:\"header-mobile-first_switch-logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"mobile\";}}i:1;a:1:{i:0;a:3:{s:5:\"field\";s:32:\"header-mobile-second_switch-logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"mobile\";}}}}s:27:\"header-style-mobile-logo_hd\";a:6:{s:4:\"name\";s:22:\"High-DPI (retina) logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:27:\"header-style-mobile-logo_hd\";s:10:\"dependency\";a:2:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:31:\"header-mobile-first_switch-logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"mobile\";}}i:1;a:1:{i:0;a:3:{s:5:\"field\";s:32:\"header-mobile-second_switch-logo\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:6:\"mobile\";}}}}s:36:\"header-style-mobile-logo-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:36:\"header-style-mobile-logo-padding-top\";}s:38:\"header-style-mobile-logo-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:38:\"header-style-mobile-logo-padding-right\";}s:39:\"header-style-mobile-logo-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:39:\"header-style-mobile-logo-padding-bottom\";}s:37:\"header-style-mobile-logo-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:37:\"header-style-mobile-logo-padding-left\";}s:23:\"bottom_bar-logo_regular\";a:5:{s:4:\"name\";s:4:\"Logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:23:\"bottom_bar-logo_regular\";}s:18:\"bottom_bar-logo_hd\";a:5:{s:4:\"name\";s:22:\"High-DPI (retina) logo\";s:4:\"type\";s:6:\"upload\";s:4:\"mode\";s:4:\"full\";s:3:\"std\";a:2:{i:0;s:0:\"\";i:1;i:0;}s:2:\"id\";s:18:\"bottom_bar-logo_hd\";}s:27:\"bottom_bar-logo-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:27:\"bottom_bar-logo-padding-top\";}s:29:\"bottom_bar-logo-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:29:\"bottom_bar-logo-padding-right\";}s:30:\"bottom_bar-logo-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:30:\"bottom_bar-logo-padding-bottom\";}s:28:\"bottom_bar-logo-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:28:\"bottom_bar-logo-padding-left\";}s:15:\"general-favicon\";a:4:{s:2:\"id\";s:15:\"general-favicon\";s:4:\"name\";s:18:\"Regular (16x16 px)\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";}s:18:\"general-favicon_hd\";a:4:{s:2:\"id\";s:18:\"general-favicon_hd\";s:4:\"name\";s:19:\"High-DPI (32x32 px)\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";}s:32:\"general-handheld_icon-old_iphone\";a:4:{s:2:\"id\";s:32:\"general-handheld_icon-old_iphone\";s:4:\"name\";s:21:\"60x60 px (old iPhone)\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";}s:30:\"general-handheld_icon-old_ipad\";a:4:{s:2:\"id\";s:30:\"general-handheld_icon-old_ipad\";s:4:\"name\";s:19:\"76x76 px (old iPad)\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";}s:35:\"general-handheld_icon-retina_iphone\";a:4:{s:2:\"id\";s:35:\"general-handheld_icon-retina_iphone\";s:4:\"name\";s:26:\"120x120 px (retina iPhone)\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";}s:33:\"general-handheld_icon-retina_ipad\";a:4:{s:2:\"id\";s:33:\"general-handheld_icon-retina_ipad\";s:4:\"name\";s:24:\"152x152 px (retina iPad)\";s:4:\"type\";s:6:\"upload\";s:3:\"std\";s:0:\"\";}s:21:\"bottom_bar-copyrights\";a:4:{s:2:\"id\";s:21:\"bottom_bar-copyrights\";s:4:\"name\";s:21:\"Copyright information\";s:4:\"type\";s:8:\"textarea\";s:3:\"std\";b:0;}s:18:\"bottom_bar-credits\";a:4:{s:2:\"id\";s:18:\"bottom_bar-credits\";s:4:\"name\";s:27:\"Give credits to Dream-Theme\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";s:1:\"1\";}s:22:\"stripes-stripe_1_color\";a:4:{s:4:\"name\";s:5:\"Color\";s:2:\"id\";s:22:\"stripes-stripe_1_color\";s:3:\"std\";s:7:\"#222526\";s:4:\"type\";s:5:\"color\";}s:25:\"stripes-stripe_1_bg_image\";a:5:{s:4:\"name\";s:20:\"Add background image\";s:2:\"id\";s:25:\"stripes-stripe_1_bg_image\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:4:\"type\";s:14:\"background_img\";s:6:\"fields\";a:0:{}}s:24:\"stripes-stripe_1_outline\";a:7:{s:4:\"name\";s:8:\"Outlines\";s:2:\"id\";s:24:\"stripes-stripe_1_outline\";s:3:\"std\";s:4:\"hide\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:1:{s:4:\"show\";b:1;}s:7:\"options\";a:2:{s:4:\"show\";a:2:{s:5:\"title\";s:4:\"Show\";s:3:\"src\";s:59:\"/inc/admin/assets/images/stripes-stripe-outline-enabled.gif\";}s:4:\"hide\";a:2:{s:5:\"title\";s:4:\"Hide\";s:3:\"src\";s:60:\"/inc/admin/assets/images/stripes-stripe-outline-disabled.gif\";}}}s:30:\"stripes-stripe_1_outline_color\";a:4:{s:4:\"name\";s:14:\"Outlines color\";s:2:\"id\";s:30:\"stripes-stripe_1_outline_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:32:\"stripes-stripe_1_outline_opacity\";a:4:{s:4:\"name\";s:16:\"Outlines opacity\";s:2:\"id\";s:32:\"stripes-stripe_1_outline_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:39:\"stripes-stripe_1_content_boxes_bg_color\";a:4:{s:4:\"name\";s:16:\"Background color\";s:2:\"id\";s:39:\"stripes-stripe_1_content_boxes_bg_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:41:\"stripes-stripe_1_content_boxes_bg_opacity\";a:4:{s:4:\"name\";s:18:\"Background opacity\";s:2:\"id\";s:41:\"stripes-stripe_1_content_boxes_bg_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:41:\"stripes-stripe_1_content_boxes_decoration\";a:7:{s:4:\"name\";s:10:\"Decoration\";s:2:\"id\";s:41:\"stripes-stripe_1_content_boxes_decoration\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:1:{s:7:\"outline\";b:1;}s:7:\"options\";a:3:{s:4:\"none\";a:2:{s:5:\"title\";s:4:\"None\";s:3:\"src\";s:66:\"/inc/admin/assets/images/general-content_boxes_decoration-none.gif\";}s:6:\"shadow\";a:2:{s:5:\"title\";s:6:\"Shadow\";s:3:\"src\";s:68:\"/inc/admin/assets/images/general-content_boxes_decoration-shadow.gif\";}s:7:\"outline\";a:2:{s:5:\"title\";s:7:\"Outline\";s:3:\"src\";s:69:\"/inc/admin/assets/images/general-content_boxes_decoration-outline.gif\";}}}s:55:\"stripes-stripe_1_content_boxes_decoration_outline_color\";a:4:{s:4:\"name\";s:24:\"Decoration outline color\";s:2:\"id\";s:55:\"stripes-stripe_1_content_boxes_decoration_outline_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:57:\"stripes-stripe_1_content_boxes_decoration_outline_opacity\";a:4:{s:4:\"name\";s:26:\"Decoration outline opacity\";s:2:\"id\";s:57:\"stripes-stripe_1_content_boxes_decoration_outline_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:30:\"stripes-stripe_1_headers_color\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:13:\"Headers color\";s:2:\"id\";s:30:\"stripes-stripe_1_headers_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:27:\"stripes-stripe_1_text_color\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:10:\"Text color\";s:2:\"id\";s:27:\"stripes-stripe_1_text_color\";s:3:\"std\";s:7:\"#828282\";s:4:\"type\";s:5:\"color\";}s:22:\"stripes-stripe_2_color\";a:4:{s:4:\"name\";s:5:\"Color\";s:2:\"id\";s:22:\"stripes-stripe_2_color\";s:3:\"std\";s:7:\"#aeaeae\";s:4:\"type\";s:5:\"color\";}s:25:\"stripes-stripe_2_bg_image\";a:5:{s:4:\"name\";s:20:\"Add background image\";s:2:\"id\";s:25:\"stripes-stripe_2_bg_image\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:4:\"type\";s:14:\"background_img\";s:6:\"fields\";a:0:{}}s:24:\"stripes-stripe_2_outline\";a:7:{s:4:\"name\";s:8:\"Outlines\";s:2:\"id\";s:24:\"stripes-stripe_2_outline\";s:3:\"std\";s:4:\"hide\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:1:{s:4:\"show\";b:1;}s:7:\"options\";a:2:{s:4:\"show\";a:2:{s:5:\"title\";s:4:\"Show\";s:3:\"src\";s:59:\"/inc/admin/assets/images/stripes-stripe-outline-enabled.gif\";}s:4:\"hide\";a:2:{s:5:\"title\";s:4:\"Hide\";s:3:\"src\";s:60:\"/inc/admin/assets/images/stripes-stripe-outline-disabled.gif\";}}}s:30:\"stripes-stripe_2_outline_color\";a:4:{s:4:\"name\";s:14:\"Outlines color\";s:2:\"id\";s:30:\"stripes-stripe_2_outline_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:32:\"stripes-stripe_2_outline_opacity\";a:4:{s:4:\"name\";s:16:\"Outlines opacity\";s:2:\"id\";s:32:\"stripes-stripe_2_outline_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:39:\"stripes-stripe_2_content_boxes_bg_color\";a:4:{s:4:\"name\";s:16:\"Background color\";s:2:\"id\";s:39:\"stripes-stripe_2_content_boxes_bg_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:41:\"stripes-stripe_2_content_boxes_bg_opacity\";a:4:{s:4:\"name\";s:18:\"Background opacity\";s:2:\"id\";s:41:\"stripes-stripe_2_content_boxes_bg_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:41:\"stripes-stripe_2_content_boxes_decoration\";a:7:{s:4:\"name\";s:10:\"Decoration\";s:2:\"id\";s:41:\"stripes-stripe_2_content_boxes_decoration\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:1:{s:7:\"outline\";b:1;}s:7:\"options\";a:3:{s:4:\"none\";a:2:{s:5:\"title\";s:4:\"None\";s:3:\"src\";s:66:\"/inc/admin/assets/images/general-content_boxes_decoration-none.gif\";}s:6:\"shadow\";a:2:{s:5:\"title\";s:6:\"Shadow\";s:3:\"src\";s:68:\"/inc/admin/assets/images/general-content_boxes_decoration-shadow.gif\";}s:7:\"outline\";a:2:{s:5:\"title\";s:7:\"Outline\";s:3:\"src\";s:69:\"/inc/admin/assets/images/general-content_boxes_decoration-outline.gif\";}}}s:55:\"stripes-stripe_2_content_boxes_decoration_outline_color\";a:4:{s:4:\"name\";s:24:\"Decoration outline color\";s:2:\"id\";s:55:\"stripes-stripe_2_content_boxes_decoration_outline_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:57:\"stripes-stripe_2_content_boxes_decoration_outline_opacity\";a:4:{s:4:\"name\";s:26:\"Decoration outline opacity\";s:2:\"id\";s:57:\"stripes-stripe_2_content_boxes_decoration_outline_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:30:\"stripes-stripe_2_headers_color\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:13:\"Headers color\";s:2:\"id\";s:30:\"stripes-stripe_2_headers_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:27:\"stripes-stripe_2_text_color\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:10:\"Text color\";s:2:\"id\";s:27:\"stripes-stripe_2_text_color\";s:3:\"std\";s:7:\"#828282\";s:4:\"type\";s:5:\"color\";}s:22:\"stripes-stripe_3_color\";a:4:{s:4:\"name\";s:5:\"Color\";s:2:\"id\";s:22:\"stripes-stripe_3_color\";s:3:\"std\";s:7:\"#cacaca\";s:4:\"type\";s:5:\"color\";}s:25:\"stripes-stripe_3_bg_image\";a:5:{s:4:\"name\";s:20:\"Add background image\";s:2:\"id\";s:25:\"stripes-stripe_3_bg_image\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}s:4:\"type\";s:14:\"background_img\";s:6:\"fields\";a:0:{}}s:24:\"stripes-stripe_3_outline\";a:7:{s:4:\"name\";s:8:\"Outlines\";s:2:\"id\";s:24:\"stripes-stripe_3_outline\";s:3:\"std\";s:4:\"hide\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:1:{s:4:\"show\";b:1;}s:7:\"options\";a:2:{s:4:\"show\";a:2:{s:5:\"title\";s:4:\"Show\";s:3:\"src\";s:59:\"/inc/admin/assets/images/stripes-stripe-outline-enabled.gif\";}s:4:\"hide\";a:2:{s:5:\"title\";s:4:\"Hide\";s:3:\"src\";s:60:\"/inc/admin/assets/images/stripes-stripe-outline-disabled.gif\";}}}s:30:\"stripes-stripe_3_outline_color\";a:4:{s:4:\"name\";s:14:\"Outlines color\";s:2:\"id\";s:30:\"stripes-stripe_3_outline_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:32:\"stripes-stripe_3_outline_opacity\";a:4:{s:4:\"name\";s:16:\"Outlines opacity\";s:2:\"id\";s:32:\"stripes-stripe_3_outline_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:39:\"stripes-stripe_3_content_boxes_bg_color\";a:4:{s:4:\"name\";s:16:\"Background color\";s:2:\"id\";s:39:\"stripes-stripe_3_content_boxes_bg_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:41:\"stripes-stripe_3_content_boxes_bg_opacity\";a:4:{s:4:\"name\";s:18:\"Background opacity\";s:2:\"id\";s:41:\"stripes-stripe_3_content_boxes_bg_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:41:\"stripes-stripe_3_content_boxes_decoration\";a:7:{s:4:\"name\";s:10:\"Decoration\";s:2:\"id\";s:41:\"stripes-stripe_3_content_boxes_decoration\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:1:{s:7:\"outline\";b:1;}s:7:\"options\";a:3:{s:4:\"none\";a:2:{s:5:\"title\";s:4:\"None\";s:3:\"src\";s:66:\"/inc/admin/assets/images/general-content_boxes_decoration-none.gif\";}s:6:\"shadow\";a:2:{s:5:\"title\";s:6:\"Shadow\";s:3:\"src\";s:68:\"/inc/admin/assets/images/general-content_boxes_decoration-shadow.gif\";}s:7:\"outline\";a:2:{s:5:\"title\";s:7:\"Outline\";s:3:\"src\";s:69:\"/inc/admin/assets/images/general-content_boxes_decoration-outline.gif\";}}}s:55:\"stripes-stripe_3_content_boxes_decoration_outline_color\";a:4:{s:4:\"name\";s:24:\"Decoration outline color\";s:2:\"id\";s:55:\"stripes-stripe_3_content_boxes_decoration_outline_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:57:\"stripes-stripe_3_content_boxes_decoration_outline_opacity\";a:4:{s:4:\"name\";s:26:\"Decoration outline opacity\";s:2:\"id\";s:57:\"stripes-stripe_3_content_boxes_decoration_outline_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:30:\"stripes-stripe_3_headers_color\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:13:\"Headers color\";s:2:\"id\";s:30:\"stripes-stripe_3_headers_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:27:\"stripes-stripe_3_text_color\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:10:\"Text color\";s:2:\"id\";s:27:\"stripes-stripe_3_text_color\";s:3:\"std\";s:7:\"#828282\";s:4:\"type\";s:5:\"color\";}s:13:\"sidebar-width\";a:6:{s:4:\"name\";s:17:\"Sidebar width (%)\";s:2:\"id\";s:13:\"sidebar-width\";s:3:\"std\";s:2:\"30\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:25:\"sidebar-vertical_distance\";a:6:{s:4:\"name\";s:38:\"Vertical distance between widgets (px)\";s:2:\"id\";s:25:\"sidebar-vertical_distance\";s:3:\"std\";s:2:\"60\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:20:\"sidebar-visual_style\";a:7:{s:4:\"name\";s:13:\"Sidebar style\";s:2:\"id\";s:20:\"sidebar-visual_style\";s:3:\"std\";s:13:\"with_dividers\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:3:{s:13:\"with_dividers\";a:2:{s:5:\"title\";s:8:\"Dividers\";s:3:\"src\";s:58:\"/inc/admin/assets/images/sidebar-visual_style-dividers.gif\";}s:7:\"with_bg\";a:2:{s:5:\"title\";s:31:\"Background behind whole sidebar\";s:3:\"src\";s:81:\"/inc/admin/assets/images/sidebar-visual_style-background-behind-whole-sidebar.gif\";}s:15:\"with_widgets_bg\";a:2:{s:5:\"title\";s:29:\"Background behind each widget\";s:3:\"src\";s:79:\"/inc/admin/assets/images/sidebar-visual_style-background-behind-each-widget.gif\";}}s:9:\"show_hide\";a:3:{s:13:\"with_dividers\";a:2:{i:0;s:25:\"sidebar-dividers-vertical\";i:1;s:27:\"sidebar-dividers-horizontal\";}s:7:\"with_bg\";a:2:{i:0;s:19:\"sidebar-bg-settings\";i:1;s:27:\"sidebar-dividers-horizontal\";}s:15:\"with_widgets_bg\";s:19:\"sidebar-bg-settings\";}}s:24:\"sidebar-divider-vertical\";a:6:{s:4:\"name\";s:16:\"Vertical divider\";s:2:\"id\";s:24:\"sidebar-divider-vertical\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:61:\"/inc/admin/assets/images/sidebar-divider-vertical-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:62:\"/inc/admin/assets/images/sidebar-divider-vertical-disabled.gif\";}}}s:26:\"sidebar-divider-horizontal\";a:6:{s:4:\"name\";s:24:\"Dividers between widgets\";s:2:\"id\";s:26:\"sidebar-divider-horizontal\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:63:\"/inc/admin/assets/images/sidebar-divider-horizontal-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:62:\"/inc/admin/assets/images/sidebar-divider-vertical-disabled.gif\";}}}s:16:\"sidebar-bg_color\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:16:\"Background color\";s:2:\"id\";s:16:\"sidebar-bg_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:18:\"sidebar-bg_opacity\";a:4:{s:4:\"name\";s:18:\"Background opacity\";s:2:\"id\";s:18:\"sidebar-bg_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:16:\"sidebar-bg_image\";a:4:{s:4:\"type\";s:14:\"background_img\";s:2:\"id\";s:16:\"sidebar-bg_image\";s:4:\"name\";s:20:\"Add background image\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}}s:18:\"sidebar-decoration\";a:7:{s:4:\"name\";s:10:\"Decoration\";s:2:\"id\";s:18:\"sidebar-decoration\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:1:{s:7:\"outline\";b:1;}s:7:\"options\";a:3:{s:4:\"none\";a:2:{s:5:\"title\";s:4:\"None\";s:3:\"src\";s:66:\"/inc/admin/assets/images/general-content_boxes_decoration-none.gif\";}s:6:\"shadow\";a:2:{s:5:\"title\";s:6:\"Shadow\";s:3:\"src\";s:68:\"/inc/admin/assets/images/general-content_boxes_decoration-shadow.gif\";}s:7:\"outline\";a:2:{s:5:\"title\";s:7:\"Outline\";s:3:\"src\";s:69:\"/inc/admin/assets/images/general-content_boxes_decoration-outline.gif\";}}}s:32:\"sidebar-decoration_outline_color\";a:4:{s:4:\"name\";s:24:\"Decoration outline color\";s:2:\"id\";s:32:\"sidebar-decoration_outline_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:34:\"sidebar-decoration_outline_opacity\";a:4:{s:4:\"name\";s:26:\"Decoration outline opacity\";s:2:\"id\";s:34:\"sidebar-decoration_outline_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:21:\"sidebar-headers_color\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:13:\"Headers color\";s:2:\"id\";s:21:\"sidebar-headers_color\";s:3:\"std\";s:7:\"#000000\";s:4:\"type\";s:5:\"color\";}s:26:\"sidebar-primary_text_color\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:10:\"Text color\";s:2:\"id\";s:26:\"sidebar-primary_text_color\";s:3:\"std\";s:7:\"#686868\";s:4:\"type\";s:5:\"color\";}s:12:\"footer-style\";a:7:{s:4:\"name\";s:29:\"Footer background &amp; lines\";s:2:\"id\";s:12:\"footer-style\";s:3:\"std\";s:18:\"content_width_line\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:3:{s:18:\"content_width_line\";a:2:{s:5:\"title\";s:18:\"Content-width line\";s:3:\"src\";s:60:\"/inc/admin/assets/images/footer-style-content-width-line.gif\";}s:15:\"full_width_line\";a:2:{s:5:\"title\";s:15:\"Full-width line\";s:3:\"src\";s:57:\"/inc/admin/assets/images/footer-style-full-width-line.gif\";}s:16:\"solid_background\";a:2:{s:5:\"title\";s:10:\"Background\";s:3:\"src\";s:52:\"/inc/admin/assets/images/footer-style-background.gif\";}}s:9:\"show_hide\";a:1:{s:16:\"solid_background\";s:29:\"footer-solid-background-block\";}}s:15:\"footer-bg_color\";a:4:{s:4:\"name\";s:5:\"Color\";s:2:\"id\";s:15:\"footer-bg_color\";s:3:\"std\";s:7:\"#1B1B1B\";s:4:\"type\";s:5:\"color\";}s:17:\"footer-bg_opacity\";a:4:{s:4:\"name\";s:7:\"Opacity\";s:2:\"id\";s:17:\"footer-bg_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:17:\"footer-decoration\";a:7:{s:4:\"name\";s:10:\"Decoration\";s:2:\"id\";s:17:\"footer-decoration\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:1:{s:7:\"outline\";b:1;}s:7:\"options\";a:2:{s:4:\"none\";a:2:{s:5:\"title\";s:4:\"None\";s:3:\"src\";s:52:\"/inc/admin/assets/images/footer-style-background.gif\";}s:7:\"outline\";a:2:{s:5:\"title\";s:4:\"Line\";s:3:\"src\";s:51:\"/inc/admin/assets/images/footer-decoration-line.gif\";}}}s:31:\"footer-decoration_outline_color\";a:4:{s:4:\"name\";s:24:\"Decoration outline color\";s:2:\"id\";s:31:\"footer-decoration_outline_color\";s:3:\"std\";s:7:\"#FFFFFF\";s:4:\"type\";s:5:\"color\";}s:33:\"footer-decoration_outline_opacity\";a:4:{s:4:\"name\";s:26:\"Decoration outline opacity\";s:2:\"id\";s:33:\"footer-decoration_outline_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:15:\"footer-bg_image\";a:4:{s:4:\"type\";s:14:\"background_img\";s:4:\"name\";s:20:\"Add background image\";s:2:\"id\";s:15:\"footer-bg_image\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}}s:21:\"footer-slide-out-mode\";a:7:{s:4:\"name\";s:14:\"Slide-out mode\";s:4:\"desc\";s:91:\"\"Slide-out mode\" isn\'t compatible with transparent/semitransparent content area background.\";s:2:\"id\";s:21:\"footer-slide-out-mode\";s:3:\"std\";s:1:\"0\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:58:\"/inc/admin/assets/images/footer-slide-out-mode-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:59:\"/inc/admin/assets/images/footer-slide-out-mode-disabled.gif\";}}}s:20:\"footer-headers_color\";a:4:{s:4:\"name\";s:13:\"Headers color\";s:2:\"id\";s:20:\"footer-headers_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:25:\"footer-primary_text_color\";a:4:{s:4:\"name\";s:13:\"Content color\";s:2:\"id\";s:25:\"footer-primary_text_color\";s:3:\"std\";s:7:\"#828282\";s:4:\"type\";s:5:\"color\";}s:18:\"footer-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:2:\"50\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:18:\"footer-padding-top\";}s:21:\"footer-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:2:\"50\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:21:\"footer-padding-bottom\";}s:23:\"footer-paddings-columns\";a:7:{s:4:\"desc\";s:65:\"E.g. 20 pixel padding will give you 40 pixel gap between columns.\";s:4:\"name\";s:36:\"Paddings between footer columns (px)\";s:2:\"id\";s:23:\"footer-paddings-columns\";s:3:\"std\";i:44;s:4:\"type\";s:4:\"text\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:13:\"footer-layout\";a:5:{s:4:\"name\";s:6:\"Layout\";s:4:\"desc\";s:18:\"E.g. \"1/4+1/4+1/2\"\";s:2:\"id\";s:13:\"footer-layout\";s:3:\"std\";s:15:\"1/4+1/4+1/4+1/4\";s:4:\"type\";s:4:\"text\";}s:21:\"footer-collapse_after\";a:7:{s:4:\"name\";s:33:\"Collapse to one column after (px)\";s:4:\"desc\";s:52:\"Won\'t have any effect if responsiveness is disabled.\";s:2:\"id\";s:21:\"footer-collapse_after\";s:3:\"std\";i:760;s:4:\"type\";s:4:\"text\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:18:\"bottom_bar-enabled\";a:5:{s:4:\"name\";s:10:\"Bottom bar\";s:2:\"id\";s:18:\"bottom_bar-enabled\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:1:\"1\";s:7:\"options\";a:2:{i:1;s:7:\"Enabled\";i:0;s:8:\"Disabled\";}}s:16:\"bottom_bar-style\";a:7:{s:4:\"name\";s:33:\"Bottom bar background &amp; lines\";s:2:\"id\";s:16:\"bottom_bar-style\";s:3:\"std\";s:18:\"content_width_line\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:3:{s:18:\"content_width_line\";a:2:{s:5:\"title\";s:18:\"Content-width line\";s:3:\"src\";s:64:\"/inc/admin/assets/images/bottom_bar-style-content-width-line.gif\";}s:15:\"full_width_line\";a:2:{s:5:\"title\";s:15:\"Full-width line\";s:3:\"src\";s:61:\"/inc/admin/assets/images/bottom_bar-style-full-width-line.gif\";}s:16:\"solid_background\";a:2:{s:5:\"title\";s:10:\"Background\";s:3:\"src\";s:56:\"/inc/admin/assets/images/bottom_bar-style-background.gif\";}}s:9:\"show_hide\";a:1:{s:16:\"solid_background\";s:33:\"bottom-bar-solid-background-block\";}}s:19:\"bottom_bar-bg_color\";a:4:{s:4:\"name\";s:5:\"Color\";s:2:\"id\";s:19:\"bottom_bar-bg_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:21:\"bottom_bar-bg_opacity\";a:4:{s:4:\"name\";s:7:\"Opacity\";s:2:\"id\";s:21:\"bottom_bar-bg_opacity\";s:3:\"std\";i:100;s:4:\"type\";s:6:\"slider\";}s:19:\"bottom_bar-bg_image\";a:4:{s:4:\"type\";s:14:\"background_img\";s:2:\"id\";s:19:\"bottom_bar-bg_image\";s:4:\"name\";s:20:\"Add background image\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}}s:16:\"bottom_bar-color\";a:4:{s:4:\"name\";s:10:\"Font color\";s:2:\"id\";s:16:\"bottom_bar-color\";s:3:\"std\";s:7:\"#757575\";s:4:\"type\";s:5:\"color\";}s:15:\"bottom_bar-text\";a:4:{s:4:\"name\";s:9:\"Text area\";s:2:\"id\";s:15:\"bottom_bar-text\";s:3:\"std\";b:0;s:4:\"type\";s:8:\"textarea\";}s:20:\"general-filter_style\";a:7:{s:2:\"id\";s:20:\"general-filter_style\";s:4:\"name\";s:5:\"Style\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:3:\"ios\";s:7:\"options\";a:3:{s:3:\"ios\";a:2:{s:5:\"title\";s:13:\"No decoration\";s:3:\"src\";s:52:\"/inc/admin/assets/images/general-filter-no-decor.gif\";}s:7:\"minimal\";a:2:{s:5:\"title\";s:10:\"Background\";s:3:\"src\";s:54:\"/inc/admin/assets/images/general-filter-background.gif\";}s:8:\"material\";a:2:{s:5:\"title\";s:9:\"Underline\";s:3:\"src\";s:53:\"/inc/admin/assets/images/general-filter-underline.gif\";}}s:9:\"show_hide\";a:3:{s:3:\"ios\";a:0:{}s:7:\"minimal\";a:1:{i:0;s:28:\"general-filter_style-minimal\";}s:8:\"material\";a:1:{i:0;s:29:\"general-filter_style-material\";}}}s:42:\"general-filter_style-minimal-border_radius\";a:5:{s:4:\"name\";s:18:\"Border radius (px)\";s:2:\"id\";s:42:\"general-filter_style-minimal-border_radius\";s:3:\"std\";s:3:\"100\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:10:\"dimensions\";}s:39:\"general-filter_style-material-line_size\";a:5:{s:4:\"name\";s:14:\"Line size (px)\";s:2:\"id\";s:39:\"general-filter_style-material-line_size\";s:3:\"std\";s:1:\"2\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:10:\"dimensions\";}s:26:\"general-filter-font-family\";a:5:{s:2:\"id\";s:26:\"general-filter-font-family\";s:4:\"name\";s:4:\"Font\";s:4:\"type\";s:9:\"web_fonts\";s:3:\"std\";s:9:\"Open Sans\";s:5:\"fonts\";s:3:\"all\";}s:24:\"general-filter-font-size\";a:6:{s:2:\"id\";s:24:\"general-filter-font-size\";s:4:\"name\";s:9:\"Font size\";s:4:\"type\";s:6:\"slider\";s:8:\"sanitize\";s:9:\"font_size\";s:3:\"std\";i:16;s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}}s:20:\"general-filter_ucase\";a:4:{s:2:\"id\";s:20:\"general-filter_ucase\";s:4:\"name\";s:10:\"Capitalize\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:26:\"general-filter-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"5\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:26:\"general-filter-padding-top\";}s:28:\"general-filter-padding-right\";a:6:{s:4:\"name\";s:18:\"Right padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"5\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:28:\"general-filter-padding-right\";}s:29:\"general-filter-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"5\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:29:\"general-filter-padding-bottom\";}s:27:\"general-filter-padding-left\";a:6:{s:4:\"name\";s:17:\"Left padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"5\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:27:\"general-filter-padding-left\";}s:25:\"general-filter-margin-top\";a:6:{s:4:\"name\";s:15:\"Top margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:25:\"general-filter-margin-top\";}s:27:\"general-filter-margin-right\";a:6:{s:4:\"name\";s:17:\"Right margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"5\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:27:\"general-filter-margin-right\";}s:28:\"general-filter-margin-bottom\";a:6:{s:4:\"name\";s:18:\"Bottom margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:28:\"general-filter-margin-bottom\";}s:26:\"general-filter-margin-left\";a:6:{s:4:\"name\";s:16:\"Left margin (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"5\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:26:\"general-filter-margin-left\";}s:25:\"general-navigation_margin\";a:6:{s:2:\"id\";s:25:\"general-navigation_margin\";s:4:\"name\";s:8:\"Gap (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:2:\"50\";s:8:\"sanitize\";s:10:\"dimensions\";s:5:\"class\";s:4:\"mini\";}s:21:\"blog-fancy_date-style\";a:6:{s:4:\"name\";s:5:\"Style\";s:2:\"id\";s:21:\"blog-fancy_date-style\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:6:\"circle\";s:7:\"options\";a:3:{s:6:\"circle\";a:2:{s:5:\"title\";s:6:\"Circle\";s:3:\"src\";s:39:\"/inc/admin/assets/images/date-round.gif\";}s:8:\"vertical\";a:2:{s:5:\"title\";s:8:\"Vertical\";s:3:\"src\";s:38:\"/inc/admin/assets/images/date-vert.gif\";}s:10:\"horizontal\";a:2:{s:5:\"title\";s:10:\"Horizontal\";s:3:\"src\";s:37:\"/inc/admin/assets/images/date-hor.gif\";}}}s:20:\"post-show_fancy_date\";a:4:{s:4:\"name\";s:15:\"Show fancy date\";s:2:\"id\";s:20:\"post-show_fancy_date\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";s:1:\"1\";}s:26:\"post-show_fancy_categories\";a:4:{s:4:\"name\";s:21:\"Show fancy categories\";s:2:\"id\";s:26:\"post-show_fancy_categories\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";s:1:\"1\";}s:19:\"blog-thumbnail_size\";a:6:{s:4:\"name\";s:28:\"Single post thumbnail sizing\";s:2:\"id\";s:19:\"blog-thumbnail_size\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:8:\"original\";s:7:\"options\";a:2:{s:8:\"original\";s:27:\"Preserve images proportions\";s:6:\"resize\";s:13:\"Resize images\";}s:9:\"show_hide\";a:1:{s:6:\"resize\";b:1;}}s:26:\"blog-thumbnail_proportions\";a:4:{s:4:\"name\";s:21:\"Thumbnail proportions\";s:2:\"id\";s:26:\"blog-thumbnail_proportions\";s:4:\"type\";s:11:\"square_size\";s:3:\"std\";a:2:{s:5:\"width\";i:3;s:6:\"height\";i:2;}}s:27:\"general-show_author_in_blog\";a:6:{s:4:\"name\";s:30:\"Show author info in blog posts\";s:2:\"id\";s:27:\"general-show_author_in_blog\";s:3:\"std\";i:1;s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:60:\"/inc/admin/assets/images/general-show_author_in_blog-yes.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}}s:25:\"general-next_prev_in_blog\";a:6:{s:4:\"name\";s:18:\"Show in blog posts\";s:2:\"id\";s:25:\"general-next_prev_in_blog\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";i:1;s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:54:\"/inc/admin/assets/images/general-next-prev-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}}s:32:\"general-show_back_button_in_post\";a:8:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:11:\"Back button\";s:2:\"id\";s:32:\"general-show_back_button_in_post\";s:3:\"std\";s:1:\"0\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:61:\"/inc/admin/assets/images/general-show-back-button-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:39:\"general-post_back_button_target_page_id\";a:3:{s:4:\"name\";s:11:\"Choose page\";s:2:\"id\";s:39:\"general-post_back_button_target_page_id\";s:4:\"type\";s:10:\"pages_list\";}s:20:\"general-blog_meta_on\";a:8:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:16:\"Meta information\";s:2:\"id\";s:20:\"general-blog_meta_on\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:58:\"/inc/admin/assets/images/general-album_meta_on-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:22:\"general-blog_meta_date\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:4:\"Date\";s:2:\"id\";s:22:\"general-blog_meta_date\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:24:\"general-blog_meta_author\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:6:\"Author\";s:2:\"id\";s:24:\"general-blog_meta_author\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:28:\"general-blog_meta_categories\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:10:\"Categories\";s:2:\"id\";s:28:\"general-blog_meta_categories\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:26:\"general-blog_meta_comments\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:8:\"Comments\";s:2:\"id\";s:26:\"general-blog_meta_comments\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:22:\"general-blog_meta_tags\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:4:\"Tags\";s:2:\"id\";s:22:\"general-blog_meta_tags\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:22:\"general-show_rel_posts\";a:8:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:13:\"Related posts\";s:2:\"id\";s:22:\"general-show_rel_posts\";s:3:\"std\";s:1:\"0\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:59:\"/inc/admin/assets/images/general-show_rel_posts-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:28:\"general-rel_posts_head_title\";a:4:{s:4:\"name\";s:5:\"Title\";s:2:\"id\";s:28:\"general-rel_posts_head_title\";s:3:\"std\";s:13:\"Related Posts\";s:4:\"type\";s:4:\"text\";}s:21:\"general-rel_posts_max\";a:5:{s:4:\"name\";s:31:\"Maximum number of related posts\";s:2:\"id\";s:21:\"general-rel_posts_max\";s:3:\"std\";i:6;s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:3:\"ppp\";}s:30:\"general-next_prev_in_portfolio\";a:6:{s:4:\"name\";s:23:\"Show in portfolio posts\";s:2:\"id\";s:30:\"general-next_prev_in_portfolio\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";i:1;s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:54:\"/inc/admin/assets/images/general-next-prev-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}}s:35:\"general-show_back_button_in_project\";a:8:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:11:\"Back button\";s:2:\"id\";s:35:\"general-show_back_button_in_project\";s:3:\"std\";s:1:\"0\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:61:\"/inc/admin/assets/images/general-show-back-button-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:42:\"general-project_back_button_target_page_id\";a:3:{s:4:\"name\";s:11:\"Choose page\";s:2:\"id\";s:42:\"general-project_back_button_target_page_id\";s:4:\"type\";s:10:\"pages_list\";}s:25:\"general-portfolio_meta_on\";a:8:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:16:\"Meta information\";s:2:\"id\";s:25:\"general-portfolio_meta_on\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:58:\"/inc/admin/assets/images/general-album_meta_on-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:27:\"general-portfolio_meta_date\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:4:\"Date\";s:2:\"id\";s:27:\"general-portfolio_meta_date\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:29:\"general-portfolio_meta_author\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:6:\"Author\";s:2:\"id\";s:29:\"general-portfolio_meta_author\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:33:\"general-portfolio_meta_categories\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:10:\"Categories\";s:2:\"id\";s:33:\"general-portfolio_meta_categories\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:31:\"general-portfolio_meta_comments\";a:5:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:18:\"Number of comments\";s:2:\"id\";s:31:\"general-portfolio_meta_comments\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:25:\"general-show_rel_projects\";a:8:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:16:\"Related projects\";s:2:\"id\";s:25:\"general-show_rel_projects\";s:3:\"std\";s:1:\"0\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:62:\"/inc/admin/assets/images/general-show_rel_projects-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:50:\"/inc/admin/assets/images/microwidgets-disabled.gif\";}}s:9:\"show_hide\";a:1:{i:1;b:1;}}s:31:\"general-rel_projects_head_title\";a:4:{s:4:\"name\";s:5:\"Title\";s:2:\"id\";s:31:\"general-rel_projects_head_title\";s:3:\"std\";s:16:\"Related Projects\";s:4:\"type\";s:4:\"text\";}s:26:\"general-rel_projects_title\";a:4:{s:4:\"name\";s:11:\"Show titles\";s:2:\"id\";s:26:\"general-rel_projects_title\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"checkbox\";}s:28:\"general-rel_projects_excerpt\";a:4:{s:4:\"name\";s:13:\"Show excerpts\";s:2:\"id\";s:28:\"general-rel_projects_excerpt\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"checkbox\";}s:30:\"general-rel_projects_info_date\";a:4:{s:4:\"name\";s:9:\"Show date\";s:2:\"id\";s:30:\"general-rel_projects_info_date\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"checkbox\";}s:32:\"general-rel_projects_info_author\";a:4:{s:4:\"name\";s:11:\"Show author\";s:2:\"id\";s:32:\"general-rel_projects_info_author\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"checkbox\";}s:34:\"general-rel_projects_info_comments\";a:4:{s:4:\"name\";s:23:\"Show number of comments\";s:2:\"id\";s:34:\"general-rel_projects_info_comments\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"checkbox\";}s:36:\"general-rel_projects_info_categories\";a:4:{s:4:\"name\";s:15:\"Show categories\";s:2:\"id\";s:36:\"general-rel_projects_info_categories\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"checkbox\";}s:25:\"general-rel_projects_link\";a:4:{s:4:\"name\";s:10:\"Show links\";s:2:\"id\";s:25:\"general-rel_projects_link\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"checkbox\";}s:25:\"general-rel_projects_zoom\";a:4:{s:4:\"name\";s:9:\"Show zoom\";s:2:\"id\";s:25:\"general-rel_projects_zoom\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"checkbox\";}s:28:\"general-rel_projects_details\";a:4:{s:4:\"name\";s:21:\"Show \"Details\" button\";s:2:\"id\";s:28:\"general-rel_projects_details\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:8:\"checkbox\";}s:24:\"general-rel_projects_max\";a:5:{s:4:\"name\";s:32:\"Maximum number of projects posts\";s:2:\"id\";s:24:\"general-rel_projects_max\";s:3:\"std\";i:12;s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:3:\"ppp\";}s:37:\"general-rel_projects_fullwidth_height\";a:5:{s:4:\"name\";s:45:\"Related posts height for fullwidth posts (px)\";s:2:\"id\";s:37:\"general-rel_projects_fullwidth_height\";s:3:\"std\";i:210;s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:3:\"ppp\";}s:42:\"general-rel_projects_fullwidth_width_style\";a:6:{s:4:\"name\";s:39:\"Related posts width for fullwidth posts\";s:2:\"id\";s:42:\"general-rel_projects_fullwidth_width_style\";s:3:\"std\";s:4:\"prop\";s:4:\"type\";s:5:\"radio\";s:7:\"options\";a:2:{s:4:\"prop\";s:19:\"Proportional images\";s:5:\"fixed\";s:11:\"Fixed width\";}s:9:\"show_hide\";a:1:{s:5:\"fixed\";b:1;}}s:36:\"general-rel_projects_fullwidth_width\";a:5:{s:4:\"name\";s:10:\"Width (px)\";s:2:\"id\";s:36:\"general-rel_projects_fullwidth_width\";s:3:\"std\";s:3:\"210\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:3:\"ppp\";}s:27:\"general-rel_projects_height\";a:5:{s:4:\"name\";s:48:\"Related posts height for posts with sidebar (px)\";s:2:\"id\";s:27:\"general-rel_projects_height\";s:3:\"std\";i:180;s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:3:\"ppp\";}s:32:\"general-rel_projects_width_style\";a:6:{s:4:\"name\";s:42:\"Related posts width for posts with sidebar\";s:2:\"id\";s:32:\"general-rel_projects_width_style\";s:3:\"std\";s:4:\"prop\";s:4:\"type\";s:5:\"radio\";s:7:\"options\";a:2:{s:4:\"prop\";s:19:\"Proportional images\";s:5:\"fixed\";s:11:\"Fixed width\";}s:9:\"show_hide\";a:1:{s:5:\"fixed\";b:1;}}s:26:\"general-rel_projects_width\";a:5:{s:4:\"name\";s:10:\"Width (px)\";s:2:\"id\";s:26:\"general-rel_projects_width\";s:3:\"std\";s:3:\"180\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:3:\"ppp\";}s:24:\"modules-portfolio-status\";a:5:{s:2:\"id\";s:24:\"modules-portfolio-status\";s:4:\"name\";s:9:\"Portfolio\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"enabled\";s:7:\"options\";a:2:{s:7:\"enabled\";s:7:\"Enabled\";s:8:\"disabled\";s:8:\"Disabled\";}}s:27:\"modules-testimonials-status\";a:5:{s:2:\"id\";s:27:\"modules-testimonials-status\";s:4:\"name\";s:12:\"Testimonials\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"enabled\";s:7:\"options\";a:2:{s:7:\"enabled\";s:7:\"Enabled\";s:8:\"disabled\";s:8:\"Disabled\";}}s:19:\"modules-team-status\";a:5:{s:2:\"id\";s:19:\"modules-team-status\";s:4:\"name\";s:4:\"Team\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"enabled\";s:7:\"options\";a:2:{s:7:\"enabled\";s:7:\"Enabled\";s:8:\"disabled\";s:8:\"Disabled\";}}s:20:\"modules-logos-status\";a:5:{s:2:\"id\";s:20:\"modules-logos-status\";s:4:\"name\";s:23:\"Partners, Clients, etc.\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"enabled\";s:7:\"options\";a:2:{s:7:\"enabled\";s:7:\"Enabled\";s:8:\"disabled\";s:8:\"Disabled\";}}s:23:\"modules-benefits-status\";a:5:{s:2:\"id\";s:23:\"modules-benefits-status\";s:4:\"name\";s:8:\"Benefits\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"enabled\";s:7:\"options\";a:2:{s:7:\"enabled\";s:7:\"Enabled\";s:8:\"disabled\";s:8:\"Disabled\";}}s:21:\"modules-albums-status\";a:5:{s:2:\"id\";s:21:\"modules-albums-status\";s:4:\"name\";s:12:\"Photo Albums\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"enabled\";s:7:\"options\";a:2:{s:7:\"enabled\";s:7:\"Enabled\";s:8:\"disabled\";s:8:\"Disabled\";}}s:24:\"modules-slideshow-status\";a:5:{s:2:\"id\";s:24:\"modules-slideshow-status\";s:4:\"name\";s:10:\"Slideshows\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:7:\"enabled\";s:7:\"options\";a:2:{s:7:\"enabled\";s:7:\"Enabled\";s:8:\"disabled\";s:8:\"Disabled\";}}s:32:\"general-post_type_portfolio_slug\";a:5:{s:2:\"id\";s:32:\"general-post_type_portfolio_slug\";s:4:\"name\";s:14:\"Portfolio slug\";s:3:\"std\";s:7:\"project\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:4:\"mini\";}s:19:\"general-title_align\";a:7:{s:2:\"id\";s:19:\"general-title_align\";s:4:\"name\";s:17:\"Title area layout\";s:4:\"desc\";s:35:\"Title and breadcrumbs interposition\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:4:\"left\";s:7:\"options\";a:5:{s:4:\"left\";a:2:{s:5:\"title\";s:30:\"Left title + right breadcrumbs\";s:3:\"src\";s:32:\"/inc/admin/assets/images/l-r.gif\";}s:5:\"right\";a:2:{s:5:\"title\";s:30:\"Right title + left breadcrumbs\";s:3:\"src\";s:32:\"/inc/admin/assets/images/r-l.gif\";}s:8:\"all_left\";a:2:{s:5:\"title\";s:4:\"Left\";s:3:\"src\";s:32:\"/inc/admin/assets/images/l-l.gif\";}s:9:\"all_right\";a:2:{s:5:\"title\";s:5:\"Right\";s:3:\"src\";s:32:\"/inc/admin/assets/images/r-r.gif\";}s:6:\"center\";a:2:{s:5:\"title\";s:8:\"Centered\";s:3:\"src\";s:35:\"/inc/admin/assets/images/centre.gif\";}}}s:20:\"general-title_height\";a:6:{s:2:\"id\";s:20:\"general-title_height\";s:4:\"name\";s:22:\"Title area height (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:3:\"170\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:6:\"slider\";}s:22:\"page_title-padding-top\";a:6:{s:4:\"name\";s:16:\"Top padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:22:\"page_title-padding-top\";}s:25:\"page_title-padding-bottom\";a:6:{s:4:\"name\";s:19:\"Bottom padding (px)\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";s:2:\"id\";s:25:\"page_title-padding-bottom\";}s:19:\"general-show_titles\";a:6:{s:2:\"id\";s:19:\"general-show_titles\";s:4:\"name\";s:10:\"Page title\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:1:\"1\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:55:\"/inc/admin/assets/images/general-showtitles-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:56:\"/inc/admin/assets/images/general-showtitles-disabled.gif\";}}}s:18:\"general-title_size\";a:7:{s:2:\"id\";s:18:\"general-title_size\";s:4:\"name\";s:10:\"Title size\";s:4:\"type\";s:6:\"select\";s:3:\"std\";s:6:\"normal\";s:5:\"class\";s:4:\"mini\";s:7:\"options\";a:9:{s:2:\"h1\";s:2:\"h1\";s:2:\"h2\";s:2:\"h2\";s:2:\"h3\";s:2:\"h3\";s:2:\"h4\";s:2:\"h4\";s:2:\"h5\";s:2:\"h5\";s:2:\"h6\";s:2:\"h6\";s:5:\"small\";s:5:\"small\";s:6:\"normal\";s:6:\"medium\";s:3:\"big\";s:5:\"large\";}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:19:\"general-show_titles\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}}}s:19:\"general-title_color\";a:5:{s:2:\"id\";s:19:\"general-title_color\";s:4:\"name\";s:11:\"Title color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:19:\"general-show_titles\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}}}s:24:\"general-show_breadcrumbs\";a:6:{s:2:\"id\";s:24:\"general-show_breadcrumbs\";s:4:\"name\";s:11:\"Breadcrumbs\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{i:1;a:2:{s:5:\"title\";s:7:\"Enabled\";s:3:\"src\";s:60:\"/inc/admin/assets/images/general-showbreadcrumbs-enabled.gif\";}i:0;a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:61:\"/inc/admin/assets/images/general-showbreadcrumbs-disabled.gif\";}}}s:25:\"general-breadcrumbs_color\";a:5:{s:2:\"id\";s:25:\"general-breadcrumbs_color\";s:4:\"name\";s:17:\"Breadcrumbs color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:24:\"general-show_breadcrumbs\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}}}s:28:\"general-breadcrumbs_bg_color\";a:7:{s:2:\"id\";s:28:\"general-breadcrumbs_bg_color\";s:4:\"name\";s:28:\"Breadcrumbs background color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:8:\"disabled\";s:7:\"options\";a:3:{s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:64:\"/inc/admin/assets/images/general-breadcrumbsbgcolor-disabled.gif\";}s:5:\"black\";a:2:{s:5:\"title\";s:5:\"Black\";s:3:\"src\";s:61:\"/inc/admin/assets/images/general-breadcrumbsbgcolor-black.gif\";}s:5:\"white\";a:2:{s:5:\"title\";s:5:\"White\";s:3:\"src\";s:61:\"/inc/admin/assets/images/general-breadcrumbsbgcolor-white.gif\";}}s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:24:\"general-show_breadcrumbs\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:1:\"1\";}}}}s:21:\"general-title_bg_mode\";a:7:{s:2:\"id\";s:21:\"general-title_bg_mode\";s:4:\"name\";s:23:\"Title background / line\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:12:\"content_line\";s:7:\"options\";a:5:{s:8:\"disabled\";a:2:{s:5:\"title\";s:8:\"Disabled\";s:3:\"src\";s:59:\"/inc/admin/assets/images/general-title_bg_mode-disabled.gif\";}s:12:\"content_line\";a:2:{s:5:\"title\";s:18:\"Content-width line\";s:3:\"src\";s:69:\"/inc/admin/assets/images/general-title_bg_mode-content-width-line.gif\";}s:14:\"fullwidth_line\";a:2:{s:5:\"title\";s:15:\"Full-width line\";s:3:\"src\";s:66:\"/inc/admin/assets/images/general-title_bg_mode-full-width-line.gif\";}s:10:\"background\";a:2:{s:5:\"title\";s:10:\"Background\";s:3:\"src\";s:35:\"/inc/admin/assets/images/centre.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:8:\"Gradient\";s:3:\"src\";s:59:\"/inc/admin/assets/images/general-title_bg_mode-gradient.gif\";}}s:9:\"show_hide\";a:2:{s:10:\"background\";a:3:{i:0;s:36:\"general-title-bg-mode-main-container\";i:1;s:22:\"general-title-bg-image\";i:2;s:28:\"general-title-bg-solid-color\";}s:8:\"gradient\";a:2:{i:0;s:36:\"general-title-bg-mode-main-container\";i:1;s:31:\"general-title-bg-gradient-color\";}}}s:17:\"header-background\";a:7:{s:2:\"id\";s:17:\"header-background\";s:4:\"name\";s:12:\"Header style\";s:3:\"std\";s:6:\"normal\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:3:{s:6:\"normal\";a:2:{s:3:\"src\";s:54:\"/inc/admin/assets/images/header-background-default.gif\";s:5:\"title\";s:7:\"Default\";}s:7:\"overlap\";a:2:{s:3:\"src\";s:58:\"/inc/admin/assets/images/header-background-overlapping.gif\";s:5:\"title\";s:11:\"Overlapping\";}s:11:\"transparent\";a:2:{s:3:\"src\";s:58:\"/inc/admin/assets/images/header-background-transparent.gif\";s:5:\"title\";s:11:\"Transparent\";}}s:9:\"show_hide\";a:1:{s:11:\"transparent\";b:1;}}s:27:\"header-transparent_bg_color\";a:4:{s:2:\"id\";s:27:\"header-transparent_bg_color\";s:4:\"name\";s:28:\"Transparent background color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#000000\";}s:29:\"header-transparent_bg_opacity\";a:5:{s:2:\"id\";s:29:\"header-transparent_bg_opacity\";s:4:\"name\";s:30:\"Transparent background opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";s:2:\"50\";s:7:\"options\";a:2:{s:3:\"min\";i:0;s:3:\"max\";i:100;}}s:52:\"page_title-background-style-transparent-color_scheme\";a:5:{s:2:\"id\";s:52:\"page_title-background-style-transparent-color_scheme\";s:4:\"name\";s:12:\"Color scheme\";s:4:\"type\";s:5:\"radio\";s:3:\"std\";s:12:\"from_options\";s:7:\"options\";a:2:{s:12:\"from_options\";s:18:\"From Theme Options\";s:5:\"light\";s:5:\"Light\";}}s:22:\"general-title_bg_color\";a:4:{s:2:\"id\";s:22:\"general-title_bg_color\";s:4:\"name\";s:16:\"Background color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#ffffff\";}s:24:\"general-title_bg_opacity\";a:4:{s:2:\"id\";s:24:\"general-title_bg_opacity\";s:4:\"name\";s:18:\"Background opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:24:\"general-title_decoration\";a:7:{s:2:\"id\";s:24:\"general-title_decoration\";s:4:\"name\";s:10:\"Decoration\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:3:\"std\";s:4:\"none\";s:9:\"show_hide\";a:1:{s:7:\"outline\";b:1;}s:7:\"options\";a:2:{s:4:\"none\";a:2:{s:5:\"title\";s:4:\"None\";s:3:\"src\";s:35:\"/inc/admin/assets/images/centre.gif\";}s:7:\"outline\";a:2:{s:5:\"title\";s:4:\"Line\";s:3:\"src\";s:58:\"/inc/admin/assets/images/general-title_decoration-line.gif\";}}}s:38:\"general-title_decoration_outline_color\";a:4:{s:2:\"id\";s:38:\"general-title_decoration_outline_color\";s:4:\"name\";s:24:\"Decoration outline color\";s:4:\"type\";s:5:\"color\";s:3:\"std\";s:7:\"#FFFFFF\";}s:40:\"general-title_decoration_outline_opacity\";a:4:{s:2:\"id\";s:40:\"general-title_decoration_outline_opacity\";s:4:\"name\";s:26:\"Decoration outline opacity\";s:4:\"type\";s:6:\"slider\";s:3:\"std\";i:100;}s:25:\"general-title_bg_gradient\";a:4:{s:2:\"id\";s:25:\"general-title_bg_gradient\";s:4:\"name\";s:16:\"Background color\";s:4:\"type\";s:8:\"gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}}s:22:\"general-title_bg_image\";a:4:{s:2:\"id\";s:22:\"general-title_bg_image\";s:4:\"name\";s:20:\"Add background image\";s:4:\"type\";s:14:\"background_img\";s:3:\"std\";a:4:{s:5:\"image\";s:0:\"\";s:6:\"repeat\";s:6:\"repeat\";s:10:\"position_x\";s:6:\"center\";s:10:\"position_y\";s:6:\"center\";}}s:27:\"general-title_bg_fullscreen\";a:4:{s:2:\"id\";s:27:\"general-title_bg_fullscreen\";s:4:\"name\";s:11:\"Fullscreen \";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:22:\"general-title_bg_fixed\";a:4:{s:2:\"id\";s:22:\"general-title_bg_fixed\";s:4:\"name\";s:6:\"Fixed \";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:25:\"general-title_bg_parallax\";a:5:{s:2:\"id\";s:25:\"general-title_bg_parallax\";s:4:\"name\";s:32:\"Enable parallax & Parallax speed\";s:4:\"type\";s:4:\"text\";s:3:\"std\";s:1:\"0\";s:5:\"class\";s:4:\"mini\";}s:21:\"content-headers_color\";a:4:{s:4:\"name\";s:13:\"Headers color\";s:2:\"id\";s:21:\"content-headers_color\";s:3:\"std\";s:7:\"#252525\";s:4:\"type\";s:5:\"color\";}s:26:\"content-primary_text_color\";a:4:{s:4:\"name\";s:18:\"Primary text color\";s:2:\"id\";s:26:\"content-primary_text_color\";s:3:\"std\";s:7:\"#686868\";s:4:\"type\";s:5:\"color\";}s:28:\"content-secondary_text_color\";a:4:{s:4:\"name\";s:20:\"Secondary text color\";s:2:\"id\";s:28:\"content-secondary_text_color\";s:3:\"std\";s:7:\"#999999\";s:4:\"type\";s:5:\"color\";}s:17:\"fonts-font_family\";a:6:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:24:\"Choose basic font-family\";s:2:\"id\";s:17:\"fonts-font_family\";s:3:\"std\";s:9:\"Open Sans\";s:4:\"type\";s:9:\"web_fonts\";s:5:\"fonts\";s:3:\"all\";}s:14:\"fonts-big_size\";a:7:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:15:\"Large font size\";s:2:\"id\";s:14:\"fonts-big_size\";s:3:\"std\";i:15;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:26:\"fonts-big_size_line_height\";a:6:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:17:\"Large line-height\";s:2:\"id\";s:26:\"fonts-big_size_line_height\";s:3:\"std\";i:20;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}}s:17:\"fonts-normal_size\";a:7:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:16:\"Medium font size\";s:2:\"id\";s:17:\"fonts-normal_size\";s:3:\"std\";i:13;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:29:\"fonts-normal_size_line_height\";a:6:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:18:\"Medium line-height\";s:2:\"id\";s:29:\"fonts-normal_size_line_height\";s:3:\"std\";i:20;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}}s:16:\"fonts-small_size\";a:7:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:15:\"Small font size\";s:2:\"id\";s:16:\"fonts-small_size\";s:3:\"std\";i:11;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:28:\"fonts-small_size_line_height\";a:6:{s:4:\"desc\";s:0:\"\";s:4:\"name\";s:17:\"Small line-height\";s:2:\"id\";s:28:\"fonts-small_size_line_height\";s:3:\"std\";i:20;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}}s:20:\"fonts-h1_font_family\";a:5:{s:4:\"name\";s:11:\"Font-family\";s:2:\"id\";s:20:\"fonts-h1_font_family\";s:3:\"std\";s:9:\"Open Sans\";s:4:\"type\";s:9:\"web_fonts\";s:5:\"fonts\";s:3:\"all\";}s:18:\"fonts-h1_font_size\";a:6:{s:4:\"name\";s:9:\"Font-size\";s:2:\"id\";s:18:\"fonts-h1_font_size\";s:3:\"std\";i:44;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:20:\"fonts-h1_line_height\";a:4:{s:4:\"name\";s:11:\"Line-height\";s:2:\"id\";s:20:\"fonts-h1_line_height\";s:3:\"std\";i:50;s:4:\"type\";s:6:\"slider\";}s:18:\"fonts-h1_uppercase\";a:4:{s:4:\"name\";s:10:\"Capitalize\";s:2:\"id\";s:18:\"fonts-h1_uppercase\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:20:\"fonts-h2_font_family\";a:5:{s:4:\"name\";s:11:\"Font-family\";s:2:\"id\";s:20:\"fonts-h2_font_family\";s:3:\"std\";s:9:\"Open Sans\";s:4:\"type\";s:9:\"web_fonts\";s:5:\"fonts\";s:3:\"all\";}s:18:\"fonts-h2_font_size\";a:6:{s:4:\"name\";s:9:\"Font-size\";s:2:\"id\";s:18:\"fonts-h2_font_size\";s:3:\"std\";i:26;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:20:\"fonts-h2_line_height\";a:4:{s:4:\"name\";s:11:\"Line-height\";s:2:\"id\";s:20:\"fonts-h2_line_height\";s:3:\"std\";i:30;s:4:\"type\";s:6:\"slider\";}s:18:\"fonts-h2_uppercase\";a:4:{s:4:\"name\";s:10:\"Capitalize\";s:2:\"id\";s:18:\"fonts-h2_uppercase\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:20:\"fonts-h3_font_family\";a:5:{s:4:\"name\";s:11:\"Font-family\";s:2:\"id\";s:20:\"fonts-h3_font_family\";s:3:\"std\";s:9:\"Open Sans\";s:4:\"type\";s:9:\"web_fonts\";s:5:\"fonts\";s:3:\"all\";}s:18:\"fonts-h3_font_size\";a:6:{s:4:\"name\";s:9:\"Font-size\";s:2:\"id\";s:18:\"fonts-h3_font_size\";s:3:\"std\";i:22;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:20:\"fonts-h3_line_height\";a:4:{s:4:\"name\";s:11:\"Line-height\";s:2:\"id\";s:20:\"fonts-h3_line_height\";s:3:\"std\";i:30;s:4:\"type\";s:6:\"slider\";}s:18:\"fonts-h3_uppercase\";a:4:{s:4:\"name\";s:10:\"Capitalize\";s:2:\"id\";s:18:\"fonts-h3_uppercase\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:20:\"fonts-h4_font_family\";a:5:{s:4:\"name\";s:11:\"Font-family\";s:2:\"id\";s:20:\"fonts-h4_font_family\";s:3:\"std\";s:9:\"Open Sans\";s:4:\"type\";s:9:\"web_fonts\";s:5:\"fonts\";s:3:\"all\";}s:18:\"fonts-h4_font_size\";a:6:{s:4:\"name\";s:9:\"Font-size\";s:2:\"id\";s:18:\"fonts-h4_font_size\";s:3:\"std\";i:18;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:20:\"fonts-h4_line_height\";a:4:{s:4:\"name\";s:11:\"Line-height\";s:2:\"id\";s:20:\"fonts-h4_line_height\";s:3:\"std\";i:20;s:4:\"type\";s:6:\"slider\";}s:18:\"fonts-h4_uppercase\";a:4:{s:4:\"name\";s:10:\"Capitalize\";s:2:\"id\";s:18:\"fonts-h4_uppercase\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:20:\"fonts-h5_font_family\";a:5:{s:4:\"name\";s:11:\"Font-family\";s:2:\"id\";s:20:\"fonts-h5_font_family\";s:3:\"std\";s:9:\"Open Sans\";s:4:\"type\";s:9:\"web_fonts\";s:5:\"fonts\";s:3:\"all\";}s:18:\"fonts-h5_font_size\";a:6:{s:4:\"name\";s:9:\"Font-size\";s:2:\"id\";s:18:\"fonts-h5_font_size\";s:3:\"std\";i:15;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:20:\"fonts-h5_line_height\";a:4:{s:4:\"name\";s:11:\"Line-height\";s:2:\"id\";s:20:\"fonts-h5_line_height\";s:3:\"std\";i:20;s:4:\"type\";s:6:\"slider\";}s:18:\"fonts-h5_uppercase\";a:4:{s:4:\"name\";s:10:\"Capitalize\";s:2:\"id\";s:18:\"fonts-h5_uppercase\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:20:\"fonts-h6_font_family\";a:5:{s:4:\"name\";s:11:\"Font-family\";s:2:\"id\";s:20:\"fonts-h6_font_family\";s:3:\"std\";s:9:\"Open Sans\";s:4:\"type\";s:9:\"web_fonts\";s:5:\"fonts\";s:3:\"all\";}s:18:\"fonts-h6_font_size\";a:6:{s:4:\"name\";s:9:\"Font-size\";s:2:\"id\";s:18:\"fonts-h6_font_size\";s:3:\"std\";i:12;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:20:\"fonts-h6_line_height\";a:4:{s:4:\"name\";s:11:\"Line-height\";s:2:\"id\";s:20:\"fonts-h6_line_height\";s:3:\"std\";i:20;s:4:\"type\";s:6:\"slider\";}s:18:\"fonts-h6_uppercase\";a:4:{s:4:\"name\";s:10:\"Capitalize\";s:2:\"id\";s:18:\"fonts-h6_uppercase\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:13:\"buttons-style\";a:6:{s:4:\"name\";s:20:\"Choose buttons style\";s:2:\"id\";s:13:\"buttons-style\";s:3:\"std\";s:4:\"ios7\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:4:{s:4:\"ios7\";a:2:{s:5:\"title\";s:3:\"iOS\";s:3:\"src\";s:46:\"/inc/admin/assets/images/buttons-style-ios.gif\";}s:4:\"flat\";a:2:{s:5:\"title\";s:4:\"Flat\";s:3:\"src\";s:47:\"/inc/admin/assets/images/buttons-style-flat.gif\";}s:2:\"3d\";a:2:{s:5:\"title\";s:2:\"3D\";s:3:\"src\";s:45:\"/inc/admin/assets/images/buttons-style-3d.gif\";}s:8:\"material\";a:2:{s:5:\"title\";s:15:\"Material design\";s:3:\"src\";s:51:\"/inc/admin/assets/images/buttons-style-material.gif\";}}}s:18:\"buttons-color_mode\";a:7:{s:4:\"name\";s:13:\"Buttons color\";s:2:\"id\";s:18:\"buttons-color_mode\";s:3:\"std\";s:6:\"accent\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:9:\"show_hide\";a:2:{s:5:\"color\";s:18:\"buttons-mode-color\";s:8:\"gradient\";s:21:\"buttons-mode-gradient\";}s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:13:\"buttons-color\";a:4:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:13:\"buttons-color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:22:\"buttons-color_gradient\";a:4:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:22:\"buttons-color_gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:4:\"type\";s:8:\"gradient\";}s:24:\"buttons-hover_color_mode\";a:8:{s:4:\"name\";s:19:\"Buttons hover color\";s:2:\"id\";s:24:\"buttons-hover_color_mode\";s:3:\"std\";s:6:\"accent\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"divider\";s:3:\"top\";s:9:\"show_hide\";a:2:{s:5:\"color\";s:24:\"buttons-hover-mode-color\";s:8:\"gradient\";s:27:\"buttons-hover-mode-gradient\";}s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:19:\"buttons-hover_color\";a:4:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:19:\"buttons-hover_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:28:\"buttons-hover_color_gradient\";a:4:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:28:\"buttons-hover_color_gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:4:\"type\";s:8:\"gradient\";}s:23:\"buttons-text_color_mode\";a:8:{s:4:\"name\";s:10:\"Text color\";s:2:\"id\";s:23:\"buttons-text_color_mode\";s:3:\"std\";s:5:\"color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"divider\";s:3:\"top\";s:9:\"show_hide\";a:1:{s:5:\"color\";b:1;}s:7:\"options\";a:2:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}}}s:18:\"buttons-text_color\";a:4:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:18:\"buttons-text_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:29:\"buttons-text_hover_color_mode\";a:8:{s:4:\"name\";s:16:\"Text hover color\";s:2:\"id\";s:29:\"buttons-text_hover_color_mode\";s:3:\"std\";s:5:\"color\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"divider\";s:3:\"top\";s:9:\"show_hide\";a:1:{s:5:\"color\";b:1;}s:7:\"options\";a:2:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}}}s:24:\"buttons-text_hover_color\";a:4:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:24:\"buttons-text_hover_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";}s:21:\"buttons-s_font_family\";a:5:{s:4:\"name\";s:11:\"Font-family\";s:2:\"id\";s:21:\"buttons-s_font_family\";s:3:\"std\";s:9:\"Open Sans\";s:4:\"type\";s:9:\"web_fonts\";s:5:\"fonts\";s:3:\"all\";}s:19:\"buttons-s_font_size\";a:6:{s:4:\"name\";s:9:\"Font-size\";s:2:\"id\";s:19:\"buttons-s_font_size\";s:3:\"std\";i:12;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:19:\"buttons-s_uppercase\";a:4:{s:4:\"name\";s:10:\"Capitalize\";s:2:\"id\";s:19:\"buttons-s_uppercase\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:21:\"buttons-s_line_height\";a:4:{s:4:\"name\";s:11:\"Line-height\";s:2:\"id\";s:21:\"buttons-s_line_height\";s:3:\"std\";i:21;s:4:\"type\";s:6:\"slider\";}s:23:\"buttons-s_border_radius\";a:6:{s:4:\"name\";s:18:\"Border Radius (px)\";s:2:\"id\";s:23:\"buttons-s_border_radius\";s:5:\"class\";s:4:\"mini\";s:3:\"std\";s:1:\"4\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:10:\"dimensions\";}s:21:\"buttons-m_font_family\";a:5:{s:4:\"name\";s:11:\"Font-family\";s:2:\"id\";s:21:\"buttons-m_font_family\";s:3:\"std\";s:9:\"Open Sans\";s:4:\"type\";s:9:\"web_fonts\";s:5:\"fonts\";s:3:\"all\";}s:19:\"buttons-m_font_size\";a:6:{s:4:\"name\";s:9:\"Font-size\";s:2:\"id\";s:19:\"buttons-m_font_size\";s:3:\"std\";i:12;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:19:\"buttons-m_uppercase\";a:4:{s:4:\"name\";s:10:\"Capitalize\";s:2:\"id\";s:19:\"buttons-m_uppercase\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:21:\"buttons-m_line_height\";a:4:{s:4:\"name\";s:11:\"Line-height\";s:2:\"id\";s:21:\"buttons-m_line_height\";s:3:\"std\";i:23;s:4:\"type\";s:6:\"slider\";}s:23:\"buttons-m_border_radius\";a:6:{s:4:\"name\";s:18:\"Border Radius (px)\";s:2:\"id\";s:23:\"buttons-m_border_radius\";s:5:\"class\";s:4:\"mini\";s:3:\"std\";s:1:\"4\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:10:\"dimensions\";}s:21:\"buttons-l_font_family\";a:5:{s:4:\"name\";s:11:\"Font-family\";s:2:\"id\";s:21:\"buttons-l_font_family\";s:3:\"std\";s:9:\"Open Sans\";s:4:\"type\";s:9:\"web_fonts\";s:5:\"fonts\";s:3:\"all\";}s:19:\"buttons-l_font_size\";a:6:{s:4:\"name\";s:9:\"Font-size\";s:2:\"id\";s:19:\"buttons-l_font_size\";s:3:\"std\";i:14;s:4:\"type\";s:6:\"slider\";s:7:\"options\";a:2:{s:3:\"min\";i:9;s:3:\"max\";i:120;}s:8:\"sanitize\";s:9:\"font_size\";}s:19:\"buttons-l_uppercase\";a:4:{s:4:\"name\";s:10:\"Capitalize\";s:2:\"id\";s:19:\"buttons-l_uppercase\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:0;}s:21:\"buttons-l_line_height\";a:4:{s:4:\"name\";s:11:\"Line-height\";s:2:\"id\";s:21:\"buttons-l_line_height\";s:3:\"std\";i:32;s:4:\"type\";s:6:\"slider\";}s:23:\"buttons-l_border_radius\";a:6:{s:4:\"name\";s:18:\"Border Radius (px)\";s:2:\"id\";s:23:\"buttons-l_border_radius\";s:5:\"class\";s:4:\"mini\";s:3:\"std\";s:1:\"4\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:10:\"dimensions\";}s:17:\"image_hover-style\";a:7:{s:4:\"name\";s:28:\"Image &amp; hover decoration\";s:4:\"desc\";s:80:\"May not have effect on some portfolio, photo albums and shortcodes image hovers.\";s:2:\"id\";s:17:\"image_hover-style\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:5:{s:4:\"none\";a:2:{s:5:\"title\";s:4:\"None\";s:3:\"src\";s:51:\"/inc/admin/assets/images/image_hover-style-none.gif\";}s:9:\"grayscale\";a:2:{s:5:\"title\";s:9:\"Grayscale\";s:3:\"src\";s:56:\"/inc/admin/assets/images/image_hover-style-grayscale.gif\";}s:10:\"gray_color\";a:2:{s:5:\"title\";s:27:\"Grayscale with color hovers\";s:3:\"src\";s:73:\"/inc/admin/assets/images/image_hover-style-grayscale-with-color-hover.gif\";}s:4:\"blur\";a:2:{s:5:\"title\";s:4:\"Blur\";s:3:\"src\";s:51:\"/inc/admin/assets/images/image_hover-style-blur.gif\";}s:5:\"scale\";a:2:{s:5:\"title\";s:5:\"Scale\";s:3:\"src\";s:52:\"/inc/admin/assets/images/image_hover-style-scale.gif\";}}}s:29:\"image_hover-onclick_animation\";a:4:{s:4:\"name\";s:18:\"Animation on click\";s:2:\"id\";s:29:\"image_hover-onclick_animation\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:24:\"image_hover-default_icon\";a:6:{s:4:\"name\";s:4:\"Icon\";s:2:\"id\";s:24:\"image_hover-default_icon\";s:3:\"std\";s:4:\"none\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:3:{s:4:\"none\";a:2:{s:5:\"title\";s:7:\"No icon\";s:3:\"src\";s:56:\"/inc/admin/assets/images/image_hover-style-grayscale.gif\";}s:12:\"small_corner\";a:2:{s:5:\"title\";s:24:\"Small icon in the corner\";s:3:\"src\";s:64:\"/inc/admin/assets/images/image_hover-default_icon-small-icon.gif\";}s:10:\"big_center\";a:2:{s:5:\"title\";s:19:\"Large centered icon\";s:3:\"src\";s:64:\"/inc/admin/assets/images/image_hover-default_icon-large-icon.gif\";}}}s:22:\"image_hover-color_mode\";a:6:{s:4:\"name\";s:23:\"Hovers background color\";s:2:\"id\";s:22:\"image_hover-color_mode\";s:3:\"std\";s:6:\"accent\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:17:\"image_hover-color\";a:5:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:17:\"image_hover-color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:22:\"image_hover-color_mode\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:26:\"image_hover-color_gradient\";a:5:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:26:\"image_hover-color_gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:4:\"type\";s:8:\"gradient\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:22:\"image_hover-color_mode\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:19:\"image_hover-opacity\";a:4:{s:4:\"name\";s:25:\"Hovers background opacity\";s:2:\"id\";s:19:\"image_hover-opacity\";s:3:\"std\";i:30;s:4:\"type\";s:6:\"slider\";}s:31:\"image_hover-project_icons_style\";a:6:{s:4:\"name\";s:27:\"Icons on hover in portfolio\";s:2:\"id\";s:31:\"image_hover-project_icons_style\";s:3:\"std\";s:6:\"accent\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:4:{s:7:\"outline\";a:2:{s:5:\"title\";s:7:\"Outline\";s:3:\"src\";s:68:\"/inc/admin/assets/images/image_hover-project_icons_style-outline.gif\";}s:11:\"transparent\";a:2:{s:5:\"title\";s:15:\"Semitransparent\";s:3:\"src\";s:71:\"/inc/admin/assets/images/image_hover-project_icons_style-semitransp.gif\";}s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:67:\"/inc/admin/assets/images/image_hover-project_icons_style-accent.gif\";}s:5:\"small\";a:2:{s:5:\"title\";s:5:\"Small\";s:3:\"src\";s:66:\"/inc/admin/assets/images/image_hover-project_icons_style-small.gif\";}}}s:34:\"image_hover-album_miniatures_style\";a:7:{s:4:\"name\";s:41:\"Image minuatures on hover in photo albums\";s:2:\"id\";s:34:\"image_hover-album_miniatures_style\";s:5:\"style\";s:8:\"vertical\";s:3:\"std\";s:7:\"style_1\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:2:{s:7:\"style_1\";a:2:{s:5:\"title\";s:42:\"Overlapping miniatures of a different size\";s:3:\"src\";s:65:\"/inc/admin/assets/images/image_hover-album_miniatures_style-1.gif\";}s:7:\"style_2\";a:2:{s:5:\"title\";s:25:\"Three miniatures in a row\";s:3:\"src\";s:65:\"/inc/admin/assets/images/image_hover-album_miniatures_style-2.gif\";}}}s:39:\"image_hover-project_rollover_color_mode\";a:6:{s:4:\"name\";s:23:\"Hovers background color\";s:2:\"id\";s:39:\"image_hover-project_rollover_color_mode\";s:3:\"std\";s:6:\"accent\";s:4:\"type\";s:6:\"images\";s:5:\"class\";s:5:\"small\";s:7:\"options\";a:3:{s:6:\"accent\";a:2:{s:5:\"title\";s:6:\"Accent\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-accent.gif\";}s:5:\"color\";a:2:{s:5:\"title\";s:12:\"Custom color\";s:3:\"src\";s:41:\"/inc/admin/assets/images/color-custom.gif\";}s:8:\"gradient\";a:2:{s:5:\"title\";s:15:\"Custom gradient\";s:3:\"src\";s:50:\"/inc/admin/assets/images/color-custom-gradient.gif\";}}}s:34:\"image_hover-project_rollover_color\";a:5:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:34:\"image_hover-project_rollover_color\";s:3:\"std\";s:7:\"#ffffff\";s:4:\"type\";s:5:\"color\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:39:\"image_hover-project_rollover_color_mode\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:5:\"color\";}}}}s:43:\"image_hover-project_rollover_color_gradient\";a:5:{s:4:\"name\";s:6:\"&nbsp;\";s:2:\"id\";s:43:\"image_hover-project_rollover_color_gradient\";s:3:\"std\";a:2:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#000000\";}s:4:\"type\";s:8:\"gradient\";s:10:\"dependency\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"field\";s:39:\"image_hover-project_rollover_color_mode\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"gradient\";}}}}s:36:\"image_hover-project_rollover_opacity\";a:4:{s:4:\"name\";s:25:\"Hovers background opacity\";s:2:\"id\";s:36:\"image_hover-project_rollover_opacity\";s:3:\"std\";i:70;s:4:\"type\";s:6:\"slider\";}s:25:\"social_buttons-visibility\";a:5:{s:4:\"name\";s:24:\"Share buttons appearance\";s:2:\"id\";s:25:\"social_buttons-visibility\";s:3:\"std\";s:8:\"on_hover\";s:4:\"type\";s:6:\"images\";s:7:\"options\";a:2:{s:8:\"on_hover\";a:2:{s:5:\"title\";s:13:\"Show on hover\";s:3:\"src\";s:60:\"/inc/admin/assets/images/social_buttons-visibility-hover.gif\";}s:7:\"allways\";a:2:{s:5:\"title\";s:14:\"Always visible\";s:3:\"src\";s:62:\"/inc/admin/assets/images/social_buttons-visibility-visible.gif\";}}}s:32:\"social_buttons-post-button_title\";a:4:{s:4:\"name\";s:12:\"Button title\";s:2:\"id\";s:32:\"social_buttons-post-button_title\";s:3:\"std\";s:15:\"Share this post\";s:4:\"type\";s:4:\"text\";}s:19:\"social_buttons-post\";a:3:{s:2:\"id\";s:19:\"social_buttons-post\";s:3:\"std\";a:0:{}s:4:\"type\";s:14:\"social_buttons\";}s:42:\"social_buttons-portfolio_post-button_title\";a:4:{s:4:\"name\";s:12:\"Button title\";s:2:\"id\";s:42:\"social_buttons-portfolio_post-button_title\";s:3:\"std\";s:15:\"Share this post\";s:4:\"type\";s:4:\"text\";}s:29:\"social_buttons-portfolio_post\";a:3:{s:2:\"id\";s:29:\"social_buttons-portfolio_post\";s:3:\"std\";a:0:{}s:4:\"type\";s:14:\"social_buttons\";}s:33:\"social_buttons-photo-button_title\";a:4:{s:4:\"name\";s:12:\"Button title\";s:2:\"id\";s:33:\"social_buttons-photo-button_title\";s:3:\"std\";s:16:\"Share this image\";s:4:\"type\";s:4:\"text\";}s:20:\"social_buttons-photo\";a:3:{s:2:\"id\";s:20:\"social_buttons-photo\";s:3:\"std\";a:0:{}s:4:\"type\";s:14:\"social_buttons\";}s:32:\"social_buttons-page-button_title\";a:4:{s:4:\"name\";s:12:\"Button title\";s:2:\"id\";s:32:\"social_buttons-page-button_title\";s:3:\"std\";s:15:\"Share this page\";s:4:\"type\";s:4:\"text\";}s:19:\"social_buttons-page\";a:3:{s:2:\"id\";s:19:\"social_buttons-page\";s:3:\"std\";a:0:{}s:4:\"type\";s:14:\"social_buttons\";}s:11:\"widgetareas\";a:4:{s:2:\"id\";s:11:\"widgetareas\";s:4:\"type\";s:16:\"fields_generator\";s:3:\"std\";a:2:{i:1;a:2:{s:12:\"sidebar_name\";s:15:\"Default Sidebar\";s:12:\"sidebar_desc\";s:27:\"Sidebar primary widget area\";}i:2;a:2:{s:12:\"sidebar_name\";s:14:\"Default Footer\";s:12:\"sidebar_desc\";s:26:\"Footer primary widget area\";}}s:7:\"options\";a:2:{s:5:\"title\";s:19:\"Add new widget area\";s:6:\"fields\";a:2:{s:12:\"sidebar_name\";a:5:{s:4:\"type\";s:4:\"text\";s:5:\"class\";s:19:\"of_fields_gen_title\";s:11:\"description\";s:12:\"Sidebar name\";s:4:\"wrap\";s:23:\"<label>%2$s%1$s</label>\";s:9:\"desc_wrap\";s:4:\"%2$s\";}s:12:\"sidebar_desc\";a:4:{s:4:\"type\";s:8:\"textarea\";s:11:\"description\";s:30:\"Sidebar description (optional)\";s:4:\"wrap\";s:23:\"<label>%2$s%1$s</label>\";s:9:\"desc_wrap\";s:4:\"%2$s\";}}}}s:13:\"import_export\";a:4:{s:2:\"id\";s:13:\"import_export\";s:4:\"type\";s:21:\"import_export_options\";s:3:\"std\";s:0:\"\";s:8:\"settings\";a:1:{s:4:\"rows\";i:16;}}s:31:\"general-page_content_top_margin\";a:6:{s:4:\"name\";s:8:\"Top (px)\";s:2:\"id\";s:31:\"general-page_content_top_margin\";s:3:\"std\";s:2:\"50\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:34:\"general-page_content_bottom_margin\";a:6:{s:4:\"name\";s:11:\"Bottom (px)\";s:2:\"id\";s:34:\"general-page_content_bottom_margin\";s:3:\"std\";s:2:\"50\";s:4:\"type\";s:4:\"text\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:18:\"general-responsive\";a:6:{s:4:\"name\";s:17:\"Responsive layout\";s:2:\"id\";s:18:\"general-responsive\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:5:\"radio\";s:9:\"show_hide\";a:1:{i:1;b:1;}s:7:\"options\";a:2:{i:1;s:7:\"Enabled\";i:0;s:8:\"Disabled\";}}s:31:\"general-responsiveness-treshold\";a:7:{s:4:\"name\";s:41:\"Collapse content to one column after (px)\";s:4:\"desc\";s:104:\"Affects sidebar, blog list, portfolio list & some portfolio project layouts. Does not affect VC columns.\";s:2:\"id\";s:31:\"general-responsiveness-treshold\";s:3:\"std\";i:800;s:4:\"type\";s:4:\"text\";s:5:\"class\";s:4:\"mini\";s:8:\"sanitize\";s:10:\"dimensions\";}s:29:\"general-side_content_paddings\";a:5:{s:4:\"name\";s:18:\"Side paddings (px)\";s:2:\"id\";s:29:\"general-side_content_paddings\";s:3:\"std\";s:2:\"40\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:10:\"dimensions\";}s:31:\"general-switch_content_paddings\";a:5:{s:4:\"name\";s:37:\"When screen width is less then.. (px)\";s:2:\"id\";s:31:\"general-switch_content_paddings\";s:3:\"std\";s:3:\"640\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:10:\"dimensions\";}s:36:\"general-mobile_side_content_paddings\";a:5:{s:4:\"name\";s:20:\"..make paddings (px)\";s:2:\"id\";s:36:\"general-mobile_side_content_paddings\";s:3:\"std\";s:2:\"20\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:10:\"dimensions\";}s:27:\"general-images_lazy_loading\";a:6:{s:2:\"id\";s:27:\"general-images_lazy_loading\";s:4:\"name\";s:19:\"Images lazy loading\";s:4:\"desc\";s:56:\"Can dramatically reduce page loading speed. Recommended.\";s:3:\"std\";s:1:\"1\";s:4:\"type\";s:5:\"radio\";s:7:\"options\";a:2:{i:1;s:7:\"Enabled\";i:0;s:8:\"Disabled\";}}s:21:\"general-smooth_scroll\";a:5:{s:4:\"name\";s:55:\"Enable \"scroll-behaviour: smooth\" for next gen browsers\";s:2:\"id\";s:21:\"general-smooth_scroll\";s:3:\"std\";s:2:\"on\";s:4:\"type\";s:5:\"radio\";s:7:\"options\";a:3:{s:2:\"on\";s:3:\"Yes\";s:3:\"off\";s:2:\"No\";s:11:\"on_parallax\";s:30:\"On only on pages with parallax\";}}s:33:\"general-contact_form_send_mail_to\";a:6:{s:4:\"name\";s:6:\"E-mail\";s:4:\"desc\";s:32:\"Leave empty to use admin e-mail.\";s:2:\"id\";s:33:\"general-contact_form_send_mail_to\";s:3:\"std\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:8:\"sanitize\";s:5:\"email\";}s:34:\"general-hide_plugins_notifications\";a:4:{s:4:\"name\";s:40:\"Silence plugins activation notifications\";s:2:\"id\";s:34:\"general-hide_plugins_notifications\";s:4:\"type\";s:8:\"checkbox\";s:3:\"std\";i:1;}s:18:\"general-custom_css\";a:5:{s:8:\"settings\";a:1:{s:4:\"rows\";i:16;}s:2:\"id\";s:18:\"general-custom_css\";s:3:\"std\";b:0;s:4:\"type\";s:8:\"textarea\";s:8:\"sanitize\";s:16:\"without_sanitize\";}s:21:\"general-tracking_code\";a:5:{s:8:\"settings\";a:1:{s:4:\"rows\";i:16;}s:2:\"id\";s:21:\"general-tracking_code\";s:3:\"std\";b:0;s:4:\"type\";s:8:\"textarea\";s:8:\"sanitize\";s:16:\"without_sanitize\";}s:23:\"template_page_id_author\";a:3:{s:2:\"id\";s:23:\"template_page_id_author\";s:4:\"name\";s:23:\"Author archive template\";s:4:\"type\";s:10:\"pages_list\";}s:21:\"template_page_id_date\";a:3:{s:2:\"id\";s:21:\"template_page_id_date\";s:4:\"name\";s:21:\"Date archive template\";s:4:\"type\";s:10:\"pages_list\";}s:30:\"template_page_id_blog_category\";a:3:{s:2:\"id\";s:30:\"template_page_id_blog_category\";s:4:\"name\";s:22:\"Blog category template\";s:4:\"type\";s:10:\"pages_list\";}s:26:\"template_page_id_blog_tags\";a:3:{s:2:\"id\";s:26:\"template_page_id_blog_tags\";s:4:\"name\";s:18:\"Blog tags template\";s:4:\"type\";s:10:\"pages_list\";}s:23:\"template_page_id_search\";a:3:{s:2:\"id\";s:23:\"template_page_id_search\";s:4:\"name\";s:11:\"Search page\";s:4:\"type\";s:10:\"pages_list\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183067", "mc4wp_mailchimp_list_b462ee9c1a", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"b462ee9c1a\";s:6:\"web_id\";i:590681;s:4:\"name\";s:12:\"NCR MARIKINA\";s:16:\"subscriber_count\";i:23;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183068", "mc4wp_mailchimp_list_1707e0cea8", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"1707e0cea8\";s:6:\"web_id\";i:590697;s:4:\"name\";s:10:\"NCR MANILA\";s:16:\"subscriber_count\";i:13;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183069", "mc4wp_mailchimp_list_a85b37c4b8", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"a85b37c4b8\";s:6:\"web_id\";i:590689;s:4:\"name\";s:10:\"NCR MALATE\";s:16:\"subscriber_count\";i:63;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183070", "mc4wp_mailchimp_list_30548e1033", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"30548e1033\";s:6:\"web_id\";i:590721;s:4:\"name\";s:12:\"NCR SAN JUAN\";s:16:\"subscriber_count\";i:21;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183071", "mc4wp_mailchimp_list_fdf838c990", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"fdf838c990\";s:6:\"web_id\";i:590677;s:4:\"name\";s:9:\"NCR RIZAL\";s:16:\"subscriber_count\";i:17;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183072", "mc4wp_mailchimp_list_422ddead73", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"422ddead73\";s:6:\"web_id\";i:590661;s:4:\"name\";s:13:\"NCR PARANAQUE\";s:16:\"subscriber_count\";i:48;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183073", "mc4wp_mailchimp_list_7fb6b33e20", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"7fb6b33e20\";s:6:\"web_id\";i:590705;s:4:\"name\";s:14:\"NCR VALENZUELA\";s:16:\"subscriber_count\";i:5;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183074", "mc4wp_mailchimp_list_35eee68413", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"35eee68413\";s:6:\"web_id\";i:590629;s:4:\"name\";s:14:\"NCR MUNTINLUPA\";s:16:\"subscriber_count\";i:23;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183075", "mc4wp_mailchimp_list_0c034b97cb", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"0c034b97cb\";s:6:\"web_id\";i:590709;s:4:\"name\";s:10:\"NCR MAKATI\";s:16:\"subscriber_count\";i:104;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183076", "mc4wp_mailchimp_list_9c544ae962", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"9c544ae962\";s:6:\"web_id\";i:590701;s:4:\"name\";s:10:\"NCR QUEZON\";s:16:\"subscriber_count\";i:120;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183077", "mc4wp_mailchimp_list_b931cc8dba", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"b931cc8dba\";s:6:\"web_id\";i:590693;s:4:\"name\";s:11:\"NCR BINONDO\";s:16:\"subscriber_count\";i:73;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183078", "mc4wp_mailchimp_list_2b9c89dc24", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"2b9c89dc24\";s:6:\"web_id\";i:590673;s:4:\"name\";s:12:\"NCR CALOOCAN\";s:16:\"subscriber_count\";i:16;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183079", "mc4wp_mailchimp_list_91f72f4c92", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"91f72f4c92\";s:6:\"web_id\";i:590669;s:4:\"name\";s:10:\"NCR TAGUIG\";s:16:\"subscriber_count\";i:15;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183080", "mc4wp_mailchimp_list_be73db82c2", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"be73db82c2\";s:6:\"web_id\";i:590717;s:4:\"name\";s:15:\"NCR MANDALUYONG\";s:16:\"subscriber_count\";i:52;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183081", "mc4wp_mailchimp_list_cbec1c39a9", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"cbec1c39a9\";s:6:\"web_id\";i:590665;s:4:\"name\";s:9:\"NCR PASAY\";s:16:\"subscriber_count\";i:51;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183082", "mc4wp_mailchimp_list_fc18acd5bb", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"fc18acd5bb\";s:6:\"web_id\";i:590637;s:4:\"name\";s:13:\"NCR LAS PINAS\";s:16:\"subscriber_count\";i:45;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183083", "mc4wp_mailchimp_list_8bd500584a", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"8bd500584a\";s:6:\"web_id\";i:590713;s:4:\"name\";s:9:\"NCR PASIG\";s:16:\"subscriber_count\";i:55;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("183084", "mc4wp_mailchimp_list_10b21522fd", "O:20:\"MC4WP_MailChimp_List\":7:{s:2:\"id\";s:10:\"10b21522fd\";s:6:\"web_id\";i:590685;s:4:\"name\";s:10:\"NCR ERMITA\";s:16:\"subscriber_count\";i:92;s:12:\"merge_fields\";a:6:{i:0;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:13:\"Email Address\";s:10:\"field_type\";s:5:\"email\";s:3:\"tag\";s:5:\"EMAIL\";s:8:\"required\";b:1;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:1;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:7:\"Address\";s:10:\"field_type\";s:7:\"address\";s:3:\"tag\";s:7:\"ADDRESS\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}i:2;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:10:\"First Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"FNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:3;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:9:\"Last Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:5:\"LNAME\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:4;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:11:\"Agency Name\";s:10:\"field_type\";s:4:\"text\";s:3:\"tag\";s:7:\"MMERGE5\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:1;s:13:\"default_value\";s:0:\"\";}i:5;O:27:\"MC4WP_MailChimp_Merge_Field\":7:{s:4:\"name\";s:12:\"Phone Number\";s:10:\"field_type\";s:5:\"phone\";s:3:\"tag\";s:5:\"PHONE\";s:8:\"required\";b:0;s:7:\"choices\";a:0:{}s:6:\"public\";b:0;s:13:\"default_value\";s:0:\"\";}}s:19:\"interest_categories\";a:0:{}s:17:\"campaign_defaults\";O:8:\"stdClass\":2:{s:9:\"from_name\";s:30:\"Travelite Travel and Tours MNL\";s:10:\"from_email\";s:21:\"info@travelite.com.ph\";}}", "no");
INSERT INTO `trvlite_options` VALUES("200740", "akismet_comment_form_privacy_notice", "hide", "yes");
INSERT INTO `trvlite_options` VALUES("203571", "_transient_timeout_plugin_slugs", "1537694279", "no");
INSERT INTO `trvlite_options` VALUES("203551", "_transient_timeout_wfcredentialstatus_1", "1537609005", "no");
INSERT INTO `trvlite_options` VALUES("203552", "_transient_wfcredentialstatus_1", "0f0c08b89442e7ff0f4178612dae2385dcd476459501f3f8498f6b30c12e0cc2d", "no");
INSERT INTO `trvlite_options` VALUES("203553", "_transient_timeout_users_online", "1537611868", "no");
INSERT INTO `trvlite_options` VALUES("203554", "_transient_users_online", "a:1:{i:0;a:3:{s:7:\"user_id\";i:1;s:13:\"last_activity\";i:1537638868;s:10:\"ip_address\";s:13:\"49.145.133.20\";}}", "no");
INSERT INTO `trvlite_options` VALUES("203539", "_transient_timeout_sbi_header_973906762", "1537600541", "no");
INSERT INTO `trvlite_options` VALUES("203540", "_transient_sbi_header_973906762", "%7B%22data%22:%7B%22id%22:%22973906762%22,%22username%22:%22travelite_ph%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22bio%22:%22%F0%9F%93%AE%20Manila%20I%20Cebu%20I%20Davao%5Cn%E2%98%8E%20Manila%20-%20(02)%20633%208434;%20Cebu%20-%20(032)%20255%203264;%20Davao%20-%20(082)%20305%200146%5Cn#traveliteph%20#travelwithtravelite%22,%22website%22:%22http://www.travelite.com.ph/%22,%22is_business%22:true,%22counts%22:%7B%22media%22:299,%22follows%22:127,%22followed_by%22:999%7D%7D,%22meta%22:%7B%22code%22:200%7D%7D", "no");
INSERT INTO `trvlite_options` VALUES("203541", "_transient_timeout_sbi_973906762", "1537600545", "no");
INSERT INTO `trvlite_options` VALUES("203542", "_transient_sbi_973906762", "%7B%22pagination%22:%7B%22next_max_id%22:%221773311086800678962_973906762%22,%22next_url%22:%5B%22https://api.instagram.com/v1/users/973906762/media/recent?access_token=973906762.3a81a9f.44de59b1d6d04413b9560d76598cfade&count=33&callback=jQuery112406955407727395817_1537597127585&_=1537597127586&max_id=1773311086800678962_973906762%22%5D%7D,%22data%22:%5B%7B%22id%22:%221855851610102837159_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/2def11eb29ff1b9d9d6a7d5e9ee5cb8a/5C3FF8FB/t51.2885-15/e35/s150x150/39304318_891836011010998_4614307756659179520_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/97e6f0c4bac2cd33a93bcd372d10d0b3/5C25E10B/t51.2885-15/e35/s320x320/39304318_891836011010998_4614307756659179520_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/5f366f488f80d420e666357dde447382/5C40E15C/t51.2885-15/sh0.08/e35/s640x640/39304318_891836011010998_4614307756659179520_n.jpg%22%7D%7D,%22created_time%22:%221535454773%22,%22caption%22:%7B%22id%22:%2217974799410051310%22,%22text%22:%22Hainan%20charter%20package%5CnVisa%20Free%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221535454773%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BnBTzToBC-n/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221833486022370112201_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/a1bc09eb97de60a203534ffba8bdd6fb/5BA842C1/t51.2885-15/e15/s150x150/37086824_219280625303689_3573174849083801600_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/9bd4283bfac43f3a0e84f6c1ce8996bc/5BA8C0F1/t51.2885-15/e15/s320x320/37086824_219280625303689_3573174849083801600_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/475e1145174456afed95c73200d1fea4/5BA83120/t51.2885-15/e15/37086824_219280625303689_3573174849083801600_n.jpg%22%7D%7D,%22created_time%22:%221532788639%22,%22caption%22:null,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:3%7D,%22tags%22:%5B%5D,%22filter%22:%22Hefe%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22video%22,%22link%22:%22https://www.instagram.com/p/Blx2dK4A7LJ/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22videos%22:%7B%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/844c7872cf5b1bf888169fd8603944d0/5BA8654F/t50.2886-16/37565163_268989000499902_7628204608841580544_n.mp4%22,%22id%22:%2217964708844035893%22%7D,%22low_bandwidth%22:%7B%22width%22:480,%22height%22:480,%22url%22:%22https://scontent.cdninstagram.com/vp/1074463a66b14b2de4e5a921976b5345/5BA8AF92/t50.2886-16/37397082_1873678326260881_4954282563058270208_n.mp4%22,%22id%22:%2217873074087262159%22%7D,%22low_resolution%22:%7B%22width%22:480,%22height%22:480,%22url%22:%22https://scontent.cdninstagram.com/vp/1074463a66b14b2de4e5a921976b5345/5BA8AF92/t50.2886-16/37397082_1873678326260881_4954282563058270208_n.mp4%22,%22id%22:%2217873074087262159%22%7D%7D%7D,%7B%22id%22:%221832703642193832901_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/a3449cf65337191103a06114cff00c63/5C5DCD7D/t51.2885-15/e35/s150x150/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/848c2840322b2a984c85f7ea549b7c88/5C611205/t51.2885-15/e35/s320x320/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/bb2602f5ea79c7402b5caec166541ae4/5C2FBEF8/t51.2885-15/sh0.08/e35/s640x640/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D%7D,%22created_time%22:%221532695320%22,%22caption%22:%7B%22id%22:%2217943230311087305%22,%22text%22:%22Singapore%20Airlines%20promo,%20Philippines%20to%20Asia,%20Oceania,%20%5CnEurope%20&%20South%20Africa%5Cn%5CnIssuance%20validity:%20August%2010,%202018%5CnTravel%20validity:%20December%2031,%202018%5Cn%5CnRemarks:%20terms%20and%20conditions%20apply,%20subject%20to%20availability%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221532695320%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:2%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/BlvEkCjhyvF/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/a3449cf65337191103a06114cff00c63/5C5DCD7D/t51.2885-15/e35/s150x150/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/848c2840322b2a984c85f7ea549b7c88/5C611205/t51.2885-15/e35/s320x320/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/bb2602f5ea79c7402b5caec166541ae4/5C2FBEF8/t51.2885-15/sh0.08/e35/s640x640/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/82ed3f77a4c808e91d708db94ea66c49/5C422301/t51.2885-15/e35/s150x150/37654412_497656767357523_6115715713593245696_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/02a94d707df47fac9a1e82f8d22f7959/5C2B35F1/t51.2885-15/e35/s320x320/37654412_497656767357523_6115715713593245696_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/0196c4d71c1553fb9d7ac2df39b89254/5C2341A6/t51.2885-15/sh0.08/e35/s640x640/37654412_497656767357523_6115715713593245696_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/a3a09b506051cd2f63af1cf6464e2549/5C250452/t51.2885-15/e35/s150x150/37259856_439472573128982_2401308256619200512_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/89e7942ab8df51a1761b3b79dbc98982/5C5D4BA2/t51.2885-15/e35/s320x320/37259856_439472573128982_2401308256619200512_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/a3abbe0784db43acaa6acb2bcdd79cfc/5C246EF5/t51.2885-15/sh0.08/e35/s640x640/37259856_439472573128982_2401308256619200512_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/0abb7f568d9e9de686f5ea47cbd5d8e2/5C3FB16A/t51.2885-15/e35/s150x150/37890087_2209330209290328_1877223058532466688_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/90be2714e2f706a71b433e63b7c8a49b/5C5FA112/t51.2885-15/e35/s320x320/37890087_2209330209290328_1877223058532466688_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/faa9e08ab4d65cf8605536705f724643/5C432FEF/t51.2885-15/sh0.08/e35/s640x640/37890087_2209330209290328_1877223058532466688_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/dc1b3705b2a362810e36445e7037fed1/5C3DE141/t51.2885-15/e35/s150x150/37185053_506890046426418_4827564058410483712_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/f24d2904da988fa9e86bfc2d6a9ebdbb/5C2540B1/t51.2885-15/e35/s320x320/37185053_506890046426418_4827564058410483712_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/2052980e23dc99cd30e8420bdd8235f0/5C3FA9E6/t51.2885-15/sh0.08/e35/s640x640/37185053_506890046426418_4827564058410483712_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/334bba0ab9c7e5a5534d87ca5806efbe/5C3FFBA7/t51.2885-15/e35/s150x150/37688449_1842709712692698_7437787577370804224_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/cbaa7f9b25fe72a19154dcd061543b35/5C24EBDF/t51.2885-15/e35/s320x320/37688449_1842709712692698_7437787577370804224_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/0b1e1dad3fc4b686c2505466c4f8740c/5C334E22/t51.2885-15/sh0.08/e35/s640x640/37688449_1842709712692698_7437787577370804224_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/87e7bdcb765858ed24b1597d2a41aeed/5C5D1A8B/t51.2885-15/e35/s150x150/37083773_1949182681813293_7085947726248017920_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/f7f4221ed7f7278c99f24b8a64f942fd/5C41E6F3/t51.2885-15/e35/s320x320/37083773_1949182681813293_7085947726248017920_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/aa721c1f144fc538606dc71aeb63bede/5C5C2C0E/t51.2885-15/sh0.08/e35/s640x640/37083773_1949182681813293_7085947726248017920_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/18accd27d21686314dfe3aab57289633/5C1E7B16/t51.2885-15/e35/s150x150/37207565_227731411398043_5454956688983457792_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/8eb1fed879764ae4c4083e60c0b21b26/5C241BE6/t51.2885-15/e35/s320x320/37207565_227731411398043_5454956688983457792_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/d5fd29c10b539b6d00042edaccab1369/5C3EAFB1/t51.2885-15/sh0.08/e35/s640x640/37207565_227731411398043_5454956688983457792_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/ff5f95beeab3017e6ff4dac549796c0d/5C2F19FD/t51.2885-15/e35/s150x150/37867469_219617345363716_6462109889782087680_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/62c3559d4d6752e3498448c7458ed7ff/5C5DB00D/t51.2885-15/e35/s320x320/37867469_219617345363716_6462109889782087680_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/f200152f2f1417514980e32ebf91b6b4/5C322E5A/t51.2885-15/sh0.08/e35/s640x640/37867469_219617345363716_6462109889782087680_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221832012717004055105_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/221f3506b67ee27d59e80c67f35238e7/5C238E70/t51.2885-15/e35/s150x150/37090378_458408747968496_5231678317270138880_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/99dfd1190c4c99afc6c1e940d5016f4f/5C613580/t51.2885-15/e35/s320x320/37090378_458408747968496_5231678317270138880_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/221df4ba25827529911a71e5ace0107d/5C322FD7/t51.2885-15/sh0.08/e35/s640x640/37090378_458408747968496_5231678317270138880_n.jpg%22%7D%7D,%22created_time%22:%221532612956%22,%22caption%22:%7B%22id%22:%2217900759824221019%22,%22text%22:%22AmaWaterways%20%7C%20Romantic%20Danube%5CnAustria,%20Czech%20Republic,%20Germany,%20Hungary%5Cn%5CnAmaWaterways%20%7C%20Christmas%20markets%20on%20the%20Rhine%5CnFrance,%20Germany,%20Netherlands,%20Switzerland%5Cn%5CnRemarks:%20-%20Terms%20and%20conditions%20apply,%20subject%20to%20availability%5Cn%5CnRates%20excludes:%20airfare,%20visa,%20pre%20and%20post%20land%20arrangements,%20shore%20excursions,%20gratuities%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221532612956%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:19%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/BlsndwVBmJB/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/221f3506b67ee27d59e80c67f35238e7/5C238E70/t51.2885-15/e35/s150x150/37090378_458408747968496_5231678317270138880_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/99dfd1190c4c99afc6c1e940d5016f4f/5C613580/t51.2885-15/e35/s320x320/37090378_458408747968496_5231678317270138880_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/221df4ba25827529911a71e5ace0107d/5C322FD7/t51.2885-15/sh0.08/e35/s640x640/37090378_458408747968496_5231678317270138880_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/fea79dc7896d85def59c4ba1fe221b33/5C1D3B07/t51.2885-15/e35/s150x150/37857781_677633819254401_5020518062638497792_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/bc33138fb5ccdd4acebce658f964c3c7/5C2784F7/t51.2885-15/e35/s320x320/37857781_677633819254401_5020518062638497792_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/ba0755d6c133eff2911fa388a97c6427/5C3C2FA0/t51.2885-15/sh0.08/e35/s640x640/37857781_677633819254401_5020518062638497792_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221832011939623233526_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/8fa4b7c0c2a63470e3e1e61af0188b75/5C27A9C9/t51.2885-15/e35/s150x150/37330978_305647836850963_3469778145702313984_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/9a115655bd304aab8590ad9616a7cb0e/5C3DA139/t51.2885-15/e35/s320x320/37330978_305647836850963_3469778145702313984_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/2ca786fed028a01b876767bfb1448c6a/5C1D7E6E/t51.2885-15/sh0.08/e35/s640x640/37330978_305647836850963_3469778145702313984_n.jpg%22%7D%7D,%22created_time%22:%221532612863%22,%22caption%22:%7B%22id%22:%2217872080730260763%22,%22text%22:%22MSC%20Cruise%20North%20Europe%20%7C%20sailing:%20Oct%2001,%202018%5CnUK,%20France,%20Belgium,%20Netherlands,%20Germany%5Cn%5CnMSC%20Cruise%20Mediterranean%20%7C%20sailing:%20Dec%2002,%202018%5CnItaly,%20Malta,%20Spain,%20France%5Cn%5CnRemarks:%20-%20Terms%20and%20conditions%20apply,%20subject%20to%20availability%5Cn%5CnRates%20excludes:%20airfare,%20visa,%20pre%20and%20post%20land%20arrangements,%20shore%20excursions,%20gratuities%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221532612863%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:33%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/BlsnScVhGf2/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/8fa4b7c0c2a63470e3e1e61af0188b75/5C27A9C9/t51.2885-15/e35/s150x150/37330978_305647836850963_3469778145702313984_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/9a115655bd304aab8590ad9616a7cb0e/5C3DA139/t51.2885-15/e35/s320x320/37330978_305647836850963_3469778145702313984_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/2ca786fed028a01b876767bfb1448c6a/5C1D7E6E/t51.2885-15/sh0.08/e35/s640x640/37330978_305647836850963_3469778145702313984_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/a1573658ab95dba4787b5bd1edd5aa5e/5C61EA5F/t51.2885-15/e35/s150x150/36904167_667013320341100_3286810812315860992_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/18af6094ae3593b331d8ec8056a3bfda/5C27F4AF/t51.2885-15/e35/s320x320/36904167_667013320341100_3286810812315860992_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/24682e24f924591a7a69b81ff475c201/5C1CEFF8/t51.2885-15/sh0.08/e35/s640x640/36904167_667013320341100_3286810812315860992_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221832011498843913330_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/0d1e0e56a9c1a6eabf45ab07b937fe8a/5C257B1F/t51.2885-15/e35/s150x150/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/b3458369403a1272e3b3696f3e15f5d5/5C335E67/t51.2885-15/e35/s320x320/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/386204ce839aa1e8ff0c8f03cb95c3c6/5C61AF9A/t51.2885-15/sh0.08/e35/s640x640/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D%7D,%22created_time%22:%221532612810%22,%22caption%22:%7B%22id%22:%2217938890112142347%22,%22text%22:%22Turkish%20Airlines%20promo,%20Philippines%20to%20Europe%20&%20South%20Africa%5Cn%5CnIssuance%20validity:%20July%2030,%202018%5CnTravel%20validity:%20March%2015,%202019%5Cn%5CnRemarks:%20terms%20and%20conditions%20apply,%20subject%20to%20availability%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221532612810%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:9%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/BlsnMB1Bbxy/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/0d1e0e56a9c1a6eabf45ab07b937fe8a/5C257B1F/t51.2885-15/e35/s150x150/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/b3458369403a1272e3b3696f3e15f5d5/5C335E67/t51.2885-15/e35/s320x320/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/386204ce839aa1e8ff0c8f03cb95c3c6/5C61AF9A/t51.2885-15/sh0.08/e35/s640x640/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/9fc82355c3fe4cf96cc4c21febf6d146/5C3DA453/t51.2885-15/e35/s150x150/37131529_261504431306444_3100034564492361728_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/3725c8bd47006608917650004be16470/5C25EEA3/t51.2885-15/e35/s320x320/37131529_261504431306444_3100034564492361728_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/16704875ffbb0a6e94978a9da9984e46/5C43C0F4/t51.2885-15/sh0.08/e35/s640x640/37131529_261504431306444_3100034564492361728_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/f02eb7b07d778bee4feaa1e08afc92c9/5C3E6476/t51.2885-15/e35/s150x150/37105894_1886865638042011_3604238552239439872_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/664575d3a4cf0aafcd06a8ff7e98b0aa/5C412A0E/t51.2885-15/e35/s320x320/37105894_1886865638042011_3604238552239439872_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/8cb22e4a5bf17e1c532231942a27d0ca/5C41F6F3/t51.2885-15/sh0.08/e35/s640x640/37105894_1886865638042011_3604238552239439872_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/952f5e45d4a91f278b16051c8b9dd967/5C3DDEE5/t51.2885-15/e35/s150x150/37314707_464385827367056_2543603387878866944_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/01a7de17f22f17fba0429f9bce2d74fe/5C1EFF15/t51.2885-15/e35/s320x320/37314707_464385827367056_2543603387878866944_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/211d1c31cb432634faf697e12b44bda6/5C292942/t51.2885-15/sh0.08/e35/s640x640/37314707_464385827367056_2543603387878866944_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/f5a05ddc24193a906514f27889767816/5C40731A/t51.2885-15/e35/s150x150/37102892_486120548502555_7976266851543941120_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/d4b028dfe965d48271ee4d48399d1af4/5C256EEA/t51.2885-15/e35/s320x320/37102892_486120548502555_7976266851543941120_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/2b31736910d366951008d828d47ef036/5C1D86BD/t51.2885-15/sh0.08/e35/s640x640/37102892_486120548502555_7976266851543941120_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/ae42817012f90f00391130c7ea19f9b1/5C23B559/t51.2885-15/e35/s150x150/37182746_2062439730464746_4278306696952020992_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/08315304bd908daf79370c2a7544eea5/5C2CEA21/t51.2885-15/e35/s320x320/37182746_2062439730464746_4278306696952020992_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/dade15eb876647d377a237ce0d5eb75b/5C2E41DC/t51.2885-15/sh0.08/e35/s640x640/37182746_2062439730464746_4278306696952020992_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/076ed23fc6701400d3e4f34bb26a5fa3/5C2EACB6/t51.2885-15/e35/s150x150/37190649_461303134343904_7987921533064445952_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/23f2cc8a124036db10b416d413633c1a/5C2C1A46/t51.2885-15/e35/s320x320/37190649_461303134343904_7987921533064445952_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/b40375f2a56064ce7aad60fc676ea8e1/5C2D0B11/t51.2885-15/sh0.08/e35/s640x640/37190649_461303134343904_7987921533064445952_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/ab36f3eadf0f1282e28e1a9a87ec45b9/5C43DFAA/t51.2885-15/e35/s150x150/37059674_245292262752346_3064343446392143872_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/4b569369302c66463999229617886a3e/5C28F45A/t51.2885-15/e35/s320x320/37059674_245292262752346_3064343446392143872_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/aad69df0ca07cf247d9004719dd741e5/5C2AB30D/t51.2885-15/sh0.08/e35/s640x640/37059674_245292262752346_3064343446392143872_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221832010510892441306_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/989bcbd60f8030721131aaaff38b4edd/5C30837E/t51.2885-15/e35/s150x150/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/3789b7f0e04cf999c5c7a89126c529b7/5C631306/t51.2885-15/e35/s320x320/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/f83d45de86e57c522843e5a469f3e449/5C3FE5FB/t51.2885-15/sh0.08/e35/s640x640/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D%7D,%22created_time%22:%221532612693%22,%22caption%22:%7B%22id%22:%2217904452422203562%22,%22text%22:%22EVA%20Airways%20promo,%20Philippines%20to%20USA%5Cn%5CnIssuance%20validity:%20July%2031,%202018%5CnTravel%20validity:%20March%2031,%202019%5Cn%5CnRemarks:%20rates%20are%20valid%20on%20low%20season%20rate,%20subject%20to%20availability%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221532612693%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:20%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:3%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/Blsm9puhp7a/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/989bcbd60f8030721131aaaff38b4edd/5C30837E/t51.2885-15/e35/s150x150/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/3789b7f0e04cf999c5c7a89126c529b7/5C631306/t51.2885-15/e35/s320x320/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/f83d45de86e57c522843e5a469f3e449/5C3FE5FB/t51.2885-15/sh0.08/e35/s640x640/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/04d514575b32269e6b65aab0061457e9/5C4099FD/t51.2885-15/e35/s150x150/37344076_2309711399044218_676350219750735872_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/abe5acfb8015532c0778a811fa989025/5C2BD10D/t51.2885-15/e35/s320x320/37344076_2309711399044218_676350219750735872_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/50497e10c21f7df2884ac6cdcd7764ca/5C5DC25A/t51.2885-15/sh0.08/e35/s640x640/37344076_2309711399044218_676350219750735872_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/7dc2d71929f992529d7386425b237c2d/5C2B3669/t51.2885-15/e35/s150x150/37194825_640558326299481_3531957207585259520_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/457d0896282af7fef3c8fe87c4337dba/5C30EB99/t51.2885-15/e35/s320x320/37194825_640558326299481_3531957207585259520_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/992004645c02e03aefd7ad00ec88b742/5C4409CE/t51.2885-15/sh0.08/e35/s640x640/37194825_640558326299481_3531957207585259520_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/ec175d5f77058c99136d4e231026f884/5C1EBFA4/t51.2885-15/e35/s150x150/37183899_2177396429173053_7072210277646729216_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/76ad14458c6b03297b1e3170ef9f6b3a/5C24E3DC/t51.2885-15/e35/s320x320/37183899_2177396429173053_7072210277646729216_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/a4772731c67d45f74fd410331e173b31/5C2C2921/t51.2885-15/sh0.08/e35/s640x640/37183899_2177396429173053_7072210277646729216_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221821726457094140597_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/04aff99e838922083356f6d3c1a9e3d3/5C2A3744/t51.2885-15/e35/s150x150/36621905_2058634627725518_3918040785714413568_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/1b807651117749bc4c804d858c997a04/5C25F03C/t51.2885-15/e35/s320x320/36621905_2058634627725518_3918040785714413568_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/e16d9c926ef4676bf41ecd5165b678be/5C3353C1/t51.2885-15/sh0.08/e35/s640x640/36621905_2058634627725518_3918040785714413568_n.jpg%22%7D%7D,%22created_time%22:%221531386738%22,%22caption%22:%7B%22id%22:%2217932297840159666%22,%22text%22:%22Travel%20with%20Cathay%20Pacific%20Airways%20and%20experience%20delectable%20inflight%20dining,%20state%20of%20the%20art%20audio%20and%20video%20on%20demand,%20and%20generous%20baggage%20allowance.%5Cn%5CnVisit%20our%20International%20Travel%20Festival%20(ITF)%20%20booth%20located%20at%20#60%20and%2061,%20Ayala%20Center%20Cebu%20from%2013July%20to%2015July%202018%20or%20click%20http://bit.ly/CEBLATESTOFFERS%20to%20kick%20off%20your%20#lifewelltravelled.%22,%22created_time%22:%221531386738%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:9%7D,%22tags%22:%5B%2260%22,%22lifewelltravelled%22%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BlIEo-RBvK1/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221808089372172865375_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/044e8489d113e6c8fcf60f0c18f2a5a5/5C62704C/t51.2885-15/e35/s150x150/35295723_2055042881429398_2386243031763255296_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/5f0f293b3748b90eedace47aecb32d65/5C207B34/t51.2885-15/e35/s320x320/35295723_2055042881429398_2386243031763255296_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/9abc258650cf4025ade0c9b32560f8d5/5C5D53C9/t51.2885-15/sh0.08/e35/s640x640/35295723_2055042881429398_2386243031763255296_n.jpg%22%7D%7D,%22created_time%22:%221529761071%22,%22caption%22:%7B%22id%22:%2217896367608207182%22,%22text%22:%22Urgent%20hiring%20for%20the%20following%20positions:%5Cn%5CnACCOUNTING%20STAFF%20(Cebu)%20*Graduate%20of%20accounting%20or%20any%20business%20management%20related%20courses.%5Cn*Experience%20in%20the%20related%20field%20is%20an%20advantage.%20Fresh%20graduates%20are%20welcome%20to%20apply.%5Cn*Proficient%20in%20MS%20Office%20Applications.%5Cn*Able%20to%20work%20as%20part%20of%20the%20team%5Cn%5CnCounter%20Sales%20&%20Reservations%20(Davao)%20*Graduate%20of%20tourism%20or%20business%20related%20courses.%5Cn*Knowledgeable%20in%20using%20Amadeus%20or%20Sabre%20GDS%20system%20is%20an%20advantage%5Cn*Fresh%20graduates%20are%20welcome%20to%20apply.%5Cn*Proficient%20in%20MS%20Office%20Applications.%5Cn*Able%20to%20work%20as%20part%20of%20the%20team%5Cn%5CnFor%20interested%20applicants:%20please%20send%20your%20updated%20CV%20to%20info@travelite.com.ph%22,%22created_time%22:%221529761071%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:5%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BkXn7ROhc9f/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%7B%22user%22:%7B%22username%22:%22mattpoonin%22%7D,%22position%22:%7B%22x%22:0.5244444173,%22y%22:0.6551110840000001%7D%7D,%7B%22user%22:%7B%22username%22:%22tim_tio%22%7D,%22position%22:%7B%22x%22:0.7848888753000001,%22y%22:0.343111084%7D%7D%5D%7D,%7B%22id%22:%221807111468962186764_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/c4bd715b333c4379ffb9aadcb395532f/5C62D536/t51.2885-15/e35/c204.0.641.641/s150x150/36085964_842703015939257_1407299541236973568_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:195,%22url%22:%22https://scontent.cdninstagram.com/vp/b20ed0abfa8602bd51091c1109af42ac/5C6316BB/t51.2885-15/e35/s320x320/36085964_842703015939257_1407299541236973568_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:390,%22url%22:%22https://scontent.cdninstagram.com/vp/21c9dcbd7baf0b8f30f765b24abae461/5C31BEEC/t51.2885-15/sh0.08/e35/s640x640/36085964_842703015939257_1407299541236973568_n.jpg%22%7D%7D,%22created_time%22:%221529644496%22,%22caption%22:%7B%22id%22:%2217955035299022759%22,%22text%22:%22for%20everybody\\\'s%20attention,%20the%20following%20facebook%20page%20is%20not%20owned%20or%20controlled%20by%20Travelite%20Travel%20and%20Tours,%20ANY%20TRANSACTIONS%20FROM%20THIS%20FRAUDULENT%20WEBPAGE%20WILL%20NOT%20BE%20HONORED.%20PLEASE%20REPORT%20IT%20IMMEDIATELY%20OF%20ANY%20SUCH%20UNAUTHORIZED%20ACTIVITY.%5Cn%5CnOur%20office%20address%20is%201707%20Tycoon%20Tower,%20Pearl%20Drive,%20Ortigas,%20Pasig%20City%5CnTel%20#%206338434%20/%206338423%22,%22created_time%22:%221529644496%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:4%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BkUJk55BoYM/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221801230454012282856_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/17c32e21077e6c522ed314449feaad7c/5C2F4773/t51.2885-15/e35/s150x150/34047683_801191390077888_6352239438029914112_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/790c02187acefb50d9da65013c17302e/5C62C283/t51.2885-15/e35/s320x320/34047683_801191390077888_6352239438029914112_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/7b9a7eeeb6827c81fe4cfd049375db15/5C31DFD4/t51.2885-15/sh0.08/e35/s640x640/34047683_801191390077888_6352239438029914112_n.jpg%22%7D%7D,%22created_time%22:%221528943424%22,%22caption%22:%7B%22id%22:%2217952522994013601%22,%22text%22:%22See%20the%20world%20with%20us,%20visit%20us%20at%20the%20upcoming%20International%20Travel%20Festival%20this%20coming%20July%2013%20-%2015%20at%20the%20Ayala%20Center%20Cebu,%20booth%2033,%2034,%20&%2035%20(across%20Laguna%20Garden%20Cafe)%22,%22created_time%22:%221528943424%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:11%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bj_QY36BIfo/%22,%22location%22:%7B%22latitude%22:10.3710633,%22longitude%22:123.9181935,%22name%22:%22Ayala%20Center%20Cebu%22,%22id%22:1271246079662830%7D,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221799949560714883994_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/b6839f9e2a0ec03acd8ed65a9325922c/5C2044DE/t51.2885-15/e35/c1.0.1078.1078/s150x150/33929618_243236902893479_279481583604334592_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:319,%22url%22:%22https://scontent.cdninstagram.com/vp/0b455ae2cd09852d172f180a81c9ba19/5C629295/t51.2885-15/e35/s320x320/33929618_243236902893479_279481583604334592_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:638,%22url%22:%22https://scontent.cdninstagram.com/vp/a3d3b901dc60ff364d8f33ae510ed3ef/5C5D0B79/t51.2885-15/sh0.08/e35/s640x640/33929618_243236902893479_279481583604334592_n.jpg%22%7D%7D,%22created_time%22:%221528790730%22,%22caption%22:%7B%22id%22:%2217951328868007373%22,%22text%22:%22Princess%20Cruise:%20Japan%20%7C%20Alaska%20%7C%20Australia%20&%20New%20Zealand%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528790730%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:10%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/Bj6tJbEB_Oa/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/b6839f9e2a0ec03acd8ed65a9325922c/5C2044DE/t51.2885-15/e35/c1.0.1078.1078/s150x150/33929618_243236902893479_279481583604334592_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:319,%22url%22:%22https://scontent.cdninstagram.com/vp/0b455ae2cd09852d172f180a81c9ba19/5C629295/t51.2885-15/e35/s320x320/33929618_243236902893479_279481583604334592_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:638,%22url%22:%22https://scontent.cdninstagram.com/vp/a3d3b901dc60ff364d8f33ae510ed3ef/5C5D0B79/t51.2885-15/sh0.08/e35/s640x640/33929618_243236902893479_279481583604334592_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/b51276baf048149d801b5b9df8a9e1fb/5C314F98/t51.2885-15/e35/c1.0.1078.1078/s150x150/33788187_202017270442189_2867990181707776000_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:319,%22url%22:%22https://scontent.cdninstagram.com/vp/df6ee02f865fea59b4eea2629ffda65d/5C43A383/t51.2885-15/e35/s320x320/33788187_202017270442189_2867990181707776000_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:638,%22url%22:%22https://scontent.cdninstagram.com/vp/f265ce3ba9275c75178a077c4e76eddc/5C2D63D4/t51.2885-15/sh0.08/e35/s640x640/33788187_202017270442189_2867990181707776000_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/de962270a8e9b12ae889419b77f8f8a7/5C5F8DBE/t51.2885-15/e35/c1.0.1078.1078/s150x150/34036465_1927861940578094_1566519802875346944_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:319,%22url%22:%22https://scontent.cdninstagram.com/vp/3a02370a47d315373128fdb2f3483b27/5C32C8FD/t51.2885-15/e35/s320x320/34036465_1927861940578094_1566519802875346944_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:638,%22url%22:%22https://scontent.cdninstagram.com/vp/ffd8814aae139743d12cf6836a47441b/5C222100/t51.2885-15/sh0.08/e35/s640x640/34036465_1927861940578094_1566519802875346944_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221799106398882376027_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/08b2c67ecaf32aed2974dc544581fa37/5C2EF1C1/t51.2885-15/e35/s150x150/33559751_196484561073288_7216981388833062912_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/55f50b409ebda0b9d7df38da3935112c/5C5D1631/t51.2885-15/e35/s320x320/33559751_196484561073288_7216981388833062912_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/cc71e25d0e771b672d623f72cd2a2b15/5C329566/t51.2885-15/sh0.08/e35/s640x640/33559751_196484561073288_7216981388833062912_n.jpg%22%7D%7D,%22created_time%22:%221528690217%22,%22caption%22:%7B%22id%22:%2217943344770073092%22,%22text%22:%22See%20the%20world%20with%20us,%20visit%20us%20at%20the%20upcoming%20Travel%20Madness%20Expo%20this%20coming%20July%205%20-%208%20at%20the%20SMX%20Convention%20Center%20in%20Pasay%20City,%20booth%20215%20(beside%20Philippine%20Airlines)%22,%22created_time%22:%221528690217%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:8%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bj3tbzahClb/%22,%22location%22:%7B%22latitude%22:14.5311864,%22longitude%22:120.9825319,%22name%22:%22SMX%20Convention%20Center%20-%20SM%20Mall%20of%20Asia%22,%22id%22:1790022364659612%7D,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221798492288075672788_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/d75a6d79a208829c40d12032b936efe5/5C2BF851/t51.2885-15/e35/s150x150/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/0911da679455b4935d51f4c3a2e497fb/5C3FCC29/t51.2885-15/e35/s320x320/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/426ea350589bc5932ea295bd12f7f0a6/5C202ED4/t51.2885-15/sh0.08/e35/s640x640/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D%7D,%22created_time%22:%221528617009%22,%22caption%22:%7B%22id%22:%2217952434629055399%22,%22text%22:%22Join%20us%20on%20our%20upcoming%20pilgrimage%20to%20the%20HOLY%20LAND%20tour!%2012%20Days%20and%2011%20Nights%20of%20culture,%20history,%20architecture%20and%20spirituality%20as%20we%20travel%20through%20Jordan,%20Israel%20and%20Egypt!%20---------------------------------%20Journey%20with%20the%20Lord%20to%20the%20Holyland%5CnOctober%20and%20November%202018%5CnFebruary,%20April%20and%20May%202019%5CnJordan%20-%20Israel%20-%20Egypt%5Cn%5CnRATE%5CnUSD%202,950%20++%20per%20person%5Cn%5CnINCLUSIONS%5CnAccommodation:%5Cnbased%20on%20twin/triple%20sharing,%20with%20daily%20breakfast,%20lunch%20and%20Dinner%5Cn2%20Night%20in%20Amman%5Cn2%20Night%20in%20Tiberias%5Cn3%20Nights%20in%20Jerusalem%20%5Cn2%20Nights%20in%20Dahab%5Cn2%20Nights%20in%20Cairo%5Cn%5CnTransportation:%5CnRound%20trip%20economy%20airfare%20%5CnAirport%20Transfers%20in%20Amman%20and%20Cairo%5CnChartered%20Transportation%20for%20the%20entire%20tour%5Cn%5CnTours:%5CnMadaba,%20Mt.%20Nebo%5CnPetra%20Tour%5CnDead%20Sea%20and%20Jericho%20Tour%5CnGalilee%20Tour%20%5CnJerusalem%20Tour%5CnBethlehem%20Tour%5CnGiza%20and%20Sphinx%20Tour%5Cnplus%20other%20sites%20on%20the%20way%5Cn%5CnVisa%20&%20Departure%20Taxes%20in%20Jordan,%20Israel%20&%20Egypt%5Cn%5CnOthers:%5CnTravelite%20ID%20and%20Bagtag%5CnService%20of%20Travel%20Factor%20Coordinator%5Cn%5CnNot%20Included:%5CnPhilippine%20Travel%20Tax%20(P1,620)%5CnLocal%20transportation%20during%20free%20time%20---------------------------------%20HIGHLIGHTS%5Cn-%20Travel%20to%20the%20Holy%20Land%5Cn-%20See%203%20countries:%20Jordan,%20Israel%20and%20Egypt!%5Cn-%20Everything\\\'s%20included,%20no%20more%20compulsary%20tipping,%20etc.%20No%20hidden%20charges!%20---------------------------------%20FOR%20INQUIRIES%5Cn-%20Email%20us%20at%20info@travelite.com.ph%5Cn-%20www.travelite.com.ph%5Cn-%20Visit%20us%20at%20our%20office%20in%20Cebu,%20Pasig%20and%20Davao%5Cn-%20Or%20send%20us%20a%20PM!%22,%22created_time%22:%221528617009%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:13%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/Bj1hzUKB6zU/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/d75a6d79a208829c40d12032b936efe5/5C2BF851/t51.2885-15/e35/s150x150/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/0911da679455b4935d51f4c3a2e497fb/5C3FCC29/t51.2885-15/e35/s320x320/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/426ea350589bc5932ea295bd12f7f0a6/5C202ED4/t51.2885-15/sh0.08/e35/s640x640/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/3d30677bca842f133e05ba0fc04c0562/5C5D8A79/t51.2885-15/e35/c0.0.1079.1079/s150x150/33689643_171564576871249_618033557532573696_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:319,%22url%22:%22https://scontent.cdninstagram.com/vp/6633af78c766604c88cbfde286cc843b/5C3C17CF/t51.2885-15/e35/s320x320/33689643_171564576871249_618033557532573696_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:639,%22url%22:%22https://scontent.cdninstagram.com/vp/a45f4cef9441973743088cd89c7e600a/5C420123/t51.2885-15/sh0.08/e35/s640x640/33689643_171564576871249_618033557532573696_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/dd53a805e6813462a81e222d1493602c/5C24A29D/t51.2885-15/e35/s150x150/34216241_195256447786817_7484020400641277952_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/d292f47639af616d7eaf885738836138/5C3EF06D/t51.2885-15/e35/s320x320/34216241_195256447786817_7484020400641277952_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/4f15e428f78e6223541a4fbdb784ed3c/5C22F03A/t51.2885-15/sh0.08/e35/s640x640/34216241_195256447786817_7484020400641277952_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/d5487c33cff4fcb8b493706096e34f8a/5C63230D/t51.2885-15/e35/s150x150/33639772_372051926652438_5823071957897183232_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/e9a810d4537d8a16e5574bf3f07f40fd/5C2A2DFD/t51.2885-15/e35/s320x320/33639772_372051926652438_5823071957897183232_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/1da9e364cee713823ea908bc2262ed6c/5C3D36AA/t51.2885-15/sh0.08/e35/s640x640/33639772_372051926652438_5823071957897183232_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221797742635919033978_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/f775473d09733d6e0c1e12a0407df336/5C26FBC8/t51.2885-15/e35/s150x150/33980699_461530287604924_7886948471138156544_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/76fbde2faa62dcd801d4e0c34e82ad31/5C3C3A38/t51.2885-15/e35/s320x320/33980699_461530287604924_7886948471138156544_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/d159c49d39a1a5108b10a02d4cbec8b9/5C5BFE6F/t51.2885-15/sh0.08/e35/s640x640/33980699_461530287604924_7886948471138156544_n.jpg%22%7D%7D,%22created_time%22:%221528527644%22,%22caption%22:%7B%22id%22:%2217951283529002970%22,%22text%22:%22Endless%20Osaka%20%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528527644%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:6%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:1%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bjy3WcLh0Z6/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221797719306294117151_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/555029fbb6718330de7b5dca1593b56d/5C31036B/t51.2885-15/e35/s150x150/34458209_786162691579381_8520447187996377088_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/e372dc600a2ef5b6c7b6b8a2b45a7c86/5C31A59B/t51.2885-15/e35/s320x320/34458209_786162691579381_8520447187996377088_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/c3415358349e41800a393c470c6f9b5d/5C28D6CC/t51.2885-15/sh0.08/e35/s640x640/34458209_786162691579381_8520447187996377088_n.jpg%22%7D%7D,%22created_time%22:%221528524863%22,%22caption%22:%7B%22id%22:%2217951657746059558%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528524863%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjyyC8xhcMf/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221797719174383236634_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/38f3e2b484e812dd0b6725ee5e105c0d/5C333612/t51.2885-15/e35/s150x150/34099007_220285068569184_1510816022666412032_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/3c17053041f57cca7483b781d2135db4/5C31E0E2/t51.2885-15/e35/s320x320/34099007_220285068569184_1510816022666412032_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/353515bf1b9dd245ee4874fd229064c6/5C5F76B5/t51.2885-15/sh0.08/e35/s640x640/34099007_220285068569184_1510816022666412032_n.jpg%22%7D%7D,%22created_time%22:%221528524847%22,%22caption%22:%7B%22id%22:%2217925989866136218%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528524847%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:10%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjyyBB7BXYa/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221797719053469773887_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/cde2003d759761738806b54b5c5430e9/5C21EF98/t51.2885-15/e35/s150x150/34007165_173301086678038_9140408975391457280_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/2ed4c953a21db24b875d2c00c0d708a3/5C609B68/t51.2885-15/e35/s320x320/34007165_173301086678038_9140408975391457280_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/7c49f13353c71d97fd980c2d9f8ba48f/5C2DEE3F/t51.2885-15/sh0.08/e35/s640x640/34007165_173301086678038_9140408975391457280_n.jpg%22%7D%7D,%22created_time%22:%221528524832%22,%22caption%22:%7B%22id%22:%2217934436651127143%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528524832%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:15%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bjyx_RUBHA_/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221797718874591229641_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/de3b50a123b59290dc0440690f6b9e84/5C2A3CDE/t51.2885-15/e35/s150x150/34592401_169569970381251_562153498980909056_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/b77d8be5517a944ad3fa3bb4410aa89e/5C5F70D3/t51.2885-15/e35/s320x320/34592401_169569970381251_562153498980909056_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/f6281821f9e6e67a3270489691d19d64/5C5BB73F/t51.2885-15/sh0.08/e35/s640x640/34592401_169569970381251_562153498980909056_n.jpg%22%7D%7D,%22created_time%22:%221528524811%22,%22caption%22:%7B%22id%22:%2217934699895126738%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528524811%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:11%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bjyx8quBnbJ/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221796259026649322352_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/94e9b8252ea3ea8b96f981dcd02307e5/5C3DA3AB/t51.2885-15/e15/s150x150/34820988_2158621017487227_6250212240805330944_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/e36f53d1864201b52d709cf320919634/5C2A49D3/t51.2885-15/e15/s320x320/34820988_2158621017487227_6250212240805330944_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/7a5d6830cd27738f759fe2fec44bb6b4/5C417296/t51.2885-15/sh0.08/e35/s640x640/34820988_2158621017487227_6250212240805330944_n.jpg%22%7D%7D,%22created_time%22:%221528350784%22,%22caption%22:%7B%22id%22:%2217861867728247305%22,%22text%22:%22MSC%20Cruise:%20Northern%20Europe%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528350784%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjtmBFYBZNw/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221796258552172920919_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/10287d17b69989977356e918c56227b6/5C2F79FF/t51.2885-15/e15/s150x150/34313747_810236599175611_6545500094332928000_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/e2a135213e72edeb066c431e31a93a0d/5C5BB80F/t51.2885-15/e15/s320x320/34313747_810236599175611_6545500094332928000_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/ab360f4dc0b5fe30ac23e06789356f53/5C403AF9/t51.2885-15/sh0.08/e35/s640x640/34313747_810236599175611_6545500094332928000_n.jpg%22%7D%7D,%22created_time%22:%221528350727%22,%22caption%22:%7B%22id%22:%2217924508028133883%22,%22text%22:%22MSC%20Cruise:%20Mediterranean%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528350727%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:12%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:2%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bjtl6LfBkBX/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221796257676830038060_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/eac51effc8363591da750eeca996d5c6/5C2A2D6D/t51.2885-15/e15/s150x150/34170780_988209704688153_919444050149376000_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/3051915691d9803af62e8367edde50c9/5C211560/t51.2885-15/e15/s320x320/34170780_988209704688153_919444050149376000_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/8ae617722e2a085454b65abd6ac25243/5C2EE6F2/t51.2885-15/sh0.08/e35/s640x640/34170780_988209704688153_919444050149376000_n.jpg%22%7D%7D,%22created_time%22:%221528350623%22,%22caption%22:%7B%22id%22:%2217878061125232718%22,%22text%22:%22Disney%20Cruises%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528350623%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:8%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjtltcQhdgs/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221796256891891176376_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/5acfb47e33553bcaab22215786e8aed3/5C600B54/t51.2885-15/e15/s150x150/34752853_2128286414123846_8602116566655434752_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/f149912eecc1a471ac8757b841217270/5C24932C/t51.2885-15/e15/s320x320/34752853_2128286414123846_8602116566655434752_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/de81344dfe69785b1e83b8d8b3d0ab60/5C323F69/t51.2885-15/sh0.08/e35/s640x640/34752853_2128286414123846_8602116566655434752_n.jpg%22%7D%7D,%22created_time%22:%221528350529%22,%22caption%22:%7B%22id%22:%2217877995485238438%22,%22text%22:%22Arosa%20River%20Cruise:%20The%20Legendary%20Danube%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528350529%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:6%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjtliBOhVO4/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221795807098983405354_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/0c7c2d801ba49364aa8d9c144dedca9f/5C1DB40E/t51.2885-15/e35/s150x150/33476369_2156509811304624_2961324094542315520_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/0ccaf51e6bc59db46c5a4c5258b5c996/5C237E76/t51.2885-15/e35/s320x320/33476369_2156509811304624_2961324094542315520_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/fe6123f373891ba096224b57221de09a/5C20CD8B/t51.2885-15/sh0.08/e35/s640x640/33476369_2156509811304624_2961324094542315520_n.jpg%22%7D%7D,%22created_time%22:%221528296910%22,%22caption%22:%7B%22id%22:%2217891305285203874%22,%22text%22:%22Costa%20Cruise:%20Japan%20&%20South%20Korea%20sailings%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528296910%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:9%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bjr_Qq8B9cq/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221794235085747401586_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/eb0da8e8d5cbd231807a47bdbec3b7f3/5C1D7427/t51.2885-15/e15/s150x150/33349397_1754216917997679_3589386671293988864_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/a41cb82135ac3c0b247c046a27acf218/5C1FA55F/t51.2885-15/e15/s320x320/33349397_1754216917997679_3589386671293988864_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/57cc9746cb9c100120ce9be9a727bd6f/5C1CCA1A/t51.2885-15/sh0.08/e35/s640x640/33349397_1754216917997679_3589386671293988864_n.jpg%22%7D%7D,%22created_time%22:%221528109511%22,%22caption%22:%7B%22id%22:%2217935676383129662%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528109511%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:6%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjmZ03hhDNy/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221789700664394672031_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/46fdb20806db22ee4db663ae4e56aa56/5C2813A6/t51.2885-15/e35/c135.0.809.809/s150x150/32367579_2032224353693558_8835136147534381056_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:239,%22url%22:%22https://scontent.cdninstagram.com/vp/b8e0615199dff9e8b8422f9bf5149886/5C2D5275/t51.2885-15/e35/s320x320/32367579_2032224353693558_8835136147534381056_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:479,%22url%22:%22https://scontent.cdninstagram.com/vp/fabb80a7f6f71ce3e054230002e1b97f/5C3F3C88/t51.2885-15/sh0.08/e35/s640x640/32367579_2032224353693558_8835136147534381056_n.jpg%22%7D%7D,%22created_time%22:%221527568966%22,%22caption%22:%7B%22id%22:%2217947774156025719%22,%22text%22:%22#huangjin%20%20#taiwan%22,%22created_time%22:%221527568966%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:10%7D,%22tags%22:%5B%22taiwan%22,%22huangjin%22%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjWS0Wjhmef/%22,%22location%22:%7B%22latitude%22:25.117804886275,%22longitude%22:121.86148701759,%22name%22:%22Huangjin%20Golden%20Waterfalls%22,%22id%22:131014230863575%7D,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221789699859457375987_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/4db2b283cc02fd87505c4d38e19c456f/5C605106/t51.2885-15/e35/c135.0.809.809/s150x150/32430504_220842831845853_8261403382363717632_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:239,%22url%22:%22https://scontent.cdninstagram.com/vp/93e3169fbcce3c425c864a3f581ddcc2/5C2BAE81/t51.2885-15/e35/s320x320/32430504_220842831845853_8261403382363717632_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:479,%22url%22:%22https://scontent.cdninstagram.com/vp/78eafadeb078fc313188f5b3d4cf0057/5C261BD6/t51.2885-15/sh0.08/e35/s640x640/32430504_220842831845853_8261403382363717632_n.jpg%22%7D%7D,%22created_time%22:%221527568870%22,%22caption%22:%7B%22id%22:%2217886881173222167%22,%22text%22:%22#kabirabay%20#ishigaki%22,%22created_time%22:%221527568870%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%22ishigaki%22,%22kabirabay%22%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjWSoo5hf7z/%22,%22location%22:%7B%22latitude%22:24.461100352578,%22longitude%22:124.14263353729,%22name%22:%22Kabira%20Bay%22,%22id%22:337032420%7D,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221789067426781207960_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/11595a4766739c5ab0f797c8e9b1d87c/5C3FEB2E/t51.2885-15/e35/c60.0.959.959/s150x150/32721285_190952904890503_7012389595190919168_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:284,%22url%22:%22https://scontent.cdninstagram.com/vp/e43e1f90c999e0c1a93a24c27bb008e4/5C1D6465/t51.2885-15/e35/s320x320/32721285_190952904890503_7012389595190919168_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:568,%22url%22:%22https://scontent.cdninstagram.com/vp/c746c7375539a4c2bbc7deb25a63a909/5C1D4A32/t51.2885-15/sh0.08/e35/s640x640/32721285_190952904890503_7012389595190919168_n.jpg%22%7D%7D,%22created_time%22:%221527493478%22,%22caption%22:%7B%22id%22:%2217874016525243262%22,%22text%22:%22Scenic%20European%20Trail%5CnItaly,%20Austria,%20Germany,%20Switzerland,%20France%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221527493478%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:9%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjUC1iEhB2Y/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221777243605053157517_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/9b3568f7fb042cebed0a30322d7b73e8/5C213981/t51.2885-15/e35/c212.0.655.655/s150x150/31970480_195048384470204_5566909645823410176_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:194,%22url%22:%22https://scontent.cdninstagram.com/vp/036811ae1caeceaae0ccab3d1f6e8030/5C27EAA2/t51.2885-15/e35/s320x320/31970480_195048384470204_5566909645823410176_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:388,%22url%22:%22https://scontent.cdninstagram.com/vp/f5a3261d09a83b939addb616bb1bb5a8/5C2B69F5/t51.2885-15/sh0.08/e35/s640x640/31970480_195048384470204_5566909645823410176_n.jpg%22%7D%7D,%22created_time%22:%221526083969%22,%22caption%22:%7B%22id%22:%2217930629732115620%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221526083969%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:14%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BiqCaR-hzCN/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221777243418297576193_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/41753f886e68414629a2afe4560bf28d/5C3D44D1/t51.2885-15/e35/s150x150/31879091_167914007216987_6074394065166663680_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/42faeab9703e4b9eebf0d1c053317b51/5C282621/t51.2885-15/e35/s320x320/31879091_167914007216987_6074394065166663680_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/b07dbce1f0ee6d5b556b75ef01d1023e/5C2D5076/t51.2885-15/sh0.08/e35/s640x640/31879091_167914007216987_6074394065166663680_n.jpg%22%7D%7D,%22created_time%22:%221526083946%22,%22caption%22:%7B%22id%22:%2217940327034067683%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221526083946%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:1%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BiqCXkDBysB/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221777243289893143972_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/e937fdd378a4634563c42c3188b5ad00/5C3E6C5D/t51.2885-15/e35/s150x150/31709144_169322203753978_1648943300482170880_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/287057662fccadd39c8092669d369650/5C2DECAD/t51.2885-15/e35/s320x320/31709144_169322203753978_1648943300482170880_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/a6ad735602b5db7969fc29b51fa60211/5C3006FA/t51.2885-15/sh0.08/e35/s640x640/31709144_169322203753978_1648943300482170880_n.jpg%22%7D%7D,%22created_time%22:%221526083931%22,%22caption%22:%7B%22id%22:%2217914602586162335%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221526083931%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:5%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BiqCVsdhwWk/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221773311323871318607_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/8b66c8677919d85ac0ca130202eb32b6/5C5F7AC7/t51.2885-15/e35/s150x150/30867885_848339418701179_4374873620648820736_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/ef4099749200fcb0006b78928dfa3de4/5C2E3937/t51.2885-15/e35/s320x320/30867885_848339418701179_4374873620648820736_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/229dd57810a8c44ccef77b79dc041e64/5C32F260/t51.2885-15/sh0.08/e35/s640x640/30867885_848339418701179_4374873620648820736_n.jpg%22%7D%7D,%22created_time%22:%221525615204%22,%22caption%22:%7B%22id%22:%2217844149008263576%22,%22text%22:%22Summer%20in%20Korea%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221525615204%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:5%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BicEUDvhxJP/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221773311086800678962_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/fc1c6e054ae23b8dd7218bbdc64eaeaa/5C5BE9AC/t51.2885-15/e35/s150x150/30905347_432067190577245_590161019372830720_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/a4066169915a0c0e904a370187f3308d/5C4211A1/t51.2885-15/e35/s320x320/30905347_432067190577245_590161019372830720_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/503227bec9b5df56789aba19efa21622/5C5DE54D/t51.2885-15/sh0.08/e35/s640x640/30905347_432067190577245_590161019372830720_n.jpg%22%7D%7D,%22created_time%22:%221525615176%22,%22caption%22:%7B%22id%22:%2217884456084207501%22,%22text%22:%22Fall%20for%20Korea%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221525615176%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:10%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BicEQm9BDAy/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D%5D,%22meta%22:%7B%22code%22:200%7D%7D", "no");
INSERT INTO `trvlite_options` VALUES("203602", "um_cached_users_queue", "0", "no");
INSERT INTO `trvlite_options` VALUES("203337", "rs-templates-new", "", "no");
INSERT INTO `trvlite_options` VALUES("203450", "_site_transient_timeout_bsf_get_bundled_products", "1538124689", "no");
INSERT INTO `trvlite_options` VALUES("203451", "_site_transient_bsf_get_bundled_products", "1", "no");
INSERT INTO `trvlite_options` VALUES("203591", "_site_transient_timeout_theme_roots", "1537610919", "no");
INSERT INTO `trvlite_options` VALUES("203592", "_site_transient_theme_roots", "a:2:{s:15:\"travelite-child\";s:7:\"/themes\";s:9:\"travelite\";s:7:\"/themes\";}", "no");
INSERT INTO `trvlite_options` VALUES("203471", "_transient_timeout_bsf_check_product_updates", "1537705179", "no");
INSERT INTO `trvlite_options` VALUES("203472", "_transient_bsf_check_product_updates", "1", "no");
INSERT INTO `trvlite_options` VALUES("203572", "_transient_plugin_slugs", "a:23:{i:0;s:19:\"akismet/akismet.php\";i:1;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:51:\"arrow-twitter-feed/twitter-feed-by-arrowplugins.php\";i:3;s:47:\"bop-search-box-item-type-for-nav-menus/init.php\";i:4;s:59:\"change-default-login-logo-url-and-title/change-logo-url.php\";i:5;s:36:\"contact-form-7/wp-contact-form-7.php\";i:6;s:27:\"convertplug/convertplug.php\";i:7;s:33:\"duplicate-post/duplicate-post.php\";i:8;s:25:\"duplicator/duplicator.php\";i:9;s:59:\"editor-menu-and-widget-access/editor-menu-widget-access.php\";i:10;s:31:\"fb-messenger-livechat/fbmsg.php\";i:11;s:33:\"instagram-feed/instagram-feed.php\";i:12;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:13;s:29:\"copy-menu/menu-duplicator.php\";i:14;s:33:\"search-exclude/search-exclude.php\";i:15;s:23:\"revslider/revslider.php\";i:16;s:29:\"dt-the7-core/dt-the7-core.php\";i:17;s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";i:18;s:35:\"ultimate-member/ultimate-member.php\";i:19;s:51:\"visual-form-builder-pro/visual-form-builder-pro.php\";i:20;s:23:\"wordfence/wordfence.php\";i:21;s:27:\"js_composer/js_composer.php\";i:22;s:21:\"like-box/like-box.php\";}", "no");
INSERT INTO `trvlite_options` VALUES("202789", "_site_transient_timeout_browser_73d8f888aab6ae100917d02d485ef070", "1537607978", "no");
INSERT INTO `trvlite_options` VALUES("202790", "_site_transient_browser_73d8f888aab6ae100917d02d485ef070", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"69.0.3497.92\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `trvlite_options` VALUES("200986", "wordfence_syncAttackDataAttempts", "0", "no");
INSERT INTO `trvlite_options` VALUES("200987", "wordfence_syncingAttackData", "0", "no");
INSERT INTO `trvlite_options` VALUES("200988", "wordfence_lastSyncAttackData", "1537005689", "no");
INSERT INTO `trvlite_options` VALUES("200769", "!sbi_973906762", "%7B%22pagination%22:%7B%22next_max_id%22:%221773311086800678962_973906762%22,%22next_url%22:%5B%22https://api.instagram.com/v1/users/973906762/media/recent?access_token=973906762.3a81a9f.44de59b1d6d04413b9560d76598cfade&count=33&callback=jQuery112406955407727395817_1537597127585&_=1537597127586&max_id=1773311086800678962_973906762%22%5D%7D,%22data%22:%5B%7B%22id%22:%221855851610102837159_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/2def11eb29ff1b9d9d6a7d5e9ee5cb8a/5C3FF8FB/t51.2885-15/e35/s150x150/39304318_891836011010998_4614307756659179520_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/97e6f0c4bac2cd33a93bcd372d10d0b3/5C25E10B/t51.2885-15/e35/s320x320/39304318_891836011010998_4614307756659179520_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/5f366f488f80d420e666357dde447382/5C40E15C/t51.2885-15/sh0.08/e35/s640x640/39304318_891836011010998_4614307756659179520_n.jpg%22%7D%7D,%22created_time%22:%221535454773%22,%22caption%22:%7B%22id%22:%2217974799410051310%22,%22text%22:%22Hainan%20charter%20package%5CnVisa%20Free%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221535454773%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BnBTzToBC-n/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221833486022370112201_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/a1bc09eb97de60a203534ffba8bdd6fb/5BA842C1/t51.2885-15/e15/s150x150/37086824_219280625303689_3573174849083801600_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/9bd4283bfac43f3a0e84f6c1ce8996bc/5BA8C0F1/t51.2885-15/e15/s320x320/37086824_219280625303689_3573174849083801600_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/475e1145174456afed95c73200d1fea4/5BA83120/t51.2885-15/e15/37086824_219280625303689_3573174849083801600_n.jpg%22%7D%7D,%22created_time%22:%221532788639%22,%22caption%22:null,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:3%7D,%22tags%22:%5B%5D,%22filter%22:%22Hefe%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22video%22,%22link%22:%22https://www.instagram.com/p/Blx2dK4A7LJ/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22videos%22:%7B%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/844c7872cf5b1bf888169fd8603944d0/5BA8654F/t50.2886-16/37565163_268989000499902_7628204608841580544_n.mp4%22,%22id%22:%2217964708844035893%22%7D,%22low_bandwidth%22:%7B%22width%22:480,%22height%22:480,%22url%22:%22https://scontent.cdninstagram.com/vp/1074463a66b14b2de4e5a921976b5345/5BA8AF92/t50.2886-16/37397082_1873678326260881_4954282563058270208_n.mp4%22,%22id%22:%2217873074087262159%22%7D,%22low_resolution%22:%7B%22width%22:480,%22height%22:480,%22url%22:%22https://scontent.cdninstagram.com/vp/1074463a66b14b2de4e5a921976b5345/5BA8AF92/t50.2886-16/37397082_1873678326260881_4954282563058270208_n.mp4%22,%22id%22:%2217873074087262159%22%7D%7D%7D,%7B%22id%22:%221832703642193832901_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/a3449cf65337191103a06114cff00c63/5C5DCD7D/t51.2885-15/e35/s150x150/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/848c2840322b2a984c85f7ea549b7c88/5C611205/t51.2885-15/e35/s320x320/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/bb2602f5ea79c7402b5caec166541ae4/5C2FBEF8/t51.2885-15/sh0.08/e35/s640x640/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D%7D,%22created_time%22:%221532695320%22,%22caption%22:%7B%22id%22:%2217943230311087305%22,%22text%22:%22Singapore%20Airlines%20promo,%20Philippines%20to%20Asia,%20Oceania,%20%5CnEurope%20&%20South%20Africa%5Cn%5CnIssuance%20validity:%20August%2010,%202018%5CnTravel%20validity:%20December%2031,%202018%5Cn%5CnRemarks:%20terms%20and%20conditions%20apply,%20subject%20to%20availability%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221532695320%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:2%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/BlvEkCjhyvF/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/a3449cf65337191103a06114cff00c63/5C5DCD7D/t51.2885-15/e35/s150x150/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/848c2840322b2a984c85f7ea549b7c88/5C611205/t51.2885-15/e35/s320x320/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/bb2602f5ea79c7402b5caec166541ae4/5C2FBEF8/t51.2885-15/sh0.08/e35/s640x640/37378559_1763947090392604_8270358805787705344_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/82ed3f77a4c808e91d708db94ea66c49/5C422301/t51.2885-15/e35/s150x150/37654412_497656767357523_6115715713593245696_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/02a94d707df47fac9a1e82f8d22f7959/5C2B35F1/t51.2885-15/e35/s320x320/37654412_497656767357523_6115715713593245696_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/0196c4d71c1553fb9d7ac2df39b89254/5C2341A6/t51.2885-15/sh0.08/e35/s640x640/37654412_497656767357523_6115715713593245696_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/a3a09b506051cd2f63af1cf6464e2549/5C250452/t51.2885-15/e35/s150x150/37259856_439472573128982_2401308256619200512_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/89e7942ab8df51a1761b3b79dbc98982/5C5D4BA2/t51.2885-15/e35/s320x320/37259856_439472573128982_2401308256619200512_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/a3abbe0784db43acaa6acb2bcdd79cfc/5C246EF5/t51.2885-15/sh0.08/e35/s640x640/37259856_439472573128982_2401308256619200512_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/0abb7f568d9e9de686f5ea47cbd5d8e2/5C3FB16A/t51.2885-15/e35/s150x150/37890087_2209330209290328_1877223058532466688_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/90be2714e2f706a71b433e63b7c8a49b/5C5FA112/t51.2885-15/e35/s320x320/37890087_2209330209290328_1877223058532466688_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/faa9e08ab4d65cf8605536705f724643/5C432FEF/t51.2885-15/sh0.08/e35/s640x640/37890087_2209330209290328_1877223058532466688_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/dc1b3705b2a362810e36445e7037fed1/5C3DE141/t51.2885-15/e35/s150x150/37185053_506890046426418_4827564058410483712_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/f24d2904da988fa9e86bfc2d6a9ebdbb/5C2540B1/t51.2885-15/e35/s320x320/37185053_506890046426418_4827564058410483712_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/2052980e23dc99cd30e8420bdd8235f0/5C3FA9E6/t51.2885-15/sh0.08/e35/s640x640/37185053_506890046426418_4827564058410483712_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/334bba0ab9c7e5a5534d87ca5806efbe/5C3FFBA7/t51.2885-15/e35/s150x150/37688449_1842709712692698_7437787577370804224_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/cbaa7f9b25fe72a19154dcd061543b35/5C24EBDF/t51.2885-15/e35/s320x320/37688449_1842709712692698_7437787577370804224_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/0b1e1dad3fc4b686c2505466c4f8740c/5C334E22/t51.2885-15/sh0.08/e35/s640x640/37688449_1842709712692698_7437787577370804224_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/87e7bdcb765858ed24b1597d2a41aeed/5C5D1A8B/t51.2885-15/e35/s150x150/37083773_1949182681813293_7085947726248017920_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/f7f4221ed7f7278c99f24b8a64f942fd/5C41E6F3/t51.2885-15/e35/s320x320/37083773_1949182681813293_7085947726248017920_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/aa721c1f144fc538606dc71aeb63bede/5C5C2C0E/t51.2885-15/sh0.08/e35/s640x640/37083773_1949182681813293_7085947726248017920_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/18accd27d21686314dfe3aab57289633/5C1E7B16/t51.2885-15/e35/s150x150/37207565_227731411398043_5454956688983457792_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/8eb1fed879764ae4c4083e60c0b21b26/5C241BE6/t51.2885-15/e35/s320x320/37207565_227731411398043_5454956688983457792_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/d5fd29c10b539b6d00042edaccab1369/5C3EAFB1/t51.2885-15/sh0.08/e35/s640x640/37207565_227731411398043_5454956688983457792_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/ff5f95beeab3017e6ff4dac549796c0d/5C2F19FD/t51.2885-15/e35/s150x150/37867469_219617345363716_6462109889782087680_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/62c3559d4d6752e3498448c7458ed7ff/5C5DB00D/t51.2885-15/e35/s320x320/37867469_219617345363716_6462109889782087680_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/f200152f2f1417514980e32ebf91b6b4/5C322E5A/t51.2885-15/sh0.08/e35/s640x640/37867469_219617345363716_6462109889782087680_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221832012717004055105_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/221f3506b67ee27d59e80c67f35238e7/5C238E70/t51.2885-15/e35/s150x150/37090378_458408747968496_5231678317270138880_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/99dfd1190c4c99afc6c1e940d5016f4f/5C613580/t51.2885-15/e35/s320x320/37090378_458408747968496_5231678317270138880_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/221df4ba25827529911a71e5ace0107d/5C322FD7/t51.2885-15/sh0.08/e35/s640x640/37090378_458408747968496_5231678317270138880_n.jpg%22%7D%7D,%22created_time%22:%221532612956%22,%22caption%22:%7B%22id%22:%2217900759824221019%22,%22text%22:%22AmaWaterways%20%7C%20Romantic%20Danube%5CnAustria,%20Czech%20Republic,%20Germany,%20Hungary%5Cn%5CnAmaWaterways%20%7C%20Christmas%20markets%20on%20the%20Rhine%5CnFrance,%20Germany,%20Netherlands,%20Switzerland%5Cn%5CnRemarks:%20-%20Terms%20and%20conditions%20apply,%20subject%20to%20availability%5Cn%5CnRates%20excludes:%20airfare,%20visa,%20pre%20and%20post%20land%20arrangements,%20shore%20excursions,%20gratuities%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221532612956%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:19%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/BlsndwVBmJB/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/221f3506b67ee27d59e80c67f35238e7/5C238E70/t51.2885-15/e35/s150x150/37090378_458408747968496_5231678317270138880_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/99dfd1190c4c99afc6c1e940d5016f4f/5C613580/t51.2885-15/e35/s320x320/37090378_458408747968496_5231678317270138880_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/221df4ba25827529911a71e5ace0107d/5C322FD7/t51.2885-15/sh0.08/e35/s640x640/37090378_458408747968496_5231678317270138880_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/fea79dc7896d85def59c4ba1fe221b33/5C1D3B07/t51.2885-15/e35/s150x150/37857781_677633819254401_5020518062638497792_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/bc33138fb5ccdd4acebce658f964c3c7/5C2784F7/t51.2885-15/e35/s320x320/37857781_677633819254401_5020518062638497792_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/ba0755d6c133eff2911fa388a97c6427/5C3C2FA0/t51.2885-15/sh0.08/e35/s640x640/37857781_677633819254401_5020518062638497792_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221832011939623233526_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/8fa4b7c0c2a63470e3e1e61af0188b75/5C27A9C9/t51.2885-15/e35/s150x150/37330978_305647836850963_3469778145702313984_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/9a115655bd304aab8590ad9616a7cb0e/5C3DA139/t51.2885-15/e35/s320x320/37330978_305647836850963_3469778145702313984_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/2ca786fed028a01b876767bfb1448c6a/5C1D7E6E/t51.2885-15/sh0.08/e35/s640x640/37330978_305647836850963_3469778145702313984_n.jpg%22%7D%7D,%22created_time%22:%221532612863%22,%22caption%22:%7B%22id%22:%2217872080730260763%22,%22text%22:%22MSC%20Cruise%20North%20Europe%20%7C%20sailing:%20Oct%2001,%202018%5CnUK,%20France,%20Belgium,%20Netherlands,%20Germany%5Cn%5CnMSC%20Cruise%20Mediterranean%20%7C%20sailing:%20Dec%2002,%202018%5CnItaly,%20Malta,%20Spain,%20France%5Cn%5CnRemarks:%20-%20Terms%20and%20conditions%20apply,%20subject%20to%20availability%5Cn%5CnRates%20excludes:%20airfare,%20visa,%20pre%20and%20post%20land%20arrangements,%20shore%20excursions,%20gratuities%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221532612863%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:33%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/BlsnScVhGf2/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/8fa4b7c0c2a63470e3e1e61af0188b75/5C27A9C9/t51.2885-15/e35/s150x150/37330978_305647836850963_3469778145702313984_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/9a115655bd304aab8590ad9616a7cb0e/5C3DA139/t51.2885-15/e35/s320x320/37330978_305647836850963_3469778145702313984_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/2ca786fed028a01b876767bfb1448c6a/5C1D7E6E/t51.2885-15/sh0.08/e35/s640x640/37330978_305647836850963_3469778145702313984_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/a1573658ab95dba4787b5bd1edd5aa5e/5C61EA5F/t51.2885-15/e35/s150x150/36904167_667013320341100_3286810812315860992_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/18af6094ae3593b331d8ec8056a3bfda/5C27F4AF/t51.2885-15/e35/s320x320/36904167_667013320341100_3286810812315860992_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/24682e24f924591a7a69b81ff475c201/5C1CEFF8/t51.2885-15/sh0.08/e35/s640x640/36904167_667013320341100_3286810812315860992_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221832011498843913330_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/0d1e0e56a9c1a6eabf45ab07b937fe8a/5C257B1F/t51.2885-15/e35/s150x150/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/b3458369403a1272e3b3696f3e15f5d5/5C335E67/t51.2885-15/e35/s320x320/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/386204ce839aa1e8ff0c8f03cb95c3c6/5C61AF9A/t51.2885-15/sh0.08/e35/s640x640/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D%7D,%22created_time%22:%221532612810%22,%22caption%22:%7B%22id%22:%2217938890112142347%22,%22text%22:%22Turkish%20Airlines%20promo,%20Philippines%20to%20Europe%20&%20South%20Africa%5Cn%5CnIssuance%20validity:%20July%2030,%202018%5CnTravel%20validity:%20March%2015,%202019%5Cn%5CnRemarks:%20terms%20and%20conditions%20apply,%20subject%20to%20availability%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221532612810%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:9%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/BlsnMB1Bbxy/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/0d1e0e56a9c1a6eabf45ab07b937fe8a/5C257B1F/t51.2885-15/e35/s150x150/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/b3458369403a1272e3b3696f3e15f5d5/5C335E67/t51.2885-15/e35/s320x320/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/386204ce839aa1e8ff0c8f03cb95c3c6/5C61AF9A/t51.2885-15/sh0.08/e35/s640x640/37193281_2001027696594768_6486011125086289920_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/9fc82355c3fe4cf96cc4c21febf6d146/5C3DA453/t51.2885-15/e35/s150x150/37131529_261504431306444_3100034564492361728_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/3725c8bd47006608917650004be16470/5C25EEA3/t51.2885-15/e35/s320x320/37131529_261504431306444_3100034564492361728_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/16704875ffbb0a6e94978a9da9984e46/5C43C0F4/t51.2885-15/sh0.08/e35/s640x640/37131529_261504431306444_3100034564492361728_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/f02eb7b07d778bee4feaa1e08afc92c9/5C3E6476/t51.2885-15/e35/s150x150/37105894_1886865638042011_3604238552239439872_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/664575d3a4cf0aafcd06a8ff7e98b0aa/5C412A0E/t51.2885-15/e35/s320x320/37105894_1886865638042011_3604238552239439872_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/8cb22e4a5bf17e1c532231942a27d0ca/5C41F6F3/t51.2885-15/sh0.08/e35/s640x640/37105894_1886865638042011_3604238552239439872_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/952f5e45d4a91f278b16051c8b9dd967/5C3DDEE5/t51.2885-15/e35/s150x150/37314707_464385827367056_2543603387878866944_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/01a7de17f22f17fba0429f9bce2d74fe/5C1EFF15/t51.2885-15/e35/s320x320/37314707_464385827367056_2543603387878866944_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/211d1c31cb432634faf697e12b44bda6/5C292942/t51.2885-15/sh0.08/e35/s640x640/37314707_464385827367056_2543603387878866944_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/f5a05ddc24193a906514f27889767816/5C40731A/t51.2885-15/e35/s150x150/37102892_486120548502555_7976266851543941120_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/d4b028dfe965d48271ee4d48399d1af4/5C256EEA/t51.2885-15/e35/s320x320/37102892_486120548502555_7976266851543941120_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/2b31736910d366951008d828d47ef036/5C1D86BD/t51.2885-15/sh0.08/e35/s640x640/37102892_486120548502555_7976266851543941120_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/ae42817012f90f00391130c7ea19f9b1/5C23B559/t51.2885-15/e35/s150x150/37182746_2062439730464746_4278306696952020992_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/08315304bd908daf79370c2a7544eea5/5C2CEA21/t51.2885-15/e35/s320x320/37182746_2062439730464746_4278306696952020992_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/dade15eb876647d377a237ce0d5eb75b/5C2E41DC/t51.2885-15/sh0.08/e35/s640x640/37182746_2062439730464746_4278306696952020992_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/076ed23fc6701400d3e4f34bb26a5fa3/5C2EACB6/t51.2885-15/e35/s150x150/37190649_461303134343904_7987921533064445952_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/23f2cc8a124036db10b416d413633c1a/5C2C1A46/t51.2885-15/e35/s320x320/37190649_461303134343904_7987921533064445952_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/b40375f2a56064ce7aad60fc676ea8e1/5C2D0B11/t51.2885-15/sh0.08/e35/s640x640/37190649_461303134343904_7987921533064445952_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/ab36f3eadf0f1282e28e1a9a87ec45b9/5C43DFAA/t51.2885-15/e35/s150x150/37059674_245292262752346_3064343446392143872_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/4b569369302c66463999229617886a3e/5C28F45A/t51.2885-15/e35/s320x320/37059674_245292262752346_3064343446392143872_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/aad69df0ca07cf247d9004719dd741e5/5C2AB30D/t51.2885-15/sh0.08/e35/s640x640/37059674_245292262752346_3064343446392143872_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221832010510892441306_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/989bcbd60f8030721131aaaff38b4edd/5C30837E/t51.2885-15/e35/s150x150/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/3789b7f0e04cf999c5c7a89126c529b7/5C631306/t51.2885-15/e35/s320x320/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/f83d45de86e57c522843e5a469f3e449/5C3FE5FB/t51.2885-15/sh0.08/e35/s640x640/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D%7D,%22created_time%22:%221532612693%22,%22caption%22:%7B%22id%22:%2217904452422203562%22,%22text%22:%22EVA%20Airways%20promo,%20Philippines%20to%20USA%5Cn%5CnIssuance%20validity:%20July%2031,%202018%5CnTravel%20validity:%20March%2031,%202019%5Cn%5CnRemarks:%20rates%20are%20valid%20on%20low%20season%20rate,%20subject%20to%20availability%5Cn%5CnFor%20more%20details:%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221532612693%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:20%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:3%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/Blsm9puhp7a/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/989bcbd60f8030721131aaaff38b4edd/5C30837E/t51.2885-15/e35/s150x150/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/3789b7f0e04cf999c5c7a89126c529b7/5C631306/t51.2885-15/e35/s320x320/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/f83d45de86e57c522843e5a469f3e449/5C3FE5FB/t51.2885-15/sh0.08/e35/s640x640/37055538_1887767351524618_8218852922318913536_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/04d514575b32269e6b65aab0061457e9/5C4099FD/t51.2885-15/e35/s150x150/37344076_2309711399044218_676350219750735872_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/abe5acfb8015532c0778a811fa989025/5C2BD10D/t51.2885-15/e35/s320x320/37344076_2309711399044218_676350219750735872_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/50497e10c21f7df2884ac6cdcd7764ca/5C5DC25A/t51.2885-15/sh0.08/e35/s640x640/37344076_2309711399044218_676350219750735872_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/7dc2d71929f992529d7386425b237c2d/5C2B3669/t51.2885-15/e35/s150x150/37194825_640558326299481_3531957207585259520_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/457d0896282af7fef3c8fe87c4337dba/5C30EB99/t51.2885-15/e35/s320x320/37194825_640558326299481_3531957207585259520_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/992004645c02e03aefd7ad00ec88b742/5C4409CE/t51.2885-15/sh0.08/e35/s640x640/37194825_640558326299481_3531957207585259520_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/ec175d5f77058c99136d4e231026f884/5C1EBFA4/t51.2885-15/e35/s150x150/37183899_2177396429173053_7072210277646729216_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/76ad14458c6b03297b1e3170ef9f6b3a/5C24E3DC/t51.2885-15/e35/s320x320/37183899_2177396429173053_7072210277646729216_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/a4772731c67d45f74fd410331e173b31/5C2C2921/t51.2885-15/sh0.08/e35/s640x640/37183899_2177396429173053_7072210277646729216_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221821726457094140597_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/04aff99e838922083356f6d3c1a9e3d3/5C2A3744/t51.2885-15/e35/s150x150/36621905_2058634627725518_3918040785714413568_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/1b807651117749bc4c804d858c997a04/5C25F03C/t51.2885-15/e35/s320x320/36621905_2058634627725518_3918040785714413568_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/e16d9c926ef4676bf41ecd5165b678be/5C3353C1/t51.2885-15/sh0.08/e35/s640x640/36621905_2058634627725518_3918040785714413568_n.jpg%22%7D%7D,%22created_time%22:%221531386738%22,%22caption%22:%7B%22id%22:%2217932297840159666%22,%22text%22:%22Travel%20with%20Cathay%20Pacific%20Airways%20and%20experience%20delectable%20inflight%20dining,%20state%20of%20the%20art%20audio%20and%20video%20on%20demand,%20and%20generous%20baggage%20allowance.%5Cn%5CnVisit%20our%20International%20Travel%20Festival%20(ITF)%20%20booth%20located%20at%20#60%20and%2061,%20Ayala%20Center%20Cebu%20from%2013July%20to%2015July%202018%20or%20click%20http://bit.ly/CEBLATESTOFFERS%20to%20kick%20off%20your%20#lifewelltravelled.%22,%22created_time%22:%221531386738%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:9%7D,%22tags%22:%5B%2260%22,%22lifewelltravelled%22%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BlIEo-RBvK1/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221808089372172865375_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/044e8489d113e6c8fcf60f0c18f2a5a5/5C62704C/t51.2885-15/e35/s150x150/35295723_2055042881429398_2386243031763255296_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/5f0f293b3748b90eedace47aecb32d65/5C207B34/t51.2885-15/e35/s320x320/35295723_2055042881429398_2386243031763255296_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/9abc258650cf4025ade0c9b32560f8d5/5C5D53C9/t51.2885-15/sh0.08/e35/s640x640/35295723_2055042881429398_2386243031763255296_n.jpg%22%7D%7D,%22created_time%22:%221529761071%22,%22caption%22:%7B%22id%22:%2217896367608207182%22,%22text%22:%22Urgent%20hiring%20for%20the%20following%20positions:%5Cn%5CnACCOUNTING%20STAFF%20(Cebu)%20*Graduate%20of%20accounting%20or%20any%20business%20management%20related%20courses.%5Cn*Experience%20in%20the%20related%20field%20is%20an%20advantage.%20Fresh%20graduates%20are%20welcome%20to%20apply.%5Cn*Proficient%20in%20MS%20Office%20Applications.%5Cn*Able%20to%20work%20as%20part%20of%20the%20team%5Cn%5CnCounter%20Sales%20&%20Reservations%20(Davao)%20*Graduate%20of%20tourism%20or%20business%20related%20courses.%5Cn*Knowledgeable%20in%20using%20Amadeus%20or%20Sabre%20GDS%20system%20is%20an%20advantage%5Cn*Fresh%20graduates%20are%20welcome%20to%20apply.%5Cn*Proficient%20in%20MS%20Office%20Applications.%5Cn*Able%20to%20work%20as%20part%20of%20the%20team%5Cn%5CnFor%20interested%20applicants:%20please%20send%20your%20updated%20CV%20to%20info@travelite.com.ph%22,%22created_time%22:%221529761071%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:5%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BkXn7ROhc9f/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%7B%22user%22:%7B%22username%22:%22mattpoonin%22%7D,%22position%22:%7B%22x%22:0.5244444173,%22y%22:0.6551110840000001%7D%7D,%7B%22user%22:%7B%22username%22:%22tim_tio%22%7D,%22position%22:%7B%22x%22:0.7848888753000001,%22y%22:0.343111084%7D%7D%5D%7D,%7B%22id%22:%221807111468962186764_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/c4bd715b333c4379ffb9aadcb395532f/5C62D536/t51.2885-15/e35/c204.0.641.641/s150x150/36085964_842703015939257_1407299541236973568_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:195,%22url%22:%22https://scontent.cdninstagram.com/vp/b20ed0abfa8602bd51091c1109af42ac/5C6316BB/t51.2885-15/e35/s320x320/36085964_842703015939257_1407299541236973568_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:390,%22url%22:%22https://scontent.cdninstagram.com/vp/21c9dcbd7baf0b8f30f765b24abae461/5C31BEEC/t51.2885-15/sh0.08/e35/s640x640/36085964_842703015939257_1407299541236973568_n.jpg%22%7D%7D,%22created_time%22:%221529644496%22,%22caption%22:%7B%22id%22:%2217955035299022759%22,%22text%22:%22for%20everybody\\\'s%20attention,%20the%20following%20facebook%20page%20is%20not%20owned%20or%20controlled%20by%20Travelite%20Travel%20and%20Tours,%20ANY%20TRANSACTIONS%20FROM%20THIS%20FRAUDULENT%20WEBPAGE%20WILL%20NOT%20BE%20HONORED.%20PLEASE%20REPORT%20IT%20IMMEDIATELY%20OF%20ANY%20SUCH%20UNAUTHORIZED%20ACTIVITY.%5Cn%5CnOur%20office%20address%20is%201707%20Tycoon%20Tower,%20Pearl%20Drive,%20Ortigas,%20Pasig%20City%5CnTel%20#%206338434%20/%206338423%22,%22created_time%22:%221529644496%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:4%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BkUJk55BoYM/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221801230454012282856_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/17c32e21077e6c522ed314449feaad7c/5C2F4773/t51.2885-15/e35/s150x150/34047683_801191390077888_6352239438029914112_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/790c02187acefb50d9da65013c17302e/5C62C283/t51.2885-15/e35/s320x320/34047683_801191390077888_6352239438029914112_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/7b9a7eeeb6827c81fe4cfd049375db15/5C31DFD4/t51.2885-15/sh0.08/e35/s640x640/34047683_801191390077888_6352239438029914112_n.jpg%22%7D%7D,%22created_time%22:%221528943424%22,%22caption%22:%7B%22id%22:%2217952522994013601%22,%22text%22:%22See%20the%20world%20with%20us,%20visit%20us%20at%20the%20upcoming%20International%20Travel%20Festival%20this%20coming%20July%2013%20-%2015%20at%20the%20Ayala%20Center%20Cebu,%20booth%2033,%2034,%20&%2035%20(across%20Laguna%20Garden%20Cafe)%22,%22created_time%22:%221528943424%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:11%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bj_QY36BIfo/%22,%22location%22:%7B%22latitude%22:10.3710633,%22longitude%22:123.9181935,%22name%22:%22Ayala%20Center%20Cebu%22,%22id%22:1271246079662830%7D,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221799949560714883994_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/b6839f9e2a0ec03acd8ed65a9325922c/5C2044DE/t51.2885-15/e35/c1.0.1078.1078/s150x150/33929618_243236902893479_279481583604334592_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:319,%22url%22:%22https://scontent.cdninstagram.com/vp/0b455ae2cd09852d172f180a81c9ba19/5C629295/t51.2885-15/e35/s320x320/33929618_243236902893479_279481583604334592_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:638,%22url%22:%22https://scontent.cdninstagram.com/vp/a3d3b901dc60ff364d8f33ae510ed3ef/5C5D0B79/t51.2885-15/sh0.08/e35/s640x640/33929618_243236902893479_279481583604334592_n.jpg%22%7D%7D,%22created_time%22:%221528790730%22,%22caption%22:%7B%22id%22:%2217951328868007373%22,%22text%22:%22Princess%20Cruise:%20Japan%20%7C%20Alaska%20%7C%20Australia%20&%20New%20Zealand%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528790730%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:10%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/Bj6tJbEB_Oa/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/b6839f9e2a0ec03acd8ed65a9325922c/5C2044DE/t51.2885-15/e35/c1.0.1078.1078/s150x150/33929618_243236902893479_279481583604334592_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:319,%22url%22:%22https://scontent.cdninstagram.com/vp/0b455ae2cd09852d172f180a81c9ba19/5C629295/t51.2885-15/e35/s320x320/33929618_243236902893479_279481583604334592_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:638,%22url%22:%22https://scontent.cdninstagram.com/vp/a3d3b901dc60ff364d8f33ae510ed3ef/5C5D0B79/t51.2885-15/sh0.08/e35/s640x640/33929618_243236902893479_279481583604334592_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/b51276baf048149d801b5b9df8a9e1fb/5C314F98/t51.2885-15/e35/c1.0.1078.1078/s150x150/33788187_202017270442189_2867990181707776000_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:319,%22url%22:%22https://scontent.cdninstagram.com/vp/df6ee02f865fea59b4eea2629ffda65d/5C43A383/t51.2885-15/e35/s320x320/33788187_202017270442189_2867990181707776000_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:638,%22url%22:%22https://scontent.cdninstagram.com/vp/f265ce3ba9275c75178a077c4e76eddc/5C2D63D4/t51.2885-15/sh0.08/e35/s640x640/33788187_202017270442189_2867990181707776000_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/de962270a8e9b12ae889419b77f8f8a7/5C5F8DBE/t51.2885-15/e35/c1.0.1078.1078/s150x150/34036465_1927861940578094_1566519802875346944_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:319,%22url%22:%22https://scontent.cdninstagram.com/vp/3a02370a47d315373128fdb2f3483b27/5C32C8FD/t51.2885-15/e35/s320x320/34036465_1927861940578094_1566519802875346944_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:638,%22url%22:%22https://scontent.cdninstagram.com/vp/ffd8814aae139743d12cf6836a47441b/5C222100/t51.2885-15/sh0.08/e35/s640x640/34036465_1927861940578094_1566519802875346944_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221799106398882376027_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/08b2c67ecaf32aed2974dc544581fa37/5C2EF1C1/t51.2885-15/e35/s150x150/33559751_196484561073288_7216981388833062912_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/55f50b409ebda0b9d7df38da3935112c/5C5D1631/t51.2885-15/e35/s320x320/33559751_196484561073288_7216981388833062912_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/cc71e25d0e771b672d623f72cd2a2b15/5C329566/t51.2885-15/sh0.08/e35/s640x640/33559751_196484561073288_7216981388833062912_n.jpg%22%7D%7D,%22created_time%22:%221528690217%22,%22caption%22:%7B%22id%22:%2217943344770073092%22,%22text%22:%22See%20the%20world%20with%20us,%20visit%20us%20at%20the%20upcoming%20Travel%20Madness%20Expo%20this%20coming%20July%205%20-%208%20at%20the%20SMX%20Convention%20Center%20in%20Pasay%20City,%20booth%20215%20(beside%20Philippine%20Airlines)%22,%22created_time%22:%221528690217%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:8%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bj3tbzahClb/%22,%22location%22:%7B%22latitude%22:14.5311864,%22longitude%22:120.9825319,%22name%22:%22SMX%20Convention%20Center%20-%20SM%20Mall%20of%20Asia%22,%22id%22:1790022364659612%7D,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221798492288075672788_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/d75a6d79a208829c40d12032b936efe5/5C2BF851/t51.2885-15/e35/s150x150/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/0911da679455b4935d51f4c3a2e497fb/5C3FCC29/t51.2885-15/e35/s320x320/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/426ea350589bc5932ea295bd12f7f0a6/5C202ED4/t51.2885-15/sh0.08/e35/s640x640/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D%7D,%22created_time%22:%221528617009%22,%22caption%22:%7B%22id%22:%2217952434629055399%22,%22text%22:%22Join%20us%20on%20our%20upcoming%20pilgrimage%20to%20the%20HOLY%20LAND%20tour!%2012%20Days%20and%2011%20Nights%20of%20culture,%20history,%20architecture%20and%20spirituality%20as%20we%20travel%20through%20Jordan,%20Israel%20and%20Egypt!%20---------------------------------%20Journey%20with%20the%20Lord%20to%20the%20Holyland%5CnOctober%20and%20November%202018%5CnFebruary,%20April%20and%20May%202019%5CnJordan%20-%20Israel%20-%20Egypt%5Cn%5CnRATE%5CnUSD%202,950%20++%20per%20person%5Cn%5CnINCLUSIONS%5CnAccommodation:%5Cnbased%20on%20twin/triple%20sharing,%20with%20daily%20breakfast,%20lunch%20and%20Dinner%5Cn2%20Night%20in%20Amman%5Cn2%20Night%20in%20Tiberias%5Cn3%20Nights%20in%20Jerusalem%20%5Cn2%20Nights%20in%20Dahab%5Cn2%20Nights%20in%20Cairo%5Cn%5CnTransportation:%5CnRound%20trip%20economy%20airfare%20%5CnAirport%20Transfers%20in%20Amman%20and%20Cairo%5CnChartered%20Transportation%20for%20the%20entire%20tour%5Cn%5CnTours:%5CnMadaba,%20Mt.%20Nebo%5CnPetra%20Tour%5CnDead%20Sea%20and%20Jericho%20Tour%5CnGalilee%20Tour%20%5CnJerusalem%20Tour%5CnBethlehem%20Tour%5CnGiza%20and%20Sphinx%20Tour%5Cnplus%20other%20sites%20on%20the%20way%5Cn%5CnVisa%20&%20Departure%20Taxes%20in%20Jordan,%20Israel%20&%20Egypt%5Cn%5CnOthers:%5CnTravelite%20ID%20and%20Bagtag%5CnService%20of%20Travel%20Factor%20Coordinator%5Cn%5CnNot%20Included:%5CnPhilippine%20Travel%20Tax%20(P1,620)%5CnLocal%20transportation%20during%20free%20time%20---------------------------------%20HIGHLIGHTS%5Cn-%20Travel%20to%20the%20Holy%20Land%5Cn-%20See%203%20countries:%20Jordan,%20Israel%20and%20Egypt!%5Cn-%20Everything\\\'s%20included,%20no%20more%20compulsary%20tipping,%20etc.%20No%20hidden%20charges!%20---------------------------------%20FOR%20INQUIRIES%5Cn-%20Email%20us%20at%20info@travelite.com.ph%5Cn-%20www.travelite.com.ph%5Cn-%20Visit%20us%20at%20our%20office%20in%20Cebu,%20Pasig%20and%20Davao%5Cn-%20Or%20send%20us%20a%20PM!%22,%22created_time%22:%221528617009%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:13%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22carousel%22,%22link%22:%22https://www.instagram.com/p/Bj1hzUKB6zU/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D,%22carousel_media%22:%5B%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/d75a6d79a208829c40d12032b936efe5/5C2BF851/t51.2885-15/e35/s150x150/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/0911da679455b4935d51f4c3a2e497fb/5C3FCC29/t51.2885-15/e35/s320x320/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/426ea350589bc5932ea295bd12f7f0a6/5C202ED4/t51.2885-15/sh0.08/e35/s640x640/33860232_2183056101917834_5778267176892891136_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/3d30677bca842f133e05ba0fc04c0562/5C5D8A79/t51.2885-15/e35/c0.0.1079.1079/s150x150/33689643_171564576871249_618033557532573696_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:319,%22url%22:%22https://scontent.cdninstagram.com/vp/6633af78c766604c88cbfde286cc843b/5C3C17CF/t51.2885-15/e35/s320x320/33689643_171564576871249_618033557532573696_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:639,%22url%22:%22https://scontent.cdninstagram.com/vp/a45f4cef9441973743088cd89c7e600a/5C420123/t51.2885-15/sh0.08/e35/s640x640/33689643_171564576871249_618033557532573696_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/dd53a805e6813462a81e222d1493602c/5C24A29D/t51.2885-15/e35/s150x150/34216241_195256447786817_7484020400641277952_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/d292f47639af616d7eaf885738836138/5C3EF06D/t51.2885-15/e35/s320x320/34216241_195256447786817_7484020400641277952_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/4f15e428f78e6223541a4fbdb784ed3c/5C22F03A/t51.2885-15/sh0.08/e35/s640x640/34216241_195256447786817_7484020400641277952_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D,%7B%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/d5487c33cff4fcb8b493706096e34f8a/5C63230D/t51.2885-15/e35/s150x150/33639772_372051926652438_5823071957897183232_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/e9a810d4537d8a16e5574bf3f07f40fd/5C2A2DFD/t51.2885-15/e35/s320x320/33639772_372051926652438_5823071957897183232_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/1da9e364cee713823ea908bc2262ed6c/5C3D36AA/t51.2885-15/sh0.08/e35/s640x640/33639772_372051926652438_5823071957897183232_n.jpg%22%7D%7D,%22users_in_photo%22:%5B%5D,%22type%22:%22image%22%7D%5D%7D,%7B%22id%22:%221797742635919033978_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/f775473d09733d6e0c1e12a0407df336/5C26FBC8/t51.2885-15/e35/s150x150/33980699_461530287604924_7886948471138156544_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/76fbde2faa62dcd801d4e0c34e82ad31/5C3C3A38/t51.2885-15/e35/s320x320/33980699_461530287604924_7886948471138156544_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/d159c49d39a1a5108b10a02d4cbec8b9/5C5BFE6F/t51.2885-15/sh0.08/e35/s640x640/33980699_461530287604924_7886948471138156544_n.jpg%22%7D%7D,%22created_time%22:%221528527644%22,%22caption%22:%7B%22id%22:%2217951283529002970%22,%22text%22:%22Endless%20Osaka%20%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528527644%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:6%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:1%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bjy3WcLh0Z6/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221797719306294117151_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/555029fbb6718330de7b5dca1593b56d/5C31036B/t51.2885-15/e35/s150x150/34458209_786162691579381_8520447187996377088_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/e372dc600a2ef5b6c7b6b8a2b45a7c86/5C31A59B/t51.2885-15/e35/s320x320/34458209_786162691579381_8520447187996377088_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/c3415358349e41800a393c470c6f9b5d/5C28D6CC/t51.2885-15/sh0.08/e35/s640x640/34458209_786162691579381_8520447187996377088_n.jpg%22%7D%7D,%22created_time%22:%221528524863%22,%22caption%22:%7B%22id%22:%2217951657746059558%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528524863%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjyyC8xhcMf/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221797719174383236634_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/38f3e2b484e812dd0b6725ee5e105c0d/5C333612/t51.2885-15/e35/s150x150/34099007_220285068569184_1510816022666412032_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/3c17053041f57cca7483b781d2135db4/5C31E0E2/t51.2885-15/e35/s320x320/34099007_220285068569184_1510816022666412032_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/353515bf1b9dd245ee4874fd229064c6/5C5F76B5/t51.2885-15/sh0.08/e35/s640x640/34099007_220285068569184_1510816022666412032_n.jpg%22%7D%7D,%22created_time%22:%221528524847%22,%22caption%22:%7B%22id%22:%2217925989866136218%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528524847%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:10%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjyyBB7BXYa/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221797719053469773887_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/cde2003d759761738806b54b5c5430e9/5C21EF98/t51.2885-15/e35/s150x150/34007165_173301086678038_9140408975391457280_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/2ed4c953a21db24b875d2c00c0d708a3/5C609B68/t51.2885-15/e35/s320x320/34007165_173301086678038_9140408975391457280_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/7c49f13353c71d97fd980c2d9f8ba48f/5C2DEE3F/t51.2885-15/sh0.08/e35/s640x640/34007165_173301086678038_9140408975391457280_n.jpg%22%7D%7D,%22created_time%22:%221528524832%22,%22caption%22:%7B%22id%22:%2217934436651127143%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528524832%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:15%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bjyx_RUBHA_/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221797718874591229641_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/de3b50a123b59290dc0440690f6b9e84/5C2A3CDE/t51.2885-15/e35/s150x150/34592401_169569970381251_562153498980909056_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/b77d8be5517a944ad3fa3bb4410aa89e/5C5F70D3/t51.2885-15/e35/s320x320/34592401_169569970381251_562153498980909056_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/f6281821f9e6e67a3270489691d19d64/5C5BB73F/t51.2885-15/sh0.08/e35/s640x640/34592401_169569970381251_562153498980909056_n.jpg%22%7D%7D,%22created_time%22:%221528524811%22,%22caption%22:%7B%22id%22:%2217934699895126738%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528524811%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:11%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bjyx8quBnbJ/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221796259026649322352_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/94e9b8252ea3ea8b96f981dcd02307e5/5C3DA3AB/t51.2885-15/e15/s150x150/34820988_2158621017487227_6250212240805330944_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/e36f53d1864201b52d709cf320919634/5C2A49D3/t51.2885-15/e15/s320x320/34820988_2158621017487227_6250212240805330944_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/7a5d6830cd27738f759fe2fec44bb6b4/5C417296/t51.2885-15/sh0.08/e35/s640x640/34820988_2158621017487227_6250212240805330944_n.jpg%22%7D%7D,%22created_time%22:%221528350784%22,%22caption%22:%7B%22id%22:%2217861867728247305%22,%22text%22:%22MSC%20Cruise:%20Northern%20Europe%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528350784%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjtmBFYBZNw/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221796258552172920919_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/10287d17b69989977356e918c56227b6/5C2F79FF/t51.2885-15/e15/s150x150/34313747_810236599175611_6545500094332928000_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/e2a135213e72edeb066c431e31a93a0d/5C5BB80F/t51.2885-15/e15/s320x320/34313747_810236599175611_6545500094332928000_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/ab360f4dc0b5fe30ac23e06789356f53/5C403AF9/t51.2885-15/sh0.08/e35/s640x640/34313747_810236599175611_6545500094332928000_n.jpg%22%7D%7D,%22created_time%22:%221528350727%22,%22caption%22:%7B%22id%22:%2217924508028133883%22,%22text%22:%22MSC%20Cruise:%20Mediterranean%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528350727%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:12%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:2%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bjtl6LfBkBX/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221796257676830038060_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/eac51effc8363591da750eeca996d5c6/5C2A2D6D/t51.2885-15/e15/s150x150/34170780_988209704688153_919444050149376000_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/3051915691d9803af62e8367edde50c9/5C211560/t51.2885-15/e15/s320x320/34170780_988209704688153_919444050149376000_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/8ae617722e2a085454b65abd6ac25243/5C2EE6F2/t51.2885-15/sh0.08/e35/s640x640/34170780_988209704688153_919444050149376000_n.jpg%22%7D%7D,%22created_time%22:%221528350623%22,%22caption%22:%7B%22id%22:%2217878061125232718%22,%22text%22:%22Disney%20Cruises%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528350623%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:8%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjtltcQhdgs/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221796256891891176376_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/5acfb47e33553bcaab22215786e8aed3/5C600B54/t51.2885-15/e15/s150x150/34752853_2128286414123846_8602116566655434752_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/f149912eecc1a471ac8757b841217270/5C24932C/t51.2885-15/e15/s320x320/34752853_2128286414123846_8602116566655434752_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/de81344dfe69785b1e83b8d8b3d0ab60/5C323F69/t51.2885-15/sh0.08/e35/s640x640/34752853_2128286414123846_8602116566655434752_n.jpg%22%7D%7D,%22created_time%22:%221528350529%22,%22caption%22:%7B%22id%22:%2217877995485238438%22,%22text%22:%22Arosa%20River%20Cruise:%20The%20Legendary%20Danube%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528350529%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:6%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjtliBOhVO4/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221795807098983405354_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/0c7c2d801ba49364aa8d9c144dedca9f/5C1DB40E/t51.2885-15/e35/s150x150/33476369_2156509811304624_2961324094542315520_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/0ccaf51e6bc59db46c5a4c5258b5c996/5C237E76/t51.2885-15/e35/s320x320/33476369_2156509811304624_2961324094542315520_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/fe6123f373891ba096224b57221de09a/5C20CD8B/t51.2885-15/sh0.08/e35/s640x640/33476369_2156509811304624_2961324094542315520_n.jpg%22%7D%7D,%22created_time%22:%221528296910%22,%22caption%22:%7B%22id%22:%2217891305285203874%22,%22text%22:%22Costa%20Cruise:%20Japan%20&%20South%20Korea%20sailings%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528296910%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:9%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/Bjr_Qq8B9cq/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221794235085747401586_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/eb0da8e8d5cbd231807a47bdbec3b7f3/5C1D7427/t51.2885-15/e15/s150x150/33349397_1754216917997679_3589386671293988864_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/a41cb82135ac3c0b247c046a27acf218/5C1FA55F/t51.2885-15/e15/s320x320/33349397_1754216917997679_3589386671293988864_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/57cc9746cb9c100120ce9be9a727bd6f/5C1CCA1A/t51.2885-15/sh0.08/e35/s640x640/33349397_1754216917997679_3589386671293988864_n.jpg%22%7D%7D,%22created_time%22:%221528109511%22,%22caption%22:%7B%22id%22:%2217935676383129662%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221528109511%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:6%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjmZ03hhDNy/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221789700664394672031_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/46fdb20806db22ee4db663ae4e56aa56/5C2813A6/t51.2885-15/e35/c135.0.809.809/s150x150/32367579_2032224353693558_8835136147534381056_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:239,%22url%22:%22https://scontent.cdninstagram.com/vp/b8e0615199dff9e8b8422f9bf5149886/5C2D5275/t51.2885-15/e35/s320x320/32367579_2032224353693558_8835136147534381056_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:479,%22url%22:%22https://scontent.cdninstagram.com/vp/fabb80a7f6f71ce3e054230002e1b97f/5C3F3C88/t51.2885-15/sh0.08/e35/s640x640/32367579_2032224353693558_8835136147534381056_n.jpg%22%7D%7D,%22created_time%22:%221527568966%22,%22caption%22:%7B%22id%22:%2217947774156025719%22,%22text%22:%22#huangjin%20%20#taiwan%22,%22created_time%22:%221527568966%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:10%7D,%22tags%22:%5B%22taiwan%22,%22huangjin%22%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjWS0Wjhmef/%22,%22location%22:%7B%22latitude%22:25.117804886275,%22longitude%22:121.86148701759,%22name%22:%22Huangjin%20Golden%20Waterfalls%22,%22id%22:131014230863575%7D,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221789699859457375987_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/4db2b283cc02fd87505c4d38e19c456f/5C605106/t51.2885-15/e35/c135.0.809.809/s150x150/32430504_220842831845853_8261403382363717632_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:239,%22url%22:%22https://scontent.cdninstagram.com/vp/93e3169fbcce3c425c864a3f581ddcc2/5C2BAE81/t51.2885-15/e35/s320x320/32430504_220842831845853_8261403382363717632_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:479,%22url%22:%22https://scontent.cdninstagram.com/vp/78eafadeb078fc313188f5b3d4cf0057/5C261BD6/t51.2885-15/sh0.08/e35/s640x640/32430504_220842831845853_8261403382363717632_n.jpg%22%7D%7D,%22created_time%22:%221527568870%22,%22caption%22:%7B%22id%22:%2217886881173222167%22,%22text%22:%22#kabirabay%20#ishigaki%22,%22created_time%22:%221527568870%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%22ishigaki%22,%22kabirabay%22%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjWSoo5hf7z/%22,%22location%22:%7B%22latitude%22:24.461100352578,%22longitude%22:124.14263353729,%22name%22:%22Kabira%20Bay%22,%22id%22:337032420%7D,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221789067426781207960_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/11595a4766739c5ab0f797c8e9b1d87c/5C3FEB2E/t51.2885-15/e35/c60.0.959.959/s150x150/32721285_190952904890503_7012389595190919168_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:284,%22url%22:%22https://scontent.cdninstagram.com/vp/e43e1f90c999e0c1a93a24c27bb008e4/5C1D6465/t51.2885-15/e35/s320x320/32721285_190952904890503_7012389595190919168_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:568,%22url%22:%22https://scontent.cdninstagram.com/vp/c746c7375539a4c2bbc7deb25a63a909/5C1D4A32/t51.2885-15/sh0.08/e35/s640x640/32721285_190952904890503_7012389595190919168_n.jpg%22%7D%7D,%22created_time%22:%221527493478%22,%22caption%22:%7B%22id%22:%2217874016525243262%22,%22text%22:%22Scenic%20European%20Trail%5CnItaly,%20Austria,%20Germany,%20Switzerland,%20France%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221527493478%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:9%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BjUC1iEhB2Y/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221777243605053157517_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/9b3568f7fb042cebed0a30322d7b73e8/5C213981/t51.2885-15/e35/c212.0.655.655/s150x150/31970480_195048384470204_5566909645823410176_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:194,%22url%22:%22https://scontent.cdninstagram.com/vp/036811ae1caeceaae0ccab3d1f6e8030/5C27EAA2/t51.2885-15/e35/s320x320/31970480_195048384470204_5566909645823410176_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:388,%22url%22:%22https://scontent.cdninstagram.com/vp/f5a3261d09a83b939addb616bb1bb5a8/5C2B69F5/t51.2885-15/sh0.08/e35/s640x640/31970480_195048384470204_5566909645823410176_n.jpg%22%7D%7D,%22created_time%22:%221526083969%22,%22caption%22:%7B%22id%22:%2217930629732115620%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221526083969%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:14%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BiqCaR-hzCN/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221777243418297576193_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/41753f886e68414629a2afe4560bf28d/5C3D44D1/t51.2885-15/e35/s150x150/31879091_167914007216987_6074394065166663680_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/42faeab9703e4b9eebf0d1c053317b51/5C282621/t51.2885-15/e35/s320x320/31879091_167914007216987_6074394065166663680_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/b07dbce1f0ee6d5b556b75ef01d1023e/5C2D5076/t51.2885-15/sh0.08/e35/s640x640/31879091_167914007216987_6074394065166663680_n.jpg%22%7D%7D,%22created_time%22:%221526083946%22,%22caption%22:%7B%22id%22:%2217940327034067683%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221526083946%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:7%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:1%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BiqCXkDBysB/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221777243289893143972_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/e937fdd378a4634563c42c3188b5ad00/5C3E6C5D/t51.2885-15/e35/s150x150/31709144_169322203753978_1648943300482170880_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/287057662fccadd39c8092669d369650/5C2DECAD/t51.2885-15/e35/s320x320/31709144_169322203753978_1648943300482170880_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/a6ad735602b5db7969fc29b51fa60211/5C3006FA/t51.2885-15/sh0.08/e35/s640x640/31709144_169322203753978_1648943300482170880_n.jpg%22%7D%7D,%22created_time%22:%221526083931%22,%22caption%22:%7B%22id%22:%2217914602586162335%22,%22text%22:%22For%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221526083931%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:5%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BiqCVsdhwWk/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221773311323871318607_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/8b66c8677919d85ac0ca130202eb32b6/5C5F7AC7/t51.2885-15/e35/s150x150/30867885_848339418701179_4374873620648820736_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/ef4099749200fcb0006b78928dfa3de4/5C2E3937/t51.2885-15/e35/s320x320/30867885_848339418701179_4374873620648820736_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/229dd57810a8c44ccef77b79dc041e64/5C32F260/t51.2885-15/sh0.08/e35/s640x640/30867885_848339418701179_4374873620648820736_n.jpg%22%7D%7D,%22created_time%22:%221525615204%22,%22caption%22:%7B%22id%22:%2217844149008263576%22,%22text%22:%22Summer%20in%20Korea%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221525615204%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:5%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BicEUDvhxJP/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D,%7B%22id%22:%221773311086800678962_973906762%22,%22user%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D,%22images%22:%7B%22thumbnail%22:%7B%22width%22:150,%22height%22:150,%22url%22:%22https://scontent.cdninstagram.com/vp/fc1c6e054ae23b8dd7218bbdc64eaeaa/5C5BE9AC/t51.2885-15/e35/s150x150/30905347_432067190577245_590161019372830720_n.jpg%22%7D,%22low_resolution%22:%7B%22width%22:320,%22height%22:320,%22url%22:%22https://scontent.cdninstagram.com/vp/a4066169915a0c0e904a370187f3308d/5C4211A1/t51.2885-15/e35/s320x320/30905347_432067190577245_590161019372830720_n.jpg%22%7D,%22standard_resolution%22:%7B%22width%22:640,%22height%22:640,%22url%22:%22https://scontent.cdninstagram.com/vp/503227bec9b5df56789aba19efa21622/5C5DE54D/t51.2885-15/sh0.08/e35/s640x640/30905347_432067190577245_590161019372830720_n.jpg%22%7D%7D,%22created_time%22:%221525615176%22,%22caption%22:%7B%22id%22:%2217884456084207501%22,%22text%22:%22Fall%20for%20Korea%5Cn%5CnFor%20more%20details;%5CnMANILA%20(02)%206338434%20/%206338423%5CnCEBU%20(032)%202553264%20/%202536080%5CnDAVAO%20(082)%203050146%20/%203306372%5CnWebsite:%20www.travelite.com.ph%22,%22created_time%22:%221525615176%22,%22from%22:%7B%22id%22:%22973906762%22,%22full_name%22:%22TRAVELITE%20TRAVEL%20&%20TOURS%20CO%22,%22profile_picture%22:%22https://scontent.cdninstagram.com/vp/1053dddce75b4a5b75ad57a4743c0851/5C428829/t51.2885-19/10534980_684751634912422_2104182813_a.jpg%22,%22username%22:%22travelite_ph%22%7D%7D,%22user_has_liked%22:false,%22likes%22:%7B%22count%22:10%7D,%22tags%22:%5B%5D,%22filter%22:%22Normal%22,%22comments%22:%7B%22count%22:0%7D,%22type%22:%22image%22,%22link%22:%22https://www.instagram.com/p/BicEQm9BDAy/%22,%22location%22:null,%22attribution%22:null,%22users_in_photo%22:%5B%5D%7D%5D,%22meta%22:%7B%22code%22:200%7D%7D", "no");
INSERT INTO `trvlite_options` VALUES("203557", "_site_transient_timeout_browser_c91c259fd5f3fa8303f885fec872baad", "1538210215", "no");
INSERT INTO `trvlite_options` VALUES("203558", "_site_transient_browser_c91c259fd5f3fa8303f885fec872baad", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"69.0.3497.100\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `trvlite_options` VALUES("203561", "_site_transient_timeout_community-events-a74473d72a7550ec1b08d74163390a2c", "1537648633", "no");
INSERT INTO `trvlite_options` VALUES("203562", "_site_transient_community-events-a74473d72a7550ec1b08d74163390a2c", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"49.145.133.0\";}s:6:\"events\";a:1:{i:0;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:36:\"#WordPressWeekend - September Meetup\";s:3:\"url\";s:47:\"https://www.meetup.com/wpcebu/events/254165337/\";s:6:\"meetup\";s:21:\"Cebu WordPress Meetup\";s:10:\"meetup_url\";s:30:\"https://www.meetup.com/wpcebu/\";s:4:\"date\";s:19:\"2018-09-22 13:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:17:\"Cebu, Philippines\";s:7:\"country\";s:2:\"ph\";s:8:\"latitude\";d:10.3282450000000007861444828449748456478118896484375;s:9:\"longitude\";d:123.906419999999997116901795379817485809326171875;}}}}", "no");
INSERT INTO `trvlite_options` VALUES("203587", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1537608781;s:7:\"checked\";a:23:{s:19:\"akismet/akismet.php\";s:5:\"4.0.8\";s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:5:\"4.3.6\";s:51:\"arrow-twitter-feed/twitter-feed-by-arrowplugins.php\";s:5:\"1.4.2\";s:47:\"bop-search-box-item-type-for-nav-menus/init.php\";s:5:\"1.6.0\";s:59:\"change-default-login-logo-url-and-title/change-logo-url.php\";s:3:\"2.0\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.0.4\";s:27:\"convertplug/convertplug.php\";s:5:\"2.3.1\";s:33:\"duplicate-post/duplicate-post.php\";s:5:\"3.2.2\";s:25:\"duplicator/duplicator.php\";s:6:\"1.2.46\";s:59:\"editor-menu-and-widget-access/editor-menu-widget-access.php\";s:5:\"3.0.1\";s:31:\"fb-messenger-livechat/fbmsg.php\";s:3:\"1.3\";s:33:\"instagram-feed/instagram-feed.php\";s:6:\"1.10.1\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:5:\"4.2.5\";s:29:\"copy-menu/menu-duplicator.php\";s:3:\"1.0\";s:33:\"search-exclude/search-exclude.php\";s:5:\"1.2.2\";s:23:\"revslider/revslider.php\";s:7:\"5.3.1.5\";s:29:\"dt-the7-core/dt-the7-core.php\";s:5:\"1.1.4\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:6:\"3.16.7\";s:35:\"ultimate-member/ultimate-member.php\";s:6:\"2.0.25\";s:51:\"visual-form-builder-pro/visual-form-builder-pro.php\";s:5:\"2.5.1\";s:23:\"wordfence/wordfence.php\";s:6:\"7.1.12\";s:27:\"js_composer/js_composer.php\";s:5:\"5.0.1\";s:21:\"like-box/like-box.php\";s:6:\"0.7.82\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:17:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.0.8\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.0.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}}s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:49:\"w.org/plugins/all-in-one-wp-security-and-firewall\";s:4:\"slug\";s:35:\"all-in-one-wp-security-and-firewall\";s:6:\"plugin\";s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:11:\"new_version\";s:5:\"4.3.6\";s:3:\"url\";s:66:\"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/plugin/all-in-one-wp-security-and-firewall.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:88:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-128x128.png?rev=1232826\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:91:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-1544x500.png?rev=1914011\";s:2:\"1x\";s:90:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-772x250.png?rev=1914013\";}s:11:\"banners_rtl\";a:0:{}}s:51:\"arrow-twitter-feed/twitter-feed-by-arrowplugins.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:32:\"w.org/plugins/arrow-twitter-feed\";s:4:\"slug\";s:18:\"arrow-twitter-feed\";s:6:\"plugin\";s:51:\"arrow-twitter-feed/twitter-feed-by-arrowplugins.php\";s:11:\"new_version\";s:5:\"1.4.2\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/arrow-twitter-feed/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/arrow-twitter-feed.1.4.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/arrow-twitter-feed/assets/icon-256x256.png?rev=1565127\";s:2:\"1x\";s:71:\"https://ps.w.org/arrow-twitter-feed/assets/icon-256x256.png?rev=1565127\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:73:\"https://ps.w.org/arrow-twitter-feed/assets/banner-772x250.png?rev=1565127\";}s:11:\"banners_rtl\";a:0:{}}s:47:\"bop-search-box-item-type-for-nav-menus/init.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:52:\"w.org/plugins/bop-search-box-item-type-for-nav-menus\";s:4:\"slug\";s:38:\"bop-search-box-item-type-for-nav-menus\";s:6:\"plugin\";s:47:\"bop-search-box-item-type-for-nav-menus/init.php\";s:11:\"new_version\";s:5:\"1.6.0\";s:3:\"url\";s:69:\"https://wordpress.org/plugins/bop-search-box-item-type-for-nav-menus/\";s:7:\"package\";s:87:\"https://downloads.wordpress.org/plugin/bop-search-box-item-type-for-nav-menus.1.6.0.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:91:\"https://ps.w.org/bop-search-box-item-type-for-nav-menus/assets/icon-128x128.png?rev=1067133\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:93:\"https://ps.w.org/bop-search-box-item-type-for-nav-menus/assets/banner-772x250.png?rev=1067133\";}s:11:\"banners_rtl\";a:0:{}}s:59:\"change-default-login-logo-url-and-title/change-logo-url.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:53:\"w.org/plugins/change-default-login-logo-url-and-title\";s:4:\"slug\";s:39:\"change-default-login-logo-url-and-title\";s:6:\"plugin\";s:59:\"change-default-login-logo-url-and-title/change-logo-url.php\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:70:\"https://wordpress.org/plugins/change-default-login-logo-url-and-title/\";s:7:\"package\";s:82:\"https://downloads.wordpress.org/plugin/change-default-login-logo-url-and-title.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:92:\"https://ps.w.org/change-default-login-logo-url-and-title/assets/icon-128x128.png?rev=1396141\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:94:\"https://ps.w.org/change-default-login-logo-url-and-title/assets/banner-772x250.png?rev=1323741\";}s:11:\"banners_rtl\";a:0:{}}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.0.4\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.0.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=984007\";s:2:\"1x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-128x128.png?rev=984007\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"duplicate-post/duplicate-post.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-post\";s:4:\"slug\";s:14:\"duplicate-post\";s:6:\"plugin\";s:33:\"duplicate-post/duplicate-post.php\";s:11:\"new_version\";s:5:\"3.2.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-post/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/duplicate-post.3.2.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-256x256.png?rev=1612753\";s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-post/assets/icon-128x128.png?rev=1612753\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-post/assets/banner-772x250.png?rev=1612986\";}s:11:\"banners_rtl\";a:0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.2.46\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.2.46.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=1298463\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055\";}s:11:\"banners_rtl\";a:0:{}}s:59:\"editor-menu-and-widget-access/editor-menu-widget-access.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:43:\"w.org/plugins/editor-menu-and-widget-access\";s:4:\"slug\";s:29:\"editor-menu-and-widget-access\";s:6:\"plugin\";s:59:\"editor-menu-and-widget-access/editor-menu-widget-access.php\";s:11:\"new_version\";s:5:\"3.0.1\";s:3:\"url\";s:60:\"https://wordpress.org/plugins/editor-menu-and-widget-access/\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/plugin/editor-menu-and-widget-access.3.0.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:82:\"https://ps.w.org/editor-menu-and-widget-access/assets/icon-256x256.png?rev=1200053\";s:2:\"1x\";s:82:\"https://ps.w.org/editor-menu-and-widget-access/assets/icon-128x128.png?rev=1200053\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:85:\"https://ps.w.org/editor-menu-and-widget-access/assets/banner-1544x500.png?rev=1448474\";s:2:\"1x\";s:84:\"https://ps.w.org/editor-menu-and-widget-access/assets/banner-772x250.png?rev=1448474\";}s:11:\"banners_rtl\";a:0:{}}s:31:\"fb-messenger-livechat/fbmsg.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:35:\"w.org/plugins/fb-messenger-livechat\";s:4:\"slug\";s:21:\"fb-messenger-livechat\";s:6:\"plugin\";s:31:\"fb-messenger-livechat/fbmsg.php\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/fb-messenger-livechat/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/fb-messenger-livechat.1.3.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:74:\"https://ps.w.org/fb-messenger-livechat/assets/icon-128x128.png?rev=1478245\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:76:\"https://ps.w.org/fb-messenger-livechat/assets/banner-772x250.png?rev=1478245\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"instagram-feed/instagram-feed.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/instagram-feed\";s:4:\"slug\";s:14:\"instagram-feed\";s:6:\"plugin\";s:33:\"instagram-feed/instagram-feed.php\";s:11:\"new_version\";s:6:\"1.10.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/instagram-feed/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/instagram-feed.1.10.1.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/instagram-feed/assets/icon-128x128.png?rev=991410\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/instagram-feed/assets/banner-772x250.png?rev=1805441\";}s:11:\"banners_rtl\";a:0:{}}s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:30:\"w.org/plugins/mailchimp-for-wp\";s:4:\"slug\";s:16:\"mailchimp-for-wp\";s:6:\"plugin\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:11:\"new_version\";s:5:\"4.2.5\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/mailchimp-for-wp/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/mailchimp-for-wp.4.2.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/mailchimp-for-wp/assets/icon-256x256.png?rev=1224577\";s:2:\"1x\";s:69:\"https://ps.w.org/mailchimp-for-wp/assets/icon-128x128.png?rev=1224577\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/mailchimp-for-wp/assets/banner-772x250.png?rev=1184706\";}s:11:\"banners_rtl\";a:0:{}}s:29:\"copy-menu/menu-duplicator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:23:\"w.org/plugins/copy-menu\";s:4:\"slug\";s:9:\"copy-menu\";s:6:\"plugin\";s:29:\"copy-menu/menu-duplicator.php\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/copy-menu/\";s:7:\"package\";s:52:\"https://downloads.wordpress.org/plugin/copy-menu.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:53:\"https://s.w.org/plugins/geopattern-icon/copy-menu.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}}s:33:\"search-exclude/search-exclude.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/search-exclude\";s:4:\"slug\";s:14:\"search-exclude\";s:6:\"plugin\";s:33:\"search-exclude/search-exclude.php\";s:11:\"new_version\";s:5:\"1.2.2\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/search-exclude/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/search-exclude.1.2.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/search-exclude/assets/icon-256x256.png?rev=1385618\";s:2:\"1x\";s:67:\"https://ps.w.org/search-exclude/assets/icon-128x128.png?rev=1385618\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/search-exclude/assets/banner-1544x500.jpg?rev=1084914\";s:2:\"1x\";s:69:\"https://ps.w.org/search-exclude/assets/banner-772x250.jpg?rev=1084914\";}s:11:\"banners_rtl\";a:0:{}}s:35:\"ultimate-member/ultimate-member.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:29:\"w.org/plugins/ultimate-member\";s:4:\"slug\";s:15:\"ultimate-member\";s:6:\"plugin\";s:35:\"ultimate-member/ultimate-member.php\";s:11:\"new_version\";s:6:\"2.0.25\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/ultimate-member/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/ultimate-member.2.0.25.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/ultimate-member/assets/icon-256x256.png?rev=1667029\";s:2:\"1x\";s:68:\"https://ps.w.org/ultimate-member/assets/icon-128x128.png?rev=1667029\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/ultimate-member/assets/banner-1544x500.png?rev=1667029\";s:2:\"1x\";s:70:\"https://ps.w.org/ultimate-member/assets/banner-772x250.png?rev=1667029\";}s:11:\"banners_rtl\";a:0:{}}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:6:\"7.1.12\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wordfence.7.1.12.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/wordfence/assets/icon-256x256.png?rev=1457724\";s:2:\"1x\";s:62:\"https://ps.w.org/wordfence/assets/icon-128x128.png?rev=1457724\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.png?rev=1808795\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.png?rev=1808795\";}s:11:\"banners_rtl\";a:0:{}}s:21:\"like-box/like-box.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:22:\"w.org/plugins/like-box\";s:4:\"slug\";s:8:\"like-box\";s:6:\"plugin\";s:21:\"like-box/like-box.php\";s:11:\"new_version\";s:6:\"0.7.82\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/like-box/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/like-box.0.7.82.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/like-box/assets/icon-128x128.png?rev=1843701\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:63:\"https://ps.w.org/like-box/assets/banner-772x250.jpg?rev=1222153\";}s:11:\"banners_rtl\";a:0:{}}}}", "no");
INSERT INTO `trvlite_options` VALUES("203338", "rs-templates", "a:2:{s:6:\"slider\";a:232:{i:0;a:20:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:310:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:20:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:20:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:20:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:439:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:20:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:20:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:20:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:20:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:20:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:20:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:20:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:440:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:20:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:20:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:20:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:20:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:20:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:20:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:20:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:447:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:20:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:20:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:20:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:20:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:20:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:20:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:20:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:346:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:20:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:310:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:20:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:20:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:438:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:20:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:436:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:20:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:20:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:20:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:20:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:20:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:617:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:20:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:438:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:20:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:630:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:20:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:508:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:20:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:20:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:20:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:518:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:20:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:449:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:20:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:20:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:323:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:20:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:316:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:20:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:326:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:20:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:443:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:20:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:308:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:20:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:444:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:20:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:444:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/revslider-doc/special-content-sources/\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:20:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:20:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:397:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:20:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:691:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:20:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:693:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:20:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:532:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:20:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:543:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/revslider-doc/second-steps/#staticlayers\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:20:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:661:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:20:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:508:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://www.themepunch.com/faq/custom-css-or-javascript-for-version-5-0/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:20:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:461:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/watch?v=I4qGepR4aWw\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://www.themepunch.com/revslider-doc/slider-revolution-documentation/\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:20:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18